/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-01-23 09:26:10 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_cptemplates` (
  `template_id` bigint(20) NOT NULL,
  `request` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `priority` smallint(2) unsigned NOT NULL,
  `conditions` mediumblob NOT NULL,
  KEY `template_id` (`template_id`),
  KEY `request` (`request`),
  KEY `priority` (`priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dhvc_form_entry_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) unsigned NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `form_url` varchar(512) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `referer` varchar(512) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `entry_data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `readed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `submitted` datetime NOT NULL,
  `ip_address` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dhvc_form_entry_note` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=8949 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1179 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=335 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pp_activity_logs` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `ip` varchar(55) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `browser` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` varchar(55) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1910 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text COLLATE utf8mb4_unicode_520_ci,
  `last_name` text COLLATE utf8mb4_unicode_520_ci,
  `company` text COLLATE utf8mb4_unicode_520_ci,
  `address_1` text COLLATE utf8mb4_unicode_520_ci,
  `address_2` text COLLATE utf8mb4_unicode_520_ci,
  `city` text COLLATE utf8mb4_unicode_520_ci,
  `state` text COLLATE utf8mb4_unicode_520_ci,
  `postcode` text COLLATE utf8mb4_unicode_520_ci,
  `country` text COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `global_unique_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("44", "action_scheduler/migration_hook", "complete", "2024-11-22 17:43:17", "2024-11-22 17:43:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732297397;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732297397;}", "1", "1", "2024-11-22 17:43:18", "2024-11-22 17:43:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("45", "woocommerce_cleanup_draft_orders", "complete", "2024-11-22 17:42:18", "2024-11-22 17:42:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732297338;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732297338;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-11-22 17:42:20", "2024-11-22 17:42:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("46", "woocommerce_cleanup_draft_orders", "complete", "2024-11-23 17:42:20", "2024-11-23 17:42:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732383740;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732383740;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-11-25 00:01:01", "2024-11-25 00:01:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("47", "woocommerce_cleanup_draft_orders", "complete", "2024-11-26 00:01:01", "2024-11-26 00:01:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732579261;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732579261;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-11-26 06:02:35", "2024-11-26 06:02:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("48", "woocommerce_cleanup_draft_orders", "complete", "2024-11-27 06:02:35", "2024-11-27 06:02:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732687355;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732687355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-11-27 10:05:52", "2024-11-27 10:05:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("49", "woocommerce_cleanup_draft_orders", "complete", "2024-11-28 10:05:52", "2024-11-28 10:05:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732788352;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732788352;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-11-28 10:59:44", "2024-11-28 10:59:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("50", "woocommerce_cleanup_draft_orders", "complete", "2024-11-29 10:59:44", "2024-11-29 10:59:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732877984;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732877984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-11-29 19:16:44", "2024-11-29 19:16:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("51", "woocommerce_cleanup_draft_orders", "complete", "2024-11-30 19:16:44", "2024-11-30 19:16:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732994204;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732994204;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-12-01 12:22:32", "2024-12-01 12:22:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("52", "woocommerce_cleanup_draft_orders", "complete", "2024-12-02 12:22:32", "2024-12-02 12:22:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733142152;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733142152;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-12-02 21:58:58", "2024-12-02 21:58:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("53", "woocommerce_cleanup_draft_orders", "complete", "2024-12-03 21:58:58", "2024-12-03 21:58:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733263138;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733263138;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-12-03 22:29:44", "2024-12-03 22:29:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("54", "woocommerce_cleanup_draft_orders", "complete", "2024-12-04 22:29:44", "2024-12-04 22:29:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733351384;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733351384;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-12-05 09:09:39", "2024-12-05 09:09:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("55", "woocommerce_cleanup_draft_orders", "complete", "2024-12-06 09:09:39", "2024-12-06 09:09:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733476179;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733476179;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-12-06 11:53:30", "2024-12-06 11:53:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("56", "woocommerce_cleanup_draft_orders", "complete", "2024-12-07 11:53:30", "2024-12-07 11:53:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733572410;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733572410;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-12-07 13:54:09", "2024-12-07 13:54:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("57", "woocommerce_cleanup_draft_orders", "complete", "2024-12-08 13:54:09", "2024-12-08 13:54:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733666049;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733666049;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-12-08 19:15:27", "2024-12-08 19:15:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("58", "woocommerce_cleanup_draft_orders", "complete", "2024-12-09 19:15:27", "2024-12-09 19:15:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733771727;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733771727;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-12-09 19:50:43", "2024-12-09 19:50:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("59", "woocommerce_cleanup_draft_orders", "complete", "2024-12-10 19:50:43", "2024-12-10 19:50:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733860243;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733860243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-12-10 20:25:08", "2024-12-10 20:25:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("60", "fetch_patterns", "complete", "2024-12-10 17:11:02", "2024-12-10 17:11:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1733850662;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1733850662;}", "2", "1", "2024-12-10 17:11:42", "2024-12-10 17:11:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("61", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2024-12-10 17:11:41", "2024-12-10 17:11:41", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1733850701;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1733850701;}", "3", "1", "2024-12-10 17:11:43", "2024-12-10 17:11:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("62", "woocommerce_cleanup_draft_orders", "pending", "2024-12-11 20:25:08", "2024-12-11 20:25:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733948708;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733948708;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("63", "action_scheduler/migration_hook", "pending", "2024-12-10 20:27:41", "2024-12-10 20:27:41", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1733862461;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1733862461;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-remote-inbox-engine");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("1", "44", "acção criada", "2024-11-22 17:42:17", "2024-11-22 17:42:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2", "45", "acção criada", "2024-11-22 17:42:18", "2024-11-22 17:42:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3", "45", "action started via WP Cron", "2024-11-22 17:42:20", "2024-11-22 17:42:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("4", "45", "acção concluída via WP Cron", "2024-11-22 17:42:20", "2024-11-22 17:42:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("5", "46", "acção criada", "2024-11-22 17:42:20", "2024-11-22 17:42:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("6", "44", "action started via Async Request", "2024-11-22 17:43:18", "2024-11-22 17:43:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7", "44", "acção concluída via Async Request", "2024-11-22 17:43:18", "2024-11-22 17:43:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("8", "46", "action started via WP Cron", "2024-11-25 00:01:01", "2024-11-25 00:01:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("9", "46", "acção concluída via WP Cron", "2024-11-25 00:01:01", "2024-11-25 00:01:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("10", "47", "acção criada", "2024-11-25 00:01:01", "2024-11-25 00:01:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("11", "47", "action started via WP Cron", "2024-11-26 06:02:35", "2024-11-26 06:02:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("12", "47", "acção concluída via WP Cron", "2024-11-26 06:02:35", "2024-11-26 06:02:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("13", "48", "acção criada", "2024-11-26 06:02:35", "2024-11-26 06:02:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("14", "48", "action started via WP Cron", "2024-11-27 10:05:52", "2024-11-27 10:05:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("15", "48", "acção concluída via WP Cron", "2024-11-27 10:05:52", "2024-11-27 10:05:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("16", "49", "acção criada", "2024-11-27 10:05:52", "2024-11-27 10:05:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("17", "49", "action started via WP Cron", "2024-11-28 10:59:44", "2024-11-28 10:59:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("18", "49", "acção concluída via WP Cron", "2024-11-28 10:59:44", "2024-11-28 10:59:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("19", "50", "acção criada", "2024-11-28 10:59:44", "2024-11-28 10:59:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("20", "50", "action started via WP Cron", "2024-11-29 19:16:44", "2024-11-29 19:16:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("21", "50", "acção concluída via WP Cron", "2024-11-29 19:16:44", "2024-11-29 19:16:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("22", "51", "acção criada", "2024-11-29 19:16:44", "2024-11-29 19:16:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("23", "51", "action started via WP Cron", "2024-12-01 12:22:32", "2024-12-01 12:22:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("24", "51", "acção concluída via WP Cron", "2024-12-01 12:22:32", "2024-12-01 12:22:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("25", "52", "acção criada", "2024-12-01 12:22:32", "2024-12-01 12:22:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("26", "52", "action started via WP Cron", "2024-12-02 21:58:58", "2024-12-02 21:58:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("27", "52", "acção concluída via WP Cron", "2024-12-02 21:58:58", "2024-12-02 21:58:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("28", "53", "acção criada", "2024-12-02 21:58:58", "2024-12-02 21:58:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("29", "53", "action started via WP Cron", "2024-12-03 22:29:44", "2024-12-03 22:29:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("30", "53", "acção concluída via WP Cron", "2024-12-03 22:29:44", "2024-12-03 22:29:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("31", "54", "acção criada", "2024-12-03 22:29:44", "2024-12-03 22:29:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("32", "54", "action started via WP Cron", "2024-12-05 09:09:39", "2024-12-05 09:09:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("33", "54", "acção concluída via WP Cron", "2024-12-05 09:09:39", "2024-12-05 09:09:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("34", "55", "acção criada", "2024-12-05 09:09:39", "2024-12-05 09:09:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("35", "55", "action started via WP Cron", "2024-12-06 11:53:30", "2024-12-06 11:53:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("36", "55", "acção concluída via WP Cron", "2024-12-06 11:53:30", "2024-12-06 11:53:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("37", "56", "acção criada", "2024-12-06 11:53:30", "2024-12-06 11:53:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("38", "56", "action started via WP Cron", "2024-12-07 13:54:09", "2024-12-07 13:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("39", "56", "acção concluída via WP Cron", "2024-12-07 13:54:09", "2024-12-07 13:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("40", "57", "acção criada", "2024-12-07 13:54:09", "2024-12-07 13:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("41", "57", "action started via WP Cron", "2024-12-08 19:15:27", "2024-12-08 19:15:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("42", "57", "acção concluída via WP Cron", "2024-12-08 19:15:27", "2024-12-08 19:15:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("43", "58", "acção criada", "2024-12-08 19:15:27", "2024-12-08 19:15:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("44", "58", "action started via WP Cron", "2024-12-09 19:50:43", "2024-12-09 19:50:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("45", "58", "acção concluída via WP Cron", "2024-12-09 19:50:43", "2024-12-09 19:50:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("46", "59", "acção criada", "2024-12-09 19:50:43", "2024-12-09 19:50:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("47", "60", "acção criada", "2024-12-10 17:11:02", "2024-12-10 17:11:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("48", "61", "acção criada", "2024-12-10 17:11:41", "2024-12-10 17:11:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("49", "60", "action started via WP Cron", "2024-12-10 17:11:42", "2024-12-10 17:11:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("50", "60", "acção concluída via WP Cron", "2024-12-10 17:11:42", "2024-12-10 17:11:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("51", "61", "action started via WP Cron", "2024-12-10 17:11:42", "2024-12-10 17:11:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("52", "61", "acção concluída via WP Cron", "2024-12-10 17:11:43", "2024-12-10 17:11:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("53", "59", "action started via WP Cron", "2024-12-10 20:25:08", "2024-12-10 20:25:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("54", "59", "acção concluída via WP Cron", "2024-12-10 20:25:08", "2024-12-10 20:25:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("55", "62", "acção criada", "2024-12-10 20:25:08", "2024-12-10 20:25:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("56", "63", "acção criada", "2024-12-10 20:26:41", "2024-12-10 20:26:41");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20230214_midtemplate", "c40edbb8bb5e7b181763_20250123092603", "22", "2025-01-23 09:26:10", "miduswer4", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-01-23 09:26:03\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"5.7.44\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:20:\"20230214_midtemplate\";s:4:\"Hash\";s:35:\"c40edbb8bb5e7b181763_20250123092603\";s:8:\"NameHash\";s:56:\"20230214_midtemplate_c40edbb8bb5e7b181763_20250123092603\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:66:\"20230214_midtemplate_c40edbb8bb5e7b181763_20250123092603_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.8\";s:6:\"WPUser\";s:9:\"miduswer4\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20230214_midtemplate_c40edbb8bb5e7b181763_20250123092603_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/home/wwwumdom/public_html/batazu\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1774;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:12319;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-01-23 09:26:03\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"5.7.44\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20230214_midtemplate\";s:4:\"Hash\";s:35:\"c40edbb8bb5e7b181763_20250123092603\";s:8:\"NameHash\";s:56:\"20230214_midtemplate_c40edbb8bb5e7b181763_20250123092603\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:74:\"20230214_midtemplate_c40edbb8bb5e7b181763_20250123092603_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:47:\"/home/wwwumdom/public_html/batazu/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:69:\"20230214_midtemplate_c40edbb8bb5e7b181763_20250123092603_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:135:\"/home/wwwumdom/public_html/batazu/wp-content/backups-dup-lite/tmp/20230214_midtemplate_c40edbb8bb5e7b181763_20250123092603_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:42:\"/home/wwwumdom/public_html/batazu/wp-admin\";i:1;s:45:\"/home/wwwumdom/public_html/batazu/wp-includes\";i:2;s:54:\"/home/wwwumdom/public_html/batazu/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:33:\"/home/wwwumdom/public_html/batazu\";i:1;s:33:\"/home/wwwumdom/public_html/batazu\";i:2;s:44:\"/home/wwwumdom/public_html/batazu/wp-content\";i:3;s:52:\"/home/wwwumdom/public_html/batazu/wp-content/uploads\";i:4;s:52:\"/home/wwwumdom/public_html/batazu/wp-content/plugins\";i:5;s:55:\"/home/wwwumdom/public_html/batazu/wp-content/mu-plugins\";i:6;s:51:\"/home/wwwumdom/public_html/batazu/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:65:\"/home/wwwumdom/public_html/batazu/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://batazu.digitalpath.pt", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://batazu.digitalpath.pt", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "Família BataZu", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Juntos, podemos vencer!", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "it@makeitdigital.pt", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "32", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j \\d\\e F, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "G:i", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "j F, Y G:i", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:9:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:23:\"dhvc-form/dhvc-form.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:35:\"insert-headers-and-footers/ihaf.php\";i:5;s:27:\"js_composer/js_composer.php\";i:6;s:23:\"loco-translate/loco.php\";i:7;s:41:\"password-protected/password-protected.php\";i:8;s:19:\"us-core/us-core.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "Impreza", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "makeitdigital", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "58975", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "0", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "36", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "55", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1741426989", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:160:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:13:\"edit_dhvcform\";b:1;s:13:\"read_dhvcform\";b:1;s:15:\"delete_dhvcform\";b:1;s:14:\"edit_dhvcforms\";b:1;s:21:\"edit_others_dhvcforms\";b:1;s:17:\"publish_dhvcforms\";b:1;s:22:\"read_private_dhvcforms\";b:1;s:16:\"delete_dhvcforms\";b:1;s:24:\"delete_private_dhvcforms\";b:1;s:26:\"delete_published_dhvcforms\";b:1;s:23:\"delete_others_dhvcforms\";b:1;s:22:\"edit_private_dhvcforms\";b:1;s:24:\"edit_published_dhvcforms\";b:1;s:9:\"edit_post\";b:1;s:9:\"read_post\";b:1;s:11:\"delete_post\";b:1;s:18:\"edit_us_page_block\";b:1;s:18:\"read_us_page_block\";b:1;s:20:\"delete_us_page_block\";b:1;s:19:\"edit_us_page_blocks\";b:1;s:26:\"edit_others_us_page_blocks\";b:1;s:21:\"delete_us_page_blocks\";b:1;s:22:\"publish_us_page_blocks\";b:1;s:27:\"read_private_us_page_blocks\";b:1;s:29:\"delete_private_us_page_blocks\";b:1;s:31:\"delete_published_us_page_blocks\";b:1;s:28:\"delete_others_us_page_blocks\";b:1;s:27:\"edit_private_us_page_blocks\";b:1;s:29:\"edit_published_us_page_blocks\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:37:\"vc_access_rules_post_types/attachment\";b:1;s:39:\"vc_access_rules_post_types/us_portfolio\";b:1;s:41:\"vc_access_rules_post_types/us_testimonial\";b:1;s:46:\"vc_access_rules_post_types/us_content_template\";b:1;s:40:\"vc_access_rules_post_types/us_page_block\";b:1;s:37:\"vc_access_rules_post_types/cptemplate\";b:1;s:37:\"vc_access_rules_post_types/slide_home\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;s:20:\"wpcode_edit_snippets\";b:1;s:24:\"wpcode_activate_snippets\";b:1;s:9:\"edit_page\";b:1;s:9:\"read_page\";b:1;s:11:\"delete_page\";b:1;s:40:\"vc_access_rules_post_types/slide-carross\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:10:\"loco_admin\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:48:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:9:\"edit_post\";b:1;s:9:\"read_post\";b:1;s:11:\"delete_post\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:23:\"vc_access_rules_code_ai\";b:1;s:23:\"vc_access_rules_text_ai\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:21:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:0;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:23:\"vc_access_rules_code_ai\";b:1;s:23:\"vc_access_rules_text_ai\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:16:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:0;s:31:\"vc_access_rules_unfiltered_html\";b:0;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:0;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:23:\"vc_access_rules_code_ai\";b:1;s:23:\"vc_access_rules_text_ai\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:92:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "pt_PT", "yes");
INSERT INTO `wp_options` VALUES("103", "user_count", "1", "no");
INSERT INTO `wp_options` VALUES("104", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:158:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Artigos recentes</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Comentários recentes</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:145:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Arquivo</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categorias</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:15:\"default_sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("106", "cron", "a:20:{i:1737625337;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1737625343;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1737627756;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1737630701;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1737631356;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1737631371;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1737652311;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1737654134;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1737654137;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1737663101;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1737673847;a:1:{s:26:\"wpcode_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1737674556;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1737674571;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1737674572;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1737713642;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1737986400;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1738074005;a:1:{s:27:\"acf_update_site_health_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1738106556;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1738184079;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "nonce_key", "F/3  aNeWH{q0!(,RSdIM}7&-G!BX8x5v%{zNb&!~6F(3S*D??/#=C$Aj15`cQ5]", "no");
INSERT INTO `wp_options` VALUES("117", "nonce_salt", "03>f5oV3P81j#T9G6^sV.sz!r#4B?To.FrGj>_SGu-;P2!vT1uQ- #oyI(|b2Ej,", "no");
INSERT INTO `wp_options` VALUES("118", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("120", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("121", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("122", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("126", "theme_mods_twentytwentythree", "a:4:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1691414151;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:15:\"default_sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}}}s:19:\"wp_classic_sidebars\";a:1:{s:15:\"default_sidebar\";a:11:{s:4:\"name\";s:15:\"Default Sidebar\";s:2:\"id\";s:15:\"default_sidebar\";s:11:\"description\";s:0:\"\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:35:\"<div id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</div>\";s:12:\"before_title\";s:24:\"<h3 class=\"widgettitle\">\";s:11:\"after_title\";s:5:\"</h3>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}}s:18:\"nav_menu_locations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("129", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("130", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("143", "secure_auth_key", "DJVb)e2k=h3Up?<d&yAS5`3$n!R2{tt2%?M=`|E@JJm<BS!kM;/cc4JHrPG+CPRV", "no");
INSERT INTO `wp_options` VALUES("144", "secure_auth_salt", "/]N)m)/*Q`qQ^*k3x9,^^DQL9}-3FuTRsn|CVtSo7Au7|8_vy<%<4RrQ:Q=D#jm`", "no");
INSERT INTO `wp_options` VALUES("145", "logged_in_key", "v^bV9a.VRI-++}plMy{{u[>WgYFXEz%8M.mG87pxt)?tjljU%<hgJPc>;@a$2Sp`", "no");
INSERT INTO `wp_options` VALUES("146", "logged_in_salt", "ItH.!U8+6N=c<mk)/?mh:]+EXvVzxr(m)-&uD8UgAI-a0VvmM2`O&SJh7>r1:AQM", "no");
INSERT INTO `wp_options` VALUES("165", "recently_activated", "a:3:{s:21:\"polylang/polylang.php\";i:1733862418;s:27:\"woocommerce/woocommerce.php\";i:1733862407;s:43:\"advanced-woo-labels/advanced-woo-labels.php\";i:1733862400;}", "off");
INSERT INTO `wp_options` VALUES("175", "password_protected_version", "2.6.0", "yes");
INSERT INTO `wp_options` VALUES("179", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("180", "dhvc_form_db_version", "2.0.0", "yes");
INSERT INTO `wp_options` VALUES("181", "vc_version", "8.0.1", "yes");
INSERT INTO `wp_options` VALUES("182", "acf_version", "6.3.10.2", "yes");
INSERT INTO `wp_options` VALUES("183", "wpb_license_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("184", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `wp_options` VALUES("185", "wpb_js_google_fonts_subsets", "a:1:{i:0;s:5:\"latin\";}", "yes");
INSERT INTO `wp_options` VALUES("186", "wpb_js_gutenberg_disable", "1", "yes");
INSERT INTO `wp_options` VALUES("187", "wpb_js_default_template_post_type", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("190", "current_theme", "Make It Digital", "yes");
INSERT INTO `wp_options` VALUES("191", "theme_mods_Impreza-child", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1681150586;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:15:\"default_sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}}}}", "no");
INSERT INTO `wp_options` VALUES("192", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("193", "usof_options_Impreza", "a:407:{s:16:\"maintenance_mode\";i:0;s:22:\"maintenance_mode_alert\";s:0:\"\";s:16:\"maintenance_page\";s:1:\"3\";s:15:\"maintenance_503\";i:0;s:9:\"site_icon\";s:2:\"55\";s:10:\"dark_theme\";s:4:\"none\";s:9:\"preloader\";s:8:\"disabled\";s:15:\"preloader_image\";s:0:\"\";s:15:\"img_placeholder\";s:94:\"https://midtemplate.makeitdigital2.tk/wp-content/plugins/us-core/assets/images/placeholder.svg\";s:13:\"ripple_effect\";i:0;s:15:\"rounded_corners\";i:0;s:15:\"links_underline\";i:0;s:22:\"keyboard_accessibility\";i:0;s:11:\"back_to_top\";i:1;s:25:\"wrapper_back_to_top_start\";s:0:\"\";s:17:\"back_to_top_style\";s:0:\"\";s:16:\"back_to_top_icon\";s:12:\"far|angle-up\";s:15:\"back_to_top_pos\";s:5:\"right\";s:17:\"back_to_top_color\";s:15:\"rgba(0,0,0,0.3)\";s:19:\"back_to_top_display\";s:5:\"100vh\";s:23:\"wrapper_back_to_top_end\";s:0:\"\";s:22:\"smooth_scroll_duration\";s:6:\"1000ms\";s:13:\"cookie_notice\";i:0;s:20:\"wrapper_cookie_start\";s:0:\"\";s:14:\"cookie_message\";s:106:\"This website uses cookies to improve your experience. If you continue to use this site, you agree with it.\";s:14:\"cookie_privacy\";s:0:\"\";s:18:\"cookie_message_pos\";s:6:\"bottom\";s:16:\"cookie_btn_label\";s:2:\"Ok\";s:16:\"cookie_btn_style\";s:1:\"1\";s:18:\"wrapper_cookie_end\";s:0:\"\";s:23:\"block_third_party_files\";i:0;s:19:\"layout_head_message\";s:0:\"\";s:13:\"canvas_layout\";s:4:\"wide\";s:13:\"color_body_bg\";s:15:\"_content_bg_alt\";s:13:\"body_bg_image\";s:0:\"\";s:21:\"wrapper_body_bg_start\";s:0:\"\";s:18:\"body_bg_image_size\";s:5:\"cover\";s:20:\"body_bg_image_repeat\";s:6:\"repeat\";s:22:\"body_bg_image_position\";s:8:\"top left\";s:24:\"body_bg_image_attachment\";i:1;s:19:\"wrapper_body_bg_end\";s:0:\"\";s:17:\"site_canvas_width\";s:6:\"1300px\";s:18:\"site_content_width\";s:6:\"1140px\";s:13:\"sidebar_width\";s:3:\"25%\";s:10:\"row_height\";s:4:\"auto\";s:17:\"row_height_custom\";s:5:\"5vmax\";s:18:\"text_bottom_indent\";s:4:\"0rem\";s:13:\"footer_reveal\";i:0;s:21:\"disable_effects_width\";s:5:\"900px\";s:22:\"columns_stacking_width\";s:5:\"600px\";s:18:\"laptops_breakpoint\";s:6:\"1380px\";s:18:\"tablets_breakpoint\";s:6:\"1024px\";s:18:\"mobiles_breakpoint\";s:5:\"600px\";s:11:\"search_page\";s:7:\"default\";s:28:\"exclude_post_types_in_search\";s:0:\"\";s:8:\"page_404\";s:7:\"default\";s:10:\"h_defaults\";s:0:\"\";s:9:\"header_id\";s:2:\"12\";s:11:\"titlebar_id\";s:2:\"10\";s:10:\"content_id\";s:0:\"\";s:10:\"sidebar_id\";s:0:\"\";s:11:\"sidebar_pos\";s:5:\"right\";s:9:\"footer_id\";s:2:\"15\";s:6:\"h_post\";s:0:\"\";s:14:\"header_post_id\";s:12:\"__defaults__\";s:16:\"titlebar_post_id\";s:0:\"\";s:15:\"content_post_id\";s:2:\"20\";s:15:\"sidebar_post_id\";s:0:\"\";s:16:\"sidebar_post_pos\";s:5:\"right\";s:14:\"footer_post_id\";s:12:\"__defaults__\";s:10:\"h_parceria\";s:0:\"\";s:18:\"header_parceria_id\";s:12:\"__defaults__\";s:20:\"titlebar_parceria_id\";s:12:\"__defaults__\";s:19:\"content_parceria_id\";s:12:\"__defaults__\";s:19:\"sidebar_parceria_id\";s:12:\"__defaults__\";s:20:\"sidebar_parceria_pos\";s:5:\"right\";s:18:\"footer_parceria_id\";s:12:\"__defaults__\";s:9:\"h_recurso\";s:0:\"\";s:17:\"header_recurso_id\";s:12:\"__defaults__\";s:19:\"titlebar_recurso_id\";s:12:\"__defaults__\";s:18:\"content_recurso_id\";s:12:\"__defaults__\";s:18:\"sidebar_recurso_id\";s:12:\"__defaults__\";s:19:\"sidebar_recurso_pos\";s:5:\"right\";s:17:\"footer_recurso_id\";s:12:\"__defaults__\";s:15:\"h_slide-carross\";s:0:\"\";s:23:\"header_slide-carross_id\";s:12:\"__defaults__\";s:25:\"titlebar_slide-carross_id\";s:12:\"__defaults__\";s:24:\"content_slide-carross_id\";s:12:\"__defaults__\";s:24:\"sidebar_slide-carross_id\";s:12:\"__defaults__\";s:25:\"sidebar_slide-carross_pos\";s:5:\"right\";s:23:\"footer_slide-carross_id\";s:12:\"__defaults__\";s:18:\"h_archive_defaults\";s:0:\"\";s:17:\"header_archive_id\";s:12:\"__defaults__\";s:19:\"titlebar_archive_id\";s:12:\"__defaults__\";s:18:\"content_archive_id\";s:0:\"\";s:18:\"sidebar_archive_id\";s:12:\"__defaults__\";s:19:\"sidebar_archive_pos\";s:5:\"right\";s:17:\"footer_archive_id\";s:12:\"__defaults__\";s:14:\"h_tax_category\";s:0:\"\";s:22:\"header_tax_category_id\";s:12:\"__defaults__\";s:24:\"titlebar_tax_category_id\";s:12:\"__defaults__\";s:23:\"content_tax_category_id\";s:3:\"229\";s:23:\"sidebar_tax_category_id\";s:12:\"__defaults__\";s:24:\"sidebar_tax_category_pos\";s:5:\"right\";s:22:\"footer_tax_category_id\";s:12:\"__defaults__\";s:14:\"h_tax_post_tag\";s:0:\"\";s:22:\"header_tax_post_tag_id\";s:12:\"__defaults__\";s:24:\"titlebar_tax_post_tag_id\";s:12:\"__defaults__\";s:23:\"content_tax_post_tag_id\";s:12:\"__defaults__\";s:23:\"sidebar_tax_post_tag_id\";s:12:\"__defaults__\";s:24:\"sidebar_tax_post_tag_pos\";s:5:\"right\";s:22:\"footer_tax_post_tag_id\";s:12:\"__defaults__\";s:17:\"h_tax_post_format\";s:0:\"\";s:25:\"header_tax_post_format_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_post_format_id\";s:12:\"__defaults__\";s:26:\"content_tax_post_format_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_post_format_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_post_format_pos\";s:5:\"right\";s:25:\"footer_tax_post_format_id\";s:12:\"__defaults__\";s:22:\"h_tax_categoria-pagina\";s:0:\"\";s:30:\"header_tax_categoria-pagina_id\";s:12:\"__defaults__\";s:32:\"titlebar_tax_categoria-pagina_id\";s:12:\"__defaults__\";s:31:\"content_tax_categoria-pagina_id\";s:12:\"__defaults__\";s:31:\"sidebar_tax_categoria-pagina_id\";s:12:\"__defaults__\";s:32:\"sidebar_tax_categoria-pagina_pos\";s:5:\"right\";s:30:\"footer_tax_categoria-pagina_id\";s:12:\"__defaults__\";s:9:\"h_authors\";s:0:\"\";s:16:\"header_author_id\";s:12:\"__defaults__\";s:18:\"titlebar_author_id\";s:12:\"__defaults__\";s:17:\"content_author_id\";s:12:\"__defaults__\";s:17:\"sidebar_author_id\";s:12:\"__defaults__\";s:18:\"sidebar_author_pos\";s:5:\"right\";s:16:\"footer_author_id\";s:12:\"__defaults__\";s:15:\"h_custom_colors\";s:0:\"\";s:13:\"custom_colors\";a:0:{}s:19:\"color_header_top_bg\";s:34:\"linear-gradient(0deg,#f5f5f5,#fff)\";s:21:\"color_header_top_text\";s:7:\"#333333\";s:27:\"color_header_top_text_hover\";s:7:\"#e95095\";s:22:\"color_header_middle_bg\";s:7:\"#ffffff\";s:24:\"color_header_middle_text\";s:7:\"#122440\";s:30:\"color_header_middle_text_hover\";s:7:\"#e95095\";s:29:\"color_header_transparent_text\";s:7:\"#ffffff\";s:35:\"color_header_transparent_text_hover\";s:7:\"#ffffff\";s:20:\"color_chrome_toolbar\";s:7:\"#f5f5f5\";s:16:\"color_content_bg\";s:7:\"#ffffff\";s:20:\"color_content_bg_alt\";s:7:\"#fef5b5\";s:20:\"color_content_border\";s:7:\"#e8e8e8\";s:21:\"color_content_heading\";s:7:\"#3b177c\";s:18:\"color_content_text\";s:7:\"#333333\";s:18:\"color_content_link\";s:7:\"#3b177c\";s:24:\"color_content_link_hover\";s:7:\"#163f72\";s:21:\"color_content_primary\";s:7:\"#42d2d7\";s:23:\"color_content_secondary\";s:7:\"#ef3566\";s:19:\"color_content_faded\";s:7:\"#999999\";s:21:\"color_content_overlay\";s:16:\"rgba(0,0,0,0.75)\";s:20:\"color_alt_content_bg\";s:7:\"#f5f5f5\";s:24:\"color_alt_content_bg_alt\";s:7:\"#fffef5\";s:24:\"color_alt_content_border\";s:7:\"#dddddd\";s:25:\"color_alt_content_heading\";s:7:\"#1a1a1a\";s:22:\"color_alt_content_text\";s:7:\"#333333\";s:22:\"color_alt_content_link\";s:7:\"#e95095\";s:28:\"color_alt_content_link_hover\";s:7:\"#7049ba\";s:25:\"color_alt_content_primary\";s:7:\"#36b1b5\";s:27:\"color_alt_content_secondary\";s:39:\"linear-gradient(135deg,#7049ba,#e95095)\";s:23:\"color_alt_content_faded\";s:7:\"#999999\";s:25:\"color_alt_content_overlay\";s:53:\"linear-gradient(135deg,#e95095,rgba(233,80,149,0.75))\";s:15:\"color_footer_bg\";s:7:\"#222222\";s:19:\"color_footer_bg_alt\";s:7:\"#1a1a1a\";s:19:\"color_footer_border\";s:7:\"#333333\";s:20:\"color_footer_heading\";s:7:\"#cccccc\";s:17:\"color_footer_text\";s:7:\"#999999\";s:17:\"color_footer_link\";s:7:\"#cccccc\";s:23:\"color_footer_link_hover\";s:7:\"#e95095\";s:18:\"color_subfooter_bg\";s:7:\"#1a1a1a\";s:22:\"color_subfooter_bg_alt\";s:7:\"#222222\";s:22:\"color_subfooter_border\";s:7:\"#282828\";s:23:\"color_subfooter_heading\";s:7:\"#cccccc\";s:20:\"color_subfooter_text\";s:7:\"#bbbbbb\";s:20:\"color_subfooter_link\";s:7:\"#ffffff\";s:26:\"color_subfooter_link_hover\";s:7:\"#e95095\";s:12:\"style_scheme\";i:0;s:26:\"change_header_colors_start\";s:0:\"\";s:10:\"h_colors_1\";s:0:\"\";s:27:\"color_header_transparent_bg\";s:11:\"transparent\";s:24:\"change_header_colors_end\";s:0:\"\";s:30:\"change_header_alt_colors_start\";s:0:\"\";s:10:\"h_colors_2\";s:0:\"\";s:31:\"color_header_top_transparent_bg\";s:15:\"rgba(0,0,0,0.2)\";s:33:\"color_header_top_transparent_text\";s:22:\"rgba(255,255,255,0.66)\";s:39:\"color_header_top_transparent_text_hover\";s:7:\"#ffffff\";s:28:\"change_header_alt_colors_end\";s:0:\"\";s:27:\"change_content_colors_start\";s:0:\"\";s:10:\"h_colors_3\";s:0:\"\";s:25:\"change_content_colors_end\";s:0:\"\";s:31:\"change_alt_content_colors_start\";s:0:\"\";s:10:\"h_colors_4\";s:0:\"\";s:29:\"change_alt_content_colors_end\";s:0:\"\";s:26:\"change_footer_colors_start\";s:0:\"\";s:10:\"h_colors_6\";s:0:\"\";s:24:\"change_footer_colors_end\";s:0:\"\";s:29:\"change_subfooter_colors_start\";s:0:\"\";s:10:\"h_colors_5\";s:0:\"\";s:27:\"change_subfooter_colors_end\";s:0:\"\";s:23:\"typography_head_message\";s:0:\"\";s:4:\"body\";a:8:{s:11:\"font-family\";s:6:\"Mulish\";s:9:\"font-size\";s:119:\"%7B%22default%22%3A%2217px%22%2C%22laptops%22%3A%2218px%22%2C%22tablets%22%3A%2218px%22%2C%22mobiles%22%3A%2216px%22%7D\";s:11:\"line-height\";s:4:\"25px\";s:11:\"font-weight\";s:3:\"300\";s:16:\"bold-font-weight\";s:3:\"800\";s:14:\"text-transform\";s:4:\"none\";s:10:\"font-style\";s:6:\"normal\";s:14:\"letter-spacing\";s:3:\"0em\";}s:2:\"h1\";a:11:{s:11:\"font-family\";s:7:\"inherit\";s:9:\"font-size\";s:16:\"max( 4rem, 4vw )\";s:11:\"line-height\";s:3:\"1.2\";s:11:\"font-weight\";s:3:\"400\";s:16:\"bold-font-weight\";s:3:\"700\";s:14:\"text-transform\";s:4:\"none\";s:10:\"font-style\";s:6:\"normal\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"0.6em\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";s:0:\"\";}s:2:\"h2\";a:11:{s:11:\"font-family\";s:21:\"var(--h1-font-family)\";s:9:\"font-size\";s:20:\"max( 2.3rem, 2.3vw )\";s:11:\"line-height\";s:3:\"1.2\";s:11:\"font-weight\";s:3:\"500\";s:16:\"bold-font-weight\";s:3:\"600\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"0.6em\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";s:0:\"\";}s:2:\"h3\";a:11:{s:11:\"font-family\";s:21:\"var(--h1-font-family)\";s:9:\"font-size\";s:20:\"max( 1.7rem, 1.7vw )\";s:11:\"line-height\";s:3:\"1.2\";s:11:\"font-weight\";s:3:\"200\";s:16:\"bold-font-weight\";s:3:\"900\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"0.6em\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";s:0:\"\";}s:2:\"h4\";a:11:{s:11:\"font-family\";s:21:\"var(--h1-font-family)\";s:9:\"font-size\";s:20:\"max( 1.5rem, 1.5vw )\";s:11:\"line-height\";s:3:\"1.2\";s:11:\"font-weight\";s:21:\"var(--h1-font-weight)\";s:16:\"bold-font-weight\";s:26:\"var(--h1-bold-font-weight)\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"0.6em\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";s:0:\"\";}s:2:\"h5\";a:11:{s:11:\"font-family\";s:21:\"var(--h1-font-family)\";s:9:\"font-size\";s:20:\"max( 1.3rem, 1.3vw )\";s:11:\"line-height\";s:3:\"1.2\";s:11:\"font-weight\";s:21:\"var(--h1-font-weight)\";s:16:\"bold-font-weight\";s:26:\"var(--h1-bold-font-weight)\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"0.6em\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";s:0:\"\";}s:2:\"h6\";a:11:{s:11:\"font-family\";s:21:\"var(--h1-font-family)\";s:9:\"font-size\";s:20:\"max( 1.2rem, 1.2vw )\";s:11:\"line-height\";s:3:\"1.2\";s:11:\"font-weight\";s:21:\"var(--h1-font-weight)\";s:16:\"bold-font-weight\";s:26:\"var(--h1-bold-font-weight)\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"0.6em\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";s:0:\"\";}s:14:\"h_typography_3\";s:0:\"\";s:11:\"custom_font\";a:0:{}s:14:\"h_typography_4\";s:0:\"\";s:14:\"uploaded_fonts\";a:0:{}s:14:\"h_typography_5\";s:0:\"\";s:12:\"font_display\";s:4:\"swap\";s:14:\"h_typography_6\";s:0:\"\";s:11:\"adobe_fonts\";s:0:\"\";s:7:\"buttons\";a:7:{i:0;a:32:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:14:\"Default Button\";s:5:\"hover\";s:4:\"fade\";s:5:\"class\";s:0:\"\";s:8:\"color_bg\";s:18:\"_content_secondary\";s:14:\"color_bg_hover\";s:16:\"_content_heading\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:0:\"\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:0:\"\";s:21:\"shadow_hover_offset_h\";s:3:\"0px\";s:21:\"shadow_hover_offset_v\";s:3:\"0px\";s:17:\"shadow_hover_blur\";s:3:\"0px\";s:19:\"shadow_hover_spread\";s:3:\"0px\";s:18:\"shadow_hover_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:5:\"0.9em\";s:9:\"font_size\";s:4:\"14px\";s:5:\"width\";s:5:\"2.3em\";s:11:\"line_height\";s:3:\"1.2\";s:12:\"border_width\";s:3:\"0px\";s:11:\"font_weight\";s:3:\"700\";s:13:\"border_radius\";s:3:\"2em\";s:14:\"letter_spacing\";s:6:\"0.08em\";s:10:\"text_style\";s:9:\"uppercase\";}i:1;a:32:{s:2:\"id\";s:1:\"8\";s:4:\"name\";s:10:\"Cheio Azul\";s:5:\"hover\";s:4:\"fade\";s:5:\"class\";s:0:\"\";s:8:\"color_bg\";s:7:\"#27b3b8\";s:14:\"color_bg_hover\";s:7:\"#1a5e61\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:17:\"_header_middle_bg\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:0:\"\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:0:\"\";s:21:\"shadow_hover_offset_h\";s:3:\"0px\";s:21:\"shadow_hover_offset_v\";s:3:\"0px\";s:17:\"shadow_hover_blur\";s:3:\"0px\";s:19:\"shadow_hover_spread\";s:3:\"0px\";s:18:\"shadow_hover_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:5:\"0.9em\";s:9:\"font_size\";s:4:\"14px\";s:5:\"width\";s:5:\"2.3em\";s:11:\"line_height\";s:3:\"1.2\";s:12:\"border_width\";s:3:\"0px\";s:11:\"font_weight\";s:3:\"700\";s:13:\"border_radius\";s:3:\"2em\";s:14:\"letter_spacing\";s:6:\"0.08em\";s:10:\"text_style\";s:9:\"uppercase\";}i:2;a:32:{s:2:\"id\";s:1:\"6\";s:4:\"name\";s:12:\"Outline Roxo\";s:5:\"hover\";s:4:\"fade\";s:5:\"class\";s:0:\"\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:16:\"_content_heading\";s:12:\"color_border\";s:16:\"_content_heading\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:16:\"_content_heading\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:0:\"\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:0:\"\";s:21:\"shadow_hover_offset_h\";s:3:\"0px\";s:21:\"shadow_hover_offset_v\";s:3:\"0px\";s:17:\"shadow_hover_blur\";s:3:\"0px\";s:19:\"shadow_hover_spread\";s:3:\"0px\";s:18:\"shadow_hover_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:5:\"0.9em\";s:9:\"font_size\";s:4:\"14px\";s:5:\"width\";s:5:\"2.3em\";s:11:\"line_height\";s:3:\"1.2\";s:12:\"border_width\";s:3:\"1px\";s:11:\"font_weight\";s:3:\"700\";s:13:\"border_radius\";s:3:\"2em\";s:14:\"letter_spacing\";s:6:\"0.08em\";s:10:\"text_style\";s:9:\"uppercase\";}i:3;a:32:{s:2:\"id\";s:1:\"7\";s:4:\"name\";s:12:\"Outline Rosa\";s:5:\"hover\";s:4:\"fade\";s:5:\"class\";s:0:\"\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:18:\"_content_secondary\";s:12:\"color_border\";s:18:\"_content_secondary\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:18:\"_content_secondary\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:0:\"\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:0:\"\";s:21:\"shadow_hover_offset_h\";s:3:\"0px\";s:21:\"shadow_hover_offset_v\";s:3:\"0px\";s:17:\"shadow_hover_blur\";s:3:\"0px\";s:19:\"shadow_hover_spread\";s:3:\"0px\";s:18:\"shadow_hover_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:5:\"0.9em\";s:9:\"font_size\";s:4:\"14px\";s:5:\"width\";s:5:\"2.3em\";s:11:\"line_height\";s:3:\"1.2\";s:12:\"border_width\";s:3:\"1px\";s:11:\"font_weight\";s:3:\"700\";s:13:\"border_radius\";s:3:\"2em\";s:14:\"letter_spacing\";s:6:\"0.08em\";s:10:\"text_style\";s:9:\"uppercase\";}i:4;a:32:{s:2:\"id\";s:1:\"9\";s:4:\"name\";s:12:\"Outline Azul\";s:5:\"hover\";s:4:\"fade\";s:5:\"class\";s:0:\"\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:7:\"#27b3b8\";s:12:\"color_border\";s:7:\"#27b3b8\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#27b3b8\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:0:\"\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:0:\"\";s:21:\"shadow_hover_offset_h\";s:3:\"0px\";s:21:\"shadow_hover_offset_v\";s:3:\"0px\";s:17:\"shadow_hover_blur\";s:3:\"0px\";s:19:\"shadow_hover_spread\";s:3:\"0px\";s:18:\"shadow_hover_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:5:\"0.9em\";s:9:\"font_size\";s:4:\"14px\";s:5:\"width\";s:5:\"2.3em\";s:11:\"line_height\";s:3:\"1.2\";s:12:\"border_width\";s:3:\"1px\";s:11:\"font_weight\";s:3:\"700\";s:13:\"border_radius\";s:3:\"2em\";s:14:\"letter_spacing\";s:6:\"0.08em\";s:10:\"text_style\";s:9:\"uppercase\";}i:5;a:32:{s:2:\"id\";s:1:\"2\";s:4:\"name\";s:9:\"Just link\";s:5:\"hover\";s:4:\"fade\";s:5:\"class\";s:0:\"\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:0:\"\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:18:\"_content_secondary\";s:16:\"color_text_hover\";s:19:\"_content_link_hover\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:0:\"\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:0:\"\";s:21:\"shadow_hover_offset_h\";s:3:\"0px\";s:21:\"shadow_hover_offset_v\";s:3:\"0px\";s:17:\"shadow_hover_blur\";s:3:\"0px\";s:19:\"shadow_hover_spread\";s:3:\"0px\";s:18:\"shadow_hover_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:5:\"0.4em\";s:9:\"font_size\";s:4:\"12px\";s:5:\"width\";s:3:\"0em\";s:11:\"line_height\";s:4:\"1.20\";s:12:\"border_width\";s:3:\"0px\";s:11:\"font_weight\";s:3:\"500\";s:13:\"border_radius\";s:5:\"0.0em\";s:14:\"letter_spacing\";s:6:\"0.02em\";s:10:\"text_style\";s:0:\"\";}i:6;a:32:{s:2:\"id\";s:1:\"5\";s:4:\"name\";s:14:\"Default Header\";s:5:\"hover\";s:4:\"fade\";s:5:\"class\";s:0:\"\";s:8:\"color_bg\";s:18:\"_content_secondary\";s:14:\"color_bg_hover\";s:7:\"#94092d\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:0:\"\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:0:\"\";s:21:\"shadow_hover_offset_h\";s:3:\"0px\";s:21:\"shadow_hover_offset_v\";s:3:\"0px\";s:17:\"shadow_hover_blur\";s:3:\"0px\";s:19:\"shadow_hover_spread\";s:3:\"0px\";s:18:\"shadow_hover_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:5:\"0.6em\";s:9:\"font_size\";s:4:\"14px\";s:5:\"width\";s:5:\"1.6em\";s:11:\"line_height\";s:3:\"1.2\";s:12:\"border_width\";s:3:\"0px\";s:11:\"font_weight\";s:3:\"800\";s:13:\"border_radius\";s:3:\"2em\";s:14:\"letter_spacing\";s:6:\"0.06em\";s:10:\"text_style\";s:9:\"uppercase\";}}s:12:\"input_fields\";a:1:{i:0;a:31:{s:2:\"id\";s:1:\"1\";s:4:\"name\";s:13:\"Default Style\";s:5:\"class\";s:0:\"\";s:8:\"color_bg\";s:19:\"_alt_content_bg_alt\";s:14:\"color_bg_focus\";s:15:\"_content_bg_alt\";s:12:\"color_border\";s:15:\"_content_border\";s:18:\"color_border_focus\";s:15:\"_content_border\";s:10:\"color_text\";s:13:\"_content_text\";s:16:\"color_text_focus\";s:13:\"_content_text\";s:12:\"color_shadow\";s:16:\"rgba(0,0,0,0.08)\";s:18:\"color_shadow_focus\";s:16:\"_content_primary\";s:15:\"shadow_offset_h\";s:3:\"1px\";s:15:\"shadow_offset_v\";s:3:\"1px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:1:\"1\";s:21:\"shadow_focus_offset_h\";s:3:\"0px\";s:21:\"shadow_focus_offset_v\";s:3:\"0px\";s:17:\"shadow_focus_blur\";s:3:\"0px\";s:19:\"shadow_focus_spread\";s:3:\"2px\";s:18:\"shadow_focus_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:6:\"2.1rem\";s:9:\"font_size\";s:6:\"0.8rem\";s:7:\"padding\";s:6:\"0.6rem\";s:11:\"font_weight\";s:3:\"400\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:13:\"border_radius\";s:0:\"\";s:14:\"text_transform\";s:4:\"none\";s:13:\"checkbox_size\";s:5:\"1.5em\";}}s:26:\"portfolio_breadcrumbs_page\";s:0:\"\";s:14:\"portfolio_slug\";s:9:\"portfolio\";s:23:\"portfolio_category_slug\";s:18:\"portfolio_category\";s:18:\"portfolio_tag_slug\";s:13:\"portfolio_tag\";s:28:\"portfolio_slug_ignore_prefix\";i:0;s:16:\"portfolio_rename\";i:0;s:20:\"portfolio_label_name\";s:9:\"Portfolio\";s:29:\"portfolio_label_singular_name\";s:14:\"Portfolio Page\";s:23:\"portfolio_label_add_new\";s:18:\"Add Portfolio Page\";s:25:\"portfolio_label_edit_item\";s:19:\"Edit Portfolio Page\";s:24:\"portfolio_label_category\";s:20:\"Portfolio Categories\";s:19:\"portfolio_label_tag\";s:14:\"Portfolio Tags\";s:6:\"h_more\";s:0:\"\";s:12:\"shop_catalog\";i:0;s:22:\"shop_primary_btn_style\";s:1:\"1\";s:24:\"shop_secondary_btn_style\";s:1:\"2\";s:15:\"product_gallery\";s:6:\"slider\";s:29:\"wrapper_product_gallery_start\";s:0:\"\";s:26:\"product_gallery_thumbs_pos\";s:6:\"bottom\";s:27:\"product_gallery_thumbs_cols\";s:1:\"8\";s:28:\"product_gallery_thumbs_width\";s:4:\"6rem\";s:26:\"product_gallery_thumbs_gap\";s:3:\"4px\";s:23:\"product_gallery_options\";s:13:\"zoom,lightbox\";s:27:\"wrapper_product_gallery_end\";s:0:\"\";s:9:\"h_product\";s:0:\"\";s:17:\"header_product_id\";s:12:\"__defaults__\";s:19:\"titlebar_product_id\";s:0:\"\";s:18:\"content_product_id\";s:0:\"\";s:18:\"sidebar_product_id\";s:12:\"__defaults__\";s:19:\"sidebar_product_pos\";s:5:\"right\";s:17:\"footer_product_id\";s:12:\"__defaults__\";s:6:\"h_shop\";s:0:\"\";s:14:\"header_shop_id\";s:12:\"__defaults__\";s:16:\"titlebar_shop_id\";s:0:\"\";s:15:\"content_shop_id\";s:0:\"\";s:18:\"wrapper_shop_start\";s:0:\"\";s:12:\"shop_columns\";s:1:\"3\";s:16:\"wrapper_shop_end\";s:0:\"\";s:15:\"sidebar_shop_id\";s:12:\"__defaults__\";s:16:\"sidebar_shop_pos\";s:5:\"right\";s:14:\"footer_shop_id\";s:12:\"__defaults__\";s:13:\"h_shop_search\";s:0:\"\";s:21:\"header_shop_search_id\";s:12:\"__defaults__\";s:23:\"titlebar_shop_search_id\";s:2:\"10\";s:22:\"content_shop_search_id\";s:12:\"__defaults__\";s:22:\"sidebar_shop_search_id\";s:12:\"__defaults__\";s:23:\"sidebar_shop_search_pos\";s:5:\"right\";s:21:\"footer_shop_search_id\";s:12:\"__defaults__\";s:7:\"h_order\";s:0:\"\";s:16:\"content_order_id\";s:0:\"\";s:6:\"h_cart\";s:0:\"\";s:9:\"shop_cart\";s:7:\"compact\";s:19:\"product_related_qty\";s:1:\"3\";s:15:\"used_icons_info\";s:0:\"\";s:9:\"h_icons_2\";s:0:\"\";s:9:\"icons_fas\";s:7:\"default\";s:21:\"icons_fas_custom_font\";s:0:\"\";s:9:\"icons_far\";s:7:\"default\";s:21:\"icons_far_custom_font\";s:0:\"\";s:9:\"icons_fal\";s:7:\"default\";s:21:\"icons_fal_custom_font\";s:0:\"\";s:9:\"icons_fad\";s:7:\"default\";s:21:\"icons_fad_custom_font\";s:0:\"\";s:9:\"icons_fab\";s:7:\"default\";s:21:\"icons_fab_custom_font\";s:0:\"\";s:14:\"icons_material\";s:7:\"default\";s:26:\"icons_material_custom_font\";s:0:\"\";s:18:\"fallback_icon_font\";i:1;s:13:\"img_size_info\";s:0:\"\";s:13:\"h_image_sizes\";s:0:\"\";s:8:\"img_size\";a:0:{}s:14:\"h_more_options\";s:0:\"\";s:24:\"big_image_size_threshold\";s:6:\"2560px\";s:20:\"delete_unused_images\";i:0;s:12:\"h_advanced_1\";s:0:\"\";s:12:\"live_builder\";i:1;s:17:\"section_templates\";i:1;s:17:\"section_favorites\";i:1;s:19:\"grid_columns_layout\";i:1;s:12:\"block_editor\";i:0;s:23:\"enable_sidebar_titlebar\";i:1;s:31:\"enable_page_blocks_for_sidebars\";i:0;s:16:\"enable_portfolio\";i:0;s:19:\"enable_testimonials\";i:1;s:14:\"media_category\";i:1;s:10:\"og_enabled\";i:1;s:13:\"schema_markup\";i:1;s:28:\"templates_access_for_editors\";i:0;s:12:\"h_advanced_2\";s:0:\"\";s:13:\"gmaps_api_key\";s:0:\"\";s:15:\"facebook_app_id\";s:0:\"\";s:22:\"grid_filter_url_prefix\";s:0:\"\";s:21:\"grid_order_url_prefix\";s:0:\"\";s:12:\"h_advanced_3\";s:0:\"\";s:17:\"keep_url_protocol\";i:1;s:22:\"disable_jquery_migrate\";i:1;s:13:\"jquery_footer\";i:1;s:16:\"disable_extra_vc\";i:1;s:15:\"optimize_assets\";i:0;s:21:\"optimize_assets_alert\";s:0:\"\";s:21:\"optimize_assets_start\";s:0:\"\";s:6:\"assets\";a:64:{s:11:\"add_to_favs\";i:1;s:20:\"font-awesome-duotone\";i:1;s:12:\"font-awesome\";i:1;s:9:\"actionbox\";i:1;s:9:\"animation\";i:1;s:7:\"buttons\";i:1;s:8:\"carousel\";i:1;s:6:\"charts\";i:1;s:19:\"color_scheme_switch\";i:1;s:7:\"columns\";i:1;s:8:\"comments\";i:1;s:16:\"content_carousel\";i:1;s:7:\"counter\";i:1;s:8:\"dropdown\";i:1;s:7:\"flipbox\";i:1;s:5:\"forms\";i:1;s:7:\"gallery\";i:1;s:5:\"gmaps\";i:1;s:4:\"grid\";i:1;s:11:\"grid_filter\";i:1;s:14:\"grid_templates\";i:1;s:10:\"grid_order\";i:1;s:15:\"grid_pagination\";i:1;s:10:\"grid_popup\";i:1;s:6:\"header\";i:1;s:12:\"hor_parallax\";i:1;s:8:\"hwrapper\";i:1;s:7:\"iconbox\";i:1;s:12:\"image_slider\";i:1;s:5:\"image\";i:1;s:8:\"contacts\";i:1;s:7:\"ibanner\";i:1;s:5:\"itext\";i:1;s:11:\"list_filter\";i:1;s:10:\"list_order\";i:1;s:11:\"list_search\";i:1;s:5:\"login\";i:1;s:4:\"menu\";i:1;s:7:\"message\";i:1;s:5:\"lmaps\";i:1;s:8:\"scroller\";i:1;s:6:\"person\";i:1;s:6:\"search\";i:1;s:5:\"popup\";i:1;s:14:\"magnific_popup\";i:1;s:13:\"post_elements\";i:1;s:9:\"post_list\";i:1;s:15:\"post_navigation\";i:1;s:9:\"preloader\";i:1;s:7:\"pricing\";i:1;s:5:\"print\";i:1;s:7:\"progbar\";i:1;s:6:\"scroll\";i:1;s:14:\"scroll-effects\";i:1;s:9:\"separator\";i:1;s:7:\"sharing\";i:1;s:11:\"simple_menu\";i:1;s:7:\"socials\";i:1;s:4:\"tabs\";i:1;s:4:\"text\";i:1;s:12:\"ver_parallax\";i:1;s:8:\"vwrapper\";i:1;s:5:\"video\";i:1;s:10:\"wp_widgets\";i:1;}s:19:\"optimize_assets_end\";s:0:\"\";s:18:\"include_gfonts_css\";i:0;s:10:\"custom_css\";s:7864:\"\n/* Glossário */\n\n.glossario .w-tabs-section-title {\n    font-weight: 500 !important;\n}\n\n.glossario .w-tabs-section.active:not(.has_text_color)>.w-tabs-section-header {\n    color: #ef3566 !important;\n}\n\n.glossario .w-tabs-section-header {\n    padding: 0.5em 1em !important;\n}\n\n/* Vários */\n\n/*\n.l-header.id_12.pos_fixed.bg_transparent.shadow_none.sticky > .l-subheader.at_bottom {\n	background-color: blue !important;\n}\n\n*/\n\n.footertitle a {\n	text-transform: uppercase !important;\n	font-size: 0.8rem !important;\n	color: #fef5b5 !important;\n	font-weight: 700 !important;\n	letter-spacing: 1px;\n	margin-top: 5px !important;\n	display: block !important;\n}\n\n.footertitlesep a {\n	margin-top: 15px !important;\n}\n\ninput:checked~.w-filter-item-value-label {\n    font-weight: 700 !important;\n    color: #3b177c !important;\n}\n\ninput[type=checkbox]:before {\n    font-weight: 400 !important;\n    font-size: 0.8rem !important;\n}\n\n.w-nav.type_desktop .w-nav-anchor:not(.level_1) {\n    line-height: 1em !important;\n    text-transform: none !important;\n    font-weight: 600 !important;\n}\n\n.w-nav.type_desktop .w-nav-list.level_2 {\n    padding-top: 0.5rem !important;\n    padding-bottom: 0.5rem !important;\n}\n\n.w-iconbox .w-iconbox-title:not(:empty) {\n    padding: 0em 0 !important;\n}\n\nh3.widgettitle {\n    font-size: 1.3rem !important;\n}\n\n\n.titleleftamarelo::after {\ncontent: \"\";\ndisplay: block;\nwidth: 95px;\nheight: 14px;\nbackground-image: url(\'/wp-content/uploads/2024/12/MID_btz_ico_-03.svg\');\nbackground-size: contain;\nbackground-repeat: no-repeat;\nmargin-left: 8px;\nvertical-align: middle;\n	margin-top: 12px;\n}\n\n.titleleftbranco::after {\ncontent: \"\";\ndisplay: block;\nwidth: 95px;\nheight: 14px;\nbackground-image: url(\'/wp-content/uploads/2024/12/MID_btz_ico_-04.svg\');\nbackground-size: contain;\nbackground-repeat: no-repeat;\nmargin-left: 8px;\nvertical-align: middle;\n	margin-top: 12px;\n}\n\n.titleleftazul::after {\ncontent: \"\";\ndisplay: block;\nwidth: 95px;\nheight: 14px;\nbackground-image: url(\'/wp-content/uploads/2024/12/MID_btz_ico_-05.svg\');\nbackground-size: contain;\nbackground-repeat: no-repeat;\nmargin-left: 8px;\nvertical-align: middle;\n	margin-top: 12px;\n}\n\n.titlecenteramarelo::after {\ncontent: \"\";\ndisplay: block;\nwidth: 95px;\nheight: 14px;\nbackground-image: url(\'/wp-content/uploads/2024/12/MID_btz_ico_-03.svg\');\nbackground-size: contain;\nbackground-repeat: no-repeat;\nmargin-left: auto !important;\nmargin-right: auto !important;\nmargin-left: 8px;\nvertical-align: middle;\n	margin-top: 12px;\n}\n\n.titlecenterbranco::after {\ncontent: \"\";\ndisplay: block;\nwidth: 95px;\nheight: 14px;\nbackground-image: url(\'/wp-content/uploads/2024/12/MID_btz_ico_-04.svg\');\nbackground-size: contain;\nbackground-repeat: no-repeat;\nmargin-left: auto !important;\nmargin-right: auto !important;\nmargin-left: 8px;\nvertical-align: middle;\n	margin-top: 12px;\n}\n\n.titlecenterazul::after {\ncontent: \"\";\ndisplay: block;\nwidth: 95px;\nheight: 14px;\nbackground-image: url(\'/wp-content/uploads/2024/12/MID_btz_ico_-05.svg\');\nbackground-size: contain;\nbackground-repeat: no-repeat;\nmargin-left: auto !important;\nmargin-right: auto !important;\nmargin-left: 8px;\nvertical-align: middle;\nmargin-top: 12px;\n}\n\n\n\n/* FIM Vários */\n\n/* Menu topo */\n\n.w-nav-close {\n    font-size: 2rem !important;\n	top: 68px !important;\n    right: 42px !important;\n}\n\n.l-subheader.at_middle .type_mobile .w-nav-list.level_1 {\n    background: #02253eed !important;\n    color: #fff;\n}\n\n/* dhcv */\n\n\ndiv.dhvc-form-inner section.l-section.wpb_row.height_auto {\n	padding-left: 0rem !important;\n	padding-right: 0rem !important;\n}\n\n.dhvc-form-flat .dhvc-form-input input, .dhvc-form-flat .dhvc-form-file input[type=text], .dhvc-form-flat .dhvc-form-captcha input, .dhvc-form-flat .dhvc-form-select select, .dhvc-form-flat .dhvc-form-textarea textarea {\n    background-color: #fff !important;\n    border-bottom-width: 2px !important;\n    border-top-width: 0px;\n    border-left-width: 0px;\n    border-right-width: 0px;\n}\n\n.dhvc-form-group .dhvc-form-label, .dhvc-form-group label {\n    display: inline-block;\n    font-weight: 400 !important;\n    font-size: 14px;\n    line-height: 1.42857;\n    margin-bottom: 5px;\n}\n\n.dhvc-form-group .dhvc-form-add-on {\n    z-index: 100 !important;\n}\n\n.dhvc-form-input.dhvc-form-has-add-on .dhvc-form-control {\n    background-color: #fff !important;\n}\n\ndiv.dhvc-form-action.dhvc_form_submit_button > button[type=\"submit\"]:not(.w-btn) {\n    padding-top: 9px !important;\n}\n\n/* FIM dhcv */\n\n/* colunas stacked */\n\n@media (max-width: 600px) {\n.g-cols.wpb_row.ignorestack.via_grid.cols_2.laptops-cols_inherit.tablets-cols_inherit.mobiles-cols_1.valign_top.type_default.stacking_default {\n    grid-template-columns: repeat(2,1fr) !important;\n}\n.g-cols.wpb_row.ignorestack.via_grid.cols_3.laptops-cols_inherit.tablets-cols_inherit.mobiles-cols_1.valign_top.type_default.stacking_default {\n    grid-template-columns: repeat(2,1fr) !important;\n}\n.g-cols.wpb_row.ignorestack.via_grid.cols_4.laptops-cols_inherit.tablets-cols_inherit.mobiles-cols_1.valign_top.type_default.stacking_default {\n    grid-template-columns: repeat(2,1fr) !important;\n}\n.g-cols.wpb_row.ignorestack.via_grid.cols_5.laptops-cols_inherit.tablets-cols_inherit.mobiles-cols_1.valign_top.type_default.stacking_default {\n    grid-template-columns: repeat(2,1fr) !important;\n}\n\n    }\n\n/* FIM colunas stacked */\n\n/* mouse-hover com ampliação da imagem */\n\n.tfzindex {\n	z-index: 100 !important;\n}\n\n.overflowesconder {\n	overflow: hidden !important;\n}\n\n\n.hover01 {\n	-webkit-transform: scale(1);\n	transform: scale(1);\n	-webkit-transition: .3s ease-in-out;\n	transition: .3s ease-in-out;\n		overflow: hidden !important;\n}\n.hover01:hover {\n	-webkit-transform: scale(1.15);\n	transform: scale(1.15);\n	overflow: hidden !important;\n}\n\n.shift01 {\n	-webkit-transform: translateY(0);;\n	transform: translateY(0);;\n	-webkit-transition: .3s ease-in-out;\n	transition: .3s ease-in-out;\n		overflow: hidden !important;\n}\n.shift01:hover {\n	-webkit-transform: translateY(-10px);\n	transform: translateY(-10px);\n	overflow: hidden !important;\n}\n\n/* FIM mouse-hover com ampliação da imagem */\n\n/* Ken Burns - usar class image-wrap */\n\n.image-wrap {\n  margin: 0 auto;\n  overflow: hidden;\n  position: relative;\n}\n\n\n.image-wrap .l-section-img {\n  width: 100%;\n  animation: move 40s ease;\n  /* Add infinite to loop. */\n  \n  -ms-animation: move 40s ease;\n  -webkit-animation: move 40s ease;\n  -0-animation: move 40s ease;\n  -moz-animation: move 40s ease;\n  position: absolute;\n}\n\n@-webkit-keyframes move {\n  0% {\n    -webkit-transform-origin: bottom left;\n    -moz-transform-origin: bottom left;\n    -ms-transform-origin: bottom left;\n    -o-transform-origin: bottom left;\n    transform-origin: bottom left;\n    transform: scale(1.0);\n    -ms-transform: scale(1.0);\n    /* IE 9 */\n    \n    -webkit-transform: scale(1.0);\n    /* Safari and Chrome */\n    \n    -o-transform: scale(1.0);\n    /* Opera */\n    \n    -moz-transform: scale(1.0);\n    /* Firefox */\n  }\n  100% {\n    transform: scale(1.2);\n    -ms-transform: scale(1.2);\n    /* IE 9 */\n    \n    -webkit-transform: scale(1.2);\n    /* Safari and Chrome */\n    \n    -o-transform: scale(1.2);\n    /* Opera */\n    \n    -moz-transform: scale(1.2);\n    /* Firefox */\n  }\n}\n/*  FIM Ken Burns */\n\n/* title stroke */\n\n.titlestrokeverde::after {\ndisplay: block;\nclear: both;\ncontent: \"\";\nposition: absolute;\nmax-width: 26px;\nheight: 1px;\nwidth: 39%;\nborder-bottom: 1px solid #009745;\nmargin: 0 auto;\npadding: 4px 0px;\n}\n\n.titlestrokegrey::after {\ndisplay: block;\nclear: both;\ncontent: \"\";\nposition: absolute;\nmax-width: 26px;\nheight: 1px;\nwidth: 39%;\nborder-bottom: 1px solid #414042;\nmargin: 0 auto;\npadding: 4px 0px;\n}\n\n.titlestrokeverdecenter::after {\ndisplay: block;\nclear: both;\ncontent: \"\";\nposition: relative;\nmax-width: 26px;\nheight: 1px;\nwidth: 39%;\nborder-bottom: 1px solid #009745;\nmargin: 0 auto;\npadding: 4px 0px;\n}\n\n\n\n\";s:16:\"custom_html_head\";s:0:\"\";s:16:\"custom_html_body\";s:0:\"\";s:11:\"custom_html\";s:0:\"\";s:8:\"of_reset\";s:0:\"\";s:9:\"of_backup\";s:0:\"\";s:11:\"of_transfer\";s:0:\"\";s:11:\"white_label\";i:0;s:22:\"white_label_theme_name\";s:0:\"\";s:28:\"white_label_theme_screenshot\";s:0:\"\";s:22:\"white_label_theme_icon\";s:0:\"\";s:22:\"white_label_login_icon\";s:0:\"\";s:11:\"h_glossario\";s:0:\"\";s:19:\"header_glossario_id\";s:12:\"__defaults__\";s:21:\"titlebar_glossario_id\";s:12:\"__defaults__\";s:20:\"content_glossario_id\";s:12:\"__defaults__\";s:20:\"sidebar_glossario_id\";s:12:\"__defaults__\";s:21:\"sidebar_glossario_pos\";s:5:\"right\";s:19:\"footer_glossario_id\";s:12:\"__defaults__\";s:21:\"h_tax_letra-glossario\";s:0:\"\";s:29:\"header_tax_letra-glossario_id\";s:12:\"__defaults__\";s:31:\"titlebar_tax_letra-glossario_id\";s:12:\"__defaults__\";s:30:\"content_tax_letra-glossario_id\";s:12:\"__defaults__\";s:30:\"sidebar_tax_letra-glossario_id\";s:12:\"__defaults__\";s:31:\"sidebar_tax_letra-glossario_pos\";s:5:\"right\";s:29:\"footer_tax_letra-glossario_id\";s:12:\"__defaults__\";s:11:\"h_portfolio\";s:0:\"\";s:19:\"header_portfolio_id\";s:12:\"__defaults__\";s:21:\"titlebar_portfolio_id\";s:12:\"__defaults__\";s:20:\"content_portfolio_id\";s:12:\"__defaults__\";s:20:\"sidebar_portfolio_id\";s:12:\"__defaults__\";s:21:\"sidebar_portfolio_pos\";s:5:\"right\";s:19:\"footer_portfolio_id\";s:12:\"__defaults__\";s:19:\"h_tax_marca-produto\";s:0:\"\";s:27:\"header_tax_marca-produto_id\";s:12:\"__defaults__\";s:29:\"titlebar_tax_marca-produto_id\";s:2:\"10\";s:28:\"content_tax_marca-produto_id\";s:2:\"58\";s:28:\"sidebar_tax_marca-produto_id\";s:12:\"__defaults__\";s:29:\"sidebar_tax_marca-produto_pos\";s:5:\"right\";s:27:\"footer_tax_marca-produto_id\";s:12:\"__defaults__\";s:27:\"h_tax_us_portfolio_category\";s:0:\"\";s:35:\"header_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:37:\"titlebar_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:36:\"content_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:36:\"sidebar_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:37:\"sidebar_tax_us_portfolio_category_pos\";s:5:\"right\";s:35:\"footer_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:22:\"h_tax_us_portfolio_tag\";s:0:\"\";s:30:\"header_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:32:\"titlebar_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:31:\"content_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:31:\"sidebar_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:32:\"sidebar_tax_us_portfolio_tag_pos\";s:5:\"right\";s:30:\"footer_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:17:\"h_tax_product_cat\";s:0:\"\";s:25:\"header_tax_product_cat_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_product_cat_id\";s:2:\"10\";s:26:\"content_tax_product_cat_id\";s:2:\"58\";s:26:\"sidebar_tax_product_cat_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_product_cat_pos\";s:5:\"right\";s:25:\"footer_tax_product_cat_id\";s:12:\"__defaults__\";s:17:\"h_tax_product_tag\";s:0:\"\";s:25:\"header_tax_product_tag_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_product_tag_id\";s:12:\"__defaults__\";s:26:\"content_tax_product_tag_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_product_tag_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_product_tag_pos\";s:5:\"right\";s:25:\"footer_tax_product_tag_id\";s:12:\"__defaults__\";s:12:\"ajax_load_js\";i:1;s:16:\"h1_letterspacing\";s:3:\"0em\";s:16:\"h2_letterspacing\";s:3:\"0em\";s:16:\"h3_letterspacing\";s:3:\"0em\";s:16:\"h4_letterspacing\";s:3:\"0em\";s:16:\"h5_letterspacing\";s:3:\"0em\";s:16:\"h6_letterspacing\";s:3:\"0em\";s:12:\"h_slide_home\";s:0:\"\";s:20:\"header_slide_home_id\";s:12:\"__defaults__\";s:22:\"titlebar_slide_home_id\";s:12:\"__defaults__\";s:21:\"content_slide_home_id\";s:12:\"__defaults__\";s:21:\"sidebar_slide_home_id\";s:12:\"__defaults__\";s:22:\"sidebar_slide_home_pos\";s:5:\"right\";s:20:\"footer_slide_home_id\";s:12:\"__defaults__\";}", "on");
INSERT INTO `wp_options` VALUES("194", "widget_us_contacts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("195", "widget_us_login", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("196", "widget_us_portfolio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("197", "widget_us_blog", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("198", "widget_us_socials", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("199", "Impreza_editor_caps_set", "1", "yes");
INSERT INTO `wp_options` VALUES("200", "usof_color_palette_Impreza", "a:8:{i:0;s:39:\"linear-gradient(135deg,#e95095,#7049ba)\";i:1;s:39:\"linear-gradient(135deg,#7049ba,#e95095)\";i:2;s:7:\"#1a1a1a\";i:3;s:4:\"#333\";i:4;s:4:\"#999\";i:5;s:7:\"#e8e8e8\";i:6;s:7:\"#f5f5f5\";i:7;s:4:\"#fff\";}", "yes");
INSERT INTO `wp_options` VALUES("201", "us_theme_options_css", ":root{--color-header-middle-bg:#ffffff;--color-header-middle-bg-grad:#ffffff;--color-header-middle-text:#122440;--color-header-middle-text-hover:#e95095;--color-header-transparent-bg:transparent;--color-header-transparent-bg-grad:transparent;--color-header-transparent-text:#ffffff;--color-header-transparent-text-hover:#ffffff;--color-chrome-toolbar:#f5f5f5;--color-chrome-toolbar-grad:#f5f5f5;--color-header-top-bg:#f5f5f5;--color-header-top-bg-grad:linear-gradient(0deg,#f5f5f5,#fff);--color-header-top-text:#333333;--color-header-top-text-hover:#e95095;--color-header-top-transparent-bg:rgba(0,0,0,0.2);--color-header-top-transparent-bg-grad:rgba(0,0,0,0.2);--color-header-top-transparent-text:rgba(255,255,255,0.66);--color-header-top-transparent-text-hover:#ffffff;--color-content-bg:#ffffff;--color-content-bg-grad:#ffffff;--color-content-bg-alt:#fef5b5;--color-content-bg-alt-grad:#fef5b5;--color-content-border:#e8e8e8;--color-content-heading:#3b177c;--color-content-heading-grad:#3b177c;--color-content-text:#333333;--color-content-link:#3b177c;--color-content-link-hover:#163f72;--color-content-primary:#42d2d7;--color-content-primary-grad:#42d2d7;--color-content-secondary:#ef3566;--color-content-secondary-grad:#ef3566;--color-content-faded:#999999;--color-content-overlay:rgba(0,0,0,0.75);--color-content-overlay-grad:rgba(0,0,0,0.75);--color-alt-content-bg:#f5f5f5;--color-alt-content-bg-grad:#f5f5f5;--color-alt-content-bg-alt:#fffef5;--color-alt-content-bg-alt-grad:#fffef5;--color-alt-content-border:#dddddd;--color-alt-content-heading:#1a1a1a;--color-alt-content-heading-grad:#1a1a1a;--color-alt-content-text:#333333;--color-alt-content-link:#e95095;--color-alt-content-link-hover:#7049ba;--color-alt-content-primary:#36b1b5;--color-alt-content-primary-grad:#36b1b5;--color-alt-content-secondary:#7049ba;--color-alt-content-secondary-grad:linear-gradient(135deg,#7049ba,#e95095);--color-alt-content-faded:#999999;--color-alt-content-overlay:#e95095;--color-alt-content-overlay-grad:linear-gradient(135deg,#e95095,rgba(233,80,149,0.75));--color-footer-bg:#222222;--color-footer-bg-grad:#222222;--color-footer-bg-alt:#1a1a1a;--color-footer-bg-alt-grad:#1a1a1a;--color-footer-border:#333333;--color-footer-heading:#cccccc;--color-footer-heading-grad:#cccccc;--color-footer-text:#999999;--color-footer-link:#cccccc;--color-footer-link-hover:#e95095;--color-subfooter-bg:#1a1a1a;--color-subfooter-bg-grad:#1a1a1a;--color-subfooter-bg-alt:#222222;--color-subfooter-bg-alt-grad:#222222;--color-subfooter-border:#282828;--color-subfooter-heading:#cccccc;--color-subfooter-heading-grad:#cccccc;--color-subfooter-text:#bbbbbb;--color-subfooter-link:#ffffff;--color-subfooter-link-hover:#e95095;--color-content-primary-faded:rgba(66,210,215,0.15);--box-shadow:0 5px 15px rgba(0,0,0,.15);--box-shadow-up:0 -5px 15px rgba(0,0,0,.15);--site-canvas-width:1300px;--site-content-width:1140px;--site-sidebar-width:25%;--text-block-margin-bottom:0rem}:root{--font-family:Mulish,sans-serif;--font-size:17px;--line-height:25px;--font-weight:300;--bold-font-weight:800;--text-transform:none;--font-style:normal;--letter-spacing:0em;--h1-font-family:inherit;--h1-font-size:max( 4rem,4vw );--h1-line-height:1.2;--h1-font-weight:400;--h1-bold-font-weight:700;--h1-text-transform:none;--h1-font-style:normal;--h1-letter-spacing:0em;--h1-margin-bottom:0.6em;--h2-font-family:var(--h1-font-family);--h2-font-size:max( 2.3rem,2.3vw );--h2-line-height:1.2;--h2-font-weight:500;--h2-bold-font-weight:600;--h2-text-transform:var(--h1-text-transform);--h2-font-style:var(--h1-font-style);--h2-letter-spacing:0em;--h2-margin-bottom:0.6em;--h3-font-family:var(--h1-font-family);--h3-font-size:max( 1.7rem,1.7vw );--h3-line-height:1.2;--h3-font-weight:200;--h3-bold-font-weight:900;--h3-text-transform:var(--h1-text-transform);--h3-font-style:var(--h1-font-style);--h3-letter-spacing:0em;--h3-margin-bottom:0.6em;--h4-font-family:var(--h1-font-family);--h4-font-size:max( 1.5rem,1.5vw );--h4-line-height:1.2;--h4-font-weight:var(--h1-font-weight);--h4-bold-font-weight:var(--h1-bold-font-weight);--h4-text-transform:var(--h1-text-transform);--h4-font-style:var(--h1-font-style);--h4-letter-spacing:0em;--h4-margin-bottom:0.6em;--h5-font-family:var(--h1-font-family);--h5-font-size:max( 1.3rem,1.3vw );--h5-line-height:1.2;--h5-font-weight:var(--h1-font-weight);--h5-bold-font-weight:var(--h1-bold-font-weight);--h5-text-transform:var(--h1-text-transform);--h5-font-style:var(--h1-font-style);--h5-letter-spacing:0em;--h5-margin-bottom:0.6em;--h6-font-family:var(--h1-font-family);--h6-font-size:max( 1.2rem,1.2vw );--h6-line-height:1.2;--h6-font-weight:var(--h1-font-weight);--h6-bold-font-weight:var(--h1-bold-font-weight);--h6-text-transform:var(--h1-text-transform);--h6-font-style:var(--h1-font-style);--h6-letter-spacing:0em;--h6-margin-bottom:0.6em}@media (min-width:1025px) and (max-width:1380px){:root{--font-size:18px}}@media (min-width:601px) and (max-width:1024px){:root{--font-size:18px}}@media (max-width:600px){:root{--font-size:16px}}h1{font-family:var(--h1-font-family,inherit);font-weight:var(--h1-font-weight,inherit);font-size:var(--h1-font-size,inherit);font-style:var(--h1-font-style,inherit);line-height:var(--h1-line-height,1.4);letter-spacing:var(--h1-letter-spacing,inherit);text-transform:var(--h1-text-transform,inherit);margin-bottom:var(--h1-margin-bottom,1.5rem)}h1>strong{font-weight:var(--h1-bold-font-weight,bold)}h2{font-family:var(--h2-font-family,inherit);font-weight:var(--h2-font-weight,inherit);font-size:var(--h2-font-size,inherit);font-style:var(--h2-font-style,inherit);line-height:var(--h2-line-height,1.4);letter-spacing:var(--h2-letter-spacing,inherit);text-transform:var(--h2-text-transform,inherit);margin-bottom:var(--h2-margin-bottom,1.5rem)}h2>strong{font-weight:var(--h2-bold-font-weight,bold)}h3{font-family:var(--h3-font-family,inherit);font-weight:var(--h3-font-weight,inherit);font-size:var(--h3-font-size,inherit);font-style:var(--h3-font-style,inherit);line-height:var(--h3-line-height,1.4);letter-spacing:var(--h3-letter-spacing,inherit);text-transform:var(--h3-text-transform,inherit);margin-bottom:var(--h3-margin-bottom,1.5rem)}h3>strong{font-weight:var(--h3-bold-font-weight,bold)}h4{font-family:var(--h4-font-family,inherit);font-weight:var(--h4-font-weight,inherit);font-size:var(--h4-font-size,inherit);font-style:var(--h4-font-style,inherit);line-height:var(--h4-line-height,1.4);letter-spacing:var(--h4-letter-spacing,inherit);text-transform:var(--h4-text-transform,inherit);margin-bottom:var(--h4-margin-bottom,1.5rem)}h4>strong{font-weight:var(--h4-bold-font-weight,bold)}h5{font-family:var(--h5-font-family,inherit);font-weight:var(--h5-font-weight,inherit);font-size:var(--h5-font-size,inherit);font-style:var(--h5-font-style,inherit);line-height:var(--h5-line-height,1.4);letter-spacing:var(--h5-letter-spacing,inherit);text-transform:var(--h5-text-transform,inherit);margin-bottom:var(--h5-margin-bottom,1.5rem)}h5>strong{font-weight:var(--h5-bold-font-weight,bold)}h6{font-family:var(--h6-font-family,inherit);font-weight:var(--h6-font-weight,inherit);font-size:var(--h6-font-size,inherit);font-style:var(--h6-font-style,inherit);line-height:var(--h6-line-height,1.4);letter-spacing:var(--h6-letter-spacing,inherit);text-transform:var(--h6-text-transform,inherit);margin-bottom:var(--h6-margin-bottom,1.5rem)}h6>strong{font-weight:var(--h6-bold-font-weight,bold)}body{background:var(--color-content-bg-alt)}@media (max-width:1225px){.l-main .aligncenter{max-width:calc(100vw - 5rem)}}@media (min-width:1381px){body.usb_preview .hide_on_default{opacity:0.25!important}.vc_hidden-lg,body:not(.usb_preview) .hide_on_default{display:none!important}.default_align_left{text-align:left;justify-content:flex-start}.default_align_right{text-align:right;justify-content:flex-end}.default_align_center{text-align:center;justify-content:center}.w-hwrapper.default_align_center>*{margin-left:calc( var(--hwrapper-gap,1.2rem) / 2 );margin-right:calc( var(--hwrapper-gap,1.2rem) / 2 )}.default_align_justify{justify-content:space-between}.w-hwrapper>.default_align_justify,.default_align_justify>.w-btn{width:100%}}@media (min-width:1025px) and (max-width:1380px){body.usb_preview .hide_on_laptops{opacity:0.25!important}.vc_hidden-md,body:not(.usb_preview) .hide_on_laptops{display:none!important}.laptops_align_left{text-align:left;justify-content:flex-start}.laptops_align_right{text-align:right;justify-content:flex-end}.laptops_align_center{text-align:center;justify-content:center}.w-hwrapper.laptops_align_center>*{margin-left:calc( var(--hwrapper-gap,1.2rem) / 2 );margin-right:calc( var(--hwrapper-gap,1.2rem) / 2 )}.laptops_align_justify{justify-content:space-between}.w-hwrapper>.laptops_align_justify,.laptops_align_justify>.w-btn{width:100%}.g-cols.via_grid[style*=\"--laptops-gap\"]{grid-gap:var(--laptops-gap,3rem)}}@media (min-width:601px) and (max-width:1024px){body.usb_preview .hide_on_tablets{opacity:0.25!important}.vc_hidden-sm,body:not(.usb_preview) .hide_on_tablets{display:none!important}.tablets_align_left{text-align:left;justify-content:flex-start}.tablets_align_right{text-align:right;justify-content:flex-end}.tablets_align_center{text-align:center;justify-content:center}.w-hwrapper.tablets_align_center>*{margin-left:calc( var(--hwrapper-gap,1.2rem) / 2 );margin-right:calc( var(--hwrapper-gap,1.2rem) / 2 )}.tablets_align_justify{justify-content:space-between}.w-hwrapper>.tablets_align_justify,.tablets_align_justify>.w-btn{width:100%}.g-cols.via_grid[style*=\"--tablets-gap\"]{grid-gap:var(--tablets-gap,3rem)}}@media (max-width:600px){body.usb_preview .hide_on_mobiles{opacity:0.25!important}.vc_hidden-xs,body:not(.usb_preview) .hide_on_mobiles{display:none!important}.mobiles_align_left{text-align:left;justify-content:flex-start}.mobiles_align_right{text-align:right;justify-content:flex-end}.mobiles_align_center{text-align:center;justify-content:center}.w-hwrapper.mobiles_align_center>*{margin-left:calc( var(--hwrapper-gap,1.2rem) / 2 );margin-right:calc( var(--hwrapper-gap,1.2rem) / 2 )}.mobiles_align_justify{justify-content:space-between}.w-hwrapper>.mobiles_align_justify,.mobiles_align_justify>.w-btn{width:100%}.w-hwrapper.stack_on_mobiles{display:block}.w-hwrapper.stack_on_mobiles>:not(script){display:block;margin:0 0 var(--hwrapper-gap,1.2rem)}.w-hwrapper.stack_on_mobiles>:last-child{margin-bottom:0}.g-cols.via_grid[style*=\"--mobiles-gap\"]{grid-gap:var(--mobiles-gap,1.5rem)}}@media (max-width:1380px){.g-cols.laptops-cols_1{grid-template-columns:100%}.g-cols.laptops-cols_1.reversed>div:last-of-type{order:-1}.g-cols.laptops-cols_2{grid-template-columns:repeat(2,1fr)}.g-cols.laptops-cols_3{grid-template-columns:repeat(3,1fr)}.g-cols.laptops-cols_4{grid-template-columns:repeat(4,1fr)}.g-cols.laptops-cols_5{grid-template-columns:repeat(5,1fr)}.g-cols.laptops-cols_6{grid-template-columns:repeat(6,1fr)}.g-cols.laptops-cols_1-2{grid-template-columns:1fr 2fr}.g-cols.laptops-cols_2-1{grid-template-columns:2fr 1fr}.g-cols.laptops-cols_2-3{grid-template-columns:2fr 3fr}.g-cols.laptops-cols_3-2{grid-template-columns:3fr 2fr}.g-cols.laptops-cols_1-3{grid-template-columns:1fr 3fr}.g-cols.laptops-cols_3-1{grid-template-columns:3fr 1fr}.g-cols.laptops-cols_1-4{grid-template-columns:1fr 4fr}.g-cols.laptops-cols_4-1{grid-template-columns:4fr 1fr}.g-cols.laptops-cols_1-5{grid-template-columns:1fr 5fr}.g-cols.laptops-cols_5-1{grid-template-columns:5fr 1fr}.g-cols.laptops-cols_1-2-1{grid-template-columns:1fr 2fr 1fr}.g-cols.laptops-cols_1-3-1{grid-template-columns:1fr 3fr 1fr}.g-cols.laptops-cols_1-4-1{grid-template-columns:1fr 4fr 1fr}}@media (max-width:1024px){.g-cols.tablets-cols_1{grid-template-columns:100%}.g-cols.tablets-cols_1.reversed>div:last-of-type{order:-1}.g-cols.tablets-cols_2{grid-template-columns:repeat(2,1fr)}.g-cols.tablets-cols_3{grid-template-columns:repeat(3,1fr)}.g-cols.tablets-cols_4{grid-template-columns:repeat(4,1fr)}.g-cols.tablets-cols_5{grid-template-columns:repeat(5,1fr)}.g-cols.tablets-cols_6{grid-template-columns:repeat(6,1fr)}.g-cols.tablets-cols_1-2{grid-template-columns:1fr 2fr}.g-cols.tablets-cols_2-1{grid-template-columns:2fr 1fr}.g-cols.tablets-cols_2-3{grid-template-columns:2fr 3fr}.g-cols.tablets-cols_3-2{grid-template-columns:3fr 2fr}.g-cols.tablets-cols_1-3{grid-template-columns:1fr 3fr}.g-cols.tablets-cols_3-1{grid-template-columns:3fr 1fr}.g-cols.tablets-cols_1-4{grid-template-columns:1fr 4fr}.g-cols.tablets-cols_4-1{grid-template-columns:4fr 1fr}.g-cols.tablets-cols_1-5{grid-template-columns:1fr 5fr}.g-cols.tablets-cols_5-1{grid-template-columns:5fr 1fr}.g-cols.tablets-cols_1-2-1{grid-template-columns:1fr 2fr 1fr}.g-cols.tablets-cols_1-3-1{grid-template-columns:1fr 3fr 1fr}.g-cols.tablets-cols_1-4-1{grid-template-columns:1fr 4fr 1fr}}@media (max-width:600px){.g-cols.mobiles-cols_1{grid-template-columns:100%}.g-cols.mobiles-cols_1.reversed>div:last-of-type{order:-1}.g-cols.mobiles-cols_2{grid-template-columns:repeat(2,1fr)}.g-cols.mobiles-cols_3{grid-template-columns:repeat(3,1fr)}.g-cols.mobiles-cols_4{grid-template-columns:repeat(4,1fr)}.g-cols.mobiles-cols_5{grid-template-columns:repeat(5,1fr)}.g-cols.mobiles-cols_6{grid-template-columns:repeat(6,1fr)}.g-cols.mobiles-cols_1-2{grid-template-columns:1fr 2fr}.g-cols.mobiles-cols_2-1{grid-template-columns:2fr 1fr}.g-cols.mobiles-cols_2-3{grid-template-columns:2fr 3fr}.g-cols.mobiles-cols_3-2{grid-template-columns:3fr 2fr}.g-cols.mobiles-cols_1-3{grid-template-columns:1fr 3fr}.g-cols.mobiles-cols_3-1{grid-template-columns:3fr 1fr}.g-cols.mobiles-cols_1-4{grid-template-columns:1fr 4fr}.g-cols.mobiles-cols_4-1{grid-template-columns:4fr 1fr}.g-cols.mobiles-cols_1-5{grid-template-columns:1fr 5fr}.g-cols.mobiles-cols_5-1{grid-template-columns:5fr 1fr}.g-cols.mobiles-cols_1-2-1{grid-template-columns:1fr 2fr 1fr}.g-cols.mobiles-cols_1-3-1{grid-template-columns:1fr 3fr 1fr}.g-cols.mobiles-cols_1-4-1{grid-template-columns:1fr 4fr 1fr}.g-cols:not([style*=\"--gap\"]){grid-gap:1.5rem}}@media (max-width:599px){.l-canvas{overflow:hidden}.g-cols.stacking_default.reversed>div:last-of-type{order:-1}.g-cols.stacking_default.via_flex>div:not([class*=\"vc_col-xs\"]){width:100%;margin:0 0 1.5rem}.g-cols.stacking_default.via_grid.mobiles-cols_1{grid-template-columns:100%}.g-cols.stacking_default.via_flex.type_boxes>div,.g-cols.stacking_default.via_flex.reversed>div:first-child,.g-cols.stacking_default.via_flex:not(.reversed)>div:last-child,.g-cols.stacking_default.via_flex>div.has_bg_color{margin-bottom:0}.g-cols.stacking_default.via_flex.type_default>.wpb_column.stretched{margin-left:-1rem;margin-right:-1rem}.g-cols.stacking_default.via_grid.mobiles-cols_1>.wpb_column.stretched,.g-cols.stacking_default.via_flex.type_boxes>.wpb_column.stretched{margin-left:-2.5rem;margin-right:-2.5rem;width:auto}.vc_column-inner.type_sticky>.wpb_wrapper,.vc_column_container.type_sticky>.vc_column-inner{top:0!important}}@media (min-width:600px){body:not(.rtl) .l-section.for_sidebar.at_left>div>.l-sidebar,.rtl .l-section.for_sidebar.at_right>div>.l-sidebar{order:-1}.vc_column_container.type_sticky>.vc_column-inner,.vc_column-inner.type_sticky>.wpb_wrapper{position:-webkit-sticky;position:sticky}.l-section.type_sticky{position:-webkit-sticky;position:sticky;top:0;z-index:11;transition:top 0.3s cubic-bezier(.78,.13,.15,.86) 0.1s}.header_hor .l-header.post_fixed.sticky_auto_hide{z-index:12}.admin-bar .l-section.type_sticky{top:32px}.l-section.type_sticky>.l-section-h{transition:padding-top 0.3s}.header_hor .l-header.pos_fixed:not(.down)~.l-main .l-section.type_sticky:not(:first-of-type){top:var(--header-sticky-height)}.admin-bar.header_hor .l-header.pos_fixed:not(.down)~.l-main .l-section.type_sticky:not(:first-of-type){top:calc( var(--header-sticky-height) + 32px )}.header_hor .l-header.pos_fixed.sticky:not(.down)~.l-main .l-section.type_sticky:first-of-type>.l-section-h{padding-top:var(--header-sticky-height)}.header_hor.headerinpos_bottom .l-header.pos_fixed.sticky:not(.down)~.l-main .l-section.type_sticky:first-of-type>.l-section-h{padding-bottom:var(--header-sticky-height)!important}}@media screen and (min-width:1225px){.g-cols.via_flex.type_default>.wpb_column.stretched:first-of-type{margin-left:min( calc( var(--site-content-width) / 2 + 0px / 2 + 1.5rem - 50vw),-1rem )}.g-cols.via_flex.type_default>.wpb_column.stretched:last-of-type{margin-right:min( calc( var(--site-content-width) / 2 + 0px / 2 + 1.5rem - 50vw),-1rem )}.l-main .alignfull, .w-separator.width_screen,.g-cols.via_grid>.wpb_column.stretched:first-of-type,.g-cols.via_flex.type_boxes>.wpb_column.stretched:first-of-type{margin-left:min( calc( var(--site-content-width) / 2 + 0px / 2 - 50vw ),-2.5rem )}.l-main .alignfull, .w-separator.width_screen,.g-cols.via_grid>.wpb_column.stretched:last-of-type,.g-cols.via_flex.type_boxes>.wpb_column.stretched:last-of-type{margin-right:min( calc( var(--site-content-width) / 2 + 0px / 2 - 50vw ),-2.5rem )}}@media (max-width:600px){.w-form-row.for_submit[style*=btn-size-mobiles] .w-btn{font-size:var(--btn-size-mobiles)!important}}a,button,input[type=submit],.ui-slider-handle{outline:none!important}.w-toplink,.w-header-show{background:rgba(0,0,0,0.3)}.no-touch .w-toplink.active:hover,.no-touch .w-header-show:hover{background:var(--color-content-primary-grad)}button[type=submit]:not(.w-btn),input[type=submit]:not(.w-btn),.us-nav-style_1>*,.navstyle_1>.owl-nav button,.us-btn-style_1{font-size:14px;line-height:1.2!important;font-weight:700;font-style:normal;text-transform:uppercase;letter-spacing:0.08em;border-radius:2em;padding:0.9em 2.3em;background:var(--color-content-secondary);border-color:transparent;color:#ffffff!important}button[type=submit]:not(.w-btn):before,input[type=submit]:not(.w-btn),.us-nav-style_1>*:before,.navstyle_1>.owl-nav button:before,.us-btn-style_1:before{border-width:0px}.no-touch button[type=submit]:not(.w-btn):hover,.no-touch input[type=submit]:not(.w-btn):hover,.us-nav-style_1>span.current,.no-touch .us-nav-style_1>a:hover,.no-touch .navstyle_1>.owl-nav button:hover,.no-touch .us-btn-style_1:hover{background:var(--color-content-heading);border-color:transparent;color:#ffffff!important}.us-nav-style_1>*{min-width:calc(1.2em + 2 * 0.9em)}.us-nav-style_8>*,.navstyle_8>.owl-nav button,.us-btn-style_8{font-size:14px;line-height:1.2!important;font-weight:700;font-style:normal;text-transform:uppercase;letter-spacing:0.08em;border-radius:2em;padding:0.9em 2.3em;background:#27b3b8;border-color:transparent;color:var(--color-header-middle-bg)!important}.us-nav-style_8>*:before,.navstyle_8>.owl-nav button:before,.us-btn-style_8:before{border-width:0px}.us-nav-style_8>span.current,.no-touch .us-nav-style_8>a:hover,.no-touch .navstyle_8>.owl-nav button:hover,.no-touch .us-btn-style_8:hover{background:#1a5e61;border-color:transparent;color:#ffffff!important}.us-nav-style_8>*{min-width:calc(1.2em + 2 * 0.9em)}.us-nav-style_6>*,.navstyle_6>.owl-nav button,.us-btn-style_6{font-size:14px;line-height:1.2!important;font-weight:700;font-style:normal;text-transform:uppercase;letter-spacing:0.08em;border-radius:2em;padding:0.9em 2.3em;background:transparent;border-color:var(--color-content-heading);color:var(--color-content-heading)!important}.us-nav-style_6>*:before,.navstyle_6>.owl-nav button:before,.us-btn-style_6:before{border-width:1px}.us-nav-style_6>span.current,.no-touch .us-nav-style_6>a:hover,.no-touch .navstyle_6>.owl-nav button:hover,.no-touch .us-btn-style_6:hover{background:var(--color-content-heading);border-color:transparent;color:#ffffff!important}.us-nav-style_6>*{min-width:calc(1.2em + 2 * 0.9em)}.us-nav-style_7>*,.navstyle_7>.owl-nav button,.us-btn-style_7{font-size:14px;line-height:1.2!important;font-weight:700;font-style:normal;text-transform:uppercase;letter-spacing:0.08em;border-radius:2em;padding:0.9em 2.3em;background:transparent;border-color:var(--color-content-secondary);color:var(--color-content-secondary)!important}.us-nav-style_7>*:before,.navstyle_7>.owl-nav button:before,.us-btn-style_7:before{border-width:1px}.us-nav-style_7>span.current,.no-touch .us-nav-style_7>a:hover,.no-touch .navstyle_7>.owl-nav button:hover,.no-touch .us-btn-style_7:hover{background:var(--color-content-secondary);border-color:transparent;color:#ffffff!important}.us-nav-style_7>*{min-width:calc(1.2em + 2 * 0.9em)}.us-nav-style_9>*,.navstyle_9>.owl-nav button,.us-btn-style_9{font-size:14px;line-height:1.2!important;font-weight:700;font-style:normal;text-transform:uppercase;letter-spacing:0.08em;border-radius:2em;padding:0.9em 2.3em;background:transparent;border-color:#27b3b8;color:#27b3b8!important}.us-nav-style_9>*:before,.navstyle_9>.owl-nav button:before,.us-btn-style_9:before{border-width:1px}.us-nav-style_9>span.current,.no-touch .us-nav-style_9>a:hover,.no-touch .navstyle_9>.owl-nav button:hover,.no-touch .us-btn-style_9:hover{background:#27b3b8;border-color:transparent;color:#ffffff!important}.us-nav-style_9>*{min-width:calc(1.2em + 2 * 0.9em)}.us-nav-style_2>*,.navstyle_2>.owl-nav button,.us-btn-style_2{font-size:12px;line-height:1.20!important;font-weight:500;font-style:normal;text-transform:none;letter-spacing:0.02em;border-radius:0.0em;padding:0.4em 0em;background:transparent;border-color:transparent;color:var(--color-content-secondary)!important}.us-nav-style_2>*:before,.navstyle_2>.owl-nav button:before,.us-btn-style_2:before{border-width:0px}.us-nav-style_2>span.current,.no-touch .us-nav-style_2>a:hover,.no-touch .navstyle_2>.owl-nav button:hover,.no-touch .us-btn-style_2:hover{background:transparent;border-color:transparent;color:var(--color-content-link-hover)!important}.us-nav-style_2>*{min-width:calc(1.20em + 2 * 0.4em)}.us-nav-style_5>*,.navstyle_5>.owl-nav button,.us-btn-style_5{font-size:14px;line-height:1.2!important;font-weight:800;font-style:normal;text-transform:uppercase;letter-spacing:0.06em;border-radius:2em;padding:0.6em 1.6em;background:var(--color-content-secondary);border-color:transparent;color:#ffffff!important}.us-nav-style_5>*:before,.navstyle_5>.owl-nav button:before,.us-btn-style_5:before{border-width:0px}.us-nav-style_5>span.current,.no-touch .us-nav-style_5>a:hover,.no-touch .navstyle_5>.owl-nav button:hover,.no-touch .us-btn-style_5:hover{background:#94092d;border-color:transparent;color:#ffffff!important}.us-nav-style_5>*{min-width:calc(1.2em + 2 * 0.6em)}:root{--inputs-font-family:inherit;--inputs-font-size:0.8rem;--inputs-font-weight:400;--inputs-letter-spacing:0em;--inputs-text-transform:none;--inputs-height:2.1rem;--inputs-padding:0.6rem;--inputs-checkbox-size:1.5em;--inputs-border-width:0px;--inputs-border-radius:0;--inputs-background:var(--color-alt-content-bg-alt);--inputs-border-color:var(--color-content-border);--inputs-text-color:var(--color-content-text);--inputs-box-shadow:1px 1px 0px 0px rgba(0,0,0,0.08) inset;--inputs-focus-background:var(--color-content-bg-alt);--inputs-focus-border-color:var(--color-content-border);--inputs-focus-text-color:var(--color-content-text);--inputs-focus-box-shadow:0px 0px 0px 2px var(--color-content-primary)}.color_alternate input:not([type=submit]),.color_alternate textarea,.color_alternate select{border-color:var(--color-alt-content-border)}.color_footer-top input:not([type=submit]),.color_footer-top textarea,.color_footer-top select{border-color:var(--color-subfooter-border)}.color_footer-bottom input:not([type=submit]),.color_footer-bottom textarea,.color_footer-bottom select{border-color:var(--color-footer-border)}.color_alternate input:not([type=submit]),.color_alternate textarea,.color_alternate select,.color_alternate .w-form-row-field>i,.color_alternate .w-form-row-field:after,.color_alternate .widget_search form:after,.color_footer-top input:not([type=submit]),.color_footer-top textarea,.color_footer-top select,.color_footer-top .w-form-row-field>i,.color_footer-top .w-form-row-field:after,.color_footer-top .widget_search form:after,.color_footer-bottom input:not([type=submit]),.color_footer-bottom textarea,.color_footer-bottom select,.color_footer-bottom .w-form-row-field>i,.color_footer-bottom .w-form-row-field:after,.color_footer-bottom .widget_search form:after{color:inherit}.leaflet-default-icon-path{background-image:url(https://batazu.digitalpath.pt/wp-content/themes/Impreza/common/css/vendor/images/marker-icon.png)}", "on");
INSERT INTO `wp_options` VALUES("211", "cpt_custom_post_types", "a:1:{i:8;a:23:{s:9:\"post_type\";s:10:\"slide_home\";s:8:\"supports\";a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";}s:12:\"hierarchical\";b:0;s:10:\"can_export\";b:1;s:16:\"delete_with_user\";b:0;s:10:\"taxonomies\";a:0:{}s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:19:\"exclude_from_search\";b:0;s:15:\"capability_type\";s:4:\"page\";s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:17:\"show_in_admin_bar\";b:1;s:13:\"menu_position\";i:5;s:9:\"menu_icon\";s:16:\"dashicons-slides\";s:11:\"has_archive\";b:0;s:7:\"rewrite\";b:1;s:9:\"query_var\";s:10:\"slide_home\";s:12:\"show_in_rest\";b:1;s:5:\"label\";s:11:\"Slide_homep\";s:6:\"labels\";a:3:{s:13:\"singular_name\";s:5:\"Slide\";s:9:\"all_items\";s:6:\"Slides\";s:4:\"name\";s:11:\"Slide_homep\";}s:6:\"status\";s:7:\"publish\";}}", "yes");
INSERT INTO `wp_options` VALUES("212", "cpt_needs_rewrite_rules_update", "", "yes");
INSERT INTO `wp_options` VALUES("223", "duplicator_settings", "a:19:{s:7:\"version\";s:8:\"1.5.11.2\";s:18:\"uninstall_settings\";s:1:\"1\";s:15:\"uninstall_files\";s:1:\"1\";s:13:\"package_debug\";s:1:\"0\";s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";s:1:\"0\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"0\";s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:1;s:21:\"unhook_third_party_js\";s:0:\"\";s:22:\"unhook_third_party_css\";s:0:\"\";s:17:\"active_package_id\";i:1;s:14:\"usage_tracking\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("224", "duplicator_version_plugin", "1.5.11.2", "yes");
INSERT INTO `wp_options` VALUES("238", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-01-23 09:26:03\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"5.7.44\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20230214_midtemplate\";s:4:\"Hash\";s:35:\"c40edbb8bb5e7b181763_20250123092603\";s:8:\"NameHash\";s:56:\"20230214_midtemplate_c40edbb8bb5e7b181763_20250123092603\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:66:\"20230214_midtemplate_c40edbb8bb5e7b181763_20250123092603_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:33:\"/home/wwwumdom/public_html/batazu\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1774;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:12319;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-01-23 09:26:03\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:6:\"5.7.44\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20230214_midtemplate\";s:4:\"Hash\";s:35:\"c40edbb8bb5e7b181763_20250123092603\";s:8:\"NameHash\";s:56:\"20230214_midtemplate_c40edbb8bb5e7b181763_20250123092603\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:47:\"/home/wwwumdom/public_html/batazu/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server (GPL)\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:42:\"/home/wwwumdom/public_html/batazu/wp-admin\";i:1;s:45:\"/home/wwwumdom/public_html/batazu/wp-includes\";i:2;s:54:\"/home/wwwumdom/public_html/batazu/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:33:\"/home/wwwumdom/public_html/batazu\";i:1;s:33:\"/home/wwwumdom/public_html/batazu\";i:2;s:44:\"/home/wwwumdom/public_html/batazu/wp-content\";i:3;s:52:\"/home/wwwumdom/public_html/batazu/wp-content/uploads\";i:4;s:52:\"/home/wwwumdom/public_html/batazu/wp-content/plugins\";i:5;s:55:\"/home/wwwumdom/public_html/batazu/wp-content/mu-plugins\";i:6;s:51:\"/home/wwwumdom/public_html/batazu/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:65:\"/home/wwwumdom/public_html/batazu/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `wp_options` VALUES("264", "ihaf_activated", "a:2:{s:6:\"wpcode\";i:1676386141;s:7:\"version\";s:7:\"2.2.3.1\";}", "yes");
INSERT INTO `wp_options` VALUES("265", "wpcode_snippets", "a:1:{s:15:\"after_paragraph\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("266", "wpcode_admin_notices", "a:2:{s:14:\"review_request\";a:2:{s:4:\"time\";i:1676386141;s:9:\"dismissed\";b:0;}s:15:\"suggest_plugins\";a:2:{s:4:\"time\";i:1733862458;s:9:\"dismissed\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("527", "duplicator_dismissed_admin_notices", "a:1:{s:14:\"review_request\";a:1:{s:4:\"time\";i:1681150312;}}", "yes");
INSERT INTO `wp_options` VALUES("531", "usof_options_Impreza-child", "a:356:{s:16:\"maintenance_mode\";i:0;s:22:\"maintenance_mode_alert\";s:0:\"\";s:16:\"maintenance_page\";s:0:\"\";s:15:\"maintenance_503\";i:0;s:9:\"site_icon\";s:0:\"\";s:10:\"dark_theme\";s:4:\"none\";s:9:\"preloader\";s:8:\"disabled\";s:15:\"preloader_image\";s:0:\"\";s:15:\"img_placeholder\";s:86:\"https://batazu.digitalpath.pt/wp-content/plugins/us-core/assets/images/placeholder.svg\";s:13:\"ripple_effect\";i:0;s:15:\"rounded_corners\";i:1;s:15:\"links_underline\";i:0;s:22:\"keyboard_accessibility\";i:0;s:11:\"back_to_top\";i:1;s:25:\"wrapper_back_to_top_start\";s:0:\"\";s:17:\"back_to_top_style\";s:0:\"\";s:15:\"back_to_top_pos\";s:5:\"right\";s:17:\"back_to_top_color\";s:15:\"rgba(0,0,0,0.3)\";s:19:\"back_to_top_display\";s:5:\"100vh\";s:23:\"wrapper_back_to_top_end\";s:0:\"\";s:13:\"cookie_notice\";i:0;s:20:\"wrapper_cookie_start\";s:0:\"\";s:14:\"cookie_message\";s:106:\"This website uses cookies to improve your experience. If you continue to use this site, you agree with it.\";s:14:\"cookie_privacy\";s:0:\"\";s:18:\"cookie_message_pos\";s:6:\"bottom\";s:16:\"cookie_btn_label\";s:2:\"Ok\";s:16:\"cookie_btn_style\";s:1:\"1\";s:18:\"wrapper_cookie_end\";s:0:\"\";s:22:\"smooth_scroll_duration\";s:6:\"1000ms\";s:13:\"canvas_layout\";s:4:\"wide\";s:13:\"color_body_bg\";s:15:\"_content_bg_alt\";s:13:\"body_bg_image\";s:0:\"\";s:21:\"wrapper_body_bg_start\";s:0:\"\";s:18:\"body_bg_image_size\";s:5:\"cover\";s:20:\"body_bg_image_repeat\";s:6:\"repeat\";s:22:\"body_bg_image_position\";s:8:\"top left\";s:24:\"body_bg_image_attachment\";i:1;s:19:\"wrapper_body_bg_end\";s:0:\"\";s:17:\"site_canvas_width\";s:6:\"1300px\";s:18:\"site_content_width\";s:6:\"1140px\";s:13:\"sidebar_width\";s:3:\"25%\";s:10:\"row_height\";s:6:\"medium\";s:17:\"row_height_custom\";s:5:\"5vmax\";s:18:\"text_bottom_indent\";s:4:\"0rem\";s:13:\"footer_reveal\";i:0;s:21:\"disable_effects_width\";s:5:\"900px\";s:22:\"columns_stacking_width\";s:5:\"600px\";s:18:\"laptops_breakpoint\";s:6:\"1380px\";s:18:\"tablets_breakpoint\";s:6:\"1024px\";s:18:\"mobiles_breakpoint\";s:5:\"600px\";s:11:\"search_page\";s:7:\"default\";s:28:\"exclude_post_types_in_search\";s:0:\"\";s:10:\"posts_page\";s:7:\"default\";s:8:\"page_404\";s:7:\"default\";s:10:\"h_defaults\";s:0:\"\";s:9:\"header_id\";s:0:\"\";s:11:\"titlebar_id\";s:0:\"\";s:10:\"content_id\";s:0:\"\";s:10:\"sidebar_id\";s:0:\"\";s:11:\"sidebar_pos\";s:5:\"right\";s:9:\"footer_id\";s:0:\"\";s:6:\"h_post\";s:0:\"\";s:14:\"header_post_id\";s:12:\"__defaults__\";s:16:\"titlebar_post_id\";s:12:\"__defaults__\";s:15:\"content_post_id\";s:12:\"__defaults__\";s:15:\"sidebar_post_id\";s:12:\"__defaults__\";s:16:\"sidebar_post_pos\";s:5:\"right\";s:14:\"footer_post_id\";s:12:\"__defaults__\";s:18:\"h_archive_defaults\";s:0:\"\";s:17:\"header_archive_id\";s:12:\"__defaults__\";s:19:\"titlebar_archive_id\";s:12:\"__defaults__\";s:18:\"content_archive_id\";s:0:\"\";s:18:\"sidebar_archive_id\";s:12:\"__defaults__\";s:19:\"sidebar_archive_pos\";s:5:\"right\";s:17:\"footer_archive_id\";s:12:\"__defaults__\";s:14:\"h_tax_category\";s:0:\"\";s:22:\"header_tax_category_id\";s:12:\"__defaults__\";s:24:\"titlebar_tax_category_id\";s:12:\"__defaults__\";s:23:\"content_tax_category_id\";s:12:\"__defaults__\";s:23:\"sidebar_tax_category_id\";s:12:\"__defaults__\";s:24:\"sidebar_tax_category_pos\";s:5:\"right\";s:22:\"footer_tax_category_id\";s:12:\"__defaults__\";s:14:\"h_tax_post_tag\";s:0:\"\";s:22:\"header_tax_post_tag_id\";s:12:\"__defaults__\";s:24:\"titlebar_tax_post_tag_id\";s:12:\"__defaults__\";s:23:\"content_tax_post_tag_id\";s:12:\"__defaults__\";s:23:\"sidebar_tax_post_tag_id\";s:12:\"__defaults__\";s:24:\"sidebar_tax_post_tag_pos\";s:5:\"right\";s:22:\"footer_tax_post_tag_id\";s:12:\"__defaults__\";s:17:\"h_tax_post_format\";s:0:\"\";s:25:\"header_tax_post_format_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_post_format_id\";s:12:\"__defaults__\";s:26:\"content_tax_post_format_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_post_format_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_post_format_pos\";s:5:\"right\";s:25:\"footer_tax_post_format_id\";s:12:\"__defaults__\";s:9:\"h_authors\";s:0:\"\";s:16:\"header_author_id\";s:12:\"__defaults__\";s:18:\"titlebar_author_id\";s:12:\"__defaults__\";s:17:\"content_author_id\";s:12:\"__defaults__\";s:17:\"sidebar_author_id\";s:12:\"__defaults__\";s:18:\"sidebar_author_pos\";s:5:\"right\";s:16:\"footer_author_id\";s:12:\"__defaults__\";s:19:\"color_header_top_bg\";s:34:\"linear-gradient(0deg,#f5f5f5,#fff)\";s:21:\"color_header_top_text\";s:4:\"#333\";s:27:\"color_header_top_text_hover\";s:7:\"#e95095\";s:22:\"color_header_middle_bg\";s:4:\"#fff\";s:24:\"color_header_middle_text\";s:4:\"#333\";s:30:\"color_header_middle_text_hover\";s:7:\"#e95095\";s:29:\"color_header_transparent_text\";s:4:\"#fff\";s:35:\"color_header_transparent_text_hover\";s:4:\"#fff\";s:20:\"color_chrome_toolbar\";s:7:\"#f5f5f5\";s:16:\"color_content_bg\";s:4:\"#fff\";s:20:\"color_content_bg_alt\";s:7:\"#f5f5f5\";s:20:\"color_content_border\";s:7:\"#e8e8e8\";s:21:\"color_content_heading\";s:7:\"#1a1a1a\";s:18:\"color_content_text\";s:4:\"#333\";s:18:\"color_content_link\";s:7:\"#e95095\";s:24:\"color_content_link_hover\";s:7:\"#7049ba\";s:21:\"color_content_primary\";s:39:\"linear-gradient(135deg,#e95095,#7049ba)\";s:23:\"color_content_secondary\";s:39:\"linear-gradient(135deg,#7049ba,#e95095)\";s:19:\"color_content_faded\";s:4:\"#999\";s:21:\"color_content_overlay\";s:16:\"rgba(0,0,0,0.75)\";s:20:\"color_alt_content_bg\";s:7:\"#f5f5f5\";s:24:\"color_alt_content_bg_alt\";s:4:\"#fff\";s:24:\"color_alt_content_border\";s:4:\"#ddd\";s:25:\"color_alt_content_heading\";s:7:\"#1a1a1a\";s:22:\"color_alt_content_text\";s:4:\"#333\";s:22:\"color_alt_content_link\";s:7:\"#e95095\";s:28:\"color_alt_content_link_hover\";s:7:\"#7049ba\";s:25:\"color_alt_content_primary\";s:39:\"linear-gradient(135deg,#e95095,#7049ba)\";s:27:\"color_alt_content_secondary\";s:39:\"linear-gradient(135deg,#7049ba,#e95095)\";s:23:\"color_alt_content_faded\";s:4:\"#999\";s:25:\"color_alt_content_overlay\";s:53:\"linear-gradient(135deg,#e95095,rgba(233,80,149,0.75))\";s:15:\"color_footer_bg\";s:4:\"#222\";s:19:\"color_footer_bg_alt\";s:7:\"#1a1a1a\";s:19:\"color_footer_border\";s:4:\"#333\";s:20:\"color_footer_heading\";s:4:\"#ccc\";s:17:\"color_footer_text\";s:4:\"#999\";s:17:\"color_footer_link\";s:4:\"#ccc\";s:23:\"color_footer_link_hover\";s:7:\"#e95095\";s:18:\"color_subfooter_bg\";s:7:\"#1a1a1a\";s:22:\"color_subfooter_bg_alt\";s:4:\"#222\";s:22:\"color_subfooter_border\";s:7:\"#282828\";s:23:\"color_subfooter_heading\";s:4:\"#ccc\";s:20:\"color_subfooter_text\";s:4:\"#bbb\";s:20:\"color_subfooter_link\";s:4:\"#fff\";s:26:\"color_subfooter_link_hover\";s:7:\"#e95095\";s:12:\"style_scheme\";i:0;s:26:\"change_header_colors_start\";s:0:\"\";s:10:\"h_colors_1\";s:0:\"\";s:27:\"color_header_transparent_bg\";s:11:\"transparent\";s:24:\"change_header_colors_end\";s:0:\"\";s:30:\"change_header_alt_colors_start\";s:0:\"\";s:10:\"h_colors_2\";s:0:\"\";s:31:\"color_header_top_transparent_bg\";s:15:\"rgba(0,0,0,0.2)\";s:33:\"color_header_top_transparent_text\";s:22:\"rgba(255,255,255,0.66)\";s:39:\"color_header_top_transparent_text_hover\";s:4:\"#fff\";s:28:\"change_header_alt_colors_end\";s:0:\"\";s:27:\"change_content_colors_start\";s:0:\"\";s:10:\"h_colors_3\";s:0:\"\";s:25:\"change_content_colors_end\";s:0:\"\";s:31:\"change_alt_content_colors_start\";s:0:\"\";s:10:\"h_colors_4\";s:0:\"\";s:29:\"change_alt_content_colors_end\";s:0:\"\";s:26:\"change_footer_colors_start\";s:0:\"\";s:10:\"h_colors_6\";s:0:\"\";s:24:\"change_footer_colors_end\";s:0:\"\";s:29:\"change_subfooter_colors_start\";s:0:\"\";s:10:\"h_colors_5\";s:0:\"\";s:27:\"change_subfooter_colors_end\";s:0:\"\";s:16:\"body_font_family\";s:15:\"Georgia, serif|\";s:13:\"body_fontsize\";s:4:\"18px\";s:20:\"body_fontsize_mobile\";s:4:\"16px\";s:15:\"body_lineheight\";s:4:\"28px\";s:22:\"body_lineheight_mobile\";s:4:\"28px\";s:14:\"h1_font_family\";s:5:\"none|\";s:11:\"h1_fontsize\";s:16:\"max( 4rem, 4vw )\";s:18:\"h1_fontsize_mobile\";s:0:\"\";s:13:\"h1_lineheight\";s:3:\"1.2\";s:16:\"h1_letterspacing\";i:0;s:13:\"h1_fontweight\";s:3:\"400\";s:16:\"h1_bottom_indent\";s:5:\"0.6em\";s:8:\"h1_color\";s:0:\"\";s:16:\"h1_texttransform\";s:4:\"none\";s:17:\"h1_color_override\";s:0:\"\";s:12:\"h1_fontstyle\";s:0:\"\";s:14:\"h2_font_family\";s:7:\"get_h1|\";s:11:\"h2_fontsize\";s:20:\"max( 2.3rem, 2.3vw )\";s:18:\"h2_fontsize_mobile\";s:0:\"\";s:13:\"h2_lineheight\";s:3:\"1.2\";s:16:\"h2_letterspacing\";i:0;s:13:\"h2_fontweight\";s:3:\"400\";s:16:\"h2_bottom_indent\";s:5:\"0.6em\";s:8:\"h2_color\";s:0:\"\";s:16:\"h2_texttransform\";s:4:\"none\";s:17:\"h2_color_override\";s:0:\"\";s:12:\"h2_fontstyle\";s:0:\"\";s:14:\"h3_font_family\";s:7:\"get_h1|\";s:11:\"h3_fontsize\";s:20:\"max( 1.7rem, 1.7vw )\";s:18:\"h3_fontsize_mobile\";s:0:\"\";s:13:\"h3_lineheight\";s:3:\"1.2\";s:16:\"h3_letterspacing\";i:0;s:13:\"h3_fontweight\";s:3:\"400\";s:16:\"h3_bottom_indent\";s:5:\"0.6em\";s:8:\"h3_color\";s:0:\"\";s:16:\"h3_texttransform\";s:4:\"none\";s:17:\"h3_color_override\";s:0:\"\";s:12:\"h3_fontstyle\";s:0:\"\";s:14:\"h4_font_family\";s:7:\"get_h1|\";s:11:\"h4_fontsize\";s:20:\"max( 1.5rem, 1.5vw )\";s:18:\"h4_fontsize_mobile\";s:0:\"\";s:13:\"h4_lineheight\";s:3:\"1.2\";s:16:\"h4_letterspacing\";i:0;s:13:\"h4_fontweight\";s:3:\"400\";s:16:\"h4_bottom_indent\";s:5:\"0.6em\";s:8:\"h4_color\";s:0:\"\";s:16:\"h4_texttransform\";s:4:\"none\";s:17:\"h4_color_override\";s:0:\"\";s:12:\"h4_fontstyle\";s:0:\"\";s:14:\"h5_font_family\";s:7:\"get_h1|\";s:11:\"h5_fontsize\";s:20:\"max( 1.3rem, 1.3vw )\";s:18:\"h5_fontsize_mobile\";s:0:\"\";s:13:\"h5_lineheight\";s:3:\"1.2\";s:16:\"h5_letterspacing\";i:0;s:13:\"h5_fontweight\";s:3:\"400\";s:16:\"h5_bottom_indent\";s:5:\"0.6em\";s:8:\"h5_color\";s:0:\"\";s:16:\"h5_texttransform\";s:4:\"none\";s:17:\"h5_color_override\";s:0:\"\";s:12:\"h5_fontstyle\";s:0:\"\";s:14:\"h6_font_family\";s:7:\"get_h1|\";s:11:\"h6_fontsize\";s:20:\"max( 1.2rem, 1.2vw )\";s:18:\"h6_fontsize_mobile\";s:0:\"\";s:13:\"h6_lineheight\";s:3:\"1.2\";s:16:\"h6_letterspacing\";i:0;s:13:\"h6_fontweight\";s:3:\"400\";s:16:\"h6_bottom_indent\";s:5:\"0.6em\";s:8:\"h6_color\";s:0:\"\";s:16:\"h6_texttransform\";s:4:\"none\";s:17:\"h6_color_override\";s:0:\"\";s:12:\"h6_fontstyle\";s:0:\"\";s:14:\"h_typography_3\";s:0:\"\";s:11:\"custom_font\";a:0:{}s:14:\"h_typography_4\";s:0:\"\";s:14:\"uploaded_fonts\";a:0:{}s:14:\"h_typography_5\";s:0:\"\";s:12:\"font_display\";s:4:\"swap\";s:7:\"buttons\";a:2:{i:0;a:19:{s:2:\"id\";i:1;s:4:\"name\";s:14:\"Default Button\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:16:\"_content_primary\";s:14:\"color_bg_hover\";s:18:\"_content_secondary\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:4:\"#fff\";s:16:\"color_text_hover\";s:4:\"#fff\";s:4:\"font\";s:7:\"default\";s:10:\"text_style\";s:0:\"\";s:9:\"font_size\";s:4:\"16px\";s:11:\"line_height\";d:1.2;s:11:\"font_weight\";i:700;s:14:\"letter_spacing\";i:0;s:6:\"height\";s:5:\"1.0em\";s:5:\"width\";s:5:\"2.0em\";s:13:\"border_radius\";s:5:\"0.3em\";s:12:\"border_width\";s:3:\"0px\";}i:1;a:19:{s:2:\"id\";i:2;s:4:\"name\";s:8:\"Button 2\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:15:\"_content_border\";s:14:\"color_bg_hover\";s:13:\"_content_text\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:13:\"_content_text\";s:16:\"color_text_hover\";s:11:\"_content_bg\";s:4:\"font\";s:7:\"default\";s:10:\"text_style\";s:0:\"\";s:9:\"font_size\";s:4:\"16px\";s:11:\"line_height\";d:1.2;s:11:\"font_weight\";i:700;s:14:\"letter_spacing\";i:0;s:6:\"height\";s:5:\"1.0em\";s:5:\"width\";s:5:\"2.0em\";s:13:\"border_radius\";s:5:\"0.3em\";s:12:\"border_width\";s:3:\"0px\";}}s:12:\"input_fields\";a:1:{i:0;a:26:{s:8:\"color_bg\";s:15:\"_content_bg_alt\";s:14:\"color_bg_focus\";s:0:\"\";s:12:\"color_border\";s:15:\"_content_border\";s:18:\"color_border_focus\";s:0:\"\";s:10:\"color_text\";s:13:\"_content_text\";s:16:\"color_text_focus\";s:0:\"\";s:12:\"color_shadow\";s:16:\"rgba(0,0,0,0.08)\";s:18:\"color_shadow_focus\";s:16:\"_content_primary\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"1px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:1:\"1\";s:21:\"shadow_focus_offset_h\";s:3:\"0px\";s:21:\"shadow_focus_offset_v\";s:3:\"0px\";s:17:\"shadow_focus_blur\";s:3:\"0px\";s:19:\"shadow_focus_spread\";s:3:\"2px\";s:18:\"shadow_focus_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:9:\"font_size\";s:4:\"1rem\";s:11:\"font_weight\";s:3:\"400\";s:14:\"letter_spacing\";s:3:\"0em\";s:6:\"height\";s:6:\"2.8rem\";s:7:\"padding\";s:6:\"0.8rem\";s:13:\"border_radius\";s:0:\"\";s:12:\"border_width\";s:3:\"0px\";}}s:26:\"portfolio_breadcrumbs_page\";s:0:\"\";s:14:\"portfolio_slug\";s:9:\"portfolio\";s:23:\"portfolio_category_slug\";s:18:\"portfolio_category\";s:18:\"portfolio_tag_slug\";s:13:\"portfolio_tag\";s:16:\"portfolio_rename\";i:0;s:20:\"portfolio_label_name\";s:9:\"Portfolio\";s:29:\"portfolio_label_singular_name\";s:14:\"Portfolio Page\";s:23:\"portfolio_label_add_new\";s:18:\"Add Portfolio Page\";s:25:\"portfolio_label_edit_item\";s:19:\"Edit Portfolio Page\";s:24:\"portfolio_label_category\";s:20:\"Portfolio Categories\";s:19:\"portfolio_label_tag\";s:14:\"Portfolio Tags\";s:6:\"h_more\";s:0:\"\";s:12:\"shop_catalog\";i:0;s:22:\"shop_primary_btn_style\";s:1:\"1\";s:24:\"shop_secondary_btn_style\";s:1:\"2\";s:15:\"product_gallery\";s:6:\"slider\";s:29:\"wrapper_product_gallery_start\";s:0:\"\";s:26:\"product_gallery_thumbs_pos\";s:6:\"bottom\";s:27:\"product_gallery_thumbs_cols\";s:1:\"4\";s:28:\"product_gallery_thumbs_width\";s:4:\"6rem\";s:26:\"product_gallery_thumbs_gap\";s:3:\"4px\";s:23:\"product_gallery_options\";s:13:\"zoom,lightbox\";s:27:\"wrapper_product_gallery_end\";s:0:\"\";s:9:\"h_product\";s:0:\"\";s:17:\"header_product_id\";s:12:\"__defaults__\";s:19:\"titlebar_product_id\";s:12:\"__defaults__\";s:18:\"content_product_id\";s:0:\"\";s:18:\"sidebar_product_id\";s:12:\"__defaults__\";s:19:\"sidebar_product_pos\";s:5:\"right\";s:17:\"footer_product_id\";s:12:\"__defaults__\";s:6:\"h_shop\";s:0:\"\";s:14:\"header_shop_id\";s:12:\"__defaults__\";s:16:\"titlebar_shop_id\";s:12:\"__defaults__\";s:15:\"content_shop_id\";s:0:\"\";s:18:\"wrapper_shop_start\";s:0:\"\";s:12:\"shop_columns\";s:1:\"3\";s:16:\"wrapper_shop_end\";s:0:\"\";s:15:\"sidebar_shop_id\";s:12:\"__defaults__\";s:16:\"sidebar_shop_pos\";s:5:\"right\";s:14:\"footer_shop_id\";s:12:\"__defaults__\";s:7:\"h_order\";s:0:\"\";s:16:\"content_order_id\";s:0:\"\";s:6:\"h_cart\";s:0:\"\";s:9:\"shop_cart\";s:7:\"compact\";s:19:\"product_related_qty\";s:1:\"3\";s:15:\"used_icons_info\";s:0:\"\";s:9:\"h_icons_2\";s:0:\"\";s:9:\"icons_fas\";s:7:\"default\";s:21:\"icons_fas_custom_font\";s:0:\"\";s:9:\"icons_far\";s:7:\"default\";s:21:\"icons_far_custom_font\";s:0:\"\";s:9:\"icons_fal\";s:7:\"default\";s:21:\"icons_fal_custom_font\";s:0:\"\";s:9:\"icons_fad\";s:7:\"default\";s:21:\"icons_fad_custom_font\";s:0:\"\";s:9:\"icons_fab\";s:7:\"default\";s:21:\"icons_fab_custom_font\";s:0:\"\";s:14:\"icons_material\";s:7:\"default\";s:26:\"icons_material_custom_font\";s:0:\"\";s:18:\"fallback_icon_font\";i:1;s:13:\"img_size_info\";s:0:\"\";s:13:\"h_image_sizes\";s:0:\"\";s:8:\"img_size\";a:0:{}s:14:\"h_more_options\";s:0:\"\";s:24:\"big_image_size_threshold\";s:6:\"2560px\";s:20:\"delete_unused_images\";i:0;s:12:\"h_advanced_1\";s:0:\"\";s:12:\"live_builder\";i:1;s:17:\"section_templates\";i:1;s:19:\"grid_columns_layout\";i:1;s:12:\"block_editor\";i:0;s:23:\"enable_sidebar_titlebar\";i:0;s:31:\"enable_page_blocks_for_sidebars\";i:0;s:16:\"enable_portfolio\";i:1;s:19:\"enable_testimonials\";i:1;s:14:\"media_category\";i:1;s:10:\"og_enabled\";i:1;s:13:\"schema_markup\";i:1;s:12:\"h_advanced_2\";s:0:\"\";s:13:\"gmaps_api_key\";s:0:\"\";s:15:\"facebook_app_id\";s:0:\"\";s:22:\"grid_filter_url_prefix\";s:0:\"\";s:21:\"grid_order_url_prefix\";s:0:\"\";s:12:\"h_advanced_3\";s:0:\"\";s:17:\"keep_url_protocol\";i:1;s:22:\"disable_jquery_migrate\";i:1;s:13:\"jquery_footer\";i:1;s:12:\"ajax_load_js\";i:1;s:16:\"disable_extra_vc\";i:1;s:15:\"optimize_assets\";i:0;s:21:\"optimize_assets_alert\";s:0:\"\";s:21:\"optimize_assets_start\";s:0:\"\";s:6:\"assets\";a:56:{s:12:\"font-awesome\";i:1;s:20:\"font-awesome-duotone\";i:1;s:9:\"actionbox\";i:1;s:9:\"animation\";i:1;s:7:\"buttons\";i:1;s:8:\"carousel\";i:1;s:6:\"charts\";i:1;s:7:\"columns\";i:1;s:8:\"comments\";i:1;s:8:\"contacts\";i:1;s:7:\"counter\";i:1;s:8:\"dropdown\";i:1;s:5:\"forms\";i:1;s:7:\"flipbox\";i:1;s:5:\"gmaps\";i:1;s:4:\"grid\";i:1;s:11:\"grid_filter\";i:1;s:10:\"grid_order\";i:1;s:14:\"grid_templates\";i:1;s:15:\"grid_pagination\";i:1;s:10:\"grid_popup\";i:1;s:6:\"header\";i:1;s:12:\"hor_parallax\";i:1;s:8:\"hwrapper\";i:1;s:7:\"iconbox\";i:1;s:5:\"image\";i:1;s:13:\"image_gallery\";i:1;s:12:\"image_slider\";i:1;s:7:\"ibanner\";i:1;s:5:\"itext\";i:1;s:5:\"login\";i:1;s:14:\"magnific_popup\";i:1;s:4:\"menu\";i:1;s:7:\"message\";i:1;s:5:\"lmaps\";i:1;s:8:\"scroller\";i:1;s:6:\"person\";i:1;s:9:\"preloader\";i:1;s:5:\"print\";i:1;s:5:\"popup\";i:1;s:13:\"post_elements\";i:1;s:15:\"post_navigation\";i:1;s:7:\"pricing\";i:1;s:7:\"progbar\";i:1;s:6:\"scroll\";i:1;s:6:\"search\";i:1;s:9:\"separator\";i:1;s:7:\"sharing\";i:1;s:11:\"simple_menu\";i:1;s:7:\"socials\";i:1;s:4:\"tabs\";i:1;s:4:\"text\";i:1;s:5:\"video\";i:1;s:12:\"ver_parallax\";i:1;s:8:\"vwrapper\";i:1;s:10:\"wp_widgets\";i:1;}s:19:\"optimize_assets_end\";s:0:\"\";s:18:\"include_gfonts_css\";i:0;s:10:\"custom_css\";s:0:\"\";s:16:\"custom_html_head\";s:0:\"\";s:11:\"custom_html\";s:0:\"\";s:8:\"of_reset\";s:0:\"\";s:9:\"of_backup\";s:0:\"\";s:11:\"of_transfer\";s:0:\"\";s:11:\"white_label\";i:0;s:22:\"white_label_theme_name\";s:0:\"\";s:28:\"white_label_theme_screenshot\";s:0:\"\";s:22:\"white_label_theme_icon\";s:0:\"\";s:22:\"white_label_login_icon\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("532", "us_db_version", "8.32.1", "on");
INSERT INTO `wp_options` VALUES("536", "usof_color_palette_Impreza-child", "a:8:{i:0;s:39:\"linear-gradient(135deg,#e95095,#7049ba)\";i:1;s:39:\"linear-gradient(135deg,#7049ba,#e95095)\";i:2;s:7:\"#1a1a1a\";i:3;s:4:\"#333\";i:4;s:4:\"#999\";i:5;s:7:\"#e8e8e8\";i:6;s:7:\"#f5f5f5\";i:7;s:4:\"#fff\";}", "yes");
INSERT INTO `wp_options` VALUES("541", "theme_mods_makeitdigital", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:12:\"us_main_menu\";i:27;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1720435538;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:15:\"default_sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}}}}", "on");
INSERT INTO `wp_options` VALUES("548", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wp_options` VALUES("549", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wp_options` VALUES("702", "theme_mods_Impreza", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:12:\"us_main_menu\";i:0;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1721660003;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:15:\"default_sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}}}}", "off");
INSERT INTO `wp_options` VALUES("708", "us_addons_version", "8.32.1", "yes");
INSERT INTO `wp_options` VALUES("718", "us_license_activated", "1", "yes");
INSERT INTO `wp_options` VALUES("719", "us_license_secret", "egjmowCIJKLPVW69", "yes");
INSERT INTO `wp_options` VALUES("814", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:27:\"password-protected/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:5:\"2.9.0\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1732115369;s:11:\"plugin_path\";s:41:\"password-protected/password-protected.php\";}}s:7:\"abspath\";s:34:\"/home/wwwumdom/public_html/batazu/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:41:\"password-protected/password-protected.php\";s:8:\"sdk_path\";s:27:\"password-protected/freemius\";s:7:\"version\";s:5:\"2.9.0\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1732115369;}}", "yes");
INSERT INTO `wp_options` VALUES("815", "fs_debug_mode", "", "yes");
INSERT INTO `wp_options` VALUES("816", "fs_accounts", "a:8:{s:21:\"id_slug_type_path_map\";a:1:{i:12503;a:3:{s:4:\"slug\";s:23:\"password-protected-free\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:41:\"password-protected/password-protected.php\";}}s:11:\"plugin_data\";a:1:{s:23:\"password-protected-free\";a:18:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:41:\"password-protected/password-protected.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1684849011;s:16:\"sdk_last_version\";s:5:\"2.7.2\";s:11:\"sdk_version\";s:5:\"2.9.0\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";s:5:\"2.7.4\";s:14:\"plugin_version\";s:5:\"2.7.5\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";N;s:4:\"host\";s:32:\"midtemplate.understandingcode.pt\";s:9:\"server_ip\";s:13:\"94.46.181.147\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1732821012;s:7:\"version\";s:5:\"2.7.5\";}s:15:\"prev_is_premium\";b:0;s:18:\"sticky_optin_added\";b:1;s:19:\"last_load_timestamp\";i:1737594085;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1734369903;s:7:\"version\";s:5:\"2.7.5\";}}}s:13:\"file_slug_map\";a:1:{s:41:\"password-protected/password-protected.php\";s:23:\"password-protected-free\";}s:7:\"plugins\";a:1:{s:23:\"password-protected-free\";O:9:\"FS_Plugin\":24:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:18:\"Password Protected\";s:4:\"slug\";s:23:\"password-protected-free\";s:12:\"premium_slug\";s:34:\"password-protected-premium-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:41:\"password-protected/password-protected.php\";s:7:\"version\";s:5:\"2.7.5\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;s:10:\"public_key\";s:32:\"pk_e9210517721d27b5112fa7773a600\";s:10:\"secret_key\";N;s:2:\"id\";s:5:\"12503\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;}}s:13:\"admin_notices\";a:1:{s:23:\"password-protected-free\";a:0:{}}s:12:\"gc_timestamp\";a:0:{}s:10:\"theme_data\";a:0:{}s:9:\"unique_id\";s:32:\"cd6bca7556f237b7f82278811c44219b\";}", "yes");
INSERT INTO `wp_options` VALUES("1055", "duplicator_notifications", "a:4:{s:6:\"update\";i:1737624068;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("1416", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("1747", "recovery_mode_email_last_sent", "1733937502", "yes");
INSERT INTO `wp_options` VALUES("1902", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("1909", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[]}", "yes");
INSERT INTO `wp_options` VALUES("2746", "password_protected_1.5_update_database", "1", "yes");
INSERT INTO `wp_options` VALUES("3142", "polylang", "a:15:{s:7:\"browser\";i:0;s:7:\"rewrite\";i:1;s:12:\"hide_default\";i:1;s:10:\"force_lang\";i:1;s:13:\"redirect_lang\";i:0;s:13:\"media_support\";b:0;s:9:\"uninstall\";i:0;s:4:\"sync\";a:0:{}s:10:\"post_types\";a:0:{}s:10:\"taxonomies\";a:0:{}s:7:\"domains\";a:0:{}s:7:\"version\";s:5:\"3.6.5\";s:16:\"first_activation\";i:1715855707;s:12:\"default_lang\";s:2:\"pt\";s:16:\"previous_version\";s:5:\"3.6.4\";}", "yes");
INSERT INTO `wp_options` VALUES("3143", "polylang_wpml_strings", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("3144", "widget_polylang", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("3149", "pll_dismissed_notices", "a:2:{i:0;s:6:\"wizard\";i:1;s:6:\"review\";}", "yes");
INSERT INTO `wp_options` VALUES("3405", "acf_pro_license", "", "yes");
INSERT INTO `wp_options` VALUES("3406", "acf_pro_license_status", "", "yes");
INSERT INTO `wp_options` VALUES("3408", "acf_site_health", "{\"version\":\"6.3.10.2\",\"plugin_type\":\"Free\",\"wp_version\":\"6.7.1\",\"mysql_version\":\"5.7.44\",\"is_multisite\":false,\"active_theme\":{\"name\":\"Make It Digital\",\"version\":\"1.0\",\"theme_uri\":\"http:\\/\\/impreza.us-themes.com\\/\",\"stylesheet\":false},\"parent_theme\":{\"name\":\"Impreza\",\"version\":\"8.32.1\",\"theme_uri\":\"http:\\/\\/impreza.us-themes.com\\/\",\"stylesheet\":false},\"active_plugins\":{\"dhvc-form\\/dhvc-form.php\":{\"name\":\"DHVC Form\",\"version\":\"2.4.6\",\"plugin_uri\":\"http:\\/\\/sitesao.com\\/dhvcform\\/\"},\"duplicator\\/duplicator.php\":{\"name\":\"Duplicator\",\"version\":\"1.5.11.2\",\"plugin_uri\":\"https:\\/\\/duplicator.com\\/\"},\"loco-translate\\/loco.php\":{\"name\":\"Loco Translate\",\"version\":\"2.6.14\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/loco-translate\\/\"},\"password-protected\\/password-protected.php\":{\"name\":\"Password Protected\",\"version\":\"2.7.5\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/password-protected\\/\"},\"advanced-custom-fields\\/acf.php\":{\"name\":\"Secure Custom Fields\",\"version\":\"6.3.10.2\",\"plugin_uri\":\"http:\\/\\/wordpress.org\\/plugins\\/advanced-custom-fields\\/\"},\"us-core\\/us-core.php\":{\"name\":\"UpSolution Core\",\"version\":\"8.32.1\",\"plugin_uri\":\"https:\\/\\/help.us-themes.com\\/impreza\\/us-core\\/\"},\"js_composer\\/js_composer.php\":{\"name\":\"WPBakery Page Builder\",\"version\":\"8.0.1\",\"plugin_uri\":\"https:\\/\\/wpbakery.com\"},\"insert-headers-and-footers\\/ihaf.php\":{\"name\":\"WPCode Lite\",\"version\":\"2.2.3.1\",\"plugin_uri\":\"https:\\/\\/www.wpcode.com\\/\"}},\"ui_field_groups\":\"2\",\"php_field_groups\":\"0\",\"json_field_groups\":\"0\",\"rest_field_groups\":\"0\",\"number_of_fields_by_type\":{\"text\":2},\"number_of_third_party_fields_by_type\":[],\"post_types_enabled\":true,\"ui_post_types\":\"13\",\"json_post_types\":\"0\",\"ui_taxonomies\":\"9\",\"json_taxonomies\":\"0\",\"rest_api_format\":\"light\",\"admin_ui_enabled\":true,\"field_type-modal_enabled\":true,\"field_settings_tabs_enabled\":false,\"shortcode_enabled\":true,\"registered_acf_forms\":\"0\",\"json_save_paths\":1,\"json_load_paths\":1,\"event_first_created_post_type\":1732217345,\"event_first_created_taxonomy\":1732297429,\"event_first_created_field_group\":1732297497,\"last_updated\":1737478814}", "off");
INSERT INTO `wp_options` VALUES("5458", "can_compress_scripts", "0", "on");
INSERT INTO `wp_options` VALUES("5471", "duplicator_install_info", "a:3:{s:7:\"version\";s:5:\"1.5.6\";s:4:\"time\";i:1676331847;s:10:\"updateTime\";i:1732115373;}", "off");
INSERT INTO `wp_options` VALUES("5524", "us_can_modify_favorite_sections", "1", "auto");
INSERT INTO `wp_options` VALUES("5588", "action_scheduler_hybrid_store_demarkation", "43", "auto");
INSERT INTO `wp_options` VALUES("5589", "schema-ActionScheduler_StoreSchema", "7.0.1732297334", "auto");
INSERT INTO `wp_options` VALUES("5590", "schema-ActionScheduler_LoggerSchema", "3.0.1732297334", "auto");
INSERT INTO `wp_options` VALUES("5593", "woocommerce_newly_installed", "no", "auto");
INSERT INTO `wp_options` VALUES("5594", "woocommerce_schema_version", "920", "auto");
INSERT INTO `wp_options` VALUES("5595", "woocommerce_store_address", "", "on");
INSERT INTO `wp_options` VALUES("5596", "woocommerce_store_address_2", "", "on");
INSERT INTO `wp_options` VALUES("5597", "woocommerce_store_city", "", "on");
INSERT INTO `wp_options` VALUES("5598", "woocommerce_default_country", "PT", "on");
INSERT INTO `wp_options` VALUES("5599", "woocommerce_store_postcode", "", "on");
INSERT INTO `wp_options` VALUES("5600", "woocommerce_allowed_countries", "all", "on");
INSERT INTO `wp_options` VALUES("5601", "woocommerce_all_except_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("5602", "woocommerce_specific_allowed_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("5603", "woocommerce_ship_to_countries", "", "on");
INSERT INTO `wp_options` VALUES("5604", "woocommerce_specific_ship_to_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("5605", "woocommerce_default_customer_address", "base", "on");
INSERT INTO `wp_options` VALUES("5606", "woocommerce_calc_taxes", "no", "on");
INSERT INTO `wp_options` VALUES("5607", "woocommerce_enable_coupons", "yes", "on");
INSERT INTO `wp_options` VALUES("5608", "woocommerce_calc_discounts_sequentially", "no", "off");
INSERT INTO `wp_options` VALUES("5609", "woocommerce_currency", "EUR", "on");
INSERT INTO `wp_options` VALUES("5610", "woocommerce_currency_pos", "right_space", "on");
INSERT INTO `wp_options` VALUES("5611", "woocommerce_price_thousand_sep", "", "on");
INSERT INTO `wp_options` VALUES("5612", "woocommerce_price_decimal_sep", ",", "on");
INSERT INTO `wp_options` VALUES("5613", "woocommerce_price_num_decimals", "2", "on");
INSERT INTO `wp_options` VALUES("5614", "woocommerce_shop_page_id", "44", "on");
INSERT INTO `wp_options` VALUES("5615", "woocommerce_cart_redirect_after_add", "no", "on");
INSERT INTO `wp_options` VALUES("5616", "woocommerce_enable_ajax_add_to_cart", "yes", "on");
INSERT INTO `wp_options` VALUES("5617", "woocommerce_placeholder_image", "43", "on");
INSERT INTO `wp_options` VALUES("5618", "woocommerce_weight_unit", "kg", "on");
INSERT INTO `wp_options` VALUES("5619", "woocommerce_dimension_unit", "cm", "on");
INSERT INTO `wp_options` VALUES("5620", "woocommerce_enable_reviews", "yes", "on");
INSERT INTO `wp_options` VALUES("5621", "woocommerce_review_rating_verification_label", "yes", "off");
INSERT INTO `wp_options` VALUES("5622", "woocommerce_review_rating_verification_required", "no", "off");
INSERT INTO `wp_options` VALUES("5623", "woocommerce_enable_review_rating", "yes", "on");
INSERT INTO `wp_options` VALUES("5624", "woocommerce_review_rating_required", "yes", "off");
INSERT INTO `wp_options` VALUES("5625", "woocommerce_manage_stock", "yes", "on");
INSERT INTO `wp_options` VALUES("5626", "woocommerce_hold_stock_minutes", "60", "off");
INSERT INTO `wp_options` VALUES("5627", "woocommerce_notify_low_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("5628", "woocommerce_notify_no_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("5629", "woocommerce_stock_email_recipient", "it@makeitdigital.pt", "off");
INSERT INTO `wp_options` VALUES("5630", "woocommerce_notify_low_stock_amount", "2", "off");
INSERT INTO `wp_options` VALUES("5631", "woocommerce_notify_no_stock_amount", "0", "on");
INSERT INTO `wp_options` VALUES("5632", "woocommerce_hide_out_of_stock_items", "no", "on");
INSERT INTO `wp_options` VALUES("5633", "woocommerce_stock_format", "", "on");
INSERT INTO `wp_options` VALUES("5634", "woocommerce_file_download_method", "force", "off");
INSERT INTO `wp_options` VALUES("5635", "woocommerce_downloads_redirect_fallback_allowed", "no", "off");
INSERT INTO `wp_options` VALUES("5636", "woocommerce_downloads_require_login", "no", "off");
INSERT INTO `wp_options` VALUES("5637", "woocommerce_downloads_grant_access_after_payment", "yes", "off");
INSERT INTO `wp_options` VALUES("5638", "woocommerce_downloads_deliver_inline", "", "off");
INSERT INTO `wp_options` VALUES("5639", "woocommerce_downloads_add_hash_to_filename", "yes", "on");
INSERT INTO `wp_options` VALUES("5640", "woocommerce_downloads_count_partial", "yes", "on");
INSERT INTO `wp_options` VALUES("5642", "woocommerce_attribute_lookup_direct_updates", "no", "on");
INSERT INTO `wp_options` VALUES("5643", "woocommerce_attribute_lookup_optimized_updates", "no", "on");
INSERT INTO `wp_options` VALUES("5644", "woocommerce_product_match_featured_image_by_sku", "no", "on");
INSERT INTO `wp_options` VALUES("5645", "woocommerce_prices_include_tax", "no", "on");
INSERT INTO `wp_options` VALUES("5646", "woocommerce_tax_based_on", "shipping", "on");
INSERT INTO `wp_options` VALUES("5647", "woocommerce_shipping_tax_class", "inherit", "on");
INSERT INTO `wp_options` VALUES("5648", "woocommerce_tax_round_at_subtotal", "no", "on");
INSERT INTO `wp_options` VALUES("5649", "woocommerce_tax_classes", "", "on");
INSERT INTO `wp_options` VALUES("5650", "woocommerce_tax_display_shop", "excl", "on");
INSERT INTO `wp_options` VALUES("5651", "woocommerce_tax_display_cart", "excl", "on");
INSERT INTO `wp_options` VALUES("5652", "woocommerce_price_display_suffix", "", "on");
INSERT INTO `wp_options` VALUES("5653", "woocommerce_tax_total_display", "itemized", "off");
INSERT INTO `wp_options` VALUES("5654", "woocommerce_enable_shipping_calc", "yes", "off");
INSERT INTO `wp_options` VALUES("5655", "woocommerce_shipping_cost_requires_address", "no", "on");
INSERT INTO `wp_options` VALUES("5656", "woocommerce_ship_to_destination", "billing", "off");
INSERT INTO `wp_options` VALUES("5657", "woocommerce_shipping_debug_mode", "no", "on");
INSERT INTO `wp_options` VALUES("5658", "woocommerce_enable_guest_checkout", "yes", "off");
INSERT INTO `wp_options` VALUES("5659", "woocommerce_enable_checkout_login_reminder", "no", "off");
INSERT INTO `wp_options` VALUES("5660", "woocommerce_enable_signup_and_login_from_checkout", "no", "off");
INSERT INTO `wp_options` VALUES("5661", "woocommerce_enable_myaccount_registration", "no", "off");
INSERT INTO `wp_options` VALUES("5662", "woocommerce_registration_generate_username", "yes", "off");
INSERT INTO `wp_options` VALUES("5663", "woocommerce_registration_generate_password", "yes", "off");
INSERT INTO `wp_options` VALUES("5664", "woocommerce_erasure_request_removes_order_data", "no", "off");
INSERT INTO `wp_options` VALUES("5665", "woocommerce_erasure_request_removes_download_data", "no", "off");
INSERT INTO `wp_options` VALUES("5666", "woocommerce_allow_bulk_remove_personal_data", "no", "off");
INSERT INTO `wp_options` VALUES("5667", "woocommerce_registration_privacy_policy_text", "Os seus dados pessoais serão utilizados para melhorar a sua experiência por toda a loja, para gerir o acesso à sua conta e para os propósitos descritos na nossa [privacy_policy].", "on");
INSERT INTO `wp_options` VALUES("5668", "woocommerce_checkout_privacy_policy_text", "Os seus dados pessoais serão utilizados para processar a sua encomenda, para melhorar a sua experiência em toda a loja e para os propósitos descritos na nossa [privacy_policy].", "on");
INSERT INTO `wp_options` VALUES("5669", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("5670", "woocommerce_trash_pending_orders", "", "off");
INSERT INTO `wp_options` VALUES("5671", "woocommerce_trash_failed_orders", "", "off");
INSERT INTO `wp_options` VALUES("5672", "woocommerce_trash_cancelled_orders", "", "off");
INSERT INTO `wp_options` VALUES("5673", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("5674", "woocommerce_email_from_name", "Mid Template", "off");
INSERT INTO `wp_options` VALUES("5675", "woocommerce_email_from_address", "it@makeitdigital.pt", "off");
INSERT INTO `wp_options` VALUES("5676", "woocommerce_email_header_image", "", "off");
INSERT INTO `wp_options` VALUES("5677", "woocommerce_email_base_color", "#7f54b3", "off");
INSERT INTO `wp_options` VALUES("5678", "woocommerce_email_background_color", "#f7f7f7", "off");
INSERT INTO `wp_options` VALUES("5679", "woocommerce_email_body_background_color", "#ffffff", "off");
INSERT INTO `wp_options` VALUES("5680", "woocommerce_email_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("5681", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "off");
INSERT INTO `wp_options` VALUES("5682", "woocommerce_email_footer_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("5683", "woocommerce_merchant_email_notifications", "no", "off");
INSERT INTO `wp_options` VALUES("5684", "woocommerce_cart_page_id", "45", "off");
INSERT INTO `wp_options` VALUES("5685", "woocommerce_checkout_page_id", "46", "off");
INSERT INTO `wp_options` VALUES("5686", "woocommerce_myaccount_page_id", "47", "off");
INSERT INTO `wp_options` VALUES("5687", "woocommerce_terms_page_id", "", "off");
INSERT INTO `wp_options` VALUES("5688", "woocommerce_checkout_pay_endpoint", "order-pay", "on");
INSERT INTO `wp_options` VALUES("5689", "woocommerce_checkout_order_received_endpoint", "order-received", "on");
INSERT INTO `wp_options` VALUES("5690", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "on");
INSERT INTO `wp_options` VALUES("5691", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "on");
INSERT INTO `wp_options` VALUES("5692", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "on");
INSERT INTO `wp_options` VALUES("5693", "woocommerce_myaccount_orders_endpoint", "orders", "on");
INSERT INTO `wp_options` VALUES("5694", "woocommerce_myaccount_view_order_endpoint", "view-order", "on");
INSERT INTO `wp_options` VALUES("5695", "woocommerce_myaccount_downloads_endpoint", "downloads", "on");
INSERT INTO `wp_options` VALUES("5696", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "on");
INSERT INTO `wp_options` VALUES("5697", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "on");
INSERT INTO `wp_options` VALUES("5698", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "on");
INSERT INTO `wp_options` VALUES("5699", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "on");
INSERT INTO `wp_options` VALUES("5700", "woocommerce_logout_endpoint", "customer-logout", "on");
INSERT INTO `wp_options` VALUES("5701", "woocommerce_api_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("5702", "woocommerce_allow_tracking", "no", "off");
INSERT INTO `wp_options` VALUES("5703", "woocommerce_show_marketplace_suggestions", "yes", "off");
INSERT INTO `wp_options` VALUES("5704", "woocommerce_custom_orders_table_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("5705", "woocommerce_analytics_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("5706", "woocommerce_feature_order_attribution_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("5707", "woocommerce_feature_site_visibility_badge_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("5708", "woocommerce_feature_product_block_editor_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("5709", "woocommerce_hpos_fts_index_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("5710", "woocommerce_single_image_width", "600", "on");
INSERT INTO `wp_options` VALUES("5711", "woocommerce_thumbnail_image_width", "300", "on");
INSERT INTO `wp_options` VALUES("5712", "woocommerce_checkout_highlight_required_fields", "yes", "on");
INSERT INTO `wp_options` VALUES("5713", "woocommerce_demo_store", "no", "off");
INSERT INTO `wp_options` VALUES("5714", "wc_downloads_approved_directories_mode", "enabled", "auto");
INSERT INTO `wp_options` VALUES("5715", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/produto\";s:13:\"category_base\";s:17:\"categoria-produto\";s:8:\"tag_base\";s:16:\"produto-etiqueta\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("5716", "current_theme_supports_woocommerce", "yes", "auto");
INSERT INTO `wp_options` VALUES("5717", "woocommerce_queue_flush_rewrite_rules", "no", "auto");
INSERT INTO `wp_options` VALUES("5719", "product_cat_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("5720", "default_product_cat", "26", "auto");
INSERT INTO `wp_options` VALUES("5728", "woocommerce_refund_returns_page_id", "48", "auto");
INSERT INTO `wp_options` VALUES("5731", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:84:\"Pagar com PayPal; pode pagar com cartão de crédito se não tiver uma conta PayPal.\";s:5:\"email\";s:19:\"it@makeitdigital.pt\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:19:\"it@makeitdigital.pt\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "on");
INSERT INTO `wp_options` VALUES("5732", "woocommerce_version", "9.4.3", "auto");
INSERT INTO `wp_options` VALUES("5733", "woocommerce_db_version", "9.4.3", "auto");
INSERT INTO `wp_options` VALUES("5734", "woocommerce_store_id", "1bffeeb3-ec8e-4493-91a4-c3ef41344556", "auto");
INSERT INTO `wp_options` VALUES("5735", "woocommerce_admin_install_timestamp", "1732297335", "auto");
INSERT INTO `wp_options` VALUES("5736", "woocommerce_inbox_variant_assignment", "3", "auto");
INSERT INTO `wp_options` VALUES("5737", "woocommerce_remote_variant_assignment", "31", "auto");
INSERT INTO `wp_options` VALUES("5744", "action_scheduler_lock_async-request-runner", "6758a3ccc9f796.44452838|1733862408", "no");
INSERT INTO `wp_options` VALUES("5745", "woocommerce_admin_notices", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("5746", "wc_blocks_version", "11.8.0-dev", "auto");
INSERT INTO `wp_options` VALUES("5747", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"dRWN4N3NAn9zAwg1wsmVP9HgPWU9WG4A\";}", "on");
INSERT INTO `wp_options` VALUES("5749", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5750", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5751", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5752", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5753", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5754", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5755", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5756", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5757", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5758", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5759", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5760", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5768", "wcpay_was_in_use", "no", "auto");
INSERT INTO `wp_options` VALUES("5771", "wc_admin_show_legacy_coupon_menu", "0", "auto");
INSERT INTO `wp_options` VALUES("5772", "woocommerce_custom_orders_table_created", "yes", "auto");
INSERT INTO `wp_options` VALUES("5773", "woocommerce_coming_soon", "yes", "auto");
INSERT INTO `wp_options` VALUES("5774", "woocommerce_initial_installed_version", "9.4.2", "off");
INSERT INTO `wp_options` VALUES("5778", "wc_blocks_db_schema_version", "260", "auto");
INSERT INTO `wp_options` VALUES("5779", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("5790", "jetpack_options", "a:1:{s:14:\"last_heartbeat\";i:1733862309;}", "auto");
INSERT INTO `wp_options` VALUES("5808", "woocommerce_onboarding_profile", "a:9:{s:15:\"business_choice\";s:34:\"im_setting_up_a_store_for_a_client\";s:21:\"selling_online_answer\";N;s:17:\"selling_platforms\";N;s:20:\"is_store_country_set\";b:1;s:8:\"industry\";a:1:{i:0;s:5:\"other\";}s:18:\"is_agree_marketing\";b:0;s:11:\"store_email\";s:19:\"it@makeitdigital.pt\";s:9:\"completed\";b:1;s:23:\"is_plugins_page_skipped\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("5810", "woocommerce_store_pages_only", "yes", "auto");
INSERT INTO `wp_options` VALUES("5811", "woocommerce_private_link", "no", "auto");
INSERT INTO `wp_options` VALUES("5812", "woocommerce_share_key", "R3zszLEm44ee0Xpkqohs9WBQmtxcK0Kx", "auto");
INSERT INTO `wp_options` VALUES("5815", "woocommerce_free_shipping_1_settings", "a:4:{s:5:\"title\";s:13:\"Free shipping\";s:8:\"requires\";s:0:\"\";s:10:\"min_amount\";s:1:\"0\";s:16:\"ignore_discounts\";s:2:\"no\";}", "auto");
INSERT INTO `wp_options` VALUES("5816", "woocommerce_admin_created_default_shipping_zones", "yes", "auto");
INSERT INTO `wp_options` VALUES("5819", "woocommerce_task_list_tracked_completed_tasks", "a:1:{i:0;s:8:\"shipping\";}", "auto");
INSERT INTO `wp_options` VALUES("5885", "jetpack_connection_active_plugins", "a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:11:\"WooCommerce\";}}", "auto");
INSERT INTO `wp_options` VALUES("6185", "loco_recent", "a:4:{s:1:\"c\";s:21:\"Loco_data_RecentItems\";s:1:\"v\";i:0;s:1:\"d\";a:1:{s:6:\"bundle\";a:1:{s:19:\"theme.makeitdigital\";i:1732642113;}}s:1:\"t\";i:1732642113;}", "off");
INSERT INTO `wp_options` VALUES("6765", "awl_hide_int_notices", "a:1:{i:0;s:3:\"acf\";}", "off");
INSERT INTO `wp_options` VALUES("6773", "woocommerce_attribute_lookup_enabled", "no", "auto");
INSERT INTO `wp_options` VALUES("6782", "wc_remote_inbox_notifications_wca_updated", "", "off");
INSERT INTO `wp_options` VALUES("6797", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("6800", "duplicator_migration_data", "{\n    \"plugin\": \"dup-lite\",\n    \"installerVersion\": \"1.5.11.2\",\n    \"installType\": -1,\n    \"logicModes\": [\n        \"CLASSIC\"\n    ],\n    \"template\": \"base\",\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/wwwumdom\\/public_html\\/batazu\\/20230214_midtemplate_fd7b9172ae901b4e7571_20241210171323_archive.zip\",\n    \"packageHash\": \"fd7b917-10171323\",\n    \"installerPath\": \"\\/home\\/wwwumdom\\/public_html\\/batazu\\/installer.php\",\n    \"installerBootLog\": \"\\/home\\/wwwumdom\\/public_html\\/batazu\\/dup-installer-bootlog__6d75898-10171323.txt\",\n    \"installerLog\": \"\\/home\\/wwwumdom\\/public_html\\/batazu\\/dup-installer\\/dup-installer-log__6d75898-10171323.txt\",\n    \"dupInstallerPath\": \"\\/home\\/wwwumdom\\/public_html\\/batazu\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/wwwumdom\\/public_html\\/batazu\\/dup-installer\\/original_files_fd7b917-10171323\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true,\n    \"licenseType\": 0,\n    \"phpVersion\": \"7.4.33\",\n    \"archiveType\": \"zip\",\n    \"siteSize\": 103948584,\n    \"siteNumFiles\": 19926,\n    \"siteDbSize\": 5226496,\n    \"siteDBNumTables\": 55,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"ustatIdentifier\": \"\",\n    \"time\": 1733862307\n}", "no");
INSERT INTO `wp_options` VALUES("6801", "_transient_pll_languages_list", "a:1:{i:0;a:22:{s:4:\"name\";s:10:\"Português\";s:4:\"slug\";s:2:\"pt\";s:10:\"term_group\";i:0;s:7:\"term_id\";i:10;s:6:\"locale\";s:5:\"pt_PT\";s:6:\"is_rtl\";i:0;s:3:\"w3c\";s:5:\"pt-PT\";s:8:\"facebook\";s:5:\"pt_PT\";s:8:\"home_url\";s:30:\"https://batazu.digitalpath.pt/\";s:10:\"search_url\";s:30:\"https://batazu.digitalpath.pt/\";s:4:\"host\";N;s:13:\"page_on_front\";i:36;s:14:\"page_for_posts\";i:0;s:9:\"flag_code\";s:2:\"pt\";s:8:\"flag_url\";s:70:\"https://batazu.digitalpath.pt/wp-content/plugins/polylang/flags/pt.png\";s:4:\"flag\";s:591:\"<img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAABL0lEQVR4AV2RA2yEQRCFNxcnRVw3qG3bthXUbZxaUaOGRVA7ro2wDWoEtW2b9/b2nHx3v943uztDSAwhAQJ86P83keCJw2HcEAJoqLivmJHbnQt+s7OFfMXHMz5DAgBPCKBCUktSRmdK43Dw3Gz451TIc68nPr+7uLzZWr2Zm78bGLxpa797e1+IC0erUeAmL+ol3R8CEE+/qqvDv2BbwjYi6yJR+6Ys5m5zA0C7HbWEIEy/KCpKC8uzQRf5fkivX3zBZIIw/Swvj8cTKthRIbDGDwcYnXRF7avy/KM5q8NZg2cDPWEaYHt8AceFACBsTdui9nmn8VWmpngawN+ngiEVHCocGM5Vpu8G0rUB5iAS0CKAYwCsg/YB1lPWKESBSCAqhMiKwHQueJwI2BeDC83C2lDIxUCuAAAAAElFTkSuQmCC\" alt=\"Português\" width=\"16\" height=\"11\" style=\"width: 16px; height: 11px;\" />\";s:15:\"custom_flag_url\";s:0:\"\";s:11:\"custom_flag\";s:0:\"\";s:6:\"active\";b:1;s:9:\"fallbacks\";a:0:{}s:10:\"is_default\";b:1;s:10:\"term_props\";a:2:{s:8:\"language\";a:3:{s:7:\"term_id\";i:10;s:16:\"term_taxonomy_id\";i:10;s:5:\"count\";i:22;}s:13:\"term_language\";a:3:{s:7:\"term_id\";i:11;s:16:\"term_taxonomy_id\";i:11;s:5:\"count\";i:1;}}}}", "on");
INSERT INTO `wp_options` VALUES("6802", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("6803", "_transient_wc_attribute_taxonomies", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("6815", "_transient_jetpack_autoloader_plugin_paths", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("6827", "_transient_wc_count_comments", "O:8:\"stdClass\":7:{s:14:\"total_comments\";i:1;s:3:\"all\";i:1;s:8:\"approved\";s:1:\"1\";s:9:\"moderated\";i:0;s:4:\"spam\";i:0;s:5:\"trash\";i:0;s:12:\"post-trashed\";i:0;}", "on");
INSERT INTO `wp_options` VALUES("6832", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/pt_PT/wordpress-6.7.1.zip\";s:6:\"locale\";s:5:\"pt_PT\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/pt_PT/wordpress-6.7.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.7.1\";s:7:\"version\";s:5:\"6.7.1\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1737594088;s:15:\"version_checked\";s:5:\"6.7.1\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("6840", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1737594089;s:7:\"checked\";a:5:{s:7:\"Impreza\";s:6:\"8.32.1\";s:13:\"makeitdigital\";s:3:\"1.0\";s:16:\"twentytwentyfive\";s:3:\"1.0\";s:16:\"twentytwentyfour\";s:3:\"1.3\";s:17:\"twentytwentythree\";s:3:\"1.6\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:3:{s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.0\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.0.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("6842", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"o6gldY-e2N&LVAkSFZ3vAA2bymlLTRse9&Y8WgKGQVwI\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 223.06,\n    \"siteNumFiles\": 14093,\n    \"siteDbSizeMB\": 5.7,\n    \"siteDbNumTables\": 55\n}", "auto");
INSERT INTO `wp_options` VALUES("6852", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("6853", "_transient_woocommerce_reports-transient-version", "1733862374", "on");
INSERT INTO `wp_options` VALUES("6861", "_transient_jetpack_connection_active_plugins_refresh", "1733862407", "on");
INSERT INTO `wp_options` VALUES("6869", "wpcode_usage_tracking_config", "a:6:{s:3:\"day\";i:4;s:4:\"hour\";i:23;s:6:\"minute\";i:10;s:6:\"second\";i:47;s:6:\"offset\";i:429047;s:8:\"initsend\";i:1734649847;}", "off");
INSERT INTO `wp_options` VALUES("6870", "_transient_wpb_notice_list", "a:1:{s:18:\"empty_api_response\";b:1;}", "on");
INSERT INTO `wp_options` VALUES("6871", "wpcode_snippets_errors", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("6872", "new_admin_email", "it@makeitdigital.pt", "auto");
INSERT INTO `wp_options` VALUES("6876", "rewrite_rules", "a:220:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:34:\"wpcode/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"wpcode/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"wpcode/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"wpcode/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"wpcode/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"wpcode/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"wpcode/([^/]+)/embed/?$\";s:39:\"index.php?wpcode=$matches[1]&embed=true\";s:27:\"wpcode/([^/]+)/trackback/?$\";s:33:\"index.php?wpcode=$matches[1]&tb=1\";s:35:\"wpcode/([^/]+)/page/?([0-9]{1,})/?$\";s:46:\"index.php?wpcode=$matches[1]&paged=$matches[2]\";s:42:\"wpcode/([^/]+)/comment-page-([0-9]{1,})/?$\";s:46:\"index.php?wpcode=$matches[1]&cpage=$matches[2]\";s:31:\"wpcode/([^/]+)(?:/([0-9]+))?/?$\";s:45:\"index.php?wpcode=$matches[1]&page=$matches[2]\";s:23:\"wpcode/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:33:\"wpcode/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:53:\"wpcode/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"wpcode/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:48:\"wpcode/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:29:\"wpcode/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"wpcode_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wpcode_type=$matches[1]&feed=$matches[2]\";s:47:\"wpcode_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wpcode_type=$matches[1]&feed=$matches[2]\";s:28:\"wpcode_type/([^/]+)/embed/?$\";s:44:\"index.php?wpcode_type=$matches[1]&embed=true\";s:40:\"wpcode_type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?wpcode_type=$matches[1]&paged=$matches[2]\";s:22:\"wpcode_type/([^/]+)/?$\";s:33:\"index.php?wpcode_type=$matches[1]\";s:56:\"wpcode_location/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?wpcode_location=$matches[1]&feed=$matches[2]\";s:51:\"wpcode_location/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?wpcode_location=$matches[1]&feed=$matches[2]\";s:32:\"wpcode_location/([^/]+)/embed/?$\";s:48:\"index.php?wpcode_location=$matches[1]&embed=true\";s:44:\"wpcode_location/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?wpcode_location=$matches[1]&paged=$matches[2]\";s:26:\"wpcode_location/([^/]+)/?$\";s:37:\"index.php?wpcode_location=$matches[1]\";s:52:\"wpcode_tags/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wpcode_tags=$matches[1]&feed=$matches[2]\";s:47:\"wpcode_tags/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?wpcode_tags=$matches[1]&feed=$matches[2]\";s:28:\"wpcode_tags/([^/]+)/embed/?$\";s:44:\"index.php?wpcode_tags=$matches[1]&embed=true\";s:40:\"wpcode_tags/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?wpcode_tags=$matches[1]&paged=$matches[2]\";s:22:\"wpcode_tags/([^/]+)/?$\";s:33:\"index.php?wpcode_tags=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:57:\"categoria-pagina/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?categoria-pagina=$matches[1]&feed=$matches[2]\";s:52:\"categoria-pagina/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?categoria-pagina=$matches[1]&feed=$matches[2]\";s:33:\"categoria-pagina/([^/]+)/embed/?$\";s:49:\"index.php?categoria-pagina=$matches[1]&embed=true\";s:45:\"categoria-pagina/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?categoria-pagina=$matches[1]&paged=$matches[2]\";s:27:\"categoria-pagina/([^/]+)/?$\";s:38:\"index.php?categoria-pagina=$matches[1]\";s:34:\"parceria/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"parceria/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"parceria/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"parceria/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"parceria/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"parceria/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:23:\"parceria/(.+?)/embed/?$\";s:41:\"index.php?parceria=$matches[1]&embed=true\";s:27:\"parceria/(.+?)/trackback/?$\";s:35:\"index.php?parceria=$matches[1]&tb=1\";s:35:\"parceria/(.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?parceria=$matches[1]&paged=$matches[2]\";s:42:\"parceria/(.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?parceria=$matches[1]&cpage=$matches[2]\";s:31:\"parceria/(.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?parceria=$matches[1]&page=$matches[2]\";s:33:\"recurso/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"recurso/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"recurso/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"recurso/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"recurso/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"recurso/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"recurso/(.+?)/embed/?$\";s:40:\"index.php?recurso=$matches[1]&embed=true\";s:26:\"recurso/(.+?)/trackback/?$\";s:34:\"index.php?recurso=$matches[1]&tb=1\";s:34:\"recurso/(.+?)/page/?([0-9]{1,})/?$\";s:47:\"index.php?recurso=$matches[1]&paged=$matches[2]\";s:41:\"recurso/(.+?)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?recurso=$matches[1]&cpage=$matches[2]\";s:30:\"recurso/(.+?)(?:/([0-9]+))?/?$\";s:46:\"index.php?recurso=$matches[1]&page=$matches[2]\";s:39:\"slide-carross/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"slide-carross/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"slide-carross/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"slide-carross/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"slide-carross/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"slide-carross/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"slide-carross/(.+?)/embed/?$\";s:46:\"index.php?slide-carross=$matches[1]&embed=true\";s:32:\"slide-carross/(.+?)/trackback/?$\";s:40:\"index.php?slide-carross=$matches[1]&tb=1\";s:40:\"slide-carross/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?slide-carross=$matches[1]&paged=$matches[2]\";s:47:\"slide-carross/(.+?)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?slide-carross=$matches[1]&cpage=$matches[2]\";s:36:\"slide-carross/(.+?)(?:/([0-9]+))?/?$\";s:52:\"index.php?slide-carross=$matches[1]&page=$matches[2]\";s:36:\"dhvcform/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"dhvcform/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"dhvcform/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"dhvcform/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"dhvcform/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"dhvcform/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"dhvcform/([^/]+)/embed/?$\";s:41:\"index.php?dhvcform=$matches[1]&embed=true\";s:29:\"dhvcform/([^/]+)/trackback/?$\";s:35:\"index.php?dhvcform=$matches[1]&tb=1\";s:37:\"dhvcform/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?dhvcform=$matches[1]&paged=$matches[2]\";s:44:\"dhvcform/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?dhvcform=$matches[1]&cpage=$matches[2]\";s:33:\"dhvcform/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?dhvcform=$matches[1]&page=$matches[2]\";s:25:\"dhvcform/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"dhvcform/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"dhvcform/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"dhvcform/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"dhvcform/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"dhvcform/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"us_testimonial_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:62:\"index.php?us_testimonial_category=$matches[1]&feed=$matches[2]\";s:59:\"us_testimonial_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:62:\"index.php?us_testimonial_category=$matches[1]&feed=$matches[2]\";s:40:\"us_testimonial_category/([^/]+)/embed/?$\";s:56:\"index.php?us_testimonial_category=$matches[1]&embed=true\";s:52:\"us_testimonial_category/([^/]+)/page/?([0-9]{1,})/?$\";s:63:\"index.php?us_testimonial_category=$matches[1]&paged=$matches[2]\";s:34:\"us_testimonial_category/([^/]+)/?$\";s:45:\"index.php?us_testimonial_category=$matches[1]\";s:58:\"us_media_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?us_media_category=$matches[1]&feed=$matches[2]\";s:53:\"us_media_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?us_media_category=$matches[1]&feed=$matches[2]\";s:34:\"us_media_category/([^/]+)/embed/?$\";s:50:\"index.php?us_media_category=$matches[1]&embed=true\";s:46:\"us_media_category/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?us_media_category=$matches[1]&paged=$matches[2]\";s:28:\"us_media_category/([^/]+)/?$\";s:39:\"index.php?us_media_category=$matches[1]\";s:40:\"vc_grid_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"vc_grid_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"vc_grid_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"vc_grid_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"vc_grid_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"vc_grid_item/([^/]+)/embed/?$\";s:45:\"index.php?vc_grid_item=$matches[1]&embed=true\";s:33:\"vc_grid_item/([^/]+)/trackback/?$\";s:39:\"index.php?vc_grid_item=$matches[1]&tb=1\";s:41:\"vc_grid_item/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&paged=$matches[2]\";s:48:\"vc_grid_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?vc_grid_item=$matches[1]&cpage=$matches[2]\";s:37:\"vc_grid_item/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?vc_grid_item=$matches[1]&page=$matches[2]\";s:29:\"vc_grid_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"vc_grid_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"vc_grid_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"vc_grid_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"vc_grid_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"glossario/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"glossario/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"glossario/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"glossario/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"glossario/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"glossario/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"glossario/(.+?)/embed/?$\";s:42:\"index.php?glossario=$matches[1]&embed=true\";s:28:\"glossario/(.+?)/trackback/?$\";s:36:\"index.php?glossario=$matches[1]&tb=1\";s:36:\"glossario/(.+?)/page/?([0-9]{1,})/?$\";s:49:\"index.php?glossario=$matches[1]&paged=$matches[2]\";s:43:\"glossario/(.+?)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?glossario=$matches[1]&cpage=$matches[2]\";s:32:\"glossario/(.+?)(?:/([0-9]+))?/?$\";s:48:\"index.php?glossario=$matches[1]&page=$matches[2]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=36&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "auto");
INSERT INTO `wp_options` VALUES("6886", "us_flush_rules", "1", "on");
INSERT INTO `wp_options` VALUES("6918", "_transient_health-check-site-status-result", "{\"good\":14,\"recommended\":7,\"critical\":2}", "on");
INSERT INTO `wp_options` VALUES("6957", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("6969", "wpb_usage_count", "a:12:{s:14:\"vc_column_text\";i:9;s:12:\"us_separator\";i:2;s:11:\"us_hwrapper\";i:1;s:6:\"us_btn\";i:4;s:11:\"us_carousel\";i:2;s:16:\"us_post_taxonomy\";i:1;s:20:\"us_post_custom_field\";i:1;s:7:\"us_grid\";i:3;s:14:\"us_grid_filter\";i:1;s:7:\"us_text\";i:1;s:8:\"us_image\";i:3;s:18:\"us_additional_menu\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("7000", "category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("7001", "wp_calendar_block_has_published_posts", "1", "auto");
INSERT INTO `wp_options` VALUES("7071", "letra-glossario_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("7365", "password_protected_status", "1", "auto");
INSERT INTO `wp_options` VALUES("7366", "password_protected_feeds", "0", "auto");
INSERT INTO `wp_options` VALUES("7367", "password_protected_rest", "0", "auto");
INSERT INTO `wp_options` VALUES("7368", "password_protected_administrators", "1", "auto");
INSERT INTO `wp_options` VALUES("7369", "password_protected_users", "0", "auto");
INSERT INTO `wp_options` VALUES("7370", "password_protected_password", "74542c17c72fcf061b0954c295b45102", "auto");
INSERT INTO `wp_options` VALUES("7371", "password_protected_allowed_ip_addresses", "", "auto");
INSERT INTO `wp_options` VALUES("7372", "password_protected_remember_me_lifetime", "80", "auto");
INSERT INTO `wp_options` VALUES("7382", "auth_key", "/XtwA5T_idi*ylrB-kV{GI(4/jIoBwmslJ`/5Y]bQ:nrvkf&DcT;SxRpSb9mG`zq", "off");
INSERT INTO `wp_options` VALUES("7383", "auth_salt", ":s)3?[m)@tZl<xRZoz_xM#o[q`-*({b`~Mmkbu`q`GW/Q%$mITF(:ipd#{yA;)8A", "off");
INSERT INTO `wp_options` VALUES("8893", "_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447", "1738112411", "off");
INSERT INTO `wp_options` VALUES("8894", "_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("8923", "_site_transient_timeout_theme_roots", "1737595889", "off");
INSERT INTO `wp_options` VALUES("8924", "_site_transient_theme_roots", "a:5:{s:7:\"Impreza\";s:7:\"/themes\";s:13:\"makeitdigital\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("8925", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1737594089;s:8:\"response\";a:4:{s:26:\"post-smtp/postman-smtp.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:23:\"w.org/plugins/post-smtp\";s:4:\"slug\";s:9:\"post-smtp\";s:6:\"plugin\";s:26:\"post-smtp/postman-smtp.php\";s:11:\"new_version\";s:5:\"3.0.1\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/post-smtp/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/post-smtp.3.0.1.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:62:\"https://ps.w.org/post-smtp/assets/icon-128x128.gif?rev=3209655\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/post-smtp/assets/banner-1544x500.jpg?rev=3196151\";s:2:\"1x\";s:64:\"https://ps.w.org/post-smtp/assets/banner-772x250.jpg?rev=3196151\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"5.6.0\";s:6:\"tested\";s:5:\"6.7.1\";s:12:\"requires_php\";s:3:\"7.0\";s:16:\"requires_plugins\";a:0:{}}s:30:\"seo-by-rank-math/rank-math.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:30:\"w.org/plugins/seo-by-rank-math\";s:4:\"slug\";s:16:\"seo-by-rank-math\";s:6:\"plugin\";s:30:\"seo-by-rank-math/rank-math.php\";s:11:\"new_version\";s:7:\"1.0.236\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/seo-by-rank-math/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/seo-by-rank-math.1.0.236.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:61:\"https://ps.w.org/seo-by-rank-math/assets/icon.svg?rev=3218327\";s:3:\"svg\";s:61:\"https://ps.w.org/seo-by-rank-math/assets/icon.svg?rev=3218327\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/seo-by-rank-math/assets/banner-1544x500.png?rev=2639678\";s:2:\"1x\";s:71:\"https://ps.w.org/seo-by-rank-math/assets/banner-772x250.png?rev=2639678\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.3\";s:6:\"tested\";s:5:\"6.7.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:30:\"advanced-custom-fields/acf.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:36:\"w.org/plugins/advanced-custom-fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:6:\"plugin\";s:30:\"advanced-custom-fields/acf.php\";s:11:\"new_version\";s:6:\"6.3.11\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/advanced-custom-fields/\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/plugin/advanced-custom-fields.6.3.11.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:67:\"https://ps.w.org/advanced-custom-fields/assets/icon.svg?rev=3207824\";s:3:\"svg\";s:67:\"https://ps.w.org/advanced-custom-fields/assets/icon.svg?rev=3207824\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/advanced-custom-fields/assets/banner-1544x500.jpg?rev=3207824\";s:2:\"1x\";s:77:\"https://ps.w.org/advanced-custom-fields/assets/banner-772x250.jpg?rev=3207824\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.0\";s:6:\"tested\";s:5:\"6.7.1\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:35:\"insert-headers-and-footers/ihaf.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:40:\"w.org/plugins/insert-headers-and-footers\";s:4:\"slug\";s:26:\"insert-headers-and-footers\";s:6:\"plugin\";s:35:\"insert-headers-and-footers/ihaf.php\";s:11:\"new_version\";s:5:\"2.2.5\";s:3:\"url\";s:57:\"https://wordpress.org/plugins/insert-headers-and-footers/\";s:7:\"package\";s:75:\"https://downloads.wordpress.org/plugin/insert-headers-and-footers.2.2.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:79:\"https://ps.w.org/insert-headers-and-footers/assets/icon-256x256.png?rev=2758516\";s:2:\"1x\";s:79:\"https://ps.w.org/insert-headers-and-footers/assets/icon-128x128.png?rev=2758516\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:82:\"https://ps.w.org/insert-headers-and-footers/assets/banner-1544x500.png?rev=2758516\";s:2:\"1x\";s:81:\"https://ps.w.org/insert-headers-and-footers/assets/banner-772x250.png?rev=2758516\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";s:6:\"tested\";s:5:\"6.7.1\";s:12:\"requires_php\";s:3:\"5.5\";s:16:\"requires_plugins\";a:0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:4:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"5.3.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.5.3.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:8:\"1.5.11.2\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/duplicator.1.5.11.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:23:\"loco-translate/loco.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/loco-translate\";s:4:\"slug\";s:14:\"loco-translate\";s:6:\"plugin\";s:23:\"loco-translate/loco.php\";s:11:\"new_version\";s:6:\"2.6.14\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/loco-translate/\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/plugin/loco-translate.2.6.14.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/loco-translate/assets/icon-256x256.png?rev=1000676\";s:2:\"1x\";s:67:\"https://ps.w.org/loco-translate/assets/icon-128x128.png?rev=1000676\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:68:\"https://ps.w.org/loco-translate/assets/banner-772x250.jpg?rev=745046\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.2\";}s:41:\"password-protected/password-protected.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:32:\"w.org/plugins/password-protected\";s:4:\"slug\";s:18:\"password-protected\";s:6:\"plugin\";s:41:\"password-protected/password-protected.php\";s:11:\"new_version\";s:5:\"2.7.5\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/password-protected/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/password-protected.2.7.5.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/password-protected/assets/icon-128x128.gif?rev=2824217\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/password-protected/assets/banner-1544x500.jpg?rev=3107315\";s:2:\"1x\";s:73:\"https://ps.w.org/password-protected/assets/banner-772x250.jpg?rev=3107315\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}}s:7:\"checked\";a:13:{s:34:\"advanced-custom-fields-pro/acf.php\";s:5:\"6.3.9\";s:19:\"akismet/akismet.php\";s:5:\"5.3.5\";s:23:\"dhvc-form/dhvc-form.php\";s:5:\"2.4.6\";s:25:\"duplicator/duplicator.php\";s:8:\"1.5.11.2\";s:23:\"loco-translate/loco.php\";s:6:\"2.6.14\";s:41:\"password-protected/password-protected.php\";s:5:\"2.7.5\";s:26:\"post-smtp/postman-smtp.php\";s:6:\"2.9.13\";s:30:\"seo-by-rank-math/rank-math.php\";s:7:\"1.0.233\";s:30:\"advanced-custom-fields/acf.php\";s:8:\"6.3.10.2\";s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";s:7:\"3.19.23\";s:19:\"us-core/us-core.php\";s:6:\"8.32.1\";s:27:\"js_composer/js_composer.php\";s:5:\"8.0.1\";s:35:\"insert-headers-and-footers/ihaf.php\";s:7:\"2.2.3.1\";}}", "off");
INSERT INTO `wp_options` VALUES("8931", "_site_transient_timeout_available_translations", "1737634847", "off");
INSERT INTO `wp_options` VALUES("8932", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:5:\"6.0.9\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.0.9/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-01 09:05:28\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.5/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.26/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-12 07:32:34\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-11 11:12:13\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-13 14:30:12\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-07-23 09:49:04\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-21 16:46:40\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-08 14:12:43\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-05 18:11:40\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-09 10:07:52\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-22 23:30:10\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-05 18:08:14\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.7.1/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-22 23:29:26\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.7.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-23 00:05:55\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-08 19:43:34\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-15 22:47:35\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-14 20:17:10\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-12 00:03:39\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-04 17:25:09\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-20 19:38:18\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-11 19:46:19\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-12 01:36:29\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-18 13:19:43\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.10/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.16/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.21/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-09 22:28:42\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-07 14:13:54\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-09 05:28:03\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-05 11:05:30\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-08 15:48:40\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-23 02:08:36\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 05:44:18\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-12 22:29:22\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-09 12:47:08\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.6/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-14 09:01:45\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-03 05:12:26\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.33\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.33/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-02-25 08:05:38\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-20 06:03:57\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-22 18:23:30\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-15 15:41:38\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-16 18:27:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-08 14:57:21\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.26\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.26/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-22 09:30:33\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.6/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.21\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.21/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-16 17:32:57\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-17 02:23:27\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-18 23:37:35\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.7.1/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-11 17:53:34\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.7.1/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-13 13:11:03\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.5/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-02 13:58:02\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:5:\"6.0.9\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.0.9/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-10-05 15:57:37\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-09 17:43:36\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.15\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.15/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.38\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.38/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-12 04:54:58\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-08-30 11:32:23\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.6.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-14 19:26:39\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.7.1/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-16 22:01:55\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-21 10:05:18\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.25/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-17 08:07:10\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.34\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.34/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-22 09:42:36\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.7.1/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-09 14:12:56\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.5/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-11-25 10:54:59\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-13 11:11:27\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-08 14:55:39\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.16/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-13 04:29:01\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.6.2\";s:7:\"updated\";s:19:\"2024-09-21 09:44:08\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.6.2/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-08-30 07:14:35\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-12 17:27:08\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-09-20 22:15:56\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-08 15:52:55\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-12 13:48:13\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.38\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.38/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.10\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.10/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:6:\"4.8.25\";s:7:\"updated\";s:19:\"2017-09-30 09:04:29\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.8.25/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-06 13:44:46\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-12 13:35:42\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"6.4.5\";s:7:\"updated\";s:19:\"2024-03-06 18:52:07\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.5/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.16\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.16/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-14 00:43:38\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.7.1/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2024-12-23 16:50:06\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.7.1\";s:7:\"updated\";s:19:\"2025-01-12 05:35:18\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.7.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.6\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.6/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}}", "off");
INSERT INTO `wp_options` VALUES("8933", "_site_transient_timeout_fs_garbage_collection", "1737710467", "off");
INSERT INTO `wp_options` VALUES("8934", "_site_transient_fs_garbage_collection", "1", "off");
INSERT INTO `wp_options` VALUES("8935", "_transient_timeout_us_update_addons_data_Impreza", "1737645668", "off");
INSERT INTO `wp_options` VALUES("8936", "_transient_us_update_addons_data_Impreza", "O:8:\"stdClass\":2:{s:7:\"success\";i:0;s:6:\"errors\";O:8:\"stdClass\":1:{s:44:\"for_wordpress.validation.purchase_code.wrong\";s:30:\"validation.purchase_code.wrong\";}}", "off");
INSERT INTO `wp_options` VALUES("8937", "_site_transient_timeout_browser_f51bb482c660d0eeadd1f058058a2b35", "1738228869", "off");
INSERT INTO `wp_options` VALUES("8938", "_site_transient_browser_f51bb482c660d0eeadd1f058058a2b35", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"131.0.0.0\";s:8:\"platform\";s:7:\"Windows\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("8939", "_site_transient_timeout_browser_0845b309c7b9b957afd9ecf775a4c21f", "1738228883", "off");
INSERT INTO `wp_options` VALUES("8940", "_site_transient_browser_0845b309c7b9b957afd9ecf775a4c21f", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"131.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("8942", "_site_transient_timeout_wp_theme_files_patterns-9957f41876b74c45780eca6df5d277a6", "1737625977", "off");
INSERT INTO `wp_options` VALUES("8943", "_site_transient_wp_theme_files_patterns-9957f41876b74c45780eca6df5d277a6", "a:2:{s:7:\"version\";s:3:\"1.0\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("8944", "_site_transient_timeout_wp_theme_files_patterns-6d773f40cb2a55e4290884a6cefc5f45", "1737625977", "off");
INSERT INTO `wp_options` VALUES("8945", "_site_transient_wp_theme_files_patterns-6d773f40cb2a55e4290884a6cefc5f45", "a:2:{s:7:\"version\";s:6:\"8.32.1\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("8946", "duplicator_expire_search-replace-wpcode", "{\"expire\":1738833957,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.0\"}}", "on");
INSERT INTO `wp_options` VALUES("8947", "duplicator_expire_wp-mail-smtp", "{\"expire\":1738833957,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.2\"}}", "on");
INSERT INTO `wp_options` VALUES("8948", "duplicator_expire_all-in-one-seo-pack", "{\"expire\":1738833957,\"value\":{\"wp_version\":\"5.3\",\"php_version\":\"7.0\"}}", "on");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("3", "5", "_us_in_content_ids", "");
INSERT INTO `wp_postmeta` VALUES("4", "5", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("5", "5", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("6", "5", "_form_control", "a:5:{s:4:\"nome\";a:5:{s:8:\"required\";s:1:\"1\";s:13:\"control_label\";s:4:\"Nome\";s:12:\"control_name\";s:4:\"nome\";s:9:\"input_css\";s:57:\".vc_custom_1676330913065{margin-bottom: 10px !important;}\";s:3:\"tag\";s:14:\"dhvc_form_text\";}s:5:\"email\";a:5:{s:8:\"required\";s:1:\"1\";s:13:\"control_label\";s:5:\"Email\";s:12:\"control_name\";s:5:\"email\";s:9:\"input_css\";s:57:\".vc_custom_1676159579023{margin-bottom: 10px !important;}\";s:3:\"tag\";s:15:\"dhvc_form_email\";}s:8:\"telefone\";a:5:{s:8:\"required\";s:1:\"1\";s:13:\"control_label\";s:8:\"Telefone\";s:12:\"control_name\";s:8:\"telefone\";s:9:\"input_css\";s:57:\".vc_custom_1676330923395{margin-bottom: 10px !important;}\";s:3:\"tag\";s:14:\"dhvc_form_text\";}s:8:\"mensagem\";a:5:{s:8:\"required\";s:1:\"1\";s:13:\"control_label\";s:8:\"Mensagem\";s:12:\"control_name\";s:8:\"mensagem\";s:9:\"input_css\";s:57:\".vc_custom_1676330935633{margin-bottom: 20px !important;}\";s:3:\"tag\";s:18:\"dhvc_form_textarea\";}s:5:\"optin\";a:5:{s:8:\"required\";s:1:\"1\";s:12:\"control_name\";s:5:\"optin\";s:7:\"options\";s:320:\"W3siaXNfZGVmYXVsdCI6MCwibGFiZWwiOiI8c3BhbiBzdHlsZT1cImZvbnQtc2l6ZTowLjdyZW0gIWltcG9ydGFudDtcIj5Fc3RvdSBkZSBhY29yZG8gY29tIGEgPGEgaHJlZj1cIi9wb2xpdGljYS1wcml2YWNpZGFkZS9cIiB0YXJnZXQ9XCJfYmxhbmtcIiByZWw9XCJub29wZW5lclwiPlBvbMOtdGljYSBkZSBQcml2YWNpZGFkZTwvYT4gcXVlIGxpIGUgY29tcHJlZW5kaS48L3NwYW4+IiwidmFsdWUiOiJvcHRpbiJ9XQ==\";s:9:\"input_css\";s:57:\".vc_custom_1676330982083{margin-bottom: 20px !important;}\";s:3:\"tag\";s:18:\"dhvc_form_checkbox\";}}");
INSERT INTO `wp_postmeta` VALUES("7", "5", "_save_data", "1");
INSERT INTO `wp_postmeta` VALUES("8", "5", "_action_type", "default");
INSERT INTO `wp_postmeta` VALUES("9", "5", "_method", "post");
INSERT INTO `wp_postmeta` VALUES("10", "5", "_on_success", "message");
INSERT INTO `wp_postmeta` VALUES("11", "5", "_message", "A sua mensagem foi enviada com sucesso.");
INSERT INTO `wp_postmeta` VALUES("12", "5", "_message_position", "bottom");
INSERT INTO `wp_postmeta` VALUES("13", "5", "_redirect_to", "to_page");
INSERT INTO `wp_postmeta` VALUES("14", "5", "_page", "2");
INSERT INTO `wp_postmeta` VALUES("15", "5", "_post", "1");
INSERT INTO `wp_postmeta` VALUES("16", "5", "_form_popup_width", "600");
INSERT INTO `wp_postmeta` VALUES("17", "5", "_form_popup_auto_open_delay", "2000");
INSERT INTO `wp_postmeta` VALUES("18", "5", "_form_popup_auto_close_delay", "10000");
INSERT INTO `wp_postmeta` VALUES("19", "5", "_notice", "1");
INSERT INTO `wp_postmeta` VALUES("20", "5", "_notice_name", "Mid Template");
INSERT INTO `wp_postmeta` VALUES("21", "5", "_notice_email_type", "email_text");
INSERT INTO `wp_postmeta` VALUES("22", "5", "_notice_email", "it@makeitdigital.pt");
INSERT INTO `wp_postmeta` VALUES("23", "5", "_notice_recipients", "a:1:{i:0;s:19:\"it@makeitdigital.pt\";}");
INSERT INTO `wp_postmeta` VALUES("24", "5", "_notice_subject", "New form submission");
INSERT INTO `wp_postmeta` VALUES("25", "5", "_notice_body", "[form_title]\r\n\r\n[form_body]");
INSERT INTO `wp_postmeta` VALUES("26", "5", "_reply_name", "Mid Template");
INSERT INTO `wp_postmeta` VALUES("27", "5", "_reply_email", "it@makeitdigital.pt");
INSERT INTO `wp_postmeta` VALUES("28", "5", "_reply_subject", "Just Confirming");
INSERT INTO `wp_postmeta` VALUES("29", "5", "_reply_body", "This is just a confirmation message. We have received you reply.");
INSERT INTO `wp_postmeta` VALUES("30", "5", "_form_layout", "vertical");
INSERT INTO `wp_postmeta` VALUES("31", "5", "_input_icon_position", "right");
INSERT INTO `wp_postmeta` VALUES("32", "5", "_dhvc_form_messages", "a:30:{s:7:\"success\";s:40:\"Obrigado pela sua mensagem. Foi enviada.\";s:23:\"upload_failed_php_error\";s:37:\"Houve um erro ao carregar o ficheiro.\";s:17:\"invalid_recaptcha\";s:30:\"Não condiz. Por favor repita.\";s:19:\"recaptcha_not_check\";s:42:\"Por favor, verifique que não é um robô.\";s:17:\"captcha_not_match\";s:39:\"O que foi introduzido está incorrecto.\";s:16:\"validation_error\";s:71:\"Um ou mais campos têm um erro. Por favor, verifique e tente novamente.\";s:4:\"spam\";s:85:\"Houve um erro ao tentar enviar a sua mensagem. Por favor, tente novamente mais tarde.\";s:5:\"error\";s:85:\"Houve um erro ao tentar enviar a sua mensagem. Por favor, tente novamente mais tarde.\";s:16:\"invalid_required\";s:27:\"Este campo é obrigatório.\";s:13:\"invalid_email\";s:65:\"Por favor introduza um endereço de correio electrónico válido.\";s:11:\"invalid_url\";s:76:\"Please enter a valid URL. Protocol is required (http://, https:// or ftp://)\";s:12:\"invalid_date\";s:26:\"Please enter a valid date.\";s:12:\"invalid_time\";s:26:\"Please enter a valid time.\";s:14:\"invalid_number\";s:28:\"Please enter a valid number.\";s:15:\"invalid_number2\";s:67:\"Please use only numbers (0-9) or brackets (), dashes – and plus +\";s:14:\"invalid_digits\";s:25:\"Please enter only digits.\";s:11:\"invalid_max\";s:46:\"Please enter a value less than or equal to %s.\";s:11:\"invalid_min\";s:49:\"Please enter a value greater than or equal to %s.\";s:16:\"invalid_too_long\";s:23:\"This input is too long.\";s:17:\"invalid_too_short\";s:24:\"This input is too short.\";s:13:\"invalid_alpha\";s:51:\"Please use letters only (a-z or A-Z) in this field.\";s:16:\"invalid_alphanum\";s:116:\"Please use only letters (a-z or A-Z) or numbers (0-9) only in this field. No spaces or other characters are allowed.\";s:11:\"invalid_zip\";s:63:\"Please enter a valid zip code. For example 90602 or 90602-1234.\";s:11:\"invalid_fax\";s:76:\"Please enter a valid fax number. For example (123) 456-7890 or 123-456-7890.\";s:17:\"invalid_cpassword\";s:38:\"Please make sure your passwords match.\";s:14:\"invalid_cemail\";s:34:\"Please make sure your email match.\";s:14:\"invalid_select\";s:23:\"Please select an option\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:21:\"upload_file_too_large\";s:20:\"The file is too big.\";}");
INSERT INTO `wp_postmeta` VALUES("33", "5", "_paypal_currency", "USD");
INSERT INTO `wp_postmeta` VALUES("34", "5", "_paypal_currency_position", "left");
INSERT INTO `wp_postmeta` VALUES("35", "5", "_us_jsoncss_data", "a:5:{i:0;s:57:\".vc_custom_1676330913065{margin-bottom: 10px !important;}\";i:1;s:57:\".vc_custom_1676159579023{margin-bottom: 10px !important;}\";i:2;s:57:\".vc_custom_1676330923395{margin-bottom: 10px !important;}\";i:3;s:57:\".vc_custom_1676330935633{margin-bottom: 20px !important;}\";i:4;s:57:\".vc_custom_1676330982083{margin-bottom: 20px !important;}\";}");
INSERT INTO `wp_postmeta` VALUES("36", "5", "us_og_image", "");
INSERT INTO `wp_postmeta` VALUES("37", "5", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("38", "5", "_wpb_shortcodes_custom_css", ".vc_custom_1676330913065{margin-bottom: 10px !important;}.vc_custom_1676159579023{margin-bottom: 10px !important;}.vc_custom_1676330923395{margin-bottom: 10px !important;}.vc_custom_1676330935633{margin-bottom: 20px !important;}.vc_custom_1676330982083{margin-bottom: 20px !important;}");
INSERT INTO `wp_postmeta` VALUES("39", "5", "_edit_lock", "1679661635:1");
INSERT INTO `wp_postmeta` VALUES("40", "2", "_edit_lock", "1676371782:1");
INSERT INTO `wp_postmeta` VALUES("41", "2", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("42", "2", "_us_jsoncss_data", NULL);
INSERT INTO `wp_postmeta` VALUES("43", "2", "_us_in_content_ids", "13");
INSERT INTO `wp_postmeta` VALUES("44", "2", "us_og_image", "");
INSERT INTO `wp_postmeta` VALUES("45", "2", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("46", "2", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("47", "2", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("48", "2", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("49", "2", "us_header_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("50", "2", "us_header_sticky_override", NULL);
INSERT INTO `wp_postmeta` VALUES("51", "2", "us_header_sticky", "");
INSERT INTO `wp_postmeta` VALUES("52", "2", "us_header_transparent_override", NULL);
INSERT INTO `wp_postmeta` VALUES("53", "2", "us_header_transparent", "");
INSERT INTO `wp_postmeta` VALUES("54", "2", "us_header_shadow", NULL);
INSERT INTO `wp_postmeta` VALUES("55", "2", "us_header_sticky_pos", "");
INSERT INTO `wp_postmeta` VALUES("56", "2", "us_content_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("57", "2", "us_footer_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("58", "2", "us_tile_additional_image", "");
INSERT INTO `wp_postmeta` VALUES("59", "2", "us_tile_link", "{\"url\":\"\",\"target\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("60", "2", "us_tile_icon", "");
INSERT INTO `wp_postmeta` VALUES("61", "2", "us_tile_size", "1x1");
INSERT INTO `wp_postmeta` VALUES("62", "2", "us_tile_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("63", "2", "us_tile_text_color", "");
INSERT INTO `wp_postmeta` VALUES("64", "2", "us_meta_title", "");
INSERT INTO `wp_postmeta` VALUES("65", "2", "us_meta_description", "");
INSERT INTO `wp_postmeta` VALUES("66", "2", "us_meta_robots", "");
INSERT INTO `wp_postmeta` VALUES("67", "7", "_us_in_content_ids", "");
INSERT INTO `wp_postmeta` VALUES("68", "7", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("69", "7", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("70", "7", "_form_control", "a:5:{s:4:\"name\";a:5:{s:8:\"required\";s:1:\"1\";s:13:\"control_label\";s:4:\"Name\";s:12:\"control_name\";s:4:\"name\";s:9:\"input_css\";s:57:\".vc_custom_1676331511714{margin-bottom: 10px !important;}\";s:3:\"tag\";s:14:\"dhvc_form_text\";}s:5:\"email\";a:5:{s:8:\"required\";s:1:\"1\";s:13:\"control_label\";s:5:\"Email\";s:12:\"control_name\";s:5:\"email\";s:9:\"input_css\";s:57:\".vc_custom_1676159579023{margin-bottom: 10px !important;}\";s:3:\"tag\";s:15:\"dhvc_form_email\";}s:5:\"phone\";a:5:{s:8:\"required\";s:1:\"1\";s:13:\"control_label\";s:5:\"Phone\";s:12:\"control_name\";s:5:\"phone\";s:9:\"input_css\";s:57:\".vc_custom_1676331520066{margin-bottom: 10px !important;}\";s:3:\"tag\";s:14:\"dhvc_form_text\";}s:7:\"message\";a:5:{s:8:\"required\";s:1:\"1\";s:13:\"control_label\";s:7:\"Message\";s:12:\"control_name\";s:7:\"message\";s:9:\"input_css\";s:57:\".vc_custom_1676331529269{margin-bottom: 20px !important;}\";s:3:\"tag\";s:18:\"dhvc_form_textarea\";}s:5:\"optin\";a:5:{s:8:\"required\";s:1:\"1\";s:12:\"control_name\";s:5:\"optin\";s:7:\"options\";s:320:\"W3siaXNfZGVmYXVsdCI6MCwibGFiZWwiOiI8c3BhbiBzdHlsZT1cImZvbnQtc2l6ZTowLjdyZW0gIWltcG9ydGFudDtcIj5Fc3RvdSBkZSBhY29yZG8gY29tIGEgPGEgaHJlZj1cIi9wb2xpdGljYS1wcml2YWNpZGFkZS9cIiB0YXJnZXQ9XCJfYmxhbmtcIiByZWw9XCJub29wZW5lclwiPlBvbMOtdGljYSBkZSBQcml2YWNpZGFkZTwvYT4gcXVlIGxpIGUgY29tcHJlZW5kaS48L3NwYW4+IiwidmFsdWUiOiJvcHRpbiJ9XQ==\";s:9:\"input_css\";s:57:\".vc_custom_1676330982083{margin-bottom: 20px !important;}\";s:3:\"tag\";s:18:\"dhvc_form_checkbox\";}}");
INSERT INTO `wp_postmeta` VALUES("71", "7", "_save_data", "1");
INSERT INTO `wp_postmeta` VALUES("72", "7", "_action_type", "default");
INSERT INTO `wp_postmeta` VALUES("73", "7", "_method", "post");
INSERT INTO `wp_postmeta` VALUES("74", "7", "_on_success", "message");
INSERT INTO `wp_postmeta` VALUES("75", "7", "_message", "Your message has been sent. Thanks!");
INSERT INTO `wp_postmeta` VALUES("76", "7", "_message_position", "bottom");
INSERT INTO `wp_postmeta` VALUES("77", "7", "_redirect_to", "to_page");
INSERT INTO `wp_postmeta` VALUES("78", "7", "_post", "1");
INSERT INTO `wp_postmeta` VALUES("79", "7", "_form_popup_width", "600");
INSERT INTO `wp_postmeta` VALUES("80", "7", "_form_popup_auto_open_delay", "2000");
INSERT INTO `wp_postmeta` VALUES("81", "7", "_form_popup_auto_close_delay", "10000");
INSERT INTO `wp_postmeta` VALUES("82", "7", "_notice", "1");
INSERT INTO `wp_postmeta` VALUES("83", "7", "_notice_name", "Mid Template");
INSERT INTO `wp_postmeta` VALUES("84", "7", "_notice_email_type", "email_text");
INSERT INTO `wp_postmeta` VALUES("85", "7", "_notice_email", "it@makeitdigital.pt");
INSERT INTO `wp_postmeta` VALUES("86", "7", "_notice_recipients", "a:1:{i:0;s:19:\"it@makeitdigital.pt\";}");
INSERT INTO `wp_postmeta` VALUES("87", "7", "_notice_subject", "New form submission");
INSERT INTO `wp_postmeta` VALUES("88", "7", "_notice_body", "[form_title]\r\n\r\n[form_body]");
INSERT INTO `wp_postmeta` VALUES("89", "7", "_reply_name", "Mid Template");
INSERT INTO `wp_postmeta` VALUES("90", "7", "_reply_email", "it@makeitdigital.pt");
INSERT INTO `wp_postmeta` VALUES("91", "7", "_reply_subject", "Just Confirming");
INSERT INTO `wp_postmeta` VALUES("92", "7", "_reply_body", "This is just a confirmation message. We have received you reply.");
INSERT INTO `wp_postmeta` VALUES("93", "7", "_form_layout", "vertical");
INSERT INTO `wp_postmeta` VALUES("94", "7", "_input_icon_position", "right");
INSERT INTO `wp_postmeta` VALUES("95", "7", "_dhvc_form_messages", "a:30:{s:7:\"success\";s:45:\"Thank you for your message. It has been sent.\";s:23:\"upload_failed_php_error\";s:38:\"There was an error uploading the file.\";s:17:\"invalid_recaptcha\";s:17:\"reCaptcha Invalid\";s:19:\"recaptcha_not_check\";s:39:\"Please verify that you are not a robot.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:5:\"error\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"invalid_required\";s:23:\"This field is required.\";s:13:\"invalid_email\";s:35:\"Please enter a valid email address.\";s:11:\"invalid_url\";s:76:\"Please enter a valid URL. Protocol is required (http://, https:// or ftp://)\";s:12:\"invalid_date\";s:26:\"Please enter a valid date.\";s:12:\"invalid_time\";s:26:\"Please enter a valid time.\";s:14:\"invalid_number\";s:28:\"Please enter a valid number.\";s:15:\"invalid_number2\";s:67:\"Please use only numbers (0-9) or brackets (), dashes – and plus +\";s:14:\"invalid_digits\";s:25:\"Please enter only digits.\";s:11:\"invalid_max\";s:46:\"Please enter a value less than or equal to %s.\";s:11:\"invalid_min\";s:49:\"Please enter a value greater than or equal to %s.\";s:16:\"invalid_too_long\";s:23:\"This input is too long.\";s:17:\"invalid_too_short\";s:24:\"This input is too short.\";s:13:\"invalid_alpha\";s:51:\"Please use letters only (a-z or A-Z) in this field.\";s:16:\"invalid_alphanum\";s:116:\"Please use only letters (a-z or A-Z) or numbers (0-9) only in this field. No spaces or other characters are allowed.\";s:11:\"invalid_zip\";s:63:\"Please enter a valid zip code. For example 90602 or 90602-1234.\";s:11:\"invalid_fax\";s:76:\"Please enter a valid fax number. For example (123) 456-7890 or 123-456-7890.\";s:17:\"invalid_cpassword\";s:38:\"Please make sure your passwords match.\";s:14:\"invalid_cemail\";s:34:\"Please make sure your email match.\";s:14:\"invalid_select\";s:23:\"Please select an option\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:21:\"upload_file_too_large\";s:20:\"The file is too big.\";}");
INSERT INTO `wp_postmeta` VALUES("96", "7", "_paypal_currency", "USD");
INSERT INTO `wp_postmeta` VALUES("97", "7", "_paypal_currency_position", "left");
INSERT INTO `wp_postmeta` VALUES("98", "7", "_us_jsoncss_data", "a:5:{i:0;s:57:\".vc_custom_1676331511714{margin-bottom: 10px !important;}\";i:1;s:57:\".vc_custom_1676159579023{margin-bottom: 10px !important;}\";i:2;s:57:\".vc_custom_1676331520066{margin-bottom: 10px !important;}\";i:3;s:57:\".vc_custom_1676331529269{margin-bottom: 20px !important;}\";i:4;s:57:\".vc_custom_1676330982083{margin-bottom: 20px !important;}\";}");
INSERT INTO `wp_postmeta` VALUES("99", "7", "us_og_image", "");
INSERT INTO `wp_postmeta` VALUES("100", "7", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("101", "7", "_wpb_shortcodes_custom_css", ".vc_custom_1676331511714{margin-bottom: 10px !important;}.vc_custom_1676159579023{margin-bottom: 10px !important;}.vc_custom_1676331520066{margin-bottom: 10px !important;}.vc_custom_1676331529269{margin-bottom: 20px !important;}.vc_custom_1676330982083{margin-bottom: 20px !important;}");
INSERT INTO `wp_postmeta` VALUES("102", "7", "_edit_lock", "1676331418:1");
INSERT INTO `wp_postmeta` VALUES("103", "8", "_us_in_content_ids", "");
INSERT INTO `wp_postmeta` VALUES("104", "8", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("105", "8", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("106", "8", "_edit_lock", "1676331576:1");
INSERT INTO `wp_postmeta` VALUES("107", "8", "accessibility_options", "a:3:{i:0;s:6:\"public\";i:1;s:18:\"publicly_queryable\";i:2;s:7:\"show_ui\";}");
INSERT INTO `wp_postmeta` VALUES("108", "8", "_accessibility_options", "field_5a739f02d85ab");
INSERT INTO `wp_postmeta` VALUES("109", "8", "capability_type", "page");
INSERT INTO `wp_postmeta` VALUES("110", "8", "_capability_type", "field_5a73a52c83ed7");
INSERT INTO `wp_postmeta` VALUES("111", "8", "menu_visibility", "a:3:{i:0;s:12:\"show_in_menu\";i:1;s:17:\"show_in_nav_menus\";i:2;s:17:\"show_in_admin_bar\";}");
INSERT INTO `wp_postmeta` VALUES("112", "8", "_menu_visibility", "field_5a739b5e2a576");
INSERT INTO `wp_postmeta` VALUES("113", "8", "menu_position", "5");
INSERT INTO `wp_postmeta` VALUES("114", "8", "_menu_position", "field_5a739ff5d85ac");
INSERT INTO `wp_postmeta` VALUES("115", "8", "menu_icon", "dashicons-slides");
INSERT INTO `wp_postmeta` VALUES("116", "8", "_menu_icon", "field_5a73a04ad85ad");
INSERT INTO `wp_postmeta` VALUES("117", "8", "has_archive", "no");
INSERT INTO `wp_postmeta` VALUES("118", "8", "_has_archive", "field_5a73a6ce83eda");
INSERT INTO `wp_postmeta` VALUES("119", "8", "rewrite", "yes");
INSERT INTO `wp_postmeta` VALUES("120", "8", "_rewrite", "field_5a73a78083edb");
INSERT INTO `wp_postmeta` VALUES("121", "8", "query_var", "");
INSERT INTO `wp_postmeta` VALUES("122", "8", "_query_var", "field_5a73a84a83ede");
INSERT INTO `wp_postmeta` VALUES("123", "8", "show_in_rest", "1");
INSERT INTO `wp_postmeta` VALUES("124", "8", "_show_in_rest", "field_5a7af6fb4b0d3");
INSERT INTO `wp_postmeta` VALUES("125", "8", "rest_base", "");
INSERT INTO `wp_postmeta` VALUES("126", "8", "_rest_base", "field_5a7af70734255");
INSERT INTO `wp_postmeta` VALUES("127", "8", "rest_controller_class", "");
INSERT INTO `wp_postmeta` VALUES("128", "8", "_rest_controller_class", "field_5a7af70fa8cd3");
INSERT INTO `wp_postmeta` VALUES("129", "8", "post_type", "slide_home");
INSERT INTO `wp_postmeta` VALUES("130", "8", "_post_type", "field_5a7399af2a574");
INSERT INTO `wp_postmeta` VALUES("131", "8", "supported_features", "a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";}");
INSERT INTO `wp_postmeta` VALUES("132", "8", "_supported_features", "field_5a73a58383ed8");
INSERT INTO `wp_postmeta` VALUES("133", "8", "other_options", "a:1:{i:0;s:10:\"can_export\";}");
INSERT INTO `wp_postmeta` VALUES("134", "8", "_other_options", "field_5a73add4ad095");
INSERT INTO `wp_postmeta` VALUES("135", "8", "taxonomies", "");
INSERT INTO `wp_postmeta` VALUES("136", "8", "_taxonomies", "field_5a76eec02594a");
INSERT INTO `wp_postmeta` VALUES("137", "8", "description", "");
INSERT INTO `wp_postmeta` VALUES("138", "8", "_description", "field_5a77850527d7d");
INSERT INTO `wp_postmeta` VALUES("139", "8", "singular_name", "Slide");
INSERT INTO `wp_postmeta` VALUES("140", "8", "_singular_name", "field_5a7399602a573");
INSERT INTO `wp_postmeta` VALUES("141", "8", "menu_name", "");
INSERT INTO `wp_postmeta` VALUES("142", "8", "_menu_name", "field_5a75e9825029c");
INSERT INTO `wp_postmeta` VALUES("143", "8", "admin_bar_name", "");
INSERT INTO `wp_postmeta` VALUES("144", "8", "_admin_bar_name", "field_5a75e9b35029d");
INSERT INTO `wp_postmeta` VALUES("145", "8", "archives", "");
INSERT INTO `wp_postmeta` VALUES("146", "8", "_archives", "field_5a75e9bd5029e");
INSERT INTO `wp_postmeta` VALUES("147", "8", "attributes", "");
INSERT INTO `wp_postmeta` VALUES("148", "8", "_attributes", "field_5a75e9cc5029f");
INSERT INTO `wp_postmeta` VALUES("149", "8", "parent_item_colon", "");
INSERT INTO `wp_postmeta` VALUES("150", "8", "_parent_item_colon", "field_5a75e9d6502a0");
INSERT INTO `wp_postmeta` VALUES("151", "8", "all_items", "Slides");
INSERT INTO `wp_postmeta` VALUES("152", "8", "_all_items", "field_5a75e9df502a1");
INSERT INTO `wp_postmeta` VALUES("153", "8", "add_new_item", "");
INSERT INTO `wp_postmeta` VALUES("154", "8", "_add_new_item", "field_5a75e9e8502a2");
INSERT INTO `wp_postmeta` VALUES("155", "8", "add_new", "");
INSERT INTO `wp_postmeta` VALUES("156", "8", "_add_new", "field_5a75e9f2502a3");
INSERT INTO `wp_postmeta` VALUES("157", "8", "new_item", "");
INSERT INTO `wp_postmeta` VALUES("158", "8", "_new_item", "field_5a75e9fa502a4");
INSERT INTO `wp_postmeta` VALUES("159", "8", "edit_item", "");
INSERT INTO `wp_postmeta` VALUES("160", "8", "_edit_item", "field_5a75ea02502a5");
INSERT INTO `wp_postmeta` VALUES("161", "8", "update_item", "");
INSERT INTO `wp_postmeta` VALUES("162", "8", "_update_item", "field_5a75ea0a502a6");
INSERT INTO `wp_postmeta` VALUES("163", "8", "view_item", "");
INSERT INTO `wp_postmeta` VALUES("164", "8", "_view_item", "field_5a75ea1c502a7");
INSERT INTO `wp_postmeta` VALUES("165", "8", "view_items", "");
INSERT INTO `wp_postmeta` VALUES("166", "8", "_view_items", "field_5a75ea24502a8");
INSERT INTO `wp_postmeta` VALUES("167", "8", "search_items", "");
INSERT INTO `wp_postmeta` VALUES("168", "8", "_search_items", "field_5a75ea2c502a9");
INSERT INTO `wp_postmeta` VALUES("169", "8", "not_found", "");
INSERT INTO `wp_postmeta` VALUES("170", "8", "_not_found", "field_5a75ea35502aa");
INSERT INTO `wp_postmeta` VALUES("171", "8", "not_found_in_trash", "");
INSERT INTO `wp_postmeta` VALUES("172", "8", "_not_found_in_trash", "field_5a75ea3e502ab");
INSERT INTO `wp_postmeta` VALUES("173", "8", "featured_image", "");
INSERT INTO `wp_postmeta` VALUES("174", "8", "_featured_image", "field_5a75ea47502ac");
INSERT INTO `wp_postmeta` VALUES("175", "8", "set_featured_image", "");
INSERT INTO `wp_postmeta` VALUES("176", "8", "_set_featured_image", "field_5a75ea51502ad");
INSERT INTO `wp_postmeta` VALUES("177", "8", "remove_featured_image", "");
INSERT INTO `wp_postmeta` VALUES("178", "8", "_remove_featured_image", "field_5a75ea59502ae");
INSERT INTO `wp_postmeta` VALUES("179", "8", "use_featured_image", "");
INSERT INTO `wp_postmeta` VALUES("180", "8", "_use_featured_image", "field_5a75ea60502af");
INSERT INTO `wp_postmeta` VALUES("181", "8", "insert_into_item", "");
INSERT INTO `wp_postmeta` VALUES("182", "8", "_insert_into_item", "field_5a75ea6b502b0");
INSERT INTO `wp_postmeta` VALUES("183", "8", "uploaded_to_this_item", "");
INSERT INTO `wp_postmeta` VALUES("184", "8", "_uploaded_to_this_item", "field_5a75ea74502b1");
INSERT INTO `wp_postmeta` VALUES("185", "8", "items_list", "");
INSERT INTO `wp_postmeta` VALUES("186", "8", "_items_list", "field_5a75ea7c502b2");
INSERT INTO `wp_postmeta` VALUES("187", "8", "items_list_navigation", "");
INSERT INTO `wp_postmeta` VALUES("188", "8", "_items_list_navigation", "field_5a75ea83502b3");
INSERT INTO `wp_postmeta` VALUES("189", "8", "filter_items_list", "");
INSERT INTO `wp_postmeta` VALUES("190", "8", "_filter_items_list", "field_5a75ea8c502b4");
INSERT INTO `wp_postmeta` VALUES("191", "9", "_us_in_content_ids", "");
INSERT INTO `wp_postmeta` VALUES("192", "9", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("193", "9", "_edit_lock", "1676331654:1");
INSERT INTO `wp_postmeta` VALUES("194", "9", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("195", "9", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("196", "9", "_us_jsoncss_data", NULL);
INSERT INTO `wp_postmeta` VALUES("197", "9", "us_og_image", "");
INSERT INTO `wp_postmeta` VALUES("200", "10", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("201", "10", "_edit_lock", "1733928852:1");
INSERT INTO `wp_postmeta` VALUES("202", "10", "_us_jsoncss_data", "a:2:{i:0;s:76:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_header_middle_bg%22%7D%7D\";i:1;s:232:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22padding-bottom%22%3A%2220px%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("204", "10", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("205", "10", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("206", "10", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("208", "10", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("210", "12", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("211", "12", "_edit_lock", "1733932480:1");
INSERT INTO `wp_postmeta` VALUES("212", "12", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("213", "12", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("217", "13", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("218", "13", "_edit_lock", "1733930164:1");
INSERT INTO `wp_postmeta` VALUES("219", "13", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("220", "13", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("223", "2", "_us_first_grid_post_type", "a:1:{i:0;s:4:\"post\";}");
INSERT INTO `wp_postmeta` VALUES("224", "2", "us_titlebar_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("225", "2", "us_sidebar_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("226", "2", "us_sidebar_pos", "right");
INSERT INTO `wp_postmeta` VALUES("228", "15", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("229", "15", "_edit_lock", "1733934325:1");
INSERT INTO `wp_postmeta` VALUES("230", "15", "_us_jsoncss_data", "a:21:{i:0;s:273:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22background-image%22%3A%22281%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\";i:1;s:53:\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\";i:2;s:378:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-left%22%3A%2210px%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\";i:3;s:131:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%2C%22margin-left%22%3A%2210px%22%7D%7D\";i:4;s:98:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\";i:5;s:98:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\";i:6;s:85:\"%7B%22default%22%3A%7B%22width%22%3A%22123px%22%2C%22margin-top%22%3A%223rem%22%7D%7D\";i:7;s:144:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\";i:8;s:53:\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\";i:9;s:345:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\";i:10;s:98:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\";i:11;s:98:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\";i:12;s:98:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\";i:13;s:102:\"%7B%22default%22%3A%7B%22width%22%3A%22123px%22%2C%22bottom%22%3A%220%22%2C%22right%22%3A%220%22%7D%7D\";i:14;s:141:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\";i:15;s:170:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\";i:16;s:170:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\";i:17;s:170:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\";i:18;s:98:\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\";i:19;s:203:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\";i:20;s:203:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("231", "15", "us_og_image", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_ico_-02.svg");
INSERT INTO `wp_postmeta` VALUES("232", "15", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("233", "15", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("234", "15", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("236", "15", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("237", "3", "_edit_lock", "1676371534:1");
INSERT INTO `wp_postmeta` VALUES("238", "3", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("240", "3", "_us_in_content_ids", "");
INSERT INTO `wp_postmeta` VALUES("241", "3", "us_og_image", "");
INSERT INTO `wp_postmeta` VALUES("242", "3", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("243", "3", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("244", "3", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("245", "3", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("246", "3", "us_header_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("247", "3", "us_header_sticky_override", NULL);
INSERT INTO `wp_postmeta` VALUES("248", "3", "us_header_sticky", "");
INSERT INTO `wp_postmeta` VALUES("249", "3", "us_header_transparent_override", NULL);
INSERT INTO `wp_postmeta` VALUES("250", "3", "us_header_transparent", "");
INSERT INTO `wp_postmeta` VALUES("251", "3", "us_header_shadow", NULL);
INSERT INTO `wp_postmeta` VALUES("252", "3", "us_header_sticky_pos", "");
INSERT INTO `wp_postmeta` VALUES("253", "3", "us_titlebar_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("254", "3", "us_content_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("255", "3", "us_sidebar_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("256", "3", "us_sidebar_pos", "right");
INSERT INTO `wp_postmeta` VALUES("257", "3", "us_footer_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("258", "3", "us_tile_additional_image", "");
INSERT INTO `wp_postmeta` VALUES("259", "3", "us_tile_link", "{\"url\":\"\",\"target\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("260", "3", "us_tile_icon", "");
INSERT INTO `wp_postmeta` VALUES("261", "3", "us_tile_size", "1x1");
INSERT INTO `wp_postmeta` VALUES("262", "3", "us_tile_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("263", "3", "us_tile_text_color", "");
INSERT INTO `wp_postmeta` VALUES("264", "3", "us_meta_title", "");
INSERT INTO `wp_postmeta` VALUES("265", "3", "us_meta_description", "");
INSERT INTO `wp_postmeta` VALUES("266", "3", "us_meta_robots", "");
INSERT INTO `wp_postmeta` VALUES("267", "18", "_us_jsoncss_data", NULL);
INSERT INTO `wp_postmeta` VALUES("268", "18", "_us_in_content_ids", "");
INSERT INTO `wp_postmeta` VALUES("269", "18", "us_og_image", "");
INSERT INTO `wp_postmeta` VALUES("270", "18", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("271", "18", "_wpcode_auto_insert", "1");
INSERT INTO `wp_postmeta` VALUES("272", "18", "_wpcode_auto_insert_number", "1");
INSERT INTO `wp_postmeta` VALUES("273", "19", "_us_jsoncss_data", NULL);
INSERT INTO `wp_postmeta` VALUES("274", "19", "_us_in_content_ids", "");
INSERT INTO `wp_postmeta` VALUES("275", "19", "us_og_image", "");
INSERT INTO `wp_postmeta` VALUES("276", "19", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("277", "19", "_wpcode_auto_insert", "1");
INSERT INTO `wp_postmeta` VALUES("278", "19", "_wpcode_library_id", "12");
INSERT INTO `wp_postmeta` VALUES("279", "20", "_us_in_content_ids", "71");
INSERT INTO `wp_postmeta` VALUES("280", "20", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("281", "20", "_edit_lock", "1733927667:1");
INSERT INTO `wp_postmeta` VALUES("310", "20", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("311", "20", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("312", "20", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("316", "20", "_us_jsoncss_data", "a:12:{i:0;s:498:\"%7B%22default%22%3A%7B%22background-image%22%3A%22211%22%2C%22background-position%22%3A%22right%20250px%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\";i:1;s:231:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:2;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:3;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:4;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:5;s:311:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\";i:6;s:228:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%220.5rem%22%7D%7D\";i:7;s:230:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22700%22%2C%22margin-top%22%3A%221rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\";i:8;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\";i:9;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\";i:10;s:164:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\";i:11;s:449:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("318", "20", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("322", "31", "_wp_attached_file", "2023/02/logo.svg");
INSERT INTO `wp_postmeta` VALUES("323", "31", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:1273;}");
INSERT INTO `wp_postmeta` VALUES("324", "32", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("325", "32", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("326", "32", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("327", "33", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("328", "32", "_edit_lock", "1732216104:1");
INSERT INTO `wp_postmeta` VALUES("329", "34", "_wp_attached_file", "2023/02/logo-02.svg");
INSERT INTO `wp_postmeta` VALUES("330", "34", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:1273;}");
INSERT INTO `wp_postmeta` VALUES("331", "15", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("332", "35", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("333", "36", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("334", "36", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("335", "36", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("336", "37", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("337", "36", "_edit_lock", "1733937647:1");
INSERT INTO `wp_postmeta` VALUES("338", "38", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("339", "38", "_edit_lock", "1732217207:1");
INSERT INTO `wp_postmeta` VALUES("340", "39", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("341", "39", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("342", "39", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("343", "39", "_edit_lock", "1737624295:1");
INSERT INTO `wp_postmeta` VALUES("344", "40", "_wp_attached_file", "2024/11/DoorWin_img-1b.jpg");
INSERT INTO `wp_postmeta` VALUES("345", "40", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1750;s:6:\"height\";i:1016;s:4:\"file\";s:26:\"2024/11/DoorWin_img-1b.jpg\";s:8:\"filesize\";i:309545;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"DoorWin_img-1b-300x174.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:174;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14199;}s:5:\"large\";a:5:{s:4:\"file\";s:27:\"DoorWin_img-1b-1024x595.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:595;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:97787;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"DoorWin_img-1b-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7185;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("347", "36", "us_header_id", "12");
INSERT INTO `wp_postmeta` VALUES("348", "36", "us_header_transparent_override", "1");
INSERT INTO `wp_postmeta` VALUES("349", "36", "us_header_transparent", "default,laptops,tablets");
INSERT INTO `wp_postmeta` VALUES("350", "36", "_us_jsoncss_data", "a:24:{i:0;s:61:\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\";i:1;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\";i:2;s:239:\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\";i:3;s:163:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\";i:4;s:58:\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\";i:5;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\";i:6;s:239:\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\";i:7;s:241:\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\";i:8;s:279:\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\";i:9;s:341:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\";i:10;s:198:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\";i:11;s:189:\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:12;s:93:\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\";i:13;s:341:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\";i:14;s:198:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\";i:15;s:189:\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:16;s:93:\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\";i:17;s:341:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\";i:18;s:198:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\";i:19;s:189:\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:20;s:93:\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\";i:21;s:155:\"%7B%22default%22%3A%7B%22background-image%22%3A%22254%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:22;s:251:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\";i:23;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("352", "41", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("353", "42", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("354", "36", "us_titlebar_id", "0");
INSERT INTO `wp_postmeta` VALUES("355", "43", "_wp_attached_file", "woocommerce-placeholder.png");
INSERT INTO `wp_postmeta` VALUES("356", "43", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:1200;s:4:\"file\";s:27:\"woocommerce-placeholder.png\";s:8:\"filesize\";i:48149;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:35:\"woocommerce-placeholder-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10490;}s:5:\"large\";a:5:{s:4:\"file\";s:37:\"woocommerce-placeholder-1024x1024.png\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:79721;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:35:\"woocommerce-placeholder-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3762;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("361", "53", "_edit_lock", "1733932360:1");
INSERT INTO `wp_postmeta` VALUES("374", "62", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("375", "62", "_edit_lock", "1732299827:1");
INSERT INTO `wp_postmeta` VALUES("376", "62", "_awl_label_priority", "0");
INSERT INTO `wp_postmeta` VALUES("377", "62", "_awl_label", "a:4:{s:16:\"awl_label_status\";a:1:{s:6:\"status\";s:1:\"1\";}s:18:\"awl_label_priority\";a:1:{s:8:\"priority\";s:1:\"0\";}s:10:\"conditions\";a:1:{s:7:\"group_1\";a:1:{s:6:\"rule_1\";a:4:{s:5:\"param\";s:13:\"sale_discount\";s:9:\"suboption\";s:8:\"percents\";s:8:\"operator\";s:7:\"greater\";s:5:\"value\";s:1:\"1\";}}}s:8:\"settings\";a:16:{s:4:\"text\";s:15:\"{SAVE_PERCENT}%\";s:8:\"template\";s:8:\"standard\";s:13:\"position_type\";s:8:\"on_image\";s:8:\"position\";s:8:\"left_top\";s:10:\"position_x\";s:4:\"left\";s:13:\"custom_styles\";s:4:\"true\";s:8:\"bg_color\";s:7:\"#3986c6\";s:10:\"text_color\";s:4:\"#fff\";s:9:\"font_size\";s:2:\"14\";s:10:\"font_style\";s:6:\"normal\";s:11:\"font_weight\";s:3:\"700\";s:14:\"letter_spacing\";s:1:\"0\";s:7:\"opacity\";s:1:\"1\";s:7:\"padding\";a:4:{s:3:\"top\";s:3:\"0.5\";s:5:\"right\";s:3:\"0.6\";s:6:\"bottom\";s:3:\"0.5\";s:4:\"left\";s:3:\"0.6\";}s:6:\"margin\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:10:\"custom_css\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("393", "20", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("394", "70", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("395", "71", "_edit_lock", "1733930142:1");
INSERT INTO `wp_postmeta` VALUES("396", "72", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("397", "74", "_wp_attached_file", "2024/12/MID_btz_parceiro-0.jpg");
INSERT INTO `wp_postmeta` VALUES("398", "74", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:412;s:6:\"height\";i:207;s:4:\"file\";s:30:\"2024/12/MID_btz_parceiro-0.jpg\";s:8:\"filesize\";i:4309;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_btz_parceiro-0-300x151.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:151;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2751;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_btz_parceiro-0-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2207;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("399", "75", "_wp_attached_file", "2024/12/MID_btz_parceiro-1.jpg");
INSERT INTO `wp_postmeta` VALUES("400", "75", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:412;s:6:\"height\";i:207;s:4:\"file\";s:30:\"2024/12/MID_btz_parceiro-1.jpg\";s:8:\"filesize\";i:14892;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_btz_parceiro-1-300x151.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:151;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7738;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_btz_parceiro-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4802;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("401", "76", "_wp_attached_file", "2024/12/MID_btz_favicon.png");
INSERT INTO `wp_postmeta` VALUES("402", "76", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1080;s:6:\"height\";i:1080;s:4:\"file\";s:27:\"2024/12/MID_btz_favicon.png\";s:8:\"filesize\";i:39399;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:27:\"MID_btz_favicon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13804;}s:5:\"large\";a:5:{s:4:\"file\";s:29:\"MID_btz_favicon-1024x1024.png\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:66076;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"MID_btz_favicon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6168;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("403", "77", "_wp_attached_file", "2024/12/MID_btz_img-1.png");
INSERT INTO `wp_postmeta` VALUES("404", "77", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1989;s:6:\"height\";i:911;s:4:\"file\";s:25:\"2024/12/MID_btz_img-1.png\";s:8:\"filesize\";i:64247;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-1-300x137.png\";s:5:\"width\";i:300;s:6:\"height\";i:137;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9380;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"MID_btz_img-1-1024x469.png\";s:5:\"width\";i:1024;s:6:\"height\";i:469;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:44542;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:395;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("405", "78", "_wp_attached_file", "2024/12/MID_btz_img-2.png");
INSERT INTO `wp_postmeta` VALUES("406", "78", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1988;s:6:\"height\";i:1416;s:4:\"file\";s:25:\"2024/12/MID_btz_img-2.png\";s:8:\"filesize\";i:80759;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-2-300x214.png\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8726;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"MID_btz_img-2-1024x729.png\";s:5:\"width\";i:1024;s:6:\"height\";i:729;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:42227;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2754;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("407", "79", "_wp_attached_file", "2024/12/MID_btz_img-3.png");
INSERT INTO `wp_postmeta` VALUES("408", "79", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1988;s:6:\"height\";i:1416;s:4:\"file\";s:25:\"2024/12/MID_btz_img-3.png\";s:8:\"filesize\";i:146675;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-3-300x214.png\";s:5:\"width\";i:300;s:6:\"height\";i:214;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:17827;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"MID_btz_img-3-1024x729.png\";s:5:\"width\";i:1024;s:6:\"height\";i:729;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:84391;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-3-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8195;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("409", "80", "_wp_attached_file", "2024/12/MID_btz_img-4.png");
INSERT INTO `wp_postmeta` VALUES("410", "80", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1992;s:6:\"height\";i:867;s:4:\"file\";s:25:\"2024/12/MID_btz_img-4.png\";s:8:\"filesize\";i:40764;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-4-300x131.png\";s:5:\"width\";i:300;s:6:\"height\";i:131;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5879;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"MID_btz_img-4-1024x446.png\";s:5:\"width\";i:1024;s:6:\"height\";i:446;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:28382;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-4-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:603;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("411", "81", "_wp_attached_file", "2024/12/MID_btz_ico_-01.svg");
INSERT INTO `wp_postmeta` VALUES("412", "81", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:24135;}");
INSERT INTO `wp_postmeta` VALUES("413", "82", "_wp_attached_file", "2024/12/MID_btz_ico_-02.svg");
INSERT INTO `wp_postmeta` VALUES("414", "82", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:24135;}");
INSERT INTO `wp_postmeta` VALUES("415", "83", "_wp_attached_file", "2024/12/MID_btz_ico_-03.svg");
INSERT INTO `wp_postmeta` VALUES("416", "83", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:2739;}");
INSERT INTO `wp_postmeta` VALUES("417", "84", "_wp_attached_file", "2024/12/MID_btz_ico_-04.svg");
INSERT INTO `wp_postmeta` VALUES("418", "84", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:2739;}");
INSERT INTO `wp_postmeta` VALUES("419", "85", "_wp_attached_file", "2024/12/MID_btz_ico_-05.svg");
INSERT INTO `wp_postmeta` VALUES("420", "85", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:2739;}");
INSERT INTO `wp_postmeta` VALUES("421", "86", "_wp_attached_file", "2024/12/MID_btz_ico_-06.svg");
INSERT INTO `wp_postmeta` VALUES("422", "86", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:9835;}");
INSERT INTO `wp_postmeta` VALUES("423", "87", "_wp_attached_file", "2024/12/MID_btz_ico_-07.svg");
INSERT INTO `wp_postmeta` VALUES("424", "87", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:4930;}");
INSERT INTO `wp_postmeta` VALUES("425", "88", "_wp_attached_file", "2024/12/MID_btz_ico_-08.svg");
INSERT INTO `wp_postmeta` VALUES("426", "88", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:3098;}");
INSERT INTO `wp_postmeta` VALUES("427", "89", "_wp_attached_file", "2024/12/MID_btz_ico_-09.svg");
INSERT INTO `wp_postmeta` VALUES("428", "89", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:9835;}");
INSERT INTO `wp_postmeta` VALUES("429", "90", "_wp_attached_file", "2024/12/MID_btz_ico_-10.svg");
INSERT INTO `wp_postmeta` VALUES("430", "90", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:4774;}");
INSERT INTO `wp_postmeta` VALUES("431", "91", "_wp_attached_file", "2024/12/MID_btz_ico_-11.svg");
INSERT INTO `wp_postmeta` VALUES("432", "91", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:3098;}");
INSERT INTO `wp_postmeta` VALUES("433", "92", "_wp_attached_file", "2024/12/MID_btz_ico_-12.svg");
INSERT INTO `wp_postmeta` VALUES("434", "92", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:10608;}");
INSERT INTO `wp_postmeta` VALUES("450", "97", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("451", "97", "_edit_lock", "1733936202:1");
INSERT INTO `wp_postmeta` VALUES("452", "97", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("453", "97", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("454", "98", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("455", "99", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("456", "99", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("457", "99", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("458", "100", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("459", "99", "_edit_lock", "1733914948:1");
INSERT INTO `wp_postmeta` VALUES("460", "101", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("461", "101", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("462", "101", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("463", "102", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("464", "101", "_edit_lock", "1733936203:1");
INSERT INTO `wp_postmeta` VALUES("465", "103", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("466", "103", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("467", "103", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("468", "104", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("469", "103", "_edit_lock", "1733935914:1");
INSERT INTO `wp_postmeta` VALUES("470", "105", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("471", "105", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("472", "105", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("473", "106", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("474", "105", "_edit_lock", "1733914978:1");
INSERT INTO `wp_postmeta` VALUES("475", "107", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("476", "107", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("477", "107", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("478", "108", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("479", "107", "_edit_lock", "1733936203:1");
INSERT INTO `wp_postmeta` VALUES("480", "109", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("481", "109", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("482", "109", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("483", "110", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("484", "109", "_edit_lock", "1733932138:1");
INSERT INTO `wp_postmeta` VALUES("485", "111", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("486", "111", "_edit_lock", "1733936091:1");
INSERT INTO `wp_postmeta` VALUES("488", "111", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("489", "112", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("490", "113", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("491", "113", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("492", "113", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("493", "114", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("494", "113", "_edit_lock", "1733915070:1");
INSERT INTO `wp_postmeta` VALUES("495", "115", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("496", "115", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("497", "115", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("498", "116", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("499", "115", "_edit_lock", "1733915078:1");
INSERT INTO `wp_postmeta` VALUES("500", "117", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("501", "117", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("502", "117", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("503", "118", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("504", "117", "_edit_lock", "1733915088:1");
INSERT INTO `wp_postmeta` VALUES("505", "119", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("506", "119", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("507", "119", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("508", "120", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("509", "119", "_edit_lock", "1734371594:1");
INSERT INTO `wp_postmeta` VALUES("510", "121", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("511", "121", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("512", "121", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("513", "122", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("514", "121", "_edit_lock", "1733915125:1");
INSERT INTO `wp_postmeta` VALUES("515", "123", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("516", "123", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("517", "123", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("518", "124", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("519", "123", "_edit_lock", "1733915133:1");
INSERT INTO `wp_postmeta` VALUES("520", "125", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("521", "125", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("522", "125", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("523", "126", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("524", "125", "_edit_lock", "1733915140:1");
INSERT INTO `wp_postmeta` VALUES("525", "127", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("526", "127", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("527", "127", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("528", "128", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("529", "127", "_edit_lock", "1733915156:1");
INSERT INTO `wp_postmeta` VALUES("548", "131", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("549", "131", "_menu_item_menu_item_parent", "149");
INSERT INTO `wp_postmeta` VALUES("550", "131", "_menu_item_object_id", "105");
INSERT INTO `wp_postmeta` VALUES("551", "131", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("552", "131", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("553", "131", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("554", "131", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("555", "131", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("557", "132", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("558", "132", "_menu_item_menu_item_parent", "149");
INSERT INTO `wp_postmeta` VALUES("559", "132", "_menu_item_object_id", "97");
INSERT INTO `wp_postmeta` VALUES("560", "132", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("561", "132", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("562", "132", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("563", "132", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("564", "132", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("566", "133", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("567", "133", "_menu_item_menu_item_parent", "162");
INSERT INTO `wp_postmeta` VALUES("568", "133", "_menu_item_object_id", "117");
INSERT INTO `wp_postmeta` VALUES("569", "133", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("570", "133", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("571", "133", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("572", "133", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("573", "133", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("575", "134", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("576", "134", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("577", "134", "_menu_item_object_id", "107");
INSERT INTO `wp_postmeta` VALUES("578", "134", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("579", "134", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("580", "134", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("581", "134", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("582", "134", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("593", "136", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("594", "136", "_menu_item_menu_item_parent", "162");
INSERT INTO `wp_postmeta` VALUES("595", "136", "_menu_item_object_id", "125");
INSERT INTO `wp_postmeta` VALUES("596", "136", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("597", "136", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("598", "136", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("599", "136", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("600", "136", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("611", "138", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("612", "138", "_menu_item_menu_item_parent", "162");
INSERT INTO `wp_postmeta` VALUES("613", "138", "_menu_item_object_id", "121");
INSERT INTO `wp_postmeta` VALUES("614", "138", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("615", "138", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("616", "138", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("617", "138", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("618", "138", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("620", "139", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("621", "139", "_menu_item_menu_item_parent", "162");
INSERT INTO `wp_postmeta` VALUES("622", "139", "_menu_item_object_id", "119");
INSERT INTO `wp_postmeta` VALUES("623", "139", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("624", "139", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("625", "139", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("626", "139", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("627", "139", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("629", "140", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("630", "140", "_menu_item_menu_item_parent", "162");
INSERT INTO `wp_postmeta` VALUES("631", "140", "_menu_item_object_id", "127");
INSERT INTO `wp_postmeta` VALUES("632", "140", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("633", "140", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("634", "140", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("635", "140", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("636", "140", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("638", "141", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("639", "141", "_menu_item_menu_item_parent", "149");
INSERT INTO `wp_postmeta` VALUES("640", "141", "_menu_item_object_id", "103");
INSERT INTO `wp_postmeta` VALUES("641", "141", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("642", "141", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("643", "141", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("644", "141", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("645", "141", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("656", "143", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("657", "143", "_menu_item_menu_item_parent", "162");
INSERT INTO `wp_postmeta` VALUES("658", "143", "_menu_item_object_id", "115");
INSERT INTO `wp_postmeta` VALUES("659", "143", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("660", "143", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("661", "143", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("662", "143", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("663", "143", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("665", "144", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("666", "144", "_menu_item_menu_item_parent", "149");
INSERT INTO `wp_postmeta` VALUES("667", "144", "_menu_item_object_id", "101");
INSERT INTO `wp_postmeta` VALUES("668", "144", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("669", "144", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("670", "144", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("671", "144", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("672", "144", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("674", "145", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("675", "145", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("676", "145", "_menu_item_object_id", "109");
INSERT INTO `wp_postmeta` VALUES("677", "145", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("678", "145", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("679", "145", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("680", "145", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("681", "145", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("692", "147", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("693", "147", "_menu_item_menu_item_parent", "162");
INSERT INTO `wp_postmeta` VALUES("694", "147", "_menu_item_object_id", "113");
INSERT INTO `wp_postmeta` VALUES("695", "147", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("696", "147", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("697", "147", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("698", "147", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("699", "147", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("701", "148", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("702", "148", "_menu_item_menu_item_parent", "149");
INSERT INTO `wp_postmeta` VALUES("703", "148", "_menu_item_object_id", "99");
INSERT INTO `wp_postmeta` VALUES("704", "148", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("705", "148", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("706", "148", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("707", "148", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("708", "148", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("710", "149", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("711", "149", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("712", "149", "_menu_item_object_id", "149");
INSERT INTO `wp_postmeta` VALUES("713", "149", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("714", "149", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("715", "149", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("716", "149", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("717", "149", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("734", "151", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("735", "151", "_edit_lock", "1733916246:1");
INSERT INTO `wp_postmeta` VALUES("736", "152", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("737", "152", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("738", "152", "_menu_item_object_id", "152");
INSERT INTO `wp_postmeta` VALUES("739", "152", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("740", "152", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("741", "152", "_menu_item_classes", "a:1:{i:0;s:11:\"footertitle\";}");
INSERT INTO `wp_postmeta` VALUES("742", "152", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("743", "152", "_menu_item_url", "#");
INSERT INTO `wp_postmeta` VALUES("745", "153", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("746", "153", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("747", "153", "_menu_item_object_id", "105");
INSERT INTO `wp_postmeta` VALUES("748", "153", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("749", "153", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("750", "153", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("751", "153", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("752", "153", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("754", "154", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("755", "154", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("756", "154", "_menu_item_object_id", "97");
INSERT INTO `wp_postmeta` VALUES("757", "154", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("758", "154", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("759", "154", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("760", "154", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("761", "154", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("763", "155", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("764", "155", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("765", "155", "_menu_item_object_id", "103");
INSERT INTO `wp_postmeta` VALUES("766", "155", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("767", "155", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("768", "155", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("769", "155", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("770", "155", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("772", "156", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("773", "156", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("774", "156", "_menu_item_object_id", "101");
INSERT INTO `wp_postmeta` VALUES("775", "156", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("776", "156", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("777", "156", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("778", "156", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("779", "156", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("781", "157", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("782", "157", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("783", "157", "_menu_item_object_id", "99");
INSERT INTO `wp_postmeta` VALUES("784", "157", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("785", "157", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("786", "157", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("787", "157", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("788", "157", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("790", "158", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("791", "158", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("792", "158", "_menu_item_object_id", "32");
INSERT INTO `wp_postmeta` VALUES("793", "158", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("794", "158", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("795", "158", "_menu_item_classes", "a:2:{i:0;s:11:\"footertitle\";i:1;s:14:\"footertitlesep\";}");
INSERT INTO `wp_postmeta` VALUES("796", "158", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("797", "158", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("799", "159", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("800", "159", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("801", "159", "_menu_item_object_id", "109");
INSERT INTO `wp_postmeta` VALUES("802", "159", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("803", "159", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("804", "159", "_menu_item_classes", "a:1:{i:0;s:11:\"footertitle\";}");
INSERT INTO `wp_postmeta` VALUES("805", "159", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("806", "159", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("808", "160", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("809", "160", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("810", "160", "_menu_item_object_id", "107");
INSERT INTO `wp_postmeta` VALUES("811", "160", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("812", "160", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("813", "160", "_menu_item_classes", "a:1:{i:0;s:11:\"footertitle\";}");
INSERT INTO `wp_postmeta` VALUES("814", "160", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("815", "160", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("817", "111", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("818", "161", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("819", "161", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("820", "161", "_menu_item_object_id", "111");
INSERT INTO `wp_postmeta` VALUES("821", "161", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("822", "161", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("823", "161", "_menu_item_classes", "a:1:{i:0;s:11:\"footertitle\";}");
INSERT INTO `wp_postmeta` VALUES("824", "161", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("825", "161", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("827", "162", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("828", "162", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("829", "162", "_menu_item_object_id", "111");
INSERT INTO `wp_postmeta` VALUES("830", "162", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("831", "162", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("832", "162", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("833", "162", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("834", "162", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("836", "163", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("837", "163", "_edit_lock", "1733916285:1");
INSERT INTO `wp_postmeta` VALUES("841", "164", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("842", "164", "_edit_lock", "1733916417:1");
INSERT INTO `wp_postmeta` VALUES("864", "165", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("865", "165", "_edit_lock", "1733932135:1");
INSERT INTO `wp_postmeta` VALUES("866", "167", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("867", "167", "_edit_lock", "1734372521:1");
INSERT INTO `wp_postmeta` VALUES("868", "167", "_thumbnail_id", "75");
INSERT INTO `wp_postmeta` VALUES("869", "167", "link_parceiro", "https://www.apcl.pt/pt");
INSERT INTO `wp_postmeta` VALUES("870", "167", "_link_parceiro", "field_675977a23d303");
INSERT INTO `wp_postmeta` VALUES("871", "168", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("872", "39", "_us_jsoncss_data", "a:2:{i:0;s:198:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%223.8rem%22%2C%22line-height%22%3A%223.9rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\";i:1;s:130:\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22padding-left%22%3A%2210%25%22%2C%22padding-right%22%3A%2210%25%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("873", "36", "_us_in_content_ids", "9,180,181,53");
INSERT INTO `wp_postmeta` VALUES("874", "171", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("875", "172", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("876", "173", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("877", "174", "_wp_attached_file", "2024/12/MID_btz_img-1b.png");
INSERT INTO `wp_postmeta` VALUES("878", "174", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2383;s:6:\"height\";i:671;s:4:\"file\";s:26:\"2024/12/MID_btz_img-1b.png\";s:8:\"filesize\";i:79047;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-1b-300x84.png\";s:5:\"width\";i:300;s:6:\"height\";i:84;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9396;}s:5:\"large\";a:5:{s:4:\"file\";s:27:\"MID_btz_img-1b-1024x288.png\";s:5:\"width\";i:1024;s:6:\"height\";i:288;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:42232;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"MID_btz_img-1b-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:461;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("879", "175", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("880", "176", "_wp_attached_file", "2024/12/MID_btz_img-1c.png");
INSERT INTO `wp_postmeta` VALUES("881", "176", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2383;s:6:\"height\";i:671;s:4:\"file\";s:26:\"2024/12/MID_btz_img-1c.png\";s:8:\"filesize\";i:79411;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-1c-300x84.png\";s:5:\"width\";i:300;s:6:\"height\";i:84;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9435;}s:5:\"large\";a:5:{s:4:\"file\";s:27:\"MID_btz_img-1c-1024x288.png\";s:5:\"width\";i:1024;s:6:\"height\";i:288;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:42230;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"MID_btz_img-1c-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:376;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("882", "177", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("883", "178", "_wp_attached_file", "2024/12/sombra_2_39.png");
INSERT INTO `wp_postmeta` VALUES("884", "178", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1330;s:6:\"height\";i:53;s:4:\"file\";s:23:\"2024/12/sombra_2_39.png\";s:8:\"filesize\";i:2363;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:22:\"sombra_2_39-300x12.png\";s:5:\"width\";i:300;s:6:\"height\";i:12;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:251;}s:5:\"large\";a:5:{s:4:\"file\";s:23:\"sombra_2_39-1024x41.png\";s:5:\"width\";i:1024;s:6:\"height\";i:41;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:851;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"sombra_2_39-150x53.png\";s:5:\"width\";i:150;s:6:\"height\";i:53;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:227;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("885", "179", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("886", "180", "_edit_lock", "1733930213:1");
INSERT INTO `wp_postmeta` VALUES("887", "181", "_edit_lock", "1733930240:1");
INSERT INTO `wp_postmeta` VALUES("888", "182", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("889", "182", "_edit_lock", "1733925331:1");
INSERT INTO `wp_postmeta` VALUES("890", "183", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("891", "183", "_edit_lock", "1733927672:1");
INSERT INTO `wp_postmeta` VALUES("893", "182", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("894", "182", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("895", "185", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("896", "187", "_wp_attached_file", "2024/12/MID_btz_not-1.jpg");
INSERT INTO `wp_postmeta` VALUES("897", "187", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1100;s:6:\"height\";i:825;s:4:\"file\";s:25:\"2024/12/MID_btz_not-1.jpg\";s:8:\"filesize\";i:63489;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"MID_btz_not-1-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8019;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"MID_btz_not-1-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:41678;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"MID_btz_not-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4432;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("898", "182", "_thumbnail_id", "187");
INSERT INTO `wp_postmeta` VALUES("900", "182", "detalhe_evento", "Lisboa, 10, 11 e 12 de Maio de 2024");
INSERT INTO `wp_postmeta` VALUES("901", "182", "_detalhe_evento", "field_67599869e4bbe");
INSERT INTO `wp_postmeta` VALUES("902", "188", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("903", "188", "detalhe_evento", "Lisboa, 10, 11 e 12 de Maio de 2024");
INSERT INTO `wp_postmeta` VALUES("904", "188", "_detalhe_evento", "field_67599869e4bbe");
INSERT INTO `wp_postmeta` VALUES("905", "189", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("906", "189", "_edit_lock", "1734371145:1");
INSERT INTO `wp_postmeta` VALUES("907", "190", "_wp_attached_file", "2024/12/MID_btz_not-2.jpg");
INSERT INTO `wp_postmeta` VALUES("908", "190", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1100;s:6:\"height\";i:825;s:4:\"file\";s:25:\"2024/12/MID_btz_not-2.jpg\";s:8:\"filesize\";i:220586;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"MID_btz_not-2-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:19290;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"MID_btz_not-2-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:122368;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"MID_btz_not-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8422;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("909", "189", "_oembed_873e288f35674fc7afa5dd823ef70c39", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("910", "189", "_oembed_3613755d0867969f4a7f63ad1319fb9e", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("911", "191", "_wp_attached_file", "2024/12/Terapias-celulares-29-maio-695x1024-1.jpg");
INSERT INTO `wp_postmeta` VALUES("912", "191", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:695;s:6:\"height\";i:1024;s:4:\"file\";s:49:\"2024/12/Terapias-celulares-29-maio-695x1024-1.jpg\";s:8:\"filesize\";i:187214;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:49:\"Terapias-celulares-29-maio-695x1024-1-204x300.jpg\";s:5:\"width\";i:204;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16819;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:49:\"Terapias-celulares-29-maio-695x1024-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6904;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("913", "189", "_thumbnail_id", "190");
INSERT INTO `wp_postmeta` VALUES("915", "189", "detalhe_evento", "Porto, 29 de Maio de 2024");
INSERT INTO `wp_postmeta` VALUES("916", "189", "_detalhe_evento", "field_67599869e4bbe");
INSERT INTO `wp_postmeta` VALUES("917", "189", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("918", "189", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("919", "189", "us_og_image", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/Terapias-celulares-29-maio-695x1024-1.jpg");
INSERT INTO `wp_postmeta` VALUES("920", "192", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("921", "192", "detalhe_evento", "Porto, 29 de Maio de 2024");
INSERT INTO `wp_postmeta` VALUES("922", "192", "_detalhe_evento", "field_67599869e4bbe");
INSERT INTO `wp_postmeta` VALUES("923", "193", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("924", "193", "_edit_lock", "1733927634:1");
INSERT INTO `wp_postmeta` VALUES("925", "194", "_wp_attached_file", "2024/12/MID_btz_not-3.jpg");
INSERT INTO `wp_postmeta` VALUES("926", "194", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1100;s:6:\"height\";i:825;s:4:\"file\";s:25:\"2024/12/MID_btz_not-3.jpg\";s:8:\"filesize\";i:199191;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"MID_btz_not-3-300x225.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:225;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18513;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"MID_btz_not-3-1024x768.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:768;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:112439;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"MID_btz_not-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8461;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("927", "193", "_thumbnail_id", "194");
INSERT INTO `wp_postmeta` VALUES("929", "193", "detalhe_evento", "Lisboa, 23 de Março de 2024 ");
INSERT INTO `wp_postmeta` VALUES("930", "193", "_detalhe_evento", "field_67599869e4bbe");
INSERT INTO `wp_postmeta` VALUES("931", "193", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("932", "193", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("933", "195", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("934", "195", "detalhe_evento", "Lisboa, 23 de Março de 2024 ");
INSERT INTO `wp_postmeta` VALUES("935", "195", "_detalhe_evento", "field_67599869e4bbe");
INSERT INTO `wp_postmeta` VALUES("936", "193", "_oembed_58e6e7919f36ad38983416c8e661f9b6", "<iframe title=\"A brief interview with Alvaro Urbano-Ispizua, MD, PhD\" width=\"640\" height=\"360\" src=\"https://www.youtube.com/embed/P1fF7rRvnkk?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("937", "193", "_oembed_time_58e6e7919f36ad38983416c8e661f9b6", "1733926485");
INSERT INTO `wp_postmeta` VALUES("939", "196", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("940", "196", "detalhe_evento", "Lisboa, 23 de Março de 2024 ");
INSERT INTO `wp_postmeta` VALUES("941", "196", "_detalhe_evento", "field_67599869e4bbe");
INSERT INTO `wp_postmeta` VALUES("942", "193", "_oembed_1acad140b7e53222017106724b5faed3", "<iframe title=\"A brief interview with Didier Blaise, MD PhD\" width=\"640\" height=\"360\" src=\"https://www.youtube.com/embed/iXwUCyuBifg?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("943", "193", "_oembed_time_1acad140b7e53222017106724b5faed3", "1733926561");
INSERT INTO `wp_postmeta` VALUES("944", "193", "_oembed_5ad082aaff57a1850e17ba8ec5a620d2", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("945", "193", "_oembed_b2afce0330e3330dfe4e13f54d75fd37", "{{unknown}}");
INSERT INTO `wp_postmeta` VALUES("947", "198", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("948", "198", "detalhe_evento", "Lisboa, 23 de Março de 2024 ");
INSERT INTO `wp_postmeta` VALUES("949", "198", "_detalhe_evento", "field_67599869e4bbe");
INSERT INTO `wp_postmeta` VALUES("950", "193", "_oembed_bc6a001bc6dd349e9d9c4786883dff3d", "<iframe title=\"A brief interview with Arnon Nagler, MD, MSc\" width=\"640\" height=\"360\" src=\"https://www.youtube.com/embed/p3uHKDXrNpA?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("951", "193", "_oembed_time_bc6a001bc6dd349e9d9c4786883dff3d", "1733926623");
INSERT INTO `wp_postmeta` VALUES("952", "193", "_oembed_0c614db299fd14607465f608d78e8b22", "<iframe title=\"A brief interview with Lung-Ji Chang, PhD\" width=\"640\" height=\"360\" src=\"https://www.youtube.com/embed/k6iv4oOLbMU?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("953", "193", "_oembed_time_0c614db299fd14607465f608d78e8b22", "1733926645");
INSERT INTO `wp_postmeta` VALUES("954", "193", "_oembed_cf4a1a4ad0081092eff9b3a30fac1fa2", "<iframe title=\"Conferência &quot;Looking today at tomorrow’s immunotherapy&quot; / &quot;making of&quot; legendado em português\" width=\"640\" height=\"360\" src=\"https://www.youtube.com/embed/q2Ius89A0lI?feature=oembed\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen></iframe>");
INSERT INTO `wp_postmeta` VALUES("955", "193", "_oembed_time_cf4a1a4ad0081092eff9b3a30fac1fa2", "1733926677");
INSERT INTO `wp_postmeta` VALUES("957", "199", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("958", "199", "detalhe_evento", "Lisboa, 23 de Março de 2024 ");
INSERT INTO `wp_postmeta` VALUES("959", "199", "_detalhe_evento", "field_67599869e4bbe");
INSERT INTO `wp_postmeta` VALUES("961", "201", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("962", "202", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("963", "203", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("964", "204", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("965", "205", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("966", "206", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("967", "207", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("968", "208", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("969", "209", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("970", "210", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("971", "211", "_wp_attached_file", "2023/02/MID_btz_img-5.png");
INSERT INTO `wp_postmeta` VALUES("972", "211", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:502;s:6:\"height\";i:540;s:4:\"file\";s:25:\"2023/02/MID_btz_img-5.png\";s:8:\"filesize\";i:18920;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-5-279x300.png\";s:5:\"width\";i:279;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:16369;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-5-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7148;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("973", "212", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("974", "213", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("975", "214", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("976", "215", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("977", "216", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("978", "217", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("979", "218", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("980", "10", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("981", "219", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("982", "220", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("983", "221", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("984", "222", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("985", "109", "_us_in_content_ids", "13");
INSERT INTO `wp_postmeta` VALUES("987", "109", "_us_jsoncss_data", "a:2:{i:0;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%224rem%22%7D%7D\";i:1;s:58:\"%7B%22default%22%3A%7B%22font-size%22%3A%220.8rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("988", "224", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("989", "225", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("990", "226", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("991", "227", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("992", "228", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("993", "229", "_edit_lock", "1733928889:1");
INSERT INTO `wp_postmeta` VALUES("994", "229", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("995", "229", "_us_jsoncss_data", "a:1:{i:0;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%224rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("996", "229", "_us_in_content_ids", "13");
INSERT INTO `wp_postmeta` VALUES("997", "229", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("998", "229", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("999", "231", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1000", "232", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1001", "233", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1002", "234", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1003", "235", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1004", "236", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1005", "237", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1006", "238", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1007", "239", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1008", "240", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1010", "241", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1011", "242", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1012", "243", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1014", "244", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1015", "245", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1016", "36", "us_og_image", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_ico_-06.svg");
INSERT INTO `wp_postmeta` VALUES("1017", "246", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1018", "247", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1019", "248", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1020", "249", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1021", "250", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1022", "251", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1023", "252", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1024", "253", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1025", "254", "_wp_attached_file", "2024/12/MID_btz_img-6.png");
INSERT INTO `wp_postmeta` VALUES("1026", "254", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:2383;s:6:\"height\";i:671;s:4:\"file\";s:25:\"2024/12/MID_btz_img-6.png\";s:8:\"filesize\";i:65707;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:24:\"MID_btz_img-6-300x84.png\";s:5:\"width\";i:300;s:6:\"height\";i:84;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7876;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"MID_btz_img-6-1024x288.png\";s:5:\"width\";i:1024;s:6:\"height\";i:288;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:36138;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-6-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:714;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1027", "255", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1028", "256", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1029", "257", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1030", "258", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1031", "259", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1032", "260", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1033", "261", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1034", "262", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1035", "262", "_edit_lock", "1733932057:1");
INSERT INTO `wp_postmeta` VALUES("1036", "262", "_thumbnail_id", "74");
INSERT INTO `wp_postmeta` VALUES("1037", "262", "link_parceiro", "#");
INSERT INTO `wp_postmeta` VALUES("1038", "262", "_link_parceiro", "field_675977a23d303");
INSERT INTO `wp_postmeta` VALUES("1039", "263", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1040", "263", "_edit_lock", "1733932073:1");
INSERT INTO `wp_postmeta` VALUES("1041", "263", "_thumbnail_id", "74");
INSERT INTO `wp_postmeta` VALUES("1042", "263", "link_parceiro", "");
INSERT INTO `wp_postmeta` VALUES("1043", "263", "_link_parceiro", "field_675977a23d303");
INSERT INTO `wp_postmeta` VALUES("1044", "264", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1045", "264", "_edit_lock", "1733932082:1");
INSERT INTO `wp_postmeta` VALUES("1046", "264", "_thumbnail_id", "74");
INSERT INTO `wp_postmeta` VALUES("1047", "264", "link_parceiro", "");
INSERT INTO `wp_postmeta` VALUES("1048", "264", "_link_parceiro", "field_675977a23d303");
INSERT INTO `wp_postmeta` VALUES("1049", "265", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1050", "265", "_edit_lock", "1733932094:1");
INSERT INTO `wp_postmeta` VALUES("1051", "265", "_thumbnail_id", "74");
INSERT INTO `wp_postmeta` VALUES("1052", "265", "link_parceiro", "");
INSERT INTO `wp_postmeta` VALUES("1053", "265", "_link_parceiro", "field_675977a23d303");
INSERT INTO `wp_postmeta` VALUES("1054", "266", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1055", "266", "_edit_lock", "1733932104:1");
INSERT INTO `wp_postmeta` VALUES("1056", "266", "_thumbnail_id", "74");
INSERT INTO `wp_postmeta` VALUES("1057", "266", "link_parceiro", "");
INSERT INTO `wp_postmeta` VALUES("1058", "266", "_link_parceiro", "field_675977a23d303");
INSERT INTO `wp_postmeta` VALUES("1059", "267", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1060", "267", "_edit_lock", "1733932141:1");
INSERT INTO `wp_postmeta` VALUES("1061", "267", "_thumbnail_id", "74");
INSERT INTO `wp_postmeta` VALUES("1062", "267", "link_parceiro", "");
INSERT INTO `wp_postmeta` VALUES("1063", "267", "_link_parceiro", "field_675977a23d303");
INSERT INTO `wp_postmeta` VALUES("1064", "268", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1065", "269", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1066", "270", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1067", "271", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1068", "272", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1069", "273", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1070", "274", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1071", "275", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1072", "276", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1073", "277", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1074", "278", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1075", "279", "_wp_attached_file", "2023/02/MID_btz_img-7.png");
INSERT INTO `wp_postmeta` VALUES("1076", "279", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:622;s:6:\"height\";i:273;s:4:\"file\";s:25:\"2023/02/MID_btz_img-7.png\";s:8:\"filesize\";i:20222;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-7-300x132.png\";s:5:\"width\";i:300;s:6:\"height\";i:132;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15606;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-7-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:9562;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1077", "280", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1078", "281", "_wp_attached_file", "2023/02/MID_btz_img-8.png");
INSERT INTO `wp_postmeta` VALUES("1079", "281", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:701;s:6:\"height\";i:343;s:4:\"file\";s:25:\"2023/02/MID_btz_img-8.png\";s:8:\"filesize\";i:21728;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-8-300x147.png\";s:5:\"width\";i:300;s:6:\"height\";i:147;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14097;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-8-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7898;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1080", "282", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1081", "283", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1082", "111", "_us_jsoncss_data", "a:10:{i:0;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\";i:1;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:2;s:132:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\";i:3;s:132:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\";i:4;s:132:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\";i:5;s:132:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\";i:6;s:132:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\";i:7;s:132:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\";i:8;s:132:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\";i:9;s:132:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("1083", "285", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1084", "286", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1085", "287", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1086", "288", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1087", "289", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1088", "290", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1089", "291", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1090", "292", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1091", "293", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1092", "97", "_us_jsoncss_data", "a:2:{i:0;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\";i:1;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22margin-top%22%3A%222rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("1093", "97", "us_og_image", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/1024.jpg");
INSERT INTO `wp_postmeta` VALUES("1094", "295", "_wp_attached_file", "2024/12/1024.jpg");
INSERT INTO `wp_postmeta` VALUES("1095", "295", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1024;s:6:\"height\";i:676;s:4:\"file\";s:16:\"2024/12/1024.jpg\";s:8:\"filesize\";i:57611;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:16:\"1024-300x198.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:198;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13073;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:16:\"1024-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5984;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1096", "296", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1097", "297", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1098", "298", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1099", "300", "_wp_attached_file", "2024/12/representation-microorganisms-concept-copy_2.jpg");
INSERT INTO `wp_postmeta` VALUES("1100", "300", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:56:\"2024/12/representation-microorganisms-concept-copy_2.jpg\";s:8:\"filesize\";i:238833;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:56:\"representation-microorganisms-concept-copy_2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:20828;}s:5:\"large\";a:5:{s:4:\"file\";s:57:\"representation-microorganisms-concept-copy_2-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:123700;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:56:\"representation-microorganisms-concept-copy_2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9470;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1101", "103", "_us_jsoncss_data", "a:3:{i:0;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\";i:1;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22margin-top%22%3A%222rem%22%7D%7D\";i:2;s:56:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("1102", "103", "us_og_image", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/representation-microorganisms-concept-copy_2-1024x683.jpg");
INSERT INTO `wp_postmeta` VALUES("1103", "301", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1104", "302", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1105", "303", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1106", "304", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1107", "101", "_us_jsoncss_data", "a:3:{i:0;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\";i:1;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22margin-top%22%3A%222rem%22%7D%7D\";i:2;s:56:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("1108", "101", "us_og_image", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_img-9-1024x775.jpg");
INSERT INTO `wp_postmeta` VALUES("1109", "306", "_wp_attached_file", "2024/12/MID_btz_img-9.jpg");
INSERT INTO `wp_postmeta` VALUES("1110", "306", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1100;s:6:\"height\";i:833;s:4:\"file\";s:25:\"2024/12/MID_btz_img-9.jpg\";s:8:\"filesize\";i:97675;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-9-300x227.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:227;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8830;}s:5:\"large\";a:5:{s:4:\"file\";s:26:\"MID_btz_img-9-1024x775.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:775;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54527;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:25:\"MID_btz_img-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4414;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1111", "307", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1112", "308", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1113", "309", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1114", "310", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1115", "311", "_wp_attached_file", "2024/12/MID_btz_img-9-1.jpg");
INSERT INTO `wp_postmeta` VALUES("1116", "311", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1100;s:6:\"height\";i:833;s:4:\"file\";s:27:\"2024/12/MID_btz_img-9-1.jpg\";s:8:\"filesize\";i:97675;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:27:\"MID_btz_img-9-1-300x227.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:227;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8830;}s:5:\"large\";a:5:{s:4:\"file\";s:28:\"MID_btz_img-9-1-1024x775.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:775;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:54527;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:27:\"MID_btz_img-9-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4414;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1117", "107", "_us_jsoncss_data", "a:1:{i:0;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("1118", "107", "us_og_image", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/close-up-cell-with-red-cells-it-generative-ai_2-1024x683.jpg");
INSERT INTO `wp_postmeta` VALUES("1119", "313", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1120", "314", "_wp_attached_file", "2024/12/close-up-cell-with-red-cells-it-generative-ai_2.jpg");
INSERT INTO `wp_postmeta` VALUES("1121", "314", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:800;s:4:\"file\";s:59:\"2024/12/close-up-cell-with-red-cells-it-generative-ai_2.jpg\";s:8:\"filesize\";i:141730;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:59:\"close-up-cell-with-red-cells-it-generative-ai_2-300x200.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:200;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12588;}s:5:\"large\";a:5:{s:4:\"file\";s:60:\"close-up-cell-with-red-cells-it-generative-ai_2-1024x683.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:683;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:73764;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:59:\"close-up-cell-with-red-cells-it-generative-ai_2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6638;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1122", "315", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1123", "316", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1128", "320", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1129", "320", "_edit_lock", "1733936522:1");
INSERT INTO `wp_postmeta` VALUES("1130", "321", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1131", "321", "_edit_lock", "1733937560:1");
INSERT INTO `wp_postmeta` VALUES("1133", "323", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1134", "324", "_edit_lock", "1733937722:1");
INSERT INTO `wp_postmeta` VALUES("1136", "325", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1137", "326", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1138", "327", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1139", "119", "_us_jsoncss_data", "a:1:{i:0;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("1140", "328", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1147", "149", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1148", "132", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1149", "148", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1150", "144", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1151", "141", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1152", "131", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1153", "134", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1154", "145", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1155", "162", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1156", "147", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1157", "143", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1158", "133", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1159", "139", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1160", "138", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1161", "136", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1162", "140", "_wp_old_date", "2024-12-11");
INSERT INTO `wp_postmeta` VALUES("1163", "329", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1164", "329", "_menu_item_menu_item_parent", "162");
INSERT INTO `wp_postmeta` VALUES("1165", "329", "_menu_item_object_id", "123");
INSERT INTO `wp_postmeta` VALUES("1166", "329", "_menu_item_object", "page");
INSERT INTO `wp_postmeta` VALUES("1167", "329", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1168", "329", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1169", "329", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1170", "329", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1172", "330", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1173", "331", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1174", "331", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("1175", "331", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1176", "332", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1177", "331", "_edit_lock", "1734372106:1");
INSERT INTO `wp_postmeta` VALUES("1178", "333", "_wpb_post_custom_layout", "default");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("2", "1", "2023-02-13 23:22:36", "2023-02-13 23:22:36", "<p>[vc_row][vc_column width=\"1/1\"][us_grid items_layout=\"13\" columns=\"3\"][/vc_column][/vc_row]</p>\r\n", "Exemplo de página", "", "draft", "closed", "open", "", "pagina-exemplo", "", "", "2023-02-14 10:41:42", "2023-02-14 10:41:42", "", "0", "https://midtemplate.makeitdigital2.tk/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("3", "1", "2023-02-13 23:22:36", "2023-02-13 23:22:36", "<p>Este Site recolhe alguns Dados Pessoais dos Utilizadores.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Propriet</strong><strong>ário e Controlador de Dados</strong><br />Nome da empresa legal</p>\r\n<p>Morada da empresa</p>\r\n<p>&nbsp;</p>\r\n<p><strong>E-mail de contato do Proprietá</strong><strong>rio:</strong> email de contacto da pessoas de contacto</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Tipos de Dados recolhidos</strong><br />Entre os tipos de Dados Pessoais que este Site recolhe, por si mesmo ou através de terceiros, existem: Nome; Apelido; Número de telefone; Nome da empresa; E-mail; Cookies.</p>\r\n<p>Os detalhes completos dos Dados Pessoais recolhidos são fornecidos nas seções dedicadas desta política de privacidade ou por textos explicativos específicos exibidos antes da recolha dos mesmos.<br />Os Dados Pessoais poderão ser fornecidos voluntariamente pelo Utilizador, ou, no caso dos Dados de Utilização, recolhidos automaticamente ao se utilizar este Site.</p>\r\n<p>A menos que seja especificado que todos os Dados solicitados por este Site são obrigatórios e a falta de fornecimento destes Dados poderá impossibilitar este Site de fornecer os seus Serviços. Nos casos em que este Site afirma especificamente que alguns Dados não são obrigatórios, os Utilizadores não terão de preencher esses Dados e não existirão consequências para a disponibilidade ou o funcionamento do Serviço.</p>\r\n<p>Os Utilizadores que tiverem dúvidas a respeito de quais os Dados Pessoais que são obrigatórios estão convidados a entrar em contato com o Proprietário.<br />Quaisquer usos de cookies – ou de outras ferramentas de rastreamento – por este Site ou pelos proprietários de serviços terceiros utilizados por este Site serão para a finalidade de fornecer os Serviços solicitados pelo Utilizador, além das demais finalidades descritas no presente documento e na Política de Cookies, se estiver disponível.</p>\r\n<p>Os Utilizadores ficam responsáveis por quaisquer Dados Pessoais de terceiros que forem obtidos, publicados ou compartilhados através deste Serviço (este Site) e confirmam que possuem a autorização dos terceiros para fornecerem os Dados para o Proprietário.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Modo e local de processamento dos Dados</strong></p>\r\n<p><br /><strong>M</strong><strong>é</strong><strong>todo de processamento</strong></p>\r\n<p>O Proprietário tomará as medidas de segurança adequadas para impedir o acesso não autorizado, divulgação, alteração ou destruição não autorizada dos Dados.<br />O processamento dos Dados é realizado através de computadores e /ou ferramentas de TI habilitadas, seguindo procedimentos organizacionais e meios estritamente relacionados com os fins indicados. Além do Proprietário, em alguns casos, os Dados podem ser acessados por certos tipos de pessoas encarregadas, envolvidas com a operação deste Serviço (este Site) (administração, vendas, marketing, administração legal do sistema) ou pessoas externas (como fornecedores terceirizados de serviços técnicos, correio, etc) nomeadas, quando necessário, como Processadores de Dados por parte do Proprietário. A lista atualizada destas partes pode ser solicitada ao Proprietário a qualquer momento.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Base jurídica para o processamento</strong><br />O Proprietário poderá processar os Dados Pessoais relacionados ao Utilizador se uma das hipóteses a seguir se aplicar:</p>\r\n<p>Utilizadores que tenham dado a sua aprovação para uma ou mais finalidades específicas; Observação: De acordo com algumas legislações o Proprietário poderá ter a permissão para processar os Dados Pessoais ATÉ QUE O Utilizador faça objeção a isto (“opt-out”), sem ter que se basear em permissão ou em quaisquer outras bases jurídicas a seguir. Isto, contudo, não se aplica sempre que o processamento de Dados Pessoais estiver sujeito à legislação europeia de proteção de dados;<br />– o fornecimento dos Dados for necessário para o cumprimento de um contrato com o Utilizador e/ou quaisquer obrigações pré-contratuais do mesmo;<br />– o processamento for necessário para o cumprimento de uma obrigação jurídica à qual o Proprietário estiver sujeito;<br />– o processamento estiver relacionado a uma tarefa que for executada no interesse público ou no exercício de uma autorização oficial na qual o Proprietário estiver investido;<br />– o processamento for necessário para a finalidade de interesses legítimos perseguidos pelo Proprietário ou por um terceiro;</p>\r\n<p>Em qualquer caso, o Proprietário colaborará de bom grado para esclarecer qual a base jurídica que se aplica ao processamento, e em especial se o fornecimento de Dados for um requisito obrigatório por força de lei ou contratual, ou uma exigência necessária para celebrar um contrato.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Per</strong><strong>íodo de Conservação</strong><br />Os Dados Pessoais serão processados e armazenados por 365 dias.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>As Finalidades do Processamento</strong><br />Os Dados relativos ao Utilizador são recolhidos para permitir que o Proprietário forneça os seus Serviços, bem como para os seguintes propósitos: Contatar o Utilizador; Proteção anti-spam; Acesso a contas de serviços de terceiros; Estatísticas; Salvar e gerir o backup; Comentário de conteúdo; Visualizar conteúdo de plataformas externas; Processamento de pagamentos; Interação com redes sociais e plataformas externas; Gestão de banco de dados de Utilizadores; Interação com plataformas de recolha de dados e outros terceiros; Gestão de endereços de e-mail e envio de mensagens; Registro e autenticação; Gestão de tags e Otimização e distribuição de tráfego.</p>\r\n<p>Os Utilizadores poderão obter informações adicionais detalhadas sobre tais finalidades do processamento e sobre os Dados Pessoais específicos utilizados para cada finalidade nas seções respetivas deste documento.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Permiss</strong><strong>ões do Facebook solicitadas por este Site</strong><br />Este Site pode pedir algumas permissões no Facebook que permitem realizar ações com a conta do Utilizador no Facebook e para recuperar as informações, incluindo dados pessoais. Este serviço permite que este Site se conecte com a conta do Utilizador na rede social Facebook, fornecido pelo Facebook Inc.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Para mais informações sobre as seguintes permissõ</strong><strong>es, consulte a documenta</strong><strong>çã</strong><strong>o de permiss</strong><strong>õ</strong><strong>es Facebook</strong> (https://developers.facebook.com/docs/facebook-login/permissions) e a política de privacidade do Facebook (https://www.facebook.com/about/privacy/).</p>\r\n<p>&nbsp;</p>\r\n<p><strong>As permissões solicitadas são as seguintes:</strong> Aniversário, Contato de e-mail, E-mail e Informações básicas.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Informa</strong><strong>ções detalhadas sobre o processamento de Dados Pessoais</strong><br />Os Dados Pessoais são recolhidos para os seguintes fins e utilizando os seguintes serviços:</p>\r\n<p>&nbsp;</p>\r\n<p>Acesso a contas de serviços de terceiros<br />Este tipo de serviço permite a este serviço (este Site) acessar os Dados da sua conta com um serviço terceiro e realizar ações com os mesmos.<br />Estes serviços não são ativados automaticamente, precisam de autorização explícita do Usuário.</p>\r\n<p>&nbsp;</p>\r\n<p>Acesso à conta Facebook (este Site)<br />Este serviço permite que este Site se conecte com a conta do Usuário na rede social Facebook, fornecido pelo Facebook, Inc.</p>\r\n<p>Pedido de Permissão: Aniversário; Contato de e-mail; E-mail.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.facebook.com/policy.php).<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>Comentário de conteúdo<br />O serviço de comentários de conteúdo permite aos Utilizadores criar e publicar comentários sobre o conteúdo deste serviço (este Site).<br />Dependendo das configurações escolhidas pelo Proprietário, os Utilizadores podem também deixar comentários anónimos. Se houver um endereço de e-mail entre os Dados Pessoais fornecidos pelo Utilizador, poderá ser usado para enviar notificações de comentários sobre o mesmo conteúdo. Os Utilizadores são responsáveis pelo conteúdo dos seus comentários.<br />Se um serviço de comentários de conteúdo prestado por terceiros estiver instalado, este ainda poderá recolher dados de tráfego da web para as páginas onde o serviço de comentário estiver instalado, mesmo quando os Utilizadores não utilizam o serviço de conteúdo de comentários.</p>\r\n<p>&nbsp;</p>\r\n<p>Sistema de Comentários gerido diretamente (este Site)<br />Este Site tem o seu próprio sistema de comentários de conteúdo interno.</p>\r\n<p>Dados Pessoais recolhidos: Cookie; E-mail; Nome; Nome de Utilizador; Apelido; Website.</p>\r\n<p>&nbsp;</p>\r\n<p>Contactar o Utilizador<br />Formulário de contacto (este Site)<br />Ao preencherem o formulário de contacto com os seus Dados, os Utilizadores autorizam este Site a utilizar esses detalhes para responder a pedidos de informações, cotação ou qualquer outro tipo de pedido como indicado pelo título do formulário.</p>\r\n<p>Dados Pessoais recolhidos: Nome, E-mail; Nome da empresa; Número de telefone.</p>\r\n<p>&nbsp;</p>\r\n<p>Lista de endereçamento ou boletim informativo (este Site)<br />Ao registar-se na lista de endereçamento ou no boletim informativo, o endereço de e-mail do Utilizador será adicionado à lista de contactos daqueles que podem receber mensagens de e-mail que contenham informações de natureza comercial ou promocional sobre este Site. O seu endereço de e-mail também poderá ser adicionado a esta lista, como resultado da sua inscrição neste serviço (este Site) ou após a realização de uma compra.</p>\r\n<p>Dados Pessoais recolhidos: E-mail; Nome; Apelido.</p>\r\n<p>&nbsp;</p>\r\n<p>Telefone de contato (este Site)<br />Os Utilizadores que forneceram o número de telefone poderão ser contactados para fins comerciais ou promocionais relacionadas com este Site, bem como para o cumprimento de pedidos de suporte.</p>\r\n<p>Dados Pessoais recolhidos: Número de telefone.</p>\r\n<p>&nbsp;</p>\r\n<p>Estatísticas<br />Os serviços presentes nesta seção habilitam o Proprietário a monitorar e analisar o tráfego da web e podem ser utilizados para rastrear o comportamento do Utilizador.</p>\r\n<p>&nbsp;</p>\r\n<p>Google Analytics (Google Inc.)<br />O Google Analytics é um serviço de análise da Internet fornecido pela Google, dependendo do local a partir do qual este Site for acedido, (“Google”). O Google utiliza os dados recolhidos para acompanhar e analisar o uso deste serviço (este Site) para preparar relatórios sobre atividades e compartilhá-los com outros serviços do Google.<br />O Google pode utilizar os dados recolhidos para contextualizar e personalizar os anúncios da sua própria rede de publicidade.</p>\r\n<p>Dados Pessoais recolhidos: Cookie; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.facebook.com/policy.php ) – Opt (https://policies.google.com/privacy?hl=pt) Out.<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>WordPress Stat (Automattic Inc.)<br />WordPress é um serviço de análise fornecido pela Automattic Inc.</p>\r\n<p>Dados Pessoais recolhidos: Cookie; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://automattic.com/privacy/).</p>\r\n<p>&nbsp;</p>\r\n<p>Gestão do banco de dados dos Utilizadores<br />Esses tipos de serviços permitem que o Proprietário crie perfis de Utilizador a partir de um endereço de e-mail, um nome pessoal, ou outras informações que o Utilizador forneceu a este Site, como também o rastreamento de atividades do Utilizador por meio de recursos analíticos. Estes Dados Pessoais podem também ser combinados com informações publicamente disponíveis sobre o Utilizador (como perfis de redes sociais) e utilizado para construir perfis privados que o Proprietário pode exibir e usar para melhorar o serviço (este Site).<br />Alguns desses serviços podem também ser habilitados para enviar mensagens programadas ao Utilizador tais como emails baseados em ações realizadas neste serviço (este Site).</p>\r\n<p>&nbsp;</p>\r\n<p>Gestão de endereços de e-mail e envio de mensagens<br />Esses tipos de serviços permitem a gestão da base de dados de contatos de e-mail, telefones ou outra informação de contacto para efeitos de comunicação com o Utilizador.<br />Estes serviços também podem ser utilizados para recolher dados referentes à data e o horário em que o Utilizador visualizou o e-mail; e também quando o Utilizador interagiu com o e-mail recebido, como por exemplo, quando o Utilizador selecionou os links incluídos no e-mail.</p>\r\n<p>&nbsp;</p>\r\n<p>Mailchimp (The Rocket Science Group, LLC.)<br />Mailchimp é a gestão de endereços de e-mail e envio de mensagem de serviço prestado por The Rocket Science Group LLC.</p>\r\n<p>Dados Pessoais recolhidos: e-mail.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://mailchimp.com/legal/privacy/).<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>Gestão de tags<br />Este tipo de serviço ajuda o Proprietário a gerir as tags ou scripts necessitados por este Site de forma centralizada. Em consequência disto os Dados do Utilizador fluem através destes serviços e há possibilidade de retenção destes Dados.</p>\r\n<p>&nbsp;</p>\r\n<p>Google Tag Manager (Google)<br />O Google Tag Manager é um serviço de gestão fornecido pela Google, dependendo do local a partir do qual este Site for acedido.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://policies.google.com/privacy?hl=pt).<br />Participante do Privacy Shield.</p>\r\n<p>Interação com plataformas de recolha de dados e outros terceiros<br />Esses tipos de serviços permitem que os Utilizadores interajam com plataformas de recolha de dados ou outros serviços diretamente a partir das páginas deste serviço (este Site) com o objetivo de salvar e reutilizar dados.</p>\r\n<p><br />Se um desses serviços estiver instalado, este poderá recolher Dados de Uso e de navegação nas páginas onde foram instalados, mesmo que os Utilizadores não utilizem o serviço ativamente.</p>\r\n<p>&nbsp;</p>\r\n<p>Interação com redes sociais e plataformas externas<br />Estes tipos de serviços permitem a interação com as redes sociais ou outras plataformas externas diretamente a partir das páginas deste serviço (este Site).<br />A interação e as informações obtidas por este Site estão sempre sujeitas às configurações de privacidade do Utilizador em cada rede social.<br />Este tipo de serviço pode ainda recolher dados de tráfego para as páginas onde o serviço estiver instalado, mesmo quando os Utilizadores não o utilizarem.<br />Recomenda-se sair dos respetivos serviços de forma a garantir que os dados processados neste serviço (este Site) não estejam a ser conectados de volta ao perfil do Utilizador.</p>\r\n<p>&nbsp;</p>\r\n<p>O botão de Gostar e os Widgets sociais do Facebook (Facebook, Inc.)<br />O botão de Gostar do Facebook e os Widgets sociais são serviços que permitem a interação com a rede social Facebook fornecido pela Facebook, Inc.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.facebook.com/privacy/explanation).<br />Participante do Privacy Shield.</p>\r\n<p>O botão +1 e Widgets sociais do Google+ (Google Inc.)<br />O botão +1 e Widgets sociais do Google+ são serviços que permitem a interação com a rede social Google+ fornecido pelo Google, dependendo do local a partir do qual este Site for acedido.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://policies.google.com/privacy?hl=pt-PT).<br />Participante do Privacy Shield.</p>\r\n<p>O botão e os widgets sociais do LinkedIn (LinkedIn Corporation)<br />O botão e os widgets sociais do LinkedIn são serviços que permitem a interação com a rede social LinkedIn fornecido pelo LinkedIn Corporation.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.linkedin.com/legal/privacy-policy).<br />Participante do Privacy Shield.</p>\r\n<p>O botão e os widgets sociais do YouTube (Google Inc.)<br />O botão e os widgets sociais do YouTube são serviços que permitem a interação com a rede social YouTube fornecido pela Google, dependendo do local a partir do qual este Site for acedido.</p>\r\n<p>Dados Pessoais recolhidos: Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://policies.google.com/privacy?hl=pt).<br />Participante do Privacy Shield.</p>\r\n<p>Otimização e distribuição de tráfego<br />Esses tipos de serviços permitem a este Site distribuir o conteúdo deles utilizando servidores localizados em países diferentes, de forma a otimizar o seu desempenho.<br />Alguns Dados Pessoais são processados e dependem das características e da forma como esses serviços são implementados. A sua função é a de filtrar as comunicações entre este Site e o navegador do Utilizador.<br />Considerando a distribuição generalizada deste sistema, é difícil determinar os locais, para os quais os conteúdos, que possam conter informações pessoais do Utilizador, foram transferidos.</p>\r\n<p>&nbsp;</p>\r\n<p>Google reCAPTCHA (Google Inc.)<br />Google reCAPTCHA é um serviço de proteção de SPAM fornecido pelo Google ou pela Google, dependendo do local a partir do qual este Site for acedido.<br />O uso do reCAPTCHA está sujeito à política de privacidade (https://policies.google.com/privacy?hl=pt-BR) e aos termos de utilização (https://policies.google.com/terms?hl=pt-BR) da Google.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://policies.google.com/privacy?hl=pt-PT).<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>Registro e autenticação<br />Ao registrar ou autenticar, os Utilizadores permitem a este serviço (este Site) identificá-los e dar-lhes o acesso a serviços dedicados. Dependendo do que estiver descrito abaixo, os serviços de registro e autenticação podem ser fornecidos por terceiros. Neste caso, este Site poderá aceder a alguns Dados armazenados por estes serviços de terceiros para fins de registro ou identificação.</p>\r\n<p>&nbsp;</p>\r\n<p>Facebook Authentication (Facebook, Inc.)<br />O Facebook Authentication é um serviço de registro e autenticação fornecido pelo Facebook, Inc. e está conectado à rede social Facebook.</p>\r\n<p>Dados Pessoais recolhidos: vários tipos de Dados como especificados na política de privacidade do serviço.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.facebook.com/help/405977429438260).<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>Salvar e gerir o backup<br />Esses tipos de serviços permitem que o Proprietário salve e gira os backups deste serviço (este Site) em servidores externos geridos pelo próprio prestador do serviço. Os backups podem incluir o código fonte e conteúdo, bem como os dados que o Utilizador fornece a este Site.</p>\r\n<p>Visualizar o conteúdo de plataformas externas<br />Esses tipos de serviços permitem que o Utilizador visualize e interage com o conteúdo presente em plataformas externas diretamente das páginas deste serviço (este Site). Se esse tipo de serviço estiver instalado poderá recolher os dados de tráfego da web para as páginas onde o mesmo estiver instalado, até quando os Utilizadores não os estão a utilizar.</p>\r\n<p>Os direitos dos Utilizadores<br />Os Utilizadores poderão exercer determinados direitos a respeito dos seus Dados processados pelo Proprietário.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Em especial, os Utilizadores têm direitos, tais como:</strong></p>\r\n<p>Retirar a sua aprovação a qualquer momento. Os Utilizadores têm o direito de retirar a sua aprovação nos casos em que tenham dado a sua aprovação anteriormente para o processamento dos seus Dados Pessoais.<br />Recusar o processamento dos seus Dados. Os Utilizadores têm o direito de recusar o processamento dos seus Dados se o processamento for executado sobre outra base jurídica que não a aprovação. São fornecidos detalhes adicionais na seção específica abaixo.<br />Aceder aos seus Dados. Os Utilizadores têm o direito de saber se os seus Dados estão a ser processados pelo Proprietário, obter revelações sobre determinados aspetos do processamento e conseguir uma cópia dos Dados que estão em processo.<br />Verificar e pedir correção. Os Utilizadores têm o direito de verificar a exatidão dos seus Dados e pedir eventuais atualizações ou correções.<br />Restringir o processamento dos seus Dados. Os Utilizadores têm o direito de, sob determinadas circunstâncias, restringir o processamento dos seus Dados para qualquer outra finalidade que não seja o armazenamento dos mesmos.<br />Apagar os Dados Pessoais ou retirá-los de outra maneira. Os Utilizadores têm o direito de, sob determinadas circunstâncias, obter a eliminação dos seus Dados do Proprietário.<br />Receber os seus Dados e ter os mesmos que foram transferidos para outro controlador. Os Utilizadores têm o direito de receber os seus Dados num formato estruturado, utilizado comumente e apto a ser lido por máquinas e, se for viável tecnicamente, fazer com que os mesmos sejam transmitidos para outro controlador sem nenhum problema. Esta determinação condiciona que os Dados sejam processados por meios automatizados e que o processamento esteja baseado na aprovação do Utilizador, num contrato do qual o Utilizador seja uma das partes ou por obrigações pré-contratuais do mesmo.<br />Registrar uma reclamação. Os Utilizadores têm o direito de apresentar uma reclamação perante a sua autoridade de proteção de dados competente.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Detalhes sobre o direito de recusar o processamento</strong><br />Nos casos em que os Dados Pessoais forem processados por um interesse público, no exercício de uma autorização oficial na qual o Proprietário estiver investido ou para finalidades dos interesses legítimos perseguidos pelo Proprietário, os Utilizadores poderão recusar o processamento através do fornecimento de um motivo relacionado com a sua situação em especial para justificar a recusa.</p>\r\n<p>Os Utilizadores devem saber que caso os seus Dados Pessoais sejam processados para finalidades de marketing, poderão recusar o processamento a qualquer momento sem fornecer nenhuma justificação. Os Utilizadores podem consultar as seções respetivas deste documento.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Como exercer estes direitos</strong><br />Quaisquer pedidos para exercer os direitos dos Utilizadores podem ser direcionados ao Proprietário através dos dados para contacto fornecidos neste documento. Estes pedidos podem ser exercidos sem nenhum custo e serão atendidos pelo Proprietário com a maior brevidade possível e em todos os casos em prazo inferior a um mês.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Informa</strong><strong>ções adicionais sobre a coleta e processamento de Dados</strong><br /><strong>Ação jurí</strong><strong>dica</strong><br />Os Dados Pessoais dos Utilizadores podem ser utilizados para fins jurídicos pelo Proprietário em questão ou nas etapas conducentes à possível ação jurídica decorrente de uma utilização indevida deste Serviço (este Site) ou dos Serviços relacionados. O Utilizador declara estar ciente de que o Proprietário poderá ser obrigado a revelar os Dados Pessoais mediante solicitação das autoridades governamentais.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Informa</strong><strong>ções adicionais sobre os Dados Pessoais do Utilizador</strong><br />Além das informações contidas nesta política de privacidade, este Site poderá fornecer ao Utilizador informações adicionais e contextuais sobre os serviços específicos ou a recolha do processamento de Dados Pessoais mediante solicitação.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Logs do sistema e manutenção</strong><br />Para fins de sistema e manutenção, este Site e quaisquer serviços de terceiros poderão recolher arquivos que guardam a interação com este Site (logs do sistema) ou utilizar outros Dados Pessoais (tais como endereço IP) para esta finalidade.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Mudanças nesta política de privacidade</strong><br />O Proprietário reserva o direito de fazer alterações nesta política de privacidade a qualquer momento, mediante comunicação aos seus Utilizadores nesta página e possivelmente dentro deste Serviço, este Site e/ou – na medida em que for viável tecnicamente e juridicamente – enviando um aviso aos Utilizadores através de quaisquer informações de contacto disponíveis para o Proprietário. É altamente recomendável que esta página seja consultada várias vezes em relação à última modificação descrita na parte inferior.</p>\r\n<p>Caso as mudanças afetem as atividades de processamento realizadas com base na aprovação do Utilizador, o Proprietário recolherá a nova aprovação do Utilizador, onde for exigida.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Defini</strong><strong>ções e referências jurídicas</strong><br /><strong>Dados Pessoais (ou Dados)</strong><br />Quaisquer informações que diretamente, indiretamente ou em relação com outras informações – incluindo um número de identificação pessoal – permitam a identificação ou identificabilidade de uma pessoa física.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Dados de Utilização</strong><br />As informações recolhidas automaticamente através deste este Site (ou serviços de terceiros contratados neste Serviço), que podem incluir: os endereços IP ou nomes de domínio dos computadores utilizados pelos Utilizadores que utilizam este Site, os endereços URI (Identificador Uniforme de Recurso), a data e hora do pedido, o método utilizado para submeter o pedido ao servidor, o tamanho do arquivo recebido em resposta, o código numérico que indica o status do servidor de resposta (resultado positivo, erro , etc.), o país de origem, as características do navegador e do sistema operacional utilizado pelo Utilizador, os vários detalhes de tempo por visita (por exemplo, o tempo gasto em cada página dentro do aplicativo) e os detalhes sobre o caminho seguido dentro da aplicação, com especial referência à sequência de páginas visitadas e outros parâmetros sobre o sistema operacional do dispositivo e/ou ambiente de TI do Utilizador.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Utilizador</strong><br />A pessoa que utiliza este Site que, a menos que especificado diferentemente, coincida com o Titular dos Dados.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Titular dos Dados</strong><br />A pessoa física a quem os Dados Pessoais se referem.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Processador de Dados (ou supervisor de Dados)</strong><br />A pessoa física ou jurídica, administração pública, agência ou outro órgão que processe os Dados Pessoais em nome do Controlador conforme descrito nesta política de privacidade.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Controlador de Dados (ou proprietá</strong><strong>rio)</strong><br />A pessoa física ou jurídica, administração pública, agência ou outro órgão que, isoladamente ou em conjunto com outros determinar as finalidades e os meios de processamento dos Dados Pessoais, incluindo medidas de segurança relativas ao funcionamento e à utilização deste Serviço (este Site). O Controlador de Dados, a menos que seja especificado de outra forma, é o Proprietário deste Serviço (este Site).</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Este Site (ou este Aplicativo)</strong><br />O meio pelo qual os Dados Pessoais do Utilizador são recolhidos e processados.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Serviço</strong><br />O serviço fornecido por este Site conforme descrito nos termos relativos (se disponíveis) e neste site/aplicativo.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>União Europeia (ou UE)</strong><br />A menos que especificado diferentemente, todas as referências feitas neste documento à União Europeia incluem todos os atuais estados membros da União Europeia e do Espaço Econômico Europeu.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Cookies</strong><br />Pequenas unidades de dados armazenados no dispositivo do Utilizador.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Informa</strong><strong>ção jurí</strong><strong>dica</strong><br />Esta declaração de privacidade foi preparada com base em determinações de múltiplas legislações, inclusive os Arts. 13/14 do Regulamento (EU) 2016/679 (GDPR – Regulamento Geral de Proteção de Dados).</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Última atualizaçã</strong><strong>o: </strong><strong>26</strong><strong> de </strong><strong>maio de 2022</strong></p>", "Política de privacidade", "", "publish", "closed", "open", "", "politica-privacidade", "", "", "2023-02-14 10:46:33", "2023-02-14 10:46:33", "", "0", "https://midtemplate.makeitdigital2.tk/?page_id=3", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("5", "1", "2023-02-13 23:30:18", "2023-02-13 23:30:18", "<p>[vc_row height=\"auto\"][vc_column width=\"1/1\"][dhvc_form_text required=\"1\" control_label=\"Nome\" control_name=\"nome\" input_css=\".vc_custom_1676330913065{margin-bottom: 10px !important;}\"][/vc_column][/vc_row][vc_row height=\"auto\" columns_gap=\"0.8rem\"][vc_column width=\"1/2\"][dhvc_form_email required=\"1\" control_label=\"Email\" control_name=\"email\" input_css=\".vc_custom_1676159579023{margin-bottom: 10px !important;}\"][/vc_column][vc_column width=\"1/2\"][dhvc_form_text required=\"1\" control_label=\"Telefone\" control_name=\"telefone\" input_css=\".vc_custom_1676330923395{margin-bottom: 10px !important;}\"][/vc_column][/vc_row][vc_row height=\"auto\"][vc_column width=\"1/1\"][dhvc_form_textarea required=\"1\" control_label=\"Mensagem\" control_name=\"mensagem\" input_css=\".vc_custom_1676330935633{margin-bottom: 20px !important;}\"][dhvc_form_checkbox required=\"1\" control_name=\"optin\" options=\"W3siaXNfZGVmYXVsdCI6MCwibGFiZWwiOiI8c3BhbiBzdHlsZT1cImZvbnQtc2l6ZTowLjdyZW0gIWltcG9ydGFudDtcIj5Fc3RvdSBkZSBhY29yZG8gY29tIGEgPGEgaHJlZj1cIi9wb2xpdGljYS1wcml2YWNpZGFkZS9cIiB0YXJnZXQ9XCJfYmxhbmtcIiByZWw9XCJub29wZW5lclwiPlBvbMOtdGljYSBkZSBQcml2YWNpZGFkZTwvYT4gcXVlIGxpIGUgY29tcHJlZW5kaS48L3NwYW4+IiwidmFsdWUiOiJvcHRpbiJ9XQ==\" input_css=\".vc_custom_1676330982083{margin-bottom: 20px !important;}\"][dhvc_form_submit_button label=\"Enviar\"][/vc_column][/vc_row]</p>\r\n", "Contacto PT", "", "publish", "closed", "closed", "", "contacto-pt", "", "", "2023-02-13 23:38:09", "2023-02-13 23:38:09", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=dhvcform&#038;p=5", "0", "dhvcform", "", "0");
INSERT INTO `wp_posts` VALUES("6", "1", "2023-02-13 23:30:45", "2023-02-13 23:30:45", "<p>[vc_row][vc_column width=\"1/1\"][dhvc_form id=\"5\"][/vc_column][/vc_row]</p>\r\n", "Exemplo de página", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2023-02-13 23:30:45", "2023-02-13 23:30:45", "", "2", "https://midtemplate.makeitdigital2.tk/?p=6", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("7", "1", "2023-02-13 23:39:16", "2023-02-13 23:39:16", "<p>[vc_row height=\"auto\"][vc_column width=\"1/1\"][dhvc_form_text required=\"1\" control_label=\"Name\" control_name=\"name\" input_css=\".vc_custom_1676331511714{margin-bottom: 10px !important;}\"][/vc_column][/vc_row][vc_row height=\"auto\" columns_gap=\"0.8rem\"][vc_column width=\"1/2\"][dhvc_form_email required=\"1\" control_label=\"Email\" control_name=\"email\" input_css=\".vc_custom_1676159579023{margin-bottom: 10px !important;}\"][/vc_column][vc_column width=\"1/2\"][dhvc_form_text required=\"1\" control_label=\"Phone\" control_name=\"phone\" input_css=\".vc_custom_1676331520066{margin-bottom: 10px !important;}\"][/vc_column][/vc_row][vc_row height=\"auto\"][vc_column width=\"1/1\"][dhvc_form_textarea required=\"1\" control_label=\"Message\" control_name=\"message\" input_css=\".vc_custom_1676331529269{margin-bottom: 20px !important;}\"][dhvc_form_checkbox required=\"1\" control_name=\"optin\" options=\"W3siaXNfZGVmYXVsdCI6MCwibGFiZWwiOiI8c3BhbiBzdHlsZT1cImZvbnQtc2l6ZTowLjdyZW0gIWltcG9ydGFudDtcIj5Fc3RvdSBkZSBhY29yZG8gY29tIGEgPGEgaHJlZj1cIi9wb2xpdGljYS1wcml2YWNpZGFkZS9cIiB0YXJnZXQ9XCJfYmxhbmtcIiByZWw9XCJub29wZW5lclwiPlBvbMOtdGljYSBkZSBQcml2YWNpZGFkZTwvYT4gcXVlIGxpIGUgY29tcHJlZW5kaS48L3NwYW4+IiwidmFsdWUiOiJvcHRpbiJ9XQ==\" input_css=\".vc_custom_1676330982083{margin-bottom: 20px !important;}\"][dhvc_form_submit_button][/vc_column][/vc_row]</p>\r\n", "Contacto EN", "", "publish", "closed", "closed", "", "contacto-en", "", "", "2023-02-13 23:39:16", "2023-02-13 23:39:16", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=dhvcform&#038;p=7", "0", "dhvcform", "", "0");
INSERT INTO `wp_posts` VALUES("8", "1", "2023-02-13 23:41:45", "2023-02-13 23:41:45", "", "Slide_homep", "", "publish", "closed", "closed", "", "slide_homep", "", "", "2023-02-13 23:41:45", "2023-02-13 23:41:45", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=cpt_cpt&#038;p=8", "0", "cpt_cpt", "", "0");
INSERT INTO `wp_posts` VALUES("9", "1", "2023-02-13 23:42:56", "2023-02-13 23:42:56", "{\"data\":{\"post_content:1\":{\"type\":\"full_content\",\"remove_rows\":\"\",\"force_fullwidth_rows\":0,\"excerpt_length\":\"0\",\"length\":\"30\",\"show_more_toggle\":0,\"show_more_toggle_height\":\"200px\",\"show_more_toggle_text_more\":\"Show More\",\"show_more_toggle_text_less\":\"Show Less\",\"show_more_toggle_alignment\":\"none\",\"css\":\"\",\"el_class\":\"\",\"el_id\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\"}},\"default\":{\"options\":{\"fixed\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"overflow\":0,\"color_bg\":\"\",\"color_text\":\"\",\"bg_img_source\":\"none\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_file_size\":\"large\",\"bg_img_size\":\"cover\",\"bg_img_position\":\"center center\",\"bg_img_repeat\":\"no-repeat\",\"bg_img_wrapper_end\":\"\",\"border_radius\":0,\"box_shadow\":0,\"box_shadow_hover\":0,\"el_class\":\"\"},\"layout\":{\"hidden\":[],\"middle_center\":[\"post_content:1\"]}}}", "Slide full content", "", "publish", "closed", "closed", "", "slide-full-content", "", "", "2023-02-13 23:43:15", "2023-02-13 23:43:15", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=us_grid_layout&#038;p=9", "0", "us_grid_layout", "", "0");
INSERT INTO `wp_posts` VALUES("10", "1", "2023-02-14 10:35:02", "2023-02-14 10:35:02", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_header_middle_bg%22%7D%7D\"][vc_column width=\"1/1\"][us_separator size=\"large\"][us_post_title css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22padding-bottom%22%3A%2220px%22%7D%7D\" el_class=\"titlecenterazul\"][us_separator size=\"small\"][/vc_column][/vc_row]", "Page title PT", "", "publish", "closed", "closed", "", "page-title-pt", "", "", "2024-12-11 14:46:42", "2024-12-11 14:46:42", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=us_page_block&#038;p=10", "0", "us_page_block", "", "0");
INSERT INTO `wp_posts` VALUES("11", "1", "2023-02-14 10:38:19", "2023-02-14 10:38:19", "<p>[vc_row content_placement=\"middle\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_bg_alt%22%2C%22background-image%22%3A%22161%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\"][vc_column width=\"1/1\"][us_separator][us_post_title css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_text%22%2C%22font-size%22%3A%221.9rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"][us_separator][/vc_column][/vc_row]</p>\n", "Page title PT", "", "inherit", "closed", "closed", "", "10-autosave-v1", "", "", "2023-02-14 10:38:19", "2023-02-14 10:38:19", "", "10", "https://midtemplate.makeitdigital2.tk/?p=11", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("12", "1", "2023-02-14 10:37:03", "2023-02-14 10:37:03", "{\"default\":{\"options\":{\"custom_breakpoint\":0,\"breakpoint\":\"900px\",\"orientation\":\"hor\",\"sticky\":1,\"sticky_auto_hide\":0,\"scroll_breakpoint\":\"1px\",\"transparent\":0,\"width\":\"300px\",\"elm_align\":\"center\",\"shadow\":\"wide\",\"top_show\":true,\"top_height\":\"40px\",\"top_sticky_height\":\"0px\",\"top_fullwidth\":0,\"top_centering\":0,\"top_bg_color\":\"_content_link_hover\",\"top_text_color\":\"_header_middle_bg\",\"top_text_hover_color\":\"_content_bg_alt\",\"top_transparent_bg_color\":\"_content_link_hover\",\"top_transparent_text_color\":\"_header_middle_bg\",\"top_transparent_text_hover_color\":\"_content_bg_alt\",\"middle_height\":\"170px\",\"middle_sticky_height\":\"100px\",\"middle_fullwidth\":0,\"middle_centering\":1,\"elm_valign\":\"top\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_img_size\":\"cover\",\"bg_img_repeat\":\"repeat\",\"bg_img_position\":\"top left\",\"bg_img_attachment\":1,\"bg_img_wrapper_end\":\"\",\"middle_bg_color\":\"linear-gradient(0deg,#fffef5,#ffffff)\",\"middle_text_color\":\"_content_heading\",\"middle_text_hover_color\":\"_content_link\",\"middle_transparent_bg_color\":\"_header_transparent_bg\",\"middle_transparent_text_color\":\"_header_top_text\",\"middle_transparent_text_hover_color\":\"_content_secondary\",\"bottom_show\":1,\"bottom_height\":\"70px\",\"bottom_sticky_height\":\"60px\",\"bottom_fullwidth\":0,\"bottom_centering\":0,\"bottom_bg_color\":\"_alt_content_bg_alt\",\"bottom_text_color\":\"_header_middle_text\",\"bottom_text_hover_color\":\"_content_secondary\",\"bottom_transparent_bg_color\":\"_header_transparent_bg\",\"bottom_transparent_text_color\":\"_header_middle_text\",\"bottom_transparent_text_hover_color\":\"_content_secondary\"},\"layout\":{\"top_left\":[],\"top_center\":[],\"top_right\":[\"text:3\",\"socials:1\"],\"middle_left\":[],\"middle_center\":[\"image:1\"],\"middle_right\":[],\"bottom_left\":[],\"bottom_center\":[\"menu:1\",\"btn:1\"],\"bottom_right\":[],\"hidden\":[\"text:2\",\"text:1\"]}},\"laptops\":{\"options\":{\"custom_breakpoint\":0,\"breakpoint\":\"900px\",\"orientation\":\"hor\",\"sticky\":1,\"sticky_auto_hide\":0,\"scroll_breakpoint\":\"1px\",\"transparent\":0,\"width\":\"300px\",\"elm_align\":\"center\",\"shadow\":\"thin\",\"top_show\":true,\"top_height\":\"40px\",\"top_sticky_height\":\"0px\",\"top_fullwidth\":0,\"top_centering\":0,\"top_bg_color\":\"_header_top_bg\",\"top_text_color\":\"_header_top_text\",\"top_text_hover_color\":\"_header_top_text_hover\",\"top_transparent_bg_color\":\"_header_top_transparent_bg\",\"top_transparent_text_color\":\"_header_top_transparent_text\",\"top_transparent_text_hover_color\":\"_header_top_transparent_text_hover\",\"middle_height\":\"100px\",\"middle_sticky_height\":\"60px\",\"middle_fullwidth\":0,\"middle_centering\":0,\"elm_valign\":\"top\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_img_size\":\"cover\",\"bg_img_repeat\":\"repeat\",\"bg_img_position\":\"top left\",\"bg_img_attachment\":1,\"bg_img_wrapper_end\":\"\",\"middle_bg_color\":\"_header_middle_bg\",\"middle_text_color\":\"_header_middle_text\",\"middle_text_hover_color\":\"_header_middle_text_hover\",\"middle_transparent_bg_color\":\"_header_transparent_bg\",\"middle_transparent_text_color\":\"_header_transparent_text\",\"middle_transparent_text_hover_color\":\"_header_transparent_text_hover\",\"bottom_show\":0,\"bottom_height\":\"50px\",\"bottom_sticky_height\":\"50px\",\"bottom_fullwidth\":0,\"bottom_centering\":0,\"bottom_bg_color\":\"_header_middle_bg\",\"bottom_text_color\":\"_header_middle_text\",\"bottom_text_hover_color\":\"_header_middle_text_hover\",\"bottom_transparent_bg_color\":\"_header_transparent_bg\",\"bottom_transparent_text_color\":\"_header_transparent_text\",\"bottom_transparent_text_hover_color\":\"_header_transparent_text_hover\"},\"layout\":{\"top_left\":[],\"top_center\":[],\"top_right\":[\"socials:1\"],\"middle_left\":[\"image:1\"],\"middle_center\":[],\"middle_right\":[\"menu:1\"],\"bottom_left\":[],\"bottom_center\":[\"btn:1\"],\"bottom_right\":[],\"hidden\":[\"text:2\",\"text:3\",\"text:1\"]}},\"tablets\":{\"options\":{\"custom_breakpoint\":0,\"breakpoint\":\"900px\",\"orientation\":\"hor\",\"sticky\":1,\"sticky_auto_hide\":0,\"scroll_breakpoint\":\"1px\",\"transparent\":0,\"width\":\"300px\",\"elm_align\":\"center\",\"shadow\":\"thin\",\"top_show\":true,\"top_height\":\"40px\",\"top_sticky_height\":\"0px\",\"top_fullwidth\":0,\"top_centering\":0,\"top_bg_color\":\"_header_top_bg\",\"top_text_color\":\"_header_top_text\",\"top_text_hover_color\":\"_header_top_text_hover\",\"top_transparent_bg_color\":\"_header_top_transparent_bg\",\"top_transparent_text_color\":\"_header_top_transparent_text\",\"top_transparent_text_hover_color\":\"_header_top_transparent_text_hover\",\"middle_height\":\"80px\",\"middle_sticky_height\":\"60px\",\"middle_fullwidth\":0,\"middle_centering\":0,\"elm_valign\":\"top\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_img_size\":\"cover\",\"bg_img_repeat\":\"repeat\",\"bg_img_position\":\"top left\",\"bg_img_attachment\":1,\"bg_img_wrapper_end\":\"\",\"middle_bg_color\":\"_header_middle_bg\",\"middle_text_color\":\"_header_middle_text\",\"middle_text_hover_color\":\"_header_middle_text_hover\",\"middle_transparent_bg_color\":\"_header_transparent_bg\",\"middle_transparent_text_color\":\"_header_transparent_text\",\"middle_transparent_text_hover_color\":\"_header_transparent_text_hover\",\"bottom_show\":0,\"bottom_height\":\"50px\",\"bottom_sticky_height\":\"50px\",\"bottom_fullwidth\":0,\"bottom_centering\":0,\"bottom_bg_color\":\"_header_middle_bg\",\"bottom_text_color\":\"_header_middle_text\",\"bottom_text_hover_color\":\"_header_middle_text_hover\",\"bottom_transparent_bg_color\":\"_header_transparent_bg\",\"bottom_transparent_text_color\":\"_header_transparent_text\",\"bottom_transparent_text_hover_color\":\"_header_transparent_text_hover\"},\"layout\":{\"top_left\":[],\"top_center\":[],\"top_right\":[\"socials:1\"],\"middle_left\":[\"image:1\"],\"middle_center\":[],\"middle_right\":[\"menu:1\"],\"bottom_left\":[],\"bottom_center\":[\"btn:1\"],\"bottom_right\":[],\"hidden\":[\"text:2\",\"text:3\",\"text:1\"]}},\"mobiles\":{\"options\":{\"custom_breakpoint\":0,\"breakpoint\":\"900px\",\"orientation\":\"hor\",\"sticky\":1,\"sticky_auto_hide\":0,\"scroll_breakpoint\":\"1px\",\"transparent\":0,\"width\":\"300px\",\"elm_align\":\"center\",\"shadow\":\"thin\",\"top_show\":0,\"top_height\":\"40px\",\"top_sticky_height\":\"0px\",\"top_fullwidth\":0,\"top_centering\":0,\"top_bg_color\":\"_header_top_bg\",\"top_text_color\":\"_header_top_text\",\"top_text_hover_color\":\"_header_top_text_hover\",\"top_transparent_bg_color\":\"_header_top_transparent_bg\",\"top_transparent_text_color\":\"_header_top_transparent_text\",\"top_transparent_text_hover_color\":\"_header_top_transparent_text_hover\",\"middle_height\":\"60px\",\"middle_sticky_height\":\"60px\",\"middle_fullwidth\":0,\"middle_centering\":0,\"elm_valign\":\"top\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_img_size\":\"cover\",\"bg_img_repeat\":\"repeat\",\"bg_img_position\":\"top left\",\"bg_img_attachment\":1,\"bg_img_wrapper_end\":\"\",\"middle_bg_color\":\"_header_middle_bg\",\"middle_text_color\":\"_header_middle_text\",\"middle_text_hover_color\":\"_header_middle_text_hover\",\"middle_transparent_bg_color\":\"_header_transparent_bg\",\"middle_transparent_text_color\":\"_header_transparent_text\",\"middle_transparent_text_hover_color\":\"_header_transparent_text_hover\",\"bottom_show\":0,\"bottom_height\":\"50px\",\"bottom_sticky_height\":\"50px\",\"bottom_fullwidth\":0,\"bottom_centering\":0,\"bottom_bg_color\":\"_header_middle_bg\",\"bottom_text_color\":\"_header_middle_text\",\"bottom_text_hover_color\":\"_header_middle_text_hover\",\"bottom_transparent_bg_color\":\"_header_transparent_bg\",\"bottom_transparent_text_color\":\"_header_transparent_text\",\"bottom_transparent_text_hover_color\":\"_header_transparent_text_hover\"},\"layout\":{\"top_left\":[],\"top_center\":[],\"top_right\":[],\"middle_left\":[\"image:1\"],\"middle_center\":[],\"middle_right\":[\"menu:1\"],\"bottom_left\":[],\"bottom_center\":[\"btn:1\"],\"bottom_right\":[],\"hidden\":[\"text:2\",\"text:3\",\"text:1\",\"socials:1\"]}},\"data\":{\"image:1\":{\"img\":\"81\",\"image\":\"\",\"has_ratio\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"disable_lazy_loading\":0,\"meta\":0,\"meta_style\":\"simple\",\"align\":\"none\",\"style\":\"\",\"size\":\"full\",\"img_transparent\":\"\",\"link\":\"%7B%22url%22%3A%22%2F%22%7D\",\"heading_1\":\"\",\"height_default\":\"140px\",\"height_laptops\":\"140px\",\"height_tablets\":\"140px\",\"height_mobiles\":\"60px\",\"heading_2\":\"\",\"height_sticky\":\"80px\",\"height_sticky_laptops\":\"80px\",\"height_sticky_tablets\":\"80px\",\"height_sticky_mobiles\":\"40px\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"margin-top\":\"20px\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"scale_hover\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"animate\":\"\",\"animate_delay\":\"\",\"link_new_tab\":\"\",\"onclick\":\"\",\"onclick_code\":\"\"},\"text:2\":{\"text\":\"+351 000 000 000\",\"wrap\":0,\"link\":\"%7B%22url%22%3A%22%22%7D\",\"hide_with_empty_link\":0,\"tag\":\"div\",\"background_inside_text\":0,\"icon\":\"fas|phone\",\"iconpos\":\"left\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"font-size\":\"0.8rem\",\"font-weight\":\"500\",\"margin-right\":\"2px\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"scale_hover\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"align\":\"\",\"link_type\":\"\",\"link_new_tab\":\"\",\"onclick_code\":\"\"},\"text:3\":{\"text\":\"Contactos\",\"wrap\":0,\"link\":\"%7B%22url%22%3A%22%2Fcontactos%2F%22%7D\",\"hide_with_empty_link\":0,\"tag\":\"div\",\"background_inside_text\":0,\"icon\":\"\",\"iconpos\":\"left\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"font-size\":\"0.72rem\",\"letter-spacing\":\"0.08em\",\"font-weight\":\"700\",\"text-transform\":\"uppercase\",\"margin-right\":\"15px\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"scale_hover\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"align\":\"\",\"link_type\":\"\",\"link_new_tab\":\"\",\"onclick_code\":\"\"},\"socials:1\":{\"items\":[{\"type\":\"facebook\",\"url\":\"%7B%22url%22%3A%22https%3A%2F%2Fwww.facebook.com%2Fprofile.php%3Fid%3D100069900293483%22%2C%22target%22%3A%22_blank%22%2C%22rel%22%3A%22nofollow%22%7D\",\"icon\":\"fab|apple\",\"title\":\"Título\",\"color\":\"_content_faded\"},{\"type\":\"instagram\",\"url\":\"%7B%22url%22%3A%22https%3A%2F%2Fwww.instagram.com%2Fbatazu_family%2F%22%2C%22target%22%3A%22_blank%22%7D\",\"icon\":\"fab|apple\",\"title\":\"Título\",\"color\":\"_content_faded\"},{\"type\":\"linkedin\",\"url\":\"%7B%22url%22%3A%22https%3A%2F%2Fwww.linkedin.com%2Fcompany%2Fbatazu-family%2Fposts%2F%3FfeedView%3Dall%22%2C%22target%22%3A%22_blank%22%2C%22rel%22%3A%22nofollow%22%7D\",\"icon\":\"fab|apple\",\"title\":\"Título\",\"color\":\"_content_faded\"}],\"shape\":\"none\",\"style\":\"default\",\"icons_color\":\"text\",\"hover\":\"fade\",\"stretch\":0,\"gap\":\"0.5em\",\"hide_tooltip\":0,\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"font-size\":\"1rem\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"color\":\"\",\"align\":\"\",\"nofollow\":\"\"},\"menu:1\":{\"source\":\"principal\",\"indents\":\"14px\",\"spread\":0,\"align_edges\":0,\"vstretch\":1,\"hover_effect\":\"simple\",\"dropdown_arrow\":1,\"dropdown_effect\":\"height\",\"dropdown_font_size\":\"0.9rem\",\"dropdown_width\":0,\"mobile_width\":\"900px\",\"mobile_layout\":\"dropdown\",\"mobile_effect_p\":\"afl\",\"mobile_effect_f\":\"aft\",\"mobile_font_size\":\"1.1rem\",\"mobile_dropdown_font_size\":\"0.9rem\",\"mobile_align\":\"none\",\"mobile_behavior\":\"1\",\"heading_1\":\"\",\"mobile_icon_size\":\"36px\",\"mobile_icon_size_laptops\":\"32px\",\"mobile_icon_size_tablets\":\"28px\",\"mobile_icon_size_mobiles\":\"24px\",\"mobile_icon_thickness\":\"3px\",\"mobile_icon_text\":\"none\",\"mobile_icon_text_label\":\"Menu\",\"color_hover_bg\":\"transparent\",\"color_hover_text\":\"_content_secondary\",\"color_active_bg\":\"transparent\",\"color_active_text\":\"_content_secondary\",\"color_transparent_hover_bg\":\"\",\"color_transparent_hover_text\":\"_content_secondary\",\"color_transparent_active_bg\":\"transparent\",\"color_transparent_active_text\":\"_content_secondary\",\"color_drop_bg\":\"_header_middle_bg\",\"color_drop_text\":\"_header_middle_text\",\"color_drop_hover_bg\":\"transparent\",\"color_drop_hover_text\":\"_content_secondary\",\"color_drop_active_bg\":\"transparent\",\"color_drop_active_text\":\"_content_secondary\",\"mobile_colors\":0,\"color_mobile_bg\":\"_content_bg\",\"color_mobile_text\":\"_content_heading\",\"color_mobile_hover_bg\":\"transparent\",\"color_mobile_hover_text\":\"_content_link_hover\",\"color_mobile_active_bg\":\"transparent\",\"color_mobile_active_text\":\"_content_link\",\"color_mobile_sub_bg\":\"transparent\",\"color_mobile_sub_text\":\"_content_text\",\"color_mobile_sub_hover_bg\":\"transparent\",\"color_mobile_sub_hover_text\":\"_content_link_hover\",\"color_mobile_sub_active_bg\":\"transparent\",\"color_mobile_sub_active_text\":\"_content_link\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"font-size\":\"0.86rem\",\"letter-spacing\":\"0.02em\",\"font-weight\":\"800\",\"text-transform\":\"uppercase\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\"},\"text:1\":{\"text\":\"(Chamada para a rede móvel nacional)\",\"wrap\":0,\"link\":\"%7B%22url%22%3A%22%22%7D\",\"hide_with_empty_link\":0,\"tag\":\"div\",\"background_inside_text\":0,\"icon\":\"\",\"iconpos\":\"left\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"color\":\"_content_bg_alt\",\"font-size\":\"0.6rem\",\"font-weight\":\"400\",\"margin-left\":\"2px\",\"margin-top\":\"2px\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"scale_hover\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"align\":\"\",\"link_type\":\"\",\"link_new_tab\":\"\",\"onclick_code\":\"\"},\"btn:1\":{\"label\":\"Apoiar\",\"link\":\"%7B%22url%22%3A%22%2F%23apoiar%22%7D\",\"hide_with_empty_link\":0,\"style\":\"5\",\"align\":\"none\",\"icon\":\"\",\"iconpos\":\"left\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"margin-left\":\"15px\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"scale_hover\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"link_new_tab\":\"\",\"link_type\":\"\",\"onclick_code\":\"\",\"width_type\":\"\"}}}", "Header PT", "", "publish", "closed", "closed", "", "header-pt", "", "", "2024-12-11 15:55:38", "2024-12-11 15:55:38", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=us_header&#038;p=12", "0", "us_header", "", "0");
INSERT INTO `wp_posts` VALUES("13", "1", "2023-02-14 10:40:33", "2023-02-14 10:40:33", "{\"title\":\"Image first (category, date, excerpt)\",\"cols\":\"2\",\"data\":{\"post_image:1\":{\"placeholder\":0,\"media_preview\":1,\"gallery_images_amount\":\"10\",\"circle\":0,\"has_ratio\":1,\"ratio\":\"16x9\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"stretch\":1,\"disable_lazy_loading\":0,\"thumbnail_size\":\"full\",\"link\":\"%7B%22type%22%3A%22post%22%7D\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"margin-bottom\":\"1rem\",\"overflow\":\"hidden\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":1,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1.03\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"custom_link\":\"\",\"link_new_tab\":\"\"},\"post_title:1\":{\"tag\":\"h2\",\"show_count\":0,\"align\":\"none\",\"link\":\"%7B%22type%22%3A%22post%22%7D\",\"color_link\":1,\"shorten_length\":0,\"shorten_length_count\":\"30\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"font-size\":\"1rem\",\"font-weight\":\"600\",\"margin-top\":\"0.2rem\",\"margin-bottom\":\"0.3rem\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"custom_link\":\"\",\"link_new_tab\":\"\"},\"btn:1\":{\"label\":\"Ver mais\",\"link\":\"%7B%22type%22%3A%22post%22%7D\",\"hide_with_empty_link\":1,\"style\":\"2\",\"align\":\"none\",\"icon\":\"fal|arrow-right\",\"iconpos\":\"right\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":\"\",\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"link_new_tab\":\"\",\"link_type\":\"\",\"onclick_code\":\"\",\"width_type\":\"\"},\"post_taxonomy:1\":{\"taxonomy_name\":\"category\",\"style\":\"simple\",\"btn_style\":\"badge\",\"separator\":\", \",\"link\":\"%7B%22type%22%3A%22archive%22%7D\",\"color_link\":1,\"icon\":\"\",\"text_before\":\"\",\"text_after\":\"\",\"show_color_swatch\":0,\"hide_color_swatch_label\":0,\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"color\":\"_content_faded\",\"font-size\":\"0.55rem\",\"line-height\":\"0.8rem\",\"letter-spacing\":\"1px\",\"font-weight\":\"600\",\"text-transform\":\"uppercase\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"custom_link\":\"\"}},\"default\":{\"layout\":{\"middle_center\":[\"post_image:1\",\"post_taxonomy:1\",\"post_title:1\",\"btn:1\"],\"hidden\":[]},\"options\":{\"fixed\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"overflow\":1,\"color_bg\":\"\",\"color_text\":\"\",\"ignore_us_tile_colors\":0,\"bg_img_source\":\"none\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_file_size\":\"large\",\"bg_img_size\":\"cover\",\"bg_img_position\":\"center center\",\"bg_img_repeat\":\"no-repeat\",\"bg_img_wrapper_end\":\"\",\"border_radius\":0,\"box_shadow\":0,\"box_shadow_hover\":0,\"el_class\":\"\"}}}", "Grid Blog", "", "publish", "closed", "closed", "", "grid-blog", "", "", "2024-12-11 15:12:48", "2024-12-11 15:12:48", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=us_grid_layout&#038;p=13", "0", "us_grid_layout", "", "0");
INSERT INTO `wp_posts` VALUES("14", "1", "2023-02-14 10:41:42", "2023-02-14 10:41:42", "<p>[vc_row][vc_column width=\"1/1\"][us_grid items_layout=\"13\" columns=\"3\"][/vc_column][/vc_row]</p>\r\n", "Exemplo de página", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2023-02-14 10:41:42", "2023-02-14 10:41:42", "", "2", "https://midtemplate.makeitdigital2.tk/?p=14", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("15", "1", "2023-02-14 10:44:17", "2023-02-14 10:44:17", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22background-image%22%3A%22281%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/4\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-left%22%3A%2210px%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%2C%22margin-left%22%3A%2210px%22%7D%7D\"][/vc_column][vc_column width=\"1/4\"][us_additional_menu main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column][vc_column width=\"2/4\"][us_additional_menu source=\"footer-2\" main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][us_image image=\"92\" size=\"full\" link=\"%7B%22url%22%3A%22https%3A%2F%2Fwww.livroreclamacoes.pt%2Finicio%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22123px%22%2C%22margin-top%22%3A%223rem%22%7D%7D\"][/vc_column][/vc_row][vc_row disable_element=\"yes\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_additional_menu main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_additional_menu source=\"footer-2\" main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_image image=\"92\" size=\"full\" link=\"%7B%22url%22%3A%22https%3A%2F%2Fwww.livroreclamacoes.pt%2Finicio%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22123px%22%2C%22bottom%22%3A%220%22%2C%22right%22%3A%220%22%7D%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]", "Footer PT", "", "publish", "closed", "closed", "", "footer-pt", "", "", "2024-12-11 16:11:16", "2024-12-11 16:11:16", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=us_page_block&#038;p=15", "0", "us_page_block", "", "0");
INSERT INTO `wp_posts` VALUES("16", "1", "2024-12-11 16:02:36", "2024-12-11 16:02:36", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"4/12\"][us_additional_menu main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"5/12\"][us_additional_menu source=\"footer-2\" main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]</p>\n", "Footer PT", "", "inherit", "closed", "closed", "", "15-autosave-v1", "", "", "2024-12-11 16:02:36", "2024-12-11 16:02:36", "", "15", "https://midtemplate.makeitdigital2.tk/?p=16", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("17", "1", "2023-02-14 10:46:33", "2023-02-14 10:46:33", "<p>Este Site recolhe alguns Dados Pessoais dos Utilizadores.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Propriet</strong><strong>ário e Controlador de Dados</strong><br />Nome da empresa legal</p>\r\n<p>Morada da empresa</p>\r\n<p>&nbsp;</p>\r\n<p><strong>E-mail de contato do Proprietá</strong><strong>rio:</strong> email de contacto da pessoas de contacto</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Tipos de Dados recolhidos</strong><br />Entre os tipos de Dados Pessoais que este Site recolhe, por si mesmo ou através de terceiros, existem: Nome; Apelido; Número de telefone; Nome da empresa; E-mail; Cookies.</p>\r\n<p>Os detalhes completos dos Dados Pessoais recolhidos são fornecidos nas seções dedicadas desta política de privacidade ou por textos explicativos específicos exibidos antes da recolha dos mesmos.<br />Os Dados Pessoais poderão ser fornecidos voluntariamente pelo Utilizador, ou, no caso dos Dados de Utilização, recolhidos automaticamente ao se utilizar este Site.</p>\r\n<p>A menos que seja especificado que todos os Dados solicitados por este Site são obrigatórios e a falta de fornecimento destes Dados poderá impossibilitar este Site de fornecer os seus Serviços. Nos casos em que este Site afirma especificamente que alguns Dados não são obrigatórios, os Utilizadores não terão de preencher esses Dados e não existirão consequências para a disponibilidade ou o funcionamento do Serviço.</p>\r\n<p>Os Utilizadores que tiverem dúvidas a respeito de quais os Dados Pessoais que são obrigatórios estão convidados a entrar em contato com o Proprietário.<br />Quaisquer usos de cookies – ou de outras ferramentas de rastreamento – por este Site ou pelos proprietários de serviços terceiros utilizados por este Site serão para a finalidade de fornecer os Serviços solicitados pelo Utilizador, além das demais finalidades descritas no presente documento e na Política de Cookies, se estiver disponível.</p>\r\n<p>Os Utilizadores ficam responsáveis por quaisquer Dados Pessoais de terceiros que forem obtidos, publicados ou compartilhados através deste Serviço (este Site) e confirmam que possuem a autorização dos terceiros para fornecerem os Dados para o Proprietário.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Modo e local de processamento dos Dados</strong></p>\r\n<p><br /><strong>M</strong><strong>é</strong><strong>todo de processamento</strong></p>\r\n<p>O Proprietário tomará as medidas de segurança adequadas para impedir o acesso não autorizado, divulgação, alteração ou destruição não autorizada dos Dados.<br />O processamento dos Dados é realizado através de computadores e /ou ferramentas de TI habilitadas, seguindo procedimentos organizacionais e meios estritamente relacionados com os fins indicados. Além do Proprietário, em alguns casos, os Dados podem ser acessados por certos tipos de pessoas encarregadas, envolvidas com a operação deste Serviço (este Site) (administração, vendas, marketing, administração legal do sistema) ou pessoas externas (como fornecedores terceirizados de serviços técnicos, correio, etc) nomeadas, quando necessário, como Processadores de Dados por parte do Proprietário. A lista atualizada destas partes pode ser solicitada ao Proprietário a qualquer momento.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Base jurídica para o processamento</strong><br />O Proprietário poderá processar os Dados Pessoais relacionados ao Utilizador se uma das hipóteses a seguir se aplicar:</p>\r\n<p>Utilizadores que tenham dado a sua aprovação para uma ou mais finalidades específicas; Observação: De acordo com algumas legislações o Proprietário poderá ter a permissão para processar os Dados Pessoais ATÉ QUE O Utilizador faça objeção a isto (“opt-out”), sem ter que se basear em permissão ou em quaisquer outras bases jurídicas a seguir. Isto, contudo, não se aplica sempre que o processamento de Dados Pessoais estiver sujeito à legislação europeia de proteção de dados;<br />– o fornecimento dos Dados for necessário para o cumprimento de um contrato com o Utilizador e/ou quaisquer obrigações pré-contratuais do mesmo;<br />– o processamento for necessário para o cumprimento de uma obrigação jurídica à qual o Proprietário estiver sujeito;<br />– o processamento estiver relacionado a uma tarefa que for executada no interesse público ou no exercício de uma autorização oficial na qual o Proprietário estiver investido;<br />– o processamento for necessário para a finalidade de interesses legítimos perseguidos pelo Proprietário ou por um terceiro;</p>\r\n<p>Em qualquer caso, o Proprietário colaborará de bom grado para esclarecer qual a base jurídica que se aplica ao processamento, e em especial se o fornecimento de Dados for um requisito obrigatório por força de lei ou contratual, ou uma exigência necessária para celebrar um contrato.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Per</strong><strong>íodo de Conservação</strong><br />Os Dados Pessoais serão processados e armazenados por 365 dias.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>As Finalidades do Processamento</strong><br />Os Dados relativos ao Utilizador são recolhidos para permitir que o Proprietário forneça os seus Serviços, bem como para os seguintes propósitos: Contatar o Utilizador; Proteção anti-spam; Acesso a contas de serviços de terceiros; Estatísticas; Salvar e gerir o backup; Comentário de conteúdo; Visualizar conteúdo de plataformas externas; Processamento de pagamentos; Interação com redes sociais e plataformas externas; Gestão de banco de dados de Utilizadores; Interação com plataformas de recolha de dados e outros terceiros; Gestão de endereços de e-mail e envio de mensagens; Registro e autenticação; Gestão de tags e Otimização e distribuição de tráfego.</p>\r\n<p>Os Utilizadores poderão obter informações adicionais detalhadas sobre tais finalidades do processamento e sobre os Dados Pessoais específicos utilizados para cada finalidade nas seções respetivas deste documento.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Permiss</strong><strong>ões do Facebook solicitadas por este Site</strong><br />Este Site pode pedir algumas permissões no Facebook que permitem realizar ações com a conta do Utilizador no Facebook e para recuperar as informações, incluindo dados pessoais. Este serviço permite que este Site se conecte com a conta do Utilizador na rede social Facebook, fornecido pelo Facebook Inc.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Para mais informações sobre as seguintes permissõ</strong><strong>es, consulte a documenta</strong><strong>çã</strong><strong>o de permiss</strong><strong>õ</strong><strong>es Facebook</strong> (https://developers.facebook.com/docs/facebook-login/permissions) e a política de privacidade do Facebook (https://www.facebook.com/about/privacy/).</p>\r\n<p>&nbsp;</p>\r\n<p><strong>As permissões solicitadas são as seguintes:</strong> Aniversário, Contato de e-mail, E-mail e Informações básicas.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Informa</strong><strong>ções detalhadas sobre o processamento de Dados Pessoais</strong><br />Os Dados Pessoais são recolhidos para os seguintes fins e utilizando os seguintes serviços:</p>\r\n<p>&nbsp;</p>\r\n<p>Acesso a contas de serviços de terceiros<br />Este tipo de serviço permite a este serviço (este Site) acessar os Dados da sua conta com um serviço terceiro e realizar ações com os mesmos.<br />Estes serviços não são ativados automaticamente, precisam de autorização explícita do Usuário.</p>\r\n<p>&nbsp;</p>\r\n<p>Acesso à conta Facebook (este Site)<br />Este serviço permite que este Site se conecte com a conta do Usuário na rede social Facebook, fornecido pelo Facebook, Inc.</p>\r\n<p>Pedido de Permissão: Aniversário; Contato de e-mail; E-mail.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.facebook.com/policy.php).<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>Comentário de conteúdo<br />O serviço de comentários de conteúdo permite aos Utilizadores criar e publicar comentários sobre o conteúdo deste serviço (este Site).<br />Dependendo das configurações escolhidas pelo Proprietário, os Utilizadores podem também deixar comentários anónimos. Se houver um endereço de e-mail entre os Dados Pessoais fornecidos pelo Utilizador, poderá ser usado para enviar notificações de comentários sobre o mesmo conteúdo. Os Utilizadores são responsáveis pelo conteúdo dos seus comentários.<br />Se um serviço de comentários de conteúdo prestado por terceiros estiver instalado, este ainda poderá recolher dados de tráfego da web para as páginas onde o serviço de comentário estiver instalado, mesmo quando os Utilizadores não utilizam o serviço de conteúdo de comentários.</p>\r\n<p>&nbsp;</p>\r\n<p>Sistema de Comentários gerido diretamente (este Site)<br />Este Site tem o seu próprio sistema de comentários de conteúdo interno.</p>\r\n<p>Dados Pessoais recolhidos: Cookie; E-mail; Nome; Nome de Utilizador; Apelido; Website.</p>\r\n<p>&nbsp;</p>\r\n<p>Contactar o Utilizador<br />Formulário de contacto (este Site)<br />Ao preencherem o formulário de contacto com os seus Dados, os Utilizadores autorizam este Site a utilizar esses detalhes para responder a pedidos de informações, cotação ou qualquer outro tipo de pedido como indicado pelo título do formulário.</p>\r\n<p>Dados Pessoais recolhidos: Nome, E-mail; Nome da empresa; Número de telefone.</p>\r\n<p>&nbsp;</p>\r\n<p>Lista de endereçamento ou boletim informativo (este Site)<br />Ao registar-se na lista de endereçamento ou no boletim informativo, o endereço de e-mail do Utilizador será adicionado à lista de contactos daqueles que podem receber mensagens de e-mail que contenham informações de natureza comercial ou promocional sobre este Site. O seu endereço de e-mail também poderá ser adicionado a esta lista, como resultado da sua inscrição neste serviço (este Site) ou após a realização de uma compra.</p>\r\n<p>Dados Pessoais recolhidos: E-mail; Nome; Apelido.</p>\r\n<p>&nbsp;</p>\r\n<p>Telefone de contato (este Site)<br />Os Utilizadores que forneceram o número de telefone poderão ser contactados para fins comerciais ou promocionais relacionadas com este Site, bem como para o cumprimento de pedidos de suporte.</p>\r\n<p>Dados Pessoais recolhidos: Número de telefone.</p>\r\n<p>&nbsp;</p>\r\n<p>Estatísticas<br />Os serviços presentes nesta seção habilitam o Proprietário a monitorar e analisar o tráfego da web e podem ser utilizados para rastrear o comportamento do Utilizador.</p>\r\n<p>&nbsp;</p>\r\n<p>Google Analytics (Google Inc.)<br />O Google Analytics é um serviço de análise da Internet fornecido pela Google, dependendo do local a partir do qual este Site for acedido, (“Google”). O Google utiliza os dados recolhidos para acompanhar e analisar o uso deste serviço (este Site) para preparar relatórios sobre atividades e compartilhá-los com outros serviços do Google.<br />O Google pode utilizar os dados recolhidos para contextualizar e personalizar os anúncios da sua própria rede de publicidade.</p>\r\n<p>Dados Pessoais recolhidos: Cookie; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.facebook.com/policy.php ) – Opt (https://policies.google.com/privacy?hl=pt) Out.<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>WordPress Stat (Automattic Inc.)<br />WordPress é um serviço de análise fornecido pela Automattic Inc.</p>\r\n<p>Dados Pessoais recolhidos: Cookie; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://automattic.com/privacy/).</p>\r\n<p>&nbsp;</p>\r\n<p>Gestão do banco de dados dos Utilizadores<br />Esses tipos de serviços permitem que o Proprietário crie perfis de Utilizador a partir de um endereço de e-mail, um nome pessoal, ou outras informações que o Utilizador forneceu a este Site, como também o rastreamento de atividades do Utilizador por meio de recursos analíticos. Estes Dados Pessoais podem também ser combinados com informações publicamente disponíveis sobre o Utilizador (como perfis de redes sociais) e utilizado para construir perfis privados que o Proprietário pode exibir e usar para melhorar o serviço (este Site).<br />Alguns desses serviços podem também ser habilitados para enviar mensagens programadas ao Utilizador tais como emails baseados em ações realizadas neste serviço (este Site).</p>\r\n<p>&nbsp;</p>\r\n<p>Gestão de endereços de e-mail e envio de mensagens<br />Esses tipos de serviços permitem a gestão da base de dados de contatos de e-mail, telefones ou outra informação de contacto para efeitos de comunicação com o Utilizador.<br />Estes serviços também podem ser utilizados para recolher dados referentes à data e o horário em que o Utilizador visualizou o e-mail; e também quando o Utilizador interagiu com o e-mail recebido, como por exemplo, quando o Utilizador selecionou os links incluídos no e-mail.</p>\r\n<p>&nbsp;</p>\r\n<p>Mailchimp (The Rocket Science Group, LLC.)<br />Mailchimp é a gestão de endereços de e-mail e envio de mensagem de serviço prestado por The Rocket Science Group LLC.</p>\r\n<p>Dados Pessoais recolhidos: e-mail.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://mailchimp.com/legal/privacy/).<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>Gestão de tags<br />Este tipo de serviço ajuda o Proprietário a gerir as tags ou scripts necessitados por este Site de forma centralizada. Em consequência disto os Dados do Utilizador fluem através destes serviços e há possibilidade de retenção destes Dados.</p>\r\n<p>&nbsp;</p>\r\n<p>Google Tag Manager (Google)<br />O Google Tag Manager é um serviço de gestão fornecido pela Google, dependendo do local a partir do qual este Site for acedido.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://policies.google.com/privacy?hl=pt).<br />Participante do Privacy Shield.</p>\r\n<p>Interação com plataformas de recolha de dados e outros terceiros<br />Esses tipos de serviços permitem que os Utilizadores interajam com plataformas de recolha de dados ou outros serviços diretamente a partir das páginas deste serviço (este Site) com o objetivo de salvar e reutilizar dados.</p>\r\n<p><br />Se um desses serviços estiver instalado, este poderá recolher Dados de Uso e de navegação nas páginas onde foram instalados, mesmo que os Utilizadores não utilizem o serviço ativamente.</p>\r\n<p>&nbsp;</p>\r\n<p>Interação com redes sociais e plataformas externas<br />Estes tipos de serviços permitem a interação com as redes sociais ou outras plataformas externas diretamente a partir das páginas deste serviço (este Site).<br />A interação e as informações obtidas por este Site estão sempre sujeitas às configurações de privacidade do Utilizador em cada rede social.<br />Este tipo de serviço pode ainda recolher dados de tráfego para as páginas onde o serviço estiver instalado, mesmo quando os Utilizadores não o utilizarem.<br />Recomenda-se sair dos respetivos serviços de forma a garantir que os dados processados neste serviço (este Site) não estejam a ser conectados de volta ao perfil do Utilizador.</p>\r\n<p>&nbsp;</p>\r\n<p>O botão de Gostar e os Widgets sociais do Facebook (Facebook, Inc.)<br />O botão de Gostar do Facebook e os Widgets sociais são serviços que permitem a interação com a rede social Facebook fornecido pela Facebook, Inc.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.facebook.com/privacy/explanation).<br />Participante do Privacy Shield.</p>\r\n<p>O botão +1 e Widgets sociais do Google+ (Google Inc.)<br />O botão +1 e Widgets sociais do Google+ são serviços que permitem a interação com a rede social Google+ fornecido pelo Google, dependendo do local a partir do qual este Site for acedido.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://policies.google.com/privacy?hl=pt-PT).<br />Participante do Privacy Shield.</p>\r\n<p>O botão e os widgets sociais do LinkedIn (LinkedIn Corporation)<br />O botão e os widgets sociais do LinkedIn são serviços que permitem a interação com a rede social LinkedIn fornecido pelo LinkedIn Corporation.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.linkedin.com/legal/privacy-policy).<br />Participante do Privacy Shield.</p>\r\n<p>O botão e os widgets sociais do YouTube (Google Inc.)<br />O botão e os widgets sociais do YouTube são serviços que permitem a interação com a rede social YouTube fornecido pela Google, dependendo do local a partir do qual este Site for acedido.</p>\r\n<p>Dados Pessoais recolhidos: Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://policies.google.com/privacy?hl=pt).<br />Participante do Privacy Shield.</p>\r\n<p>Otimização e distribuição de tráfego<br />Esses tipos de serviços permitem a este Site distribuir o conteúdo deles utilizando servidores localizados em países diferentes, de forma a otimizar o seu desempenho.<br />Alguns Dados Pessoais são processados e dependem das características e da forma como esses serviços são implementados. A sua função é a de filtrar as comunicações entre este Site e o navegador do Utilizador.<br />Considerando a distribuição generalizada deste sistema, é difícil determinar os locais, para os quais os conteúdos, que possam conter informações pessoais do Utilizador, foram transferidos.</p>\r\n<p>&nbsp;</p>\r\n<p>Google reCAPTCHA (Google Inc.)<br />Google reCAPTCHA é um serviço de proteção de SPAM fornecido pelo Google ou pela Google, dependendo do local a partir do qual este Site for acedido.<br />O uso do reCAPTCHA está sujeito à política de privacidade (https://policies.google.com/privacy?hl=pt-BR) e aos termos de utilização (https://policies.google.com/terms?hl=pt-BR) da Google.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://policies.google.com/privacy?hl=pt-PT).<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>Registro e autenticação<br />Ao registrar ou autenticar, os Utilizadores permitem a este serviço (este Site) identificá-los e dar-lhes o acesso a serviços dedicados. Dependendo do que estiver descrito abaixo, os serviços de registro e autenticação podem ser fornecidos por terceiros. Neste caso, este Site poderá aceder a alguns Dados armazenados por estes serviços de terceiros para fins de registro ou identificação.</p>\r\n<p>&nbsp;</p>\r\n<p>Facebook Authentication (Facebook, Inc.)<br />O Facebook Authentication é um serviço de registro e autenticação fornecido pelo Facebook, Inc. e está conectado à rede social Facebook.</p>\r\n<p>Dados Pessoais recolhidos: vários tipos de Dados como especificados na política de privacidade do serviço.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.facebook.com/help/405977429438260).<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>Salvar e gerir o backup<br />Esses tipos de serviços permitem que o Proprietário salve e gira os backups deste serviço (este Site) em servidores externos geridos pelo próprio prestador do serviço. Os backups podem incluir o código fonte e conteúdo, bem como os dados que o Utilizador fornece a este Site.</p>\r\n<p>Visualizar o conteúdo de plataformas externas<br />Esses tipos de serviços permitem que o Utilizador visualize e interage com o conteúdo presente em plataformas externas diretamente das páginas deste serviço (este Site). Se esse tipo de serviço estiver instalado poderá recolher os dados de tráfego da web para as páginas onde o mesmo estiver instalado, até quando os Utilizadores não os estão a utilizar.</p>\r\n<p>Os direitos dos Utilizadores<br />Os Utilizadores poderão exercer determinados direitos a respeito dos seus Dados processados pelo Proprietário.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Em especial, os Utilizadores têm direitos, tais como:</strong></p>\r\n<p>Retirar a sua aprovação a qualquer momento. Os Utilizadores têm o direito de retirar a sua aprovação nos casos em que tenham dado a sua aprovação anteriormente para o processamento dos seus Dados Pessoais.<br />Recusar o processamento dos seus Dados. Os Utilizadores têm o direito de recusar o processamento dos seus Dados se o processamento for executado sobre outra base jurídica que não a aprovação. São fornecidos detalhes adicionais na seção específica abaixo.<br />Aceder aos seus Dados. Os Utilizadores têm o direito de saber se os seus Dados estão a ser processados pelo Proprietário, obter revelações sobre determinados aspetos do processamento e conseguir uma cópia dos Dados que estão em processo.<br />Verificar e pedir correção. Os Utilizadores têm o direito de verificar a exatidão dos seus Dados e pedir eventuais atualizações ou correções.<br />Restringir o processamento dos seus Dados. Os Utilizadores têm o direito de, sob determinadas circunstâncias, restringir o processamento dos seus Dados para qualquer outra finalidade que não seja o armazenamento dos mesmos.<br />Apagar os Dados Pessoais ou retirá-los de outra maneira. Os Utilizadores têm o direito de, sob determinadas circunstâncias, obter a eliminação dos seus Dados do Proprietário.<br />Receber os seus Dados e ter os mesmos que foram transferidos para outro controlador. Os Utilizadores têm o direito de receber os seus Dados num formato estruturado, utilizado comumente e apto a ser lido por máquinas e, se for viável tecnicamente, fazer com que os mesmos sejam transmitidos para outro controlador sem nenhum problema. Esta determinação condiciona que os Dados sejam processados por meios automatizados e que o processamento esteja baseado na aprovação do Utilizador, num contrato do qual o Utilizador seja uma das partes ou por obrigações pré-contratuais do mesmo.<br />Registrar uma reclamação. Os Utilizadores têm o direito de apresentar uma reclamação perante a sua autoridade de proteção de dados competente.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Detalhes sobre o direito de recusar o processamento</strong><br />Nos casos em que os Dados Pessoais forem processados por um interesse público, no exercício de uma autorização oficial na qual o Proprietário estiver investido ou para finalidades dos interesses legítimos perseguidos pelo Proprietário, os Utilizadores poderão recusar o processamento através do fornecimento de um motivo relacionado com a sua situação em especial para justificar a recusa.</p>\r\n<p>Os Utilizadores devem saber que caso os seus Dados Pessoais sejam processados para finalidades de marketing, poderão recusar o processamento a qualquer momento sem fornecer nenhuma justificação. Os Utilizadores podem consultar as seções respetivas deste documento.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Como exercer estes direitos</strong><br />Quaisquer pedidos para exercer os direitos dos Utilizadores podem ser direcionados ao Proprietário através dos dados para contacto fornecidos neste documento. Estes pedidos podem ser exercidos sem nenhum custo e serão atendidos pelo Proprietário com a maior brevidade possível e em todos os casos em prazo inferior a um mês.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Informa</strong><strong>ções adicionais sobre a coleta e processamento de Dados</strong><br /><strong>Ação jurí</strong><strong>dica</strong><br />Os Dados Pessoais dos Utilizadores podem ser utilizados para fins jurídicos pelo Proprietário em questão ou nas etapas conducentes à possível ação jurídica decorrente de uma utilização indevida deste Serviço (este Site) ou dos Serviços relacionados. O Utilizador declara estar ciente de que o Proprietário poderá ser obrigado a revelar os Dados Pessoais mediante solicitação das autoridades governamentais.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Informa</strong><strong>ções adicionais sobre os Dados Pessoais do Utilizador</strong><br />Além das informações contidas nesta política de privacidade, este Site poderá fornecer ao Utilizador informações adicionais e contextuais sobre os serviços específicos ou a recolha do processamento de Dados Pessoais mediante solicitação.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Logs do sistema e manutenção</strong><br />Para fins de sistema e manutenção, este Site e quaisquer serviços de terceiros poderão recolher arquivos que guardam a interação com este Site (logs do sistema) ou utilizar outros Dados Pessoais (tais como endereço IP) para esta finalidade.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Mudanças nesta política de privacidade</strong><br />O Proprietário reserva o direito de fazer alterações nesta política de privacidade a qualquer momento, mediante comunicação aos seus Utilizadores nesta página e possivelmente dentro deste Serviço, este Site e/ou – na medida em que for viável tecnicamente e juridicamente – enviando um aviso aos Utilizadores através de quaisquer informações de contacto disponíveis para o Proprietário. É altamente recomendável que esta página seja consultada várias vezes em relação à última modificação descrita na parte inferior.</p>\r\n<p>Caso as mudanças afetem as atividades de processamento realizadas com base na aprovação do Utilizador, o Proprietário recolherá a nova aprovação do Utilizador, onde for exigida.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Defini</strong><strong>ções e referências jurídicas</strong><br /><strong>Dados Pessoais (ou Dados)</strong><br />Quaisquer informações que diretamente, indiretamente ou em relação com outras informações – incluindo um número de identificação pessoal – permitam a identificação ou identificabilidade de uma pessoa física.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Dados de Utilização</strong><br />As informações recolhidas automaticamente através deste este Site (ou serviços de terceiros contratados neste Serviço), que podem incluir: os endereços IP ou nomes de domínio dos computadores utilizados pelos Utilizadores que utilizam este Site, os endereços URI (Identificador Uniforme de Recurso), a data e hora do pedido, o método utilizado para submeter o pedido ao servidor, o tamanho do arquivo recebido em resposta, o código numérico que indica o status do servidor de resposta (resultado positivo, erro , etc.), o país de origem, as características do navegador e do sistema operacional utilizado pelo Utilizador, os vários detalhes de tempo por visita (por exemplo, o tempo gasto em cada página dentro do aplicativo) e os detalhes sobre o caminho seguido dentro da aplicação, com especial referência à sequência de páginas visitadas e outros parâmetros sobre o sistema operacional do dispositivo e/ou ambiente de TI do Utilizador.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Utilizador</strong><br />A pessoa que utiliza este Site que, a menos que especificado diferentemente, coincida com o Titular dos Dados.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Titular dos Dados</strong><br />A pessoa física a quem os Dados Pessoais se referem.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Processador de Dados (ou supervisor de Dados)</strong><br />A pessoa física ou jurídica, administração pública, agência ou outro órgão que processe os Dados Pessoais em nome do Controlador conforme descrito nesta política de privacidade.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Controlador de Dados (ou proprietá</strong><strong>rio)</strong><br />A pessoa física ou jurídica, administração pública, agência ou outro órgão que, isoladamente ou em conjunto com outros determinar as finalidades e os meios de processamento dos Dados Pessoais, incluindo medidas de segurança relativas ao funcionamento e à utilização deste Serviço (este Site). O Controlador de Dados, a menos que seja especificado de outra forma, é o Proprietário deste Serviço (este Site).</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Este Site (ou este Aplicativo)</strong><br />O meio pelo qual os Dados Pessoais do Utilizador são recolhidos e processados.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Serviço</strong><br />O serviço fornecido por este Site conforme descrito nos termos relativos (se disponíveis) e neste site/aplicativo.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>União Europeia (ou UE)</strong><br />A menos que especificado diferentemente, todas as referências feitas neste documento à União Europeia incluem todos os atuais estados membros da União Europeia e do Espaço Econômico Europeu.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Cookies</strong><br />Pequenas unidades de dados armazenados no dispositivo do Utilizador.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Informa</strong><strong>ção jurí</strong><strong>dica</strong><br />Esta declaração de privacidade foi preparada com base em determinações de múltiplas legislações, inclusive os Arts. 13/14 do Regulamento (EU) 2016/679 (GDPR – Regulamento Geral de Proteção de Dados).</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Última atualizaçã</strong><strong>o: </strong><strong>26</strong><strong> de </strong><strong>maio de 2022</strong></p>", "Política de privacidade", "", "inherit", "closed", "closed", "", "3-revision-v1", "", "", "2023-02-14 10:46:33", "2023-02-14 10:46:33", "", "3", "https://midtemplate.makeitdigital2.tk/?p=17", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("18", "1", "2023-02-14 14:49:01", "0000-00-00 00:00:00", "Thank you for reading this post, don\'t forget to subscribe!", "Display a message after the 1st paragraph of posts", "", "draft", "closed", "closed", "", "", "", "", "2023-02-14 14:49:01", "0000-00-00 00:00:00", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=wpcode&p=18", "0", "wpcode", "", "0");
INSERT INTO `wp_posts` VALUES("19", "1", "2023-02-14 14:49:01", "0000-00-00 00:00:00", "add_action(\'admin_init\', function () {\r\n    // Redirect any user trying to access comments page\r\n    global $pagenow;\r\n    \r\n    if ($pagenow === \'edit-comments.php\') {\r\n        wp_safe_redirect(admin_url());\r\n        exit;\r\n    }\r\n\r\n    // Remove comments metabox from dashboard\r\n    remove_meta_box(\'dashboard_recent_comments\', \'dashboard\', \'normal\');\r\n\r\n    // Disable support for comments and trackbacks in post types\r\n    foreach (get_post_types() as $post_type) {\r\n        if (post_type_supports($post_type, \'comments\')) {\r\n            remove_post_type_support($post_type, \'comments\');\r\n            remove_post_type_support($post_type, \'trackbacks\');\r\n        }\r\n    }\r\n});\r\n\r\n// Close comments on the front-end\r\nadd_filter(\'comments_open\', \'__return_false\', 20, 2);\r\nadd_filter(\'pings_open\', \'__return_false\', 20, 2);\r\n\r\n// Hide existing comments\r\nadd_filter(\'comments_array\', \'__return_empty_array\', 10, 2);\r\n\r\n// Remove comments page in menu\r\nadd_action(\'admin_menu\', function () {\r\n    remove_menu_page(\'edit-comments.php\');\r\n});\r\n\r\n// Remove comments links from admin bar\r\nadd_action(\'init\', function () {\r\n    if (is_admin_bar_showing()) {\r\n        remove_action(\'admin_bar_menu\', \'wp_admin_bar_comments_menu\', 60);\r\n    }\r\n});", "Completely Disable Comments", "", "draft", "closed", "closed", "", "", "", "", "2023-02-14 14:49:01", "0000-00-00 00:00:00", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=wpcode&p=19", "0", "wpcode", "", "0");
INSERT INTO `wp_posts` VALUES("20", "1", "2023-02-14 15:24:41", "2023-02-14 15:24:41", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22211%22%2C%22background-position%22%3A%22right%20250px%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%220.5rem%22%7D%7D\"][us_post_custom_field key=\"detalhe_evento\" hide_empty=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22700%22%2C%22margin-top%22%3A%221rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing providers=\"email,facebook,twitter,linkedin,whatsapp\" align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "publish", "closed", "closed", "", "blog-single", "", "", "2024-12-11 14:36:01", "2024-12-11 14:36:01", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=us_content_template&#038;p=20", "0", "us_content_template", "", "0");
INSERT INTO `wp_posts` VALUES("31", "1", "2024-11-21 19:09:54", "2024-11-21 19:09:54", "", "logo", "", "inherit", "", "closed", "", "logo", "", "", "2024-11-21 19:09:54", "2024-11-21 19:09:54", "", "12", "https://batazu.digitalpath.pt/wp-content/uploads/2023/02/logo.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("32", "1", "2024-11-21 19:10:45", "2024-11-21 19:10:45", "", "Contactos", "", "publish", "closed", "closed", "", "contactos", "", "", "2024-11-21 19:10:45", "2024-11-21 19:10:45", "", "0", "https://batazu.digitalpath.pt/?page_id=32", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("33", "1", "2024-11-21 19:10:45", "2024-11-21 19:10:45", "", "Contactos", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2024-11-21 19:10:45", "2024-11-21 19:10:45", "", "32", "https://batazu.digitalpath.pt/?p=33", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("34", "1", "2024-11-21 19:12:04", "2024-11-21 19:12:04", "", "logo-02", "", "inherit", "", "closed", "", "logo-02", "", "", "2024-11-21 19:12:04", "2024-11-21 19:12:04", "", "15", "https://batazu.digitalpath.pt/wp-content/uploads/2023/02/logo-02.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("35", "1", "2024-11-21 19:13:16", "2024-11-21 19:13:16", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23263b61%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"34\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522%2523%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522%2523%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"4/12\"][us_text text=\"Contactos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|map-marker-alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]fdsffgfdgd\r\nfgdfgdfgdffdgd[/vc_column_text][/us_hwrapper][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|phone\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"tel:00351000000000\">(+351) 000 000 000</a>\r\n<span style=\"font-size: 0.65rem !important; display: inline-block; color: #edf5fd !important;\">(Chamada para a rede fixa nacional)</span>[/vc_column_text][/us_hwrapper][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|envelope\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"mailto:geral@mail.pt\" target=\"_blank\" rel=\"noopener\">geral@mail.pt</a>[/vc_column_text][/us_hwrapper][/vc_column_inner][vc_column_inner width=\"5/12\"][us_text text=\"Receba a nossa newsletter\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]", "Footer PT", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2024-11-21 19:13:16", "2024-11-21 19:13:16", "", "15", "https://batazu.digitalpath.pt/?p=35", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("36", "1", "2024-11-21 19:28:37", "2024-11-21 19:28:37", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftbranco\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver tudo\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\" el_id=\"apoiar\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Benefícios\r\nfiscais[/vc_column_text][us_image image=\"87\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]A ajuda à nossa Associação confere-lhe benefícios fiscais.[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Consignação\r\ndo IRS[/vc_column_text][us_image image=\"88\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Na sua próxima declaração de IRS, lembre-se de nós! O nosso contribuinte é o  517771330[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22254%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Parcerias\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterazul\"][us_carousel post_type=\"parceria\" items_quantity=\"-1\" items_layout=\"53\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"5\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_offset=\"12px\" dots=\"1\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%7D\"][/vc_column][/vc_row]", "Homepage", "", "publish", "closed", "closed", "", "homepage", "", "", "2024-12-11 16:37:02", "2024-12-11 16:37:02", "", "0", "https://batazu.digitalpath.pt/?page_id=36", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("37", "1", "2024-11-21 19:28:37", "2024-11-21 19:28:37", "", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-11-21 19:28:37", "2024-11-21 19:28:37", "", "36", "https://batazu.digitalpath.pt/?p=37", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("38", "1", "2024-11-21 19:29:05", "2024-11-21 19:29:05", "a:35:{s:9:\"post_type\";s:13:\"slide-carross\";s:22:\"advanced_configuration\";b:1;s:13:\"import_source\";s:0:\"\";s:11:\"import_date\";s:0:\"\";s:6:\"labels\";a:33:{s:4:\"name\";s:6:\"Slides\";s:13:\"singular_name\";s:5:\"Slide\";s:9:\"menu_name\";s:6:\"Slides\";s:9:\"all_items\";s:15:\"Todos os Slides\";s:9:\"edit_item\";s:12:\"Editar Slide\";s:9:\"view_item\";s:9:\"Ver Slide\";s:10:\"view_items\";s:10:\"Ver Slides\";s:12:\"add_new_item\";s:20:\"Adicionar novo Slide\";s:7:\"add_new\";s:20:\"Adicionar novo Slide\";s:8:\"new_item\";s:10:\"Novo Slide\";s:17:\"parent_item_colon\";s:15:\"Slide superior:\";s:12:\"search_items\";s:15:\"Pesquisa Slides\";s:9:\"not_found\";s:24:\"Nenhum slides encontrado\";s:18:\"not_found_in_trash\";s:32:\"Nenhum slides encontrado no lixo\";s:8:\"archives\";s:16:\"Arquivo de Slide\";s:10:\"attributes\";s:18:\"Atributos de Slide\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:16:\"insert_into_item\";s:16:\"Inserir em slide\";s:21:\"uploaded_to_this_item\";s:26:\"Carregados para este slide\";s:17:\"filter_items_list\";s:23:\"Filtrar lista de slides\";s:14:\"filter_by_date\";s:23:\"Filtrar slides por data\";s:21:\"items_list_navigation\";s:30:\"Navegação da lista de Slides\";s:10:\"items_list\";s:15:\"Lista de Slides\";s:14:\"item_published\";s:16:\"Slide publicado.\";s:24:\"item_published_privately\";s:27:\"Slide publicado em privado.\";s:22:\"item_reverted_to_draft\";s:30:\"Slide revertido para rascunho.\";s:14:\"item_scheduled\";s:15:\"Slide agendado.\";s:12:\"item_updated\";s:18:\"Slide actualizado.\";s:9:\"item_link\";s:18:\"Ligação de Slide\";s:21:\"item_link_description\";s:28:\"Uma ligação para um slide.\";}s:11:\"description\";s:0:\"\";s:6:\"public\";b:1;s:12:\"hierarchical\";b:1;s:19:\"exclude_from_search\";b:0;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"admin_menu_parent\";s:0:\"\";s:17:\"show_in_admin_bar\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:9:\"rest_base\";s:0:\"\";s:14:\"rest_namespace\";s:5:\"wp/v2\";s:21:\"rest_controller_class\";s:24:\"WP_REST_Posts_Controller\";s:13:\"menu_position\";i:2;s:9:\"menu_icon\";a:2:{s:4:\"type\";s:9:\"dashicons\";s:5:\"value\";s:31:\"dashicons-image-flip-horizontal\";}s:19:\"rename_capabilities\";b:0;s:24:\"singular_capability_name\";s:4:\"post\";s:22:\"plural_capability_name\";s:5:\"posts\";s:8:\"supports\";a:4:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";i:3;s:13:\"custom-fields\";}s:10:\"taxonomies\";s:0:\"\";s:11:\"has_archive\";b:0;s:16:\"has_archive_slug\";s:0:\"\";s:7:\"rewrite\";a:4:{s:17:\"permalink_rewrite\";s:13:\"post_type_key\";s:10:\"with_front\";s:1:\"1\";s:5:\"feeds\";s:1:\"0\";s:5:\"pages\";s:1:\"1\";}s:9:\"query_var\";s:13:\"post_type_key\";s:14:\"query_var_name\";s:0:\"\";s:10:\"can_export\";b:1;s:16:\"delete_with_user\";b:0;s:20:\"register_meta_box_cb\";s:0:\"\";s:16:\"enter_title_here\";s:0:\"\";}", "Slides", "slides", "publish", "closed", "closed", "", "post_type_673f89ed47a7d", "", "", "2024-11-21 19:29:05", "2024-11-21 19:29:05", "", "0", "https://batazu.digitalpath.pt/?post_type=acf-post-type&#038;p=38", "0", "acf-post-type", "", "0");
INSERT INTO `wp_posts` VALUES("39", "1", "2024-11-21 19:29:27", "2024-11-21 19:29:27", "[vc_row][vc_column width=\"1/1\"][us_separator][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%223.8rem%22%2C%22line-height%22%3A%223.9rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\"]Juntos, podemos\r\ntransformar\r\nesperança em cura![/vc_column_text][us_separator size=\"small\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22padding-left%22%3A%2210%25%22%2C%22padding-right%22%3A%2210%25%22%7D%7D\"]O Projeto BataZu está a um passo de um marco histórico:\r\n<strong>trazer a primeira terapia CAR-T cell académica para Portugal.</strong>\r\nEste tratamento inovador, que usa o poder do sistema imunológico para combater a leucemia e outras doenças oncológicas, oferece uma nova chance de vida para crianças e jovens que enfrentam desafios inimagináveis.\r\nMas para isso, <strong>precisamos de todos!</strong>[/vc_column_text][us_separator size=\"small\"][us_hwrapper alignment=\"center\" valign=\"middle\" link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Conheça o Projeto BataZu\" link=\"%7B%22url%22%3A%22%2Fo-projeto-batazu%2F%22%7D\"][us_btn label=\"O início de tudo: a família BataZu\" link=\"%7B%22url%22%3A%22%2Fa-familia-batazu%2F%22%7D\" style=\"6\"][/us_hwrapper][/vc_column][/vc_row]", "Slide 1", "", "publish", "closed", "closed", "", "slide-1", "", "", "2024-12-11 12:27:34", "2024-12-11 12:27:34", "", "0", "https://batazu.digitalpath.pt/?post_type=slide-carross&#038;p=39", "0", "slide-carross", "", "0");
INSERT INTO `wp_posts` VALUES("40", "1", "2024-11-21 19:29:37", "2024-11-21 19:29:37", "", "DoorWin_img-1b", "", "inherit", "", "closed", "", "doorwin_img-1b", "", "", "2024-11-21 19:29:37", "2024-11-21 19:29:37", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/11/DoorWin_img-1b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("41", "1", "2024-11-21 19:30:44", "2024-11-21 19:30:44", "[vc_row width=\"full\"][vc_column width=\"1/1\"][us_carousel post_type=\"slide-carrossel\" items_quantity=\"4\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" autoplay=\"1\" autoplay_timeout=\"5s\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"12px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\"][vc_column width=\"1/1\"][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokeverde\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokegrey\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokeverdecenter\"][us_separator][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-11-21 19:30:44", "2024-11-21 19:30:44", "", "36", "https://batazu.digitalpath.pt/?p=41", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("42", "1", "2024-11-21 19:31:29", "2024-11-21 19:31:29", "<p>[vc_row width=\"full\"][vc_column width=\"1/1\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" autoplay=\"1\" autoplay_timeout=\"5s\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"12px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\"][vc_column width=\"1/1\"][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokeverde\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokegrey\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokeverdecenter\"][us_separator][/vc_column][/vc_row]</p>\r\n", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-11-21 19:31:29", "2024-11-21 19:31:29", "", "36", "https://batazu.digitalpath.pt/?p=42", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("43", "1", "2024-11-22 17:42:14", "2024-11-22 17:42:14", "", "woocommerce-placeholder", "", "inherit", "", "closed", "", "woocommerce-placeholder", "", "", "2024-11-22 17:42:14", "2024-11-22 17:42:14", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/11/woocommerce-placeholder.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("53", "1", "2024-11-22 17:45:12", "2024-11-22 17:45:12", "{\"data\":{\"image:1\":{\"img\":\"{{the_thumbnail}}\",\"image\":\"\",\"has_ratio\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"disable_lazy_loading\":0,\"meta\":0,\"meta_style\":\"simple\",\"align\":\"none\",\"style\":\"\",\"size\":\"medium\",\"img_transparent\":\"\",\"link\":\"%7B%22url%22%3A%22%7B%7Blink_parceiro%7D%7D%22%2C%22target%22%3A%22_blank%22%7D\",\"heading_1\":\"\",\"height_default\":\"35px\",\"height_laptops\":\"30px\",\"height_tablets\":\"25px\",\"height_mobiles\":\"20px\",\"heading_2\":\"\",\"height_sticky\":\"35px\",\"height_sticky_laptops\":\"30px\",\"height_sticky_tablets\":\"25px\",\"height_sticky_mobiles\":\"20px\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":\"\",\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"animate\":\"\",\"animate_delay\":\"\",\"link_new_tab\":\"\",\"onclick\":\"\",\"onclick_code\":\"\"}},\"default\":{\"options\":{\"fixed\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"overflow\":0,\"color_bg\":\"\",\"color_text\":\"\",\"ignore_us_tile_colors\":0,\"bg_img_source\":\"none\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_file_size\":\"large\",\"bg_img_size\":\"cover\",\"bg_img_position\":\"center center\",\"bg_img_repeat\":\"no-repeat\",\"bg_img_wrapper_end\":\"\",\"border_radius\":0,\"box_shadow\":0,\"box_shadow_hover\":0,\"el_class\":\"\"},\"layout\":{\"hidden\":[],\"middle_center\":[\"image:1\"]}}}", "Parceiros - Carrossel", "", "publish", "closed", "closed", "", "marcas-carrossel", "", "", "2024-12-11 15:48:52", "2024-12-11 15:48:52", "", "0", "https://batazu.digitalpath.pt/?post_type=us_grid_layout&#038;p=53", "0", "us_grid_layout", "", "0");
INSERT INTO `wp_posts` VALUES("62", "1", "2024-11-22 18:24:53", "2024-11-22 18:24:53", "", "Percentagem", "", "publish", "closed", "closed", "", "percentagem", "", "", "2024-11-22 18:24:53", "2024-11-22 18:24:53", "", "0", "https://batazu.digitalpath.pt/?post_type=awl-labels&#038;p=62", "0", "awl-labels", "", "0");
INSERT INTO `wp_posts` VALUES("70", "1", "2024-11-26 17:51:23", "2024-11-26 17:51:23", "<p>[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Voltar às Notícias\" link=\"%7B%22url%22%3A%22%2Fnoticias-e-casos-de-sucesso-doorwin%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outras notícias\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"338\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]</p>\r\n", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-11-26 17:51:23", "2024-11-26 17:51:23", "", "20", "https://batazu.digitalpath.pt/?p=70", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("71", "1", "2024-11-26 17:51:45", "2024-11-26 17:51:45", "{\"title\":\"Image first (category, date, excerpt)\",\"cols\":\"2\",\"data\":{\"post_title:1\":{\"tag\":\"h2\",\"show_count\":0,\"align\":\"none\",\"link\":\"%7B%22type%22%3A%22post%22%7D\",\"color_link\":1,\"shorten_length\":0,\"shorten_length_count\":\"30\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"font-size\":\"1rem\",\"font-weight\":\"600\",\"margin-bottom\":\"0.2rem\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"custom_link\":\"\",\"link_new_tab\":\"\"},\"hwrapper:1\":{\"inner_items_gap\":\"0rem\",\"wrap\":1,\"conditions\":[],\"css\":{\"default\":{\"color\":\"_content_faded\",\"font-size\":\"0.9rem\"}},\"link\":\"{\\\"url\\\":\\\"\\\"}\",\"alignment\":\"none\",\"valign\":\"top\",\"stack_on_mobiles\":0,\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"scale_hover\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\"},\"post_taxonomy:1\":{\"taxonomy_name\":\"category\",\"style\":\"simple\",\"btn_style\":\"badge\",\"separator\":\", \",\"link\":\"%7B%22type%22%3A%22archive%22%7D\",\"color_link\":1,\"icon\":\"\",\"text_before\":\"\",\"text_after\":\"\",\"show_color_swatch\":0,\"hide_color_swatch_label\":0,\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"color\":\"_footer_text\",\"font-size\":\"0.6rem\",\"font-weight\":\"700\",\"text-transform\":\"uppercase\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"custom_link\":\"\"}},\"default\":{\"layout\":{\"middle_center\":[\"hwrapper:1\",\"post_title:1\"],\"hwrapper:1\":[\"post_taxonomy:1\"],\"hidden\":[]},\"options\":{\"fixed\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"overflow\":0,\"color_bg\":\"\",\"color_text\":\"\",\"ignore_us_tile_colors\":0,\"bg_img_source\":\"none\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_file_size\":\"large\",\"bg_img_size\":\"cover\",\"bg_img_position\":\"center center\",\"bg_img_repeat\":\"no-repeat\",\"bg_img_wrapper_end\":\"\",\"border_radius\":0,\"box_shadow\":0,\"box_shadow_hover\":0,\"el_class\":\"\"}}}", "grid Blog Listagem", "", "publish", "closed", "closed", "", "grid-blog-listagem", "", "", "2024-12-11 14:29:17", "2024-12-11 14:29:17", "", "0", "https://batazu.digitalpath.pt/?post_type=us_grid_layout&#038;p=71", "0", "us_grid_layout", "", "0");
INSERT INTO `wp_posts` VALUES("72", "1", "2024-11-26 17:52:11", "2024-11-26 17:52:11", "<p>[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Voltar às Notícias\" link=\"%7B%22url%22%3A%22%2Fnoticias-e-casos-de-sucesso-doorwin%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outras notícias\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]</p>\r\n", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-11-26 17:52:11", "2024-11-26 17:52:11", "", "20", "https://batazu.digitalpath.pt/?p=72", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("74", "1", "2024-12-10 20:29:11", "2024-12-10 20:29:11", "", "MID_btz_parceiro-0", "", "inherit", "", "closed", "", "mid_btz_parceiro-0", "", "", "2024-12-10 20:29:11", "2024-12-10 20:29:11", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_parceiro-0.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("75", "1", "2024-12-10 20:29:12", "2024-12-10 20:29:12", "", "MID_btz_parceiro-1", "", "inherit", "", "closed", "", "mid_btz_parceiro-1", "", "", "2024-12-10 20:29:12", "2024-12-10 20:29:12", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_parceiro-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("76", "1", "2024-12-10 20:29:13", "2024-12-10 20:29:13", "", "MID_btz_favicon", "", "inherit", "", "closed", "", "mid_btz_favicon", "", "", "2024-12-10 20:29:13", "2024-12-10 20:29:13", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_favicon.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("77", "1", "2024-12-10 20:29:14", "2024-12-10 20:29:14", "", "MID_btz_img-1", "", "inherit", "", "closed", "", "mid_btz_img-1", "", "", "2024-12-10 20:29:14", "2024-12-10 20:29:14", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_img-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("78", "1", "2024-12-10 20:29:16", "2024-12-10 20:29:16", "", "MID_btz_img-2", "", "inherit", "", "closed", "", "mid_btz_img-2", "", "", "2024-12-10 20:29:16", "2024-12-10 20:29:16", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_img-2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("79", "1", "2024-12-10 20:29:17", "2024-12-10 20:29:17", "", "MID_btz_img-3", "", "inherit", "", "closed", "", "mid_btz_img-3", "", "", "2024-12-10 20:29:17", "2024-12-10 20:29:17", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_img-3.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("80", "1", "2024-12-10 20:29:18", "2024-12-10 20:29:18", "", "MID_btz_img-4", "", "inherit", "", "closed", "", "mid_btz_img-4", "", "", "2024-12-10 20:29:18", "2024-12-10 20:29:18", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_img-4.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("81", "1", "2024-12-10 20:29:24", "2024-12-10 20:29:24", "", "MID_btz_ico_-01", "", "inherit", "", "closed", "", "mid_btz_ico_-01", "", "", "2024-12-10 20:29:24", "2024-12-10 20:29:24", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_ico_-01.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("82", "1", "2024-12-10 20:29:25", "2024-12-10 20:29:25", "", "MID_btz_ico_-02", "", "inherit", "", "closed", "", "mid_btz_ico_-02", "", "", "2024-12-10 20:29:25", "2024-12-10 20:29:25", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_ico_-02.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("83", "1", "2024-12-10 20:29:26", "2024-12-10 20:29:26", "", "MID_btz_ico_-03", "", "inherit", "", "closed", "", "mid_btz_ico_-03", "", "", "2024-12-10 20:29:26", "2024-12-10 20:29:26", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_ico_-03.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("84", "1", "2024-12-10 20:29:27", "2024-12-10 20:29:27", "", "MID_btz_ico_-04", "", "inherit", "", "closed", "", "mid_btz_ico_-04", "", "", "2024-12-10 20:29:27", "2024-12-10 20:29:27", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_ico_-04.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("85", "1", "2024-12-10 20:29:28", "2024-12-10 20:29:28", "", "MID_btz_ico_-05", "", "inherit", "", "closed", "", "mid_btz_ico_-05", "", "", "2024-12-10 20:29:28", "2024-12-10 20:29:28", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_ico_-05.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("86", "1", "2024-12-10 20:29:29", "2024-12-10 20:29:29", "", "MID_btz_ico_-06", "", "inherit", "", "closed", "", "mid_btz_ico_-06", "", "", "2024-12-10 20:29:29", "2024-12-10 20:29:29", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_ico_-06.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("87", "1", "2024-12-10 20:29:29", "2024-12-10 20:29:29", "", "MID_btz_ico_-07", "", "inherit", "", "closed", "", "mid_btz_ico_-07", "", "", "2024-12-10 20:29:29", "2024-12-10 20:29:29", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_ico_-07.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("88", "1", "2024-12-10 20:29:30", "2024-12-10 20:29:30", "", "MID_btz_ico_-08", "", "inherit", "", "closed", "", "mid_btz_ico_-08", "", "", "2024-12-10 20:29:30", "2024-12-10 20:29:30", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_ico_-08.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("89", "1", "2024-12-10 20:29:31", "2024-12-10 20:29:31", "", "MID_btz_ico_-09", "", "inherit", "", "closed", "", "mid_btz_ico_-09", "", "", "2024-12-10 20:29:31", "2024-12-10 20:29:31", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_ico_-09.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("90", "1", "2024-12-10 20:29:32", "2024-12-10 20:29:32", "", "MID_btz_ico_-10", "", "inherit", "", "closed", "", "mid_btz_ico_-10", "", "", "2024-12-10 20:29:32", "2024-12-10 20:29:32", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_ico_-10.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("91", "1", "2024-12-10 20:29:33", "2024-12-10 20:29:33", "", "MID_btz_ico_-11", "", "inherit", "", "closed", "", "mid_btz_ico_-11", "", "", "2024-12-10 20:29:33", "2024-12-10 20:29:33", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_ico_-11.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("92", "1", "2024-12-10 20:29:33", "2024-12-10 20:29:33", "", "MID_btz_ico_-12", "", "inherit", "", "closed", "", "mid_btz_ico_-12", "", "", "2024-12-10 20:29:33", "2024-12-10 20:29:33", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_ico_-12.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("97", "1", "2024-12-11 11:04:38", "2024-12-11 11:04:38", "<p>[vc_row content_placement=\"middle\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/2\"][us_image image=\"295\" link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][vc_column width=\"1/2\"][vc_column_text]A Família BataZu enfrentou um grande desafio em 2021, quando o filho mais velho, Tomás, foi diagnosticado com leucemia mieloide aguda (LMA). Através da sua página no Instagram, conseguiram apoio e fundos para um tratamento inovador com células CAR-T, mas, infelizmente, Tomás não resistiu à doença. Em sua memória, a família criou a Associação BataZu para promover o tratamento de células CAR-T pediátricas e aumentar o conhecimento sobre a LMA em Portugal.[/vc_column_text][us_btn label=\"Saiba mais sobre o Tomás BataZu e o percurso LMA\" link=\"%7B%22url%22%3A%22%2Ftomas-batazu-e-o-percurso-lma%2F%22%7D\" style=\"2\" icon=\"fal|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row]</p>\r\n", "A família BataZu", "", "publish", "closed", "closed", "", "a-familia-batazu", "", "", "2024-12-11 16:40:58", "2024-12-11 16:40:58", "", "0", "https://batazu.digitalpath.pt/?page_id=97", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("98", "1", "2024-12-11 11:04:38", "2024-12-11 11:04:38", "", "A família BataZu", "", "inherit", "closed", "closed", "", "97-revision-v1", "", "", "2024-12-11 11:04:38", "2024-12-11 11:04:38", "", "97", "https://batazu.digitalpath.pt/?p=98", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("99", "1", "2024-12-11 11:04:49", "2024-12-11 11:04:49", "", "Tomás BataZu e o percurso LMA", "", "publish", "closed", "closed", "", "tomas-batazu-e-o-percurso-lma", "", "", "2024-12-11 11:04:49", "2024-12-11 11:04:49", "", "0", "https://batazu.digitalpath.pt/?page_id=99", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("100", "1", "2024-12-11 11:04:49", "2024-12-11 11:04:49", "", "Tomás BataZu e o percurso LMA", "", "inherit", "closed", "closed", "", "99-revision-v1", "", "", "2024-12-11 11:04:49", "2024-12-11 11:04:49", "", "99", "https://batazu.digitalpath.pt/?p=100", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("101", "1", "2024-12-11 11:04:59", "2024-12-11 11:04:59", "[vc_row css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/2\"][vc_column_text]<strong>Juntos, podemos transformar esperança em cura!</strong>\r\n\r\nO Projeto BataZu está a um passo de um marco histórico: trazer a primeira terapia CAR-T cell académica para Portugal. Este tratamento inovador, que usa o poder do sistema imunológico para combater a leucemia e outras doenças oncológicas, oferece uma nova chance de vida para crianças e jovens que enfrentam desafios inimagináveis. Mas para isso, precisamos de todos! Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][us_btn label=\"Apoie-nos, faça a sua doação\" link=\"%7B%22url%22%3A%22%2F%23apoiar%22%7D\" style=\"2\" icon=\"fal|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22margin-top%22%3A%222rem%22%7D%7D\"][us_btn label=\"Saiba mais sobre o Tomás BataZu e o percurso LMA\" link=\"%7B%22url%22%3A%22%2Ftomas-batazu-e-o-percurso-lma%2F%22%7D\" style=\"2\" icon=\"fal|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"1/2\"][us_image image=\"306\" has_ratio=\"1\" link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][/vc_row]", "O Projeto BataZu", "", "publish", "closed", "closed", "", "o-projeto-batazu", "", "", "2024-12-11 16:52:38", "2024-12-11 16:52:38", "", "0", "https://batazu.digitalpath.pt/?page_id=101", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("102", "1", "2024-12-11 11:04:59", "2024-12-11 11:04:59", "", "O Projeto BataZu", "", "inherit", "closed", "closed", "", "101-revision-v1", "", "", "2024-12-11 11:04:59", "2024-12-11 11:04:59", "", "101", "https://batazu.digitalpath.pt/?p=102", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("103", "1", "2024-12-11 11:05:11", "2024-12-11 11:05:11", "[vc_row content_placement=\"middle\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/2\"][us_image image=\"300\" has_ratio=\"1\" ratio=\"3x4\" link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][vc_column width=\"1/2\"][vc_column_text]A missão BataZu é promover o tratamento de células CAR-T pediátricas em Portugal, aumentar o conhecimento sobre a leucemia mieloide aguda (LMA) e outras leucemias, além de apoiar famílias que enfrentam doenças oncológicas pediátricas. Através de iniciativas de sensibilização, pesquisa e apoio, o projeto busca proporcionar esperança e melhores opções de tratamento para crianças e jovens diagnosticados com essas doenças.\r\nObjetivos:\r\n<ul>\r\n 	<li>Fomentar o desenvolvimento e implementação de terapias CAR-T cells académicas em Portugal, colaborando com instituições de pesquisa e universidades para criar protocolos locais.</li>\r\n 	<li>Reduzir a dependência de tratamentos no exterior, promovendo a acessibilidade e sustentabilidade das terapias CAR-T personalizadas no país.</li>\r\n 	<li>Contribuir para o fortalecimento da pesquisa sobre leucemias e terapias inovadoras, garantindo que mais crianças tenham acesso a tratamentos revolucionários e eficazes.</li>\r\n 	<li>Aumentar a conscientização pública sobre leucemias, especialmente a LMA, através de campanhas educativas, palestras e eventos de sensibilização.</li>\r\n</ul>\r\n[/vc_column_text][us_btn label=\"O Projeto BataZu\" link=\"%7B%22url%22%3A%22%2Fo-projeto-batazu%2F%22%7D\" style=\"2\" icon=\"fal|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22margin-top%22%3A%222rem%22%7D%7D\"][us_btn label=\"Saiba mais sobre o Tomás BataZu e o percurso LMA\" link=\"%7B%22url%22%3A%22%2Ftomas-batazu-e-o-percurso-lma%2F%22%7D\" style=\"2\" icon=\"fal|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%7D%7D\"][/vc_column][/vc_row]", "Missão", "", "publish", "closed", "closed", "", "missao", "", "", "2024-12-11 16:47:57", "2024-12-11 16:47:57", "", "0", "https://batazu.digitalpath.pt/?page_id=103", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("104", "1", "2024-12-11 11:05:11", "2024-12-11 11:05:11", "", "Missão", "", "inherit", "closed", "closed", "", "103-revision-v1", "", "", "2024-12-11 11:05:11", "2024-12-11 11:05:11", "", "103", "https://batazu.digitalpath.pt/?p=104", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("105", "1", "2024-12-11 11:05:20", "2024-12-11 11:05:20", "", "A Associação BataZu", "", "publish", "closed", "closed", "", "a-associacao-batazu", "", "", "2024-12-11 11:05:20", "2024-12-11 11:05:20", "", "0", "https://batazu.digitalpath.pt/?page_id=105", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("106", "1", "2024-12-11 11:05:20", "2024-12-11 11:05:20", "", "A Associação BataZu", "", "inherit", "closed", "closed", "", "105-revision-v1", "", "", "2024-12-11 11:05:20", "2024-12-11 11:05:20", "", "105", "https://batazu.digitalpath.pt/?p=106", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("107", "1", "2024-12-11 11:05:28", "2024-12-11 11:05:28", "[vc_row css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/2\"][vc_column_text]As células CAR-T (receptores quiméricos de antigénio) representam uma nova e promissora abordagem no tratamento de cancro, especialmente nas leucemias e linfomas. As células T do sistema imunitário do paciente são extraídas e modificadas em laboratório para expressar receptores específicos (CAR) que reconhecem e atacam células cancerígenas. Após essa modificação, as células T são reintroduzidas no corpo, onde podem identificar e destruir as células tumorais de forma mais eficaz.\r\n\r\nA terapia CAR-T é conhecida por seus resultados impressionantes em casos de cancro resistentes a tratamentos convencionais, como a quimioterapia. No entanto, por ser uma técnica nova, está disponível apenas em alguns países e ainda envolve custos elevados.\r\n\r\n<strong>Características principais:</strong>\r\n<ol>\r\n 	<li>Personalização: As células T do próprio paciente são usadas e modificadas, tornando o tratamento personalizado e menos suscetível a rejeições.</li>\r\n 	<li>Precisão: As células CAR-T atacam diretamente as células cancerosas, reduzindo o impacto sobre células saudáveis.</li>\r\n 	<li>Eficácia: Em muitos casos, o tratamento CAR-T tem resultado em remissões prolongadas, especialmente em pacientes que esgotaram outras opções.</li>\r\n</ol>\r\n[/vc_column_text][/vc_column][vc_column width=\"1/2\"][us_image image=\"314\" has_ratio=\"1\" ratio=\"3x4\" link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][/vc_row]", "Car T Cells", "", "publish", "closed", "closed", "", "car-t-cells", "", "", "2024-12-11 16:56:20", "2024-12-11 16:56:20", "", "0", "https://batazu.digitalpath.pt/?page_id=107", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("108", "1", "2024-12-11 11:05:28", "2024-12-11 11:05:28", "", "Car T Cells", "", "inherit", "closed", "closed", "", "107-revision-v1", "", "", "2024-12-11 11:05:28", "2024-12-11 11:05:28", "", "107", "https://batazu.digitalpath.pt/?p=108", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("109", "1", "2024-12-11 11:05:40", "2024-12-11 11:05:40", "[vc_row css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/5\"][us_grid_filter filter_items=\"%5B%7B%22source%22%3A%22tax%7Ccategory%22%2C%22ui_type%22%3A%22checkbox%22%2C%22min_value%22%3A%220%22%2C%22step_size%22%3A%221%22%2C%22show_all_value%22%3A%221%22%2C%22show_amount%22%3A%220%22%2C%22label%22%3A%22Filtrar%20por%3A%22%2C%22show_color_swatch%22%3A%220%22%2C%22hide_color_swatch_label%22%3A%220%22%7D%5D\" layout=\"ver\" values_max_height=\"80vh\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column][vc_column width=\"4/5\"][us_grid items_quantity=\"12\" pagination=\"regular\" items_layout=\"13\" columns=\"3\" items_gap=\"1rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][/vc_row]", "Projetos, Eventos e Notícias", "", "publish", "closed", "closed", "", "projetos-eventos-e-noticias", "", "", "2024-12-11 14:49:14", "2024-12-11 14:49:14", "", "0", "https://batazu.digitalpath.pt/?page_id=109", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("110", "1", "2024-12-11 11:05:40", "2024-12-11 11:05:40", "", "Projetos, Eventos e Notícias", "", "inherit", "closed", "closed", "", "109-revision-v1", "", "", "2024-12-11 11:05:40", "2024-12-11 11:05:40", "", "109", "https://batazu.digitalpath.pt/?p=110", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("111", "1", "2024-12-11 11:06:31", "2024-12-11 11:06:31", "[vc_row css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_column][vc_column width=\"2/3\"][us_btn label=\"Sobre a Leucemia Mieloide Aguda\" link=\"%7B%22url%22%3A%22%2Fsobre-a-leucemia-mieloide-aguda%2F%22%7D\" style=\"2\" align=\"left\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\"][us_btn label=\"Nutrição\" link=\"%7B%22url%22%3A%22%2Fnutricao%2F%22%7D\" style=\"2\" align=\"left\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\"][us_btn label=\"Acompanhamento psicológico e como lidar com a LMA\" link=\"%7B%22url%22%3A%22%2Facompanhamento-psicologico-e-como-lidar-com-a-lma%2F%22%7D\" style=\"2\" align=\"left\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\"][us_btn label=\"Glossário\" link=\"%7B%22url%22%3A%22%2Fglossario%2F%22%7D\" style=\"2\" align=\"left\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\"][us_btn label=\"Formas de apoiar doentes com cancro do sangue\" link=\"%7B%22url%22%3A%22%2Fformas-de-apoiar-doentes-com-cancro-do-sangue%2F%22%7D\" style=\"2\" align=\"left\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\"][us_btn label=\"Estudos Clínicos\" link=\"%7B%22url%22%3A%22%2Festudos-clinicos%2F%22%7D\" style=\"2\" align=\"left\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\"][us_btn label=\"Contactos Úteis\" link=\"%7B%22url%22%3A%22%2Fcontactos-uteis%2F%22%7D\" style=\"2\" align=\"left\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\"][us_btn label=\"Leituras recomendadas\" link=\"%7B%22url%22%3A%22%2Fleituras-recomendadas%2F%22%7D\" style=\"2\" align=\"left\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%7D%7D\"][/vc_column][/vc_row]", "Recursos para doentes LMA", "", "publish", "closed", "closed", "", "recursos-para-doentes-lma", "", "", "2024-12-11 16:36:38", "2024-12-11 16:36:38", "", "0", "https://batazu.digitalpath.pt/?page_id=111", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("112", "1", "2024-12-11 11:06:31", "2024-12-11 11:06:31", "", "Recursos para doentes LMA", "", "inherit", "closed", "closed", "", "111-revision-v1", "", "", "2024-12-11 11:06:31", "2024-12-11 11:06:31", "", "111", "https://batazu.digitalpath.pt/?p=112", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("113", "1", "2024-12-11 11:06:50", "2024-12-11 11:06:50", "", "Sobre a Leucemia Mieloide Aguda", "", "publish", "closed", "closed", "", "sobre-a-leucemia-mieloide-aguda", "", "", "2024-12-11 11:06:50", "2024-12-11 11:06:50", "", "0", "https://batazu.digitalpath.pt/?page_id=113", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("114", "1", "2024-12-11 11:06:50", "2024-12-11 11:06:50", "", "Sobre a Leucemia Mieloide Aguda", "", "inherit", "closed", "closed", "", "113-revision-v1", "", "", "2024-12-11 11:06:50", "2024-12-11 11:06:50", "", "113", "https://batazu.digitalpath.pt/?p=114", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("115", "1", "2024-12-11 11:06:57", "2024-12-11 11:06:57", "", "Nutrição", "", "publish", "closed", "closed", "", "nutricao", "", "", "2024-12-11 11:06:57", "2024-12-11 11:06:57", "", "0", "https://batazu.digitalpath.pt/?page_id=115", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("116", "1", "2024-12-11 11:06:57", "2024-12-11 11:06:57", "", "Nutrição", "", "inherit", "closed", "closed", "", "115-revision-v1", "", "", "2024-12-11 11:06:57", "2024-12-11 11:06:57", "", "115", "https://batazu.digitalpath.pt/?p=116", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("117", "1", "2024-12-11 11:07:05", "2024-12-11 11:07:05", "", "Acompanhamento psicológico e como lidar com a LMA", "", "publish", "closed", "closed", "", "acompanhamento-psicologico-e-como-lidar-com-a-lma", "", "", "2024-12-11 11:07:05", "2024-12-11 11:07:05", "", "0", "https://batazu.digitalpath.pt/?page_id=117", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("118", "1", "2024-12-11 11:07:05", "2024-12-11 11:07:05", "", "Acompanhamento psicológico e como lidar com a LMA", "", "inherit", "closed", "closed", "", "117-revision-v1", "", "", "2024-12-11 11:07:05", "2024-12-11 11:07:05", "", "117", "https://batazu.digitalpath.pt/?p=118", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("119", "1", "2024-12-11 11:07:18", "2024-12-11 11:07:18", "[vc_row css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/6\"][/vc_column][vc_column width=\"4/6\"][vc_tta_accordion toggle=\"1\" el_class=\"glossario\"][vc_tta_section title=\"Cart-T Cells\" tab_link=\"%7B%22url%22%3A%22%22%7D\" el_id=\"cartcells\"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title=\"Outro exemplo de nome\" tab_link=\"%7B%22url%22%3A%22%22%7D\"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][vc_tta_section title=\"Ainda outro exemplo de nome\" tab_link=\"%7B%22url%22%3A%22%22%7D\" el_id=\"outro\"][vc_column_text]I am text block. Click edit button to change this text. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.[/vc_column_text][/vc_tta_section][/vc_tta_accordion][/vc_column][vc_column width=\"1/6\"][/vc_column][/vc_row]", "Glossário", "", "publish", "closed", "closed", "", "glossario", "", "", "2024-12-16 17:54:55", "2024-12-16 17:54:55", "", "0", "https://batazu.digitalpath.pt/?page_id=119", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("120", "1", "2024-12-11 11:07:18", "2024-12-11 11:07:18", "", "Glossário", "", "inherit", "closed", "closed", "", "119-revision-v1", "", "", "2024-12-11 11:07:18", "2024-12-11 11:07:18", "", "119", "https://batazu.digitalpath.pt/?p=120", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("121", "1", "2024-12-11 11:07:43", "2024-12-11 11:07:43", "", "Formas de apoiar doentes com cancro do sangue", "", "publish", "closed", "closed", "", "formas-de-apoiar-doentes-com-cancro-do-sangue", "", "", "2024-12-11 11:07:43", "2024-12-11 11:07:43", "", "0", "https://batazu.digitalpath.pt/?page_id=121", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("122", "1", "2024-12-11 11:07:43", "2024-12-11 11:07:43", "", "Formas de apoiar doentes com cancro do sangue", "", "inherit", "closed", "closed", "", "121-revision-v1", "", "", "2024-12-11 11:07:43", "2024-12-11 11:07:43", "", "121", "https://batazu.digitalpath.pt/?p=122", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("123", "1", "2024-12-11 11:07:52", "2024-12-11 11:07:52", "", "Estudos Clínicos", "", "publish", "closed", "closed", "", "estudos-clinicos", "", "", "2024-12-11 11:07:52", "2024-12-11 11:07:52", "", "0", "https://batazu.digitalpath.pt/?page_id=123", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("124", "1", "2024-12-11 11:07:52", "2024-12-11 11:07:52", "", "Estudos Clínicos", "", "inherit", "closed", "closed", "", "123-revision-v1", "", "", "2024-12-11 11:07:52", "2024-12-11 11:07:52", "", "123", "https://batazu.digitalpath.pt/?p=124", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("125", "1", "2024-12-11 11:08:00", "2024-12-11 11:08:00", "", "Contactos Úteis", "", "publish", "closed", "closed", "", "contactos-uteis", "", "", "2024-12-11 11:08:00", "2024-12-11 11:08:00", "", "0", "https://batazu.digitalpath.pt/?page_id=125", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("126", "1", "2024-12-11 11:08:00", "2024-12-11 11:08:00", "", "Contactos Úteis", "", "inherit", "closed", "closed", "", "125-revision-v1", "", "", "2024-12-11 11:08:00", "2024-12-11 11:08:00", "", "125", "https://batazu.digitalpath.pt/?p=126", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("127", "1", "2024-12-11 11:08:07", "2024-12-11 11:08:07", "", "Leituras recomendadas", "", "publish", "closed", "closed", "", "leituras-recomendadas", "", "", "2024-12-11 11:08:07", "2024-12-11 11:08:07", "", "0", "https://batazu.digitalpath.pt/?page_id=127", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("128", "1", "2024-12-11 11:08:07", "2024-12-11 11:08:07", "", "Leituras recomendadas", "", "inherit", "closed", "closed", "", "127-revision-v1", "", "", "2024-12-11 11:08:07", "2024-12-11 11:08:07", "", "127", "https://batazu.digitalpath.pt/?p=128", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("131", "1", "2024-12-16 17:49:54", "2024-12-11 11:08:28", " ", "", "", "publish", "closed", "closed", "", "131", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=131", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("132", "1", "2024-12-16 17:49:54", "2024-12-11 11:08:28", " ", "", "", "publish", "closed", "closed", "", "132", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=132", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("133", "1", "2024-12-16 17:49:54", "2024-12-11 11:08:28", " ", "", "", "publish", "closed", "closed", "", "133", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=133", "12", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("134", "1", "2024-12-16 17:49:54", "2024-12-11 11:08:28", " ", "", "", "publish", "closed", "closed", "", "134", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=134", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("136", "1", "2024-12-16 17:49:54", "2024-12-11 11:08:28", " ", "", "", "publish", "closed", "closed", "", "136", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=136", "16", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("138", "1", "2024-12-16 17:49:54", "2024-12-11 11:08:28", " ", "", "", "publish", "closed", "closed", "", "138", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=138", "14", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("139", "1", "2024-12-16 17:49:54", "2024-12-11 11:08:28", " ", "", "", "publish", "closed", "closed", "", "139", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=139", "13", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("140", "1", "2024-12-16 17:49:54", "2024-12-11 11:08:28", " ", "", "", "publish", "closed", "closed", "", "140", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=140", "17", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("141", "1", "2024-12-16 17:49:54", "2024-12-11 11:08:28", " ", "", "", "publish", "closed", "closed", "", "141", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=141", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("143", "1", "2024-12-16 17:49:54", "2024-12-11 11:08:28", " ", "", "", "publish", "closed", "closed", "", "143", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=143", "11", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("144", "1", "2024-12-16 17:49:54", "2024-12-11 11:08:28", " ", "", "", "publish", "closed", "closed", "", "144", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=144", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("145", "1", "2024-12-16 17:49:54", "2024-12-11 11:08:28", " ", "", "", "publish", "closed", "closed", "", "145", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=145", "8", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("147", "1", "2024-12-16 17:49:54", "2024-12-11 11:08:28", " ", "", "", "publish", "closed", "closed", "", "147", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=147", "10", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("148", "1", "2024-12-16 17:49:54", "2024-12-11 11:08:28", " ", "", "", "publish", "closed", "closed", "", "148", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=148", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("149", "1", "2024-12-16 17:49:54", "2024-12-11 11:12:07", "", "Sobre nós", "", "publish", "closed", "closed", "", "sobre-nos", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=149", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("151", "1", "2024-12-11 11:13:10", "2024-12-11 11:13:10", "a:35:{s:9:\"post_type\";s:7:\"recurso\";s:22:\"advanced_configuration\";b:1;s:13:\"import_source\";s:0:\"\";s:11:\"import_date\";s:0:\"\";s:6:\"labels\";a:33:{s:4:\"name\";s:8:\"Recursos\";s:13:\"singular_name\";s:7:\"Recurso\";s:9:\"menu_name\";s:8:\"Recursos\";s:9:\"all_items\";s:17:\"Todos os Recursos\";s:9:\"edit_item\";s:14:\"Editar Recurso\";s:9:\"view_item\";s:11:\"Ver Recurso\";s:10:\"view_items\";s:12:\"Ver Recursos\";s:12:\"add_new_item\";s:22:\"Adicionar novo Recurso\";s:7:\"add_new\";s:22:\"Adicionar novo Recurso\";s:8:\"new_item\";s:12:\"Novo Recurso\";s:17:\"parent_item_colon\";s:17:\"Recurso superior:\";s:12:\"search_items\";s:17:\"Pesquisa Recursos\";s:9:\"not_found\";s:26:\"Nenhum recursos encontrado\";s:18:\"not_found_in_trash\";s:34:\"Nenhum recursos encontrado no lixo\";s:8:\"archives\";s:18:\"Arquivo de Recurso\";s:10:\"attributes\";s:20:\"Atributos de Recurso\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:16:\"insert_into_item\";s:18:\"Inserir em recurso\";s:21:\"uploaded_to_this_item\";s:28:\"Carregados para este recurso\";s:17:\"filter_items_list\";s:25:\"Filtrar lista de recursos\";s:14:\"filter_by_date\";s:25:\"Filtrar recursos por data\";s:21:\"items_list_navigation\";s:32:\"Navegação da lista de Recursos\";s:10:\"items_list\";s:17:\"Lista de Recursos\";s:14:\"item_published\";s:18:\"Recurso publicado.\";s:24:\"item_published_privately\";s:29:\"Recurso publicado em privado.\";s:22:\"item_reverted_to_draft\";s:32:\"Recurso revertido para rascunho.\";s:14:\"item_scheduled\";s:17:\"Recurso agendado.\";s:12:\"item_updated\";s:20:\"Recurso actualizado.\";s:9:\"item_link\";s:20:\"Ligação de Recurso\";s:21:\"item_link_description\";s:30:\"Uma ligação para um recurso.\";}s:11:\"description\";s:0:\"\";s:6:\"public\";b:1;s:12:\"hierarchical\";b:1;s:19:\"exclude_from_search\";b:0;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"admin_menu_parent\";s:0:\"\";s:17:\"show_in_admin_bar\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:9:\"rest_base\";s:0:\"\";s:14:\"rest_namespace\";s:5:\"wp/v2\";s:21:\"rest_controller_class\";s:24:\"WP_REST_Posts_Controller\";s:13:\"menu_position\";i:2;s:9:\"menu_icon\";a:2:{s:4:\"type\";s:9:\"dashicons\";s:5:\"value\";s:23:\"dashicons-admin-network\";}s:19:\"rename_capabilities\";b:0;s:24:\"singular_capability_name\";s:4:\"post\";s:22:\"plural_capability_name\";s:5:\"posts\";s:8:\"supports\";a:4:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";i:3;s:13:\"custom-fields\";}s:10:\"taxonomies\";s:0:\"\";s:11:\"has_archive\";b:0;s:16:\"has_archive_slug\";s:0:\"\";s:7:\"rewrite\";a:4:{s:17:\"permalink_rewrite\";s:13:\"post_type_key\";s:10:\"with_front\";s:1:\"1\";s:5:\"feeds\";s:1:\"0\";s:5:\"pages\";s:1:\"1\";}s:9:\"query_var\";s:13:\"post_type_key\";s:14:\"query_var_name\";s:0:\"\";s:10:\"can_export\";b:1;s:16:\"delete_with_user\";b:0;s:20:\"register_meta_box_cb\";s:0:\"\";s:16:\"enter_title_here\";s:0:\"\";}", "Recursos", "recursos", "publish", "closed", "closed", "", "post_type_675973b0222fa", "", "", "2024-12-11 11:13:10", "2024-12-11 11:13:10", "", "0", "https://batazu.digitalpath.pt/?post_type=acf-post-type&#038;p=151", "0", "acf-post-type", "", "0");
INSERT INTO `wp_posts` VALUES("152", "1", "2024-12-11 17:23:23", "2024-12-11 11:15:35", "", "Sobre nós", "", "publish", "closed", "closed", "", "sobre-nos-2", "", "", "2024-12-11 17:23:23", "2024-12-11 17:23:23", "", "0", "https://batazu.digitalpath.pt/?p=152", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("153", "1", "2024-12-11 17:23:23", "2024-12-11 11:15:35", " ", "", "", "publish", "closed", "closed", "", "153", "", "", "2024-12-11 17:23:23", "2024-12-11 17:23:23", "", "0", "https://batazu.digitalpath.pt/?p=153", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("154", "1", "2024-12-11 17:23:23", "2024-12-11 11:15:35", " ", "", "", "publish", "closed", "closed", "", "154", "", "", "2024-12-11 17:23:23", "2024-12-11 17:23:23", "", "0", "https://batazu.digitalpath.pt/?p=154", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("155", "1", "2024-12-11 17:23:23", "2024-12-11 11:15:35", " ", "", "", "publish", "closed", "closed", "", "155", "", "", "2024-12-11 17:23:23", "2024-12-11 17:23:23", "", "0", "https://batazu.digitalpath.pt/?p=155", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("156", "1", "2024-12-11 17:23:23", "2024-12-11 11:15:35", " ", "", "", "publish", "closed", "closed", "", "156", "", "", "2024-12-11 17:23:23", "2024-12-11 17:23:23", "", "0", "https://batazu.digitalpath.pt/?p=156", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("157", "1", "2024-12-11 17:23:23", "2024-12-11 11:15:35", " ", "", "", "publish", "closed", "closed", "", "157", "", "", "2024-12-11 17:23:23", "2024-12-11 17:23:23", "", "0", "https://batazu.digitalpath.pt/?p=157", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("158", "1", "2024-12-11 17:23:23", "2024-12-11 11:15:35", " ", "", "", "publish", "closed", "closed", "", "158", "", "", "2024-12-11 17:23:23", "2024-12-11 17:23:23", "", "0", "https://batazu.digitalpath.pt/?p=158", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("159", "1", "2024-12-11 11:25:46", "2024-12-11 11:24:45", " ", "", "", "publish", "closed", "closed", "", "159", "", "", "2024-12-11 11:25:46", "2024-12-11 11:25:46", "", "0", "https://batazu.digitalpath.pt/?p=159", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("160", "1", "2024-12-11 11:25:46", "2024-12-11 11:24:45", " ", "", "", "publish", "closed", "closed", "", "160", "", "", "2024-12-11 11:25:46", "2024-12-11 11:25:46", "", "0", "https://batazu.digitalpath.pt/?p=160", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("161", "1", "2024-12-11 11:25:46", "2024-12-11 11:25:46", " ", "", "", "publish", "closed", "closed", "", "161", "", "", "2024-12-11 11:25:46", "2024-12-11 11:25:46", "", "0", "https://batazu.digitalpath.pt/?p=161", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("162", "1", "2024-12-16 17:49:54", "2024-12-11 11:26:21", " ", "", "", "publish", "closed", "closed", "", "162", "", "", "2024-12-16 17:49:54", "2024-12-16 17:49:54", "", "0", "https://batazu.digitalpath.pt/?p=162", "9", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("163", "1", "2024-12-11 11:27:07", "2024-12-11 11:27:07", "a:29:{s:8:\"taxonomy\";s:16:\"categoria-pagina\";s:11:\"object_type\";a:1:{i:0;s:4:\"page\";}s:22:\"advanced_configuration\";i:0;s:13:\"import_source\";s:0:\"\";s:11:\"import_date\";s:0:\"\";s:6:\"labels\";a:25:{s:4:\"name\";s:22:\"Categorias de Páginas\";s:13:\"singular_name\";s:20:\"Categoria de Página\";s:9:\"menu_name\";s:22:\"Categorias de Páginas\";s:9:\"all_items\";s:31:\"Todos os Categorias de Páginas\";s:9:\"edit_item\";s:27:\"Editar Categoria de Página\";s:9:\"view_item\";s:24:\"Ver Categoria de Página\";s:11:\"update_item\";s:31:\"Actualizar Categoria de Página\";s:12:\"add_new_item\";s:35:\"Adicionar novo Categoria de Página\";s:13:\"new_item_name\";s:33:\"Nome do novo Categoria de Página\";s:11:\"parent_item\";s:29:\"Categoria de Página superior\";s:17:\"parent_item_colon\";s:30:\"Categoria de Página superior:\";s:12:\"search_items\";s:31:\"Pesquisa Categorias de Páginas\";s:9:\"most_used\";s:0:\"\";s:9:\"not_found\";s:40:\"Nenhum categorias de páginas encontrado\";s:8:\"no_terms\";s:29:\"Nenhum categorias de páginas\";s:22:\"name_field_description\";s:0:\"\";s:22:\"slug_field_description\";s:0:\"\";s:24:\"parent_field_description\";s:0:\"\";s:22:\"desc_field_description\";s:0:\"\";s:14:\"filter_by_item\";s:32:\"Filtrar por categoria de página\";s:21:\"items_list_navigation\";s:46:\"Navegação da lista de Categorias de Páginas\";s:10:\"items_list\";s:31:\"Lista de Categorias de Páginas\";s:13:\"back_to_items\";s:34:\"← Ir para categorias de páginas\";s:9:\"item_link\";s:33:\"Ligação de Categoria de Página\";s:21:\"item_link_description\";s:42:\"Uma ligação para um categoria de página\";}s:11:\"description\";s:0:\"\";s:12:\"capabilities\";a:4:{s:12:\"manage_terms\";s:17:\"manage_categories\";s:10:\"edit_terms\";s:17:\"manage_categories\";s:12:\"delete_terms\";s:17:\"manage_categories\";s:12:\"assign_terms\";s:10:\"edit_posts\";}s:6:\"public\";i:1;s:18:\"publicly_queryable\";i:1;s:12:\"hierarchical\";i:1;s:7:\"show_ui\";i:1;s:12:\"show_in_menu\";i:1;s:17:\"show_in_nav_menus\";i:1;s:12:\"show_in_rest\";i:1;s:9:\"rest_base\";s:0:\"\";s:14:\"rest_namespace\";s:5:\"wp/v2\";s:21:\"rest_controller_class\";s:24:\"WP_REST_Terms_Controller\";s:13:\"show_tagcloud\";i:1;s:18:\"show_in_quick_edit\";i:1;s:17:\"show_admin_column\";i:0;s:7:\"rewrite\";a:3:{s:17:\"permalink_rewrite\";s:12:\"taxonomy_key\";s:10:\"with_front\";s:1:\"1\";s:20:\"rewrite_hierarchical\";s:1:\"0\";}s:9:\"query_var\";s:13:\"post_type_key\";s:14:\"query_var_name\";s:0:\"\";s:12:\"default_term\";a:1:{s:20:\"default_term_enabled\";s:1:\"0\";}s:4:\"sort\";i:0;s:8:\"meta_box\";s:7:\"default\";s:11:\"meta_box_cb\";s:0:\"\";s:20:\"meta_box_sanitize_cb\";s:0:\"\";}", "Categorias de Páginas", "categorias-de-paginas", "publish", "closed", "closed", "", "taxonomy_675976f69ea40", "", "", "2024-12-11 11:27:07", "2024-12-11 11:27:07", "", "0", "https://batazu.digitalpath.pt/?post_type=acf-taxonomy&#038;p=163", "0", "acf-taxonomy", "", "0");
INSERT INTO `wp_posts` VALUES("164", "1", "2024-12-11 11:27:50", "2024-12-11 11:27:50", "a:35:{s:9:\"post_type\";s:8:\"parceria\";s:22:\"advanced_configuration\";b:1;s:13:\"import_source\";s:0:\"\";s:11:\"import_date\";s:0:\"\";s:6:\"labels\";a:33:{s:4:\"name\";s:9:\"Parcerias\";s:13:\"singular_name\";s:8:\"Parceria\";s:9:\"menu_name\";s:9:\"Parcerias\";s:9:\"all_items\";s:18:\"Todos os Parcerias\";s:9:\"edit_item\";s:15:\"Editar Parceria\";s:9:\"view_item\";s:12:\"Ver Parceria\";s:10:\"view_items\";s:13:\"Ver Parcerias\";s:12:\"add_new_item\";s:23:\"Adicionar novo Parceria\";s:7:\"add_new\";s:23:\"Adicionar novo Parceria\";s:8:\"new_item\";s:13:\"Novo Parceria\";s:17:\"parent_item_colon\";s:18:\"Parceria superior:\";s:12:\"search_items\";s:18:\"Pesquisa Parcerias\";s:9:\"not_found\";s:27:\"Nenhum parcerias encontrado\";s:18:\"not_found_in_trash\";s:35:\"Nenhum parcerias encontrado no lixo\";s:8:\"archives\";s:19:\"Arquivo de Parceria\";s:10:\"attributes\";s:21:\"Atributos de Parceria\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:16:\"insert_into_item\";s:19:\"Inserir em parceria\";s:21:\"uploaded_to_this_item\";s:29:\"Carregados para este parceria\";s:17:\"filter_items_list\";s:26:\"Filtrar lista de parcerias\";s:14:\"filter_by_date\";s:26:\"Filtrar parcerias por data\";s:21:\"items_list_navigation\";s:33:\"Navegação da lista de Parcerias\";s:10:\"items_list\";s:18:\"Lista de Parcerias\";s:14:\"item_published\";s:19:\"Parceria publicado.\";s:24:\"item_published_privately\";s:30:\"Parceria publicado em privado.\";s:22:\"item_reverted_to_draft\";s:33:\"Parceria revertido para rascunho.\";s:14:\"item_scheduled\";s:18:\"Parceria agendado.\";s:12:\"item_updated\";s:21:\"Parceria actualizado.\";s:9:\"item_link\";s:21:\"Ligação de Parceria\";s:21:\"item_link_description\";s:31:\"Uma ligação para um parceria.\";}s:11:\"description\";s:0:\"\";s:6:\"public\";b:1;s:12:\"hierarchical\";b:1;s:19:\"exclude_from_search\";b:0;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"admin_menu_parent\";s:0:\"\";s:17:\"show_in_admin_bar\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:9:\"rest_base\";s:0:\"\";s:14:\"rest_namespace\";s:5:\"wp/v2\";s:21:\"rest_controller_class\";s:24:\"WP_REST_Posts_Controller\";s:13:\"menu_position\";i:2;s:9:\"menu_icon\";a:2:{s:4:\"type\";s:9:\"dashicons\";s:5:\"value\";s:21:\"dashicons-admin-links\";}s:19:\"rename_capabilities\";b:0;s:24:\"singular_capability_name\";s:4:\"post\";s:22:\"plural_capability_name\";s:5:\"posts\";s:8:\"supports\";a:4:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";i:3;s:13:\"custom-fields\";}s:10:\"taxonomies\";s:0:\"\";s:11:\"has_archive\";b:0;s:16:\"has_archive_slug\";s:0:\"\";s:7:\"rewrite\";a:4:{s:17:\"permalink_rewrite\";s:13:\"post_type_key\";s:10:\"with_front\";s:1:\"1\";s:5:\"feeds\";s:1:\"0\";s:5:\"pages\";s:1:\"1\";}s:9:\"query_var\";s:13:\"post_type_key\";s:14:\"query_var_name\";s:0:\"\";s:10:\"can_export\";b:1;s:16:\"delete_with_user\";b:0;s:20:\"register_meta_box_cb\";s:0:\"\";s:16:\"enter_title_here\";s:0:\"\";}", "Parcerias", "parcerias", "publish", "closed", "closed", "", "post_type_6759771b486b0", "", "", "2024-12-11 11:27:50", "2024-12-11 11:27:50", "", "0", "https://batazu.digitalpath.pt/?post_type=acf-post-type&#038;p=164", "0", "acf-post-type", "", "0");
INSERT INTO `wp_posts` VALUES("165", "1", "2024-12-11 11:30:31", "2024-12-11 11:30:31", "a:8:{s:8:\"location\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"param\";s:9:\"post_type\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:8:\"parceria\";}}}s:8:\"position\";s:15:\"acf_after_title\";s:5:\"style\";s:7:\"default\";s:15:\"label_placement\";s:3:\"top\";s:21:\"instruction_placement\";s:5:\"label\";s:14:\"hide_on_screen\";a:7:{i:0;s:11:\"the_content\";i:1;s:7:\"excerpt\";i:2;s:10:\"discussion\";i:3;s:8:\"comments\";i:4;s:6:\"format\";i:5;s:15:\"page_attributes\";i:6;s:15:\"send-trackbacks\";}s:11:\"description\";s:0:\"\";s:12:\"show_in_rest\";i:0;}", "Detalhes Parceiros", "detalhes-parceiros", "publish", "closed", "closed", "", "group_675977a1db5f4", "", "", "2024-12-11 11:30:31", "2024-12-11 11:30:31", "", "0", "https://batazu.digitalpath.pt/?post_type=acf-field-group&#038;p=165", "0", "acf-field-group", "", "0");
INSERT INTO `wp_posts` VALUES("166", "1", "2024-12-11 11:30:31", "2024-12-11 11:30:31", "a:12:{s:10:\"aria-label\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";s:17:\"allow_in_bindings\";i:0;s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";}", "Link externo parceiro", "link_parceiro", "publish", "closed", "closed", "", "field_675977a23d303", "", "", "2024-12-11 11:30:31", "2024-12-11 11:30:31", "", "165", "https://batazu.digitalpath.pt/?post_type=acf-field&p=166", "0", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("167", "1", "2024-12-11 15:51:14", "2024-12-11 15:51:14", "", "APCL", "", "publish", "closed", "closed", "", "apcl", "", "", "2024-12-11 15:51:43", "2024-12-11 15:51:43", "", "0", "https://batazu.digitalpath.pt/?post_type=parceria&#038;p=167", "0", "parceria", "", "0");
INSERT INTO `wp_posts` VALUES("168", "1", "2024-12-11 11:32:25", "2024-12-11 11:32:25", "<p>[vc_row width=\"full\"][vc_column width=\"1/1\"][/vc_column][/vc_row][vc_row height=\"huge\"][vc_column width=\"1/1\"][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftamarelo\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftazul\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlecenteramarelo\"][us_separator][/vc_column][/vc_row]</p>\r\n", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 11:32:25", "2024-12-11 11:32:25", "", "36", "https://batazu.digitalpath.pt/?p=168", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("169", "1", "2024-12-11 11:39:34", "2024-12-11 11:39:34", "<p>[vc_row][vc_column width=\"1/1\"][us_separator][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%223.8rem%22%2C%22line-height%22%3A%223.9rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\"]Juntos, podemos<br />\ntransformar<br />\nesperança em cura![/vc_column_text][us_separator size=\"small\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22padding-left%22%3A%2210%25%22%2C%22padding-right%22%3A%2210%25%22%7D%7D\"]O Projeto BataZu está a um passo de um marco histórico:<strong>trazer a primeira terapia CAR-T cell académica para Portugal.</strong><br />\nEste tratamento inovador, que usa o poder do sistema imunológico para combater a leucemia e outras doenças oncológicas, oferece uma nova chance de vida para crianças e jovens que enfrentam desafios inimagináveis. Mas para isso, precisamos de todos![/vc_column_text][us_separator size=\"small\"][us_hwrapper alignment=\"center\" valign=\"middle\" link=\"%7B%22url%22%3A%22%22%7D\"][us_btn][/us_hwrapper][/vc_column][/vc_row]</p>\n", "Slide 1", "", "inherit", "closed", "closed", "", "39-autosave-v1", "", "", "2024-12-11 11:39:34", "2024-12-11 11:39:34", "", "39", "https://batazu.digitalpath.pt/?p=169", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("170", "1", "2024-12-11 15:40:15", "2024-12-11 15:40:15", "<p>[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,<br />\neventos<br />\ne notícias<br />\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.<br />\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma<br />\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Benefícios<br />\nfiscais[/vc_column_text][us_image image=\"87\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]A ajuda à nossa Associação confere-lhe benefícios fiscais.[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Consignação<br />\ndo IRS[/vc_column_text][us_image image=\"88\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Na sua próxima declaração de IRS, lembre-se de nós! O nosso contribuinte é o  517771330[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column width=\"1/1\"][/vc_column][/vc_row]</p>\n", "Homepage", "", "inherit", "closed", "closed", "", "36-autosave-v1", "", "", "2024-12-11 15:40:15", "2024-12-11 15:40:15", "", "36", "https://batazu.digitalpath.pt/?p=170", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("171", "1", "2024-12-11 11:45:01", "2024-12-11 11:45:01", "[vc_row width=\"full\"][vc_column width=\"1/1\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\"][vc_column width=\"1/1\"][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftamarelo\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftazul\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlecenteramarelo\"][us_separator][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 11:45:01", "2024-12-11 11:45:01", "", "36", "https://batazu.digitalpath.pt/?p=171", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("172", "1", "2024-12-11 12:00:34", "2024-12-11 12:00:34", "[vc_row width=\"full\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2280%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22240px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\"][vc_column width=\"1/1\"][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftamarelo\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftazul\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlecenteramarelo\"][us_separator][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 12:00:34", "2024-12-11 12:00:34", "", "36", "https://batazu.digitalpath.pt/?p=172", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("173", "1", "2024-12-11 12:02:05", "2024-12-11 12:02:05", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"80\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22240px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\"][vc_column width=\"1/1\"][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftamarelo\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftazul\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlecenteramarelo\"][us_separator][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 12:02:05", "2024-12-11 12:02:05", "", "36", "https://batazu.digitalpath.pt/?p=173", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("174", "1", "2024-12-11 12:07:59", "2024-12-11 12:07:59", "", "MID_btz_img-1b", "", "inherit", "", "closed", "", "mid_btz_img-1b", "", "", "2024-12-11 12:07:59", "2024-12-11 12:07:59", "", "36", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_img-1b.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("175", "1", "2024-12-11 12:08:27", "2024-12-11 12:08:27", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"174\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22240px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\"][vc_column width=\"1/1\"][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftamarelo\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftazul\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlecenteramarelo\"][us_separator][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 12:08:27", "2024-12-11 12:08:27", "", "36", "https://batazu.digitalpath.pt/?p=175", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("176", "1", "2024-12-11 12:11:03", "2024-12-11 12:11:03", "", "MID_btz_img-1c", "", "inherit", "", "closed", "", "mid_btz_img-1c", "", "", "2024-12-11 12:11:03", "2024-12-11 12:11:03", "", "36", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_img-1c.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("177", "1", "2024-12-11 12:11:11", "2024-12-11 12:11:11", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22240px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\"][vc_column width=\"1/1\"][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftamarelo\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftazul\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlecenteramarelo\"][us_separator][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 12:11:11", "2024-12-11 12:11:11", "", "36", "https://batazu.digitalpath.pt/?p=177", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("178", "1", "2024-12-11 12:16:39", "2024-12-11 12:16:39", "", "sombra_2_39", "", "inherit", "", "closed", "", "sombra_2_39", "", "", "2024-12-11 12:16:39", "2024-12-11 12:16:39", "", "0", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/sombra_2_39.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("179", "1", "2024-12-11 12:26:54", "2024-12-11 12:26:54", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\"][vc_column width=\"1/1\"][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftamarelo\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftazul\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlecenteramarelo\"][us_separator][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 12:26:54", "2024-12-11 12:26:54", "", "36", "https://batazu.digitalpath.pt/?p=179", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("180", "1", "2024-12-11 13:43:37", "2024-12-11 13:43:37", "{\"data\":{\"post_image:1\":{\"has_ratio\":1,\"ratio\":\"4x3\",\"conditions\":[],\"css\":{\"default\":{\"margin-bottom\":\"0.7rem\",\"overflow\":\"hidden\"}},\"hover\":1,\"scale_hover\":\"1.03\",\"placeholder\":0,\"media_preview\":0,\"gallery_images_amount\":\"10\",\"circle\":0,\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"stretch\":1,\"disable_lazy_loading\":0,\"thumbnail_size\":\"large\",\"link\":\"{\\\"type\\\":\\\"post\\\"}\",\"conditions_operator\":\"always\",\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\"},\"post_taxonomy:1\":{\"taxonomy_name\":\"category\",\"style\":\"simple\",\"btn_style\":\"badge\",\"separator\":\", \",\"link\":\"%7B%22type%22%3A%22archive%22%7D\",\"color_link\":1,\"icon\":\"\",\"text_before\":\"\",\"text_after\":\"\",\"show_color_swatch\":0,\"hide_color_swatch_label\":0,\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"color\":\"_content_primary\",\"font-size\":\"0.6rem\",\"line-height\":\"0.9rem\",\"letter-spacing\":\"0.08em\",\"text-transform\":\"uppercase\",\"margin-top\":\"25px\",\"margin-bottom\":\"0.3rem\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"custom_link\":\"\"},\"post_title:1\":{\"tag\":\"h2\",\"show_count\":0,\"align\":\"none\",\"link\":\"%7B%22type%22%3A%22post%22%7D\",\"color_link\":1,\"shorten_length\":0,\"shorten_length_count\":\"30\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"color\":\"_header_middle_bg\",\"font-size\":\"1.2rem\",\"line-height\":\"1.6rem\",\"font-weight\":\"600\",\"margin-top\":\"1px\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"custom_link\":\"\",\"link_new_tab\":\"\"},\"vwrapper:1\":{\"inner_items_gap\":\"0.2rem\",\"conditions\":[],\"alignment\":\"none\",\"valign\":\"top\",\"link\":\"{\\\"url\\\":\\\"\\\"}\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"css\":\"\",\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"scale_hover\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\"}},\"default\":{\"options\":{\"fixed\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"overflow\":1,\"color_bg\":\"\",\"color_text\":\"\",\"ignore_us_tile_colors\":0,\"bg_img_source\":\"none\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_file_size\":\"large\",\"bg_img_size\":\"cover\",\"bg_img_position\":\"center center\",\"bg_img_repeat\":\"no-repeat\",\"bg_img_wrapper_end\":\"\",\"border_radius\":0,\"box_shadow\":0,\"box_shadow_hover\":0,\"el_class\":\"\"},\"layout\":{\"hidden\":[],\"middle_center\":[\"post_image:1\",\"post_taxonomy:1\",\"vwrapper:1\"],\"vwrapper:1\":[\"post_title:1\"]}}}", "Grid Blog Home XL com data", "", "publish", "closed", "closed", "", "grid-blog-home-xl-com-data", "", "", "2024-12-11 15:14:06", "2024-12-11 15:14:06", "", "0", "https://batazu.digitalpath.pt/?post_type=us_grid_layout&#038;p=180", "0", "us_grid_layout", "", "0");
INSERT INTO `wp_posts` VALUES("181", "1", "2024-12-11 13:44:10", "2024-12-11 13:44:10", "{\"data\":{\"post_image:1\":{\"has_ratio\":1,\"ratio\":\"4x3\",\"conditions\":[],\"css\":{\"default\":{\"width\":\"37%\",\"overflow\":\"hidden\"}},\"hover\":1,\"scale_hover\":\"1.03\",\"placeholder\":0,\"media_preview\":0,\"gallery_images_amount\":\"10\",\"circle\":0,\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"stretch\":1,\"disable_lazy_loading\":0,\"thumbnail_size\":\"large\",\"link\":\"{\\\"type\\\":\\\"post\\\"}\",\"conditions_operator\":\"always\",\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\"},\"post_taxonomy:1\":{\"taxonomy_name\":\"category\",\"style\":\"simple\",\"btn_style\":\"badge\",\"separator\":\", \",\"link\":\"%7B%22type%22%3A%22archive%22%7D\",\"color_link\":1,\"icon\":\"\",\"text_before\":\"\",\"text_after\":\"\",\"show_color_swatch\":0,\"hide_color_swatch_label\":0,\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"color\":\"_content_primary\",\"font-size\":\"0.6rem\",\"line-height\":\"0.9rem\",\"letter-spacing\":\"0.08em\",\"text-transform\":\"uppercase\",\"margin-bottom\":\"0.3rem\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"custom_link\":\"\"},\"post_title:1\":{\"tag\":\"h2\",\"show_count\":0,\"align\":\"none\",\"link\":\"%7B%22type%22%3A%22post%22%7D\",\"color_link\":1,\"shorten_length\":0,\"shorten_length_count\":\"30\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"color\":\"_header_middle_bg\",\"font-size\":\"0.95rem\",\"line-height\":\"1.1rem\",\"font-weight\":\"600\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"custom_link\":\"\",\"link_new_tab\":\"\"},\"hwrapper:1\":{\"alignment\":\"none\",\"valign\":\"top\",\"inner_items_gap\":\"1rem\",\"wrap\":0,\"stack_on_mobiles\":0,\"link\":\"%7B%22url%22%3A%22%22%7D\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":\"\",\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\"},\"vwrapper:1\":{\"inner_items_gap\":\"0rem\",\"conditions\":[],\"css\":{\"default\":{\"padding-top\":\"0.7rem\"}},\"alignment\":\"none\",\"valign\":\"top\",\"link\":\"{\\\"url\\\":\\\"\\\"}\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"scale_hover\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\"}},\"default\":{\"options\":{\"fixed\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"overflow\":1,\"color_bg\":\"\",\"color_text\":\"\",\"ignore_us_tile_colors\":0,\"bg_img_source\":\"none\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_file_size\":\"large\",\"bg_img_size\":\"cover\",\"bg_img_position\":\"center center\",\"bg_img_repeat\":\"no-repeat\",\"bg_img_wrapper_end\":\"\",\"border_radius\":0,\"box_shadow\":0,\"box_shadow_hover\":0,\"el_class\":\"\"},\"layout\":{\"hidden\":[],\"middle_center\":[\"hwrapper:1\"],\"hwrapper:1\":[\"post_image:1\",\"vwrapper:1\"],\"vwrapper:1\":[\"post_taxonomy:1\",\"post_title:1\"]}}}", "Grid Blog Home S", "", "publish", "closed", "closed", "", "grid-blog-home-s", "", "", "2024-12-11 15:19:43", "2024-12-11 15:19:43", "", "0", "https://batazu.digitalpath.pt/?post_type=us_grid_layout&#038;p=181", "0", "us_grid_layout", "", "0");
INSERT INTO `wp_posts` VALUES("182", "1", "2024-12-11 13:50:38", "2024-12-11 13:50:38", "O OncoSummit, organizado pela AIM Cancer Center e pela European School of Lifestyle Oncology, realizou-se na Faculdade de Medicina de Lisboa e contou com 40 palestras, 50 oradores e 12 workshops. O evento abordou tratamentos oncológicos e temas como inovação em terapias, nutrição, suplementação, exercício, saúde mental e cuidados de suporte.\r\n\r\nA Associação BataZu partilhou a sua experiência com o tema \"Quando os meus colegas médicos não sabem o que fazer ao cancro do meu filho\", relatando como procuraram soluções inovadoras e cuidados de suporte para melhorar a qualidade de vida do filho Tomás, mesmo quando os médicos não tinham mais tratamentos a oferecer.\r\n\r\n<a href=\"https://www.instagram.com/p/C6yx4Jdskxx/?img_index=1\" target=\"_blank\" rel=\"noopener\">Veja aqui o post de Instagram</a>", "Onco Summit  I Congresso de Oncologia e estilo de Vida", "", "publish", "closed", "open", "", "onco-summit-i-congresso-de-oncologia-e-estilo-de-vida", "", "", "2024-12-11 13:57:51", "2024-12-11 13:57:51", "", "0", "https://batazu.digitalpath.pt/?p=182", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("183", "1", "2024-12-11 13:50:11", "2024-12-11 13:50:11", "a:8:{s:8:\"location\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"param\";s:9:\"post_type\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:4:\"post\";}}}s:8:\"position\";s:15:\"acf_after_title\";s:5:\"style\";s:7:\"default\";s:15:\"label_placement\";s:3:\"top\";s:21:\"instruction_placement\";s:5:\"label\";s:14:\"hide_on_screen\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"show_in_rest\";i:0;}", "Detalhes de artigos", "detalhes-de-artigos", "publish", "closed", "closed", "", "group_675998691f591", "", "", "2024-12-11 13:50:33", "2024-12-11 13:50:33", "", "0", "https://batazu.digitalpath.pt/?post_type=acf-field-group&#038;p=183", "0", "acf-field-group", "", "0");
INSERT INTO `wp_posts` VALUES("184", "1", "2024-12-11 13:50:11", "2024-12-11 13:50:11", "a:12:{s:10:\"aria-label\";s:0:\"\";s:4:\"type\";s:4:\"text\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"default_value\";s:0:\"\";s:9:\"maxlength\";s:0:\"\";s:17:\"allow_in_bindings\";i:0;s:11:\"placeholder\";s:0:\"\";s:7:\"prepend\";s:0:\"\";s:6:\"append\";s:0:\"\";}", "Detalhes do evento/acontecimento", "detalhe_evento", "publish", "closed", "closed", "", "field_67599869e4bbe", "", "", "2024-12-11 13:50:33", "2024-12-11 13:50:33", "", "183", "https://batazu.digitalpath.pt/?post_type=acf-field&#038;p=184", "0", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("185", "1", "2024-12-11 13:50:38", "2024-12-11 13:50:38", "Lisboa, 10, 11 e 12 de Maio de 2024", "Onco Summit  I Congresso de Oncologia e estilo de Vida", "", "inherit", "closed", "closed", "", "182-revision-v1", "", "", "2024-12-11 13:50:38", "2024-12-11 13:50:38", "", "182", "https://batazu.digitalpath.pt/?p=185", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("186", "1", "2024-12-11 13:52:41", "2024-12-11 13:52:41", "O OncoSummit, organizado pela AIM Cancer Center e pela European School of Lifestyle Oncology, realizou-se na Faculdade de Medicina de Lisboa e contou com 40 palestras, 50 oradores e 12 workshops. O evento abordou tratamentos oncológicos e temas como inovação em terapias, nutrição, suplementação, exercício, saúde mental e cuidados de suporte.\n\nA Associação BataZu partilhou a sua experiência com o tema \"Quando os meus colegas médicos não sabem o que fazer ao cancro do meu filho\", relatando como procuraram soluções inovadoras e cuidados de suporte para melhorar a qualidade de vida do filho Tomás, mesmo quando os médicos não tinham mais tratamentos a oferecer.\n\n<a href=\"https://www.instagram.com/p/C6yx4Jdskxx/?img_index=1\" target=\"_blank\" rel=\"noopener\">Veja aqui o post de Instagram</a>", "Onco Summit  I Congresso de Oncologia e estilo de Vida", "", "inherit", "closed", "closed", "", "182-autosave-v1", "", "", "2024-12-11 13:52:41", "2024-12-11 13:52:41", "", "182", "https://batazu.digitalpath.pt/?p=186", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("187", "1", "2024-12-11 13:57:19", "2024-12-11 13:57:19", "", "MID_btz_not-1", "", "inherit", "", "closed", "", "mid_btz_not-1", "", "", "2024-12-11 13:57:19", "2024-12-11 13:57:19", "", "182", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_not-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("188", "1", "2024-12-11 13:57:51", "2024-12-11 13:57:51", "O OncoSummit, organizado pela AIM Cancer Center e pela European School of Lifestyle Oncology, realizou-se na Faculdade de Medicina de Lisboa e contou com 40 palestras, 50 oradores e 12 workshops. O evento abordou tratamentos oncológicos e temas como inovação em terapias, nutrição, suplementação, exercício, saúde mental e cuidados de suporte.\r\n\r\nA Associação BataZu partilhou a sua experiência com o tema \"Quando os meus colegas médicos não sabem o que fazer ao cancro do meu filho\", relatando como procuraram soluções inovadoras e cuidados de suporte para melhorar a qualidade de vida do filho Tomás, mesmo quando os médicos não tinham mais tratamentos a oferecer.\r\n\r\n<a href=\"https://www.instagram.com/p/C6yx4Jdskxx/?img_index=1\" target=\"_blank\" rel=\"noopener\">Veja aqui o post de Instagram</a>", "Onco Summit  I Congresso de Oncologia e estilo de Vida", "", "inherit", "closed", "closed", "", "182-revision-v1", "", "", "2024-12-11 13:57:51", "2024-12-11 13:57:51", "", "182", "https://batazu.digitalpath.pt/?p=188", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("189", "1", "2024-12-11 14:04:48", "2024-12-11 14:04:48", "A iniciativa “Terapias Celulares Avançadas no IPO Porto – Open Day” foi realizada em parceria com o Hospital Clínic de Barcelona, visando iniciar a produção de CAR-T no IPO Porto. O evento marcou o início da colaboração entre as instituições, focada na partilha de conhecimento em terapias celulares. Especialistas do IPO Porto, Hospital Clínic de Barcelona e INFARMED participaram, e a Associação BataZu partilhou a sua experiência com CAR-T cells em Israel e na China, destacando a importância da troca de experiências.\r\n\r\nPost no Instagram:\r\n<a href=\"https://www.instagram.com/p/C7kDjs7MgKd/?utm_source=ig_web_copy_link&amp;igsh=MzRlODBiNWFlZA%3D%3D\" target=\"_blank\" rel=\"noopener\">https://www.instagram.com/p/C7kDjs7MgKd/?utm_source=ig_web_copy_link&amp;igsh=MzRlODBiNWFlZA%3D%3D</a>\r\n\r\nOutros links:\r\n\r\n<a href=\"https://ipoporto.pt/evento/terapias-celulares-avancadas-open-day/\" target=\"_blank\" rel=\"noopener\">https://ipoporto.pt/evento/terapias-celulares-avancadas-open-day/</a>\r\n\r\n<a href=\"https://www.linkedin.com/posts/ipoporto_o-instituto-portugu%C3%AAs-de-oncologia-do-porto-activity-7200896107156017153-v7Iz/?utm_source=share&amp;utm_medium=member_desktop\" target=\"_blank\" rel=\"noopener\">https://www.linkedin.com/posts/ipoporto_o-instituto-portugu%C3%AAs-de-oncologia-do-porto-activity-7200896107156017153-v7Iz/?utm_source=share&amp;utm_medium=member_desktop</a>\r\n\r\n<img class=\"alignnone size-full wp-image-191\" src=\"https://batazu.digitalpath.pt/wp-content/uploads/2024/12/Terapias-celulares-29-maio-695x1024-1.jpg\" alt=\"\" width=\"695\" height=\"1024\" />", "Terapias Celulares Avançadas no IPO Porto – Open day", "", "publish", "closed", "open", "", "terapias-celulares-avancadas-no-ipo-porto-open-day", "", "", "2024-12-11 14:04:48", "2024-12-11 14:04:48", "", "0", "https://batazu.digitalpath.pt/?p=189", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("190", "1", "2024-12-11 14:02:15", "2024-12-11 14:02:15", "", "MID_btz_not-2", "", "inherit", "", "closed", "", "mid_btz_not-2", "", "", "2024-12-11 14:02:15", "2024-12-11 14:02:15", "", "189", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_not-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("191", "1", "2024-12-11 14:04:37", "2024-12-11 14:04:37", "", "Terapias-celulares-29-maio-695x1024", "", "inherit", "", "closed", "", "terapias-celulares-29-maio-695x1024", "", "", "2024-12-11 14:04:37", "2024-12-11 14:04:37", "", "189", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/Terapias-celulares-29-maio-695x1024-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("192", "1", "2024-12-11 14:04:48", "2024-12-11 14:04:48", "A iniciativa “Terapias Celulares Avançadas no IPO Porto – Open Day” foi realizada em parceria com o Hospital Clínic de Barcelona, visando iniciar a produção de CAR-T no IPO Porto. O evento marcou o início da colaboração entre as instituições, focada na partilha de conhecimento em terapias celulares. Especialistas do IPO Porto, Hospital Clínic de Barcelona e INFARMED participaram, e a Associação BataZu partilhou a sua experiência com CAR-T cells em Israel e na China, destacando a importância da troca de experiências.\r\n\r\nPost no Instagram:\r\n<a href=\"https://www.instagram.com/p/C7kDjs7MgKd/?utm_source=ig_web_copy_link&amp;igsh=MzRlODBiNWFlZA%3D%3D\" target=\"_blank\" rel=\"noopener\">https://www.instagram.com/p/C7kDjs7MgKd/?utm_source=ig_web_copy_link&amp;igsh=MzRlODBiNWFlZA%3D%3D</a>\r\n\r\nOutros links:\r\n\r\n<a href=\"https://ipoporto.pt/evento/terapias-celulares-avancadas-open-day/\" target=\"_blank\" rel=\"noopener\">https://ipoporto.pt/evento/terapias-celulares-avancadas-open-day/</a>\r\n\r\n<a href=\"https://www.linkedin.com/posts/ipoporto_o-instituto-portugu%C3%AAs-de-oncologia-do-porto-activity-7200896107156017153-v7Iz/?utm_source=share&amp;utm_medium=member_desktop\" target=\"_blank\" rel=\"noopener\">https://www.linkedin.com/posts/ipoporto_o-instituto-portugu%C3%AAs-de-oncologia-do-porto-activity-7200896107156017153-v7Iz/?utm_source=share&amp;utm_medium=member_desktop</a>\r\n\r\n<img class=\"alignnone size-full wp-image-191\" src=\"https://batazu.digitalpath.pt/wp-content/uploads/2024/12/Terapias-celulares-29-maio-695x1024-1.jpg\" alt=\"\" width=\"695\" height=\"1024\" />", "Terapias Celulares Avançadas no IPO Porto – Open day", "", "inherit", "closed", "closed", "", "189-revision-v1", "", "", "2024-12-11 14:04:48", "2024-12-11 14:04:48", "", "189", "https://batazu.digitalpath.pt/?p=192", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("193", "1", "2024-12-11 14:13:42", "2024-12-11 14:13:42", "A Família BataZu orgulha-se da realização da primeira conferência sobre CAR-T Cells em Portugal, organizada em conjunto com a Associação Portuguesa contra a Leucemia.\r\n\r\nO evento reuniu especialistas nacionais e internacionais para discutir o potencial das CAR-T Cells no tratamento de linfomas agressivos, leucemias agudas e mielomas múltiplos. Entre os participantes estavam Arnon Nagler, Presidente do Centro de Hemato-Oncologia do Sheba Medical Center em Israel, Didier Blaise, Chefe do Departamento de Hematologia e Terapia Celular do Instituto Paoli-Calmettes em Marselha, J. Chang, Presidente do Instituto Médico Geno-Imune de Shenzhen, e outros especialistas, como Fernando Leal da Costa, Maria Gomes da Silva, João Raposo, Gilda Teixeira, José Mário Mariz e Manuel Guerreiro, participaram na discussão, assim como Elisabete Gonçalves, Diretora de Assuntos Regulatórios e Científicos da Europa na CTI Clinical Trial and Consulting Services, Margarida Serra, investigadora do iBET, e os hematologistas Sérgio Chacim, Eduardo Espada, Ana Carolina Freitas e Ximo Duarte, que apresentaram resultados da investigação realizada em Portugal.\r\n\r\nO sucesso da conferência marca um importante passo para a Associação BataZu, alinhando-se com a sua missão de promover as CAR-T Cells e acelerar os avanços nos tratamentos oncológicos.\r\n\r\nSobre a Conferência em geral:\r\n\r\nhttps://youtu.be/q2Ius89A0lI?si=_x4WZRA_BrBb-bns\r\n\r\n&nbsp;\r\n\r\n<em>Entrevistas:</em>\r\n\r\n<strong>Arnon Nagler</strong>\r\n\r\nhttps://youtu.be/p3uHKDXrNpA?si=1Os3uUh52i2x1cZ9\r\n\r\n&nbsp;\r\n\r\n<span><strong>Chang</strong><em>\r\n</em></span>\r\n\r\nhttps://youtu.be/k6iv4oOLbMU?si=qgNXMjY-aemnqden\r\n\r\n&nbsp;\r\n\r\n<span><strong>Didier Blaise</strong>\r\n</span>\r\n\r\nhttps://youtu.be/iXwUCyuBifg?si=Qpwo2QubtIJoh5DH\r\n\r\n&nbsp;\r\n\r\n<strong>Alvaro Urbano-Ispizua</strong>\r\n\r\nhttps://youtu.be/P1fF7rRvnkk?si=qR27VQJfI_aUlOYD\r\n\r\n&nbsp;", "Looking today at tomorrow’s immunotherapy, The Emerging Role of Cellular Therapies in Hematological Malignancies", "", "publish", "closed", "open", "", "looking-today-at-tomorrows-immunotherapy-the-emerging-role-of-cellular-therapies-in-hematological-malignancies", "", "", "2024-12-11 14:18:23", "2024-12-11 14:18:23", "", "0", "https://batazu.digitalpath.pt/?p=193", "0", "post", "", "0");
INSERT INTO `wp_posts` VALUES("194", "1", "2024-12-11 14:10:23", "2024-12-11 14:10:23", "", "MID_btz_not-3", "", "inherit", "", "closed", "", "mid_btz_not-3", "", "", "2024-12-11 14:10:23", "2024-12-11 14:10:23", "", "193", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_not-3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("195", "1", "2024-12-11 14:13:42", "2024-12-11 14:13:42", "A Família BataZu orgulha-se da realização da primeira conferência sobre CAR-T Cells em Portugal, organizada em conjunto com a Associação Portuguesa contra a Leucemia.\r\n\r\nO evento reuniu especialistas nacionais e internacionais para discutir o potencial das CAR-T Cells no tratamento de linfomas agressivos, leucemias agudas e mielomas múltiplos. Entre os participantes estavam Arnon Nagler, Presidente do Centro de Hemato-Oncologia do Sheba Medical Center em Israel, Didier Blaise, Chefe do Departamento de Hematologia e Terapia Celular do Instituto Paoli-Calmettes em Marselha, J. Chang, Presidente do Instituto Médico Geno-Imune de Shenzhen, e outros especialistas, como Fernando Leal da Costa, Maria Gomes da Silva, João Raposo, Gilda Teixeira, José Mário Mariz e Manuel Guerreiro, participaram na discussão, assim como Elisabete Gonçalves, Diretora de Assuntos Regulatórios e Científicos da Europa na CTI Clinical Trial and Consulting Services, Margarida Serra, investigadora do iBET, e os hematologistas Sérgio Chacim, Eduardo Espada, Ana Carolina Freitas e Ximo Duarte, que apresentaram resultados da investigação realizada em Portugal.\r\n\r\nO sucesso da conferência marca um importante passo para a Associação BataZu, alinhando-se com a sua missão de promover as CAR-T Cells e acelerar os avanços nos tratamentos oncológicos.\r\n\r\nSobre a Conferência em geral:\r\n&lt;iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/q2Ius89A0lI?si=ptqx_WBg4ed62KTp\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen&gt;&lt;/iframe&gt;\r\n\r\n&nbsp;\r\n\r\n<em>Entrevistas:</em>\r\n\r\n<strong>Arnon Nagler</strong>\r\n&lt;iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/p3uHKDXrNpA?si=wI3CxKmWI0kiCkX-\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen&gt;&lt;/iframe&gt;\r\n\r\n<span><strong>Chang</strong><em>\r\n</em>&lt;iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/k6iv4oOLbMU?si=Czto_pAcf_ayAr73\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen&gt;&lt;/iframe&gt;<em>\r\n</em></span>\r\n\r\n<span><strong>Didier Blaise</strong><em>\r\n</em>&lt;iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/iXwUCyuBifg?si=g0780wyOM-d28rDk\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen&gt;&lt;/iframe&gt;</span>\r\n\r\n<strong>Alvaro Urbano-Ispizua</strong>\r\n&lt;iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/P1fF7rRvnkk?si=wXmDjBIJC4-UVM4P\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen&gt;&lt;/iframe&gt;", "Looking today at tomorrow’s immunotherapy, The Emerging Role of Cellular Therapies in Hematological Malignancies", "", "inherit", "closed", "closed", "", "193-revision-v1", "", "", "2024-12-11 14:13:42", "2024-12-11 14:13:42", "", "193", "https://batazu.digitalpath.pt/?p=195", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("196", "1", "2024-12-11 14:15:26", "2024-12-11 14:15:26", "A Família BataZu orgulha-se da realização da primeira conferência sobre CAR-T Cells em Portugal, organizada em conjunto com a Associação Portuguesa contra a Leucemia.\r\n\r\nO evento reuniu especialistas nacionais e internacionais para discutir o potencial das CAR-T Cells no tratamento de linfomas agressivos, leucemias agudas e mielomas múltiplos. Entre os participantes estavam Arnon Nagler, Presidente do Centro de Hemato-Oncologia do Sheba Medical Center em Israel, Didier Blaise, Chefe do Departamento de Hematologia e Terapia Celular do Instituto Paoli-Calmettes em Marselha, J. Chang, Presidente do Instituto Médico Geno-Imune de Shenzhen, e outros especialistas, como Fernando Leal da Costa, Maria Gomes da Silva, João Raposo, Gilda Teixeira, José Mário Mariz e Manuel Guerreiro, participaram na discussão, assim como Elisabete Gonçalves, Diretora de Assuntos Regulatórios e Científicos da Europa na CTI Clinical Trial and Consulting Services, Margarida Serra, investigadora do iBET, e os hematologistas Sérgio Chacim, Eduardo Espada, Ana Carolina Freitas e Ximo Duarte, que apresentaram resultados da investigação realizada em Portugal.\r\n\r\nO sucesso da conferência marca um importante passo para a Associação BataZu, alinhando-se com a sua missão de promover as CAR-T Cells e acelerar os avanços nos tratamentos oncológicos.\r\n\r\nSobre a Conferência em geral:\r\n&lt;iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/q2Ius89A0lI?si=ptqx_WBg4ed62KTp\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen&gt;&lt;/iframe&gt;\r\n\r\n<em>Entrevistas:</em>\r\n\r\n<strong>Arnon Nagler</strong>\r\n&lt;iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/p3uHKDXrNpA?si=wI3CxKmWI0kiCkX-\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen&gt;&lt;/iframe&gt;\r\n\r\n<span><strong>Chang</strong><em>\r\n</em>&lt;iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/k6iv4oOLbMU?si=Czto_pAcf_ayAr73\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen&gt;&lt;/iframe&gt;<em>\r\n</em></span>\r\n\r\n<span><strong>Didier Blaise</strong><em>\r\n</em>&lt;iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/iXwUCyuBifg?si=g0780wyOM-d28rDk\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen&gt;&lt;/iframe&gt;</span>\r\n\r\n<strong>Alvaro Urbano-Ispizua</strong>\r\nhttps://youtu.be/P1fF7rRvnkk?si=qR27VQJfI_aUlOYD\r\n\r\n&nbsp;", "Looking today at tomorrow’s immunotherapy, The Emerging Role of Cellular Therapies in Hematological Malignancies", "", "inherit", "closed", "closed", "", "193-revision-v1", "", "", "2024-12-11 14:15:26", "2024-12-11 14:15:26", "", "193", "https://batazu.digitalpath.pt/?p=196", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("197", "1", "2024-12-11 14:17:33", "2024-12-11 14:17:33", "A Família BataZu orgulha-se da realização da primeira conferência sobre CAR-T Cells em Portugal, organizada em conjunto com a Associação Portuguesa contra a Leucemia.\n\nO evento reuniu especialistas nacionais e internacionais para discutir o potencial das CAR-T Cells no tratamento de linfomas agressivos, leucemias agudas e mielomas múltiplos. Entre os participantes estavam Arnon Nagler, Presidente do Centro de Hemato-Oncologia do Sheba Medical Center em Israel, Didier Blaise, Chefe do Departamento de Hematologia e Terapia Celular do Instituto Paoli-Calmettes em Marselha, J. Chang, Presidente do Instituto Médico Geno-Imune de Shenzhen, e outros especialistas, como Fernando Leal da Costa, Maria Gomes da Silva, João Raposo, Gilda Teixeira, José Mário Mariz e Manuel Guerreiro, participaram na discussão, assim como Elisabete Gonçalves, Diretora de Assuntos Regulatórios e Científicos da Europa na CTI Clinical Trial and Consulting Services, Margarida Serra, investigadora do iBET, e os hematologistas Sérgio Chacim, Eduardo Espada, Ana Carolina Freitas e Ximo Duarte, que apresentaram resultados da investigação realizada em Portugal.\n\nO sucesso da conferência marca um importante passo para a Associação BataZu, alinhando-se com a sua missão de promover as CAR-T Cells e acelerar os avanços nos tratamentos oncológicos.\n\nSobre a Conferência em geral:\n&lt;iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/q2Ius89A0lI?si=ptqx_WBg4ed62KTp\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen&gt;&lt;/iframe&gt;\n\n<em>Entrevistas:</em>\n\n<strong>Arnon Nagler</strong>\n\nhttps://youtu.be/p3uHKDXrNpA?si=1Os3uUh52i2x1cZ9\n\n&nbsp;\n\n<span><strong>Chang</strong><em>\n</em></span>\n\nhttps://youtu.be/k6iv4oOLbMU?si=qgNXMjY-aemnqden\n\n&nbsp;\n\n<span><strong>Didier Blaise</strong>\n</span>\n\nhttps://youtu.be/iXwUCyuBifg?si=Qpwo2QubtIJoh5DH\n\n&nbsp;\n\n<strong>Alvaro Urbano-Ispizua</strong>\n\nhttps://youtu.be/P1fF7rRvnkk?si=qR27VQJfI_aUlOYD\n\n&nbsp;", "Looking today at tomorrow’s immunotherapy, The Emerging Role of Cellular Therapies in Hematological Malignancies", "", "inherit", "closed", "closed", "", "193-autosave-v1", "", "", "2024-12-11 14:17:33", "2024-12-11 14:17:33", "", "193", "https://batazu.digitalpath.pt/?p=197", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("198", "1", "2024-12-11 14:16:32", "2024-12-11 14:16:32", "A Família BataZu orgulha-se da realização da primeira conferência sobre CAR-T Cells em Portugal, organizada em conjunto com a Associação Portuguesa contra a Leucemia.\r\n\r\nO evento reuniu especialistas nacionais e internacionais para discutir o potencial das CAR-T Cells no tratamento de linfomas agressivos, leucemias agudas e mielomas múltiplos. Entre os participantes estavam Arnon Nagler, Presidente do Centro de Hemato-Oncologia do Sheba Medical Center em Israel, Didier Blaise, Chefe do Departamento de Hematologia e Terapia Celular do Instituto Paoli-Calmettes em Marselha, J. Chang, Presidente do Instituto Médico Geno-Imune de Shenzhen, e outros especialistas, como Fernando Leal da Costa, Maria Gomes da Silva, João Raposo, Gilda Teixeira, José Mário Mariz e Manuel Guerreiro, participaram na discussão, assim como Elisabete Gonçalves, Diretora de Assuntos Regulatórios e Científicos da Europa na CTI Clinical Trial and Consulting Services, Margarida Serra, investigadora do iBET, e os hematologistas Sérgio Chacim, Eduardo Espada, Ana Carolina Freitas e Ximo Duarte, que apresentaram resultados da investigação realizada em Portugal.\r\n\r\nO sucesso da conferência marca um importante passo para a Associação BataZu, alinhando-se com a sua missão de promover as CAR-T Cells e acelerar os avanços nos tratamentos oncológicos.\r\n\r\nSobre a Conferência em geral:\r\n&lt;iframe width=\"560\" height=\"315\" src=\"https://www.youtube.com/embed/q2Ius89A0lI?si=ptqx_WBg4ed62KTp\" title=\"YouTube video player\" frameborder=\"0\" allow=\"accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share\" referrerpolicy=\"strict-origin-when-cross-origin\" allowfullscreen&gt;&lt;/iframe&gt;\r\n\r\n<em>Entrevistas:</em>\r\n\r\n<strong>Arnon Nagler</strong>\r\n\r\nhttps://www.youtube.com/embed/p3uHKDXrNpA?si=wI3CxKmWI0kiCkX-\r\n\r\n&nbsp;\r\n\r\n<span><strong>Chang</strong><em>\r\n</em></span>\r\n\r\nhttps://www.youtube.com/embed/k6iv4oOLbMU?si=Czto_pAcf_ayAr73\r\n\r\n&nbsp;\r\n\r\n<span><strong>Didier Blaise</strong>\r\n</span>\r\n\r\nhttps://youtu.be/iXwUCyuBifg?si=Qpwo2QubtIJoh5DH\r\n\r\n&nbsp;\r\n\r\n<strong>Alvaro Urbano-Ispizua</strong>\r\n\r\nhttps://youtu.be/P1fF7rRvnkk?si=qR27VQJfI_aUlOYD\r\n\r\n&nbsp;", "Looking today at tomorrow’s immunotherapy, The Emerging Role of Cellular Therapies in Hematological Malignancies", "", "inherit", "closed", "closed", "", "193-revision-v1", "", "", "2024-12-11 14:16:32", "2024-12-11 14:16:32", "", "193", "https://batazu.digitalpath.pt/?p=198", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("199", "1", "2024-12-11 14:18:05", "2024-12-11 14:18:05", "A Família BataZu orgulha-se da realização da primeira conferência sobre CAR-T Cells em Portugal, organizada em conjunto com a Associação Portuguesa contra a Leucemia.\r\n\r\nO evento reuniu especialistas nacionais e internacionais para discutir o potencial das CAR-T Cells no tratamento de linfomas agressivos, leucemias agudas e mielomas múltiplos. Entre os participantes estavam Arnon Nagler, Presidente do Centro de Hemato-Oncologia do Sheba Medical Center em Israel, Didier Blaise, Chefe do Departamento de Hematologia e Terapia Celular do Instituto Paoli-Calmettes em Marselha, J. Chang, Presidente do Instituto Médico Geno-Imune de Shenzhen, e outros especialistas, como Fernando Leal da Costa, Maria Gomes da Silva, João Raposo, Gilda Teixeira, José Mário Mariz e Manuel Guerreiro, participaram na discussão, assim como Elisabete Gonçalves, Diretora de Assuntos Regulatórios e Científicos da Europa na CTI Clinical Trial and Consulting Services, Margarida Serra, investigadora do iBET, e os hematologistas Sérgio Chacim, Eduardo Espada, Ana Carolina Freitas e Ximo Duarte, que apresentaram resultados da investigação realizada em Portugal.\r\n\r\nO sucesso da conferência marca um importante passo para a Associação BataZu, alinhando-se com a sua missão de promover as CAR-T Cells e acelerar os avanços nos tratamentos oncológicos.\r\n\r\nSobre a Conferência em geral:\r\n\r\nhttps://youtu.be/q2Ius89A0lI?si=_x4WZRA_BrBb-bns\r\n\r\n&nbsp;\r\n\r\n<em>Entrevistas:</em>\r\n\r\n<strong>Arnon Nagler</strong>\r\n\r\nhttps://youtu.be/p3uHKDXrNpA?si=1Os3uUh52i2x1cZ9\r\n\r\n&nbsp;\r\n\r\n<span><strong>Chang</strong><em>\r\n</em></span>\r\n\r\nhttps://youtu.be/k6iv4oOLbMU?si=qgNXMjY-aemnqden\r\n\r\n&nbsp;\r\n\r\n<span><strong>Didier Blaise</strong>\r\n</span>\r\n\r\nhttps://youtu.be/iXwUCyuBifg?si=Qpwo2QubtIJoh5DH\r\n\r\n&nbsp;\r\n\r\n<strong>Alvaro Urbano-Ispizua</strong>\r\n\r\nhttps://youtu.be/P1fF7rRvnkk?si=qR27VQJfI_aUlOYD\r\n\r\n&nbsp;", "Looking today at tomorrow’s immunotherapy, The Emerging Role of Cellular Therapies in Hematological Malignancies", "", "inherit", "closed", "closed", "", "193-revision-v1", "", "", "2024-12-11 14:18:05", "2024-12-11 14:18:05", "", "193", "https://batazu.digitalpath.pt/?p=199", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("200", "1", "2024-12-11 14:20:47", "2024-12-11 14:20:47", "<p>[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]</p>\n", "Blog single", "", "inherit", "closed", "closed", "", "20-autosave-v1", "", "", "2024-12-11 14:20:47", "2024-12-11 14:20:47", "", "20", "https://batazu.digitalpath.pt/?p=200", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("201", "1", "2024-12-11 14:21:31", "2024-12-11 14:21:31", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:21:31", "2024-12-11 14:21:31", "", "20", "https://batazu.digitalpath.pt/?p=201", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("202", "1", "2024-12-11 14:22:31", "2024-12-11 14:22:31", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%233cb6ba%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%220.1em%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:22:31", "2024-12-11 14:22:31", "", "20", "https://batazu.digitalpath.pt/?p=202", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("203", "1", "2024-12-11 14:22:43", "2024-12-11 14:22:43", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%220.1em%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:22:43", "2024-12-11 14:22:43", "", "20", "https://batazu.digitalpath.pt/?p=203", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("204", "1", "2024-12-11 14:23:09", "2024-12-11 14:23:09", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:23:09", "2024-12-11 14:23:09", "", "20", "https://batazu.digitalpath.pt/?p=204", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("205", "1", "2024-12-11 14:24:10", "2024-12-11 14:24:10", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:24:10", "2024-12-11 14:24:10", "", "20", "https://batazu.digitalpath.pt/?p=205", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("206", "1", "2024-12-11 14:24:46", "2024-12-11 14:24:46", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_custom_field key=\"detalhe_evento\" hide_empty=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22font-style%22%3A%22italic%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:24:46", "2024-12-11 14:24:46", "", "20", "https://batazu.digitalpath.pt/?p=206", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("207", "1", "2024-12-11 14:25:16", "2024-12-11 14:25:16", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%220.5rem%22%7D%7D\"][us_post_custom_field key=\"detalhe_evento\" hide_empty=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22font-style%22%3A%22italic%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:25:16", "2024-12-11 14:25:16", "", "20", "https://batazu.digitalpath.pt/?p=207", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("208", "1", "2024-12-11 14:26:08", "2024-12-11 14:26:08", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%220.5rem%22%7D%7D\"][us_post_custom_field key=\"detalhe_evento\" hide_empty=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:26:08", "2024-12-11 14:26:08", "", "20", "https://batazu.digitalpath.pt/?p=208", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("209", "1", "2024-12-11 14:26:31", "2024-12-11 14:26:31", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%220.5rem%22%7D%7D\"][us_post_custom_field key=\"detalhe_evento\" hide_empty=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22700%22%2C%22margin-top%22%3A%221rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:26:31", "2024-12-11 14:26:31", "", "20", "https://batazu.digitalpath.pt/?p=209", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("210", "1", "2024-12-11 14:26:52", "2024-12-11 14:26:52", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%220.5rem%22%7D%7D\"][us_post_custom_field key=\"detalhe_evento\" hide_empty=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22700%22%2C%22margin-top%22%3A%221rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing providers=\"email,facebook,twitter,linkedin,whatsapp\" align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:26:52", "2024-12-11 14:26:52", "", "20", "https://batazu.digitalpath.pt/?p=210", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("211", "1", "2024-12-11 14:32:20", "2024-12-11 14:32:20", "", "MID_btz_img-5", "", "inherit", "", "closed", "", "mid_btz_img-5", "", "", "2024-12-11 14:32:20", "2024-12-11 14:32:20", "", "20", "https://batazu.digitalpath.pt/wp-content/uploads/2023/02/MID_btz_img-5.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("212", "1", "2024-12-11 14:32:44", "2024-12-11 14:32:44", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22211%22%2C%22background-position%22%3A%22top%20right%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%220.5rem%22%7D%7D\"][us_post_custom_field key=\"detalhe_evento\" hide_empty=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22700%22%2C%22margin-top%22%3A%221rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing providers=\"email,facebook,twitter,linkedin,whatsapp\" align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:32:44", "2024-12-11 14:32:44", "", "20", "https://batazu.digitalpath.pt/?p=212", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("213", "1", "2024-12-11 14:33:21", "2024-12-11 14:33:21", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22211%22%2C%22background-position%22%3A%22180px%20right%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%220.5rem%22%7D%7D\"][us_post_custom_field key=\"detalhe_evento\" hide_empty=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22700%22%2C%22margin-top%22%3A%221rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing providers=\"email,facebook,twitter,linkedin,whatsapp\" align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:33:21", "2024-12-11 14:33:21", "", "20", "https://batazu.digitalpath.pt/?p=213", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("214", "1", "2024-12-11 14:34:06", "2024-12-11 14:34:06", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22211%22%2C%22background-position%22%3A%223rem%207rem%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%220.5rem%22%7D%7D\"][us_post_custom_field key=\"detalhe_evento\" hide_empty=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22700%22%2C%22margin-top%22%3A%221rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing providers=\"email,facebook,twitter,linkedin,whatsapp\" align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:34:06", "2024-12-11 14:34:06", "", "20", "https://batazu.digitalpath.pt/?p=214", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("215", "1", "2024-12-11 14:34:27", "2024-12-11 14:34:27", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22211%22%2C%22background-position%22%3A%2213rem%207rem%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%220.5rem%22%7D%7D\"][us_post_custom_field key=\"detalhe_evento\" hide_empty=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22700%22%2C%22margin-top%22%3A%221rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing providers=\"email,facebook,twitter,linkedin,whatsapp\" align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:34:27", "2024-12-11 14:34:27", "", "20", "https://batazu.digitalpath.pt/?p=215", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("216", "1", "2024-12-11 14:34:53", "2024-12-11 14:34:53", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22211%22%2C%22background-position%22%3A%22right%207rem%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%220.5rem%22%7D%7D\"][us_post_custom_field key=\"detalhe_evento\" hide_empty=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22700%22%2C%22margin-top%22%3A%221rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing providers=\"email,facebook,twitter,linkedin,whatsapp\" align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:34:53", "2024-12-11 14:34:53", "", "20", "https://batazu.digitalpath.pt/?p=216", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("217", "1", "2024-12-11 14:35:14", "2024-12-11 14:35:14", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22211%22%2C%22background-position%22%3A%22right%20180px%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%220.5rem%22%7D%7D\"][us_post_custom_field key=\"detalhe_evento\" hide_empty=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22700%22%2C%22margin-top%22%3A%221rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing providers=\"email,facebook,twitter,linkedin,whatsapp\" align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:35:14", "2024-12-11 14:35:14", "", "20", "https://batazu.digitalpath.pt/?p=217", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("218", "1", "2024-12-11 14:36:01", "2024-12-11 14:36:01", "[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22211%22%2C%22background-position%22%3A%22right%20250px%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Todos os Projetos, Eventos e Notícias\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_taxonomy link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_primary%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%2220px%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222px%22%2C%22margin-bottom%22%3A%220.5rem%22%7D%7D\"][us_post_custom_field key=\"detalhe_evento\" hide_empty=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22700%22%2C%22margin-top%22%3A%221rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing providers=\"email,facebook,twitter,linkedin,whatsapp\" align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outros artigos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-12-11 14:36:01", "2024-12-11 14:36:01", "", "20", "https://batazu.digitalpath.pt/?p=218", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("219", "1", "2024-12-11 14:41:17", "2024-12-11 14:41:17", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_header_middle_bg%22%2C%22margin-bottom%22%3A%223rem%22%7D%7D\"][vc_column width=\"1/1\"][us_separator][us_post_title css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222.5rem%22%2C%22line-height%22%3A%222.7rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titlecenterazul\"][us_separator size=\"small\"][/vc_column][/vc_row]", "Page title PT", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2024-12-11 14:41:17", "2024-12-11 14:41:17", "", "10", "https://batazu.digitalpath.pt/?p=219", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("220", "1", "2024-12-11 14:41:49", "2024-12-11 14:41:49", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_header_middle_bg%22%2C%22margin-bottom%22%3A%223rem%22%7D%7D\"][vc_column width=\"1/1\"][us_separator][us_post_title css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222.5rem%22%2C%22line-height%22%3A%222.7rem%22%2C%22font-weight%22%3A%22300%22%2C%22padding-bottom%22%3A%2220px%22%7D%7D\" el_class=\"titlecenterazul\"][us_separator size=\"small\"][/vc_column][/vc_row]", "Page title PT", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2024-12-11 14:41:49", "2024-12-11 14:41:49", "", "10", "https://batazu.digitalpath.pt/?p=220", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("221", "1", "2024-12-11 14:43:38", "2024-12-11 14:43:38", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_header_middle_bg%22%2C%22margin-bottom%22%3A%223rem%22%7D%7D\"][vc_column width=\"1/1\"][us_separator][us_post_title css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22padding-bottom%22%3A%2220px%22%7D%7D\" el_class=\"titlecenterazul\"][us_separator size=\"small\"][/vc_column][/vc_row]", "Page title PT", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2024-12-11 14:43:38", "2024-12-11 14:43:38", "", "10", "https://batazu.digitalpath.pt/?p=221", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("222", "1", "2024-12-11 14:44:20", "2024-12-11 14:44:20", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_header_middle_bg%22%2C%22margin-bottom%22%3A%223rem%22%7D%7D\"][vc_column width=\"1/1\"][us_separator size=\"large\"][us_post_title css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22padding-bottom%22%3A%2220px%22%7D%7D\" el_class=\"titlecenterazul\"][us_separator size=\"small\"][/vc_column][/vc_row]", "Page title PT", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2024-12-11 14:44:20", "2024-12-11 14:44:20", "", "10", "https://batazu.digitalpath.pt/?p=222", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("223", "1", "2024-12-11 14:45:37", "2024-12-11 14:45:37", "<p>[vc_row][vc_column width=\"1/4\"][us_grid_filter][/vc_column][vc_column width=\"3/4\"][us_grid items_layout=\"13\" columns=\"3\" items_gap=\"1rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][/vc_row]</p>\n", "Projetos, Eventos e Notícias", "", "inherit", "closed", "closed", "", "109-autosave-v1", "", "", "2024-12-11 14:45:37", "2024-12-11 14:45:37", "", "109", "https://batazu.digitalpath.pt/?p=223", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("224", "1", "2024-12-11 14:45:56", "2024-12-11 14:45:56", "[vc_row][vc_column width=\"1/4\"][us_grid_filter filter_items=\"%5B%7B%22source%22%3A%22tax%7Ccategory%22%2C%22ui_type%22%3A%22checkbox%22%2C%22min_value%22%3A%220%22%2C%22step_size%22%3A%221%22%2C%22show_all_value%22%3A%221%22%2C%22show_amount%22%3A%220%22%2C%22label%22%3A%22Filtrar%20por%3A%22%2C%22show_color_swatch%22%3A%220%22%2C%22hide_color_swatch_label%22%3A%220%22%7D%5D\" layout=\"ver\" values_max_height=\"80vh\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column][vc_column width=\"3/4\"][us_grid items_layout=\"13\" columns=\"3\" items_gap=\"1rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][/vc_row]", "Projetos, Eventos e Notícias", "", "inherit", "closed", "closed", "", "109-revision-v1", "", "", "2024-12-11 14:45:56", "2024-12-11 14:45:56", "", "109", "https://batazu.digitalpath.pt/?p=224", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("225", "1", "2024-12-11 14:46:42", "2024-12-11 14:46:42", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_header_middle_bg%22%7D%7D\"][vc_column width=\"1/1\"][us_separator size=\"large\"][us_post_title css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22padding-bottom%22%3A%2220px%22%7D%7D\" el_class=\"titlecenterazul\"][us_separator size=\"small\"][/vc_column][/vc_row]", "Page title PT", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2024-12-11 14:46:42", "2024-12-11 14:46:42", "", "10", "https://batazu.digitalpath.pt/?p=225", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("226", "1", "2024-12-11 14:47:54", "2024-12-11 14:47:54", "[vc_row][vc_column width=\"1/4\"][us_grid_filter filter_items=\"%5B%7B%22source%22%3A%22tax%7Ccategory%22%2C%22ui_type%22%3A%22checkbox%22%2C%22min_value%22%3A%220%22%2C%22step_size%22%3A%221%22%2C%22show_all_value%22%3A%221%22%2C%22show_amount%22%3A%220%22%2C%22label%22%3A%22Filtrar%20por%3A%22%2C%22show_color_swatch%22%3A%220%22%2C%22hide_color_swatch_label%22%3A%220%22%7D%5D\" layout=\"ver\" values_max_height=\"80vh\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column][vc_column width=\"3/4\"][us_grid items_layout=\"13\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][/vc_row]", "Projetos, Eventos e Notícias", "", "inherit", "closed", "closed", "", "109-revision-v1", "", "", "2024-12-11 14:47:54", "2024-12-11 14:47:54", "", "109", "https://batazu.digitalpath.pt/?p=226", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("227", "1", "2024-12-11 14:48:47", "2024-12-11 14:48:47", "[vc_row][vc_column width=\"1/5\"][us_grid_filter filter_items=\"%5B%7B%22source%22%3A%22tax%7Ccategory%22%2C%22ui_type%22%3A%22checkbox%22%2C%22min_value%22%3A%220%22%2C%22step_size%22%3A%221%22%2C%22show_all_value%22%3A%221%22%2C%22show_amount%22%3A%220%22%2C%22label%22%3A%22Filtrar%20por%3A%22%2C%22show_color_swatch%22%3A%220%22%2C%22hide_color_swatch_label%22%3A%220%22%7D%5D\" layout=\"ver\" values_max_height=\"80vh\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column][vc_column width=\"4/5\"][us_grid items_quantity=\"12\" pagination=\"regular\" items_layout=\"13\" columns=\"3\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][/vc_row]", "Projetos, Eventos e Notícias", "", "inherit", "closed", "closed", "", "109-revision-v1", "", "", "2024-12-11 14:48:47", "2024-12-11 14:48:47", "", "109", "https://batazu.digitalpath.pt/?p=227", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("228", "1", "2024-12-11 14:49:14", "2024-12-11 14:49:14", "[vc_row css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/5\"][us_grid_filter filter_items=\"%5B%7B%22source%22%3A%22tax%7Ccategory%22%2C%22ui_type%22%3A%22checkbox%22%2C%22min_value%22%3A%220%22%2C%22step_size%22%3A%221%22%2C%22show_all_value%22%3A%221%22%2C%22show_amount%22%3A%220%22%2C%22label%22%3A%22Filtrar%20por%3A%22%2C%22show_color_swatch%22%3A%220%22%2C%22hide_color_swatch_label%22%3A%220%22%7D%5D\" layout=\"ver\" values_max_height=\"80vh\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column][vc_column width=\"4/5\"][us_grid items_quantity=\"12\" pagination=\"regular\" items_layout=\"13\" columns=\"3\" items_gap=\"1rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][/vc_row]", "Projetos, Eventos e Notícias", "", "inherit", "closed", "closed", "", "109-revision-v1", "", "", "2024-12-11 14:49:14", "2024-12-11 14:49:14", "", "109", "https://batazu.digitalpath.pt/?p=228", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("229", "1", "2024-12-11 14:55:57", "2024-12-11 14:55:57", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][us_grid post_type=\"current_query\" pagination=\"regular\" items_layout=\"13\" columns=\"3\" items_gap=\"1rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][/vc_row]</p>\r\n", "Artigos Categorias archive", "", "publish", "closed", "closed", "", "artigos-categorias-archive", "", "", "2024-12-11 14:56:56", "2024-12-11 14:56:56", "", "0", "https://batazu.digitalpath.pt/?post_type=us_content_template&#038;p=229", "0", "us_content_template", "", "0");
INSERT INTO `wp_posts` VALUES("230", "1", "2024-12-11 14:55:57", "2024-12-11 14:55:57", "", "Page Template 2", "", "inherit", "closed", "closed", "", "229-revision-v1", "", "", "2024-12-11 14:55:57", "2024-12-11 14:55:57", "", "229", "https://batazu.digitalpath.pt/?p=230", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("231", "1", "2024-12-11 14:56:14", "2024-12-11 14:56:14", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][us_grid items_quantity=\"12\" pagination=\"regular\" items_layout=\"13\" columns=\"3\" items_gap=\"1rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][/vc_row]</p>\r\n", "Artigos Categorias archive", "", "inherit", "closed", "closed", "", "229-revision-v1", "", "", "2024-12-11 14:56:14", "2024-12-11 14:56:14", "", "229", "https://batazu.digitalpath.pt/?p=231", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("232", "1", "2024-12-11 14:56:56", "2024-12-11 14:56:56", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][us_grid post_type=\"current_query\" pagination=\"regular\" items_layout=\"13\" columns=\"3\" items_gap=\"1rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][/vc_row]</p>\r\n", "Artigos Categorias archive", "", "inherit", "closed", "closed", "", "229-revision-v1", "", "", "2024-12-11 14:56:56", "2024-12-11 14:56:56", "", "229", "https://batazu.digitalpath.pt/?p=232", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("233", "1", "2024-12-11 15:07:14", "2024-12-11 15:07:14", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"3/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"4/12\"][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftamarelo\"][/vc_column][vc_column width=\"5/12\"][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:07:14", "2024-12-11 15:07:14", "", "36", "https://batazu.digitalpath.pt/?p=233", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("234", "1", "2024-12-11 15:07:45", "2024-12-11 15:07:45", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"3/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"4/12\"][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titleleftamarelo\"][/vc_column][vc_column width=\"5/12\"][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:07:45", "2024-12-11 15:07:45", "", "36", "https://batazu.digitalpath.pt/?p=234", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("235", "1", "2024-12-11 15:08:44", "2024-12-11 15:08:44", "<p>[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"3/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,<br />\r\neventos<br />\r\ne notícias<br />\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"4/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"2\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][/vc_row]</p>\r\n", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:08:44", "2024-12-11 15:08:44", "", "36", "https://batazu.digitalpath.pt/?p=235", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("236", "1", "2024-12-11 15:09:18", "2024-12-11 15:09:18", "<p>[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,<br />\r\neventos<br />\r\ne notícias<br />\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"2\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][/vc_row]</p>\r\n", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:09:18", "2024-12-11 15:09:18", "", "36", "https://batazu.digitalpath.pt/?p=236", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("237", "1", "2024-12-11 15:16:15", "2024-12-11 15:16:15", "<p>[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,<br />\r\neventos<br />\r\ne notícias<br />\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"2\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][/vc_row]</p>\r\n", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:16:15", "2024-12-11 15:16:15", "", "36", "https://batazu.digitalpath.pt/?p=237", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("238", "1", "2024-12-11 15:17:02", "2024-12-11 15:17:02", "<p>[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,<br />\r\neventos<br />\r\ne notícias<br />\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"2\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row]</p>\r\n", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:17:02", "2024-12-11 15:17:02", "", "36", "https://batazu.digitalpath.pt/?p=238", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("239", "1", "2024-12-11 15:18:25", "2024-12-11 15:18:25", "<p>[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,<br />\r\neventos<br />\r\ne notícias<br />\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"2\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row]</p>\r\n", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:18:25", "2024-12-11 15:18:25", "", "36", "https://batazu.digitalpath.pt/?p=239", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("240", "1", "2024-12-11 15:18:59", "2024-12-11 15:18:59", "<p>[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,<br />\r\neventos<br />\r\ne notícias<br />\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row]</p>\r\n", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:18:59", "2024-12-11 15:18:59", "", "36", "https://batazu.digitalpath.pt/?p=240", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("241", "1", "2024-12-11 15:21:33", "2024-12-11 15:21:33", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titlecenterbranco\"][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:21:33", "2024-12-11 15:21:33", "", "36", "https://batazu.digitalpath.pt/?p=241", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("242", "1", "2024-12-11 15:22:01", "2024-12-11 15:22:01", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titlecenterbranco\"][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:22:01", "2024-12-11 15:22:01", "", "36", "https://batazu.digitalpath.pt/?p=242", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("243", "1", "2024-12-11 15:22:31", "2024-12-11 15:22:31", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titlecenterbranco\"][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:22:31", "2024-12-11 15:22:31", "", "36", "https://batazu.digitalpath.pt/?p=243", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("244", "1", "2024-12-11 15:23:53", "2024-12-11 15:23:53", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:23:53", "2024-12-11 15:23:53", "", "36", "https://batazu.digitalpath.pt/?p=244", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("245", "1", "2024-12-11 15:24:20", "2024-12-11 15:24:20", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:24:20", "2024-12-11 15:24:20", "", "36", "https://batazu.digitalpath.pt/?p=245", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("246", "1", "2024-12-11 15:27:47", "2024-12-11 15:27:47", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23b2eeef%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:27:47", "2024-12-11 15:27:47", "", "36", "https://batazu.digitalpath.pt/?p=246", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("247", "1", "2024-12-11 15:28:58", "2024-12-11 15:28:58", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23dbfeff%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:28:58", "2024-12-11 15:28:58", "", "36", "https://batazu.digitalpath.pt/?p=247", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("248", "1", "2024-12-11 15:30:09", "2024-12-11 15:30:09", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22linear-gradient%280deg%2C%23ffffff%2C%23dbfeff%29%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:30:09", "2024-12-11 15:30:09", "", "36", "https://batazu.digitalpath.pt/?p=248", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("249", "1", "2024-12-11 15:30:51", "2024-12-11 15:30:51", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:30:51", "2024-12-11 15:30:51", "", "36", "https://batazu.digitalpath.pt/?p=249", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("250", "1", "2024-12-11 15:31:15", "2024-12-11 15:31:15", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.2em%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:31:15", "2024-12-11 15:31:15", "", "36", "https://batazu.digitalpath.pt/?p=250", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("251", "1", "2024-12-11 15:31:29", "2024-12-11 15:31:29", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:31:29", "2024-12-11 15:31:29", "", "36", "https://batazu.digitalpath.pt/?p=251", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("252", "1", "2024-12-11 15:37:59", "2024-12-11 15:37:59", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Benefícios\r\nfiscais[/vc_column_text][us_image image=\"87\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]A ajuda à nossa Associação confere-lhe benefícios fiscais.[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Consignação\r\ndo IRS[/vc_column_text][us_image image=\"88\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Na sua próxima declaração de IRS, lembre-se de nós! O contribuinte da Associação\r\nBataZu é o 517771330[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:37:59", "2024-12-11 15:37:59", "", "36", "https://batazu.digitalpath.pt/?p=252", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("253", "1", "2024-12-11 15:39:13", "2024-12-11 15:39:13", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Benefícios\r\nfiscais[/vc_column_text][us_image image=\"87\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]A ajuda à nossa Associação confere-lhe benefícios fiscais.[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Consignação\r\ndo IRS[/vc_column_text][us_image image=\"88\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Na sua próxima declaração de IRS, lembre-se de nós! O nosso contribuinte é o  517771330[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:39:13", "2024-12-11 15:39:13", "", "36", "https://batazu.digitalpath.pt/?p=253", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("254", "1", "2024-12-11 15:43:04", "2024-12-11 15:43:04", "", "MID_btz_img-6", "", "inherit", "", "closed", "", "mid_btz_img-6", "", "", "2024-12-11 15:43:04", "2024-12-11 15:43:04", "", "36", "https://batazu.digitalpath.pt/wp-content/uploads/2024/12/MID_btz_img-6.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("255", "1", "2024-12-11 15:43:59", "2024-12-11 15:43:59", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Benefícios\r\nfiscais[/vc_column_text][us_image image=\"87\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]A ajuda à nossa Associação confere-lhe benefícios fiscais.[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Consignação\r\ndo IRS[/vc_column_text][us_image image=\"88\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Na sua próxima declaração de IRS, lembre-se de nós! O nosso contribuinte é o  517771330[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22254%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Parcerias\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterazul\"][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:43:59", "2024-12-11 15:43:59", "", "36", "https://batazu.digitalpath.pt/?p=255", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("256", "1", "2024-12-11 15:44:32", "2024-12-11 15:44:32", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Benefícios\r\nfiscais[/vc_column_text][us_image image=\"87\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]A ajuda à nossa Associação confere-lhe benefícios fiscais.[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Consignação\r\ndo IRS[/vc_column_text][us_image image=\"88\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Na sua próxima declaração de IRS, lembre-se de nós! O nosso contribuinte é o  517771330[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22254%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Parcerias\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterazul\"][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:44:32", "2024-12-11 15:44:32", "", "36", "https://batazu.digitalpath.pt/?p=256", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("257", "1", "2024-12-11 15:44:48", "2024-12-11 15:44:48", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftamarelo\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Benefícios\r\nfiscais[/vc_column_text][us_image image=\"87\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]A ajuda à nossa Associação confere-lhe benefícios fiscais.[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Consignação\r\ndo IRS[/vc_column_text][us_image image=\"88\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Na sua próxima declaração de IRS, lembre-se de nós! O nosso contribuinte é o  517771330[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22254%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Parcerias\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterazul\"][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:44:48", "2024-12-11 15:44:48", "", "36", "https://batazu.digitalpath.pt/?p=257", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("258", "1", "2024-12-11 15:45:12", "2024-12-11 15:45:12", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftbranco\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Benefícios\r\nfiscais[/vc_column_text][us_image image=\"87\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]A ajuda à nossa Associação confere-lhe benefícios fiscais.[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Consignação\r\ndo IRS[/vc_column_text][us_image image=\"88\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Na sua próxima declaração de IRS, lembre-se de nós! O nosso contribuinte é o  517771330[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22254%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Parcerias\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterazul\"][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:45:12", "2024-12-11 15:45:12", "", "36", "https://batazu.digitalpath.pt/?p=258", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("259", "1", "2024-12-11 15:46:09", "2024-12-11 15:46:09", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftbranco\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Benefícios\r\nfiscais[/vc_column_text][us_image image=\"87\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]A ajuda à nossa Associação confere-lhe benefícios fiscais.[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Consignação\r\ndo IRS[/vc_column_text][us_image image=\"88\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Na sua próxima declaração de IRS, lembre-se de nós! O nosso contribuinte é o  517771330[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22254%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Parcerias\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterazul\"][us_carousel post_type=\"parceria\" items_quantity=\"-1\" items_layout=\"53\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"5\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_offset=\"12px\" dots=\"1\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:46:09", "2024-12-11 15:46:09", "", "36", "https://batazu.digitalpath.pt/?p=259", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("260", "1", "2024-12-11 15:46:50", "2024-12-11 15:46:50", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftbranco\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Benefícios\r\nfiscais[/vc_column_text][us_image image=\"87\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]A ajuda à nossa Associação confere-lhe benefícios fiscais.[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Consignação\r\ndo IRS[/vc_column_text][us_image image=\"88\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Na sua próxima declaração de IRS, lembre-se de nós! O nosso contribuinte é o  517771330[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22254%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Parcerias\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterazul\"][us_carousel post_type=\"parceria\" items_quantity=\"-1\" items_layout=\"53\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"5\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_offset=\"12px\" dots=\"1\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222.5rem%22%7D%7D\"][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:46:50", "2024-12-11 15:46:50", "", "36", "https://batazu.digitalpath.pt/?p=260", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("261", "1", "2024-12-11 15:47:12", "2024-12-11 15:47:12", "[vc_row width=\"full\" us_bg_image_source=\"media\" us_bg_image=\"176\" us_bg_size=\"initial\" us_bg_pos=\"top center\" us_bg_repeat=\"no-repeat\" css=\"%7B%22default%22%3A%7B%22padding-bottom%22%3A%224rem%22%7D%7D\" el_class=\"image-wrap\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22220px%22%7D%7D\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" items_valign=\"top\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"-21px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"large\" columns_gap=\"1.4rem\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2278%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"2/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.8rem%22%2C%22font-weight%22%3A%22800%22%7D%7D\" el_class=\"titleleftbranco\"]Projetos,\r\neventos\r\ne notícias\r\nmais recentes[/vc_column_text][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"1\" items_layout=\"180\" columns=\"1\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%221rem%22%7D%7D\"][/vc_column][vc_column width=\"5/12\"][us_grid items_quantity=\"3\" exclude_items=\"offset\" items_layout=\"181\" columns=\"1\" items_gap=\"1.4rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][us_btn label=\"Ver todos\" link=\"%7B%22url%22%3A%22%2Fprojetos-eventos-e-noticias%2F%22%7D\" style=\"2\" align=\"right\" icon=\"far|arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2279%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Porque precisamos do apoio de todos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterbranco\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23000%22%2C%22text-align%22%3A%22center%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22margin-left%22%3A%2210%25%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%223rem%22%2C%22margin-right%22%3A%2210%25%22%7D%7D\"]Apoie esta causa, contribua para que Portugal avance na pesquisa e desenvolvimento de tratamentos revolucionários, e ajude-nos a dar mais esperança a cada família que luta contra o cancro infantil.\r\n<strong>Juntos, podemos vencer!</strong>[/vc_column_text][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Faça uma\r\ndoação agora[/vc_column_text][us_image image=\"86\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Simples e rápido, pode-nos ajudar por MB-Way através do número 000 000 000[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Benefícios\r\nfiscais[/vc_column_text][us_image image=\"87\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]A ajuda à nossa Associação confere-lhe benefícios fiscais.[/vc_column_text][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23e8fcfc%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%2C%22box-shadow-blur%22%3A%2220px%22%2C%22box-shadow-color%22%3A%22%2389b1b3%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.7rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"]Consignação\r\ndo IRS[/vc_column_text][us_image image=\"88\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22210px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22line-height%22%3A%221.4em%22%7D%7D\"]Na sua próxima declaração de IRS, lembre-se de nós! O nosso contribuinte é o  517771330[/vc_column_text][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row height=\"large\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22254%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Parcerias\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%222rem%22%2C%22line-height%22%3A%222.2rem%22%2C%22font-weight%22%3A%22800%22%2C%22background-image%22%3A%22%7B%7Bsite_icon%7D%7D%22%7D%7D\" el_class=\"titlecenterazul\"][us_carousel post_type=\"parceria\" items_quantity=\"-1\" items_layout=\"53\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"5\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_offset=\"12px\" dots=\"1\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%7D\"][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-12-11 15:47:12", "2024-12-11 15:47:12", "", "36", "https://batazu.digitalpath.pt/?p=261", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("262", "1", "2024-12-11 15:49:59", "2024-12-11 15:49:59", "", "Teste 1", "", "publish", "closed", "closed", "", "teste-1", "", "", "2024-12-11 15:49:59", "2024-12-11 15:49:59", "", "0", "https://batazu.digitalpath.pt/?post_type=parceria&#038;p=262", "0", "parceria", "", "0");
INSERT INTO `wp_posts` VALUES("263", "1", "2024-12-11 15:50:16", "2024-12-11 15:50:16", "", "Teste 2", "", "publish", "closed", "closed", "", "teste-2", "", "", "2024-12-11 15:50:16", "2024-12-11 15:50:16", "", "0", "https://batazu.digitalpath.pt/?post_type=parceria&#038;p=263", "0", "parceria", "", "0");
INSERT INTO `wp_posts` VALUES("264", "1", "2024-12-11 15:50:25", "2024-12-11 15:50:25", "", "Teste 3", "", "publish", "closed", "closed", "", "teste-3", "", "", "2024-12-11 15:50:25", "2024-12-11 15:50:25", "", "0", "https://batazu.digitalpath.pt/?post_type=parceria&#038;p=264", "0", "parceria", "", "0");
INSERT INTO `wp_posts` VALUES("265", "1", "2024-12-11 15:50:36", "2024-12-11 15:50:36", "", "Teste 4", "", "publish", "closed", "closed", "", "teste-4", "", "", "2024-12-11 15:50:36", "2024-12-11 15:50:36", "", "0", "https://batazu.digitalpath.pt/?post_type=parceria&#038;p=265", "0", "parceria", "", "0");
INSERT INTO `wp_posts` VALUES("266", "1", "2024-12-11 15:50:47", "2024-12-11 15:50:47", "", "Teste 5", "", "publish", "closed", "closed", "", "teste-5", "", "", "2024-12-11 15:50:47", "2024-12-11 15:50:47", "", "0", "https://batazu.digitalpath.pt/?post_type=parceria&#038;p=266", "0", "parceria", "", "0");
INSERT INTO `wp_posts` VALUES("267", "1", "2024-12-11 15:50:58", "2024-12-11 15:50:58", "", "Teste 6", "", "publish", "closed", "closed", "", "teste-6", "", "", "2024-12-11 15:50:58", "2024-12-11 15:50:58", "", "0", "https://batazu.digitalpath.pt/?post_type=parceria&#038;p=267", "0", "parceria", "", "0");
INSERT INTO `wp_posts` VALUES("268", "1", "2024-12-11 15:53:23", "2024-12-11 15:53:23", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23263b61%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"4/12\"][us_text text=\"Contactos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|map-marker-alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]fdsffgfdgd\r\nfgdfgdfgdffdgd[/vc_column_text][/us_hwrapper][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|phone\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"tel:00351000000000\">(+351) 000 000 000</a>\r\n<span style=\"font-size: 0.65rem !important; display: inline-block; color: #edf5fd !important;\">(Chamada para a rede fixa nacional)</span>[/vc_column_text][/us_hwrapper][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|envelope\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"mailto:geral@mail.pt\" target=\"_blank\" rel=\"noopener\">geral@mail.pt</a>[/vc_column_text][/us_hwrapper][/vc_column_inner][vc_column_inner width=\"5/12\"][us_text text=\"Receba a nossa newsletter\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]", "Footer PT", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2024-12-11 15:53:23", "2024-12-11 15:53:23", "", "15", "https://batazu.digitalpath.pt/?p=268", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("269", "1", "2024-12-11 15:53:47", "2024-12-11 15:53:47", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"4/12\"][us_text text=\"Contactos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|map-marker-alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]fdsffgfdgd\r\nfgdfgdfgdffdgd[/vc_column_text][/us_hwrapper][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|phone\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"tel:00351000000000\">(+351) 000 000 000</a>\r\n<span style=\"font-size: 0.65rem !important; display: inline-block; color: #edf5fd !important;\">(Chamada para a rede fixa nacional)</span>[/vc_column_text][/us_hwrapper][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|envelope\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"mailto:geral@mail.pt\" target=\"_blank\" rel=\"noopener\">geral@mail.pt</a>[/vc_column_text][/us_hwrapper][/vc_column_inner][vc_column_inner width=\"5/12\"][us_text text=\"Receba a nossa newsletter\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]", "Footer PT", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2024-12-11 15:53:47", "2024-12-11 15:53:47", "", "15", "https://batazu.digitalpath.pt/?p=269", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("270", "1", "2024-12-11 15:54:38", "2024-12-11 15:54:38", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"4/12\"][us_text text=\"Contactos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|map-marker-alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]fdsffgfdgd\r\nfgdfgdfgdffdgd[/vc_column_text][/us_hwrapper][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|phone\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"tel:00351000000000\">(+351) 000 000 000</a>\r\n<span style=\"font-size: 0.65rem !important; display: inline-block; color: #edf5fd !important;\">(Chamada para a rede fixa nacional)</span>[/vc_column_text][/us_hwrapper][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|envelope\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"mailto:geral@mail.pt\" target=\"_blank\" rel=\"noopener\">geral@mail.pt</a>[/vc_column_text][/us_hwrapper][/vc_column_inner][vc_column_inner width=\"5/12\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]", "Footer PT", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2024-12-11 15:54:38", "2024-12-11 15:54:38", "", "15", "https://batazu.digitalpath.pt/?p=270", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("271", "1", "2024-12-11 15:57:26", "2024-12-11 15:57:26", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"4/12\"][us_additional_menu main_gap=\"0.5rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" sub_items=\"1\" sub_gap=\"5px\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"5/12\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]", "Footer PT", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2024-12-11 15:57:26", "2024-12-11 15:57:26", "", "15", "https://batazu.digitalpath.pt/?p=271", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("272", "1", "2024-12-11 15:58:25", "2024-12-11 15:58:25", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"4/12\"][us_additional_menu main_gap=\"0.5rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"5/12\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]", "Footer PT", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2024-12-11 15:58:25", "2024-12-11 15:58:25", "", "15", "https://batazu.digitalpath.pt/?p=272", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("273", "1", "2024-12-11 16:01:13", "2024-12-11 16:01:13", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"4/12\"][us_additional_menu main_gap=\"0.3rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"5/12\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]", "Footer PT", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2024-12-11 16:01:13", "2024-12-11 16:01:13", "", "15", "https://batazu.digitalpath.pt/?p=273", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("274", "1", "2024-12-11 16:01:35", "2024-12-11 16:01:35", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"4/12\"][us_additional_menu main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"5/12\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]", "Footer PT", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2024-12-11 16:01:35", "2024-12-11 16:01:35", "", "15", "https://batazu.digitalpath.pt/?p=274", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("275", "1", "2024-12-11 16:03:58", "2024-12-11 16:03:58", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_additional_menu main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_additional_menu source=\"footer-2\" main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_image image=\"92\" size=\"full\" link=\"%7B%22url%22%3A%22https%3A%2F%2Fwww.livroreclamacoes.pt%2Finicio%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22123px%22%2C%22bottom%22%3A%220%22%2C%22right%22%3A%220%22%7D%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]", "Footer PT", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2024-12-11 16:03:58", "2024-12-11 16:03:58", "", "15", "https://batazu.digitalpath.pt/?p=275", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("276", "1", "2024-12-11 16:04:55", "2024-12-11 16:04:55", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/4\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column][vc_column width=\"1/4\"][us_additional_menu main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column][vc_column width=\"1/4\"][us_additional_menu source=\"footer-2\" main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column][vc_column width=\"1/4\"][us_image image=\"92\" size=\"full\" link=\"%7B%22url%22%3A%22https%3A%2F%2Fwww.livroreclamacoes.pt%2Finicio%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22123px%22%2C%22bottom%22%3A%220%22%2C%22right%22%3A%220%22%7D%7D\"][/vc_column][/vc_row][vc_row disable_element=\"yes\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_additional_menu main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_additional_menu source=\"footer-2\" main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_image image=\"92\" size=\"full\" link=\"%7B%22url%22%3A%22https%3A%2F%2Fwww.livroreclamacoes.pt%2Finicio%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22123px%22%2C%22bottom%22%3A%220%22%2C%22right%22%3A%220%22%7D%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]", "Footer PT", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2024-12-11 16:04:55", "2024-12-11 16:04:55", "", "15", "https://batazu.digitalpath.pt/?p=276", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("277", "1", "2024-12-11 16:05:55", "2024-12-11 16:05:55", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/4\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column][vc_column width=\"1/4\"][us_additional_menu main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column][vc_column width=\"2/4\"][us_additional_menu source=\"footer-2\" main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][us_image image=\"92\" size=\"full\" link=\"%7B%22url%22%3A%22https%3A%2F%2Fwww.livroreclamacoes.pt%2Finicio%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22123px%22%2C%22bottom%22%3A%220%22%2C%22right%22%3A%220%22%7D%7D\"][/vc_column][/vc_row][vc_row disable_element=\"yes\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_additional_menu main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_additional_menu source=\"footer-2\" main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_image image=\"92\" size=\"full\" link=\"%7B%22url%22%3A%22https%3A%2F%2Fwww.livroreclamacoes.pt%2Finicio%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22123px%22%2C%22bottom%22%3A%220%22%2C%22right%22%3A%220%22%7D%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]", "Footer PT", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2024-12-11 16:05:55", "2024-12-11 16:05:55", "", "15", "https://batazu.digitalpath.pt/?p=277", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("278", "1", "2024-12-11 16:06:47", "2024-12-11 16:06:47", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/4\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-left%22%3A%2210px%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%2C%22margin-left%22%3A%2210px%22%7D%7D\"][/vc_column][vc_column width=\"1/4\"][us_additional_menu main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column][vc_column width=\"2/4\"][us_additional_menu source=\"footer-2\" main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][us_image image=\"92\" size=\"full\" link=\"%7B%22url%22%3A%22https%3A%2F%2Fwww.livroreclamacoes.pt%2Finicio%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22123px%22%2C%22margin-top%22%3A%223rem%22%7D%7D\"][/vc_column][/vc_row][vc_row disable_element=\"yes\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_additional_menu main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_additional_menu source=\"footer-2\" main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_image image=\"92\" size=\"full\" link=\"%7B%22url%22%3A%22https%3A%2F%2Fwww.livroreclamacoes.pt%2Finicio%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22123px%22%2C%22bottom%22%3A%220%22%2C%22right%22%3A%220%22%7D%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]", "Footer PT", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2024-12-11 16:06:47", "2024-12-11 16:06:47", "", "15", "https://batazu.digitalpath.pt/?p=278", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("279", "1", "2024-12-11 16:08:46", "2024-12-11 16:08:46", "", "MID_btz_img-7", "", "inherit", "", "closed", "", "mid_btz_img-7", "", "", "2024-12-11 16:08:46", "2024-12-11 16:08:46", "", "15", "https://batazu.digitalpath.pt/wp-content/uploads/2023/02/MID_btz_img-7.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("280", "1", "2024-12-11 16:09:01", "2024-12-11 16:09:01", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22background-image%22%3A%22279%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/4\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-left%22%3A%2210px%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%2C%22margin-left%22%3A%2210px%22%7D%7D\"][/vc_column][vc_column width=\"1/4\"][us_additional_menu main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column][vc_column width=\"2/4\"][us_additional_menu source=\"footer-2\" main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][us_image image=\"92\" size=\"full\" link=\"%7B%22url%22%3A%22https%3A%2F%2Fwww.livroreclamacoes.pt%2Finicio%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22123px%22%2C%22margin-top%22%3A%223rem%22%7D%7D\"][/vc_column][/vc_row][vc_row disable_element=\"yes\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_heading%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"82\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fprofile.php%253Fid%253D100069900293483%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fbatazu_family%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fbatazu-family%252Fposts%252F%253FfeedView%253Dall%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_additional_menu main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_additional_menu source=\"footer-2\" main_gap=\"0.2rem\" main_color_text=\"_header_middle_bg\" main_color_text_hover=\"_content_bg_alt\" main_color_text_active=\"_content_bg_alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.8rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"3/12\"][us_image image=\"92\" size=\"full\" link=\"%7B%22url%22%3A%22https%3A%2F%2Fwww.livroreclamacoes.pt%2Finicio%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22123px%22%2C%22bottom%22%3A%220%22%2C%22right%22%3A%220%22%7D%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D