/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-10-15 09:09:18 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=328 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=313 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=833 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_cptemplates` (
  `template_id` bigint(20) NOT NULL,
  `request` varchar(50) NOT NULL,
  `priority` smallint(2) unsigned NOT NULL,
  `conditions` mediumblob NOT NULL,
  KEY `template_id` (`template_id`),
  KEY `request` (`request`),
  KEY `priority` (`priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dhvc_form_entry_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` bigint(20) unsigned NOT NULL,
  `post_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `form_url` varchar(512) NOT NULL,
  `referer` varchar(512) NOT NULL,
  `entry_data` longtext NOT NULL,
  `readed` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `submitted` datetime NOT NULL,
  `ip_address` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dhvc_form_entry_note` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `created` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=17163 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1246 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=595 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pp_activity_logs` (
  `id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `ip` varchar(55) NOT NULL,
  `browser` text NOT NULL,
  `status` tinytext NOT NULL,
  `created_at` varchar(55) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_us_filter_index` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` int(10) unsigned DEFAULT NULL,
  `filter_name` varchar(50) DEFAULT NULL,
  `filter_value` varchar(50) DEFAULT NULL,
  `term_id` int(10) unsigned DEFAULT 0,
  `parent_id` int(10) unsigned DEFAULT 0,
  `depth` tinyint(3) unsigned DEFAULT 0,
  `variation_id` int(10) unsigned DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `post_id` (`post_id`),
  KEY `filter_name` (`filter_name`),
  KEY `term_id` (`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21580 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("247", "woocommerce_cleanup_draft_orders", "complete", "2025-08-15 15:58:16", "2025-08-15 15:58:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755273496;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755273496;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-15 17:15:03", "2025-08-15 17:15:03", "166", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("251", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-15 16:20:20", "2025-08-15 16:20:20", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755274820;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755274820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-15 17:15:03", "2025-08-15 17:15:03", "166", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("252", "woocommerce_refresh_order_count_cache", "complete", "2025-08-15 22:14:59", "2025-08-15 22:14:59", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755296099;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755296099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-08-21 14:13:12", "2025-08-21 14:13:12", "169", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("253", "woocommerce_cleanup_draft_orders", "complete", "2025-08-16 17:15:03", "2025-08-16 17:15:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755364503;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755364503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-21 14:13:12", "2025-08-21 14:13:12", "169", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("254", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-16 17:15:03", "2025-08-16 17:15:03", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755364503;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755364503;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-21 14:13:12", "2025-08-21 14:13:12", "169", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("255", "woocommerce_refresh_order_count_cache", "complete", "2025-08-22 02:13:12", "2025-08-22 02:13:12", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755828792;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755828792;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-08-25 02:53:07", "2025-08-25 02:53:07", "172", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("256", "woocommerce_cleanup_draft_orders", "complete", "2025-08-22 14:13:12", "2025-08-22 14:13:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755871992;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755871992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-25 02:53:07", "2025-08-25 02:53:07", "172", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("257", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-22 14:13:12", "2025-08-22 14:13:12", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1755871992;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1755871992;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-25 02:53:07", "2025-08-25 02:53:07", "172", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("258", "woocommerce_refresh_order_count_cache", "complete", "2025-08-25 14:53:07", "2025-08-25 14:53:07", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756133587;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756133587;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-08-26 02:14:53", "2025-08-26 02:14:53", "177", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("259", "woocommerce_cleanup_draft_orders", "complete", "2025-08-26 02:53:07", "2025-08-26 02:53:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756176787;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756176787;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-26 03:46:31", "2025-08-26 03:46:31", "179", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("260", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-26 02:53:07", "2025-08-26 02:53:07", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756176787;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756176787;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-26 03:46:31", "2025-08-26 03:46:31", "179", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("261", "woocommerce_refresh_order_count_cache", "complete", "2025-08-26 14:14:53", "2025-08-26 14:14:53", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756217693;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756217693;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-08-26 14:34:59", "2025-08-26 14:34:59", "184", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("262", "woocommerce_cleanup_draft_orders", "complete", "2025-08-27 03:46:31", "2025-08-27 03:46:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756266391;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756266391;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-27 09:22:54", "2025-08-27 09:22:54", "200", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("263", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-27 03:46:31", "2025-08-27 03:46:31", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756266391;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756266391;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-27 09:22:54", "2025-08-27 09:22:54", "200", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("264", "woocommerce_refresh_order_count_cache", "complete", "2025-08-27 02:34:59", "2025-08-27 02:34:59", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756262099;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756262099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-08-27 09:22:54", "2025-08-27 09:22:54", "200", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("265", "woocommerce_refresh_order_count_cache", "complete", "2025-08-27 21:22:54", "2025-08-27 21:22:54", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756329774;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756329774;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-08-28 02:42:03", "2025-08-28 02:42:03", "217", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("266", "woocommerce_cleanup_draft_orders", "complete", "2025-08-28 09:22:54", "2025-08-28 09:22:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756372974;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756372974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-28 09:25:56", "2025-08-28 09:25:56", "219", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("267", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-28 09:22:54", "2025-08-28 09:22:54", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756372974;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756372974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-28 09:25:56", "2025-08-28 09:25:56", "219", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("268", "woocommerce_refresh_order_count_cache", "complete", "2025-08-28 14:42:03", "2025-08-28 14:42:03", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756392123;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756392123;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-08-29 02:02:57", "2025-08-29 02:02:57", "222", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("269", "woocommerce_cleanup_draft_orders", "complete", "2025-08-29 09:25:56", "2025-08-29 09:25:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756459556;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756459556;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-29 09:33:14", "2025-08-29 09:33:14", "224", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("270", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-29 09:25:56", "2025-08-29 09:25:56", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756459556;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756459556;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-29 09:33:14", "2025-08-29 09:33:14", "224", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("271", "woocommerce_refresh_order_count_cache", "complete", "2025-08-29 14:02:57", "2025-08-29 14:02:57", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756476177;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756476177;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-08-29 20:28:26", "2025-08-29 20:28:26", "229", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("272", "woocommerce_cleanup_draft_orders", "complete", "2025-08-30 09:33:14", "2025-08-30 09:33:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756546394;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756546394;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-08-30 16:43:27", "2025-08-30 16:43:27", "235", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("273", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-30 09:33:14", "2025-08-30 09:33:14", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756546394;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756546394;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-08-30 16:43:27", "2025-08-30 16:43:27", "235", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("274", "woocommerce_refresh_order_count_cache", "complete", "2025-08-30 08:28:26", "2025-08-30 08:28:26", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756542506;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756542506;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-08-30 16:43:27", "2025-08-30 16:43:27", "235", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("275", "woocommerce_refresh_order_count_cache", "complete", "2025-08-31 04:43:27", "2025-08-31 04:43:27", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756615407;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756615407;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-08-31 05:35:41", "2025-08-31 05:35:41", "239", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("276", "woocommerce_cleanup_draft_orders", "complete", "2025-08-31 16:43:27", "2025-08-31 16:43:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756658607;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756658607;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-01 02:50:04", "2025-09-01 02:50:04", "242", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("277", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-08-31 16:43:27", "2025-08-31 16:43:27", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756658607;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756658607;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-09-01 02:50:04", "2025-09-01 02:50:04", "242", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("278", "woocommerce_refresh_order_count_cache", "complete", "2025-08-31 17:35:41", "2025-08-31 17:35:41", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756661741;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756661741;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-09-01 02:50:04", "2025-09-01 02:50:04", "242", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("279", "woocommerce_cleanup_draft_orders", "complete", "2025-09-02 02:50:04", "2025-09-02 02:50:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756781404;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756781404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-02 07:13:00", "2025-09-02 07:13:00", "246", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("280", "woocommerce_refresh_order_count_cache", "complete", "2025-09-01 14:50:04", "2025-09-01 14:50:04", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756738204;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756738204;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-09-01 23:49:17", "2025-09-01 23:49:17", "244", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("281", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-02 02:50:04", "2025-09-02 02:50:04", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756781404;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756781404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-09-02 07:13:00", "2025-09-02 07:13:00", "246", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("282", "woocommerce_refresh_order_count_cache", "complete", "2025-09-02 11:49:17", "2025-09-02 11:49:17", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756813757;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756813757;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-09-03 06:18:35", "2025-09-03 06:18:35", "248", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("283", "woocommerce_cleanup_draft_orders", "complete", "2025-09-03 07:13:00", "2025-09-03 07:13:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756883580;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756883580;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-03 07:54:29", "2025-09-03 07:54:29", "251", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("284", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-03 07:13:00", "2025-09-03 07:13:00", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756883580;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756883580;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-09-03 07:54:29", "2025-09-03 07:54:29", "251", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("285", "woocommerce_refresh_order_count_cache", "complete", "2025-09-03 18:18:35", "2025-09-03 18:18:35", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756923515;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756923515;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-09-04 00:18:42", "2025-09-04 00:18:42", "254", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("286", "woocommerce_cleanup_draft_orders", "complete", "2025-09-04 07:54:29", "2025-09-04 07:54:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756972469;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756972469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-05 09:40:58", "2025-09-05 09:40:58", "259", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("287", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-04 07:54:29", "2025-09-04 07:54:29", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756972469;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756972469;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-09-05 09:40:58", "2025-09-05 09:40:58", "259", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("288", "woocommerce_refresh_order_count_cache", "complete", "2025-09-04 12:18:42", "2025-09-04 12:18:42", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1756988322;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1756988322;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-09-05 09:40:58", "2025-09-05 09:40:58", "259", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("289", "woocommerce_cleanup_draft_orders", "complete", "2025-09-06 09:40:58", "2025-09-06 09:40:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757151658;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757151658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-07 14:44:09", "2025-09-07 14:44:09", "264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("290", "woocommerce_refresh_order_count_cache", "complete", "2025-09-05 21:40:58", "2025-09-05 21:40:58", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757108458;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757108458;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-09-07 14:44:09", "2025-09-07 14:44:09", "264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("291", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-06 09:40:58", "2025-09-06 09:40:58", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757151658;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757151658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-09-07 14:44:09", "2025-09-07 14:44:09", "264", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("292", "woocommerce_refresh_order_count_cache", "complete", "2025-09-08 02:44:09", "2025-09-08 02:44:09", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757299449;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757299449;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-09-08 03:36:02", "2025-09-08 03:36:02", "267", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("293", "woocommerce_cleanup_draft_orders", "complete", "2025-09-08 14:44:09", "2025-09-08 14:44:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757342649;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757342649;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-09 15:28:12", "2025-09-09 15:28:12", "269", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("294", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-08 14:44:09", "2025-09-08 14:44:09", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757342649;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757342649;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-09-09 15:28:12", "2025-09-09 15:28:12", "269", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("295", "woocommerce_refresh_order_count_cache", "complete", "2025-09-08 15:36:02", "2025-09-08 15:36:02", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757345762;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757345762;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-09-09 15:28:12", "2025-09-09 15:28:12", "269", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("296", "woocommerce_cleanup_draft_orders", "complete", "2025-09-10 15:28:12", "2025-09-10 15:28:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757518092;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757518092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-10 16:41:02", "2025-09-10 16:41:02", "272", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("297", "woocommerce_refresh_order_count_cache", "complete", "2025-09-10 03:28:12", "2025-09-10 03:28:12", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757474892;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757474892;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-09-10 16:41:02", "2025-09-10 16:41:02", "272", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("298", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-10 15:28:12", "2025-09-10 15:28:12", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757518092;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757518092;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-09-10 16:41:02", "2025-09-10 16:41:02", "272", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("299", "woocommerce_refresh_order_count_cache", "complete", "2025-09-11 04:41:02", "2025-09-11 04:41:02", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757565662;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757565662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-09-11 13:43:31", "2025-09-11 13:43:31", "275", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("300", "woocommerce_cleanup_draft_orders", "complete", "2025-09-11 16:41:02", "2025-09-11 16:41:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757608862;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757608862;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-11 16:56:57", "2025-09-11 16:56:57", "278", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("301", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-11 16:41:02", "2025-09-11 16:41:02", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757608862;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757608862;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-09-11 16:56:57", "2025-09-11 16:56:57", "278", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("302", "woocommerce_refresh_order_count_cache", "complete", "2025-09-12 01:43:31", "2025-09-12 01:43:31", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757641411;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757641411;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-09-15 00:39:20", "2025-09-15 00:39:20", "302", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("303", "woocommerce_cleanup_draft_orders", "complete", "2025-09-12 16:56:57", "2025-09-12 16:56:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757696217;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757696217;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-09-15 00:39:20", "2025-09-15 00:39:20", "302", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("304", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-12 16:56:57", "2025-09-12 16:56:57", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757696217;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757696217;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2025-09-15 00:39:20", "2025-09-15 00:39:20", "302", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("305", "fetch_patterns", "complete", "2025-09-11 16:58:07", "2025-09-11 16:58:07", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757609887;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757609887;}", "2", "1", "2025-09-11 16:59:02", "2025-09-11 16:59:02", "281", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("306", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-09-11 16:59:01", "2025-09-11 16:59:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757609941;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757609941;}", "3", "1", "2025-09-11 16:59:03", "2025-09-11 16:59:03", "281", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("307", "woocommerce_refresh_order_count_cache", "complete", "2025-09-15 12:39:20", "2025-09-15 12:39:20", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757939960;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757939960;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "1", "2025-09-15 13:54:04", "2025-09-15 13:54:04", "305", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("308", "woocommerce_cleanup_draft_orders", "canceled", "2025-09-16 00:39:20", "2025-09-16 00:39:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757983160;s:18:\"\0*\0first_timestamp\";i:1732297338;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757983160;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("309", "woocommerce_scheduled_sales", "pending", "2025-09-16 00:00:00", "2025-09-16 00:00:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757980800;s:18:\"\0*\0first_timestamp\";i:1757980800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757980800;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("310", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-15 01:39:20", "2025-09-15 01:39:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757900360;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757900360;}", "7", "1", "2025-09-15 13:54:04", "2025-09-15 13:54:04", "305", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("311", "woocommerce_cleanup_personal_data", "complete", "2025-09-15 00:39:30", "2025-09-15 00:39:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757896770;s:18:\"\0*\0first_timestamp\";i:1757896770;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757896770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-09-15 13:54:04", "2025-09-15 13:54:04", "305", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("312", "woocommerce_cleanup_logs", "complete", "2025-09-15 03:39:20", "2025-09-15 03:39:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757907560;s:18:\"\0*\0first_timestamp\";i:1757907560;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757907560;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-09-15 13:54:04", "2025-09-15 13:54:04", "305", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("313", "woocommerce_cleanup_sessions", "complete", "2025-09-15 06:39:20", "2025-09-15 06:39:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757918360;s:18:\"\0*\0first_timestamp\";i:1757918360;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757918360;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "1", "2025-09-15 13:54:04", "2025-09-15 13:54:04", "305", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("314", "woocommerce_geoip_updater", "complete", "2025-09-15 00:40:20", "2025-09-15 00:40:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757896820;s:18:\"\0*\0first_timestamp\";i:1757896820;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757896820;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "7", "1", "2025-09-15 13:54:04", "2025-09-15 13:54:04", "305", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("315", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-15 03:39:20", "2025-09-15 03:39:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757907560;s:18:\"\0*\0first_timestamp\";i:1757907560;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757907560;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-09-15 13:54:04", "2025-09-15 13:54:04", "305", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("316", "wc_admin_daily_wrapper", "complete", "2025-09-15 00:39:20", "2025-09-15 00:39:20", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757896760;s:18:\"\0*\0first_timestamp\";i:1757896760;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757896760;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "1", "2025-09-15 00:39:21", "2025-09-15 00:39:21", "303", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("317", "generate_category_lookup_table_wrapper", "complete", "2025-09-15 00:39:30", "2025-09-15 00:39:30", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757896770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757896770;}", "7", "1", "2025-09-15 13:54:04", "2025-09-15 13:54:04", "305", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("318", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-09-16 00:39:20", "2025-09-16 00:39:20", "20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757983160;s:18:\"\0*\0first_timestamp\";i:1755188418;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757983160;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("319", "wc_admin_daily_wrapper", "pending", "2025-09-16 00:39:21", "2025-09-16 00:39:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757983161;s:18:\"\0*\0first_timestamp\";i:1757896760;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757983161;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("320", "woocommerce_cleanup_personal_data", "pending", "2025-09-16 13:54:04", "2025-09-16 13:54:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758030844;s:18:\"\0*\0first_timestamp\";i:1757896770;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758030844;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("321", "woocommerce_geoip_updater", "pending", "2025-09-30 13:54:04", "2025-09-30 13:54:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759240444;s:18:\"\0*\0first_timestamp\";i:1757896820;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759240444;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("322", "woocommerce_cancel_unpaid_orders", "pending", "2025-09-15 14:54:04", "2025-09-15 14:54:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757948044;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757948044;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("323", "woocommerce_cleanup_logs", "pending", "2025-09-16 13:54:04", "2025-09-16 13:54:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758030844;s:18:\"\0*\0first_timestamp\";i:1757907560;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758030844;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("324", "woocommerce_cleanup_rate_limits_wrapper", "pending", "2025-09-16 13:54:04", "2025-09-16 13:54:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758030844;s:18:\"\0*\0first_timestamp\";i:1757907560;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758030844;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("325", "woocommerce_cleanup_sessions", "pending", "2025-09-16 01:54:04", "2025-09-16 01:54:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757987644;s:18:\"\0*\0first_timestamp\";i:1757918360;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757987644;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("326", "woocommerce_refresh_order_count_cache", "canceled", "2025-09-16 01:54:04", "2025-09-16 01:54:04", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757987644;s:18:\"\0*\0first_timestamp\";i:1752897371;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757987644;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("327", "action_scheduler/migration_hook", "pending", "2025-09-15 14:11:31", "2025-09-15 14:11:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757945491;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757945491;}", "1", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "count");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "ActionScheduler");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "woocommerce");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("608", "247", "acção criada", "2025-08-14 15:58:16", "2025-08-14 15:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("618", "251", "acção criada", "2025-08-14 16:20:20", "2025-08-14 16:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("621", "252", "acção criada", "2025-08-15 10:14:59", "2025-08-15 10:14:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("622", "247", "action started via WP Cron", "2025-08-15 17:15:03", "2025-08-15 17:15:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("623", "247", "acção concluída via WP Cron", "2025-08-15 17:15:03", "2025-08-15 17:15:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("624", "253", "acção criada", "2025-08-15 17:15:03", "2025-08-15 17:15:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("625", "251", "action started via WP Cron", "2025-08-15 17:15:03", "2025-08-15 17:15:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("626", "251", "acção concluída via WP Cron", "2025-08-15 17:15:03", "2025-08-15 17:15:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("627", "254", "acção criada", "2025-08-15 17:15:03", "2025-08-15 17:15:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("628", "252", "action started via WP Cron", "2025-08-21 14:13:11", "2025-08-21 14:13:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("629", "252", "acção concluída via WP Cron", "2025-08-21 14:13:12", "2025-08-21 14:13:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("630", "255", "acção criada", "2025-08-21 14:13:12", "2025-08-21 14:13:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("631", "253", "action started via WP Cron", "2025-08-21 14:13:12", "2025-08-21 14:13:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("632", "253", "acção concluída via WP Cron", "2025-08-21 14:13:12", "2025-08-21 14:13:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("633", "256", "acção criada", "2025-08-21 14:13:12", "2025-08-21 14:13:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("634", "254", "action started via WP Cron", "2025-08-21 14:13:12", "2025-08-21 14:13:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("635", "254", "acção concluída via WP Cron", "2025-08-21 14:13:12", "2025-08-21 14:13:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("636", "257", "acção criada", "2025-08-21 14:13:12", "2025-08-21 14:13:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("637", "255", "action started via WP Cron", "2025-08-25 02:53:07", "2025-08-25 02:53:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("638", "255", "acção concluída via WP Cron", "2025-08-25 02:53:07", "2025-08-25 02:53:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("639", "258", "acção criada", "2025-08-25 02:53:07", "2025-08-25 02:53:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("640", "256", "action started via WP Cron", "2025-08-25 02:53:07", "2025-08-25 02:53:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("641", "256", "acção concluída via WP Cron", "2025-08-25 02:53:07", "2025-08-25 02:53:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("642", "259", "acção criada", "2025-08-25 02:53:07", "2025-08-25 02:53:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("643", "257", "action started via WP Cron", "2025-08-25 02:53:07", "2025-08-25 02:53:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("644", "257", "acção concluída via WP Cron", "2025-08-25 02:53:07", "2025-08-25 02:53:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("645", "260", "acção criada", "2025-08-25 02:53:07", "2025-08-25 02:53:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("646", "258", "action started via WP Cron", "2025-08-26 02:14:53", "2025-08-26 02:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("647", "258", "acção concluída via WP Cron", "2025-08-26 02:14:53", "2025-08-26 02:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("648", "261", "acção criada", "2025-08-26 02:14:53", "2025-08-26 02:14:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("649", "259", "action started via WP Cron", "2025-08-26 03:46:31", "2025-08-26 03:46:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("650", "259", "acção concluída via WP Cron", "2025-08-26 03:46:31", "2025-08-26 03:46:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("651", "262", "acção criada", "2025-08-26 03:46:31", "2025-08-26 03:46:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("652", "260", "action started via WP Cron", "2025-08-26 03:46:31", "2025-08-26 03:46:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("653", "260", "acção concluída via WP Cron", "2025-08-26 03:46:31", "2025-08-26 03:46:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("654", "263", "acção criada", "2025-08-26 03:46:31", "2025-08-26 03:46:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("655", "261", "action started via WP Cron", "2025-08-26 14:34:59", "2025-08-26 14:34:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("656", "261", "acção concluída via WP Cron", "2025-08-26 14:34:59", "2025-08-26 14:34:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("657", "264", "acção criada", "2025-08-26 14:34:59", "2025-08-26 14:34:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("658", "264", "action started via WP Cron", "2025-08-27 09:22:54", "2025-08-27 09:22:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("659", "264", "acção concluída via WP Cron", "2025-08-27 09:22:54", "2025-08-27 09:22:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("660", "265", "acção criada", "2025-08-27 09:22:54", "2025-08-27 09:22:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("661", "262", "action started via WP Cron", "2025-08-27 09:22:54", "2025-08-27 09:22:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("662", "262", "acção concluída via WP Cron", "2025-08-27 09:22:54", "2025-08-27 09:22:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("663", "266", "acção criada", "2025-08-27 09:22:54", "2025-08-27 09:22:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("664", "263", "action started via WP Cron", "2025-08-27 09:22:54", "2025-08-27 09:22:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("665", "263", "acção concluída via WP Cron", "2025-08-27 09:22:54", "2025-08-27 09:22:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("666", "267", "acção criada", "2025-08-27 09:22:54", "2025-08-27 09:22:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("667", "265", "action started via WP Cron", "2025-08-28 02:42:03", "2025-08-28 02:42:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("668", "265", "acção concluída via WP Cron", "2025-08-28 02:42:03", "2025-08-28 02:42:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("669", "268", "acção criada", "2025-08-28 02:42:03", "2025-08-28 02:42:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("670", "266", "action started via WP Cron", "2025-08-28 09:25:56", "2025-08-28 09:25:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("671", "266", "acção concluída via WP Cron", "2025-08-28 09:25:56", "2025-08-28 09:25:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("672", "269", "acção criada", "2025-08-28 09:25:56", "2025-08-28 09:25:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("673", "267", "action started via WP Cron", "2025-08-28 09:25:56", "2025-08-28 09:25:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("674", "267", "acção concluída via WP Cron", "2025-08-28 09:25:56", "2025-08-28 09:25:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("675", "270", "acção criada", "2025-08-28 09:25:56", "2025-08-28 09:25:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("676", "268", "action started via WP Cron", "2025-08-29 02:02:57", "2025-08-29 02:02:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("677", "268", "acção concluída via WP Cron", "2025-08-29 02:02:57", "2025-08-29 02:02:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("678", "271", "acção criada", "2025-08-29 02:02:57", "2025-08-29 02:02:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("679", "269", "action started via WP Cron", "2025-08-29 09:33:14", "2025-08-29 09:33:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("680", "269", "acção concluída via WP Cron", "2025-08-29 09:33:14", "2025-08-29 09:33:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("681", "272", "acção criada", "2025-08-29 09:33:14", "2025-08-29 09:33:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("682", "270", "action started via WP Cron", "2025-08-29 09:33:14", "2025-08-29 09:33:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("683", "270", "acção concluída via WP Cron", "2025-08-29 09:33:14", "2025-08-29 09:33:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("684", "273", "acção criada", "2025-08-29 09:33:14", "2025-08-29 09:33:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("685", "271", "action started via WP Cron", "2025-08-29 20:28:25", "2025-08-29 20:28:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("686", "271", "acção concluída via WP Cron", "2025-08-29 20:28:26", "2025-08-29 20:28:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("687", "274", "acção criada", "2025-08-29 20:28:26", "2025-08-29 20:28:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("688", "274", "action started via WP Cron", "2025-08-30 16:43:27", "2025-08-30 16:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("689", "274", "acção concluída via WP Cron", "2025-08-30 16:43:27", "2025-08-30 16:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("690", "275", "acção criada", "2025-08-30 16:43:27", "2025-08-30 16:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("691", "272", "action started via WP Cron", "2025-08-30 16:43:27", "2025-08-30 16:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("692", "272", "acção concluída via WP Cron", "2025-08-30 16:43:27", "2025-08-30 16:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("693", "276", "acção criada", "2025-08-30 16:43:27", "2025-08-30 16:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("694", "273", "action started via WP Cron", "2025-08-30 16:43:27", "2025-08-30 16:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("695", "273", "acção concluída via WP Cron", "2025-08-30 16:43:27", "2025-08-30 16:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("696", "277", "acção criada", "2025-08-30 16:43:27", "2025-08-30 16:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("697", "275", "action started via WP Cron", "2025-08-31 05:35:41", "2025-08-31 05:35:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("698", "275", "acção concluída via WP Cron", "2025-08-31 05:35:41", "2025-08-31 05:35:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("699", "278", "acção criada", "2025-08-31 05:35:41", "2025-08-31 05:35:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("700", "276", "action started via WP Cron", "2025-09-01 02:50:04", "2025-09-01 02:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("701", "276", "acção concluída via WP Cron", "2025-09-01 02:50:04", "2025-09-01 02:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("702", "279", "acção criada", "2025-09-01 02:50:04", "2025-09-01 02:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("703", "278", "action started via WP Cron", "2025-09-01 02:50:04", "2025-09-01 02:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("704", "278", "acção concluída via WP Cron", "2025-09-01 02:50:04", "2025-09-01 02:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("705", "280", "acção criada", "2025-09-01 02:50:04", "2025-09-01 02:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("706", "277", "action started via WP Cron", "2025-09-01 02:50:04", "2025-09-01 02:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("707", "277", "acção concluída via WP Cron", "2025-09-01 02:50:04", "2025-09-01 02:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("708", "281", "acção criada", "2025-09-01 02:50:04", "2025-09-01 02:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("709", "280", "action started via WP Cron", "2025-09-01 23:49:17", "2025-09-01 23:49:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("710", "280", "acção concluída via WP Cron", "2025-09-01 23:49:17", "2025-09-01 23:49:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("711", "282", "acção criada", "2025-09-01 23:49:17", "2025-09-01 23:49:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("712", "279", "action started via WP Cron", "2025-09-02 07:13:00", "2025-09-02 07:13:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("713", "279", "acção concluída via WP Cron", "2025-09-02 07:13:00", "2025-09-02 07:13:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("714", "283", "acção criada", "2025-09-02 07:13:00", "2025-09-02 07:13:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("715", "281", "action started via WP Cron", "2025-09-02 07:13:00", "2025-09-02 07:13:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("716", "281", "acção concluída via WP Cron", "2025-09-02 07:13:00", "2025-09-02 07:13:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("717", "284", "acção criada", "2025-09-02 07:13:00", "2025-09-02 07:13:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("718", "282", "action started via WP Cron", "2025-09-03 06:18:35", "2025-09-03 06:18:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("719", "282", "acção concluída via WP Cron", "2025-09-03 06:18:35", "2025-09-03 06:18:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("720", "285", "acção criada", "2025-09-03 06:18:35", "2025-09-03 06:18:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("721", "283", "action started via WP Cron", "2025-09-03 07:54:29", "2025-09-03 07:54:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("722", "283", "acção concluída via WP Cron", "2025-09-03 07:54:29", "2025-09-03 07:54:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("723", "286", "acção criada", "2025-09-03 07:54:29", "2025-09-03 07:54:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("724", "284", "action started via WP Cron", "2025-09-03 07:54:29", "2025-09-03 07:54:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("725", "284", "acção concluída via WP Cron", "2025-09-03 07:54:29", "2025-09-03 07:54:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("726", "287", "acção criada", "2025-09-03 07:54:29", "2025-09-03 07:54:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("727", "285", "action started via WP Cron", "2025-09-04 00:18:42", "2025-09-04 00:18:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("728", "285", "acção concluída via WP Cron", "2025-09-04 00:18:42", "2025-09-04 00:18:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("729", "288", "acção criada", "2025-09-04 00:18:42", "2025-09-04 00:18:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("730", "286", "action started via WP Cron", "2025-09-05 09:40:58", "2025-09-05 09:40:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("731", "286", "acção concluída via WP Cron", "2025-09-05 09:40:58", "2025-09-05 09:40:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("732", "289", "acção criada", "2025-09-05 09:40:58", "2025-09-05 09:40:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("733", "288", "action started via WP Cron", "2025-09-05 09:40:58", "2025-09-05 09:40:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("734", "288", "acção concluída via WP Cron", "2025-09-05 09:40:58", "2025-09-05 09:40:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("735", "290", "acção criada", "2025-09-05 09:40:58", "2025-09-05 09:40:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("736", "287", "action started via WP Cron", "2025-09-05 09:40:58", "2025-09-05 09:40:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("737", "287", "acção concluída via WP Cron", "2025-09-05 09:40:58", "2025-09-05 09:40:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("738", "291", "acção criada", "2025-09-05 09:40:58", "2025-09-05 09:40:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("739", "290", "action started via WP Cron", "2025-09-07 14:44:09", "2025-09-07 14:44:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("740", "290", "acção concluída via WP Cron", "2025-09-07 14:44:09", "2025-09-07 14:44:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("741", "292", "acção criada", "2025-09-07 14:44:09", "2025-09-07 14:44:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("742", "289", "action started via WP Cron", "2025-09-07 14:44:09", "2025-09-07 14:44:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("743", "289", "acção concluída via WP Cron", "2025-09-07 14:44:09", "2025-09-07 14:44:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("744", "293", "acção criada", "2025-09-07 14:44:09", "2025-09-07 14:44:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("745", "291", "action started via WP Cron", "2025-09-07 14:44:09", "2025-09-07 14:44:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("746", "291", "acção concluída via WP Cron", "2025-09-07 14:44:09", "2025-09-07 14:44:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("747", "294", "acção criada", "2025-09-07 14:44:09", "2025-09-07 14:44:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("748", "292", "action started via WP Cron", "2025-09-08 03:36:02", "2025-09-08 03:36:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("749", "292", "acção concluída via WP Cron", "2025-09-08 03:36:02", "2025-09-08 03:36:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("750", "295", "acção criada", "2025-09-08 03:36:02", "2025-09-08 03:36:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("751", "293", "action started via WP Cron", "2025-09-09 15:28:12", "2025-09-09 15:28:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("752", "293", "acção concluída via WP Cron", "2025-09-09 15:28:12", "2025-09-09 15:28:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("753", "296", "acção criada", "2025-09-09 15:28:12", "2025-09-09 15:28:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("754", "295", "action started via WP Cron", "2025-09-09 15:28:12", "2025-09-09 15:28:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("755", "295", "acção concluída via WP Cron", "2025-09-09 15:28:12", "2025-09-09 15:28:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("756", "297", "acção criada", "2025-09-09 15:28:12", "2025-09-09 15:28:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("757", "294", "action started via WP Cron", "2025-09-09 15:28:12", "2025-09-09 15:28:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("758", "294", "acção concluída via WP Cron", "2025-09-09 15:28:12", "2025-09-09 15:28:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("759", "298", "acção criada", "2025-09-09 15:28:12", "2025-09-09 15:28:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("760", "297", "action started via WP Cron", "2025-09-10 16:41:02", "2025-09-10 16:41:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("761", "297", "acção concluída via WP Cron", "2025-09-10 16:41:02", "2025-09-10 16:41:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("762", "299", "acção criada", "2025-09-10 16:41:02", "2025-09-10 16:41:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("763", "296", "action started via WP Cron", "2025-09-10 16:41:02", "2025-09-10 16:41:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("764", "296", "acção concluída via WP Cron", "2025-09-10 16:41:02", "2025-09-10 16:41:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("765", "300", "acção criada", "2025-09-10 16:41:02", "2025-09-10 16:41:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("766", "298", "action started via WP Cron", "2025-09-10 16:41:02", "2025-09-10 16:41:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("767", "298", "acção concluída via WP Cron", "2025-09-10 16:41:02", "2025-09-10 16:41:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("768", "301", "acção criada", "2025-09-10 16:41:02", "2025-09-10 16:41:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("769", "299", "action started via WP Cron", "2025-09-11 13:43:31", "2025-09-11 13:43:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("770", "299", "acção concluída via WP Cron", "2025-09-11 13:43:31", "2025-09-11 13:43:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("771", "302", "acção criada", "2025-09-11 13:43:31", "2025-09-11 13:43:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("772", "300", "action started via WP Cron", "2025-09-11 16:56:57", "2025-09-11 16:56:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("773", "300", "acção concluída via WP Cron", "2025-09-11 16:56:57", "2025-09-11 16:56:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("774", "303", "acção criada", "2025-09-11 16:56:57", "2025-09-11 16:56:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("775", "301", "action started via WP Cron", "2025-09-11 16:56:57", "2025-09-11 16:56:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("776", "301", "acção concluída via WP Cron", "2025-09-11 16:56:57", "2025-09-11 16:56:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("777", "304", "acção criada", "2025-09-11 16:56:57", "2025-09-11 16:56:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("778", "305", "acção criada", "2025-09-11 16:58:07", "2025-09-11 16:58:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("779", "306", "acção criada", "2025-09-11 16:59:01", "2025-09-11 16:59:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("780", "305", "action started via WP Cron", "2025-09-11 16:59:02", "2025-09-11 16:59:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("781", "305", "acção concluída via WP Cron", "2025-09-11 16:59:02", "2025-09-11 16:59:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("782", "306", "action started via WP Cron", "2025-09-11 16:59:02", "2025-09-11 16:59:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("783", "306", "acção concluída via WP Cron", "2025-09-11 16:59:03", "2025-09-11 16:59:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("784", "302", "action started via WP Cron", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("785", "302", "acção concluída via WP Cron", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("786", "307", "acção criada", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("787", "303", "action started via WP Cron", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("788", "303", "acção concluída via WP Cron", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("789", "308", "acção criada", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("790", "304", "action started via WP Cron", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("791", "309", "acção criada", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("792", "310", "acção criada", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("793", "311", "acção criada", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("794", "312", "acção criada", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("795", "313", "acção criada", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("796", "314", "acção criada", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("797", "315", "acção criada", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("798", "316", "acção criada", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("799", "317", "acção criada", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("800", "304", "acção concluída via WP Cron", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("801", "318", "acção criada", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("802", "316", "action started via WP Cron", "2025-09-15 00:39:20", "2025-09-15 00:39:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("803", "316", "acção concluída via WP Cron", "2025-09-15 00:39:21", "2025-09-15 00:39:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("804", "319", "acção criada", "2025-09-15 00:39:21", "2025-09-15 00:39:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("805", "311", "action started via WP Cron", "2025-09-15 13:54:03", "2025-09-15 13:54:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("806", "311", "acção concluída via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("807", "320", "acção criada", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("808", "317", "action started via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("809", "317", "acção concluída via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("810", "314", "action started via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("811", "314", "acção concluída via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("812", "321", "acção criada", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("813", "310", "action started via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("814", "322", "acção criada", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("815", "310", "acção concluída via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("816", "312", "action started via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("817", "312", "acção concluída via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("818", "323", "acção criada", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("819", "315", "action started via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("820", "315", "acção concluída via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("821", "324", "acção criada", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("822", "313", "action started via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("823", "313", "acção concluída via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("824", "325", "acção criada", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("825", "307", "action started via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("826", "307", "acção concluída via WP Cron", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("827", "326", "acção criada", "2025-09-15 13:54:04", "2025-09-15 13:54:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("828", "327", "acção criada", "2025-09-15 14:10:31", "2025-09-15 14:10:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("829", "326", "acção cancelada", "2025-09-15 14:10:58", "2025-09-15 14:10:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("830", "326", "acção cancelada", "2025-09-15 14:10:58", "2025-09-15 14:10:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("831", "308", "acção cancelada", "2025-09-15 14:10:58", "2025-09-15 14:10:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("832", "308", "acção cancelada", "2025-09-15 14:10:58", "2025-09-15 14:10:58");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "Um comentador do WordPress", "wapuu@wordpress.example", "https://pt.wordpress.org/", "", "2023-02-13 23:22:36", "2023-02-13 23:22:36", "Olá, isto é um comentário.\nPara começar a moderar, editar e eliminar comentários, por favor visite o ecrã de comentários no painel.\nOs avatares dos comentadores são do <a href=\"https://pt.gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("62", "20230214_midtemplate", "aae4edf98103666b1861_20251015090854", "21", "2025-10-15 09:09:18", "miduswer4", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-15 09:08:54\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:7:\"10.6.23\";s:10:\"VersionPHP\";s:6:\"8.3.26\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:62;s:4:\"Name\";s:20:\"20230214_midtemplate\";s:4:\"Hash\";s:35:\"aae4edf98103666b1861_20251015090854\";s:8:\"NameHash\";s:56:\"20230214_midtemplate_aae4edf98103666b1861_20251015090854\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:66:\"20230214_midtemplate_aae4edf98103666b1861_20251015090854_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.8\";s:6:\"WPUser\";s:9:\"miduswer4\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:68:\"20230214_midtemplate_aae4edf98103666b1861_20251015090854_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:34:\"/home/subverti/public_html/xpharma\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1898;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:13569;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-15 09:08:54\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:7:\"10.6.23\";s:10:\"VersionPHP\";s:6:\"8.3.26\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20230214_midtemplate\";s:4:\"Hash\";s:35:\"aae4edf98103666b1861_20251015090854\";s:8:\"NameHash\";s:56:\"20230214_midtemplate_aae4edf98103666b1861_20251015090854\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:74:\"20230214_midtemplate_aae4edf98103666b1861_20251015090854_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:48:\"/home/subverti/public_html/xpharma/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:69:\"20230214_midtemplate_aae4edf98103666b1861_20251015090854_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:136:\"/home/subverti/public_html/xpharma/wp-content/backups-dup-lite/tmp/20230214_midtemplate_aae4edf98103666b1861_20251015090854_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:43:\"/home/subverti/public_html/xpharma/wp-admin\";i:1;s:46:\"/home/subverti/public_html/xpharma/wp-includes\";i:2;s:55:\"/home/subverti/public_html/xpharma/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:34:\"/home/subverti/public_html/xpharma\";i:1;s:34:\"/home/subverti/public_html/xpharma\";i:2;s:45:\"/home/subverti/public_html/xpharma/wp-content\";i:3;s:53:\"/home/subverti/public_html/xpharma/wp-content/uploads\";i:4;s:53:\"/home/subverti/public_html/xpharma/wp-content/plugins\";i:5;s:56:\"/home/subverti/public_html/xpharma/wp-content/mu-plugins\";i:6;s:52:\"/home/subverti/public_html/xpharma/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:66:\"/home/subverti/public_html/xpharma/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://xpharma.digitalpath.pt/xpharma", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://xpharma.digitalpath.pt/xpharma", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "XPharma", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Especialistas na procura de medicamentos de difícil acesso", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "it@makeitdigital.pt", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "j \\d\\e F, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "G:i", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "j F, Y G:i", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:10:{i:0;s:21:\"polylang/polylang.php\";i:1;s:30:\"advanced-custom-fields/acf.php\";i:2;s:23:\"dhvc-form/dhvc-form.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:25:\"duplicator/duplicator.php\";i:5;s:27:\"js_composer/js_composer.php\";i:6;s:23:\"loco-translate/loco.php\";i:7;s:41:\"password-protected/password-protected.php\";i:8;s:35:\"rc_particlebackground/vc_extend.php\";i:9;s:19:\"us-core/us-core.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "Impreza", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "makeitdigital", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "60421", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "0", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "130", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "90", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1773496493", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:161:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:13:\"edit_dhvcform\";b:1;s:13:\"read_dhvcform\";b:1;s:15:\"delete_dhvcform\";b:1;s:14:\"edit_dhvcforms\";b:1;s:21:\"edit_others_dhvcforms\";b:1;s:17:\"publish_dhvcforms\";b:1;s:22:\"read_private_dhvcforms\";b:1;s:16:\"delete_dhvcforms\";b:1;s:24:\"delete_private_dhvcforms\";b:1;s:26:\"delete_published_dhvcforms\";b:1;s:23:\"delete_others_dhvcforms\";b:1;s:22:\"edit_private_dhvcforms\";b:1;s:24:\"edit_published_dhvcforms\";b:1;s:9:\"edit_post\";b:1;s:9:\"read_post\";b:1;s:11:\"delete_post\";b:1;s:18:\"edit_us_page_block\";b:1;s:18:\"read_us_page_block\";b:1;s:20:\"delete_us_page_block\";b:1;s:19:\"edit_us_page_blocks\";b:1;s:26:\"edit_others_us_page_blocks\";b:1;s:21:\"delete_us_page_blocks\";b:1;s:22:\"publish_us_page_blocks\";b:1;s:27:\"read_private_us_page_blocks\";b:1;s:29:\"delete_private_us_page_blocks\";b:1;s:31:\"delete_published_us_page_blocks\";b:1;s:28:\"delete_others_us_page_blocks\";b:1;s:27:\"edit_private_us_page_blocks\";b:1;s:29:\"edit_published_us_page_blocks\";b:1;s:31:\"vc_access_rules_post_types/post\";b:1;s:37:\"vc_access_rules_post_types/attachment\";b:1;s:39:\"vc_access_rules_post_types/us_portfolio\";b:1;s:41:\"vc_access_rules_post_types/us_testimonial\";b:1;s:46:\"vc_access_rules_post_types/us_content_template\";b:1;s:40:\"vc_access_rules_post_types/us_page_block\";b:1;s:37:\"vc_access_rules_post_types/cptemplate\";b:1;s:37:\"vc_access_rules_post_types/slide_home\";b:1;s:26:\"vc_access_rules_post_types\";s:6:\"custom\";s:31:\"vc_access_rules_post_types/page\";b:1;s:20:\"wpcode_edit_snippets\";b:1;s:24:\"wpcode_activate_snippets\";b:1;s:9:\"edit_page\";b:1;s:9:\"read_page\";b:1;s:11:\"delete_page\";b:1;s:40:\"vc_access_rules_post_types/slide-carross\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:10:\"loco_admin\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:48:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:9:\"edit_post\";b:1;s:9:\"read_post\";b:1;s:11:\"delete_post\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:1;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:23:\"vc_access_rules_code_ai\";b:1;s:23:\"vc_access_rules_text_ai\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:21:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:1;s:31:\"vc_access_rules_unfiltered_html\";b:0;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:1;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:23:\"vc_access_rules_code_ai\";b:1;s:23:\"vc_access_rules_text_ai\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:16:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:26:\"vc_access_rules_post_types\";b:1;s:30:\"vc_access_rules_backend_editor\";b:0;s:31:\"vc_access_rules_unfiltered_html\";b:0;s:29:\"vc_access_rules_post_settings\";b:1;s:25:\"vc_access_rules_templates\";b:1;s:26:\"vc_access_rules_shortcodes\";b:1;s:28:\"vc_access_rules_grid_builder\";b:0;s:23:\"vc_access_rules_presets\";b:1;s:25:\"vc_access_rules_dragndrop\";b:1;s:23:\"vc_access_rules_code_ai\";b:1;s:23:\"vc_access_rules_text_ai\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:93:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "pt_PT", "yes");
INSERT INTO `wp_options` VALUES("103", "user_count", "1", "no");
INSERT INTO `wp_options` VALUES("104", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:158:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Artigos recentes</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:233:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Comentários recentes</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:145:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Arquivo</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categorias</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "sidebars_widgets", "a:3:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:15:\"default_sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("106", "cron", "a:15:{i:1760519611;a:1:{s:22:\"us_filter_indexer_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1760520156;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1760521337;a:1:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1760527356;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760527371;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1760550137;a:1:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760561679;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1760570556;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760570571;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760570572;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1760696042;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1760968800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761056405;a:1:{s:27:\"acf_update_site_health_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761088956;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "nonce_key", "F/3  aNeWH{q0!(,RSdIM}7&-G!BX8x5v%{zNb&!~6F(3S*D??/#=C$Aj15`cQ5]", "no");
INSERT INTO `wp_options` VALUES("117", "nonce_salt", "03>f5oV3P81j#T9G6^sV.sz!r#4B?To.FrGj>_SGu-;P2!vT1uQ- #oyI(|b2Ej,", "no");
INSERT INTO `wp_options` VALUES("118", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("120", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("121", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("122", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("126", "theme_mods_twentytwentythree", "a:4:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1691414151;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:15:\"default_sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}}}s:19:\"wp_classic_sidebars\";a:1:{s:15:\"default_sidebar\";a:11:{s:4:\"name\";s:15:\"Default Sidebar\";s:2:\"id\";s:15:\"default_sidebar\";s:11:\"description\";s:0:\"\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:35:\"<div id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</div>\";s:12:\"before_title\";s:24:\"<h3 class=\"widgettitle\">\";s:11:\"after_title\";s:5:\"</h3>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}}s:18:\"nav_menu_locations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("129", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("130", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("143", "secure_auth_key", "DJVb)e2k=h3Up?<d&yAS5`3$n!R2{tt2%?M=`|E@JJm<BS!kM;/cc4JHrPG+CPRV", "no");
INSERT INTO `wp_options` VALUES("144", "secure_auth_salt", "/]N)m)/*Q`qQ^*k3x9,^^DQL9}-3FuTRsn|CVtSo7Au7|8_vy<%<4RrQ:Q=D#jm`", "no");
INSERT INTO `wp_options` VALUES("145", "logged_in_key", "v^bV9a.VRI-++}plMy{{u[>WgYFXEz%8M.mG87pxt)?tjljU%<hgJPc>;@a$2Sp`", "no");
INSERT INTO `wp_options` VALUES("146", "logged_in_salt", "ItH.!U8+6N=c<mk)/?mh:]+EXvVzxr(m)-&uD8UgAI-a0VvmM2`O&SJh7>r1:AQM", "no");
INSERT INTO `wp_options` VALUES("165", "recently_activated", "a:2:{s:27:\"woocommerce/woocommerce.php\";i:1757945458;s:43:\"advanced-woo-labels/advanced-woo-labels.php\";i:1757945430;}", "off");
INSERT INTO `wp_options` VALUES("175", "password_protected_version", "2.6.0", "yes");
INSERT INTO `wp_options` VALUES("179", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("180", "dhvc_form_db_version", "2.0.0", "yes");
INSERT INTO `wp_options` VALUES("181", "vc_version", "8.6.1", "yes");
INSERT INTO `wp_options` VALUES("182", "acf_version", "6.5.1", "yes");
INSERT INTO `wp_options` VALUES("183", "wpb_license_errors", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("184", "wpb_js_composer_license_activation_notified", "yes", "yes");
INSERT INTO `wp_options` VALUES("185", "wpb_js_google_fonts_subsets", "a:1:{i:0;s:5:\"latin\";}", "yes");
INSERT INTO `wp_options` VALUES("186", "wpb_js_gutenberg_disable", "1", "yes");
INSERT INTO `wp_options` VALUES("187", "wpb_js_default_template_post_type", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("190", "current_theme", "Make It Digital", "yes");
INSERT INTO `wp_options` VALUES("191", "theme_mods_Impreza-child", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1681150586;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:15:\"default_sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}}}}", "no");
INSERT INTO `wp_options` VALUES("192", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("193", "usof_options_Impreza", "a:425:{s:16:\"maintenance_mode\";i:0;s:22:\"maintenance_mode_alert\";s:0:\"\";s:16:\"maintenance_page\";s:1:\"3\";s:26:\"maintenance_private_access\";i:0;s:23:\"maintenance_private_key\";s:32:\"h9LzYbohVgaGxGTSX8esCGljmTVGog8t\";s:15:\"maintenance_503\";i:0;s:9:\"site_icon\";s:2:\"90\";s:10:\"dark_theme\";s:4:\"none\";s:9:\"preloader\";s:8:\"disabled\";s:15:\"preloader_image\";s:0:\"\";s:15:\"img_placeholder\";s:94:\"https://midtemplate.makeitdigital2.tk/wp-content/plugins/us-core/assets/images/placeholder.svg\";s:13:\"ripple_effect\";i:0;s:15:\"rounded_corners\";i:0;s:15:\"links_underline\";i:0;s:29:\"wrapper_links_underline_start\";s:0:\"\";s:25:\"links_underline_thickness\";s:3:\"0px\";s:31:\"links_underline_thickness_hover\";s:3:\"1px\";s:22:\"links_underline_offset\";s:5:\"0.2em\";s:28:\"links_underline_offset_hover\";s:5:\"0.2em\";s:21:\"links_underline_style\";s:5:\"solid\";s:27:\"links_underline_style_hover\";s:5:\"solid\";s:24:\"links_underline_skip_ink\";s:4:\"auto\";s:30:\"links_underline_skip_ink_hover\";s:4:\"auto\";s:21:\"links_underline_color\";s:0:\"\";s:27:\"links_underline_color_hover\";s:0:\"\";s:27:\"wrapper_links_underline_end\";s:0:\"\";s:11:\"back_to_top\";i:1;s:25:\"wrapper_back_to_top_start\";s:0:\"\";s:17:\"back_to_top_style\";s:0:\"\";s:16:\"back_to_top_icon\";s:12:\"far|angle-up\";s:15:\"back_to_top_pos\";s:5:\"right\";s:17:\"back_to_top_color\";s:15:\"rgba(0,0,0,0.3)\";s:19:\"back_to_top_display\";s:5:\"100vh\";s:23:\"wrapper_back_to_top_end\";s:0:\"\";s:22:\"smooth_scroll_duration\";s:6:\"1000ms\";s:13:\"cookie_notice\";i:0;s:20:\"wrapper_cookie_start\";s:0:\"\";s:14:\"cookie_message\";s:106:\"This website uses cookies to improve your experience. If you continue to use this site, you agree with it.\";s:14:\"cookie_privacy\";s:0:\"\";s:18:\"cookie_message_pos\";s:6:\"bottom\";s:16:\"cookie_btn_label\";s:2:\"Ok\";s:16:\"cookie_btn_style\";s:1:\"1\";s:18:\"wrapper_cookie_end\";s:0:\"\";s:23:\"block_third_party_files\";i:0;s:24:\"h_keyboard_accessibility\";s:0:\"\";s:27:\"wrapper_focus_outline_start\";s:0:\"\";s:19:\"focus_outline_width\";s:3:\"2px\";s:19:\"focus_outline_style\";s:5:\"solid\";s:20:\"focus_outline_offset\";s:3:\"2px\";s:19:\"focus_outline_color\";s:16:\"_content_primary\";s:25:\"wrapper_focus_outline_end\";s:0:\"\";s:19:\"skip_to_content_btn\";i:0;s:33:\"wrapper_skip_to_content_btn_start\";s:0:\"\";s:25:\"skip_to_content_btn_label\";s:20:\"Skip to main content\";s:25:\"skip_to_content_btn_style\";s:0:\"\";s:31:\"wrapper_skip_to_content_btn_end\";s:0:\"\";s:18:\"skip_to_footer_btn\";i:0;s:32:\"wrapper_skip_to_footer_btn_start\";s:0:\"\";s:24:\"skip_to_footer_btn_label\";s:14:\"Skip to footer\";s:24:\"skip_to_footer_btn_style\";s:0:\"\";s:30:\"wrapper_skip_to_footer_btn_end\";s:0:\"\";s:19:\"layout_head_message\";s:0:\"\";s:13:\"canvas_layout\";s:4:\"wide\";s:13:\"color_body_bg\";s:15:\"_content_bg_alt\";s:13:\"body_bg_image\";s:0:\"\";s:21:\"wrapper_body_bg_start\";s:0:\"\";s:18:\"body_bg_image_size\";s:5:\"cover\";s:20:\"body_bg_image_repeat\";s:6:\"repeat\";s:22:\"body_bg_image_position\";s:8:\"top left\";s:24:\"body_bg_image_attachment\";i:1;s:19:\"wrapper_body_bg_end\";s:0:\"\";s:17:\"site_canvas_width\";s:6:\"1300px\";s:18:\"site_content_width\";s:6:\"1140px\";s:13:\"sidebar_width\";s:3:\"25%\";s:10:\"row_height\";s:4:\"auto\";s:17:\"row_height_custom\";s:5:\"5vmax\";s:18:\"text_bottom_indent\";s:4:\"0rem\";s:13:\"footer_reveal\";i:0;s:21:\"disable_effects_width\";s:5:\"900px\";s:22:\"columns_stacking_width\";s:5:\"600px\";s:18:\"laptops_breakpoint\";s:6:\"1380px\";s:18:\"tablets_breakpoint\";s:6:\"1024px\";s:18:\"mobiles_breakpoint\";s:5:\"600px\";s:11:\"search_page\";s:7:\"default\";s:28:\"exclude_post_types_in_search\";s:0:\"\";s:8:\"page_404\";s:7:\"default\";s:10:\"h_defaults\";s:0:\"\";s:9:\"header_id\";s:2:\"12\";s:11:\"titlebar_id\";s:2:\"10\";s:10:\"content_id\";s:0:\"\";s:10:\"sidebar_id\";s:0:\"\";s:11:\"sidebar_pos\";s:5:\"right\";s:9:\"footer_id\";s:2:\"15\";s:6:\"h_post\";s:0:\"\";s:14:\"header_post_id\";s:12:\"__defaults__\";s:16:\"titlebar_post_id\";s:12:\"__defaults__\";s:15:\"content_post_id\";s:2:\"20\";s:15:\"sidebar_post_id\";s:0:\"\";s:16:\"sidebar_post_pos\";s:5:\"right\";s:14:\"footer_post_id\";s:12:\"__defaults__\";s:15:\"h_slide-carross\";s:0:\"\";s:23:\"header_slide-carross_id\";s:12:\"__defaults__\";s:25:\"titlebar_slide-carross_id\";s:12:\"__defaults__\";s:24:\"content_slide-carross_id\";s:12:\"__defaults__\";s:24:\"sidebar_slide-carross_id\";s:12:\"__defaults__\";s:25:\"sidebar_slide-carross_pos\";s:5:\"right\";s:23:\"footer_slide-carross_id\";s:12:\"__defaults__\";s:11:\"h_portfolio\";s:0:\"\";s:19:\"header_portfolio_id\";s:12:\"__defaults__\";s:21:\"titlebar_portfolio_id\";s:12:\"__defaults__\";s:20:\"content_portfolio_id\";s:12:\"__defaults__\";s:20:\"sidebar_portfolio_id\";s:12:\"__defaults__\";s:21:\"sidebar_portfolio_pos\";s:5:\"right\";s:19:\"footer_portfolio_id\";s:12:\"__defaults__\";s:18:\"h_archive_defaults\";s:0:\"\";s:17:\"header_archive_id\";s:12:\"__defaults__\";s:19:\"titlebar_archive_id\";s:12:\"__defaults__\";s:18:\"content_archive_id\";s:0:\"\";s:18:\"sidebar_archive_id\";s:12:\"__defaults__\";s:19:\"sidebar_archive_pos\";s:5:\"right\";s:17:\"footer_archive_id\";s:12:\"__defaults__\";s:14:\"h_tax_category\";s:0:\"\";s:22:\"header_tax_category_id\";s:12:\"__defaults__\";s:24:\"titlebar_tax_category_id\";s:12:\"__defaults__\";s:23:\"content_tax_category_id\";s:12:\"__defaults__\";s:23:\"sidebar_tax_category_id\";s:12:\"__defaults__\";s:24:\"sidebar_tax_category_pos\";s:5:\"right\";s:22:\"footer_tax_category_id\";s:12:\"__defaults__\";s:14:\"h_tax_post_tag\";s:0:\"\";s:22:\"header_tax_post_tag_id\";s:12:\"__defaults__\";s:24:\"titlebar_tax_post_tag_id\";s:12:\"__defaults__\";s:23:\"content_tax_post_tag_id\";s:12:\"__defaults__\";s:23:\"sidebar_tax_post_tag_id\";s:12:\"__defaults__\";s:24:\"sidebar_tax_post_tag_pos\";s:5:\"right\";s:22:\"footer_tax_post_tag_id\";s:12:\"__defaults__\";s:17:\"h_tax_post_format\";s:0:\"\";s:25:\"header_tax_post_format_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_post_format_id\";s:12:\"__defaults__\";s:26:\"content_tax_post_format_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_post_format_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_post_format_pos\";s:5:\"right\";s:25:\"footer_tax_post_format_id\";s:12:\"__defaults__\";s:19:\"h_tax_marca-produto\";s:0:\"\";s:27:\"header_tax_marca-produto_id\";s:12:\"__defaults__\";s:29:\"titlebar_tax_marca-produto_id\";s:2:\"10\";s:28:\"content_tax_marca-produto_id\";s:2:\"58\";s:28:\"sidebar_tax_marca-produto_id\";s:12:\"__defaults__\";s:29:\"sidebar_tax_marca-produto_pos\";s:5:\"right\";s:27:\"footer_tax_marca-produto_id\";s:12:\"__defaults__\";s:27:\"h_tax_us_portfolio_category\";s:0:\"\";s:35:\"header_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:37:\"titlebar_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:36:\"content_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:36:\"sidebar_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:37:\"sidebar_tax_us_portfolio_category_pos\";s:5:\"right\";s:35:\"footer_tax_us_portfolio_category_id\";s:12:\"__defaults__\";s:22:\"h_tax_us_portfolio_tag\";s:0:\"\";s:30:\"header_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:32:\"titlebar_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:31:\"content_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:31:\"sidebar_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:32:\"sidebar_tax_us_portfolio_tag_pos\";s:5:\"right\";s:30:\"footer_tax_us_portfolio_tag_id\";s:12:\"__defaults__\";s:9:\"h_authors\";s:0:\"\";s:16:\"header_author_id\";s:12:\"__defaults__\";s:18:\"titlebar_author_id\";s:12:\"__defaults__\";s:17:\"content_author_id\";s:12:\"__defaults__\";s:17:\"sidebar_author_id\";s:12:\"__defaults__\";s:18:\"sidebar_author_pos\";s:5:\"right\";s:16:\"footer_author_id\";s:12:\"__defaults__\";s:15:\"h_custom_colors\";s:0:\"\";s:13:\"custom_colors\";a:8:{i:0;a:3:{s:5:\"color\";s:7:\"#86367D\";s:4:\"name\";s:9:\"principal\";s:4:\"slug\";s:10:\"_principal\";}i:1;a:3:{s:5:\"color\";s:7:\"#C20A72\";s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:5:\"_link\";}i:2;a:3:{s:5:\"color\";s:7:\"#6C2470\";s:4:\"name\";s:10:\"secundaria\";s:4:\"slug\";s:11:\"_secundaria\";}i:3;a:3:{s:5:\"color\";s:7:\"#A73089\";s:4:\"name\";s:4:\"vivo\";s:4:\"slug\";s:5:\"_vivo\";}i:4;a:3:{s:5:\"color\";s:7:\"#361D4A\";s:4:\"name\";s:4:\"dark\";s:4:\"slug\";s:5:\"_dark\";}i:5;a:3:{s:5:\"color\";s:7:\"#F8F8F8\";s:4:\"name\";s:6:\"fundo1\";s:4:\"slug\";s:7:\"_fundo1\";}i:6;a:3:{s:5:\"color\";s:7:\"#fceaf4\";s:4:\"name\";s:6:\"fundo2\";s:4:\"slug\";s:7:\"_fundo2\";}i:7;a:3:{s:5:\"color\";s:4:\"#fff\";s:4:\"name\";s:6:\"branco\";s:4:\"slug\";s:7:\"_branco\";}}s:19:\"color_header_top_bg\";s:34:\"linear-gradient(0deg,#f5f5f5,#fff)\";s:21:\"color_header_top_text\";s:7:\"#333333\";s:27:\"color_header_top_text_hover\";s:7:\"#e95095\";s:22:\"color_header_middle_bg\";s:7:\"#ffffff\";s:24:\"color_header_middle_text\";s:5:\"_link\";s:30:\"color_header_middle_text_hover\";s:7:\"_fundo2\";s:29:\"color_header_transparent_text\";s:7:\"#ffffff\";s:35:\"color_header_transparent_text_hover\";s:7:\"#ffffff\";s:20:\"color_chrome_toolbar\";s:7:\"#f5f5f5\";s:16:\"color_content_bg\";s:7:\"_branco\";s:20:\"color_content_bg_alt\";s:7:\"_fundo1\";s:20:\"color_content_border\";s:7:\"#e8e8e8\";s:21:\"color_content_heading\";s:10:\"_principal\";s:18:\"color_content_text\";s:7:\"#333333\";s:18:\"color_content_link\";s:5:\"_link\";s:24:\"color_content_link_hover\";s:5:\"_dark\";s:21:\"color_content_primary\";s:10:\"_principal\";s:23:\"color_content_secondary\";s:11:\"_secundaria\";s:19:\"color_content_faded\";s:7:\"#999999\";s:21:\"color_content_overlay\";s:16:\"rgba(0,0,0,0.75)\";s:20:\"color_alt_content_bg\";s:7:\"#f5f5f5\";s:24:\"color_alt_content_bg_alt\";s:7:\"#a1cce4\";s:24:\"color_alt_content_border\";s:7:\"#dddddd\";s:25:\"color_alt_content_heading\";s:7:\"#1a1a1a\";s:22:\"color_alt_content_text\";s:7:\"#333333\";s:22:\"color_alt_content_link\";s:7:\"#e95095\";s:28:\"color_alt_content_link_hover\";s:7:\"#7049ba\";s:25:\"color_alt_content_primary\";s:39:\"linear-gradient(135deg,#e95095,#7049ba)\";s:27:\"color_alt_content_secondary\";s:39:\"linear-gradient(135deg,#7049ba,#e95095)\";s:23:\"color_alt_content_faded\";s:7:\"#999999\";s:25:\"color_alt_content_overlay\";s:53:\"linear-gradient(135deg,#e95095,rgba(233,80,149,0.75))\";s:15:\"color_footer_bg\";s:7:\"#222222\";s:19:\"color_footer_bg_alt\";s:7:\"#1a1a1a\";s:19:\"color_footer_border\";s:7:\"#333333\";s:20:\"color_footer_heading\";s:7:\"#cccccc\";s:17:\"color_footer_text\";s:7:\"#999999\";s:17:\"color_footer_link\";s:7:\"#cccccc\";s:23:\"color_footer_link_hover\";s:7:\"#e95095\";s:18:\"color_subfooter_bg\";s:7:\"#1a1a1a\";s:22:\"color_subfooter_bg_alt\";s:7:\"#222222\";s:22:\"color_subfooter_border\";s:7:\"#282828\";s:23:\"color_subfooter_heading\";s:7:\"#cccccc\";s:20:\"color_subfooter_text\";s:7:\"#bbbbbb\";s:20:\"color_subfooter_link\";s:7:\"#ffffff\";s:26:\"color_subfooter_link_hover\";s:7:\"#e95095\";s:12:\"style_scheme\";i:0;s:26:\"change_header_colors_start\";s:0:\"\";s:10:\"h_colors_1\";s:0:\"\";s:27:\"color_header_transparent_bg\";s:11:\"transparent\";s:24:\"change_header_colors_end\";s:0:\"\";s:30:\"change_header_alt_colors_start\";s:0:\"\";s:10:\"h_colors_2\";s:0:\"\";s:31:\"color_header_top_transparent_bg\";s:15:\"rgba(0,0,0,0.2)\";s:33:\"color_header_top_transparent_text\";s:22:\"rgba(255,255,255,0.66)\";s:39:\"color_header_top_transparent_text_hover\";s:7:\"#ffffff\";s:28:\"change_header_alt_colors_end\";s:0:\"\";s:27:\"change_content_colors_start\";s:0:\"\";s:10:\"h_colors_3\";s:0:\"\";s:25:\"change_content_colors_end\";s:0:\"\";s:31:\"change_alt_content_colors_start\";s:0:\"\";s:10:\"h_colors_4\";s:0:\"\";s:29:\"change_alt_content_colors_end\";s:0:\"\";s:26:\"change_footer_colors_start\";s:0:\"\";s:10:\"h_colors_6\";s:0:\"\";s:24:\"change_footer_colors_end\";s:0:\"\";s:29:\"change_subfooter_colors_start\";s:0:\"\";s:10:\"h_colors_5\";s:0:\"\";s:27:\"change_subfooter_colors_end\";s:0:\"\";s:23:\"typography_head_message\";s:0:\"\";s:4:\"body\";a:8:{s:11:\"font-family\";s:10:\"Montserrat\";s:9:\"font-size\";s:119:\"%7B%22default%22%3A%2217px%22%2C%22laptops%22%3A%2218px%22%2C%22tablets%22%3A%2218px%22%2C%22mobiles%22%3A%2216px%22%7D\";s:11:\"line-height\";s:4:\"25px\";s:11:\"font-weight\";s:3:\"400\";s:16:\"bold-font-weight\";s:3:\"700\";s:14:\"text-transform\";s:4:\"none\";s:10:\"font-style\";s:6:\"normal\";s:14:\"letter-spacing\";s:3:\"0em\";}s:2:\"h1\";a:11:{s:11:\"font-family\";s:7:\"inherit\";s:9:\"font-size\";s:16:\"max( 4rem, 4vw )\";s:11:\"line-height\";s:3:\"1.2\";s:11:\"font-weight\";s:3:\"300\";s:16:\"bold-font-weight\";s:3:\"800\";s:14:\"text-transform\";s:4:\"none\";s:10:\"font-style\";s:6:\"normal\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"0.6em\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";s:0:\"\";}s:2:\"h2\";a:11:{s:11:\"font-family\";s:21:\"var(--h1-font-family)\";s:9:\"font-size\";s:20:\"max( 2.3rem, 2.3vw )\";s:11:\"line-height\";s:3:\"1.2\";s:11:\"font-weight\";s:3:\"500\";s:16:\"bold-font-weight\";s:3:\"600\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"0.6em\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";s:0:\"\";}s:2:\"h3\";a:11:{s:11:\"font-family\";s:21:\"var(--h1-font-family)\";s:9:\"font-size\";s:20:\"max( 1.7rem, 1.7vw )\";s:11:\"line-height\";s:3:\"1.2\";s:11:\"font-weight\";s:3:\"200\";s:16:\"bold-font-weight\";s:3:\"900\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"0.6em\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";s:0:\"\";}s:2:\"h4\";a:11:{s:11:\"font-family\";s:21:\"var(--h1-font-family)\";s:9:\"font-size\";s:20:\"max( 1.5rem, 1.5vw )\";s:11:\"line-height\";s:3:\"1.2\";s:11:\"font-weight\";s:21:\"var(--h1-font-weight)\";s:16:\"bold-font-weight\";s:26:\"var(--h1-bold-font-weight)\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"0.6em\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";s:0:\"\";}s:2:\"h5\";a:11:{s:11:\"font-family\";s:21:\"var(--h1-font-family)\";s:9:\"font-size\";s:20:\"max( 1.3rem, 1.3vw )\";s:11:\"line-height\";s:3:\"1.2\";s:11:\"font-weight\";s:21:\"var(--h1-font-weight)\";s:16:\"bold-font-weight\";s:26:\"var(--h1-bold-font-weight)\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"0.6em\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";s:0:\"\";}s:2:\"h6\";a:11:{s:11:\"font-family\";s:21:\"var(--h1-font-family)\";s:9:\"font-size\";s:20:\"max( 1.2rem, 1.2vw )\";s:11:\"line-height\";s:3:\"1.2\";s:11:\"font-weight\";s:21:\"var(--h1-font-weight)\";s:16:\"bold-font-weight\";s:26:\"var(--h1-bold-font-weight)\";s:14:\"text-transform\";s:24:\"var(--h1-text-transform)\";s:10:\"font-style\";s:20:\"var(--h1-font-style)\";s:14:\"letter-spacing\";s:3:\"0em\";s:13:\"margin-bottom\";s:5:\"0.6em\";s:5:\"color\";s:0:\"\";s:14:\"color_override\";s:0:\"\";}s:14:\"h_typography_3\";s:0:\"\";s:11:\"custom_font\";a:1:{i:0;a:1:{s:11:\"font_family\";s:17:\"Corinthia|400,700\";}}s:14:\"h_typography_4\";s:0:\"\";s:14:\"uploaded_fonts\";a:0:{}s:14:\"h_typography_5\";s:0:\"\";s:12:\"font_display\";s:4:\"swap\";s:14:\"h_typography_6\";s:0:\"\";s:11:\"adobe_fonts\";s:0:\"\";s:7:\"buttons\";a:6:{i:0;a:35:{s:2:\"id\";s:1:\"1\";s:5:\"hover\";s:4:\"fade\";s:20:\"hover_text_animation\";s:4:\"fade\";s:19:\"transition_duration\";s:4:\"0.3s\";s:26:\"transition_timing_function\";s:0:\"\";s:8:\"color_bg\";s:16:\"_content_primary\";s:14:\"color_bg_hover\";s:18:\"_content_secondary\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:0:\"\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:0:\"\";s:21:\"shadow_hover_offset_h\";s:3:\"0px\";s:21:\"shadow_hover_offset_v\";s:3:\"0px\";s:17:\"shadow_hover_blur\";s:3:\"0px\";s:19:\"shadow_hover_spread\";s:3:\"0px\";s:18:\"shadow_hover_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:5:\"0.9em\";s:9:\"font_size\";s:4:\"14px\";s:5:\"width\";s:5:\"2.0em\";s:11:\"line_height\";s:3:\"1.2\";s:12:\"border_width\";s:3:\"0px\";s:11:\"font_weight\";s:3:\"700\";s:13:\"border_radius\";s:5:\"0.0em\";s:14:\"letter_spacing\";s:6:\"0.06em\";s:10:\"text_style\";s:0:\"\";s:4:\"name\";s:14:\"Default Button\";s:5:\"class\";s:0:\"\";}i:1;a:35:{s:2:\"id\";s:1:\"4\";s:5:\"hover\";s:4:\"fade\";s:20:\"hover_text_animation\";s:4:\"fade\";s:19:\"transition_duration\";s:4:\"0.3s\";s:26:\"transition_timing_function\";s:0:\"\";s:8:\"color_bg\";s:18:\"_content_secondary\";s:14:\"color_bg_hover\";s:5:\"_dark\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:0:\"\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:0:\"\";s:21:\"shadow_hover_offset_h\";s:3:\"0px\";s:21:\"shadow_hover_offset_v\";s:3:\"0px\";s:17:\"shadow_hover_blur\";s:3:\"0px\";s:19:\"shadow_hover_spread\";s:3:\"0px\";s:18:\"shadow_hover_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:5:\"0.9em\";s:9:\"font_size\";s:4:\"14px\";s:5:\"width\";s:5:\"2.0em\";s:11:\"line_height\";s:3:\"1.2\";s:12:\"border_width\";s:3:\"0px\";s:11:\"font_weight\";s:3:\"700\";s:13:\"border_radius\";s:5:\"0.0em\";s:14:\"letter_spacing\";s:6:\"0.06em\";s:10:\"text_style\";s:0:\"\";s:4:\"name\";s:13:\"Default Verde\";s:5:\"class\";s:0:\"\";}i:2;a:35:{s:2:\"id\";s:1:\"3\";s:5:\"hover\";s:4:\"fade\";s:20:\"hover_text_animation\";s:4:\"fade\";s:19:\"transition_duration\";s:4:\"0.3s\";s:26:\"transition_timing_function\";s:0:\"\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:18:\"_content_secondary\";s:12:\"color_border\";s:16:\"_content_primary\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:16:\"_content_primary\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:0:\"\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:0:\"\";s:21:\"shadow_hover_offset_h\";s:3:\"0px\";s:21:\"shadow_hover_offset_v\";s:3:\"0px\";s:17:\"shadow_hover_blur\";s:3:\"0px\";s:19:\"shadow_hover_spread\";s:3:\"0px\";s:18:\"shadow_hover_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:5:\"1.0em\";s:9:\"font_size\";s:4:\"14px\";s:5:\"width\";s:5:\"2.0em\";s:11:\"line_height\";s:3:\"1.2\";s:12:\"border_width\";s:3:\"1px\";s:11:\"font_weight\";s:3:\"700\";s:13:\"border_radius\";s:5:\"0.0em\";s:14:\"letter_spacing\";s:6:\"0.03em\";s:10:\"text_style\";s:9:\"uppercase\";s:4:\"name\";s:7:\"Outline\";s:5:\"class\";s:0:\"\";}i:3;a:35:{s:2:\"id\";s:1:\"2\";s:5:\"hover\";s:4:\"fade\";s:20:\"hover_text_animation\";s:4:\"fade\";s:19:\"transition_duration\";s:4:\"0.3s\";s:26:\"transition_timing_function\";s:0:\"\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:0:\"\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:13:\"_content_link\";s:16:\"color_text_hover\";s:19:\"_content_link_hover\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:0:\"\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:0:\"\";s:21:\"shadow_hover_offset_h\";s:3:\"0px\";s:21:\"shadow_hover_offset_v\";s:3:\"0px\";s:17:\"shadow_hover_blur\";s:3:\"0px\";s:19:\"shadow_hover_spread\";s:3:\"0px\";s:18:\"shadow_hover_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:5:\"0.4em\";s:9:\"font_size\";s:4:\"13px\";s:5:\"width\";s:3:\"0em\";s:11:\"line_height\";s:4:\"1.20\";s:12:\"border_width\";s:3:\"0px\";s:11:\"font_weight\";s:3:\"600\";s:13:\"border_radius\";s:5:\"0.0em\";s:14:\"letter_spacing\";s:6:\"0.04em\";s:10:\"text_style\";s:0:\"\";s:4:\"name\";s:9:\"Just link\";s:5:\"class\";s:0:\"\";}i:4;a:35:{s:2:\"id\";s:1:\"6\";s:5:\"hover\";s:4:\"fade\";s:20:\"hover_text_animation\";s:4:\"fade\";s:19:\"transition_duration\";s:4:\"0.3s\";s:26:\"transition_timing_function\";s:0:\"\";s:8:\"color_bg\";s:0:\"\";s:14:\"color_bg_hover\";s:0:\"\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"_fundo2\";s:16:\"color_text_hover\";s:7:\"#de50a0\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:0:\"\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:0:\"\";s:21:\"shadow_hover_offset_h\";s:3:\"0px\";s:21:\"shadow_hover_offset_v\";s:3:\"0px\";s:17:\"shadow_hover_blur\";s:3:\"0px\";s:19:\"shadow_hover_spread\";s:3:\"0px\";s:18:\"shadow_hover_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:5:\"0.4em\";s:9:\"font_size\";s:4:\"13px\";s:5:\"width\";s:3:\"0em\";s:11:\"line_height\";s:4:\"1.20\";s:12:\"border_width\";s:3:\"0px\";s:11:\"font_weight\";s:3:\"600\";s:13:\"border_radius\";s:5:\"0.0em\";s:14:\"letter_spacing\";s:6:\"0.04em\";s:10:\"text_style\";s:0:\"\";s:4:\"name\";s:22:\"Just link fundo escuro\";s:5:\"class\";s:0:\"\";}i:5;a:35:{s:2:\"id\";s:1:\"5\";s:5:\"hover\";s:4:\"fade\";s:20:\"hover_text_animation\";s:4:\"fade\";s:19:\"transition_duration\";s:4:\"0.3s\";s:26:\"transition_timing_function\";s:0:\"\";s:8:\"color_bg\";s:18:\"_content_secondary\";s:14:\"color_bg_hover\";s:7:\"#154d04\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:7:\"#ffffff\";s:16:\"color_text_hover\";s:7:\"#ffffff\";s:12:\"color_shadow\";s:0:\"\";s:18:\"color_shadow_hover\";s:0:\"\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"0px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:0:\"\";s:21:\"shadow_hover_offset_h\";s:3:\"0px\";s:21:\"shadow_hover_offset_v\";s:3:\"0px\";s:17:\"shadow_hover_blur\";s:3:\"0px\";s:19:\"shadow_hover_spread\";s:3:\"0px\";s:18:\"shadow_hover_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:5:\"0.9em\";s:9:\"font_size\";s:4:\"14px\";s:5:\"width\";s:5:\"1.3em\";s:11:\"line_height\";s:3:\"1.2\";s:12:\"border_width\";s:3:\"0px\";s:11:\"font_weight\";s:3:\"600\";s:13:\"border_radius\";s:5:\"0.0em\";s:14:\"letter_spacing\";s:6:\"0.06em\";s:10:\"text_style\";s:9:\"uppercase\";s:4:\"name\";s:20:\"Default Verde Header\";s:5:\"class\";s:0:\"\";}}s:12:\"input_fields\";a:1:{i:0;a:30:{s:8:\"color_bg\";s:15:\"_content_bg_alt\";s:14:\"color_bg_focus\";s:15:\"_content_bg_alt\";s:12:\"color_border\";s:15:\"_content_border\";s:18:\"color_border_focus\";s:15:\"_content_border\";s:10:\"color_text\";s:13:\"_content_text\";s:16:\"color_text_focus\";s:13:\"_content_text\";s:12:\"color_shadow\";s:16:\"rgba(0,0,0,0.08)\";s:18:\"color_shadow_focus\";s:16:\"_content_primary\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"1px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:1:\"1\";s:21:\"shadow_focus_offset_h\";s:3:\"0px\";s:21:\"shadow_focus_offset_v\";s:3:\"0px\";s:17:\"shadow_focus_blur\";s:3:\"0px\";s:19:\"shadow_focus_spread\";s:3:\"2px\";s:18:\"shadow_focus_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:6:\"height\";s:6:\"2.8rem\";s:9:\"font_size\";s:4:\"1rem\";s:7:\"padding\";s:6:\"0.8rem\";s:11:\"font_weight\";s:3:\"400\";s:12:\"border_width\";s:3:\"0px\";s:14:\"letter_spacing\";s:3:\"0em\";s:13:\"border_radius\";s:0:\"\";s:2:\"id\";s:1:\"1\";s:4:\"name\";s:13:\"Default Style\";s:14:\"text_transform\";s:4:\"none\";s:13:\"checkbox_size\";s:5:\"1.5em\";}}s:26:\"portfolio_breadcrumbs_page\";s:0:\"\";s:14:\"portfolio_slug\";s:9:\"portfolio\";s:23:\"portfolio_category_slug\";s:18:\"portfolio_category\";s:18:\"portfolio_tag_slug\";s:13:\"portfolio_tag\";s:28:\"portfolio_slug_ignore_prefix\";i:0;s:16:\"portfolio_rename\";i:0;s:20:\"portfolio_label_name\";s:9:\"Portfolio\";s:29:\"portfolio_label_singular_name\";s:14:\"Portfolio Page\";s:23:\"portfolio_label_add_new\";s:18:\"Add Portfolio Page\";s:25:\"portfolio_label_edit_item\";s:19:\"Edit Portfolio Page\";s:24:\"portfolio_label_category\";s:20:\"Portfolio Categories\";s:19:\"portfolio_label_tag\";s:14:\"Portfolio Tags\";s:6:\"h_more\";s:0:\"\";s:12:\"shop_catalog\";i:0;s:22:\"shop_primary_btn_style\";s:1:\"1\";s:24:\"shop_secondary_btn_style\";s:1:\"2\";s:15:\"product_gallery\";s:6:\"slider\";s:29:\"wrapper_product_gallery_start\";s:0:\"\";s:26:\"product_gallery_thumbs_pos\";s:6:\"bottom\";s:27:\"product_gallery_thumbs_cols\";s:1:\"8\";s:28:\"product_gallery_thumbs_width\";s:4:\"6rem\";s:26:\"product_gallery_thumbs_gap\";s:3:\"4px\";s:23:\"product_gallery_options\";s:13:\"zoom,lightbox\";s:27:\"wrapper_product_gallery_end\";s:0:\"\";s:9:\"h_product\";s:0:\"\";s:17:\"header_product_id\";s:12:\"__defaults__\";s:19:\"titlebar_product_id\";s:0:\"\";s:18:\"content_product_id\";s:2:\"55\";s:18:\"sidebar_product_id\";s:12:\"__defaults__\";s:19:\"sidebar_product_pos\";s:5:\"right\";s:17:\"footer_product_id\";s:12:\"__defaults__\";s:6:\"h_shop\";s:0:\"\";s:14:\"header_shop_id\";s:12:\"__defaults__\";s:16:\"titlebar_shop_id\";s:0:\"\";s:15:\"content_shop_id\";s:2:\"64\";s:18:\"wrapper_shop_start\";s:0:\"\";s:12:\"shop_columns\";s:1:\"3\";s:16:\"wrapper_shop_end\";s:0:\"\";s:15:\"sidebar_shop_id\";s:12:\"__defaults__\";s:16:\"sidebar_shop_pos\";s:5:\"right\";s:14:\"footer_shop_id\";s:12:\"__defaults__\";s:13:\"h_shop_search\";s:0:\"\";s:21:\"header_shop_search_id\";s:12:\"__defaults__\";s:23:\"titlebar_shop_search_id\";s:2:\"10\";s:22:\"content_shop_search_id\";s:2:\"58\";s:22:\"sidebar_shop_search_id\";s:12:\"__defaults__\";s:23:\"sidebar_shop_search_pos\";s:5:\"right\";s:21:\"footer_shop_search_id\";s:12:\"__defaults__\";s:7:\"h_order\";s:0:\"\";s:16:\"content_order_id\";s:0:\"\";s:6:\"h_cart\";s:0:\"\";s:9:\"shop_cart\";s:7:\"compact\";s:19:\"product_related_qty\";s:1:\"3\";s:15:\"used_icons_info\";s:0:\"\";s:9:\"h_icons_2\";s:0:\"\";s:9:\"icons_fas\";s:7:\"default\";s:21:\"icons_fas_custom_font\";s:0:\"\";s:9:\"icons_far\";s:7:\"default\";s:21:\"icons_far_custom_font\";s:0:\"\";s:9:\"icons_fal\";s:7:\"default\";s:21:\"icons_fal_custom_font\";s:0:\"\";s:9:\"icons_fad\";s:7:\"default\";s:21:\"icons_fad_custom_font\";s:0:\"\";s:9:\"icons_fab\";s:7:\"default\";s:21:\"icons_fab_custom_font\";s:0:\"\";s:14:\"icons_material\";s:7:\"default\";s:26:\"icons_material_custom_font\";s:0:\"\";s:18:\"fallback_icon_font\";i:1;s:13:\"img_size_info\";s:0:\"\";s:13:\"h_image_sizes\";s:0:\"\";s:8:\"img_size\";a:0:{}s:14:\"h_more_options\";s:0:\"\";s:24:\"big_image_size_threshold\";s:6:\"2560px\";s:20:\"delete_unused_images\";i:0;s:12:\"h_advanced_2\";s:0:\"\";s:18:\"reCAPTCHA_site_key\";s:0:\"\";s:20:\"reCAPTCHA_secret_key\";s:0:\"\";s:20:\"reCAPTCHA_hide_badge\";s:1:\"0\";s:21:\"reCAPTCHA_policy_text\";s:223:\"This site is protected by reCAPTCHA and the Google <a href=\"https://policies.google.com/privacy\" target=\"_blank\">Privacy Policy</a> and <a href=\"https://policies.google.com/terms\" target=\"_blank\">Terms of Service</a> apply.\";s:13:\"gmaps_api_key\";s:0:\"\";s:15:\"facebook_app_id\";s:0:\"\";s:22:\"grid_filter_url_prefix\";s:0:\"\";s:21:\"grid_order_url_prefix\";s:0:\"\";s:12:\"h_advanced_4\";s:0:\"\";s:18:\"index_filter_panel\";s:0:\"\";s:26:\"enable_auto_filter_reindex\";i:0;s:12:\"h_advanced_1\";s:0:\"\";s:12:\"live_builder\";i:1;s:17:\"section_templates\";i:1;s:17:\"section_favorites\";i:1;s:19:\"grid_columns_layout\";i:1;s:12:\"block_editor\";i:0;s:23:\"enable_sidebar_titlebar\";i:1;s:31:\"enable_page_blocks_for_sidebars\";i:0;s:16:\"enable_portfolio\";i:1;s:19:\"enable_testimonials\";i:1;s:22:\"cform_inbound_messages\";i:0;s:14:\"media_category\";i:1;s:26:\"enable_additional_settings\";i:1;s:30:\"additional_settings_post_types\";s:44:\"page,post,slide-carross,product,us_portfolio\";s:10:\"og_enabled\";i:1;s:13:\"schema_markup\";i:1;s:28:\"templates_access_for_editors\";i:0;s:12:\"h_advanced_3\";s:0:\"\";s:17:\"keep_url_protocol\";i:1;s:22:\"disable_jquery_migrate\";i:1;s:13:\"jquery_footer\";i:1;s:16:\"disable_extra_vc\";i:1;s:15:\"optimize_assets\";i:0;s:21:\"optimize_assets_alert\";s:0:\"\";s:21:\"optimize_assets_start\";s:0:\"\";s:6:\"assets\";a:64:{s:11:\"add_to_favs\";i:1;s:20:\"font-awesome-duotone\";i:1;s:12:\"font-awesome\";i:1;s:9:\"actionbox\";i:1;s:9:\"animation\";i:1;s:7:\"buttons\";i:1;s:8:\"carousel\";i:1;s:6:\"charts\";i:1;s:19:\"color_scheme_switch\";i:1;s:7:\"columns\";i:1;s:8:\"comments\";i:1;s:16:\"content_carousel\";i:1;s:7:\"counter\";i:1;s:8:\"dropdown\";i:1;s:7:\"flipbox\";i:1;s:5:\"forms\";i:1;s:7:\"gallery\";i:1;s:5:\"gmaps\";i:1;s:4:\"grid\";i:1;s:11:\"grid_filter\";i:1;s:14:\"grid_templates\";i:1;s:10:\"grid_order\";i:1;s:15:\"grid_pagination\";i:1;s:10:\"grid_popup\";i:1;s:6:\"header\";i:1;s:12:\"hor_parallax\";i:1;s:8:\"hwrapper\";i:1;s:7:\"iconbox\";i:1;s:12:\"image_slider\";i:1;s:5:\"image\";i:1;s:8:\"contacts\";i:1;s:7:\"ibanner\";i:1;s:5:\"itext\";i:1;s:11:\"list_filter\";i:1;s:10:\"list_order\";i:1;s:11:\"list_search\";i:1;s:5:\"login\";i:1;s:4:\"menu\";i:1;s:7:\"message\";i:1;s:5:\"lmaps\";i:1;s:8:\"scroller\";i:1;s:6:\"person\";i:1;s:6:\"search\";i:1;s:5:\"popup\";i:1;s:14:\"magnific_popup\";i:1;s:13:\"post_elements\";i:1;s:9:\"post_list\";i:1;s:15:\"post_navigation\";i:1;s:9:\"preloader\";i:1;s:7:\"pricing\";i:1;s:5:\"print\";i:1;s:7:\"progbar\";i:1;s:6:\"scroll\";i:1;s:14:\"scroll-effects\";i:1;s:9:\"separator\";i:1;s:7:\"sharing\";i:1;s:11:\"simple_menu\";i:1;s:7:\"socials\";i:1;s:4:\"tabs\";i:1;s:4:\"text\";i:1;s:12:\"ver_parallax\";i:1;s:8:\"vwrapper\";i:1;s:5:\"video\";i:1;s:10:\"wp_widgets\";i:1;}s:19:\"optimize_assets_end\";s:0:\"\";s:18:\"include_gfonts_css\";i:0;s:10:\"custom_css\";s:6306:\"/* colunas com overlay em mouse-hover */\n\n.hoverpurple1 {\n  position: relative; /* Needed for the overlay positioning */\n  overflow: hidden;   /* Prevent the overlay from bleeding outside */\n}\n\n.hoverpurple1::before {\n  content: \"\";\n  position: absolute;\n  inset: 0; /* shorthand for top:0; right:0; bottom:0; left:0 */\n  background-color: #C20A72;\n  mix-blend-mode: overlay;\n  opacity: 0;\n  transition: opacity 0.3s ease;\n  pointer-events: none; /* make sure overlay doesn’t block clicks */\n}\n\n.hoverpurple1:hover::before {\n  opacity: 1;\n}\n.mousepoint:hover {\n	cursor: pointer !important;\n}\n\n/* Vários */\n\n.w-iconbox.iconpos_left .w-iconbox-icon {\n    margin-right: 9px !important;\n}\n\n.w-ibanner.animation_phorcys .w-ibanner-desc {\n    margin-top: .2rem !important;\n}\n\n\n.pop1 .w-popup-box-content p {\n	font-size: .9rem !important;\n}\n\n.w-nav.type_desktop .w-nav-list.level_2 {\n    padding-top: 0.5rem !important;\n    padding-bottom: 0.5rem !important;\n}\n\n.w-iconbox .w-iconbox-title:not(:empty) {\n    padding: 0em 0 !important;\n}\n\nh3.widgettitle {\n    font-size: 1.3rem !important;\n}\n\n\n/* FIM Vários */\n\n/* Menu topo */\n\n.w-nav-close {\n    font-size: 2rem !important;\n	top: 68px !important;\n    right: 42px !important;\n}\n\n.l-subheader.at_middle .type_mobile .w-nav-list.level_1 {\n    background: #451848ed !important;\n    color: #fff;\n}\n\n/* dhcv */\n\n\ndiv.dhvc-form-inner section.l-section.wpb_row.height_auto {\n	padding-left: 0rem !important;\n	padding-right: 0rem !important;\n}\n\n.dhvc-form-flat .dhvc-form-input input, .dhvc-form-flat .dhvc-form-file input[type=text], .dhvc-form-flat .dhvc-form-captcha input, .dhvc-form-flat .dhvc-form-select select, .dhvc-form-flat .dhvc-form-textarea textarea {\n    background-color: #fff !important;\n    border-bottom-width: 2px !important;\n    border-top-width: 0px;\n    border-left-width: 0px;\n    border-right-width: 0px;\n}\n\n.dhvc-form-group .dhvc-form-label, .dhvc-form-group label {\n    display: inline-block;\n    font-weight: 400 !important;\n    font-size: 14px;\n    line-height: 1.42857;\n    margin-bottom: 5px;\n}\n\n.dhvc-form-group .dhvc-form-add-on {\n    z-index: 100 !important;\n}\n\n.dhvc-form-input.dhvc-form-has-add-on .dhvc-form-control {\n    background-color: #fff !important;\n}\n\ndiv.dhvc-form-action.dhvc_form_submit_button > button[type=\"submit\"]:not(.w-btn) {\n    padding-top: 13px !important;\n}\n\n/* FIM dhcv */\n\n/* colunas stacked */\n\n@media (max-width: 600px) {\n.g-cols.wpb_row.ignorestack.via_grid.cols_2.laptops-cols_inherit.tablets-cols_inherit.mobiles-cols_1.valign_top.type_default.stacking_default {\n    grid-template-columns: repeat(2,1fr) !important;\n}\n.g-cols.wpb_row.ignorestack.via_grid.cols_3.laptops-cols_inherit.tablets-cols_inherit.mobiles-cols_1.valign_top.type_default.stacking_default {\n    grid-template-columns: repeat(2,1fr) !important;\n}\n.g-cols.wpb_row.ignorestack.via_grid.cols_4.laptops-cols_inherit.tablets-cols_inherit.mobiles-cols_1.valign_top.type_default.stacking_default {\n    grid-template-columns: repeat(2,1fr) !important;\n}\n.g-cols.wpb_row.ignorestack.via_grid.cols_5.laptops-cols_inherit.tablets-cols_inherit.mobiles-cols_1.valign_top.type_default.stacking_default {\n    grid-template-columns: repeat(2,1fr) !important;\n}\n\n    }\n\n/* FIM colunas stacked */\n\n/* mouse-hover com ampliação da imagem */\n\n.tfzindex {\n	z-index: 100 !important;\n}\n\n.overflowesconder {\n	overflow: hidden !important;\n}\n\n\n.hover01 {\n	-webkit-transform: scale(1);\n	transform: scale(1);\n	-webkit-transition: .3s ease-in-out;\n	transition: .3s ease-in-out;\n		overflow: hidden !important;\n}\n.hover01:hover {\n	-webkit-transform: scale(1.15);\n	transform: scale(1.15);\n	overflow: hidden !important;\n}\n\n.shift01 {\n	-webkit-transform: translateY(0);;\n	transform: translateY(0);;\n	-webkit-transition: .3s ease-in-out;\n	transition: .3s ease-in-out;\n		overflow: hidden !important;\n}\n.shift01:hover {\n	-webkit-transform: translateY(-10px);\n	transform: translateY(-10px);\n	overflow: hidden !important;\n}\n\n/* FIM mouse-hover com ampliação da imagem */\n\n\n/* novo ken-burns que funciona com image-background */\n\n.image-wrap2 {\n  overflow: hidden;\n  position: relative;\n}\n\n.image-wrap2::before {\n  content: \"\";\n  position: absolute;\n  top: 0;\n  left: 0;\n  width: 110%;\n  height: 110%;\n  background-image: inherit;\n  background-size: cover;\n  background-position: center;\n  animation: kenburns 20s ease-in-out infinite;\n  z-index: 0;\n}\n\n@keyframes kenburns {\n  0% {\n    transform: scale(1) translate(0, 0);\n  }\n  100% {\n    transform: scale(1.1) translate(-2%, -2%);\n  }\n}\n\n\n\n/* Ken Burns - usar class image-wrap */\n\n.image-wrap {\n  margin: 0 auto;\n  overflow: hidden;\n  position: relative;\n}\n\n\n.image-wrap .l-section-img {\n  width: 100%;\n  animation: move 40s ease;\n  /* Add infinite to loop. */\n  \n  -ms-animation: move 40s ease;\n  -webkit-animation: move 40s ease;\n  -0-animation: move 40s ease;\n  -moz-animation: move 40s ease;\n  position: absolute;\n}\n\n@-webkit-keyframes move {\n  0% {\n    -webkit-transform-origin: bottom left;\n    -moz-transform-origin: bottom left;\n    -ms-transform-origin: bottom left;\n    -o-transform-origin: bottom left;\n    transform-origin: bottom left;\n    transform: scale(1.0);\n    -ms-transform: scale(1.0);\n    /* IE 9 */\n    \n    -webkit-transform: scale(1.0);\n    /* Safari and Chrome */\n    \n    -o-transform: scale(1.0);\n    /* Opera */\n    \n    -moz-transform: scale(1.0);\n    /* Firefox */\n  }\n  100% {\n    transform: scale(1.2);\n    -ms-transform: scale(1.2);\n    /* IE 9 */\n    \n    -webkit-transform: scale(1.2);\n    /* Safari and Chrome */\n    \n    -o-transform: scale(1.2);\n    /* Opera */\n    \n    -moz-transform: scale(1.2);\n    /* Firefox */\n  }\n}\n/*  FIM Ken Burns */\n\n/* title stroke */\n\n.titlestrokeverde::after {\ndisplay: block;\nclear: both;\ncontent: \"\";\nposition: absolute;\nmax-width: 26px;\nheight: 1px;\nwidth: 39%;\nborder-bottom: 1px solid #009745;\nmargin: 0 auto;\npadding: 4px 0px;\n}\n\n.titlestrokegrey::after {\ndisplay: block;\nclear: both;\ncontent: \"\";\nposition: absolute;\nmax-width: 26px;\nheight: 1px;\nwidth: 39%;\nborder-bottom: 1px solid #414042;\nmargin: 0 auto;\npadding: 4px 0px;\n}\n\n.titlestrokeverdecenter::after {\ndisplay: block;\nclear: both;\ncontent: \"\";\nposition: relative;\nmax-width: 26px;\nheight: 1px;\nwidth: 39%;\nborder-bottom: 1px solid #009745;\nmargin: 0 auto;\npadding: 4px 0px;\n}\n\n\n\n\";s:16:\"custom_html_head\";s:0:\"\";s:16:\"custom_html_body\";s:0:\"\";s:11:\"custom_html\";s:0:\"\";s:8:\"of_reset\";s:0:\"\";s:9:\"of_backup\";s:0:\"\";s:11:\"of_transfer\";s:0:\"\";s:11:\"white_label\";i:0;s:22:\"white_label_theme_name\";s:0:\"\";s:28:\"white_label_theme_screenshot\";s:0:\"\";s:22:\"white_label_theme_icon\";s:0:\"\";s:22:\"white_label_login_icon\";s:0:\"\";s:19:\"h_tax_product_brand\";s:0:\"\";s:27:\"header_tax_product_brand_id\";s:12:\"__defaults__\";s:29:\"titlebar_tax_product_brand_id\";s:12:\"__defaults__\";s:28:\"content_tax_product_brand_id\";s:12:\"__defaults__\";s:28:\"sidebar_tax_product_brand_id\";s:12:\"__defaults__\";s:29:\"sidebar_tax_product_brand_pos\";s:5:\"right\";s:27:\"footer_tax_product_brand_id\";s:12:\"__defaults__\";s:17:\"h_tax_product_cat\";s:0:\"\";s:25:\"header_tax_product_cat_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_product_cat_id\";s:2:\"10\";s:26:\"content_tax_product_cat_id\";s:2:\"58\";s:26:\"sidebar_tax_product_cat_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_product_cat_pos\";s:5:\"right\";s:25:\"footer_tax_product_cat_id\";s:12:\"__defaults__\";s:17:\"h_tax_product_tag\";s:0:\"\";s:25:\"header_tax_product_tag_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_product_tag_id\";s:12:\"__defaults__\";s:26:\"content_tax_product_tag_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_product_tag_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_product_tag_pos\";s:5:\"right\";s:25:\"footer_tax_product_tag_id\";s:12:\"__defaults__\";s:22:\"keyboard_accessibility\";i:0;s:12:\"ajax_load_js\";i:1;s:16:\"h1_letterspacing\";s:3:\"0em\";s:16:\"h2_letterspacing\";s:3:\"0em\";s:16:\"h3_letterspacing\";s:3:\"0em\";s:16:\"h4_letterspacing\";s:3:\"0em\";s:16:\"h5_letterspacing\";s:3:\"0em\";s:16:\"h6_letterspacing\";s:3:\"0em\";s:12:\"h_slide_home\";s:0:\"\";s:20:\"header_slide_home_id\";s:12:\"__defaults__\";s:22:\"titlebar_slide_home_id\";s:12:\"__defaults__\";s:21:\"content_slide_home_id\";s:12:\"__defaults__\";s:21:\"sidebar_slide_home_id\";s:12:\"__defaults__\";s:22:\"sidebar_slide_home_pos\";s:5:\"right\";s:20:\"footer_slide_home_id\";s:12:\"__defaults__\";s:29:\"header_wpb_gutenberg_param_id\";s:12:\"__defaults__\";s:31:\"titlebar_wpb_gutenberg_param_id\";s:12:\"__defaults__\";s:30:\"content_wpb_gutenberg_param_id\";s:12:\"__defaults__\";s:30:\"sidebar_wpb_gutenberg_param_id\";s:12:\"__defaults__\";s:29:\"footer_wpb_gutenberg_param_id\";s:12:\"__defaults__\";}", "on");
INSERT INTO `wp_options` VALUES("194", "widget_us_contacts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("195", "widget_us_login", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("196", "widget_us_portfolio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("197", "widget_us_blog", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("198", "widget_us_socials", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("199", "Impreza_editor_caps_set", "1", "yes");
INSERT INTO `wp_options` VALUES("200", "usof_color_palette_Impreza", "a:8:{i:0;s:39:\"linear-gradient(135deg,#e95095,#7049ba)\";i:1;s:39:\"linear-gradient(135deg,#7049ba,#e95095)\";i:2;s:7:\"#1a1a1a\";i:3;s:4:\"#333\";i:4;s:4:\"#999\";i:5;s:7:\"#e8e8e8\";i:6;s:7:\"#f5f5f5\";i:7;s:4:\"#fff\";}", "yes");
INSERT INTO `wp_options` VALUES("201", "us_theme_options_css", ":root{--color-principal:#86367D;--color-link:#C20A72;--color-secundaria:#6C2470;--color-vivo:#A73089;--color-dark:#361D4A;--color-fundo1:#F8F8F8;--color-fundo2:#fceaf4;--color-branco:#fff;--color-header-middle-bg:#ffffff;--color-header-middle-bg-grad:#ffffff;--color-header-middle-text:#C20A72;--color-header-middle-text-hover:#fceaf4;--color-header-transparent-bg:transparent;--color-header-transparent-bg-grad:transparent;--color-header-transparent-text:#ffffff;--color-header-transparent-text-hover:#ffffff;--color-chrome-toolbar:#f5f5f5;--color-header-top-bg:#f5f5f5;--color-header-top-bg-grad:linear-gradient(0deg,#f5f5f5,#fff);--color-header-top-text:#333333;--color-header-top-text-hover:#e95095;--color-header-top-transparent-bg:rgba(0,0,0,0.2);--color-header-top-transparent-bg-grad:rgba(0,0,0,0.2);--color-header-top-transparent-text:rgba(255,255,255,0.66);--color-header-top-transparent-text-hover:#ffffff;--color-content-bg:#fff;--color-content-bg-grad:#fff;--color-content-bg-alt:#F8F8F8;--color-content-bg-alt-grad:#F8F8F8;--color-content-border:#e8e8e8;--color-content-heading:#86367D;--color-content-heading-grad:#86367D;--color-content-text:#333333;--color-content-link:#C20A72;--color-content-link-hover:#361D4A;--color-content-primary:#86367D;--color-content-primary-grad:#86367D;--color-content-secondary:#6C2470;--color-content-secondary-grad:#6C2470;--color-content-faded:#999999;--color-content-overlay:rgba(0,0,0,0.75);--color-content-overlay-grad:rgba(0,0,0,0.75);--color-alt-content-bg:#f5f5f5;--color-alt-content-bg-grad:#f5f5f5;--color-alt-content-bg-alt:#a1cce4;--color-alt-content-bg-alt-grad:#a1cce4;--color-alt-content-border:#dddddd;--color-alt-content-heading:#1a1a1a;--color-alt-content-heading-grad:#1a1a1a;--color-alt-content-text:#333333;--color-alt-content-link:#e95095;--color-alt-content-link-hover:#7049ba;--color-alt-content-primary:#e95095;--color-alt-content-primary-grad:linear-gradient(135deg,#e95095,#7049ba);--color-alt-content-secondary:#7049ba;--color-alt-content-secondary-grad:linear-gradient(135deg,#7049ba,#e95095);--color-alt-content-faded:#999999;--color-alt-content-overlay:#e95095;--color-alt-content-overlay-grad:linear-gradient(135deg,#e95095,rgba(233,80,149,0.75));--color-footer-bg:#222222;--color-footer-bg-grad:#222222;--color-footer-bg-alt:#1a1a1a;--color-footer-bg-alt-grad:#1a1a1a;--color-footer-border:#333333;--color-footer-heading:#cccccc;--color-footer-heading-grad:#cccccc;--color-footer-text:#999999;--color-footer-link:#cccccc;--color-footer-link-hover:#e95095;--color-subfooter-bg:#1a1a1a;--color-subfooter-bg-grad:#1a1a1a;--color-subfooter-bg-alt:#222222;--color-subfooter-bg-alt-grad:#222222;--color-subfooter-border:#282828;--color-subfooter-heading:#cccccc;--color-subfooter-heading-grad:#cccccc;--color-subfooter-text:#bbbbbb;--color-subfooter-link:#ffffff;--color-subfooter-link-hover:#e95095;--color-content-primary-faded:rgba(134,54,125,0.15);--box-shadow:0 5px 15px rgba(0,0,0,.15);--box-shadow-up:0 -5px 15px rgba(0,0,0,.15);--site-canvas-width:1300px;--site-content-width:1140px;--site-sidebar-width:25%;--text-block-margin-bottom:0rem;--focus-outline-width:2px}:root{--font-family:Montserrat,sans-serif;--font-size:17px;--line-height:25px;--font-weight:400;--bold-font-weight:700;--text-transform:none;--font-style:normal;--letter-spacing:0em;--h1-font-family:inherit;--h1-font-size:max( 4rem,4vw );--h1-line-height:1.2;--h1-font-weight:300;--h1-bold-font-weight:800;--h1-text-transform:none;--h1-font-style:normal;--h1-letter-spacing:0em;--h1-margin-bottom:0.6em;--h2-font-family:var(--h1-font-family);--h2-font-size:max( 2.3rem,2.3vw );--h2-line-height:1.2;--h2-font-weight:500;--h2-bold-font-weight:600;--h2-text-transform:var(--h1-text-transform);--h2-font-style:var(--h1-font-style);--h2-letter-spacing:0em;--h2-margin-bottom:0.6em;--h3-font-family:var(--h1-font-family);--h3-font-size:max( 1.7rem,1.7vw );--h3-line-height:1.2;--h3-font-weight:200;--h3-bold-font-weight:900;--h3-text-transform:var(--h1-text-transform);--h3-font-style:var(--h1-font-style);--h3-letter-spacing:0em;--h3-margin-bottom:0.6em;--h4-font-family:var(--h1-font-family);--h4-font-size:max( 1.5rem,1.5vw );--h4-line-height:1.2;--h4-font-weight:var(--h1-font-weight);--h4-bold-font-weight:var(--h1-bold-font-weight);--h4-text-transform:var(--h1-text-transform);--h4-font-style:var(--h1-font-style);--h4-letter-spacing:0em;--h4-margin-bottom:0.6em;--h5-font-family:var(--h1-font-family);--h5-font-size:max( 1.3rem,1.3vw );--h5-line-height:1.2;--h5-font-weight:var(--h1-font-weight);--h5-bold-font-weight:var(--h1-bold-font-weight);--h5-text-transform:var(--h1-text-transform);--h5-font-style:var(--h1-font-style);--h5-letter-spacing:0em;--h5-margin-bottom:0.6em;--h6-font-family:var(--h1-font-family);--h6-font-size:max( 1.2rem,1.2vw );--h6-line-height:1.2;--h6-font-weight:var(--h1-font-weight);--h6-bold-font-weight:var(--h1-bold-font-weight);--h6-text-transform:var(--h1-text-transform);--h6-font-style:var(--h1-font-style);--h6-letter-spacing:0em;--h6-margin-bottom:0.6em}@media (min-width:1025px) and (max-width:1380px){:root{--font-size:18px}}@media (min-width:601px) and (max-width:1024px){:root{--font-size:18px}}@media (max-width:600px){:root{--font-size:16px}}h1{font-family:var(--h1-font-family,inherit);font-weight:var(--h1-font-weight,inherit);font-size:var(--h1-font-size,inherit);font-style:var(--h1-font-style,inherit);line-height:var(--h1-line-height,1.4);letter-spacing:var(--h1-letter-spacing,inherit);text-transform:var(--h1-text-transform,inherit);margin-bottom:var(--h1-margin-bottom,1.5rem)}h1>strong{font-weight:var(--h1-bold-font-weight,bold)}h2{font-family:var(--h2-font-family,inherit);font-weight:var(--h2-font-weight,inherit);font-size:var(--h2-font-size,inherit);font-style:var(--h2-font-style,inherit);line-height:var(--h2-line-height,1.4);letter-spacing:var(--h2-letter-spacing,inherit);text-transform:var(--h2-text-transform,inherit);margin-bottom:var(--h2-margin-bottom,1.5rem)}h2>strong{font-weight:var(--h2-bold-font-weight,bold)}h3{font-family:var(--h3-font-family,inherit);font-weight:var(--h3-font-weight,inherit);font-size:var(--h3-font-size,inherit);font-style:var(--h3-font-style,inherit);line-height:var(--h3-line-height,1.4);letter-spacing:var(--h3-letter-spacing,inherit);text-transform:var(--h3-text-transform,inherit);margin-bottom:var(--h3-margin-bottom,1.5rem)}h3>strong{font-weight:var(--h3-bold-font-weight,bold)}h4{font-family:var(--h4-font-family,inherit);font-weight:var(--h4-font-weight,inherit);font-size:var(--h4-font-size,inherit);font-style:var(--h4-font-style,inherit);line-height:var(--h4-line-height,1.4);letter-spacing:var(--h4-letter-spacing,inherit);text-transform:var(--h4-text-transform,inherit);margin-bottom:var(--h4-margin-bottom,1.5rem)}h4>strong{font-weight:var(--h4-bold-font-weight,bold)}h5{font-family:var(--h5-font-family,inherit);font-weight:var(--h5-font-weight,inherit);font-size:var(--h5-font-size,inherit);font-style:var(--h5-font-style,inherit);line-height:var(--h5-line-height,1.4);letter-spacing:var(--h5-letter-spacing,inherit);text-transform:var(--h5-text-transform,inherit);margin-bottom:var(--h5-margin-bottom,1.5rem)}h5>strong{font-weight:var(--h5-bold-font-weight,bold)}h6{font-family:var(--h6-font-family,inherit);font-weight:var(--h6-font-weight,inherit);font-size:var(--h6-font-size,inherit);font-style:var(--h6-font-style,inherit);line-height:var(--h6-line-height,1.4);letter-spacing:var(--h6-letter-spacing,inherit);text-transform:var(--h6-text-transform,inherit);margin-bottom:var(--h6-margin-bottom,1.5rem)}h6>strong{font-weight:var(--h6-bold-font-weight,bold)}body{background:var(--color-content-bg-alt)}@media (max-width:1225px){.l-main .aligncenter{max-width:calc(100vw - 5rem)}}@media (min-width:1381px){body.usb_preview .hide_on_default{opacity:0.25!important}.vc_hidden-lg,body:not(.usb_preview) .hide_on_default{display:none!important}.default_align_left{text-align:left;justify-content:flex-start}.default_align_right{text-align:right;justify-content:flex-end}.default_align_center{text-align:center;justify-content:center}.w-hwrapper.default_align_center>*{margin-left:calc( var(--hwrapper-gap,1.2rem) / 2 );margin-right:calc( var(--hwrapper-gap,1.2rem) / 2 )}.default_align_justify{justify-content:space-between}.w-hwrapper>.default_align_justify,.default_align_justify>.w-btn{width:100%}*:not(.w-hwrapper)>.w-btn-wrapper:not([class*=\"default_align_none\"]):not(.align_none){display:block;margin-inline-end:0}}@media (min-width:1025px) and (max-width:1380px){body.usb_preview .hide_on_laptops{opacity:0.25!important}.vc_hidden-md,body:not(.usb_preview) .hide_on_laptops{display:none!important}.laptops_align_left{text-align:left;justify-content:flex-start}.laptops_align_right{text-align:right;justify-content:flex-end}.laptops_align_center{text-align:center;justify-content:center}.w-hwrapper.laptops_align_center>*{margin-left:calc( var(--hwrapper-gap,1.2rem) / 2 );margin-right:calc( var(--hwrapper-gap,1.2rem) / 2 )}.laptops_align_justify{justify-content:space-between}.w-hwrapper>.laptops_align_justify,.laptops_align_justify>.w-btn{width:100%}*:not(.w-hwrapper)>.w-btn-wrapper:not([class*=\"laptops_align_none\"]):not(.align_none){display:block;margin-inline-end:0}.g-cols.via_grid[style*=\"--laptops-columns-gap\"]{gap:var(--laptops-columns-gap,3rem)}}@media (min-width:601px) and (max-width:1024px){body.usb_preview .hide_on_tablets{opacity:0.25!important}.vc_hidden-sm,body:not(.usb_preview) .hide_on_tablets{display:none!important}.tablets_align_left{text-align:left;justify-content:flex-start}.tablets_align_right{text-align:right;justify-content:flex-end}.tablets_align_center{text-align:center;justify-content:center}.w-hwrapper.tablets_align_center>*{margin-left:calc( var(--hwrapper-gap,1.2rem) / 2 );margin-right:calc( var(--hwrapper-gap,1.2rem) / 2 )}.tablets_align_justify{justify-content:space-between}.w-hwrapper>.tablets_align_justify,.tablets_align_justify>.w-btn{width:100%}*:not(.w-hwrapper)>.w-btn-wrapper:not([class*=\"tablets_align_none\"]):not(.align_none){display:block;margin-inline-end:0}.g-cols.via_grid[style*=\"--tablets-columns-gap\"]{gap:var(--tablets-columns-gap,3rem)}}@media (max-width:600px){body.usb_preview .hide_on_mobiles{opacity:0.25!important}.vc_hidden-xs,body:not(.usb_preview) .hide_on_mobiles{display:none!important}.mobiles_align_left{text-align:left;justify-content:flex-start}.mobiles_align_right{text-align:right;justify-content:flex-end}.mobiles_align_center{text-align:center;justify-content:center}.w-hwrapper.mobiles_align_center>*{margin-left:calc( var(--hwrapper-gap,1.2rem) / 2 );margin-right:calc( var(--hwrapper-gap,1.2rem) / 2 )}.mobiles_align_justify{justify-content:space-between}.w-hwrapper>.mobiles_align_justify,.mobiles_align_justify>.w-btn{width:100%}.w-hwrapper.stack_on_mobiles{display:block}.w-hwrapper.stack_on_mobiles>:not(script){display:block;margin:0 0 var(--hwrapper-gap,1.2rem)}.w-hwrapper.stack_on_mobiles>:last-child{margin-bottom:0}*:not(.w-hwrapper)>.w-btn-wrapper:not([class*=\"mobiles_align_none\"]):not(.align_none){display:block;margin-inline-end:0}.g-cols.via_grid[style*=\"--mobiles-columns-gap\"]{gap:var(--mobiles-columns-gap,1.5rem)}}@media (max-width:1380px){.g-cols.laptops-cols_1{grid-template-columns:100%}.g-cols.laptops-cols_1.reversed>div:last-of-type{order:-1}.g-cols.laptops-cols_2{grid-template-columns:repeat(2,1fr)}.g-cols.laptops-cols_3{grid-template-columns:repeat(3,1fr)}.g-cols.laptops-cols_4{grid-template-columns:repeat(4,1fr)}.g-cols.laptops-cols_5{grid-template-columns:repeat(5,1fr)}.g-cols.laptops-cols_6{grid-template-columns:repeat(6,1fr)}.g-cols.laptops-cols_1-2{grid-template-columns:1fr 2fr}.g-cols.laptops-cols_2-1{grid-template-columns:2fr 1fr}.g-cols.laptops-cols_2-3{grid-template-columns:2fr 3fr}.g-cols.laptops-cols_3-2{grid-template-columns:3fr 2fr}.g-cols.laptops-cols_1-3{grid-template-columns:1fr 3fr}.g-cols.laptops-cols_3-1{grid-template-columns:3fr 1fr}.g-cols.laptops-cols_1-4{grid-template-columns:1fr 4fr}.g-cols.laptops-cols_4-1{grid-template-columns:4fr 1fr}.g-cols.laptops-cols_1-5{grid-template-columns:1fr 5fr}.g-cols.laptops-cols_5-1{grid-template-columns:5fr 1fr}.g-cols.laptops-cols_1-2-1{grid-template-columns:1fr 2fr 1fr}.g-cols.laptops-cols_1-3-1{grid-template-columns:1fr 3fr 1fr}.g-cols.laptops-cols_1-4-1{grid-template-columns:1fr 4fr 1fr}}@media (max-width:1024px){.g-cols.tablets-cols_1{grid-template-columns:100%}.g-cols.tablets-cols_1.reversed>div:last-of-type{order:-1}.g-cols.tablets-cols_2{grid-template-columns:repeat(2,1fr)}.g-cols.tablets-cols_3{grid-template-columns:repeat(3,1fr)}.g-cols.tablets-cols_4{grid-template-columns:repeat(4,1fr)}.g-cols.tablets-cols_5{grid-template-columns:repeat(5,1fr)}.g-cols.tablets-cols_6{grid-template-columns:repeat(6,1fr)}.g-cols.tablets-cols_1-2{grid-template-columns:1fr 2fr}.g-cols.tablets-cols_2-1{grid-template-columns:2fr 1fr}.g-cols.tablets-cols_2-3{grid-template-columns:2fr 3fr}.g-cols.tablets-cols_3-2{grid-template-columns:3fr 2fr}.g-cols.tablets-cols_1-3{grid-template-columns:1fr 3fr}.g-cols.tablets-cols_3-1{grid-template-columns:3fr 1fr}.g-cols.tablets-cols_1-4{grid-template-columns:1fr 4fr}.g-cols.tablets-cols_4-1{grid-template-columns:4fr 1fr}.g-cols.tablets-cols_1-5{grid-template-columns:1fr 5fr}.g-cols.tablets-cols_5-1{grid-template-columns:5fr 1fr}.g-cols.tablets-cols_1-2-1{grid-template-columns:1fr 2fr 1fr}.g-cols.tablets-cols_1-3-1{grid-template-columns:1fr 3fr 1fr}.g-cols.tablets-cols_1-4-1{grid-template-columns:1fr 4fr 1fr}}@media (max-width:600px){.g-cols.mobiles-cols_1{grid-template-columns:100%}.g-cols.mobiles-cols_1.reversed>div:last-of-type{order:-1}.g-cols.mobiles-cols_2{grid-template-columns:repeat(2,1fr)}.g-cols.mobiles-cols_3{grid-template-columns:repeat(3,1fr)}.g-cols.mobiles-cols_4{grid-template-columns:repeat(4,1fr)}.g-cols.mobiles-cols_5{grid-template-columns:repeat(5,1fr)}.g-cols.mobiles-cols_6{grid-template-columns:repeat(6,1fr)}.g-cols.mobiles-cols_1-2{grid-template-columns:1fr 2fr}.g-cols.mobiles-cols_2-1{grid-template-columns:2fr 1fr}.g-cols.mobiles-cols_2-3{grid-template-columns:2fr 3fr}.g-cols.mobiles-cols_3-2{grid-template-columns:3fr 2fr}.g-cols.mobiles-cols_1-3{grid-template-columns:1fr 3fr}.g-cols.mobiles-cols_3-1{grid-template-columns:3fr 1fr}.g-cols.mobiles-cols_1-4{grid-template-columns:1fr 4fr}.g-cols.mobiles-cols_4-1{grid-template-columns:4fr 1fr}.g-cols.mobiles-cols_1-5{grid-template-columns:1fr 5fr}.g-cols.mobiles-cols_5-1{grid-template-columns:5fr 1fr}.g-cols.mobiles-cols_1-2-1{grid-template-columns:1fr 2fr 1fr}.g-cols.mobiles-cols_1-3-1{grid-template-columns:1fr 3fr 1fr}.g-cols.mobiles-cols_1-4-1{grid-template-columns:1fr 4fr 1fr}.g-cols:not([style*=\"--columns-gap\"]){gap:1.5rem}}@media (max-width:599px){.l-canvas{overflow:hidden}.g-cols.stacking_default.reversed>div:last-of-type{order:-1}.g-cols.stacking_default.via_flex>div:not([class*=\"vc_col-xs\"]){width:100%;margin:0 0 1.5rem}.g-cols.stacking_default.via_grid.mobiles-cols_1{grid-template-columns:100%}.g-cols.stacking_default.via_flex.type_boxes>div,.g-cols.stacking_default.via_flex.reversed>div:first-child,.g-cols.stacking_default.via_flex:not(.reversed)>div:last-child,.g-cols.stacking_default.via_flex>div.has_bg_color{margin-bottom:0}.g-cols.stacking_default.via_flex.type_default>.wpb_column.stretched{margin-left:-1rem;margin-right:-1rem}.g-cols.stacking_default.via_grid.mobiles-cols_1>.wpb_column.stretched,.g-cols.stacking_default.via_flex.type_boxes>.wpb_column.stretched{margin-left:-2.5rem;margin-right:-2.5rem;width:auto}.vc_column-inner.type_sticky>.wpb_wrapper,.vc_column_container.type_sticky>.vc_column-inner{top:0!important}}@media (min-width:600px){body:not(.rtl) .l-section.for_sidebar.at_left>div>.l-sidebar,.rtl .l-section.for_sidebar.at_right>div>.l-sidebar{order:-1}.vc_column_container.type_sticky>.vc_column-inner,.vc_column-inner.type_sticky>.wpb_wrapper{position:-webkit-sticky;position:sticky}.l-section.type_sticky{position:-webkit-sticky;position:sticky;top:0;z-index:11;transition:top 0.3s cubic-bezier(.78,.13,.15,.86) 0.1s}.header_hor .l-header.post_fixed.sticky_auto_hide{z-index:12}.admin-bar .l-section.type_sticky{top:32px}.l-section.type_sticky>.l-section-h{transition:padding-top 0.3s}.header_hor .l-header.pos_fixed:not(.down)~.l-main .l-section.type_sticky:not(:first-of-type){top:var(--header-sticky-height)}.admin-bar.header_hor .l-header.pos_fixed:not(.down)~.l-main .l-section.type_sticky:not(:first-of-type){top:calc( var(--header-sticky-height) + 32px )}.header_hor .l-header.pos_fixed.sticky:not(.down)~.l-main .l-section.type_sticky:first-of-type>.l-section-h{padding-top:var(--header-sticky-height)}.header_hor.headerinpos_bottom .l-header.pos_fixed.sticky:not(.down)~.l-main .l-section.type_sticky:first-of-type>.l-section-h{padding-bottom:var(--header-sticky-height)!important}}@media screen and (min-width:1225px){.g-cols.via_flex.type_default>.wpb_column.stretched:first-of-type{margin-inline-start:min( calc( var(--site-content-width) / 2 + 0px / 2 + 1.5rem - 50vw),-1rem )}.g-cols.via_flex.type_default>.wpb_column.stretched:last-of-type{margin-inline-end:min( calc( var(--site-content-width) / 2 + 0px / 2 + 1.5rem - 50vw),-1rem )}.l-main .alignfull, .w-separator.width_screen,.g-cols.via_grid>.wpb_column.stretched:first-of-type,.g-cols.via_flex.type_boxes>.wpb_column.stretched:first-of-type{margin-inline-start:min( calc( var(--site-content-width) / 2 + 0px / 2 - 50vw ),-2.5rem )}.l-main .alignfull, .w-separator.width_screen,.g-cols.via_grid>.wpb_column.stretched:last-of-type,.g-cols.via_flex.type_boxes>.wpb_column.stretched:last-of-type{margin-inline-end:min( calc( var(--site-content-width) / 2 + 0px / 2 - 50vw ),-2.5rem )}}@media (max-width:600px){.w-form-row.for_submit[style*=btn-size-mobiles] .w-btn{font-size:var(--btn-size-mobiles)!important}}:focus-visible,input[type=checkbox]:focus-visible + i,input[type=checkbox]:focus-visible~.w-color-switch-box,.w-nav-arrow:focus-visible::before,.woocommerce-mini-cart-item:has(:focus-visible),.w-filter-item-value.w-btn:has(:focus-visible){outline-width:var(--focus-outline-width,2px );outline-style:solid;outline-offset:2px;outline-color:var(--color-content-primary)}.w-toplink,.w-header-show{background:rgba(0,0,0,0.3)}.no-touch .w-toplink.active:hover,.no-touch .w-header-show:hover{background:var(--color-content-primary-grad)}button[type=submit]:not(.w-btn),input[type=submit]:not(.w-btn),.us-nav-style_1>*,.navstyle_1>.owl-nav button,.us-btn-style_1{font-style:normal;text-transform:none;font-size:14px;line-height:1.2!important;font-weight:700;letter-spacing:0.06em;padding:0.9em 2.0em;transition-duration:0.3s;border-radius:0.0em;transition-timing-function:ease;--btn-height:calc(1.2em + 2 * 0.9em);background:var(--color-content-primary);border-color:transparent;border-image:none;color:#ffffff!important}button[type=submit]:not(.w-btn):before,input[type=submit]:not(.w-btn),.us-nav-style_1>*:before,.navstyle_1>.owl-nav button:before,.us-btn-style_1:before{border-width:0px}.no-touch button[type=submit]:not(.w-btn):hover,.no-touch input[type=submit]:not(.w-btn):hover,.w-filter-item-value.us-btn-style_1:has(input:checked),.us-nav-style_1>span.current,.no-touch .us-nav-style_1>a:hover,.no-touch .navstyle_1>.owl-nav button:hover,.no-touch .us-btn-style_1:hover{background:var(--color-content-secondary);border-color:transparent;border-image:none;color:#ffffff!important}.us-nav-style_4>*,.navstyle_4>.owl-nav button,.us-btn-style_4{font-style:normal;text-transform:none;font-size:14px;line-height:1.2!important;font-weight:700;letter-spacing:0.06em;padding:0.9em 2.0em;transition-duration:0.3s;border-radius:0.0em;transition-timing-function:ease;--btn-height:calc(1.2em + 2 * 0.9em);background:var(--color-content-secondary);border-color:transparent;border-image:none;color:#ffffff!important}.us-nav-style_4>*:before,.navstyle_4>.owl-nav button:before,.us-btn-style_4:before{border-width:0px}.w-filter-item-value.us-btn-style_4:has(input:checked),.us-nav-style_4>span.current,.no-touch .us-nav-style_4>a:hover,.no-touch .navstyle_4>.owl-nav button:hover,.no-touch .us-btn-style_4:hover{background:var(--color-dark);border-color:transparent;border-image:none;color:#ffffff!important}.us-nav-style_3>*,.navstyle_3>.owl-nav button,.us-btn-style_3{font-style:normal;text-transform:uppercase;font-size:14px;line-height:1.2!important;font-weight:700;letter-spacing:0.03em;padding:1.0em 2.0em;transition-duration:0.3s;border-radius:0.0em;transition-timing-function:ease;--btn-height:calc(1.2em + 2 * 1.0em);background:transparent;border-color:var(--color-content-primary);border-image:none;color:var(--color-content-primary)!important}.us-nav-style_3>*:before,.navstyle_3>.owl-nav button:before,.us-btn-style_3:before{border-width:1px}.w-filter-item-value.us-btn-style_3:has(input:checked),.us-nav-style_3>span.current,.no-touch .us-nav-style_3>a:hover,.no-touch .navstyle_3>.owl-nav button:hover,.no-touch .us-btn-style_3:hover{background:var(--color-content-secondary);border-color:transparent;border-image:none;color:#ffffff!important}.us-nav-style_2>*,.navstyle_2>.owl-nav button,.us-btn-style_2{font-style:normal;text-transform:none;font-size:13px;line-height:1.20!important;font-weight:600;letter-spacing:0.04em;padding:0.4em 0em;transition-duration:0.3s;border-radius:0.0em;transition-timing-function:ease;--btn-height:calc(1.20em + 2 * 0.4em);background:transparent;border-color:transparent;border-image:none;color:var(--color-content-link)!important}.us-nav-style_2>*:before,.navstyle_2>.owl-nav button:before,.us-btn-style_2:before{border-width:0px}.w-filter-item-value.us-btn-style_2:has(input:checked),.us-nav-style_2>span.current,.no-touch .us-nav-style_2>a:hover,.no-touch .navstyle_2>.owl-nav button:hover,.no-touch .us-btn-style_2:hover{background:transparent;border-color:transparent;border-image:none;color:var(--color-content-link-hover)!important}.us-nav-style_6>*,.navstyle_6>.owl-nav button,.us-btn-style_6{font-style:normal;text-transform:none;font-size:13px;line-height:1.20!important;font-weight:600;letter-spacing:0.04em;padding:0.4em 0em;transition-duration:0.3s;border-radius:0.0em;transition-timing-function:ease;--btn-height:calc(1.20em + 2 * 0.4em);background:transparent;border-color:transparent;border-image:none;color:var(--color-fundo2)!important}.us-nav-style_6>*:before,.navstyle_6>.owl-nav button:before,.us-btn-style_6:before{border-width:0px}.w-filter-item-value.us-btn-style_6:has(input:checked),.us-nav-style_6>span.current,.no-touch .us-nav-style_6>a:hover,.no-touch .navstyle_6>.owl-nav button:hover,.no-touch .us-btn-style_6:hover{background:transparent;border-color:transparent;border-image:none;color:#de50a0!important}.us-nav-style_5>*,.navstyle_5>.owl-nav button,.us-btn-style_5{font-style:normal;text-transform:uppercase;font-size:14px;line-height:1.2!important;font-weight:600;letter-spacing:0.06em;padding:0.9em 1.3em;transition-duration:0.3s;border-radius:0.0em;transition-timing-function:ease;--btn-height:calc(1.2em + 2 * 0.9em);background:var(--color-content-secondary);border-color:transparent;border-image:none;color:#ffffff!important}.us-nav-style_5>*:before,.navstyle_5>.owl-nav button:before,.us-btn-style_5:before{border-width:0px}.w-filter-item-value.us-btn-style_5:has(input:checked),.us-nav-style_5>span.current,.no-touch .us-nav-style_5>a:hover,.no-touch .navstyle_5>.owl-nav button:hover,.no-touch .us-btn-style_5:hover{background:#154d04;border-color:transparent;border-image:none;color:#ffffff!important}:root{--inputs-font-family:inherit;--inputs-font-size:1rem;--inputs-font-weight:400;--inputs-letter-spacing:0em;--inputs-text-transform:none;--inputs-height:2.8rem;--inputs-padding:0.8rem;--inputs-checkbox-size:1.5em;--inputs-border-width:0px;--inputs-border-radius:0;--inputs-background:var(--color-content-bg-alt);--inputs-border-color:var(--color-content-border);--inputs-text-color:var(--color-content-text);--inputs-box-shadow:0px 1px 0px 0px rgba(0,0,0,0.08) inset;--inputs-focus-background:var(--color-content-bg-alt);--inputs-focus-border-color:var(--color-content-border);--inputs-focus-text-color:var(--color-content-text);--inputs-focus-box-shadow:0px 0px 0px 2px var(--color-content-primary)}.color_alternate input:not([type=submit]),.color_alternate textarea,.color_alternate select,.color_alternate .move_label .w-form-row-label{background:var(--color-alt-content-bg-alt-grad)}.color_footer-top input:not([type=submit]),.color_footer-top textarea,.color_footer-top select,.color_footer-top .w-form-row.move_label .w-form-row-label{background:var(--color-subfooter-bg-alt-grad)}.color_footer-bottom input:not([type=submit]),.color_footer-bottom textarea,.color_footer-bottom select,.color_footer-bottom .w-form-row.move_label .w-form-row-label{background:var(--color-footer-bg-alt-grad)}.color_alternate input:not([type=submit]),.color_alternate textarea,.color_alternate select{border-color:var(--color-alt-content-border)}.color_footer-top input:not([type=submit]),.color_footer-top textarea,.color_footer-top select{border-color:var(--color-subfooter-border)}.color_footer-bottom input:not([type=submit]),.color_footer-bottom textarea,.color_footer-bottom select{border-color:var(--color-footer-border)}.color_alternate input:not([type=submit]),.color_alternate textarea,.color_alternate select,.color_alternate .w-form-row-field>i,.color_alternate .w-form-row-field:after,.color_alternate .widget_search form:after,.color_footer-top input:not([type=submit]),.color_footer-top textarea,.color_footer-top select,.color_footer-top .w-form-row-field>i,.color_footer-top .w-form-row-field:after,.color_footer-top .widget_search form:after,.color_footer-bottom input:not([type=submit]),.color_footer-bottom textarea,.color_footer-bottom select,.color_footer-bottom .w-form-row-field>i,.color_footer-bottom .w-form-row-field:after,.color_footer-bottom .widget_search form:after{color:inherit}.leaflet-default-icon-path{background-image:url(https://xpharma.digitalpath.pt/wp-content/themes/Impreza/common/css/vendor/images/marker-icon.png)}", "on");
INSERT INTO `wp_options` VALUES("211", "cpt_custom_post_types", "a:1:{i:8;a:23:{s:9:\"post_type\";s:10:\"slide_home\";s:8:\"supports\";a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";}s:12:\"hierarchical\";b:0;s:10:\"can_export\";b:1;s:16:\"delete_with_user\";b:0;s:10:\"taxonomies\";a:0:{}s:6:\"public\";b:1;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:19:\"exclude_from_search\";b:0;s:15:\"capability_type\";s:4:\"page\";s:12:\"show_in_menu\";b:1;s:17:\"show_in_nav_menus\";b:1;s:17:\"show_in_admin_bar\";b:1;s:13:\"menu_position\";i:5;s:9:\"menu_icon\";s:16:\"dashicons-slides\";s:11:\"has_archive\";b:0;s:7:\"rewrite\";b:1;s:9:\"query_var\";s:10:\"slide_home\";s:12:\"show_in_rest\";b:1;s:5:\"label\";s:11:\"Slide_homep\";s:6:\"labels\";a:3:{s:13:\"singular_name\";s:5:\"Slide\";s:9:\"all_items\";s:6:\"Slides\";s:4:\"name\";s:11:\"Slide_homep\";}s:6:\"status\";s:7:\"publish\";}}", "yes");
INSERT INTO `wp_options` VALUES("212", "cpt_needs_rewrite_rules_update", "", "yes");
INSERT INTO `wp_options` VALUES("223", "duplicator_settings", "a:19:{s:7:\"version\";s:8:\"1.5.13.3\";s:18:\"uninstall_settings\";s:1:\"1\";s:15:\"uninstall_files\";s:1:\"1\";s:13:\"package_debug\";s:1:\"0\";s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";s:1:\"0\";s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";s:1:\"0\";s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";s:1:\"2\";s:17:\"skip_archive_scan\";b:1;s:21:\"unhook_third_party_js\";s:0:\"\";s:22:\"unhook_third_party_css\";s:0:\"\";s:17:\"active_package_id\";i:62;s:14:\"usage_tracking\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("224", "duplicator_version_plugin", "1.5.13.3", "yes");
INSERT INTO `wp_options` VALUES("238", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-15 09:08:54\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:7:\"10.6.23\";s:10:\"VersionPHP\";s:6:\"8.3.26\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20230214_midtemplate\";s:4:\"Hash\";s:35:\"aae4edf98103666b1861_20251015090854\";s:8:\"NameHash\";s:56:\"20230214_midtemplate_aae4edf98103666b1861_20251015090854\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:66:\"20230214_midtemplate_aae4edf98103666b1861_20251015090854_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:34:\"/home/subverti/public_html/xpharma\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:1898;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:13569;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-15 09:08:54\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.2\";s:9:\"VersionDB\";s:7:\"10.6.23\";s:10:\"VersionPHP\";s:6:\"8.3.26\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:20:\"20230214_midtemplate\";s:4:\"Hash\";s:35:\"aae4edf98103666b1861_20251015090854\";s:8:\"NameHash\";s:56:\"20230214_midtemplate_aae4edf98103666b1861_20251015090854\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:48:\"/home/subverti/public_html/xpharma/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:43:\"/home/subverti/public_html/xpharma/wp-admin\";i:1;s:46:\"/home/subverti/public_html/xpharma/wp-includes\";i:2;s:55:\"/home/subverti/public_html/xpharma/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:34:\"/home/subverti/public_html/xpharma\";i:1;s:34:\"/home/subverti/public_html/xpharma\";i:2;s:45:\"/home/subverti/public_html/xpharma/wp-content\";i:3;s:53:\"/home/subverti/public_html/xpharma/wp-content/uploads\";i:4;s:53:\"/home/subverti/public_html/xpharma/wp-content/plugins\";i:5;s:56:\"/home/subverti/public_html/xpharma/wp-content/mu-plugins\";i:6;s:52:\"/home/subverti/public_html/xpharma/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:66:\"/home/subverti/public_html/xpharma/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `wp_options` VALUES("264", "ihaf_activated", "a:2:{s:6:\"wpcode\";i:1676386141;s:7:\"version\";s:5:\"2.0.7\";}", "yes");
INSERT INTO `wp_options` VALUES("265", "wpcode_snippets", "a:1:{s:15:\"after_paragraph\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("266", "wpcode_admin_notices", "a:1:{s:14:\"review_request\";a:2:{s:4:\"time\";i:1676386141;s:9:\"dismissed\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("527", "duplicator_dismissed_admin_notices", "a:1:{s:14:\"review_request\";a:1:{s:4:\"time\";i:1681150312;}}", "yes");
INSERT INTO `wp_options` VALUES("531", "usof_options_Impreza-child", "a:356:{s:16:\"maintenance_mode\";i:0;s:22:\"maintenance_mode_alert\";s:0:\"\";s:16:\"maintenance_page\";s:0:\"\";s:15:\"maintenance_503\";i:0;s:9:\"site_icon\";s:0:\"\";s:10:\"dark_theme\";s:4:\"none\";s:9:\"preloader\";s:8:\"disabled\";s:15:\"preloader_image\";s:0:\"\";s:15:\"img_placeholder\";s:95:\"https://xpharma.digitalpath.pt/xpharma/wp-content/plugins/us-core/assets/images/placeholder.svg\";s:13:\"ripple_effect\";i:0;s:15:\"rounded_corners\";i:1;s:15:\"links_underline\";i:0;s:22:\"keyboard_accessibility\";i:0;s:11:\"back_to_top\";i:1;s:25:\"wrapper_back_to_top_start\";s:0:\"\";s:17:\"back_to_top_style\";s:0:\"\";s:15:\"back_to_top_pos\";s:5:\"right\";s:17:\"back_to_top_color\";s:15:\"rgba(0,0,0,0.3)\";s:19:\"back_to_top_display\";s:5:\"100vh\";s:23:\"wrapper_back_to_top_end\";s:0:\"\";s:13:\"cookie_notice\";i:0;s:20:\"wrapper_cookie_start\";s:0:\"\";s:14:\"cookie_message\";s:106:\"This website uses cookies to improve your experience. If you continue to use this site, you agree with it.\";s:14:\"cookie_privacy\";s:0:\"\";s:18:\"cookie_message_pos\";s:6:\"bottom\";s:16:\"cookie_btn_label\";s:2:\"Ok\";s:16:\"cookie_btn_style\";s:1:\"1\";s:18:\"wrapper_cookie_end\";s:0:\"\";s:22:\"smooth_scroll_duration\";s:6:\"1000ms\";s:13:\"canvas_layout\";s:4:\"wide\";s:13:\"color_body_bg\";s:15:\"_content_bg_alt\";s:13:\"body_bg_image\";s:0:\"\";s:21:\"wrapper_body_bg_start\";s:0:\"\";s:18:\"body_bg_image_size\";s:5:\"cover\";s:20:\"body_bg_image_repeat\";s:6:\"repeat\";s:22:\"body_bg_image_position\";s:8:\"top left\";s:24:\"body_bg_image_attachment\";i:1;s:19:\"wrapper_body_bg_end\";s:0:\"\";s:17:\"site_canvas_width\";s:6:\"1300px\";s:18:\"site_content_width\";s:6:\"1140px\";s:13:\"sidebar_width\";s:3:\"25%\";s:10:\"row_height\";s:6:\"medium\";s:17:\"row_height_custom\";s:5:\"5vmax\";s:18:\"text_bottom_indent\";s:4:\"0rem\";s:13:\"footer_reveal\";i:0;s:21:\"disable_effects_width\";s:5:\"900px\";s:22:\"columns_stacking_width\";s:5:\"600px\";s:18:\"laptops_breakpoint\";s:6:\"1380px\";s:18:\"tablets_breakpoint\";s:6:\"1024px\";s:18:\"mobiles_breakpoint\";s:5:\"600px\";s:11:\"search_page\";s:7:\"default\";s:28:\"exclude_post_types_in_search\";s:0:\"\";s:10:\"posts_page\";s:7:\"default\";s:8:\"page_404\";s:7:\"default\";s:10:\"h_defaults\";s:0:\"\";s:9:\"header_id\";s:0:\"\";s:11:\"titlebar_id\";s:0:\"\";s:10:\"content_id\";s:0:\"\";s:10:\"sidebar_id\";s:0:\"\";s:11:\"sidebar_pos\";s:5:\"right\";s:9:\"footer_id\";s:0:\"\";s:6:\"h_post\";s:0:\"\";s:14:\"header_post_id\";s:12:\"__defaults__\";s:16:\"titlebar_post_id\";s:12:\"__defaults__\";s:15:\"content_post_id\";s:12:\"__defaults__\";s:15:\"sidebar_post_id\";s:12:\"__defaults__\";s:16:\"sidebar_post_pos\";s:5:\"right\";s:14:\"footer_post_id\";s:12:\"__defaults__\";s:18:\"h_archive_defaults\";s:0:\"\";s:17:\"header_archive_id\";s:12:\"__defaults__\";s:19:\"titlebar_archive_id\";s:12:\"__defaults__\";s:18:\"content_archive_id\";s:0:\"\";s:18:\"sidebar_archive_id\";s:12:\"__defaults__\";s:19:\"sidebar_archive_pos\";s:5:\"right\";s:17:\"footer_archive_id\";s:12:\"__defaults__\";s:14:\"h_tax_category\";s:0:\"\";s:22:\"header_tax_category_id\";s:12:\"__defaults__\";s:24:\"titlebar_tax_category_id\";s:12:\"__defaults__\";s:23:\"content_tax_category_id\";s:12:\"__defaults__\";s:23:\"sidebar_tax_category_id\";s:12:\"__defaults__\";s:24:\"sidebar_tax_category_pos\";s:5:\"right\";s:22:\"footer_tax_category_id\";s:12:\"__defaults__\";s:14:\"h_tax_post_tag\";s:0:\"\";s:22:\"header_tax_post_tag_id\";s:12:\"__defaults__\";s:24:\"titlebar_tax_post_tag_id\";s:12:\"__defaults__\";s:23:\"content_tax_post_tag_id\";s:12:\"__defaults__\";s:23:\"sidebar_tax_post_tag_id\";s:12:\"__defaults__\";s:24:\"sidebar_tax_post_tag_pos\";s:5:\"right\";s:22:\"footer_tax_post_tag_id\";s:12:\"__defaults__\";s:17:\"h_tax_post_format\";s:0:\"\";s:25:\"header_tax_post_format_id\";s:12:\"__defaults__\";s:27:\"titlebar_tax_post_format_id\";s:12:\"__defaults__\";s:26:\"content_tax_post_format_id\";s:12:\"__defaults__\";s:26:\"sidebar_tax_post_format_id\";s:12:\"__defaults__\";s:27:\"sidebar_tax_post_format_pos\";s:5:\"right\";s:25:\"footer_tax_post_format_id\";s:12:\"__defaults__\";s:9:\"h_authors\";s:0:\"\";s:16:\"header_author_id\";s:12:\"__defaults__\";s:18:\"titlebar_author_id\";s:12:\"__defaults__\";s:17:\"content_author_id\";s:12:\"__defaults__\";s:17:\"sidebar_author_id\";s:12:\"__defaults__\";s:18:\"sidebar_author_pos\";s:5:\"right\";s:16:\"footer_author_id\";s:12:\"__defaults__\";s:19:\"color_header_top_bg\";s:34:\"linear-gradient(0deg,#f5f5f5,#fff)\";s:21:\"color_header_top_text\";s:4:\"#333\";s:27:\"color_header_top_text_hover\";s:7:\"#e95095\";s:22:\"color_header_middle_bg\";s:4:\"#fff\";s:24:\"color_header_middle_text\";s:4:\"#333\";s:30:\"color_header_middle_text_hover\";s:7:\"#e95095\";s:29:\"color_header_transparent_text\";s:4:\"#fff\";s:35:\"color_header_transparent_text_hover\";s:4:\"#fff\";s:20:\"color_chrome_toolbar\";s:7:\"#f5f5f5\";s:16:\"color_content_bg\";s:4:\"#fff\";s:20:\"color_content_bg_alt\";s:7:\"#f5f5f5\";s:20:\"color_content_border\";s:7:\"#e8e8e8\";s:21:\"color_content_heading\";s:7:\"#1a1a1a\";s:18:\"color_content_text\";s:4:\"#333\";s:18:\"color_content_link\";s:7:\"#e95095\";s:24:\"color_content_link_hover\";s:7:\"#7049ba\";s:21:\"color_content_primary\";s:39:\"linear-gradient(135deg,#e95095,#7049ba)\";s:23:\"color_content_secondary\";s:39:\"linear-gradient(135deg,#7049ba,#e95095)\";s:19:\"color_content_faded\";s:4:\"#999\";s:21:\"color_content_overlay\";s:16:\"rgba(0,0,0,0.75)\";s:20:\"color_alt_content_bg\";s:7:\"#f5f5f5\";s:24:\"color_alt_content_bg_alt\";s:4:\"#fff\";s:24:\"color_alt_content_border\";s:4:\"#ddd\";s:25:\"color_alt_content_heading\";s:7:\"#1a1a1a\";s:22:\"color_alt_content_text\";s:4:\"#333\";s:22:\"color_alt_content_link\";s:7:\"#e95095\";s:28:\"color_alt_content_link_hover\";s:7:\"#7049ba\";s:25:\"color_alt_content_primary\";s:39:\"linear-gradient(135deg,#e95095,#7049ba)\";s:27:\"color_alt_content_secondary\";s:39:\"linear-gradient(135deg,#7049ba,#e95095)\";s:23:\"color_alt_content_faded\";s:4:\"#999\";s:25:\"color_alt_content_overlay\";s:53:\"linear-gradient(135deg,#e95095,rgba(233,80,149,0.75))\";s:15:\"color_footer_bg\";s:4:\"#222\";s:19:\"color_footer_bg_alt\";s:7:\"#1a1a1a\";s:19:\"color_footer_border\";s:4:\"#333\";s:20:\"color_footer_heading\";s:4:\"#ccc\";s:17:\"color_footer_text\";s:4:\"#999\";s:17:\"color_footer_link\";s:4:\"#ccc\";s:23:\"color_footer_link_hover\";s:7:\"#e95095\";s:18:\"color_subfooter_bg\";s:7:\"#1a1a1a\";s:22:\"color_subfooter_bg_alt\";s:4:\"#222\";s:22:\"color_subfooter_border\";s:7:\"#282828\";s:23:\"color_subfooter_heading\";s:4:\"#ccc\";s:20:\"color_subfooter_text\";s:4:\"#bbb\";s:20:\"color_subfooter_link\";s:4:\"#fff\";s:26:\"color_subfooter_link_hover\";s:7:\"#e95095\";s:12:\"style_scheme\";i:0;s:26:\"change_header_colors_start\";s:0:\"\";s:10:\"h_colors_1\";s:0:\"\";s:27:\"color_header_transparent_bg\";s:11:\"transparent\";s:24:\"change_header_colors_end\";s:0:\"\";s:30:\"change_header_alt_colors_start\";s:0:\"\";s:10:\"h_colors_2\";s:0:\"\";s:31:\"color_header_top_transparent_bg\";s:15:\"rgba(0,0,0,0.2)\";s:33:\"color_header_top_transparent_text\";s:22:\"rgba(255,255,255,0.66)\";s:39:\"color_header_top_transparent_text_hover\";s:4:\"#fff\";s:28:\"change_header_alt_colors_end\";s:0:\"\";s:27:\"change_content_colors_start\";s:0:\"\";s:10:\"h_colors_3\";s:0:\"\";s:25:\"change_content_colors_end\";s:0:\"\";s:31:\"change_alt_content_colors_start\";s:0:\"\";s:10:\"h_colors_4\";s:0:\"\";s:29:\"change_alt_content_colors_end\";s:0:\"\";s:26:\"change_footer_colors_start\";s:0:\"\";s:10:\"h_colors_6\";s:0:\"\";s:24:\"change_footer_colors_end\";s:0:\"\";s:29:\"change_subfooter_colors_start\";s:0:\"\";s:10:\"h_colors_5\";s:0:\"\";s:27:\"change_subfooter_colors_end\";s:0:\"\";s:16:\"body_font_family\";s:15:\"Georgia, serif|\";s:13:\"body_fontsize\";s:4:\"18px\";s:20:\"body_fontsize_mobile\";s:4:\"16px\";s:15:\"body_lineheight\";s:4:\"28px\";s:22:\"body_lineheight_mobile\";s:4:\"28px\";s:14:\"h1_font_family\";s:5:\"none|\";s:11:\"h1_fontsize\";s:16:\"max( 4rem, 4vw )\";s:18:\"h1_fontsize_mobile\";s:0:\"\";s:13:\"h1_lineheight\";s:3:\"1.2\";s:16:\"h1_letterspacing\";i:0;s:13:\"h1_fontweight\";s:3:\"400\";s:16:\"h1_bottom_indent\";s:5:\"0.6em\";s:8:\"h1_color\";s:0:\"\";s:16:\"h1_texttransform\";s:4:\"none\";s:17:\"h1_color_override\";s:0:\"\";s:12:\"h1_fontstyle\";s:0:\"\";s:14:\"h2_font_family\";s:7:\"get_h1|\";s:11:\"h2_fontsize\";s:20:\"max( 2.3rem, 2.3vw )\";s:18:\"h2_fontsize_mobile\";s:0:\"\";s:13:\"h2_lineheight\";s:3:\"1.2\";s:16:\"h2_letterspacing\";i:0;s:13:\"h2_fontweight\";s:3:\"400\";s:16:\"h2_bottom_indent\";s:5:\"0.6em\";s:8:\"h2_color\";s:0:\"\";s:16:\"h2_texttransform\";s:4:\"none\";s:17:\"h2_color_override\";s:0:\"\";s:12:\"h2_fontstyle\";s:0:\"\";s:14:\"h3_font_family\";s:7:\"get_h1|\";s:11:\"h3_fontsize\";s:20:\"max( 1.7rem, 1.7vw )\";s:18:\"h3_fontsize_mobile\";s:0:\"\";s:13:\"h3_lineheight\";s:3:\"1.2\";s:16:\"h3_letterspacing\";i:0;s:13:\"h3_fontweight\";s:3:\"400\";s:16:\"h3_bottom_indent\";s:5:\"0.6em\";s:8:\"h3_color\";s:0:\"\";s:16:\"h3_texttransform\";s:4:\"none\";s:17:\"h3_color_override\";s:0:\"\";s:12:\"h3_fontstyle\";s:0:\"\";s:14:\"h4_font_family\";s:7:\"get_h1|\";s:11:\"h4_fontsize\";s:20:\"max( 1.5rem, 1.5vw )\";s:18:\"h4_fontsize_mobile\";s:0:\"\";s:13:\"h4_lineheight\";s:3:\"1.2\";s:16:\"h4_letterspacing\";i:0;s:13:\"h4_fontweight\";s:3:\"400\";s:16:\"h4_bottom_indent\";s:5:\"0.6em\";s:8:\"h4_color\";s:0:\"\";s:16:\"h4_texttransform\";s:4:\"none\";s:17:\"h4_color_override\";s:0:\"\";s:12:\"h4_fontstyle\";s:0:\"\";s:14:\"h5_font_family\";s:7:\"get_h1|\";s:11:\"h5_fontsize\";s:20:\"max( 1.3rem, 1.3vw )\";s:18:\"h5_fontsize_mobile\";s:0:\"\";s:13:\"h5_lineheight\";s:3:\"1.2\";s:16:\"h5_letterspacing\";i:0;s:13:\"h5_fontweight\";s:3:\"400\";s:16:\"h5_bottom_indent\";s:5:\"0.6em\";s:8:\"h5_color\";s:0:\"\";s:16:\"h5_texttransform\";s:4:\"none\";s:17:\"h5_color_override\";s:0:\"\";s:12:\"h5_fontstyle\";s:0:\"\";s:14:\"h6_font_family\";s:7:\"get_h1|\";s:11:\"h6_fontsize\";s:20:\"max( 1.2rem, 1.2vw )\";s:18:\"h6_fontsize_mobile\";s:0:\"\";s:13:\"h6_lineheight\";s:3:\"1.2\";s:16:\"h6_letterspacing\";i:0;s:13:\"h6_fontweight\";s:3:\"400\";s:16:\"h6_bottom_indent\";s:5:\"0.6em\";s:8:\"h6_color\";s:0:\"\";s:16:\"h6_texttransform\";s:4:\"none\";s:17:\"h6_color_override\";s:0:\"\";s:12:\"h6_fontstyle\";s:0:\"\";s:14:\"h_typography_3\";s:0:\"\";s:11:\"custom_font\";a:0:{}s:14:\"h_typography_4\";s:0:\"\";s:14:\"uploaded_fonts\";a:0:{}s:14:\"h_typography_5\";s:0:\"\";s:12:\"font_display\";s:4:\"swap\";s:7:\"buttons\";a:2:{i:0;a:19:{s:2:\"id\";i:1;s:4:\"name\";s:14:\"Default Button\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:16:\"_content_primary\";s:14:\"color_bg_hover\";s:18:\"_content_secondary\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:4:\"#fff\";s:16:\"color_text_hover\";s:4:\"#fff\";s:4:\"font\";s:7:\"default\";s:10:\"text_style\";s:0:\"\";s:9:\"font_size\";s:4:\"16px\";s:11:\"line_height\";d:1.2;s:11:\"font_weight\";i:700;s:14:\"letter_spacing\";i:0;s:6:\"height\";s:5:\"1.0em\";s:5:\"width\";s:5:\"2.0em\";s:13:\"border_radius\";s:5:\"0.3em\";s:12:\"border_width\";s:3:\"0px\";}i:1;a:19:{s:2:\"id\";i:2;s:4:\"name\";s:8:\"Button 2\";s:5:\"hover\";s:4:\"fade\";s:8:\"color_bg\";s:15:\"_content_border\";s:14:\"color_bg_hover\";s:13:\"_content_text\";s:12:\"color_border\";s:0:\"\";s:18:\"color_border_hover\";s:0:\"\";s:10:\"color_text\";s:13:\"_content_text\";s:16:\"color_text_hover\";s:11:\"_content_bg\";s:4:\"font\";s:7:\"default\";s:10:\"text_style\";s:0:\"\";s:9:\"font_size\";s:4:\"16px\";s:11:\"line_height\";d:1.2;s:11:\"font_weight\";i:700;s:14:\"letter_spacing\";i:0;s:6:\"height\";s:5:\"1.0em\";s:5:\"width\";s:5:\"2.0em\";s:13:\"border_radius\";s:5:\"0.3em\";s:12:\"border_width\";s:3:\"0px\";}}s:12:\"input_fields\";a:1:{i:0;a:26:{s:8:\"color_bg\";s:15:\"_content_bg_alt\";s:14:\"color_bg_focus\";s:0:\"\";s:12:\"color_border\";s:15:\"_content_border\";s:18:\"color_border_focus\";s:0:\"\";s:10:\"color_text\";s:13:\"_content_text\";s:16:\"color_text_focus\";s:0:\"\";s:12:\"color_shadow\";s:16:\"rgba(0,0,0,0.08)\";s:18:\"color_shadow_focus\";s:16:\"_content_primary\";s:15:\"shadow_offset_h\";s:3:\"0px\";s:15:\"shadow_offset_v\";s:3:\"1px\";s:11:\"shadow_blur\";s:3:\"0px\";s:13:\"shadow_spread\";s:3:\"0px\";s:12:\"shadow_inset\";s:1:\"1\";s:21:\"shadow_focus_offset_h\";s:3:\"0px\";s:21:\"shadow_focus_offset_v\";s:3:\"0px\";s:17:\"shadow_focus_blur\";s:3:\"0px\";s:19:\"shadow_focus_spread\";s:3:\"2px\";s:18:\"shadow_focus_inset\";s:0:\"\";s:4:\"font\";s:0:\"\";s:9:\"font_size\";s:4:\"1rem\";s:11:\"font_weight\";s:3:\"400\";s:14:\"letter_spacing\";s:3:\"0em\";s:6:\"height\";s:6:\"2.8rem\";s:7:\"padding\";s:6:\"0.8rem\";s:13:\"border_radius\";s:0:\"\";s:12:\"border_width\";s:3:\"0px\";}}s:26:\"portfolio_breadcrumbs_page\";s:0:\"\";s:14:\"portfolio_slug\";s:9:\"portfolio\";s:23:\"portfolio_category_slug\";s:18:\"portfolio_category\";s:18:\"portfolio_tag_slug\";s:13:\"portfolio_tag\";s:16:\"portfolio_rename\";i:0;s:20:\"portfolio_label_name\";s:9:\"Portfolio\";s:29:\"portfolio_label_singular_name\";s:14:\"Portfolio Page\";s:23:\"portfolio_label_add_new\";s:18:\"Add Portfolio Page\";s:25:\"portfolio_label_edit_item\";s:19:\"Edit Portfolio Page\";s:24:\"portfolio_label_category\";s:20:\"Portfolio Categories\";s:19:\"portfolio_label_tag\";s:14:\"Portfolio Tags\";s:6:\"h_more\";s:0:\"\";s:12:\"shop_catalog\";i:0;s:22:\"shop_primary_btn_style\";s:1:\"1\";s:24:\"shop_secondary_btn_style\";s:1:\"2\";s:15:\"product_gallery\";s:6:\"slider\";s:29:\"wrapper_product_gallery_start\";s:0:\"\";s:26:\"product_gallery_thumbs_pos\";s:6:\"bottom\";s:27:\"product_gallery_thumbs_cols\";s:1:\"4\";s:28:\"product_gallery_thumbs_width\";s:4:\"6rem\";s:26:\"product_gallery_thumbs_gap\";s:3:\"4px\";s:23:\"product_gallery_options\";s:13:\"zoom,lightbox\";s:27:\"wrapper_product_gallery_end\";s:0:\"\";s:9:\"h_product\";s:0:\"\";s:17:\"header_product_id\";s:12:\"__defaults__\";s:19:\"titlebar_product_id\";s:12:\"__defaults__\";s:18:\"content_product_id\";s:0:\"\";s:18:\"sidebar_product_id\";s:12:\"__defaults__\";s:19:\"sidebar_product_pos\";s:5:\"right\";s:17:\"footer_product_id\";s:12:\"__defaults__\";s:6:\"h_shop\";s:0:\"\";s:14:\"header_shop_id\";s:12:\"__defaults__\";s:16:\"titlebar_shop_id\";s:12:\"__defaults__\";s:15:\"content_shop_id\";s:0:\"\";s:18:\"wrapper_shop_start\";s:0:\"\";s:12:\"shop_columns\";s:1:\"3\";s:16:\"wrapper_shop_end\";s:0:\"\";s:15:\"sidebar_shop_id\";s:12:\"__defaults__\";s:16:\"sidebar_shop_pos\";s:5:\"right\";s:14:\"footer_shop_id\";s:12:\"__defaults__\";s:7:\"h_order\";s:0:\"\";s:16:\"content_order_id\";s:0:\"\";s:6:\"h_cart\";s:0:\"\";s:9:\"shop_cart\";s:7:\"compact\";s:19:\"product_related_qty\";s:1:\"3\";s:15:\"used_icons_info\";s:0:\"\";s:9:\"h_icons_2\";s:0:\"\";s:9:\"icons_fas\";s:7:\"default\";s:21:\"icons_fas_custom_font\";s:0:\"\";s:9:\"icons_far\";s:7:\"default\";s:21:\"icons_far_custom_font\";s:0:\"\";s:9:\"icons_fal\";s:7:\"default\";s:21:\"icons_fal_custom_font\";s:0:\"\";s:9:\"icons_fad\";s:7:\"default\";s:21:\"icons_fad_custom_font\";s:0:\"\";s:9:\"icons_fab\";s:7:\"default\";s:21:\"icons_fab_custom_font\";s:0:\"\";s:14:\"icons_material\";s:7:\"default\";s:26:\"icons_material_custom_font\";s:0:\"\";s:18:\"fallback_icon_font\";i:1;s:13:\"img_size_info\";s:0:\"\";s:13:\"h_image_sizes\";s:0:\"\";s:8:\"img_size\";a:0:{}s:14:\"h_more_options\";s:0:\"\";s:24:\"big_image_size_threshold\";s:6:\"2560px\";s:20:\"delete_unused_images\";i:0;s:12:\"h_advanced_1\";s:0:\"\";s:12:\"live_builder\";i:1;s:17:\"section_templates\";i:1;s:19:\"grid_columns_layout\";i:1;s:12:\"block_editor\";i:0;s:23:\"enable_sidebar_titlebar\";i:0;s:31:\"enable_page_blocks_for_sidebars\";i:0;s:16:\"enable_portfolio\";i:1;s:19:\"enable_testimonials\";i:1;s:14:\"media_category\";i:1;s:10:\"og_enabled\";i:1;s:13:\"schema_markup\";i:1;s:12:\"h_advanced_2\";s:0:\"\";s:13:\"gmaps_api_key\";s:0:\"\";s:15:\"facebook_app_id\";s:0:\"\";s:22:\"grid_filter_url_prefix\";s:0:\"\";s:21:\"grid_order_url_prefix\";s:0:\"\";s:12:\"h_advanced_3\";s:0:\"\";s:17:\"keep_url_protocol\";i:1;s:22:\"disable_jquery_migrate\";i:1;s:13:\"jquery_footer\";i:1;s:12:\"ajax_load_js\";i:1;s:16:\"disable_extra_vc\";i:1;s:15:\"optimize_assets\";i:0;s:21:\"optimize_assets_alert\";s:0:\"\";s:21:\"optimize_assets_start\";s:0:\"\";s:6:\"assets\";a:56:{s:12:\"font-awesome\";i:1;s:20:\"font-awesome-duotone\";i:1;s:9:\"actionbox\";i:1;s:9:\"animation\";i:1;s:7:\"buttons\";i:1;s:8:\"carousel\";i:1;s:6:\"charts\";i:1;s:7:\"columns\";i:1;s:8:\"comments\";i:1;s:8:\"contacts\";i:1;s:7:\"counter\";i:1;s:8:\"dropdown\";i:1;s:5:\"forms\";i:1;s:7:\"flipbox\";i:1;s:5:\"gmaps\";i:1;s:4:\"grid\";i:1;s:11:\"grid_filter\";i:1;s:10:\"grid_order\";i:1;s:14:\"grid_templates\";i:1;s:15:\"grid_pagination\";i:1;s:10:\"grid_popup\";i:1;s:6:\"header\";i:1;s:12:\"hor_parallax\";i:1;s:8:\"hwrapper\";i:1;s:7:\"iconbox\";i:1;s:5:\"image\";i:1;s:13:\"image_gallery\";i:1;s:12:\"image_slider\";i:1;s:7:\"ibanner\";i:1;s:5:\"itext\";i:1;s:5:\"login\";i:1;s:14:\"magnific_popup\";i:1;s:4:\"menu\";i:1;s:7:\"message\";i:1;s:5:\"lmaps\";i:1;s:8:\"scroller\";i:1;s:6:\"person\";i:1;s:9:\"preloader\";i:1;s:5:\"print\";i:1;s:5:\"popup\";i:1;s:13:\"post_elements\";i:1;s:15:\"post_navigation\";i:1;s:7:\"pricing\";i:1;s:7:\"progbar\";i:1;s:6:\"scroll\";i:1;s:6:\"search\";i:1;s:9:\"separator\";i:1;s:7:\"sharing\";i:1;s:11:\"simple_menu\";i:1;s:7:\"socials\";i:1;s:4:\"tabs\";i:1;s:4:\"text\";i:1;s:5:\"video\";i:1;s:12:\"ver_parallax\";i:1;s:8:\"vwrapper\";i:1;s:10:\"wp_widgets\";i:1;}s:19:\"optimize_assets_end\";s:0:\"\";s:18:\"include_gfonts_css\";i:0;s:10:\"custom_css\";s:0:\"\";s:16:\"custom_html_head\";s:0:\"\";s:11:\"custom_html\";s:0:\"\";s:8:\"of_reset\";s:0:\"\";s:9:\"of_backup\";s:0:\"\";s:11:\"of_transfer\";s:0:\"\";s:11:\"white_label\";i:0;s:22:\"white_label_theme_name\";s:0:\"\";s:28:\"white_label_theme_screenshot\";s:0:\"\";s:22:\"white_label_theme_icon\";s:0:\"\";s:22:\"white_label_login_icon\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("532", "us_db_version", "8.39.1", "on");
INSERT INTO `wp_options` VALUES("536", "usof_color_palette_Impreza-child", "a:8:{i:0;s:39:\"linear-gradient(135deg,#e95095,#7049ba)\";i:1;s:39:\"linear-gradient(135deg,#7049ba,#e95095)\";i:2;s:7:\"#1a1a1a\";i:3;s:4:\"#333\";i:4;s:4:\"#999\";i:5;s:7:\"#e8e8e8\";i:6;s:7:\"#f5f5f5\";i:7;s:4:\"#fff\";}", "yes");
INSERT INTO `wp_options` VALUES("541", "theme_mods_makeitdigital", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:12:\"us_main_menu\";i:0;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1739963604;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:15:\"default_sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}}}}", "on");
INSERT INTO `wp_options` VALUES("548", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wp_options` VALUES("549", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wp_options` VALUES("702", "theme_mods_Impreza", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:12:\"us_main_menu\";i:0;}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1721660003;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:15:\"default_sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}}}}", "off");
INSERT INTO `wp_options` VALUES("708", "us_addons_version", "8.39.1", "yes");
INSERT INTO `wp_options` VALUES("718", "us_license_activated", "1", "yes");
INSERT INTO `wp_options` VALUES("719", "us_license_secret", "egjmowCIJKLPVW69", "yes");
INSERT INTO `wp_options` VALUES("814", "fs_active_plugins", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:27:\"password-protected/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:6:\"2.12.1\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1757609940;s:11:\"plugin_path\";s:41:\"password-protected/password-protected.php\";}}s:7:\"abspath\";s:35:\"/home/subverti/public_html/xpharma/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:41:\"password-protected/password-protected.php\";s:8:\"sdk_path\";s:27:\"password-protected/freemius\";s:7:\"version\";s:6:\"2.12.1\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1757609940;}}", "yes");
INSERT INTO `wp_options` VALUES("815", "fs_debug_mode", "", "yes");
INSERT INTO `wp_options` VALUES("816", "fs_accounts", "a:8:{s:21:\"id_slug_type_path_map\";a:1:{i:12503;a:3:{s:4:\"slug\";s:23:\"password-protected-free\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:41:\"password-protected/password-protected.php\";}}s:11:\"plugin_data\";a:1:{s:23:\"password-protected-free\";a:18:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:41:\"password-protected/password-protected.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1684849011;s:16:\"sdk_last_version\";s:6:\"2.11.0\";s:11:\"sdk_version\";s:6:\"2.12.1\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";s:5:\"2.7.9\";s:14:\"plugin_version\";s:6:\"2.7.10\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";N;s:4:\"host\";s:32:\"midtemplate.understandingcode.pt\";s:9:\"server_ip\";s:13:\"94.46.181.147\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1757609940;s:7:\"version\";s:6:\"2.7.10\";}s:15:\"prev_is_premium\";b:0;s:18:\"sticky_optin_added\";b:1;s:19:\"last_load_timestamp\";i:1760436958;s:12:\"is_anonymous\";a:3:{s:2:\"is\";b:1;s:9:\"timestamp\";i:1757946772;s:7:\"version\";s:6:\"2.7.10\";}}}s:13:\"file_slug_map\";a:1:{s:41:\"password-protected/password-protected.php\";s:23:\"password-protected-free\";}s:7:\"plugins\";a:1:{s:23:\"password-protected-free\";O:9:\"FS_Plugin\":24:{s:2:\"id\";s:5:\"12503\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:0;s:10:\"public_key\";s:32:\"pk_e9210517721d27b5112fa7773a600\";s:10:\"secret_key\";N;s:16:\"parent_plugin_id\";N;s:5:\"title\";s:18:\"Password Protected\";s:4:\"slug\";s:23:\"password-protected-free\";s:12:\"premium_slug\";s:34:\"password-protected-premium-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:41:\"password-protected/password-protected.php\";s:7:\"version\";s:6:\"2.7.10\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:17:\"opt_in_moderation\";N;}}s:13:\"admin_notices\";a:1:{s:23:\"password-protected-free\";a:0:{}}s:12:\"gc_timestamp\";a:0:{}s:10:\"theme_data\";a:0:{}s:9:\"unique_id\";s:32:\"f806a71195bc6e3a231acbf9166630a8\";}", "yes");
INSERT INTO `wp_options` VALUES("1055", "duplicator_notifications", "a:4:{s:6:\"update\";i:1760518516;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("1416", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("1747", "recovery_mode_email_last_sent", "1710430409", "yes");
INSERT INTO `wp_options` VALUES("1902", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("1909", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60],\"failedPackageIds\":[]}", "yes");
INSERT INTO `wp_options` VALUES("2746", "password_protected_1.5_update_database", "1", "yes");
INSERT INTO `wp_options` VALUES("3142", "polylang", "a:17:{s:7:\"browser\";b:0;s:7:\"rewrite\";b:1;s:12:\"hide_default\";b:1;s:10:\"force_lang\";i:1;s:13:\"redirect_lang\";b:1;s:13:\"media_support\";b:0;s:9:\"uninstall\";i:0;s:4:\"sync\";a:0:{}s:10:\"post_types\";a:0:{}s:10:\"taxonomies\";a:0:{}s:7:\"domains\";a:2:{s:2:\"en\";s:0:\"\";s:2:\"pt\";s:30:\"https://xpharma.digitalpath.pt\";}s:7:\"version\";s:5:\"3.7.3\";s:16:\"first_activation\";i:1715855707;s:12:\"default_lang\";s:2:\"pt\";s:16:\"previous_version\";s:5:\"3.7.2\";s:9:\"nav_menus\";a:1:{s:13:\"makeitdigital\";a:1:{s:12:\"us_main_menu\";a:0:{}}}s:19:\"language_taxonomies\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("3143", "polylang_wpml_strings", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("3144", "widget_polylang", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("3149", "pll_dismissed_notices", "a:3:{i:0;s:6:\"wizard\";i:1;s:6:\"review\";i:2;s:5:\"pllwc\";}", "yes");
INSERT INTO `wp_options` VALUES("3405", "acf_pro_license", "", "yes");
INSERT INTO `wp_options` VALUES("3406", "acf_pro_license_status", "", "yes");
INSERT INTO `wp_options` VALUES("3408", "acf_site_health", "{\"version\":\"6.5.1\",\"plugin_type\":\"Free\",\"update_source\":\"wordpress.org\",\"wp_version\":\"6.8.2\",\"mysql_version\":\"10.6.23-MariaDB\",\"is_multisite\":false,\"active_theme\":{\"name\":\"Make It Digital\",\"version\":\"1.0\",\"theme_uri\":\"http:\\/\\/impreza.us-themes.com\\/\",\"stylesheet\":false},\"parent_theme\":{\"name\":\"Impreza\",\"version\":\"8.39.1\",\"theme_uri\":\"http:\\/\\/impreza.us-themes.com\\/\",\"stylesheet\":false},\"active_plugins\":{\"advanced-custom-fields\\/acf.php\":{\"name\":\"Advanced Custom Fields\",\"version\":\"6.5.1\",\"plugin_uri\":\"https:\\/\\/www.advancedcustomfields.com\"},\"dhvc-form\\/dhvc-form.php\":{\"name\":\"DHVC Form\",\"version\":\"2.4.17\",\"plugin_uri\":\"https:\\/\\/demo.sitesao.com\\/dhvcform\"},\"duplicator\\/duplicator.php\":{\"name\":\"Duplicator\",\"version\":\"1.5.13.3\",\"plugin_uri\":\"https:\\/\\/duplicator.com\\/\"},\"loco-translate\\/loco.php\":{\"name\":\"Loco Translate\",\"version\":\"2.8.0\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/loco-translate\\/\"},\"rc_particlebackground\\/vc_extend.php\":{\"name\":\"Parcticle Backround for visual composer\",\"version\":\"4.6\",\"plugin_uri\":\"https:\\/\\/rcreators.com\\/vc\\/addons\"},\"password-protected\\/password-protected.php\":{\"name\":\"Password Protected\",\"version\":\"2.7.10\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/password-protected\\/\"},\"polylang\\/polylang.php\":{\"name\":\"Polylang\",\"version\":\"3.7.3\",\"plugin_uri\":\"https:\\/\\/polylang.pro\"},\"us-core\\/us-core.php\":{\"name\":\"UpSolution Core\",\"version\":\"8.39.1\",\"plugin_uri\":\"https:\\/\\/help.us-themes.com\\/impreza\\/us-core\\/\"},\"js_composer\\/js_composer.php\":{\"name\":\"WPBakery Page Builder\",\"version\":\"8.6.1\",\"plugin_uri\":\"https:\\/\\/wpbakery.com\"}},\"ui_field_groups\":\"1\",\"php_field_groups\":\"0\",\"json_field_groups\":\"0\",\"rest_field_groups\":\"0\",\"all_location_rules\":[\"taxonomy==marca-produto\"],\"number_of_fields_by_type\":{\"image\":1},\"number_of_third_party_fields_by_type\":[],\"post_types_enabled\":true,\"ui_post_types\":\"12\",\"json_post_types\":\"0\",\"ui_taxonomies\":\"12\",\"json_taxonomies\":\"0\",\"rest_api_format\":\"light\",\"admin_ui_enabled\":true,\"field_type-modal_enabled\":true,\"field_settings_tabs_enabled\":false,\"shortcode_enabled\":true,\"registered_acf_forms\":\"0\",\"json_save_paths\":1,\"json_load_paths\":1,\"event_first_created_post_type\":1732217345,\"event_first_created_taxonomy\":1732297429,\"event_first_created_field_group\":1732297497,\"last_updated\":1760456916}", "off");
INSERT INTO `wp_options` VALUES("5524", "us_can_modify_favorite_sections", "1", "auto");
INSERT INTO `wp_options` VALUES("5588", "action_scheduler_hybrid_store_demarkation", "43", "auto");
INSERT INTO `wp_options` VALUES("5589", "schema-ActionScheduler_StoreSchema", "8.0.1755188376", "auto");
INSERT INTO `wp_options` VALUES("5590", "schema-ActionScheduler_LoggerSchema", "3.0.1732297334", "auto");
INSERT INTO `wp_options` VALUES("5593", "woocommerce_newly_installed", "no", "auto");
INSERT INTO `wp_options` VALUES("5594", "woocommerce_schema_version", "920", "auto");
INSERT INTO `wp_options` VALUES("5595", "woocommerce_store_address", "", "on");
INSERT INTO `wp_options` VALUES("5596", "woocommerce_store_address_2", "", "on");
INSERT INTO `wp_options` VALUES("5597", "woocommerce_store_city", "", "on");
INSERT INTO `wp_options` VALUES("5598", "woocommerce_default_country", "PT", "on");
INSERT INTO `wp_options` VALUES("5599", "woocommerce_store_postcode", "", "on");
INSERT INTO `wp_options` VALUES("5600", "woocommerce_allowed_countries", "all", "on");
INSERT INTO `wp_options` VALUES("5601", "woocommerce_all_except_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("5602", "woocommerce_specific_allowed_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("5603", "woocommerce_ship_to_countries", "", "on");
INSERT INTO `wp_options` VALUES("5604", "woocommerce_specific_ship_to_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("5605", "woocommerce_default_customer_address", "base", "on");
INSERT INTO `wp_options` VALUES("5606", "woocommerce_calc_taxes", "no", "on");
INSERT INTO `wp_options` VALUES("5607", "woocommerce_enable_coupons", "yes", "on");
INSERT INTO `wp_options` VALUES("5608", "woocommerce_calc_discounts_sequentially", "no", "off");
INSERT INTO `wp_options` VALUES("5609", "woocommerce_currency", "EUR", "on");
INSERT INTO `wp_options` VALUES("5610", "woocommerce_currency_pos", "right_space", "on");
INSERT INTO `wp_options` VALUES("5611", "woocommerce_price_thousand_sep", "", "on");
INSERT INTO `wp_options` VALUES("5612", "woocommerce_price_decimal_sep", ",", "on");
INSERT INTO `wp_options` VALUES("5613", "woocommerce_price_num_decimals", "2", "on");
INSERT INTO `wp_options` VALUES("5614", "woocommerce_shop_page_id", "44", "on");
INSERT INTO `wp_options` VALUES("5615", "woocommerce_cart_redirect_after_add", "no", "on");
INSERT INTO `wp_options` VALUES("5616", "woocommerce_enable_ajax_add_to_cart", "yes", "on");
INSERT INTO `wp_options` VALUES("5617", "woocommerce_placeholder_image", "43", "on");
INSERT INTO `wp_options` VALUES("5618", "woocommerce_weight_unit", "kg", "on");
INSERT INTO `wp_options` VALUES("5619", "woocommerce_dimension_unit", "cm", "on");
INSERT INTO `wp_options` VALUES("5620", "woocommerce_enable_reviews", "yes", "on");
INSERT INTO `wp_options` VALUES("5621", "woocommerce_review_rating_verification_label", "yes", "off");
INSERT INTO `wp_options` VALUES("5622", "woocommerce_review_rating_verification_required", "no", "off");
INSERT INTO `wp_options` VALUES("5623", "woocommerce_enable_review_rating", "yes", "on");
INSERT INTO `wp_options` VALUES("5624", "woocommerce_review_rating_required", "yes", "off");
INSERT INTO `wp_options` VALUES("5625", "woocommerce_manage_stock", "yes", "on");
INSERT INTO `wp_options` VALUES("5626", "woocommerce_hold_stock_minutes", "60", "off");
INSERT INTO `wp_options` VALUES("5627", "woocommerce_notify_low_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("5628", "woocommerce_notify_no_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("5629", "woocommerce_stock_email_recipient", "it@makeitdigital.pt", "off");
INSERT INTO `wp_options` VALUES("5630", "woocommerce_notify_low_stock_amount", "2", "off");
INSERT INTO `wp_options` VALUES("5631", "woocommerce_notify_no_stock_amount", "0", "on");
INSERT INTO `wp_options` VALUES("5632", "woocommerce_hide_out_of_stock_items", "no", "on");
INSERT INTO `wp_options` VALUES("5633", "woocommerce_stock_format", "", "on");
INSERT INTO `wp_options` VALUES("5634", "woocommerce_file_download_method", "force", "off");
INSERT INTO `wp_options` VALUES("5635", "woocommerce_downloads_redirect_fallback_allowed", "no", "off");
INSERT INTO `wp_options` VALUES("5636", "woocommerce_downloads_require_login", "no", "off");
INSERT INTO `wp_options` VALUES("5637", "woocommerce_downloads_grant_access_after_payment", "yes", "off");
INSERT INTO `wp_options` VALUES("5638", "woocommerce_downloads_deliver_inline", "", "off");
INSERT INTO `wp_options` VALUES("5639", "woocommerce_downloads_add_hash_to_filename", "yes", "on");
INSERT INTO `wp_options` VALUES("5640", "woocommerce_downloads_count_partial", "yes", "on");
INSERT INTO `wp_options` VALUES("5642", "woocommerce_attribute_lookup_direct_updates", "no", "on");
INSERT INTO `wp_options` VALUES("5643", "woocommerce_attribute_lookup_optimized_updates", "no", "on");
INSERT INTO `wp_options` VALUES("5644", "woocommerce_product_match_featured_image_by_sku", "no", "on");
INSERT INTO `wp_options` VALUES("5645", "woocommerce_prices_include_tax", "no", "on");
INSERT INTO `wp_options` VALUES("5646", "woocommerce_tax_based_on", "shipping", "on");
INSERT INTO `wp_options` VALUES("5647", "woocommerce_shipping_tax_class", "inherit", "on");
INSERT INTO `wp_options` VALUES("5648", "woocommerce_tax_round_at_subtotal", "no", "on");
INSERT INTO `wp_options` VALUES("5649", "woocommerce_tax_classes", "", "on");
INSERT INTO `wp_options` VALUES("5650", "woocommerce_tax_display_shop", "excl", "on");
INSERT INTO `wp_options` VALUES("5651", "woocommerce_tax_display_cart", "excl", "on");
INSERT INTO `wp_options` VALUES("5652", "woocommerce_price_display_suffix", "", "on");
INSERT INTO `wp_options` VALUES("5653", "woocommerce_tax_total_display", "itemized", "off");
INSERT INTO `wp_options` VALUES("5654", "woocommerce_enable_shipping_calc", "yes", "off");
INSERT INTO `wp_options` VALUES("5655", "woocommerce_shipping_cost_requires_address", "no", "on");
INSERT INTO `wp_options` VALUES("5656", "woocommerce_ship_to_destination", "billing", "off");
INSERT INTO `wp_options` VALUES("5657", "woocommerce_shipping_debug_mode", "no", "on");
INSERT INTO `wp_options` VALUES("5658", "woocommerce_enable_guest_checkout", "yes", "off");
INSERT INTO `wp_options` VALUES("5659", "woocommerce_enable_checkout_login_reminder", "no", "off");
INSERT INTO `wp_options` VALUES("5660", "woocommerce_enable_signup_and_login_from_checkout", "no", "off");
INSERT INTO `wp_options` VALUES("5661", "woocommerce_enable_myaccount_registration", "no", "off");
INSERT INTO `wp_options` VALUES("5662", "woocommerce_registration_generate_username", "yes", "off");
INSERT INTO `wp_options` VALUES("5663", "woocommerce_registration_generate_password", "yes", "off");
INSERT INTO `wp_options` VALUES("5664", "woocommerce_erasure_request_removes_order_data", "no", "off");
INSERT INTO `wp_options` VALUES("5665", "woocommerce_erasure_request_removes_download_data", "no", "off");
INSERT INTO `wp_options` VALUES("5666", "woocommerce_allow_bulk_remove_personal_data", "no", "off");
INSERT INTO `wp_options` VALUES("5667", "woocommerce_registration_privacy_policy_text", "Os seus dados pessoais serão utilizados para melhorar a sua experiência por toda a loja, para gerir o acesso à sua conta e para os propósitos descritos na nossa [privacy_policy].", "on");
INSERT INTO `wp_options` VALUES("5668", "woocommerce_checkout_privacy_policy_text", "Os seus dados pessoais serão utilizados para processar a sua encomenda, para melhorar a sua experiência em toda a loja e para os propósitos descritos na nossa [privacy_policy].", "on");
INSERT INTO `wp_options` VALUES("5669", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("5670", "woocommerce_trash_pending_orders", "", "off");
INSERT INTO `wp_options` VALUES("5671", "woocommerce_trash_failed_orders", "", "off");
INSERT INTO `wp_options` VALUES("5672", "woocommerce_trash_cancelled_orders", "", "off");
INSERT INTO `wp_options` VALUES("5673", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("5674", "woocommerce_email_from_name", "Mid Template", "off");
INSERT INTO `wp_options` VALUES("5675", "woocommerce_email_from_address", "it@makeitdigital.pt", "off");
INSERT INTO `wp_options` VALUES("5676", "woocommerce_email_header_image", "", "off");
INSERT INTO `wp_options` VALUES("5677", "woocommerce_email_base_color", "#720eec", "off");
INSERT INTO `wp_options` VALUES("5678", "woocommerce_email_background_color", "#f7f7f7", "off");
INSERT INTO `wp_options` VALUES("5679", "woocommerce_email_body_background_color", "#ffffff", "off");
INSERT INTO `wp_options` VALUES("5680", "woocommerce_email_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("5681", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "off");
INSERT INTO `wp_options` VALUES("5682", "woocommerce_email_footer_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("5683", "woocommerce_merchant_email_notifications", "no", "off");
INSERT INTO `wp_options` VALUES("5684", "woocommerce_cart_page_id", "45", "off");
INSERT INTO `wp_options` VALUES("5685", "woocommerce_checkout_page_id", "46", "off");
INSERT INTO `wp_options` VALUES("5686", "woocommerce_myaccount_page_id", "47", "off");
INSERT INTO `wp_options` VALUES("5687", "woocommerce_terms_page_id", "", "off");
INSERT INTO `wp_options` VALUES("5688", "woocommerce_checkout_pay_endpoint", "order-pay", "on");
INSERT INTO `wp_options` VALUES("5689", "woocommerce_checkout_order_received_endpoint", "order-received", "on");
INSERT INTO `wp_options` VALUES("5690", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "on");
INSERT INTO `wp_options` VALUES("5691", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "on");
INSERT INTO `wp_options` VALUES("5692", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "on");
INSERT INTO `wp_options` VALUES("5693", "woocommerce_myaccount_orders_endpoint", "orders", "on");
INSERT INTO `wp_options` VALUES("5694", "woocommerce_myaccount_view_order_endpoint", "view-order", "on");
INSERT INTO `wp_options` VALUES("5695", "woocommerce_myaccount_downloads_endpoint", "downloads", "on");
INSERT INTO `wp_options` VALUES("5696", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "on");
INSERT INTO `wp_options` VALUES("5697", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "on");
INSERT INTO `wp_options` VALUES("5698", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "on");
INSERT INTO `wp_options` VALUES("5699", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "on");
INSERT INTO `wp_options` VALUES("5700", "woocommerce_logout_endpoint", "customer-logout", "on");
INSERT INTO `wp_options` VALUES("5701", "woocommerce_api_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("5702", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_options` VALUES("5703", "woocommerce_show_marketplace_suggestions", "yes", "off");
INSERT INTO `wp_options` VALUES("5704", "woocommerce_custom_orders_table_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("5705", "woocommerce_analytics_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("5706", "woocommerce_feature_order_attribution_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("5707", "woocommerce_feature_site_visibility_badge_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("5708", "woocommerce_feature_product_block_editor_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("5709", "woocommerce_hpos_fts_index_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("5710", "woocommerce_single_image_width", "600", "on");
INSERT INTO `wp_options` VALUES("5711", "woocommerce_thumbnail_image_width", "300", "on");
INSERT INTO `wp_options` VALUES("5712", "woocommerce_checkout_highlight_required_fields", "yes", "on");
INSERT INTO `wp_options` VALUES("5713", "woocommerce_demo_store", "no", "off");
INSERT INTO `wp_options` VALUES("5714", "wc_downloads_approved_directories_mode", "enabled", "auto");
INSERT INTO `wp_options` VALUES("5715", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:8:\"/produto\";s:13:\"category_base\";s:17:\"categoria-produto\";s:8:\"tag_base\";s:16:\"produto-etiqueta\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "auto");
INSERT INTO `wp_options` VALUES("5716", "current_theme_supports_woocommerce", "yes", "auto");
INSERT INTO `wp_options` VALUES("5717", "woocommerce_queue_flush_rewrite_rules", "no", "auto");
INSERT INTO `wp_options` VALUES("5719", "product_cat_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("5720", "default_product_cat", "26", "auto");
INSERT INTO `wp_options` VALUES("5728", "woocommerce_refund_returns_page_id", "48", "auto");
INSERT INTO `wp_options` VALUES("5731", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:6:\"PayPal\";s:11:\"description\";s:84:\"Pagar com PayPal; pode pagar com cartão de crédito se não tiver uma conta PayPal.\";s:5:\"email\";s:19:\"it@makeitdigital.pt\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:19:\"it@makeitdigital.pt\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "on");
INSERT INTO `wp_options` VALUES("5732", "woocommerce_version", "10.1.2", "auto");
INSERT INTO `wp_options` VALUES("5733", "woocommerce_db_version", "10.1.2", "auto");
INSERT INTO `wp_options` VALUES("5734", "woocommerce_store_id", "1bffeeb3-ec8e-4493-91a4-c3ef41344556", "auto");
INSERT INTO `wp_options` VALUES("5735", "woocommerce_admin_install_timestamp", "1732297335", "auto");
INSERT INTO `wp_options` VALUES("5736", "woocommerce_inbox_variant_assignment", "3", "auto");
INSERT INTO `wp_options` VALUES("5737", "woocommerce_remote_variant_assignment", "31", "auto");
INSERT INTO `wp_options` VALUES("5744", "action_scheduler_lock_async-request-runner", "68c81e36432d23.52655014|1757945458", "no");
INSERT INTO `wp_options` VALUES("5745", "woocommerce_admin_notices", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("5746", "wc_blocks_version", "11.8.0-dev", "auto");
INSERT INTO `wp_options` VALUES("5747", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"dRWN4N3NAn9zAwg1wsmVP9HgPWU9WG4A\";}", "on");
INSERT INTO `wp_options` VALUES("5749", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5750", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5751", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5752", "widget_woocommerce_price_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5753", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5754", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5755", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5756", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5757", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5758", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5759", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5760", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("5768", "wcpay_was_in_use", "no", "auto");
INSERT INTO `wp_options` VALUES("5771", "wc_admin_show_legacy_coupon_menu", "0", "auto");
INSERT INTO `wp_options` VALUES("5772", "woocommerce_custom_orders_table_created", "yes", "auto");
INSERT INTO `wp_options` VALUES("5773", "woocommerce_coming_soon", "yes", "auto");
INSERT INTO `wp_options` VALUES("5774", "woocommerce_initial_installed_version", "9.4.2", "off");
INSERT INTO `wp_options` VALUES("5778", "wc_blocks_db_schema_version", "260", "auto");
INSERT INTO `wp_options` VALUES("5779", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("5790", "jetpack_options", "a:1:{s:14:\"last_heartbeat\";i:1757896761;}", "auto");
INSERT INTO `wp_options` VALUES("5808", "woocommerce_onboarding_profile", "a:9:{s:15:\"business_choice\";s:34:\"im_setting_up_a_store_for_a_client\";s:21:\"selling_online_answer\";N;s:17:\"selling_platforms\";N;s:20:\"is_store_country_set\";b:1;s:8:\"industry\";a:1:{i:0;s:5:\"other\";}s:18:\"is_agree_marketing\";b:0;s:11:\"store_email\";s:19:\"it@makeitdigital.pt\";s:9:\"completed\";b:1;s:23:\"is_plugins_page_skipped\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("5810", "woocommerce_store_pages_only", "yes", "auto");
INSERT INTO `wp_options` VALUES("5811", "woocommerce_private_link", "no", "auto");
INSERT INTO `wp_options` VALUES("5812", "woocommerce_share_key", "R3zszLEm44ee0Xpkqohs9WBQmtxcK0Kx", "auto");
INSERT INTO `wp_options` VALUES("5815", "woocommerce_free_shipping_1_settings", "a:4:{s:5:\"title\";s:13:\"Free shipping\";s:8:\"requires\";s:0:\"\";s:10:\"min_amount\";s:1:\"0\";s:16:\"ignore_discounts\";s:2:\"no\";}", "auto");
INSERT INTO `wp_options` VALUES("5816", "woocommerce_admin_created_default_shipping_zones", "yes", "auto");
INSERT INTO `wp_options` VALUES("5819", "woocommerce_task_list_tracked_completed_tasks", "a:1:{i:0;s:8:\"shipping\";}", "auto");
INSERT INTO `wp_options` VALUES("5885", "jetpack_connection_active_plugins", "a:1:{s:11:\"woocommerce\";a:1:{s:4:\"name\";s:11:\"WooCommerce\";}}", "auto");
INSERT INTO `wp_options` VALUES("6185", "loco_recent", "a:4:{s:1:\"c\";s:21:\"Loco_data_RecentItems\";s:1:\"v\";i:0;s:1:\"d\";a:1:{s:6:\"bundle\";a:1:{s:19:\"theme.makeitdigital\";i:1732642113;}}s:1:\"t\";i:1732642113;}", "off");
INSERT INTO `wp_options` VALUES("6765", "awl_hide_int_notices", "a:1:{i:0;s:3:\"acf\";}", "off");
INSERT INTO `wp_options` VALUES("6782", "wc_remote_inbox_notifications_wca_updated", "", "off");
INSERT INTO `wp_options` VALUES("7714", "woocommerce_feature_cost_of_goods_sold_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("7765", "woocommerce_task_list_reminder_bar_hidden", "yes", "auto");
INSERT INTO `wp_options` VALUES("8786", "widget_wc_brands_brand_description", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("8787", "widget_woocommerce_brand_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("8788", "widget_wc_brands_brand_thumbnails", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("8791", "woocommerce_feature_rate_limit_checkout_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("8792", "woocommerce_feature_remote_logging_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("8793", "woocommerce_feature_email_improvements_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("8800", "woocommerce_admin_pes_incentive_woopayments_store_had_woopayments", "no", "auto");
INSERT INTO `wp_options` VALUES("8809", "woocommerce_checkout_phone_field", "optional", "auto");
INSERT INTO `wp_options` VALUES("8810", "woocommerce_checkout_company_field", "hidden", "auto");
INSERT INTO `wp_options` VALUES("8811", "woocommerce_checkout_address_2_field", "optional", "auto");
INSERT INTO `wp_options` VALUES("9614", "theme_mods_twentytwentyfive", "a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:0:{}s:19:\"wp_classic_sidebars\";a:1:{s:15:\"default_sidebar\";a:11:{s:4:\"name\";s:15:\"Default Sidebar\";s:2:\"id\";s:15:\"default_sidebar\";s:11:\"description\";s:0:\"\";s:5:\"class\";s:0:\"\";s:13:\"before_widget\";s:35:\"<div id=\"%1$s\" class=\"widget %2$s\">\";s:12:\"after_widget\";s:6:\"</div>\";s:12:\"before_title\";s:24:\"<h3 class=\"widgettitle\">\";s:11:\"after_title\";s:5:\"</h3>\";s:14:\"before_sidebar\";s:0:\"\";s:13:\"after_sidebar\";s:0:\"\";s:12:\"show_in_rest\";b:0;}}s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1739963616;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:15:\"default_sidebar\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}}}}", "off");
INSERT INTO `wp_options` VALUES("9618", "woocommerce_hooked_blocks_version", "9.6.0", "auto");
INSERT INTO `wp_options` VALUES("9619", "wc_blocks_use_blockified_product_grid_block_as_template", "1", "auto");
INSERT INTO `wp_options` VALUES("9620", "woocommerce_maybe_regenerate_images_hash", "f295711100eef51cf7195e603d0739ad", "auto");
INSERT INTO `wp_options` VALUES("11311", "woocommerce_feature_reactify-classic-payments-settings_enabled", "yes", "auto");
INSERT INTO `wp_options` VALUES("11314", "woocommerce_anonymize_refunded_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("11315", "woocommerce_email_auto_sync_with_theme", "no", "off");
INSERT INTO `wp_options` VALUES("11392", "pll_language_from_content_available", "no", "auto");
INSERT INTO `wp_options` VALUES("13286", "us_filter_index_table_is_created", "1", "on");
INSERT INTO `wp_options` VALUES("13292", "woocommerce_shipping_hide_rates_when_free", "no", "off");
INSERT INTO `wp_options` VALUES("13293", "woocommerce_email_header_image_width", "120", "on");
INSERT INTO `wp_options` VALUES("13294", "woocommerce_email_header_alignment", "left", "on");
INSERT INTO `wp_options` VALUES("13295", "woocommerce_email_font_family", "Helvetica", "on");
INSERT INTO `wp_options` VALUES("13296", "woocommerce_pos_store_name", "Mid Template", "on");
INSERT INTO `wp_options` VALUES("13297", "woocommerce_pos_store_address", "", "on");
INSERT INTO `wp_options` VALUES("13298", "woocommerce_pos_store_phone", "", "on");
INSERT INTO `wp_options` VALUES("13299", "woocommerce_pos_store_email", "it@makeitdigital.pt", "on");
INSERT INTO `wp_options` VALUES("13300", "woocommerce_pos_refund_returns_policy", "", "on");
INSERT INTO `wp_options` VALUES("13301", "woocommerce_feature_blueprint_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("13302", "woocommerce_hpos_datastore_caching_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("13303", "woocommerce_feature_block_email_editor_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("13304", "woocommerce_feature_point_of_sale_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("13338", "woocommerce_gateway_order", "a:6:{s:19:\"_wc_pes_woopayments\";i:0;s:25:\"_wc_pes_paypal_full_stack\";i:1;s:33:\"_wc_offline_payment_methods_group\";i:2;s:4:\"bacs\";i:3;s:6:\"cheque\";i:4;s:3:\"cod\";i:5;}", "auto");
INSERT INTO `wp_options` VALUES("13485", "can_compress_scripts", "0", "on");
INSERT INTO `wp_options` VALUES("14091", "woocommerce_feature_experimental-iapi-mini-cart_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("14812", "woocommerce_attribute_lookup_enabled", "no", "auto");
INSERT INTO `wp_options` VALUES("14902", "duplicator_install_info", "a:3:{s:7:\"version\";s:5:\"1.5.6\";s:4:\"time\";i:1676331847;s:10:\"updateTime\";i:1757944540;}", "off");
INSERT INTO `wp_options` VALUES("14908", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("14911", "duplicator_migration_data", "{\n    \"plugin\": \"dup-lite\",\n    \"installerVersion\": \"1.5.13.3\",\n    \"installType\": -1,\n    \"logicModes\": [\n        \"CLASSIC\"\n    ],\n    \"template\": \"base\",\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/subverti\\/public_html\\/xpharma\\/20230214_midtemplate_c80f9746b608cfe24211_20250915135659_archive.zip\",\n    \"packageHash\": \"c80f974-15135659\",\n    \"installerPath\": \"\\/home\\/subverti\\/public_html\\/xpharma\\/installer.php\",\n    \"installerBootLog\": \"\\/home\\/subverti\\/public_html\\/xpharma\\/dup-installer-bootlog__b8fdb22-15135659.txt\",\n    \"installerLog\": \"\\/home\\/subverti\\/public_html\\/xpharma\\/dup-installer\\/dup-installer-log__b8fdb22-15135659.txt\",\n    \"dupInstallerPath\": \"\\/home\\/subverti\\/public_html\\/xpharma\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/subverti\\/public_html\\/xpharma\\/dup-installer\\/original_files_c80f974-15135659\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true,\n    \"licenseType\": 0,\n    \"phpVersion\": \"8.3.25\",\n    \"archiveType\": \"zip\",\n    \"siteSize\": 124881324,\n    \"siteNumFiles\": 22404,\n    \"siteDbSize\": 5406720,\n    \"siteDBNumTables\": 56,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"ustatIdentifier\": \"\",\n    \"time\": 1757945289\n}", "no");
INSERT INTO `wp_options` VALUES("14913", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("14914", "_transient_wc_attribute_taxonomies", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("14919", "_site_transient_timeout_woocommerce_blocks_patterns", "1760537290", "off");
INSERT INTO `wp_options` VALUES("14920", "_site_transient_woocommerce_blocks_patterns", "a:2:{s:7:\"version\";s:6:\"10.1.2\";s:8:\"patterns\";a:41:{i:0;a:11:{s:5:\"title\";s:6:\"Banner\";s:4:\"slug\";s:25:\"woocommerce-blocks/banner\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:10:\"banner.php\";}i:1;a:11:{s:5:\"title\";s:23:\"Coming Soon Entire Site\";s:4:\"slug\";s:35:\"woocommerce/coming-soon-entire-site\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"coming-soon-entire-site.php\";}i:2;a:11:{s:5:\"title\";s:22:\"Coming Soon Store Only\";s:4:\"slug\";s:34:\"woocommerce/coming-soon-store-only\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"coming-soon-store-only.php\";}i:3;a:11:{s:5:\"title\";s:11:\"Coming Soon\";s:4:\"slug\";s:23:\"woocommerce/coming-soon\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:15:\"coming-soon.php\";}i:4;a:11:{s:5:\"title\";s:29:\"Content right with image left\";s:4:\"slug\";s:48:\"woocommerce-blocks/content-right-with-image-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"content-right-image-left.php\";}i:5;a:11:{s:5:\"title\";s:29:\"Featured Category Cover Image\";s:4:\"slug\";s:48:\"woocommerce-blocks/featured-category-cover-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"featured-category-cover-image.php\";}i:6;a:11:{s:5:\"title\";s:24:\"Featured Category Triple\";s:4:\"slug\";s:43:\"woocommerce-blocks/featured-category-triple\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"featured-category-triple.php\";}i:7;a:11:{s:5:\"title\";s:12:\"Large Footer\";s:4:\"slug\";s:31:\"woocommerce-blocks/footer-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"footer-large.php\";}i:8;a:11:{s:5:\"title\";s:23:\"Footer with Simple Menu\";s:4:\"slug\";s:37:\"woocommerce-blocks/footer-simple-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"footer-simple-menu.php\";}i:9;a:11:{s:5:\"title\";s:17:\"Footer with menus\";s:4:\"slug\";s:38:\"woocommerce-blocks/footer-with-3-menus\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"footer-with-3-menus.php\";}i:10;a:11:{s:5:\"title\";s:28:\"Four Image Grid Content Left\";s:4:\"slug\";s:47:\"woocommerce-blocks/form-image-grid-content-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"four-image-grid-content-left.php\";}i:11;a:11:{s:5:\"title\";s:20:\"Centered Header Menu\";s:4:\"slug\";s:39:\"woocommerce-blocks/header-centered-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-centered-pattern.php\";}i:12;a:11:{s:5:\"title\";s:23:\"Distraction Free Header\";s:4:\"slug\";s:42:\"woocommerce-blocks/header-distraction-free\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-distraction-free.php\";}i:13;a:11:{s:5:\"title\";s:16:\"Essential Header\";s:4:\"slug\";s:35:\"woocommerce-blocks/header-essential\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"header-essential.php\";}i:14;a:11:{s:5:\"title\";s:12:\"Large Header\";s:4:\"slug\";s:31:\"woocommerce-blocks/header-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"header-large.php\";}i:15;a:11:{s:5:\"title\";s:14:\"Minimal Header\";s:4:\"slug\";s:33:\"woocommerce-blocks/header-minimal\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:18:\"header-minimal.php\";}i:16;a:11:{s:5:\"title\";s:47:\"Heading with three columns of content with link\";s:4:\"slug\";s:66:\"woocommerce-blocks/heading-with-three-columns-of-content-with-link\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:51:\"heading-with-three-columns-of-content-with-link.php\";}i:17;a:11:{s:5:\"title\";s:20:\"Hero Product 3 Split\";s:4:\"slug\";s:39:\"woocommerce-blocks/hero-product-3-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:24:\"hero-product-3-split.php\";}i:18;a:11:{s:5:\"title\";s:23:\"Hero Product Chessboard\";s:4:\"slug\";s:42:\"woocommerce-blocks/hero-product-chessboard\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"hero-product-chessboard.php\";}i:19;a:11:{s:5:\"title\";s:18:\"Hero Product Split\";s:4:\"slug\";s:37:\"woocommerce-blocks/hero-product-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"hero-product-split.php\";}i:20;a:11:{s:5:\"title\";s:33:\"Centered content with image below\";s:4:\"slug\";s:52:\"woocommerce-blocks/centered-content-with-image-below\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:43:\"intro-centered-content-with-image-below.php\";}i:21;a:11:{s:5:\"title\";s:22:\"Just Arrived Full Hero\";s:4:\"slug\";s:41:\"woocommerce-blocks/just-arrived-full-hero\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"just-arrived-full-hero.php\";}i:22;a:11:{s:5:\"title\";s:33:\"No Products Found - Clear Filters\";s:4:\"slug\";s:43:\"woocommerce/no-products-found-clear-filters\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:29:\"no-products-found-filters.php\";}i:23;a:11:{s:5:\"title\";s:17:\"No Products Found\";s:4:\"slug\";s:29:\"woocommerce/no-products-found\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:21:\"no-products-found.php\";}i:24;a:11:{s:5:\"title\";s:19:\"Default Coming Soon\";s:4:\"slug\";s:36:\"woocommerce/page-coming-soon-default\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:28:\"page-coming-soon-default.php\";}i:25;a:11:{s:5:\"title\";s:25:\"Coming Soon Image Gallery\";s:4:\"slug\";s:42:\"woocommerce/page-coming-soon-image-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:34:\"page-coming-soon-image-gallery.php\";}i:26;a:11:{s:5:\"title\";s:30:\"Coming Soon Minimal Left Image\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-minimal-left-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-minimal-left-image.php\";}i:27;a:11:{s:5:\"title\";s:24:\"Coming Soon Modern Black\";s:4:\"slug\";s:41:\"woocommerce/page-coming-soon-modern-black\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:33:\"page-coming-soon-modern-black.php\";}i:28;a:11:{s:5:\"title\";s:29:\"Coming Soon Split Right Image\";s:4:\"slug\";s:46:\"woocommerce/page-coming-soon-split-right-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:38:\"page-coming-soon-split-right-image.php\";}i:29;a:11:{s:5:\"title\";s:34:\"Coming Soon With Header and Footer\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-with-header-footer\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-with-header-footer.php\";}i:30;a:11:{s:5:\"title\";s:28:\"Product Collection 3 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-3-columns.php\";}i:31;a:11:{s:5:\"title\";s:28:\"Product Collection 4 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-4-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-4-columns.php\";}i:32;a:11:{s:5:\"title\";s:28:\"Product Collection 5 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-5-columns.php\";}i:33;a:11:{s:5:\"title\";s:47:\"Product Collection: Featured Products 5 Columns\";s:4:\"slug\";s:65:\"woocommerce-blocks/product-collection-featured-products-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:50:\"product-collection-featured-products-5-columns.php\";}i:34;a:11:{s:5:\"title\";s:15:\"Product Gallery\";s:4:\"slug\";s:48:\"woocommerce-blocks/product-query-product-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:36:\"core/query/woocommerce/product-query\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"product-query-product-gallery.php\";}i:35;a:11:{s:5:\"title\";s:14:\"Product Search\";s:4:\"slug\";s:31:\"woocommerce/product-search-form\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"product-search-form.php\";}i:36;a:11:{s:5:\"title\";s:16:\"Related Products\";s:4:\"slug\";s:35:\"woocommerce-blocks/related-products\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"related-products.php\";}i:37;a:11:{s:5:\"title\";s:33:\"Social: Follow us on social media\";s:4:\"slug\";s:51:\"woocommerce-blocks/social-follow-us-in-social-media\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:25:\"WooCommerce, social-media\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:36:\"social-follow-us-in-social-media.php\";}i:38;a:11:{s:5:\"title\";s:22:\"Testimonials 3 Columns\";s:4:\"slug\";s:41:\"woocommerce-blocks/testimonials-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"testimonials-3-columns.php\";}i:39;a:11:{s:5:\"title\";s:19:\"Testimonials Single\";s:4:\"slug\";s:38:\"woocommerce-blocks/testimonials-single\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"testimonials-single.php\";}i:40;a:11:{s:5:\"title\";s:37:\"Three columns with images and content\";s:4:\"slug\";s:56:\"woocommerce-blocks/three-columns-with-images-and-content\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:41:\"three-columns-with-images-and-content.php\";}}}", "off");
INSERT INTO `wp_options` VALUES("14922", "_transient_jetpack_autoloader_plugin_paths", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("14923", "_transient_timeout_woocommerce_blocks_asset_api_script_data_ssl", "1760537325", "off");
INSERT INTO `wp_options` VALUES("14924", "_transient_woocommerce_blocks_asset_api_script_data_ssl", "{\"script_data\":{\"assets\\/client\\/blocks\\/wc-settings.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-settings.js\",\"version\":\"4f2e7067bd1c84cca43f\",\"dependencies\":[\"wc-types\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-types.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-types.js\",\"version\":\"35dee88875b85ff65531\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-middleware.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-middleware.js\",\"version\":\"d79dedade2f2e4dc9df4\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-data.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-data.js\",\"version\":\"d0ad299087b6ae74378b\",\"dependencies\":[\"wc-blocks-checkout-events\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors.js\",\"version\":\"1c5f828afef2f98a6774\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-registry.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-registry.js\",\"version\":\"a16aa912ffa0a15063f1\",\"dependencies\":[\"react-jsx-runtime\",\"wc-settings\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.js\",\"version\":\"0db759a8a6e010732c50\",\"dependencies\":[\"react-jsx-runtime\",\"wp-blocks\",\"wp-compose\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-context.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-context.js\",\"version\":\"1d9ff4f03584490ad390\",\"dependencies\":[\"react-jsx-runtime\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\",\"version\":\"99a2a0de38bfa707fc7b\",\"dependencies\":[\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-format.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-format.js\",\"version\":\"57e176e7cc02bdd27978\",\"dependencies\":[\"wc-settings\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\",\"version\":\"2a67f05c7f92833d4e15\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\",\"version\":\"c939a893efb4febadc26\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\",\"version\":\"d737836f8db716b9f469\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-checkout.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout.js\",\"version\":\"a1c2e7c31247ee1ae717\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/blocks-checkout-events.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout-events.js\",\"version\":\"2d0fd4590f6cc663947c\",\"dependencies\":[\"wc-types\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-components.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-components.js\",\"version\":\"14f739e1c451e591f9da\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-schema-parser.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-schema-parser.js\",\"version\":\"f762078aeb4207fe9c3d\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/admin\\/customer-effort-score\\/index.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/admin\\/customer-effort-score\\/index.js\",\"version\":\"ebdc0b2d7487174621e6\",\"dependencies\":[\"react\",\"wc-experimental\",\"wc-navigation\",\"wc-store-data\",\"wc-tracks\",\"wp-api-fetch\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-data-controls\",\"wp-element\",\"wp-i18n\"]},\"assets\\/client\\/blocks\\/mini-cart-component-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-component-frontend.js\",\"version\":\"996b487bcdeb2a438dc9\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-jsx-runtime\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-10.1.2\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\":{\"src\":\"https:\\/\\/xpharma.digitalpath.pt\\/xpharma\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\",\"version\":\"0446a66f2604add5f739\",\"dependencies\":[\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]}},\"version\":\"wc-10.1.2\",\"hash\":\"1affeedf69c4597c167d3ed46b011353\"}", "off");
INSERT INTO `wp_options` VALUES("14951", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"=Q;j=sEUiLUbQB66,f43oup,bc9lyoKc=VNpW81jZiht\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 243.79,\n    \"siteNumFiles\": 15467,\n    \"siteDbSizeMB\": 13.92,\n    \"siteDbNumTables\": 56\n}", "auto");
INSERT INTO `wp_options` VALUES("14957", "woocommerce_brand_permalink", "", "auto");
INSERT INTO `wp_options` VALUES("14961", "new_admin_email", "it@makeitdigital.pt", "auto");
INSERT INTO `wp_options` VALUES("14966", "_site_transient_wp_plugin_dependencies_plugin_data", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("14967", "_transient_timeout_woocommerce_analytics_orders_statuses_all", "1789481404", "off");
INSERT INTO `wp_options` VALUES("14968", "_transient_woocommerce_analytics_orders_statuses_all", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("14975", "_transient_wpb_notice_list", "a:1:{s:18:\"empty_api_response\";b:1;}", "on");
INSERT INTO `wp_options` VALUES("14980", "_transient_jetpack_connection_active_plugins_refresh", "1757945458", "on");
INSERT INTO `wp_options` VALUES("14983", "category_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("15003", "wpb_js_modules", "{\"vc-seo\":true,\"vc-ai\":true,\"vc-automapper\":true,\"vc-custom-js\":true,\"vc-custom-css\":true,\"vc-post-custom-layout\":true,\"vc-scroll-to-element\":false,\"vc-color-picker\":true,\"vc-typography\":true}", "auto");
INSERT INTO `wp_options` VALUES("15025", "password_protected_status", "1", "auto");
INSERT INTO `wp_options` VALUES("15026", "password_protected_feeds", "0", "auto");
INSERT INTO `wp_options` VALUES("15027", "password_protected_rest", "0", "auto");
INSERT INTO `wp_options` VALUES("15028", "password_protected_administrators", "1", "auto");
INSERT INTO `wp_options` VALUES("15029", "password_protected_users", "0", "auto");
INSERT INTO `wp_options` VALUES("15030", "password_protected_password", "6167fa1077191cf78f92b055bf661e13", "auto");
INSERT INTO `wp_options` VALUES("15031", "password_protected_allowed_ip_addresses", "", "auto");
INSERT INTO `wp_options` VALUES("15032", "password_protected_remember_me_lifetime", "60", "auto");
INSERT INTO `wp_options` VALUES("15036", "wpb_usage_count", "a:10:{s:12:\"us_separator\";i:14;s:14:\"vc_column_text\";i:8;s:11:\"us_hwrapper\";i:5;s:6:\"us_btn\";i:1;s:7:\"us_text\";i:5;s:8:\"us_image\";i:9;s:8:\"us_popup\";i:1;s:10:\"us_ibanner\";i:1;s:10:\"us_iconbox\";i:1;s:18:\"us_additional_menu\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("15066", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("15534", "auth_key", "yJ3U@}0b6;/Ewr3vkl:;awG? &RC^F_b&2+J1};G<1N<6,ESWgxa#Cj6|./A26t@", "off");
INSERT INTO `wp_options` VALUES("15535", "auth_salt", "9}Mk5]q!M_5!kFV0%xu*.NU)1`}1H[4D0F<MAsiDSi#TUr*B.Ou;0I4R7bm>n$q|", "off");
INSERT INTO `wp_options` VALUES("15692", "_transient_health-check-site-status-result", "{\"good\":16,\"recommended\":5,\"critical\":3}", "on");
INSERT INTO `wp_options` VALUES("16705", "_site_transient_timeout_browser_3268fe57febc0d1640e7d7359e3c065d", "1760607845", "off");
INSERT INTO `wp_options` VALUES("16706", "_site_transient_browser_3268fe57febc0d1640e7d7359e3c065d", "a:10:{s:4:\"name\";s:6:\"Chrome\";s:7:\"version\";s:9:\"141.0.0.0\";s:8:\"platform\";s:9:\"Macintosh\";s:10:\"update_url\";s:29:\"https://www.google.com/chrome\";s:7:\"img_src\";s:43:\"http://s.w.org/images/browsers/chrome.png?1\";s:11:\"img_src_ssl\";s:44:\"https://s.w.org/images/browsers/chrome.png?1\";s:15:\"current_version\";s:2:\"18\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;s:6:\"mobile\";b:0;}", "off");
INSERT INTO `wp_options` VALUES("16770", "_site_transient_timeout_php_check_bf05629fd259c5e3e696947741738355", "1760693994", "off");
INSERT INTO `wp_options` VALUES("16771", "_site_transient_php_check_bf05629fd259c5e3e696947741738355", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("16853", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:3:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/pt_PT/wordpress-6.8.3.zip\";s:6:\"locale\";s:5:\"pt_PT\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/pt_PT/wordpress-6.8.3.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.3\";s:7:\"version\";s:5:\"6.8.3\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}i:1;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.3.zip\";s:6:\"locale\";s:5:\"en_US\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:59:\"https://downloads.wordpress.org/release/wordpress-6.8.3.zip\";s:10:\"no_content\";s:70:\"https://downloads.wordpress.org/release/wordpress-6.8.3-no-content.zip\";s:11:\"new_bundled\";s:71:\"https://downloads.wordpress.org/release/wordpress-6.8.3-new-bundled.zip\";s:7:\"partial\";s:69:\"https://downloads.wordpress.org/release/wordpress-6.8.3-partial-2.zip\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.3\";s:7:\"version\";s:5:\"6.8.3\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:5:\"6.8.2\";}i:2;O:8:\"stdClass\":11:{s:8:\"response\";s:10:\"autoupdate\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/pt_PT/wordpress-6.8.3.zip\";s:6:\"locale\";s:5:\"pt_PT\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/pt_PT/wordpress-6.8.3.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.3\";s:7:\"version\";s:5:\"6.8.3\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";s:9:\"new_files\";s:1:\"1\";}}s:12:\"last_checked\";i:1760518514;s:15:\"version_checked\";s:5:\"6.8.2\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("16854", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1760518515;s:7:\"checked\";a:5:{s:7:\"Impreza\";s:6:\"8.39.1\";s:13:\"makeitdigital\";s:3:\"1.0\";s:16:\"twentytwentyfive\";s:3:\"1.3\";s:16:\"twentytwentyfour\";s:3:\"1.3\";s:17:\"twentytwentythree\";s:3:\"1.6\";}s:8:\"response\";a:0:{}s:9:\"no_update\";a:3:{s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.3.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("17024", "rewrite_rules", "a:297:{s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:53:\"^(en)/wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:92:\"index.php?lang=$matches[1]&sitemap=$matches[2]&sitemap-subtype=$matches[3]&paged=$matches[4]\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:39:\"^(en)/wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:64:\"index.php?lang=$matches[1]&sitemap=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:52:\"(en)/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?lang=$matches[1]&category_name=$matches[2]&feed=$matches[3]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:47:\"(en)/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:69:\"index.php?lang=$matches[1]&category_name=$matches[2]&feed=$matches[3]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:28:\"(en)/category/(.+?)/embed/?$\";s:63:\"index.php?lang=$matches[1]&category_name=$matches[2]&embed=true\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:40:\"(en)/category/(.+?)/page/?([0-9]{1,})/?$\";s:70:\"index.php?lang=$matches[1]&category_name=$matches[2]&paged=$matches[3]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:22:\"(en)/category/(.+?)/?$\";s:52:\"index.php?lang=$matches[1]&category_name=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:49:\"(en)/tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?lang=$matches[1]&tag=$matches[2]&feed=$matches[3]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:44:\"(en)/tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?lang=$matches[1]&tag=$matches[2]&feed=$matches[3]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:25:\"(en)/tag/([^/]+)/embed/?$\";s:53:\"index.php?lang=$matches[1]&tag=$matches[2]&embed=true\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:37:\"(en)/tag/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?lang=$matches[1]&tag=$matches[2]&paged=$matches[3]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:19:\"(en)/tag/([^/]+)/?$\";s:42:\"index.php?lang=$matches[1]&tag=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:50:\"(en)/type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&post_format=$matches[2]&feed=$matches[3]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?lang=pt&post_format=$matches[1]&feed=$matches[2]\";s:45:\"(en)/type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&post_format=$matches[2]&feed=$matches[3]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?lang=pt&post_format=$matches[1]&feed=$matches[2]\";s:26:\"(en)/type/([^/]+)/embed/?$\";s:61:\"index.php?lang=$matches[1]&post_format=$matches[2]&embed=true\";s:21:\"type/([^/]+)/embed/?$\";s:52:\"index.php?lang=pt&post_format=$matches[1]&embed=true\";s:38:\"(en)/type/([^/]+)/page/?([0-9]{1,})/?$\";s:68:\"index.php?lang=$matches[1]&post_format=$matches[2]&paged=$matches[3]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?lang=pt&post_format=$matches[1]&paged=$matches[2]\";s:20:\"(en)/type/([^/]+)/?$\";s:50:\"index.php?lang=$matches[1]&post_format=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:41:\"index.php?lang=pt&post_format=$matches[1]\";s:54:\"marca-produto/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?marca-produto=$matches[1]&feed=$matches[2]\";s:49:\"marca-produto/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?marca-produto=$matches[1]&feed=$matches[2]\";s:30:\"marca-produto/([^/]+)/embed/?$\";s:46:\"index.php?marca-produto=$matches[1]&embed=true\";s:42:\"marca-produto/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?marca-produto=$matches[1]&paged=$matches[2]\";s:24:\"marca-produto/([^/]+)/?$\";s:35:\"index.php?marca-produto=$matches[1]\";s:39:\"slide-carross/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"slide-carross/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"slide-carross/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"slide-carross/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"slide-carross/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"slide-carross/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:28:\"slide-carross/(.+?)/embed/?$\";s:46:\"index.php?slide-carross=$matches[1]&embed=true\";s:32:\"slide-carross/(.+?)/trackback/?$\";s:40:\"index.php?slide-carross=$matches[1]&tb=1\";s:40:\"slide-carross/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?slide-carross=$matches[1]&paged=$matches[2]\";s:47:\"slide-carross/(.+?)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?slide-carross=$matches[1]&cpage=$matches[2]\";s:36:\"slide-carross/(.+?)(?:/([0-9]+))?/?$\";s:52:\"index.php?slide-carross=$matches[1]&page=$matches[2]\";s:36:\"dhvcform/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"dhvcform/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"dhvcform/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"dhvcform/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"dhvcform/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"dhvcform/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"dhvcform/([^/]+)/embed/?$\";s:41:\"index.php?dhvcform=$matches[1]&embed=true\";s:29:\"dhvcform/([^/]+)/trackback/?$\";s:35:\"index.php?dhvcform=$matches[1]&tb=1\";s:37:\"dhvcform/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?dhvcform=$matches[1]&paged=$matches[2]\";s:44:\"dhvcform/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?dhvcform=$matches[1]&cpage=$matches[2]\";s:33:\"dhvcform/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?dhvcform=$matches[1]&page=$matches[2]\";s:25:\"dhvcform/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"dhvcform/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"dhvcform/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"dhvcform/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"dhvcform/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"dhvcform/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"(en)/portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:77:\"index.php?lang=$matches[1]&us_portfolio_category=$matches[2]&feed=$matches[3]\";s:59:\"portfolio_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?us_portfolio_category=$matches[1]&feed=$matches[2]\";s:59:\"(en)/portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:77:\"index.php?lang=$matches[1]&us_portfolio_category=$matches[2]&feed=$matches[3]\";s:54:\"portfolio_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?us_portfolio_category=$matches[1]&feed=$matches[2]\";s:40:\"(en)/portfolio_category/([^/]+)/embed/?$\";s:71:\"index.php?lang=$matches[1]&us_portfolio_category=$matches[2]&embed=true\";s:35:\"portfolio_category/([^/]+)/embed/?$\";s:54:\"index.php?us_portfolio_category=$matches[1]&embed=true\";s:52:\"(en)/portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:78:\"index.php?lang=$matches[1]&us_portfolio_category=$matches[2]&paged=$matches[3]\";s:47:\"portfolio_category/([^/]+)/page/?([0-9]{1,})/?$\";s:61:\"index.php?us_portfolio_category=$matches[1]&paged=$matches[2]\";s:34:\"(en)/portfolio_category/([^/]+)/?$\";s:60:\"index.php?lang=$matches[1]&us_portfolio_category=$matches[2]\";s:29:\"portfolio_category/([^/]+)/?$\";s:43:\"index.php?us_portfolio_category=$matches[1]\";s:59:\"(en)/portfolio_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:72:\"index.php?lang=$matches[1]&us_portfolio_tag=$matches[2]&feed=$matches[3]\";s:54:\"portfolio_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?us_portfolio_tag=$matches[1]&feed=$matches[2]\";s:54:\"(en)/portfolio_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:72:\"index.php?lang=$matches[1]&us_portfolio_tag=$matches[2]&feed=$matches[3]\";s:49:\"portfolio_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?us_portfolio_tag=$matches[1]&feed=$matches[2]\";s:35:\"(en)/portfolio_tag/([^/]+)/embed/?$\";s:66:\"index.php?lang=$matches[1]&us_portfolio_tag=$matches[2]&embed=true\";s:30:\"portfolio_tag/([^/]+)/embed/?$\";s:49:\"index.php?us_portfolio_tag=$matches[1]&embed=true\";s:47:\"(en)/portfolio_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:73:\"index.php?lang=$matches[1]&us_portfolio_tag=$matches[2]&paged=$matches[3]\";s:42:\"portfolio_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?us_portfolio_tag=$matches[1]&paged=$matches[2]\";s:29:\"(en)/portfolio_tag/([^/]+)/?$\";s:55:\"index.php?lang=$matches[1]&us_portfolio_tag=$matches[2]\";s:24:\"portfolio_tag/([^/]+)/?$\";s:38:\"index.php?us_portfolio_tag=$matches[1]\";s:42:\"(en)/portfolio/[^/]+/attachment/([^/]+)/?$\";s:49:\"index.php?lang=$matches[1]&attachment=$matches[2]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"(en)/portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:54:\"index.php?lang=$matches[1]&attachment=$matches[2]&tb=1\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"(en)/portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"(en)/portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"(en)/portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?lang=$matches[1]&attachment=$matches[2]&cpage=$matches[3]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"(en)/portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:60:\"index.php?lang=$matches[1]&attachment=$matches[2]&embed=true\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"(en)/portfolio/([^/]+)/embed/?$\";s:62:\"index.php?lang=$matches[1]&us_portfolio=$matches[2]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:45:\"index.php?us_portfolio=$matches[1]&embed=true\";s:35:\"(en)/portfolio/([^/]+)/trackback/?$\";s:56:\"index.php?lang=$matches[1]&us_portfolio=$matches[2]&tb=1\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:39:\"index.php?us_portfolio=$matches[1]&tb=1\";s:43:\"(en)/portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?lang=$matches[1]&us_portfolio=$matches[2]&paged=$matches[3]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?us_portfolio=$matches[1]&paged=$matches[2]\";s:50:\"(en)/portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:69:\"index.php?lang=$matches[1]&us_portfolio=$matches[2]&cpage=$matches[3]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?us_portfolio=$matches[1]&cpage=$matches[2]\";s:39:\"(en)/portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:68:\"index.php?lang=$matches[1]&us_portfolio=$matches[2]&page=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?us_portfolio=$matches[1]&page=$matches[2]\";s:31:\"(en)/portfolio/[^/]+/([^/]+)/?$\";s:49:\"index.php?lang=$matches[1]&attachment=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"(en)/portfolio/[^/]+/([^/]+)/trackback/?$\";s:54:\"index.php?lang=$matches[1]&attachment=$matches[2]&tb=1\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"(en)/portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"(en)/portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"(en)/portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?lang=$matches[1]&attachment=$matches[2]&cpage=$matches[3]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"(en)/portfolio/[^/]+/([^/]+)/embed/?$\";s:60:\"index.php?lang=$matches[1]&attachment=$matches[2]&embed=true\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:69:\"(en)/us_testimonial_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:93:\"index.php?lang=$matches[1]&taxonomy=us_testimonial_category&term=$matches[2]&feed=$matches[3]\";s:64:\"us_testimonial_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:76:\"index.php?taxonomy=us_testimonial_category&term=$matches[1]&feed=$matches[2]\";s:64:\"(en)/us_testimonial_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:93:\"index.php?lang=$matches[1]&taxonomy=us_testimonial_category&term=$matches[2]&feed=$matches[3]\";s:59:\"us_testimonial_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:76:\"index.php?taxonomy=us_testimonial_category&term=$matches[1]&feed=$matches[2]\";s:45:\"(en)/us_testimonial_category/([^/]+)/embed/?$\";s:87:\"index.php?lang=$matches[1]&taxonomy=us_testimonial_category&term=$matches[2]&embed=true\";s:40:\"us_testimonial_category/([^/]+)/embed/?$\";s:70:\"index.php?taxonomy=us_testimonial_category&term=$matches[1]&embed=true\";s:57:\"(en)/us_testimonial_category/([^/]+)/page/?([0-9]{1,})/?$\";s:94:\"index.php?lang=$matches[1]&taxonomy=us_testimonial_category&term=$matches[2]&paged=$matches[3]\";s:52:\"us_testimonial_category/([^/]+)/page/?([0-9]{1,})/?$\";s:77:\"index.php?taxonomy=us_testimonial_category&term=$matches[1]&paged=$matches[2]\";s:39:\"(en)/us_testimonial_category/([^/]+)/?$\";s:76:\"index.php?lang=$matches[1]&taxonomy=us_testimonial_category&term=$matches[2]\";s:34:\"us_testimonial_category/([^/]+)/?$\";s:59:\"index.php?taxonomy=us_testimonial_category&term=$matches[1]\";s:58:\"us_media_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?taxonomy=us_media_category&term=$matches[1]&feed=$matches[2]\";s:53:\"us_media_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?taxonomy=us_media_category&term=$matches[1]&feed=$matches[2]\";s:34:\"us_media_category/([^/]+)/embed/?$\";s:64:\"index.php?taxonomy=us_media_category&term=$matches[1]&embed=true\";s:46:\"us_media_category/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?taxonomy=us_media_category&term=$matches[1]&paged=$matches[2]\";s:28:\"us_media_category/([^/]+)/?$\";s:53:\"index.php?taxonomy=us_media_category&term=$matches[1]\";s:47:\"wpb_gutenberg_param/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"wpb_gutenberg_param/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"wpb_gutenberg_param/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"wpb_gutenberg_param/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"wpb_gutenberg_param/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"wpb_gutenberg_param/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"wpb_gutenberg_param/([^/]+)/embed/?$\";s:67:\"index.php?post_type=wpb_gutenberg_param&name=$matches[1]&embed=true\";s:40:\"wpb_gutenberg_param/([^/]+)/trackback/?$\";s:61:\"index.php?post_type=wpb_gutenberg_param&name=$matches[1]&tb=1\";s:48:\"wpb_gutenberg_param/([^/]+)/page/?([0-9]{1,})/?$\";s:74:\"index.php?post_type=wpb_gutenberg_param&name=$matches[1]&paged=$matches[2]\";s:55:\"wpb_gutenberg_param/([^/]+)/comment-page-([0-9]{1,})/?$\";s:74:\"index.php?post_type=wpb_gutenberg_param&name=$matches[1]&cpage=$matches[2]\";s:44:\"wpb_gutenberg_param/([^/]+)(?:/([0-9]+))?/?$\";s:73:\"index.php?post_type=wpb_gutenberg_param&name=$matches[1]&page=$matches[2]\";s:36:\"wpb_gutenberg_param/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"wpb_gutenberg_param/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"wpb_gutenberg_param/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"wpb_gutenberg_param/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"wpb_gutenberg_param/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"wpb_gutenberg_param/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:37:\"(en)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?lang=$matches[1]&&feed=$matches[2]\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:35:\"index.php?lang=pt&&feed=$matches[1]\";s:32:\"(en)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?lang=$matches[1]&&feed=$matches[2]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:35:\"index.php?lang=pt&&feed=$matches[1]\";s:13:\"(en)/embed/?$\";s:38:\"index.php?lang=$matches[1]&&embed=true\";s:8:\"embed/?$\";s:29:\"index.php?lang=pt&&embed=true\";s:25:\"(en)/page/?([0-9]{1,})/?$\";s:45:\"index.php?lang=$matches[1]&&paged=$matches[2]\";s:20:\"page/?([0-9]{1,})/?$\";s:36:\"index.php?lang=pt&&paged=$matches[1]\";s:32:\"(en)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?lang=$matches[1]&&page_id=541&cpage=$matches[2]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:48:\"index.php?lang=pt&&page_id=541&cpage=$matches[1]\";s:7:\"(en)/?$\";s:26:\"index.php?lang=$matches[1]\";s:46:\"(en)/comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?lang=$matches[1]&&feed=$matches[2]&withcomments=1\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?lang=pt&&feed=$matches[1]&withcomments=1\";s:41:\"(en)/comments/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?lang=$matches[1]&&feed=$matches[2]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?lang=pt&&feed=$matches[1]&withcomments=1\";s:22:\"(en)/comments/embed/?$\";s:38:\"index.php?lang=$matches[1]&&embed=true\";s:17:\"comments/embed/?$\";s:29:\"index.php?lang=pt&&embed=true\";s:49:\"(en)/search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?lang=$matches[1]&s=$matches[2]&feed=$matches[3]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?lang=pt&s=$matches[1]&feed=$matches[2]\";s:44:\"(en)/search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:57:\"index.php?lang=$matches[1]&s=$matches[2]&feed=$matches[3]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?lang=pt&s=$matches[1]&feed=$matches[2]\";s:25:\"(en)/search/(.+)/embed/?$\";s:51:\"index.php?lang=$matches[1]&s=$matches[2]&embed=true\";s:20:\"search/(.+)/embed/?$\";s:42:\"index.php?lang=pt&s=$matches[1]&embed=true\";s:37:\"(en)/search/(.+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?lang=$matches[1]&s=$matches[2]&paged=$matches[3]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?lang=pt&s=$matches[1]&paged=$matches[2]\";s:19:\"(en)/search/(.+)/?$\";s:40:\"index.php?lang=$matches[1]&s=$matches[2]\";s:14:\"search/(.+)/?$\";s:31:\"index.php?lang=pt&s=$matches[1]\";s:52:\"(en)/author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&author_name=$matches[2]&feed=$matches[3]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?lang=pt&author_name=$matches[1]&feed=$matches[2]\";s:47:\"(en)/author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?lang=$matches[1]&author_name=$matches[2]&feed=$matches[3]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:58:\"index.php?lang=pt&author_name=$matches[1]&feed=$matches[2]\";s:28:\"(en)/author/([^/]+)/embed/?$\";s:61:\"index.php?lang=$matches[1]&author_name=$matches[2]&embed=true\";s:23:\"author/([^/]+)/embed/?$\";s:52:\"index.php?lang=pt&author_name=$matches[1]&embed=true\";s:40:\"(en)/author/([^/]+)/page/?([0-9]{1,})/?$\";s:68:\"index.php?lang=$matches[1]&author_name=$matches[2]&paged=$matches[3]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:59:\"index.php?lang=pt&author_name=$matches[1]&paged=$matches[2]\";s:22:\"(en)/author/([^/]+)/?$\";s:50:\"index.php?lang=$matches[1]&author_name=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:41:\"index.php?lang=pt&author_name=$matches[1]\";s:74:\"(en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&feed=$matches[5]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:88:\"index.php?lang=pt&year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:69:\"(en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&feed=$matches[5]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:88:\"index.php?lang=pt&year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:50:\"(en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:91:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&embed=true\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:82:\"index.php?lang=pt&year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:62:\"(en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:98:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]&paged=$matches[5]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:89:\"index.php?lang=pt&year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:44:\"(en)/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:80:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&day=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:71:\"index.php?lang=pt&year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:61:\"(en)/([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:81:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&feed=$matches[4]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:72:\"index.php?lang=pt&year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:56:\"(en)/([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:81:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&feed=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:72:\"index.php?lang=pt&year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:37:\"(en)/([0-9]{4})/([0-9]{1,2})/embed/?$\";s:75:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&embed=true\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:66:\"index.php?lang=pt&year=$matches[1]&monthnum=$matches[2]&embed=true\";s:49:\"(en)/([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:82:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]&paged=$matches[4]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:73:\"index.php?lang=pt&year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:31:\"(en)/([0-9]{4})/([0-9]{1,2})/?$\";s:64:\"index.php?lang=$matches[1]&year=$matches[2]&monthnum=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:55:\"index.php?lang=pt&year=$matches[1]&monthnum=$matches[2]\";s:48:\"(en)/([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?lang=$matches[1]&year=$matches[2]&feed=$matches[3]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?lang=pt&year=$matches[1]&feed=$matches[2]\";s:43:\"(en)/([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?lang=$matches[1]&year=$matches[2]&feed=$matches[3]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?lang=pt&year=$matches[1]&feed=$matches[2]\";s:24:\"(en)/([0-9]{4})/embed/?$\";s:54:\"index.php?lang=$matches[1]&year=$matches[2]&embed=true\";s:19:\"([0-9]{4})/embed/?$\";s:45:\"index.php?lang=pt&year=$matches[1]&embed=true\";s:36:\"(en)/([0-9]{4})/page/?([0-9]{1,})/?$\";s:61:\"index.php?lang=$matches[1]&year=$matches[2]&paged=$matches[3]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:52:\"index.php?lang=pt&year=$matches[1]&paged=$matches[2]\";s:18:\"(en)/([0-9]{4})/?$\";s:43:\"index.php?lang=$matches[1]&year=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:34:\"index.php?lang=pt&year=$matches[1]\";s:32:\"(en)/.?.+?/attachment/([^/]+)/?$\";s:49:\"index.php?lang=$matches[1]&attachment=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"(en)/.?.+?/attachment/([^/]+)/trackback/?$\";s:54:\"index.php?lang=$matches[1]&attachment=$matches[2]&tb=1\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"(en)/.?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"(en)/.?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"(en)/.?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?lang=$matches[1]&attachment=$matches[2]&cpage=$matches[3]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"(en)/.?.+?/attachment/([^/]+)/embed/?$\";s:60:\"index.php?lang=$matches[1]&attachment=$matches[2]&embed=true\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"(en)/(.?.+?)/embed/?$\";s:58:\"index.php?lang=$matches[1]&pagename=$matches[2]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:25:\"(en)/(.?.+?)/trackback/?$\";s:52:\"index.php?lang=$matches[1]&pagename=$matches[2]&tb=1\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:45:\"(en)/(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?lang=$matches[1]&pagename=$matches[2]&feed=$matches[3]\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:40:\"(en)/(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?lang=$matches[1]&pagename=$matches[2]&feed=$matches[3]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:33:\"(en)/(.?.+?)/page/?([0-9]{1,})/?$\";s:65:\"index.php?lang=$matches[1]&pagename=$matches[2]&paged=$matches[3]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:40:\"(en)/(.?.+?)/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?lang=$matches[1]&pagename=$matches[2]&cpage=$matches[3]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:29:\"(en)/(.?.+?)(?:/([0-9]+))?/?$\";s:64:\"index.php?lang=$matches[1]&pagename=$matches[2]&page=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:32:\"(en)/[^/]+/attachment/([^/]+)/?$\";s:49:\"index.php?lang=$matches[1]&attachment=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"(en)/[^/]+/attachment/([^/]+)/trackback/?$\";s:54:\"index.php?lang=$matches[1]&attachment=$matches[2]&tb=1\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"(en)/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"(en)/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"(en)/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?lang=$matches[1]&attachment=$matches[2]&cpage=$matches[3]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"(en)/[^/]+/attachment/([^/]+)/embed/?$\";s:60:\"index.php?lang=$matches[1]&attachment=$matches[2]&embed=true\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:21:\"(en)/([^/]+)/embed/?$\";s:54:\"index.php?lang=$matches[1]&name=$matches[2]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:25:\"(en)/([^/]+)/trackback/?$\";s:48:\"index.php?lang=$matches[1]&name=$matches[2]&tb=1\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:45:\"(en)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?lang=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:40:\"(en)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?lang=$matches[1]&name=$matches[2]&feed=$matches[3]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:33:\"(en)/([^/]+)/page/?([0-9]{1,})/?$\";s:61:\"index.php?lang=$matches[1]&name=$matches[2]&paged=$matches[3]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:40:\"(en)/([^/]+)/comment-page-([0-9]{1,})/?$\";s:61:\"index.php?lang=$matches[1]&name=$matches[2]&cpage=$matches[3]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:29:\"(en)/([^/]+)(?:/([0-9]+))?/?$\";s:60:\"index.php?lang=$matches[1]&name=$matches[2]&page=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:21:\"(en)/[^/]+/([^/]+)/?$\";s:49:\"index.php?lang=$matches[1]&attachment=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"(en)/[^/]+/([^/]+)/trackback/?$\";s:54:\"index.php?lang=$matches[1]&attachment=$matches[2]&tb=1\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"(en)/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"(en)/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:66:\"index.php?lang=$matches[1]&attachment=$matches[2]&feed=$matches[3]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"(en)/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?lang=$matches[1]&attachment=$matches[2]&cpage=$matches[3]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:27:\"(en)/[^/]+/([^/]+)/embed/?$\";s:60:\"index.php?lang=$matches[1]&attachment=$matches[2]&embed=true\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "auto");
INSERT INTO `wp_options` VALUES("17127", "_site_transient_timeout_wp_theme_files_patterns-9a8e399a9868cf883d8030607583f32d", "1760520305", "off");
INSERT INTO `wp_options` VALUES("17128", "_site_transient_wp_theme_files_patterns-9a8e399a9868cf883d8030607583f32d", "a:2:{s:7:\"version\";s:3:\"1.0\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("17129", "_site_transient_timeout_wp_theme_files_patterns-64ddaf2de449619b6b3da7ef53d00178", "1760520305", "off");
INSERT INTO `wp_options` VALUES("17130", "_site_transient_wp_theme_files_patterns-64ddaf2de449619b6b3da7ef53d00178", "a:2:{s:7:\"version\";s:6:\"8.39.1\";s:8:\"patterns\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("17132", "_site_transient_timeout_available_translations", "1760529305", "off");
INSERT INTO `wp_options` VALUES("17133", "_site_transient_available_translations", "a:131:{s:2:\"af\";a:8:{s:8:\"language\";s:2:\"af\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-05-13 15:59:22\";s:12:\"english_name\";s:9:\"Afrikaans\";s:11:\"native_name\";s:9:\"Afrikaans\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/af.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"af\";i:2;s:3:\"afr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Gaan voort\";}}s:2:\"am\";a:8:{s:8:\"language\";s:2:\"am\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-09-29 20:43:49\";s:12:\"english_name\";s:7:\"Amharic\";s:11:\"native_name\";s:12:\"አማርኛ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.0.11/am.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"am\";i:2;s:3:\"amh\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"ቀጥል\";}}s:3:\"arg\";a:8:{s:8:\"language\";s:3:\"arg\";s:7:\"version\";s:8:\"6.2-beta\";s:7:\"updated\";s:19:\"2022-09-22 16:46:56\";s:12:\"english_name\";s:9:\"Aragonese\";s:11:\"native_name\";s:9:\"Aragonés\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.2-beta/arg.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"an\";i:2;s:3:\"arg\";i:3;s:3:\"arg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continar\";}}s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-02-13 12:49:38\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.4.7/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"متابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-01-26 15:42:35\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/ary.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"as\";a:8:{s:8:\"language\";s:2:\"as\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-10 08:09:09\";s:12:\"english_name\";s:8:\"Assamese\";s:11:\"native_name\";s:21:\"অসমীয়া\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/as.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"as\";i:2;s:3:\"asm\";i:3;s:3:\"asm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:3:\"azb\";a:8:{s:8:\"language\";s:3:\"azb\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2024-01-19 08:58:31\";s:12:\"english_name\";s:17:\"South Azerbaijani\";s:11:\"native_name\";s:29:\"گؤنئی آذربایجان\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.4.7/azb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:3;s:3:\"azb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-06 00:09:27\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:3:\"bel\";a:8:{s:8:\"language\";s:3:\"bel\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2024-12-26 00:37:42\";s:12:\"english_name\";s:10:\"Belarusian\";s:11:\"native_name\";s:29:\"Беларуская мова\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.9.28/bel.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"be\";i:2;s:3:\"bel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Працягнуць\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-26 09:35:39\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Напред\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-01 14:03:28\";s:12:\"english_name\";s:20:\"Bengali (Bangladesh)\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:28:\"চালিয়ে যান\";}}s:2:\"bo\";a:8:{s:8:\"language\";s:2:\"bo\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2020-10-30 03:24:38\";s:12:\"english_name\";s:7:\"Tibetan\";s:11:\"native_name\";s:21:\"བོད་ཡིག\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/5.8-beta/bo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bo\";i:2;s:3:\"tib\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:33:\"མུ་མཐུད་དུ།\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 20:45:53\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-19 10:33:50\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:3:\"ceb\";a:8:{s:8:\"language\";s:3:\"ceb\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-02 17:25:51\";s:12:\"english_name\";s:7:\"Cebuano\";s:11:\"native_name\";s:7:\"Cebuano\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/ceb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"ceb\";i:3;s:3:\"ceb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Padayun\";}}s:5:\"cs_CZ\";a:8:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-09 08:25:54\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/cs_CZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cs\";i:2;s:3:\"ces\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Pokračovat\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-11 16:48:51\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-25 10:23:08\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsæt\";}}s:5:\"de_AT\";a:8:{s:8:\"language\";s:5:\"de_AT\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-05 10:10:20\";s:12:\"english_name\";s:16:\"German (Austria)\";s:11:\"native_name\";s:21:\"Deutsch (Österreich)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/de_AT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-29 01:31:30\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-29 01:33:14\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.2/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-28 10:25:03\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:14:\"de_CH_informal\";a:8:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-28 10:25:24\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:73:\"https://downloads.wordpress.org/translation/core/6.8.2/de_CH_informal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Weiter\";}}s:3:\"dsb\";a:8:{s:8:\"language\";s:3:\"dsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-16 12:13:09\";s:12:\"english_name\";s:13:\"Lower Sorbian\";s:11:\"native_name\";s:16:\"Dolnoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/dsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"dsb\";i:3;s:3:\"dsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Dalej\";}}s:3:\"dzo\";a:8:{s:8:\"language\";s:3:\"dzo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-06-29 08:59:03\";s:12:\"english_name\";s:8:\"Dzongkha\";s:11:\"native_name\";s:18:\"རྫོང་ཁ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/dzo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"dz\";i:2;s:3:\"dzo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-21 14:54:13\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-22 11:56:25\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-30 21:52:12\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-19 23:02:24\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-25 13:50:40\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-29 13:22:09\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-19 08:40:47\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_CR\";a:8:{s:8:\"language\";s:5:\"es_CR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-26 16:45:13\";s:12:\"english_name\";s:20:\"Spanish (Costa Rica)\";s:11:\"native_name\";s:22:\"Español de Costa Rica\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_CR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2024-10-16 21:04:12\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_PE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-28 22:23:40\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_CL.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_AR\";a:8:{s:8:\"language\";s:5:\"es_AR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-14 15:46:25\";s:12:\"english_name\";s:19:\"Spanish (Argentina)\";s:11:\"native_name\";s:21:\"Español de Argentina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_AR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-29 19:09:09\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_ES.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-30 13:57:29\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_MX.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-10-16 16:00:04\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/es_VE.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_EC\";a:8:{s:8:\"language\";s:5:\"es_EC\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-04-21 13:32:10\";s:12:\"english_name\";s:17:\"Spanish (Ecuador)\";s:11:\"native_name\";s:19:\"Español de Ecuador\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/es_EC.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_DO\";a:8:{s:8:\"language\";s:5:\"es_DO\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2021-10-08 14:32:50\";s:12:\"english_name\";s:28:\"Spanish (Dominican Republic)\";s:11:\"native_name\";s:33:\"Español de República Dominicana\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.8.12/es_DO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_UY\";a:8:{s:8:\"language\";s:5:\"es_UY\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-31 18:33:26\";s:12:\"english_name\";s:17:\"Spanish (Uruguay)\";s:11:\"native_name\";s:19:\"Español de Uruguay\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/es_UY.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PR\";a:8:{s:8:\"language\";s:5:\"es_PR\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-29 15:36:59\";s:12:\"english_name\";s:21:\"Spanish (Puerto Rico)\";s:11:\"native_name\";s:23:\"Español de Puerto Rico\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.4.18/es_PR.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-11 05:24:36\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/es_CO.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_GT\";a:8:{s:8:\"language\";s:5:\"es_GT\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-03-02 06:35:01\";s:12:\"english_name\";s:19:\"Spanish (Guatemala)\";s:11:\"native_name\";s:21:\"Español de Guatemala\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.2.23/es_GT.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"es\";i:2;s:3:\"spa\";i:3;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"6.5.5\";s:7:\"updated\";s:19:\"2024-06-06 09:50:37\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.5/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-05 12:26:55\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_AF\";a:8:{s:8:\"language\";s:5:\"fa_AF\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-02-14 17:29:08\";s:12:\"english_name\";s:21:\"Persian (Afghanistan)\";s:11:\"native_name\";s:31:\"(فارسی (افغانستان\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/fa_AF.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-03 12:49:52\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-05-12 09:41:09\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-29 15:04:36\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_CA\";a:8:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-25 05:20:17\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/fr_CA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-02-01 23:56:53\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.5.7/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:3:\"fur\";a:8:{s:8:\"language\";s:3:\"fur\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2023-04-30 13:56:46\";s:12:\"english_name\";s:8:\"Friulian\";s:11:\"native_name\";s:8:\"Friulian\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/fur.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"fur\";i:3;s:3:\"fur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"fy\";a:8:{s:8:\"language\";s:2:\"fy\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-12-25 12:53:23\";s:12:\"english_name\";s:7:\"Frisian\";s:11:\"native_name\";s:5:\"Frysk\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.2.8/fy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fy\";i:2;s:3:\"fry\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Trochgean\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-08-23 17:41:37\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-16 11:10:04\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"gu\";a:8:{s:8:\"language\";s:2:\"gu\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-29 04:27:18\";s:12:\"english_name\";s:8:\"Gujarati\";s:11:\"native_name\";s:21:\"ગુજરાતી\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/gu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gu\";i:2;s:3:\"guj\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ચાલુ રાખો\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:6:\"4.4.34\";s:7:\"updated\";s:19:\"2015-12-05 00:59:09\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.4.34/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2024-05-04 18:39:24\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"המשך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2025-02-06 05:17:11\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"जारी रखें\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-31 12:41:06\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:3:\"hsb\";a:8:{s:8:\"language\";s:3:\"hsb\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-02-22 17:37:32\";s:12:\"english_name\";s:13:\"Upper Sorbian\";s:11:\"native_name\";s:17:\"Hornjoserbšćina\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/hsb.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"hsb\";i:3;s:3:\"hsb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:4:\"Dale\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-09 13:56:03\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Folytatás\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-12-03 16:21:10\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-16 04:17:52\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2018-12-11 10:40:02\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-11 21:28:29\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-22 12:19:14\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"次へ\";}}s:5:\"jv_ID\";a:8:{s:8:\"language\";s:5:\"jv_ID\";s:7:\"version\";s:6:\"4.9.28\";s:7:\"updated\";s:19:\"2019-02-16 23:58:56\";s:12:\"english_name\";s:8:\"Javanese\";s:11:\"native_name\";s:9:\"Basa Jawa\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.9.28/jv_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"jv\";i:2;s:3:\"jav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Nerusaké\";}}s:5:\"ka_GE\";a:8:{s:8:\"language\";s:5:\"ka_GE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-14 08:02:58\";s:12:\"english_name\";s:8:\"Georgian\";s:11:\"native_name\";s:21:\"ქართული\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ka_GE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ka\";i:2;s:3:\"kat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"გაგრძელება\";}}s:3:\"kab\";a:8:{s:8:\"language\";s:3:\"kab\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2023-07-05 11:40:39\";s:12:\"english_name\";s:6:\"Kabyle\";s:11:\"native_name\";s:9:\"Taqbaylit\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.2.8/kab.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"kab\";i:3;s:3:\"kab\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Kemmel\";}}s:2:\"kk\";a:8:{s:8:\"language\";s:2:\"kk\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2024-07-18 02:49:24\";s:12:\"english_name\";s:6:\"Kazakh\";s:11:\"native_name\";s:19:\"Қазақ тілі\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/kk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kk\";i:2;s:3:\"kaz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Жалғастыру\";}}s:2:\"km\";a:8:{s:8:\"language\";s:2:\"km\";s:7:\"version\";s:6:\"5.2.23\";s:7:\"updated\";s:19:\"2019-06-10 16:18:28\";s:12:\"english_name\";s:5:\"Khmer\";s:11:\"native_name\";s:27:\"ភាសាខ្មែរ\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.2.23/km.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"km\";i:2;s:3:\"khm\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"បន្ត\";}}s:2:\"kn\";a:8:{s:8:\"language\";s:2:\"kn\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-22 16:17:50\";s:12:\"english_name\";s:7:\"Kannada\";s:11:\"native_name\";s:15:\"ಕನ್ನಡ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/kn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"kn\";i:2;s:3:\"kan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"ಮುಂದುವರಿಸು\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-15 15:01:44\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:3:\"ckb\";a:8:{s:8:\"language\";s:3:\"ckb\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-22 23:30:14\";s:12:\"english_name\";s:16:\"Kurdish (Sorani)\";s:11:\"native_name\";s:13:\"كوردی‎\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.2/ckb.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ku\";i:3;s:3:\"ckb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"به‌رده‌وام به‌\";}}s:3:\"kir\";a:8:{s:8:\"language\";s:3:\"kir\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-17 05:00:42\";s:12:\"english_name\";s:6:\"Kyrgyz\";s:11:\"native_name\";s:16:\"Кыргызча\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.2/kir.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ky\";i:2;s:3:\"kir\";i:3;s:3:\"kir\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Улантуу\";}}s:2:\"lo\";a:8:{s:8:\"language\";s:2:\"lo\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 09:59:23\";s:12:\"english_name\";s:3:\"Lao\";s:11:\"native_name\";s:21:\"ພາສາລາວ\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/lo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lo\";i:2;s:3:\"lao\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"ຕໍ່​ໄປ\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-27 20:51:17\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:2:\"lv\";a:8:{s:8:\"language\";s:2:\"lv\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-15 19:11:43\";s:12:\"english_name\";s:7:\"Latvian\";s:11:\"native_name\";s:16:\"Latviešu valoda\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/lv.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lv\";i:2;s:3:\"lav\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Turpināt\";}}s:5:\"mk_MK\";a:8:{s:8:\"language\";s:5:\"mk_MK\";s:7:\"version\";s:6:\"6.0.11\";s:7:\"updated\";s:19:\"2022-10-01 09:23:52\";s:12:\"english_name\";s:10:\"Macedonian\";s:11:\"native_name\";s:31:\"Македонски јазик\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/6.0.11/mk_MK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mk\";i:2;s:3:\"mkd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Продолжи\";}}s:5:\"ml_IN\";a:8:{s:8:\"language\";s:5:\"ml_IN\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-24 16:32:35\";s:12:\"english_name\";s:9:\"Malayalam\";s:11:\"native_name\";s:18:\"മലയാളം\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ml_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ml\";i:2;s:3:\"mal\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"തുടരുക\";}}s:2:\"mn\";a:8:{s:8:\"language\";s:2:\"mn\";s:7:\"version\";s:5:\"6.5.7\";s:7:\"updated\";s:19:\"2024-06-20 17:22:06\";s:12:\"english_name\";s:9:\"Mongolian\";s:11:\"native_name\";s:12:\"Монгол\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.5.7/mn.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mn\";i:2;s:3:\"mon\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"mr\";a:8:{s:8:\"language\";s:2:\"mr\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-26 17:30:52\";s:12:\"english_name\";s:7:\"Marathi\";s:11:\"native_name\";s:15:\"मराठी\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/mr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"mr\";i:2;s:3:\"mar\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"सुरु ठेवा\";}}s:5:\"ms_MY\";a:8:{s:8:\"language\";s:5:\"ms_MY\";s:7:\"version\";s:6:\"5.5.17\";s:7:\"updated\";s:19:\"2022-03-11 13:52:22\";s:12:\"english_name\";s:5:\"Malay\";s:11:\"native_name\";s:13:\"Bahasa Melayu\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/5.5.17/ms_MY.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ms\";i:2;s:3:\"msa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Teruskan\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2017-12-26 11:57:10\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ဆောင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-30 18:16:57\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"ne_NP\";a:8:{s:8:\"language\";s:5:\"ne_NP\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-23 09:31:59\";s:12:\"english_name\";s:6:\"Nepali\";s:11:\"native_name\";s:18:\"नेपाली\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ne_NP.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ne\";i:2;s:3:\"nep\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:43:\"जारी राख्नुहोस्\";}}s:5:\"nl_BE\";a:8:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-29 06:56:09\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/nl_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:12:\"nl_NL_formal\";a:8:{s:8:\"language\";s:12:\"nl_NL_formal\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-31 11:10:17\";s:12:\"english_name\";s:14:\"Dutch (Formal)\";s:11:\"native_name\";s:20:\"Nederlands (Formeel)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/6.8.2/nl_NL_formal.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-15 07:18:24\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-03-18 10:59:16\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.8.27\";s:7:\"updated\";s:19:\"2017-08-25 10:03:08\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.8.27/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pa_IN\";a:8:{s:8:\"language\";s:5:\"pa_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-16 05:19:43\";s:12:\"english_name\";s:15:\"Panjabi (India)\";s:11:\"native_name\";s:18:\"ਪੰਜਾਬੀ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/pa_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pa\";i:2;s:3:\"pan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:25:\"ਜਾਰੀ ਰੱਖੋ\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-20 12:00:49\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:6:\"4.3.35\";s:7:\"updated\";s:19:\"2015-12-02 21:41:29\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.35/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"دوام ورکړه\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-27 23:38:30\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-30 11:47:36\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_AO\";a:8:{s:8:\"language\";s:5:\"pt_AO\";s:7:\"version\";s:5:\"6.4.7\";s:7:\"updated\";s:19:\"2023-08-21 12:15:00\";s:12:\"english_name\";s:19:\"Portuguese (Angola)\";s:11:\"native_name\";s:20:\"Português de Angola\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.4.7/pt_AO.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:10:\"pt_PT_ao90\";a:8:{s:8:\"language\";s:10:\"pt_PT_ao90\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-27 23:48:59\";s:12:\"english_name\";s:27:\"Portuguese (Portugal, AO90)\";s:11:\"native_name\";s:17:\"Português (AO90)\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/translation/core/6.8.2/pt_PT_ao90.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"rhg\";a:8:{s:8:\"language\";s:3:\"rhg\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-16 13:03:18\";s:12:\"english_name\";s:8:\"Rohingya\";s:11:\"native_name\";s:8:\"Ruáinga\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/rhg.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"rhg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-24 09:05:42\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-24 17:30:30\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:3:\"sah\";a:8:{s:8:\"language\";s:3:\"sah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-21 02:06:41\";s:12:\"english_name\";s:5:\"Sakha\";s:11:\"native_name\";s:14:\"Сахалыы\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/sah.zip\";s:3:\"iso\";a:2:{i:2;s:3:\"sah\";i:3;s:3:\"sah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Салҕаа\";}}s:3:\"snd\";a:8:{s:8:\"language\";s:3:\"snd\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-07-07 01:53:37\";s:12:\"english_name\";s:6:\"Sindhi\";s:11:\"native_name\";s:8:\"سنڌي\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/5.4.18/snd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"sd\";i:2;s:3:\"snd\";i:3;s:3:\"snd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"اڳتي هلو\";}}s:5:\"si_LK\";a:8:{s:8:\"language\";s:5:\"si_LK\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-12 06:00:52\";s:12:\"english_name\";s:7:\"Sinhala\";s:11:\"native_name\";s:15:\"සිංහල\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/si_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"si\";i:2;s:3:\"sin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:44:\"දිගටම කරගෙන යන්න\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-29 04:32:58\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:3:\"skr\";a:8:{s:8:\"language\";s:3:\"skr\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-24 16:58:02\";s:12:\"english_name\";s:7:\"Saraiki\";s:11:\"native_name\";s:14:\"سرائیکی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/6.8.2/skr.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"skr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"جاری رکھو\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-14 09:44:53\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Nadaljuj\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-18 09:38:51\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-08 20:51:20\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-08-10 20:44:58\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"sw\";a:8:{s:8:\"language\";s:2:\"sw\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-06-28 12:50:48\";s:12:\"english_name\";s:7:\"Swahili\";s:11:\"native_name\";s:9:\"Kiswahili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/sw.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sw\";i:2;s:3:\"swa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Endelea\";}}s:3:\"szl\";a:8:{s:8:\"language\";s:3:\"szl\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-09-24 19:58:14\";s:12:\"english_name\";s:8:\"Silesian\";s:11:\"native_name\";s:17:\"Ślōnskŏ gŏdka\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/szl.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"szl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:13:\"Kōntynuować\";}}s:5:\"ta_IN\";a:8:{s:8:\"language\";s:5:\"ta_IN\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-27 03:22:47\";s:12:\"english_name\";s:5:\"Tamil\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/ta_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:24:\"தொடரவும்\";}}s:5:\"ta_LK\";a:8:{s:8:\"language\";s:5:\"ta_LK\";s:7:\"version\";s:6:\"4.2.39\";s:7:\"updated\";s:19:\"2015-12-03 01:07:44\";s:12:\"english_name\";s:17:\"Tamil (Sri Lanka)\";s:11:\"native_name\";s:15:\"தமிழ்\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.2.39/ta_LK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ta\";i:2;s:3:\"tam\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:18:\"தொடர்க\";}}s:2:\"te\";a:8:{s:8:\"language\";s:2:\"te\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2017-01-26 15:47:39\";s:12:\"english_name\";s:6:\"Telugu\";s:11:\"native_name\";s:18:\"తెలుగు\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.7.2/te.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"te\";i:2;s:3:\"tel\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:30:\"కొనసాగించు\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:6:\"5.8.12\";s:7:\"updated\";s:19:\"2022-06-08 04:30:30\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.8.12/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-08 16:09:09\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-04-16 23:11:08\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"tt_RU\";a:8:{s:8:\"language\";s:5:\"tt_RU\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-11-20 20:20:50\";s:12:\"english_name\";s:5:\"Tatar\";s:11:\"native_name\";s:19:\"Татар теле\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.7.2/tt_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tt\";i:2;s:3:\"tat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:17:\"дәвам итү\";}}s:3:\"tah\";a:8:{s:8:\"language\";s:3:\"tah\";s:7:\"version\";s:5:\"4.7.2\";s:7:\"updated\";s:19:\"2016-03-06 18:39:39\";s:12:\"english_name\";s:8:\"Tahitian\";s:11:\"native_name\";s:10:\"Reo Tahiti\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.7.2/tah.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"ty\";i:2;s:3:\"tah\";i:3;s:3:\"tah\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-29 21:46:36\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:16:\"ئۇيغۇرچە\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"6.8\";s:7:\"updated\";s:19:\"2025-04-18 21:10:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/translation/core/6.8/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"ur\";a:8:{s:8:\"language\";s:2:\"ur\";s:7:\"version\";s:6:\"5.4.18\";s:7:\"updated\";s:19:\"2020-04-09 11:17:33\";s:12:\"english_name\";s:4:\"Urdu\";s:11:\"native_name\";s:8:\"اردو\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/5.4.18/ur.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ur\";i:2;s:3:\"urd\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:19:\"جاری رکھیں\";}}s:5:\"uz_UZ\";a:8:{s:8:\"language\";s:5:\"uz_UZ\";s:7:\"version\";s:8:\"5.8-beta\";s:7:\"updated\";s:19:\"2021-02-28 12:02:22\";s:12:\"english_name\";s:5:\"Uzbek\";s:11:\"native_name\";s:11:\"O‘zbekcha\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/translation/core/5.8-beta/uz_UZ.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uz\";i:2;s:3:\"uzb\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:11:\"Davom etish\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-09-01 09:12:13\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/6.8.2/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-16 04:41:52\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_HK\";a:8:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"6.2.8\";s:7:\"updated\";s:19:\"2022-07-15 15:25:03\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:12:\"香港中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.2.8/zh_HK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"6.8.2\";s:7:\"updated\";s:19:\"2025-07-29 06:55:14\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/6.8.2/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}", "off");
INSERT INTO `wp_options` VALUES("17134", "_site_transient_timeout_theme_roots", "1760520306", "off");
INSERT INTO `wp_options` VALUES("17135", "_site_transient_theme_roots", "a:5:{s:7:\"Impreza\";s:7:\"/themes\";s:13:\"makeitdigital\";s:7:\"/themes\";s:16:\"twentytwentyfive\";s:7:\"/themes\";s:16:\"twentytwentyfour\";s:7:\"/themes\";s:17:\"twentytwentythree\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("17136", "_site_transient_timeout_php_check_84bab1ffd8c4f8f9d81d62c8afdcab8a", "1761123306", "off");
INSERT INTO `wp_options` VALUES("17137", "_site_transient_php_check_84bab1ffd8c4f8f9d81d62c8afdcab8a", "a:5:{s:19:\"recommended_version\";s:3:\"8.3\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("17139", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1760518515;s:8:\"response\";a:5:{s:30:\"advanced-custom-fields/acf.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:36:\"w.org/plugins/advanced-custom-fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:6:\"plugin\";s:30:\"advanced-custom-fields/acf.php\";s:11:\"new_version\";s:5:\"6.6.0\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/advanced-custom-fields/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/advanced-custom-fields.6.6.0.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:67:\"https://ps.w.org/advanced-custom-fields/assets/icon.svg?rev=3207824\";s:3:\"svg\";s:67:\"https://ps.w.org/advanced-custom-fields/assets/icon.svg?rev=3207824\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/advanced-custom-fields/assets/banner-1544x500.jpg?rev=3374528\";s:2:\"1x\";s:77:\"https://ps.w.org/advanced-custom-fields/assets/banner-772x250.jpg?rev=3374528\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.2\";s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.5.14\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.5.14.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}s:41:\"password-protected/password-protected.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:32:\"w.org/plugins/password-protected\";s:4:\"slug\";s:18:\"password-protected\";s:6:\"plugin\";s:41:\"password-protected/password-protected.php\";s:11:\"new_version\";s:6:\"2.7.12\";s:3:\"url\";s:49:\"https://wordpress.org/plugins/password-protected/\";s:7:\"package\";s:68:\"https://downloads.wordpress.org/plugin/password-protected.2.7.12.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/password-protected/assets/icon-128x128.gif?rev=2824217\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/password-protected/assets/banner-1544x500.jpg?rev=3107315\";s:2:\"1x\";s:73:\"https://ps.w.org/password-protected/assets/banner-772x250.jpg?rev=3107315\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"5.6\";s:16:\"requires_plugins\";a:0:{}}s:26:\"post-smtp/postman-smtp.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:23:\"w.org/plugins/post-smtp\";s:4:\"slug\";s:9:\"post-smtp\";s:6:\"plugin\";s:26:\"post-smtp/postman-smtp.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/post-smtp/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/post-smtp.3.6.0.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:62:\"https://ps.w.org/post-smtp/assets/icon-128x128.gif?rev=3209655\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/post-smtp/assets/banner-1544x500.jpg?rev=3296254\";s:2:\"1x\";s:64:\"https://ps.w.org/post-smtp/assets/banner-772x250.jpg?rev=3296254\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"5.6.0\";s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"7.0\";s:16:\"requires_plugins\";a:0:{}}s:30:\"seo-by-rank-math/rank-math.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:30:\"w.org/plugins/seo-by-rank-math\";s:4:\"slug\";s:16:\"seo-by-rank-math\";s:6:\"plugin\";s:30:\"seo-by-rank-math/rank-math.php\";s:11:\"new_version\";s:7:\"1.0.255\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/seo-by-rank-math/\";s:7:\"package\";s:67:\"https://downloads.wordpress.org/plugin/seo-by-rank-math.1.0.255.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:61:\"https://ps.w.org/seo-by-rank-math/assets/icon.svg?rev=3218327\";s:3:\"svg\";s:61:\"https://ps.w.org/seo-by-rank-math/assets/icon.svg?rev=3218327\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/seo-by-rank-math/assets/banner-1544x500.png?rev=2639678\";s:2:\"1x\";s:71:\"https://ps.w.org/seo-by-rank-math/assets/banner-772x250.png?rev=2639678\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.3\";s:6:\"tested\";s:5:\"6.8.3\";s:12:\"requires_php\";s:3:\"7.4\";s:16:\"requires_plugins\";a:0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:4:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:3:\"5.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:54:\"https://downloads.wordpress.org/plugin/akismet.5.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";}s:23:\"loco-translate/loco.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/loco-translate\";s:4:\"slug\";s:14:\"loco-translate\";s:6:\"plugin\";s:23:\"loco-translate/loco.php\";s:11:\"new_version\";s:5:\"2.8.0\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/loco-translate/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/loco-translate.2.8.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/loco-translate/assets/icon-256x256.png?rev=1000676\";s:2:\"1x\";s:67:\"https://ps.w.org/loco-translate/assets/icon-128x128.png?rev=1000676\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:68:\"https://ps.w.org/loco-translate/assets/banner-772x250.jpg?rev=745046\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:21:\"polylang/polylang.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:22:\"w.org/plugins/polylang\";s:4:\"slug\";s:8:\"polylang\";s:6:\"plugin\";s:21:\"polylang/polylang.php\";s:11:\"new_version\";s:5:\"3.7.3\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/polylang/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/polylang.3.7.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:61:\"https://ps.w.org/polylang/assets/icon-256x256.png?rev=1331499\";s:2:\"1x\";s:61:\"https://ps.w.org/polylang/assets/icon-128x128.png?rev=1331499\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/polylang/assets/banner-1544x500.png?rev=1405299\";s:2:\"1x\";s:63:\"https://ps.w.org/polylang/assets/banner-772x250.png?rev=1405299\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.2\";}s:35:\"insert-headers-and-footers/ihaf.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:40:\"w.org/plugins/insert-headers-and-footers\";s:4:\"slug\";s:26:\"insert-headers-and-footers\";s:6:\"plugin\";s:35:\"insert-headers-and-footers/ihaf.php\";s:11:\"new_version\";s:5:\"2.3.0\";s:3:\"url\";s:57:\"https://wordpress.org/plugins/insert-headers-and-footers/\";s:7:\"package\";s:75:\"https://downloads.wordpress.org/plugin/insert-headers-and-footers.2.3.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:79:\"https://ps.w.org/insert-headers-and-footers/assets/icon-256x256.png?rev=2758516\";s:2:\"1x\";s:79:\"https://ps.w.org/insert-headers-and-footers/assets/icon-128x128.png?rev=2758516\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:82:\"https://ps.w.org/insert-headers-and-footers/assets/banner-1544x500.png?rev=2758516\";s:2:\"1x\";s:81:\"https://ps.w.org/insert-headers-and-footers/assets/banner-772x250.png?rev=2758516\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}}s:7:\"checked\";a:14:{s:30:\"advanced-custom-fields/acf.php\";s:5:\"6.5.1\";s:19:\"akismet/akismet.php\";s:3:\"5.5\";s:23:\"dhvc-form/dhvc-form.php\";s:6:\"2.4.17\";s:25:\"duplicator/duplicator.php\";s:8:\"1.5.13.3\";s:23:\"loco-translate/loco.php\";s:5:\"2.8.0\";s:35:\"rc_particlebackground/vc_extend.php\";s:3:\"4.6\";s:41:\"password-protected/password-protected.php\";s:6:\"2.7.10\";s:21:\"polylang/polylang.php\";s:5:\"3.7.3\";s:26:\"post-smtp/postman-smtp.php\";s:5:\"3.4.2\";s:30:\"seo-by-rank-math/rank-math.php\";s:7:\"1.0.253\";s:41:\"Ultimate_VC_Addons/Ultimate_VC_Addons.php\";s:6:\"3.21.1\";s:19:\"us-core/us-core.php\";s:6:\"8.39.1\";s:27:\"js_composer/js_composer.php\";s:5:\"8.6.1\";s:35:\"insert-headers-and-footers/ihaf.php\";s:5:\"2.3.0\";}}", "off");
INSERT INTO `wp_options` VALUES("17140", "_site_transient_timeout_fs_garbage_collection", "1760604915", "off");
INSERT INTO `wp_options` VALUES("17141", "_site_transient_fs_garbage_collection", "1", "off");
INSERT INTO `wp_options` VALUES("17142", "_transient_timeout_us_update_addons_data_Impreza", "1760540116", "off");
INSERT INTO `wp_options` VALUES("17143", "_transient_us_update_addons_data_Impreza", "O:8:\"stdClass\":2:{s:7:\"success\";i:0;s:6:\"errors\";O:8:\"stdClass\":1:{s:44:\"for_wordpress.validation.purchase_code.wrong\";s:30:\"validation.purchase_code.wrong\";}}", "off");
INSERT INTO `wp_options` VALUES("17158", "_transient_pll_languages_list", "a:2:{i:0;a:22:{s:4:\"name\";s:2:\"PT\";s:4:\"slug\";s:2:\"pt\";s:10:\"term_group\";i:0;s:7:\"term_id\";i:10;s:6:\"locale\";s:5:\"pt_PT\";s:6:\"is_rtl\";i:0;s:3:\"w3c\";s:5:\"pt-PT\";s:8:\"facebook\";s:5:\"pt_PT\";s:8:\"home_url\";s:31:\"https://xpharma.digitalpath.pt/\";s:10:\"search_url\";s:31:\"https://xpharma.digitalpath.pt/\";s:4:\"host\";N;s:13:\"page_on_front\";i:130;s:14:\"page_for_posts\";i:0;s:9:\"flag_code\";s:2:\"pt\";s:8:\"flag_url\";s:71:\"https://xpharma.digitalpath.pt/wp-content/plugins/polylang/flags/pt.png\";s:4:\"flag\";s:583:\"<img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAIAAAD5gJpuAAABL0lEQVR4AV2RA2yEQRCFNxcnRVw3qG3bthXUbZxaUaOGRVA7ro2wDWoEtW2b9/b2nHx3v943uztDSAwhAQJ86P83keCJw2HcEAJoqLivmJHbnQt+s7OFfMXHMz5DAgBPCKBCUktSRmdK43Dw3Gz451TIc68nPr+7uLzZWr2Zm78bGLxpa797e1+IC0erUeAmL+ol3R8CEE+/qqvDv2BbwjYi6yJR+6Ys5m5zA0C7HbWEIEy/KCpKC8uzQRf5fkivX3zBZIIw/Swvj8cTKthRIbDGDwcYnXRF7avy/KM5q8NZg2cDPWEaYHt8AceFACBsTdui9nmn8VWmpngawN+ngiEVHCocGM5Vpu8G0rUB5iAS0CKAYwCsg/YB1lPWKESBSCAqhMiKwHQueJwI2BeDC83C2lDIxUCuAAAAAElFTkSuQmCC\" alt=\"PT\" width=\"16\" height=\"11\" style=\"width: 16px; height: 11px;\" />\";s:15:\"custom_flag_url\";s:0:\"\";s:11:\"custom_flag\";s:0:\"\";s:6:\"active\";b:1;s:9:\"fallbacks\";a:0:{}s:10:\"is_default\";b:1;s:10:\"term_props\";a:2:{s:8:\"language\";a:3:{s:7:\"term_id\";i:10;s:16:\"term_taxonomy_id\";i:10;s:5:\"count\";i:26;}s:13:\"term_language\";a:3:{s:7:\"term_id\";i:11;s:16:\"term_taxonomy_id\";i:11;s:5:\"count\";i:1;}}}i:1;a:22:{s:4:\"name\";s:2:\"EN\";s:4:\"slug\";s:2:\"en\";s:10:\"term_group\";i:0;s:7:\"term_id\";i:27;s:6:\"locale\";s:5:\"en_GB\";s:6:\"is_rtl\";i:0;s:3:\"w3c\";s:5:\"en-GB\";s:8:\"facebook\";s:5:\"en_GB\";s:8:\"home_url\";s:34:\"https://xpharma.digitalpath.pt/en/\";s:10:\"search_url\";s:34:\"https://xpharma.digitalpath.pt/en/\";s:4:\"host\";N;s:13:\"page_on_front\";i:541;s:14:\"page_for_posts\";i:0;s:9:\"flag_code\";s:2:\"gb\";s:8:\"flag_url\";s:71:\"https://xpharma.digitalpath.pt/wp-content/plugins/polylang/flags/gb.png\";s:4:\"flag\";s:631:\"<img src=\"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABAAAAALCAMAAABBPP0LAAAAt1BMVEWSmb66z+18msdig8La3u+tYX9IaLc7W7BagbmcUW+kqMr/q6n+//+hsNv/lIr/jIGMnNLJyOP9/fyQttT/wb3/////aWn+YWF5kNT0oqz0i4ueqtIZNJjhvt/8gn//WVr/6+rN1+o9RKZwgcMPJpX/VFT9UEn+RUX8Ozv2Ly+FGzdYZrfU1e/8LS/lQkG/mbVUX60AE231hHtcdMb0mp3qYFTFwNu3w9prcqSURGNDaaIUMX5FNW5wYt7AAAAAjklEQVR4AR3HNUJEMQCGwf+L8RR36ajR+1+CEuvRdd8kK9MNAiRQNgJmVDAt1yM6kSzYVJUsPNssAk5N7ZFKjVNFAY4co6TAOI+kyQm+LFUEBEKKzuWUNB7rSH/rSnvOulOGk+QlXTBqMIrfYX4tSe2nP3iRa/KNK7uTmWJ5a9+erZ3d+18od4ytiZdvZyuKWy8o3UpTVAAAAABJRU5ErkJggg==\" alt=\"EN\" width=\"16\" height=\"11\" style=\"width: 16px; height: 11px;\" />\";s:15:\"custom_flag_url\";s:0:\"\";s:11:\"custom_flag\";s:0:\"\";s:6:\"active\";b:1;s:9:\"fallbacks\";a:0:{}s:10:\"is_default\";b:0;s:10:\"term_props\";a:2:{s:8:\"language\";a:3:{s:7:\"term_id\";i:27;s:16:\"term_taxonomy_id\";i:27;s:5:\"count\";i:8;}s:13:\"term_language\";a:3:{s:7:\"term_id\";i:28;s:16:\"term_taxonomy_id\";i:28;s:5:\"count\";i:1;}}}}", "on");
INSERT INTO `wp_options` VALUES("17160", "duplicator_expire_search-replace-wpcode", "{\"expire\":1761728919,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.0\"}}", "on");
INSERT INTO `wp_options` VALUES("17161", "duplicator_expire_wp-mail-smtp", "{\"expire\":1761728919,\"value\":{\"wp_version\":\"5.5\",\"php_version\":\"7.4\"}}", "on");
INSERT INTO `wp_options` VALUES("17162", "duplicator_expire_all-in-one-seo-pack", "{\"expire\":1761728920,\"value\":{\"wp_version\":\"5.7\",\"php_version\":\"7.2\"}}", "on");

/* INSERT TABLE DATA: wp_postmeta */
INSERT INTO `wp_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("2", "3", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("4", "5", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("5", "5", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("6", "5", "_form_control", "a:5:{s:4:\"nome\";a:4:{s:8:\"required\";s:1:\"1\";s:12:\"control_name\";s:4:\"nome\";s:11:\"placeholder\";s:4:\"Nome\";s:3:\"tag\";s:14:\"dhvc_form_text\";}s:5:\"email\";a:4:{s:8:\"required\";s:1:\"1\";s:12:\"control_name\";s:5:\"email\";s:11:\"placeholder\";s:5:\"Email\";s:3:\"tag\";s:15:\"dhvc_form_email\";}s:8:\"telefone\";a:4:{s:8:\"required\";s:1:\"1\";s:12:\"control_name\";s:8:\"telefone\";s:11:\"placeholder\";s:8:\"Telefone\";s:3:\"tag\";s:14:\"dhvc_form_text\";}s:8:\"mensagem\";a:5:{s:8:\"required\";s:1:\"1\";s:12:\"control_name\";s:8:\"mensagem\";s:9:\"input_css\";s:57:\".vc_custom_1758028114321{margin-bottom: 20px !important;}\";s:11:\"placeholder\";s:8:\"Mensagem\";s:3:\"tag\";s:18:\"dhvc_form_textarea\";}s:5:\"optin\";a:5:{s:8:\"required\";s:1:\"1\";s:12:\"control_name\";s:5:\"optin\";s:7:\"options\";s:348:\"W3siaXNfZGVmYXVsdCI6MCwibGFiZWwiOiI8c3BhbiBzdHlsZT1cImZvbnQtc2l6ZTowLjdyZW0gIWltcG9ydGFudDtjb2xvcjojZmZmICFpbXBvcnRhbnQ7XCI+RXN0b3UgZGUgYWNvcmRvIGNvbSBhIDxhIGhyZWY9XCIvcG9saXRpY2EtcHJpdmFjaWRhZGUvXCIgdGFyZ2V0PVwiX2JsYW5rXCIgcmVsPVwibm9vcGVuZXJcIj5Qb2zDrXRpY2EgZGUgUHJpdmFjaWRhZGU8L2E+IHF1ZSBsaSBlIGNvbXByZWVuZGkuPC9zcGFuPiIsInZhbHVlIjoib3B0aW4ifV0=\";s:9:\"input_css\";s:57:\".vc_custom_1758028132742{margin-bottom: 20px !important;}\";s:3:\"tag\";s:18:\"dhvc_form_checkbox\";}}");
INSERT INTO `wp_postmeta` VALUES("7", "5", "_save_data", "1");
INSERT INTO `wp_postmeta` VALUES("8", "5", "_action_type", "default");
INSERT INTO `wp_postmeta` VALUES("9", "5", "_method", "post");
INSERT INTO `wp_postmeta` VALUES("10", "5", "_on_success", "message");
INSERT INTO `wp_postmeta` VALUES("11", "5", "_message", "A sua mensagem foi enviada com sucesso.");
INSERT INTO `wp_postmeta` VALUES("12", "5", "_message_position", "bottom");
INSERT INTO `wp_postmeta` VALUES("13", "5", "_redirect_to", "to_page");
INSERT INTO `wp_postmeta` VALUES("14", "5", "_page", "32");
INSERT INTO `wp_postmeta` VALUES("15", "5", "_post", "1");
INSERT INTO `wp_postmeta` VALUES("16", "5", "_form_popup_width", "600");
INSERT INTO `wp_postmeta` VALUES("17", "5", "_form_popup_auto_open_delay", "2000");
INSERT INTO `wp_postmeta` VALUES("18", "5", "_form_popup_auto_close_delay", "10000");
INSERT INTO `wp_postmeta` VALUES("19", "5", "_notice", "1");
INSERT INTO `wp_postmeta` VALUES("20", "5", "_notice_name", "Mid Template");
INSERT INTO `wp_postmeta` VALUES("21", "5", "_notice_email_type", "email_text");
INSERT INTO `wp_postmeta` VALUES("22", "5", "_notice_email", "it@makeitdigital.pt");
INSERT INTO `wp_postmeta` VALUES("23", "5", "_notice_recipients", "a:1:{i:0;s:19:\"it@makeitdigital.pt\";}");
INSERT INTO `wp_postmeta` VALUES("24", "5", "_notice_subject", "New form submission");
INSERT INTO `wp_postmeta` VALUES("25", "5", "_notice_body", "[form_title]\r\n\r\n[form_body]");
INSERT INTO `wp_postmeta` VALUES("26", "5", "_reply_name", "Mid Template");
INSERT INTO `wp_postmeta` VALUES("27", "5", "_reply_email", "it@makeitdigital.pt");
INSERT INTO `wp_postmeta` VALUES("28", "5", "_reply_subject", "Just Confirming");
INSERT INTO `wp_postmeta` VALUES("29", "5", "_reply_body", "This is just a confirmation message. We have received you reply.");
INSERT INTO `wp_postmeta` VALUES("30", "5", "_form_layout", "vertical");
INSERT INTO `wp_postmeta` VALUES("31", "5", "_input_icon_position", "right");
INSERT INTO `wp_postmeta` VALUES("32", "5", "_dhvc_form_messages", "a:30:{s:7:\"success\";s:40:\"Obrigado pela sua mensagem. Foi enviada.\";s:23:\"upload_failed_php_error\";s:37:\"Houve um erro ao carregar o ficheiro.\";s:17:\"invalid_recaptcha\";s:30:\"Não condiz. Por favor repita.\";s:19:\"recaptcha_not_check\";s:42:\"Por favor, verifique que não é um robô.\";s:17:\"captcha_not_match\";s:39:\"O que foi introduzido está incorrecto.\";s:16:\"validation_error\";s:71:\"Um ou mais campos têm um erro. Por favor, verifique e tente novamente.\";s:4:\"spam\";s:85:\"Houve um erro ao tentar enviar a sua mensagem. Por favor, tente novamente mais tarde.\";s:5:\"error\";s:85:\"Houve um erro ao tentar enviar a sua mensagem. Por favor, tente novamente mais tarde.\";s:16:\"invalid_required\";s:27:\"Este campo é obrigatório.\";s:13:\"invalid_email\";s:65:\"Por favor introduza um endereço de correio electrónico válido.\";s:11:\"invalid_url\";s:76:\"Please enter a valid URL. Protocol is required (http://, https:// or ftp://)\";s:12:\"invalid_date\";s:26:\"Please enter a valid date.\";s:12:\"invalid_time\";s:26:\"Please enter a valid time.\";s:14:\"invalid_number\";s:28:\"Please enter a valid number.\";s:15:\"invalid_number2\";s:67:\"Please use only numbers (0-9) or brackets (), dashes – and plus +\";s:14:\"invalid_digits\";s:25:\"Please enter only digits.\";s:11:\"invalid_max\";s:46:\"Please enter a value less than or equal to %s.\";s:11:\"invalid_min\";s:49:\"Please enter a value greater than or equal to %s.\";s:16:\"invalid_too_long\";s:23:\"This input is too long.\";s:17:\"invalid_too_short\";s:24:\"This input is too short.\";s:13:\"invalid_alpha\";s:51:\"Please use letters only (a-z or A-Z) in this field.\";s:16:\"invalid_alphanum\";s:116:\"Please use only letters (a-z or A-Z) or numbers (0-9) only in this field. No spaces or other characters are allowed.\";s:11:\"invalid_zip\";s:63:\"Please enter a valid zip code. For example 90602 or 90602-1234.\";s:11:\"invalid_fax\";s:76:\"Please enter a valid fax number. For example (123) 456-7890 or 123-456-7890.\";s:17:\"invalid_cpassword\";s:38:\"Please make sure your passwords match.\";s:14:\"invalid_cemail\";s:34:\"Please make sure your email match.\";s:14:\"invalid_select\";s:23:\"Please select an option\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:21:\"upload_file_too_large\";s:20:\"The file is too big.\";}");
INSERT INTO `wp_postmeta` VALUES("33", "5", "_paypal_currency", "USD");
INSERT INTO `wp_postmeta` VALUES("34", "5", "_paypal_currency_position", "left");
INSERT INTO `wp_postmeta` VALUES("35", "5", "_us_jsoncss_data", "a:2:{i:0;s:57:\".vc_custom_1758028114321{margin-bottom: 20px !important;}\";i:1;s:57:\".vc_custom_1758028132742{margin-bottom: 20px !important;}\";}");
INSERT INTO `wp_postmeta` VALUES("37", "5", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("38", "5", "_wpb_shortcodes_custom_css", ".vc_custom_1758028114321{margin-bottom: 20px !important;}.vc_custom_1758028132742{margin-bottom: 20px !important;}");
INSERT INTO `wp_postmeta` VALUES("39", "5", "_edit_lock", "1758034660:1");
INSERT INTO `wp_postmeta` VALUES("40", "2", "_edit_lock", "1759409639:1");
INSERT INTO `wp_postmeta` VALUES("41", "2", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("45", "2", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("46", "2", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("47", "2", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("48", "2", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("67", "7", "_us_in_content_ids", "");
INSERT INTO `wp_postmeta` VALUES("68", "7", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("69", "7", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("70", "7", "_form_control", "a:5:{s:4:\"name\";a:5:{s:8:\"required\";s:1:\"1\";s:13:\"control_label\";s:4:\"Name\";s:12:\"control_name\";s:4:\"name\";s:9:\"input_css\";s:57:\".vc_custom_1676331511714{margin-bottom: 10px !important;}\";s:3:\"tag\";s:14:\"dhvc_form_text\";}s:5:\"email\";a:5:{s:8:\"required\";s:1:\"1\";s:13:\"control_label\";s:5:\"Email\";s:12:\"control_name\";s:5:\"email\";s:9:\"input_css\";s:57:\".vc_custom_1676159579023{margin-bottom: 10px !important;}\";s:3:\"tag\";s:15:\"dhvc_form_email\";}s:5:\"phone\";a:5:{s:8:\"required\";s:1:\"1\";s:13:\"control_label\";s:5:\"Phone\";s:12:\"control_name\";s:5:\"phone\";s:9:\"input_css\";s:57:\".vc_custom_1676331520066{margin-bottom: 10px !important;}\";s:3:\"tag\";s:14:\"dhvc_form_text\";}s:7:\"message\";a:5:{s:8:\"required\";s:1:\"1\";s:13:\"control_label\";s:7:\"Message\";s:12:\"control_name\";s:7:\"message\";s:9:\"input_css\";s:57:\".vc_custom_1676331529269{margin-bottom: 20px !important;}\";s:3:\"tag\";s:18:\"dhvc_form_textarea\";}s:5:\"optin\";a:5:{s:8:\"required\";s:1:\"1\";s:12:\"control_name\";s:5:\"optin\";s:7:\"options\";s:320:\"W3siaXNfZGVmYXVsdCI6MCwibGFiZWwiOiI8c3BhbiBzdHlsZT1cImZvbnQtc2l6ZTowLjdyZW0gIWltcG9ydGFudDtcIj5Fc3RvdSBkZSBhY29yZG8gY29tIGEgPGEgaHJlZj1cIi9wb2xpdGljYS1wcml2YWNpZGFkZS9cIiB0YXJnZXQ9XCJfYmxhbmtcIiByZWw9XCJub29wZW5lclwiPlBvbMOtdGljYSBkZSBQcml2YWNpZGFkZTwvYT4gcXVlIGxpIGUgY29tcHJlZW5kaS48L3NwYW4+IiwidmFsdWUiOiJvcHRpbiJ9XQ==\";s:9:\"input_css\";s:57:\".vc_custom_1676330982083{margin-bottom: 20px !important;}\";s:3:\"tag\";s:18:\"dhvc_form_checkbox\";}}");
INSERT INTO `wp_postmeta` VALUES("71", "7", "_save_data", "1");
INSERT INTO `wp_postmeta` VALUES("72", "7", "_action_type", "default");
INSERT INTO `wp_postmeta` VALUES("73", "7", "_method", "post");
INSERT INTO `wp_postmeta` VALUES("74", "7", "_on_success", "message");
INSERT INTO `wp_postmeta` VALUES("75", "7", "_message", "Your message has been sent. Thanks!");
INSERT INTO `wp_postmeta` VALUES("76", "7", "_message_position", "bottom");
INSERT INTO `wp_postmeta` VALUES("77", "7", "_redirect_to", "to_page");
INSERT INTO `wp_postmeta` VALUES("78", "7", "_post", "1");
INSERT INTO `wp_postmeta` VALUES("79", "7", "_form_popup_width", "600");
INSERT INTO `wp_postmeta` VALUES("80", "7", "_form_popup_auto_open_delay", "2000");
INSERT INTO `wp_postmeta` VALUES("81", "7", "_form_popup_auto_close_delay", "10000");
INSERT INTO `wp_postmeta` VALUES("82", "7", "_notice", "1");
INSERT INTO `wp_postmeta` VALUES("83", "7", "_notice_name", "Mid Template");
INSERT INTO `wp_postmeta` VALUES("84", "7", "_notice_email_type", "email_text");
INSERT INTO `wp_postmeta` VALUES("85", "7", "_notice_email", "it@makeitdigital.pt");
INSERT INTO `wp_postmeta` VALUES("86", "7", "_notice_recipients", "a:1:{i:0;s:19:\"it@makeitdigital.pt\";}");
INSERT INTO `wp_postmeta` VALUES("87", "7", "_notice_subject", "New form submission");
INSERT INTO `wp_postmeta` VALUES("88", "7", "_notice_body", "[form_title]\r\n\r\n[form_body]");
INSERT INTO `wp_postmeta` VALUES("89", "7", "_reply_name", "Mid Template");
INSERT INTO `wp_postmeta` VALUES("90", "7", "_reply_email", "it@makeitdigital.pt");
INSERT INTO `wp_postmeta` VALUES("91", "7", "_reply_subject", "Just Confirming");
INSERT INTO `wp_postmeta` VALUES("92", "7", "_reply_body", "This is just a confirmation message. We have received you reply.");
INSERT INTO `wp_postmeta` VALUES("93", "7", "_form_layout", "vertical");
INSERT INTO `wp_postmeta` VALUES("94", "7", "_input_icon_position", "right");
INSERT INTO `wp_postmeta` VALUES("95", "7", "_dhvc_form_messages", "a:30:{s:7:\"success\";s:45:\"Thank you for your message. It has been sent.\";s:23:\"upload_failed_php_error\";s:38:\"There was an error uploading the file.\";s:17:\"invalid_recaptcha\";s:17:\"reCaptcha Invalid\";s:19:\"recaptcha_not_check\";s:39:\"Please verify that you are not a robot.\";s:17:\"captcha_not_match\";s:31:\"Your entered code is incorrect.\";s:16:\"validation_error\";s:61:\"One or more fields have an error. Please check and try again.\";s:4:\"spam\";s:71:\"There was an error trying to send your message. Please try again later.\";s:5:\"error\";s:71:\"There was an error trying to send your message. Please try again later.\";s:16:\"invalid_required\";s:23:\"This field is required.\";s:13:\"invalid_email\";s:35:\"Please enter a valid email address.\";s:11:\"invalid_url\";s:76:\"Please enter a valid URL. Protocol is required (http://, https:// or ftp://)\";s:12:\"invalid_date\";s:26:\"Please enter a valid date.\";s:12:\"invalid_time\";s:26:\"Please enter a valid time.\";s:14:\"invalid_number\";s:28:\"Please enter a valid number.\";s:15:\"invalid_number2\";s:67:\"Please use only numbers (0-9) or brackets (), dashes – and plus +\";s:14:\"invalid_digits\";s:25:\"Please enter only digits.\";s:11:\"invalid_max\";s:46:\"Please enter a value less than or equal to %s.\";s:11:\"invalid_min\";s:49:\"Please enter a value greater than or equal to %s.\";s:16:\"invalid_too_long\";s:23:\"This input is too long.\";s:17:\"invalid_too_short\";s:24:\"This input is too short.\";s:13:\"invalid_alpha\";s:51:\"Please use letters only (a-z or A-Z) in this field.\";s:16:\"invalid_alphanum\";s:116:\"Please use only letters (a-z or A-Z) or numbers (0-9) only in this field. No spaces or other characters are allowed.\";s:11:\"invalid_zip\";s:63:\"Please enter a valid zip code. For example 90602 or 90602-1234.\";s:11:\"invalid_fax\";s:76:\"Please enter a valid fax number. For example (123) 456-7890 or 123-456-7890.\";s:17:\"invalid_cpassword\";s:38:\"Please make sure your passwords match.\";s:14:\"invalid_cemail\";s:34:\"Please make sure your email match.\";s:14:\"invalid_select\";s:23:\"Please select an option\";s:24:\"upload_file_type_invalid\";s:49:\"You are not allowed to upload files of this type.\";s:13:\"upload_failed\";s:46:\"There was an unknown error uploading the file.\";s:21:\"upload_file_too_large\";s:20:\"The file is too big.\";}");
INSERT INTO `wp_postmeta` VALUES("96", "7", "_paypal_currency", "USD");
INSERT INTO `wp_postmeta` VALUES("97", "7", "_paypal_currency_position", "left");
INSERT INTO `wp_postmeta` VALUES("98", "7", "_us_jsoncss_data", "a:5:{i:0;s:57:\".vc_custom_1676331511714{margin-bottom: 10px !important;}\";i:1;s:57:\".vc_custom_1676159579023{margin-bottom: 10px !important;}\";i:2;s:57:\".vc_custom_1676331520066{margin-bottom: 10px !important;}\";i:3;s:57:\".vc_custom_1676331529269{margin-bottom: 20px !important;}\";i:4;s:57:\".vc_custom_1676330982083{margin-bottom: 20px !important;}\";}");
INSERT INTO `wp_postmeta` VALUES("99", "7", "us_og_image", "");
INSERT INTO `wp_postmeta` VALUES("100", "7", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("101", "7", "_wpb_shortcodes_custom_css", ".vc_custom_1676331511714{margin-bottom: 10px !important;}.vc_custom_1676159579023{margin-bottom: 10px !important;}.vc_custom_1676331520066{margin-bottom: 10px !important;}.vc_custom_1676331529269{margin-bottom: 20px !important;}.vc_custom_1676330982083{margin-bottom: 20px !important;}");
INSERT INTO `wp_postmeta` VALUES("102", "7", "_edit_lock", "1676331418:1");
INSERT INTO `wp_postmeta` VALUES("103", "8", "_us_in_content_ids", "");
INSERT INTO `wp_postmeta` VALUES("104", "8", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("105", "8", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("106", "8", "_edit_lock", "1676331576:1");
INSERT INTO `wp_postmeta` VALUES("107", "8", "accessibility_options", "a:3:{i:0;s:6:\"public\";i:1;s:18:\"publicly_queryable\";i:2;s:7:\"show_ui\";}");
INSERT INTO `wp_postmeta` VALUES("108", "8", "_accessibility_options", "field_5a739f02d85ab");
INSERT INTO `wp_postmeta` VALUES("109", "8", "capability_type", "page");
INSERT INTO `wp_postmeta` VALUES("110", "8", "_capability_type", "field_5a73a52c83ed7");
INSERT INTO `wp_postmeta` VALUES("111", "8", "menu_visibility", "a:3:{i:0;s:12:\"show_in_menu\";i:1;s:17:\"show_in_nav_menus\";i:2;s:17:\"show_in_admin_bar\";}");
INSERT INTO `wp_postmeta` VALUES("112", "8", "_menu_visibility", "field_5a739b5e2a576");
INSERT INTO `wp_postmeta` VALUES("113", "8", "menu_position", "5");
INSERT INTO `wp_postmeta` VALUES("114", "8", "_menu_position", "field_5a739ff5d85ac");
INSERT INTO `wp_postmeta` VALUES("115", "8", "menu_icon", "dashicons-slides");
INSERT INTO `wp_postmeta` VALUES("116", "8", "_menu_icon", "field_5a73a04ad85ad");
INSERT INTO `wp_postmeta` VALUES("117", "8", "has_archive", "no");
INSERT INTO `wp_postmeta` VALUES("118", "8", "_has_archive", "field_5a73a6ce83eda");
INSERT INTO `wp_postmeta` VALUES("119", "8", "rewrite", "yes");
INSERT INTO `wp_postmeta` VALUES("120", "8", "_rewrite", "field_5a73a78083edb");
INSERT INTO `wp_postmeta` VALUES("121", "8", "query_var", "");
INSERT INTO `wp_postmeta` VALUES("122", "8", "_query_var", "field_5a73a84a83ede");
INSERT INTO `wp_postmeta` VALUES("123", "8", "show_in_rest", "1");
INSERT INTO `wp_postmeta` VALUES("124", "8", "_show_in_rest", "field_5a7af6fb4b0d3");
INSERT INTO `wp_postmeta` VALUES("125", "8", "rest_base", "");
INSERT INTO `wp_postmeta` VALUES("126", "8", "_rest_base", "field_5a7af70734255");
INSERT INTO `wp_postmeta` VALUES("127", "8", "rest_controller_class", "");
INSERT INTO `wp_postmeta` VALUES("128", "8", "_rest_controller_class", "field_5a7af70fa8cd3");
INSERT INTO `wp_postmeta` VALUES("129", "8", "post_type", "slide_home");
INSERT INTO `wp_postmeta` VALUES("130", "8", "_post_type", "field_5a7399af2a574");
INSERT INTO `wp_postmeta` VALUES("131", "8", "supported_features", "a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";}");
INSERT INTO `wp_postmeta` VALUES("132", "8", "_supported_features", "field_5a73a58383ed8");
INSERT INTO `wp_postmeta` VALUES("133", "8", "other_options", "a:1:{i:0;s:10:\"can_export\";}");
INSERT INTO `wp_postmeta` VALUES("134", "8", "_other_options", "field_5a73add4ad095");
INSERT INTO `wp_postmeta` VALUES("135", "8", "taxonomies", "");
INSERT INTO `wp_postmeta` VALUES("136", "8", "_taxonomies", "field_5a76eec02594a");
INSERT INTO `wp_postmeta` VALUES("137", "8", "description", "");
INSERT INTO `wp_postmeta` VALUES("138", "8", "_description", "field_5a77850527d7d");
INSERT INTO `wp_postmeta` VALUES("139", "8", "singular_name", "Slide");
INSERT INTO `wp_postmeta` VALUES("140", "8", "_singular_name", "field_5a7399602a573");
INSERT INTO `wp_postmeta` VALUES("141", "8", "menu_name", "");
INSERT INTO `wp_postmeta` VALUES("142", "8", "_menu_name", "field_5a75e9825029c");
INSERT INTO `wp_postmeta` VALUES("143", "8", "admin_bar_name", "");
INSERT INTO `wp_postmeta` VALUES("144", "8", "_admin_bar_name", "field_5a75e9b35029d");
INSERT INTO `wp_postmeta` VALUES("145", "8", "archives", "");
INSERT INTO `wp_postmeta` VALUES("146", "8", "_archives", "field_5a75e9bd5029e");
INSERT INTO `wp_postmeta` VALUES("147", "8", "attributes", "");
INSERT INTO `wp_postmeta` VALUES("148", "8", "_attributes", "field_5a75e9cc5029f");
INSERT INTO `wp_postmeta` VALUES("149", "8", "parent_item_colon", "");
INSERT INTO `wp_postmeta` VALUES("150", "8", "_parent_item_colon", "field_5a75e9d6502a0");
INSERT INTO `wp_postmeta` VALUES("151", "8", "all_items", "Slides");
INSERT INTO `wp_postmeta` VALUES("152", "8", "_all_items", "field_5a75e9df502a1");
INSERT INTO `wp_postmeta` VALUES("153", "8", "add_new_item", "");
INSERT INTO `wp_postmeta` VALUES("154", "8", "_add_new_item", "field_5a75e9e8502a2");
INSERT INTO `wp_postmeta` VALUES("155", "8", "add_new", "");
INSERT INTO `wp_postmeta` VALUES("156", "8", "_add_new", "field_5a75e9f2502a3");
INSERT INTO `wp_postmeta` VALUES("157", "8", "new_item", "");
INSERT INTO `wp_postmeta` VALUES("158", "8", "_new_item", "field_5a75e9fa502a4");
INSERT INTO `wp_postmeta` VALUES("159", "8", "edit_item", "");
INSERT INTO `wp_postmeta` VALUES("160", "8", "_edit_item", "field_5a75ea02502a5");
INSERT INTO `wp_postmeta` VALUES("161", "8", "update_item", "");
INSERT INTO `wp_postmeta` VALUES("162", "8", "_update_item", "field_5a75ea0a502a6");
INSERT INTO `wp_postmeta` VALUES("163", "8", "view_item", "");
INSERT INTO `wp_postmeta` VALUES("164", "8", "_view_item", "field_5a75ea1c502a7");
INSERT INTO `wp_postmeta` VALUES("165", "8", "view_items", "");
INSERT INTO `wp_postmeta` VALUES("166", "8", "_view_items", "field_5a75ea24502a8");
INSERT INTO `wp_postmeta` VALUES("167", "8", "search_items", "");
INSERT INTO `wp_postmeta` VALUES("168", "8", "_search_items", "field_5a75ea2c502a9");
INSERT INTO `wp_postmeta` VALUES("169", "8", "not_found", "");
INSERT INTO `wp_postmeta` VALUES("170", "8", "_not_found", "field_5a75ea35502aa");
INSERT INTO `wp_postmeta` VALUES("171", "8", "not_found_in_trash", "");
INSERT INTO `wp_postmeta` VALUES("172", "8", "_not_found_in_trash", "field_5a75ea3e502ab");
INSERT INTO `wp_postmeta` VALUES("173", "8", "featured_image", "");
INSERT INTO `wp_postmeta` VALUES("174", "8", "_featured_image", "field_5a75ea47502ac");
INSERT INTO `wp_postmeta` VALUES("175", "8", "set_featured_image", "");
INSERT INTO `wp_postmeta` VALUES("176", "8", "_set_featured_image", "field_5a75ea51502ad");
INSERT INTO `wp_postmeta` VALUES("177", "8", "remove_featured_image", "");
INSERT INTO `wp_postmeta` VALUES("178", "8", "_remove_featured_image", "field_5a75ea59502ae");
INSERT INTO `wp_postmeta` VALUES("179", "8", "use_featured_image", "");
INSERT INTO `wp_postmeta` VALUES("180", "8", "_use_featured_image", "field_5a75ea60502af");
INSERT INTO `wp_postmeta` VALUES("181", "8", "insert_into_item", "");
INSERT INTO `wp_postmeta` VALUES("182", "8", "_insert_into_item", "field_5a75ea6b502b0");
INSERT INTO `wp_postmeta` VALUES("183", "8", "uploaded_to_this_item", "");
INSERT INTO `wp_postmeta` VALUES("184", "8", "_uploaded_to_this_item", "field_5a75ea74502b1");
INSERT INTO `wp_postmeta` VALUES("185", "8", "items_list", "");
INSERT INTO `wp_postmeta` VALUES("186", "8", "_items_list", "field_5a75ea7c502b2");
INSERT INTO `wp_postmeta` VALUES("187", "8", "items_list_navigation", "");
INSERT INTO `wp_postmeta` VALUES("188", "8", "_items_list_navigation", "field_5a75ea83502b3");
INSERT INTO `wp_postmeta` VALUES("189", "8", "filter_items_list", "");
INSERT INTO `wp_postmeta` VALUES("190", "8", "_filter_items_list", "field_5a75ea8c502b4");
INSERT INTO `wp_postmeta` VALUES("191", "9", "_us_in_content_ids", "");
INSERT INTO `wp_postmeta` VALUES("192", "9", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("193", "9", "_edit_lock", "1676331654:1");
INSERT INTO `wp_postmeta` VALUES("194", "9", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("195", "9", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("196", "9", "_us_jsoncss_data", NULL);
INSERT INTO `wp_postmeta` VALUES("197", "9", "us_og_image", "");
INSERT INTO `wp_postmeta` VALUES("200", "10", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("201", "10", "_edit_lock", "1758039016:1");
INSERT INTO `wp_postmeta` VALUES("202", "10", "_us_jsoncss_data", "a:2:{i:0;s:242:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_chrome_toolbar%22%2C%22background-image%22%3A%22161%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22margin-bottom%22%3A%223rem%22%7D%7D\";i:1;s:123:\"%7B%22default%22%3A%7B%22color%22%3A%22_principal%22%2C%22font-size%22%3A%221.9rem%22%2C%22font-weight%22%3A%22400%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("204", "10", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("205", "10", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("206", "10", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("208", "10", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("210", "12", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("211", "12", "_edit_lock", "1760375556:1");
INSERT INTO `wp_postmeta` VALUES("212", "12", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("213", "12", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("216", "13", "_us_in_content_ids", "");
INSERT INTO `wp_postmeta` VALUES("217", "13", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("218", "13", "_edit_lock", "1746645300:1");
INSERT INTO `wp_postmeta` VALUES("219", "13", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("220", "13", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("221", "13", "_us_jsoncss_data", NULL);
INSERT INTO `wp_postmeta` VALUES("222", "13", "us_og_image", "");
INSERT INTO `wp_postmeta` VALUES("223", "2", "_us_first_grid_post_type", "a:1:{i:0;s:4:\"post\";}");
INSERT INTO `wp_postmeta` VALUES("228", "15", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("229", "15", "_edit_lock", "1760375155:1");
INSERT INTO `wp_postmeta` VALUES("230", "15", "_us_jsoncss_data", "a:19:{i:0;s:572:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22background-image%22%3A%2291%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%222rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%222rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%222rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%221rem%22%7D%7D\";i:1;s:203:\"%7B%22default%22%3A%7B%22width%22%3A%22156px%22%7D%2C%22laptops%22%3A%7B%22width%22%3A%22156px%22%7D%2C%22tablets%22%3A%7B%22width%22%3A%22156px%22%7D%2C%22mobiles%22%3A%7B%22width%22%3A%22106px%22%7D%7D\";i:2;s:130:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%2C%22margin-top%22%3A%222rem%22%7D%7D\";i:3;s:196:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.2%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:4;s:63:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\";i:5;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\";i:6;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\";i:7;s:63:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\";i:8;s:195:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\";i:9;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\";i:10;s:63:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\";i:11;s:195:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\";i:12;s:468:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%22.8rem%22%2C%22line-height%22%3A%221.2%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%22.3rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:13;s:53:\"%7B%22default%22%3A%7B%22width%22%3A%22166px%22%7D%7D\";i:14;s:52:\"%7B%22default%22%3A%7B%22width%22%3A%2265px%22%7D%7D\";i:15;s:225:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:16;s:198:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\";i:17;s:231:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.55rem%22%2C%22line-height%22%3A%221%22%2C%22letter-spacing%22%3A%221px%22%2C%22margin-top%22%3A%22.6rem%22%7D%7D\";i:18;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("231", "15", "us_og_image", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/09/MID_XPharma_logo.png");
INSERT INTO `wp_postmeta` VALUES("232", "15", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("233", "15", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("234", "15", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("236", "15", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("237", "3", "_edit_lock", "1760375364:1");
INSERT INTO `wp_postmeta` VALUES("238", "3", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("242", "3", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("243", "3", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("244", "3", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("245", "3", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("267", "18", "_us_jsoncss_data", NULL);
INSERT INTO `wp_postmeta` VALUES("268", "18", "_us_in_content_ids", "");
INSERT INTO `wp_postmeta` VALUES("269", "18", "us_og_image", "");
INSERT INTO `wp_postmeta` VALUES("270", "18", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("271", "18", "_wpcode_auto_insert", "1");
INSERT INTO `wp_postmeta` VALUES("272", "18", "_wpcode_auto_insert_number", "1");
INSERT INTO `wp_postmeta` VALUES("273", "19", "_us_jsoncss_data", NULL);
INSERT INTO `wp_postmeta` VALUES("274", "19", "_us_in_content_ids", "");
INSERT INTO `wp_postmeta` VALUES("275", "19", "us_og_image", "");
INSERT INTO `wp_postmeta` VALUES("276", "19", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("277", "19", "_wpcode_auto_insert", "1");
INSERT INTO `wp_postmeta` VALUES("278", "19", "_wpcode_library_id", "12");
INSERT INTO `wp_postmeta` VALUES("279", "20", "_us_in_content_ids", "71");
INSERT INTO `wp_postmeta` VALUES("280", "20", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("281", "20", "_edit_lock", "1744308748:1");
INSERT INTO `wp_postmeta` VALUES("282", "21", "_us_in_content_ids", "13");
INSERT INTO `wp_postmeta` VALUES("283", "21", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("284", "21", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("285", "21", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("286", "21", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("287", "21", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("288", "21", "us_header_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("289", "21", "us_header_sticky_override", NULL);
INSERT INTO `wp_postmeta` VALUES("290", "21", "us_header_sticky", "");
INSERT INTO `wp_postmeta` VALUES("291", "21", "us_header_transparent_override", NULL);
INSERT INTO `wp_postmeta` VALUES("292", "21", "us_header_transparent", "");
INSERT INTO `wp_postmeta` VALUES("293", "21", "us_header_shadow", NULL);
INSERT INTO `wp_postmeta` VALUES("294", "21", "us_header_sticky_pos", "");
INSERT INTO `wp_postmeta` VALUES("295", "21", "us_titlebar_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("296", "21", "us_content_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("297", "21", "us_sidebar_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("298", "21", "us_sidebar_pos", "right");
INSERT INTO `wp_postmeta` VALUES("299", "21", "us_footer_id", "__defaults__");
INSERT INTO `wp_postmeta` VALUES("300", "21", "us_tile_additional_image", "");
INSERT INTO `wp_postmeta` VALUES("301", "21", "us_tile_link", "{\"url\":\"\",\"target\":\"\"}");
INSERT INTO `wp_postmeta` VALUES("302", "21", "us_tile_icon", "");
INSERT INTO `wp_postmeta` VALUES("303", "21", "us_tile_size", "1x1");
INSERT INTO `wp_postmeta` VALUES("304", "21", "us_tile_bg_color", "");
INSERT INTO `wp_postmeta` VALUES("305", "21", "us_tile_text_color", "");
INSERT INTO `wp_postmeta` VALUES("306", "21", "us_meta_title", "");
INSERT INTO `wp_postmeta` VALUES("307", "21", "us_meta_description", "");
INSERT INTO `wp_postmeta` VALUES("308", "21", "us_meta_robots", "");
INSERT INTO `wp_postmeta` VALUES("309", "21", "_edit_lock", "1732640779:1");
INSERT INTO `wp_postmeta` VALUES("310", "20", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("311", "20", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("312", "20", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("316", "20", "_us_jsoncss_data", "a:10:{i:0;s:367:\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\";i:1;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:2;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:3;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:4;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:5;s:227:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\";i:6;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\";i:7;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\";i:8;s:164:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\";i:9;s:449:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("318", "20", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("319", "21", "_us_jsoncss_data", "a:1:{i:0;s:94:\"%7B%22default%22%3A%7B%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%225rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("320", "21", "us_og_image", "https://xpharma.digitalpath.pt/xpharma/wp-content/plugins/us-core/assets/images/placeholder.svg");
INSERT INTO `wp_postmeta` VALUES("321", "21", "_us_first_grid_post_type", "a:1:{i:0;s:4:\"post\";}");
INSERT INTO `wp_postmeta` VALUES("322", "31", "_wp_attached_file", "2023/02/logo.svg");
INSERT INTO `wp_postmeta` VALUES("323", "31", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:1273;}");
INSERT INTO `wp_postmeta` VALUES("324", "32", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("325", "32", "_wpb_vc_js_status", "false");
INSERT INTO `wp_postmeta` VALUES("326", "32", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("327", "33", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("328", "32", "_edit_lock", "1732216104:1");
INSERT INTO `wp_postmeta` VALUES("329", "34", "_wp_attached_file", "2023/02/logo-02.svg");
INSERT INTO `wp_postmeta` VALUES("330", "34", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:1273;}");
INSERT INTO `wp_postmeta` VALUES("331", "15", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("332", "35", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("333", "36", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("334", "36", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("335", "36", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("336", "37", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("337", "36", "_edit_lock", "1757946517:1");
INSERT INTO `wp_postmeta` VALUES("338", "38", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("339", "38", "_edit_lock", "1732217207:1");
INSERT INTO `wp_postmeta` VALUES("340", "39", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("341", "39", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("342", "39", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("343", "39", "_edit_lock", "1760373106:1");
INSERT INTO `wp_postmeta` VALUES("344", "40", "_wp_attached_file", "2024/11/DoorWin_img-1b.jpg");
INSERT INTO `wp_postmeta` VALUES("345", "40", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1750;s:6:\"height\";i:1016;s:4:\"file\";s:26:\"2024/11/DoorWin_img-1b.jpg\";s:8:\"filesize\";i:309545;s:5:\"sizes\";a:6:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:26:\"DoorWin_img-1b-300x300.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18356;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:26:\"DoorWin_img-1b-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6605;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:26:\"DoorWin_img-1b-600x348.jpg\";s:5:\"width\";i:600;s:6:\"height\";i:348;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36637;}s:6:\"medium\";a:5:{s:4:\"file\";s:26:\"DoorWin_img-1b-300x174.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:174;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14199;}s:5:\"large\";a:5:{s:4:\"file\";s:27:\"DoorWin_img-1b-1024x595.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:595;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:97787;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:26:\"DoorWin_img-1b-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7185;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("346", "39", "_us_jsoncss_data", "a:9:{i:0;s:193:\"%7B%22default%22%3A%7B%22background-image%22%3A%22496%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:1;s:219:\"%7B%22default%22%3A%7B%22min-height%22%3A%2280vh%22%7D%2C%22laptops%22%3A%7B%22min-height%22%3A%2280vh%22%7D%2C%22tablets%22%3A%7B%22min-height%22%3A%2280vh%22%7D%2C%22mobiles%22%3A%7B%22min-height%22%3A%2270vh%22%7D%7D\";i:2;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%2242vh%22%7D%7D\";i:3;s:257:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%223.4rem%22%2C%22line-height%22%3A%221%22%2C%22font-weight%22%3A%22200%22%2C%22animation-name%22%3A%22aft%22%2C%22animation-delay%22%3A%22250ms%22%7D%7D\";i:4;s:56:\"%7B%22default%22%3A%7B%22margin-top%22%3A%226vh%22%7D%7D\";i:5;s:193:\"%7B%22default%22%3A%7B%22background-image%22%3A%22104%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:6;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%2235vh%22%7D%7D\";i:7;s:152:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%223.2rem%22%2C%22line-height%22%3A%221.1%22%2C%22font-weight%22%3A%22200%22%7D%7D\";i:8;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("347", "36", "us_header_id", "12");
INSERT INTO `wp_postmeta` VALUES("348", "36", "us_header_transparent_override", "1");
INSERT INTO `wp_postmeta` VALUES("349", "36", "us_header_transparent", "default,laptops,tablets");
INSERT INTO `wp_postmeta` VALUES("350", "36", "_us_jsoncss_data", "a:3:{i:0;s:175:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\";i:1;s:175:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\";i:2;s:209:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("351", "36", "_us_in_content_ids", "9");
INSERT INTO `wp_postmeta` VALUES("352", "41", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("353", "42", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("354", "36", "us_titlebar_id", "0");
INSERT INTO `wp_postmeta` VALUES("355", "43", "_wp_attached_file", "woocommerce-placeholder.png");
INSERT INTO `wp_postmeta` VALUES("356", "43", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1200;s:6:\"height\";i:1200;s:4:\"file\";s:27:\"woocommerce-placeholder.png\";s:8:\"filesize\";i:48149;s:5:\"sizes\";a:6:{s:21:\"woocommerce_thumbnail\";a:6:{s:4:\"file\";s:35:\"woocommerce-placeholder-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12321;s:9:\"uncropped\";b:0;}s:29:\"woocommerce_gallery_thumbnail\";a:5:{s:4:\"file\";s:35:\"woocommerce-placeholder-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4209;}s:18:\"woocommerce_single\";a:5:{s:4:\"file\";s:35:\"woocommerce-placeholder-600x600.png\";s:5:\"width\";i:600;s:6:\"height\";i:600;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:38159;}s:6:\"medium\";a:5:{s:4:\"file\";s:35:\"woocommerce-placeholder-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10490;}s:5:\"large\";a:5:{s:4:\"file\";s:37:\"woocommerce-placeholder-1024x1024.png\";s:5:\"width\";i:1024;s:6:\"height\";i:1024;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:79721;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:35:\"woocommerce-placeholder-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3762;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("357", "50", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("358", "50", "_edit_lock", "1732297295:1");
INSERT INTO `wp_postmeta` VALUES("359", "51", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("360", "51", "_edit_lock", "1732297358:1");
INSERT INTO `wp_postmeta` VALUES("361", "53", "_edit_lock", "1746645363:1");
INSERT INTO `wp_postmeta` VALUES("362", "54", "_edit_lock", "1732299557:1");
INSERT INTO `wp_postmeta` VALUES("363", "55", "_edit_lock", "1732299903:1");
INSERT INTO `wp_postmeta` VALUES("364", "55", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("365", "55", "_us_jsoncss_data", "a:15:{i:0;s:92:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\";i:1;s:131:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_link%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.75rem%22%7D%7D\";i:2;s:207:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_link%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.75rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\";i:3;s:233:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_primary%22%2C%22font-size%22%3A%222.3rem%22%2C%22line-height%22%3A%222.5rem%22%2C%22font-weight%22%3A%22500%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:4;s:130:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.8rem%22%7D%7D\";i:5;s:161:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.8rem%22%2C%22margin-top%22%3A%226px%22%7D%7D\";i:6;s:312:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%220.3em%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222.5rem%22%2C%22margin-bottom%22%3A%221.5rem%22%7D%7D\";i:7;s:93:\"%7B%22default%22%3A%7B%22font-size%22%3A%220.9rem%22%2C%22line-height%22%3A%221.3rem%22%7D%7D\";i:8;s:205:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%2C%22padding-top%22%3A%221.2rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%221px%22%2C%22border-color%22%3A%22%23d4d4d4%22%7D%7D\";i:9;s:242:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.85rem%22%2C%22letter-spacing%22%3A%220.16em%22%2C%22font-weight%22%3A%22400%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\";i:10;s:163:\"%7B%22default%22%3A%7B%22color%22%3A%22%23757575%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.85rem%22%2C%22letter-spacing%22%3A%220.2em%22%7D%7D\";i:11;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%226rem%22%7D%7D\";i:12;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22100px%22%7D%7D\";i:13;s:242:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.1rem%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\";i:14;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%223rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("366", "55", "_us_in_content_ids", "189");
INSERT INTO `wp_postmeta` VALUES("367", "55", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("368", "55", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("369", "57", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("370", "58", "_edit_lock", "1737465946:1");
INSERT INTO `wp_postmeta` VALUES("371", "58", "_us_jsoncss_data", "a:2:{i:0;s:94:\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%225rem%22%7D%7D\";i:1;s:810:\"%7B%22default%22%3A%7B%22font-size%22%3A%220.8rem%22%2C%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%220.5rem%22%2C%22padding-bottom%22%3A%220.5rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%221px%22%2C%22border-bottom-width%22%3A%221px%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("372", "58", "_us_in_content_ids", "61");
INSERT INTO `wp_postmeta` VALUES("373", "61", "_edit_lock", "1732299891:1");
INSERT INTO `wp_postmeta` VALUES("374", "62", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("375", "62", "_edit_lock", "1732299827:1");
INSERT INTO `wp_postmeta` VALUES("376", "62", "_awl_label_priority", "0");
INSERT INTO `wp_postmeta` VALUES("377", "62", "_awl_label", "a:4:{s:16:\"awl_label_status\";a:1:{s:6:\"status\";s:1:\"1\";}s:18:\"awl_label_priority\";a:1:{s:8:\"priority\";s:1:\"0\";}s:10:\"conditions\";a:1:{s:7:\"group_1\";a:1:{s:6:\"rule_1\";a:4:{s:5:\"param\";s:13:\"sale_discount\";s:9:\"suboption\";s:8:\"percents\";s:8:\"operator\";s:7:\"greater\";s:5:\"value\";s:1:\"1\";}}}s:8:\"settings\";a:16:{s:4:\"text\";s:15:\"{SAVE_PERCENT}%\";s:8:\"template\";s:8:\"standard\";s:13:\"position_type\";s:8:\"on_image\";s:8:\"position\";s:8:\"left_top\";s:10:\"position_x\";s:4:\"left\";s:13:\"custom_styles\";s:4:\"true\";s:8:\"bg_color\";s:7:\"#3986c6\";s:10:\"text_color\";s:4:\"#fff\";s:9:\"font_size\";s:2:\"14\";s:10:\"font_style\";s:6:\"normal\";s:11:\"font_weight\";s:3:\"700\";s:14:\"letter_spacing\";s:1:\"0\";s:7:\"opacity\";s:1:\"1\";s:7:\"padding\";a:4:{s:3:\"top\";s:3:\"0.5\";s:5:\"right\";s:3:\"0.6\";s:6:\"bottom\";s:3:\"0.5\";s:4:\"left\";s:3:\"0.6\";}s:6:\"margin\";a:4:{s:3:\"top\";s:1:\"0\";s:5:\"right\";s:1:\"0\";s:6:\"bottom\";s:1:\"0\";s:4:\"left\";s:1:\"0\";}s:10:\"custom_css\";s:0:\"\";}}");
INSERT INTO `wp_postmeta` VALUES("378", "58", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("379", "58", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("380", "58", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("381", "63", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("382", "44", "_edit_lock", "1732640808:1");
INSERT INTO `wp_postmeta` VALUES("383", "64", "_edit_lock", "1732641903:1");
INSERT INTO `wp_postmeta` VALUES("384", "64", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("385", "64", "_us_jsoncss_data", "a:2:{i:0;s:94:\"%7B%22default%22%3A%7B%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%225rem%22%7D%7D\";i:1;s:810:\"%7B%22default%22%3A%7B%22font-size%22%3A%220.8rem%22%2C%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%220.5rem%22%2C%22padding-bottom%22%3A%220.5rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%221px%22%2C%22border-bottom-width%22%3A%221px%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("386", "64", "_us_in_content_ids", "61");
INSERT INTO `wp_postmeta` VALUES("387", "64", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("388", "64", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("389", "66", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("390", "67", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("391", "68", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("392", "69", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("393", "20", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("394", "70", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("395", "71", "_edit_lock", "1746645326:1");
INSERT INTO `wp_postmeta` VALUES("396", "72", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("398", "90", "_wp_attached_file", "2025/09/MID_XPharma_favicon.png");
INSERT INTO `wp_postmeta` VALUES("399", "90", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"file\";s:31:\"2025/09/MID_XPharma_favicon.png\";s:8:\"filesize\";i:15883;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_favicon-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:13712;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_favicon-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:6152;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("400", "91", "_wp_attached_file", "2025/09/MID_XPharma_img-10.jpg");
INSERT INTO `wp_postmeta` VALUES("401", "91", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:617;s:6:\"height\";i:514;s:4:\"file\";s:30:\"2025/09/MID_XPharma_img-10.jpg\";s:8:\"filesize\";i:16302;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-10-300x250.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:250;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2662;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-10-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1491;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("402", "92", "_wp_attached_file", "2025/09/MID_XPharma_img-9.jpg");
INSERT INTO `wp_postmeta` VALUES("403", "92", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:854;s:6:\"height\";i:953;s:4:\"file\";s:29:\"2025/09/MID_XPharma_img-9.jpg\";s:8:\"filesize\";i:31188;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-9-269x300.jpg\";s:5:\"width\";i:269;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2682;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-9-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1439;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("404", "93", "_wp_attached_file", "2025/09/MID_XPharma_img-8.jpg");
INSERT INTO `wp_postmeta` VALUES("405", "93", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1700;s:6:\"height\";i:1070;s:4:\"file\";s:29:\"2025/09/MID_XPharma_img-8.jpg\";s:8:\"filesize\";i:272288;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-8-300x189.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:189;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13855;}s:5:\"large\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-8-1024x645.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:645;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:80218;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-8-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6836;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("406", "94", "_wp_attached_file", "2025/09/MID_XPharma_img-7.jpg");
INSERT INTO `wp_postmeta` VALUES("407", "94", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1700;s:6:\"height\";i:895;s:4:\"file\";s:29:\"2025/09/MID_XPharma_img-7.jpg\";s:8:\"filesize\";i:125519;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-7-300x158.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:158;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7501;}s:5:\"large\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-7-1024x539.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:539;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:38096;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-7-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4373;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("408", "95", "_wp_attached_file", "2025/09/MID_XPharma_team-4.jpg");
INSERT INTO `wp_postmeta` VALUES("409", "95", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:483;s:6:\"height\";i:616;s:4:\"file\";s:30:\"2025/09/MID_XPharma_team-4.jpg\";s:8:\"filesize\";i:56289;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_team-4-235x300.jpg\";s:5:\"width\";i:235;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12789;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_team-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5480;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("410", "96", "_wp_attached_file", "2025/09/MID_XPharma_team-3.jpg");
INSERT INTO `wp_postmeta` VALUES("411", "96", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:483;s:6:\"height\";i:616;s:4:\"file\";s:30:\"2025/09/MID_XPharma_team-3.jpg\";s:8:\"filesize\";i:78489;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_team-3-235x300.jpg\";s:5:\"width\";i:235;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:18032;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_team-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6554;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("412", "97", "_wp_attached_file", "2025/09/MID_XPharma_team-2.jpg");
INSERT INTO `wp_postmeta` VALUES("413", "97", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:483;s:6:\"height\";i:616;s:4:\"file\";s:30:\"2025/09/MID_XPharma_team-2.jpg\";s:8:\"filesize\";i:51543;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_team-2-235x300.jpg\";s:5:\"width\";i:235;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11671;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_team-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5250;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("414", "98", "_wp_attached_file", "2025/09/MID_XPharma_team-1.jpg");
INSERT INTO `wp_postmeta` VALUES("415", "98", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:483;s:6:\"height\";i:616;s:4:\"file\";s:30:\"2025/09/MID_XPharma_team-1.jpg\";s:8:\"filesize\";i:72018;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_team-1-235x300.jpg\";s:5:\"width\";i:235;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:16341;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_team-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6290;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("416", "99", "_wp_attached_file", "2025/09/MID_XPharma_img-6.jpg");
INSERT INTO `wp_postmeta` VALUES("417", "99", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1573;s:6:\"height\";i:571;s:4:\"file\";s:29:\"2025/09/MID_XPharma_img-6.jpg\";s:8:\"filesize\";i:159274;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-6-300x109.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:109;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9858;}s:5:\"large\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-6-1024x372.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:372;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:55605;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6273;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("418", "100", "_wp_attached_file", "2025/09/MID_XPharma_img-5.jpg");
INSERT INTO `wp_postmeta` VALUES("419", "100", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:726;s:6:\"height\";i:786;s:4:\"file\";s:29:\"2025/09/MID_XPharma_img-5.jpg\";s:8:\"filesize\";i:88498;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-5-277x300.jpg\";s:5:\"width\";i:277;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15248;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-5-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6288;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("420", "101", "_wp_attached_file", "2025/09/MID_XPharma_img-4.jpg");
INSERT INTO `wp_postmeta` VALUES("421", "101", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:726;s:6:\"height\";i:786;s:4:\"file\";s:29:\"2025/09/MID_XPharma_img-4.jpg\";s:8:\"filesize\";i:94014;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-4-277x300.jpg\";s:5:\"width\";i:277;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14826;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6206;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("422", "102", "_wp_attached_file", "2025/09/MID_XPharma_img-3.jpg");
INSERT INTO `wp_postmeta` VALUES("423", "102", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:771;s:6:\"height\";i:857;s:4:\"file\";s:29:\"2025/09/MID_XPharma_img-3.jpg\";s:8:\"filesize\";i:21169;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-3-270x300.jpg\";s:5:\"width\";i:270;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3744;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1820;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("424", "103", "_wp_attached_file", "2025/09/MID_XPharma_img-2.jpg");
INSERT INTO `wp_postmeta` VALUES("425", "103", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1053;s:6:\"height\";i:726;s:4:\"file\";s:29:\"2025/09/MID_XPharma_img-2.jpg\";s:8:\"filesize\";i:110423;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-2-300x207.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:207;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12948;}s:5:\"large\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-2-1024x706.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:706;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68756;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6303;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("426", "104", "_wp_attached_file", "2025/09/MID_XPharma_img-1.jpg");
INSERT INTO `wp_postmeta` VALUES("427", "104", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1700;s:6:\"height\";i:931;s:4:\"file\";s:29:\"2025/09/MID_XPharma_img-1.jpg\";s:8:\"filesize\";i:176670;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-1-300x164.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9147;}s:5:\"large\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-1-1024x561.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:561;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:53611;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_img-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5445;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("428", "105", "_wp_attached_file", "2025/09/MID_XPharma_agua-3.png");
INSERT INTO `wp_postmeta` VALUES("429", "105", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:251;s:6:\"height\";i:155;s:4:\"file\";s:30:\"2025/09/MID_XPharma_agua-3.png\";s:8:\"filesize\";i:1177;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-3-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1269;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("430", "106", "_wp_attached_file", "2025/09/MID_XPharma_agua-2.png");
INSERT INTO `wp_postmeta` VALUES("431", "106", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:702;s:6:\"height\";i:241;s:4:\"file\";s:30:\"2025/09/MID_XPharma_agua-2.png\";s:8:\"filesize\";i:2248;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-2-300x103.png\";s:5:\"width\";i:300;s:6:\"height\";i:103;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1304;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:489;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("432", "107", "_wp_attached_file", "2025/09/MID_XPharma_agua-1.png");
INSERT INTO `wp_postmeta` VALUES("433", "107", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1672;s:6:\"height\";i:241;s:4:\"file\";s:30:\"2025/09/MID_XPharma_agua-1.png\";s:8:\"filesize\";i:3600;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_agua-1-300x43.png\";s:5:\"width\";i:300;s:6:\"height\";i:43;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:598;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_agua-1-1024x148.png\";s:5:\"width\";i:1024;s:6:\"height\";i:148;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2454;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:489;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("434", "108", "_wp_attached_file", "2025/09/MID_XPharma_ico_-01.svg");
INSERT INTO `wp_postmeta` VALUES("435", "108", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:2448;}");
INSERT INTO `wp_postmeta` VALUES("436", "109", "_wp_attached_file", "2025/09/MID_XPharma_ico_-02.svg");
INSERT INTO `wp_postmeta` VALUES("437", "109", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:2023;}");
INSERT INTO `wp_postmeta` VALUES("438", "110", "_wp_attached_file", "2025/09/MID_XPharma_ico_-03.svg");
INSERT INTO `wp_postmeta` VALUES("439", "110", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:1884;}");
INSERT INTO `wp_postmeta` VALUES("440", "111", "_wp_attached_file", "2025/09/MID_XPharma_ico_-04.svg");
INSERT INTO `wp_postmeta` VALUES("441", "111", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:1941;}");
INSERT INTO `wp_postmeta` VALUES("442", "112", "_wp_attached_file", "2025/09/MID_XPharma_ico_-05.svg");
INSERT INTO `wp_postmeta` VALUES("443", "112", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:8734;}");
INSERT INTO `wp_postmeta` VALUES("444", "113", "_wp_attached_file", "2025/09/MID_XPharma_ico_-06.svg");
INSERT INTO `wp_postmeta` VALUES("445", "113", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:6439;}");
INSERT INTO `wp_postmeta` VALUES("446", "114", "_wp_attached_file", "2025/09/MID_XPharma_ico_-07.svg");
INSERT INTO `wp_postmeta` VALUES("447", "114", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:3299;}");
INSERT INTO `wp_postmeta` VALUES("448", "115", "_wp_attached_file", "2025/09/MID_XPharma_ico_-08.svg");
INSERT INTO `wp_postmeta` VALUES("449", "115", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:2849;}");
INSERT INTO `wp_postmeta` VALUES("450", "116", "_wp_attached_file", "2025/09/MID_XPharma_ico_-09.svg");
INSERT INTO `wp_postmeta` VALUES("451", "116", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:3188;}");
INSERT INTO `wp_postmeta` VALUES("452", "117", "_wp_attached_file", "2025/09/MID_XPharma_ico_-10.svg");
INSERT INTO `wp_postmeta` VALUES("453", "117", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:2257;}");
INSERT INTO `wp_postmeta` VALUES("454", "118", "_wp_attached_file", "2025/09/MID_XPharma_ico_-11.svg");
INSERT INTO `wp_postmeta` VALUES("455", "118", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:1613;}");
INSERT INTO `wp_postmeta` VALUES("456", "119", "_wp_attached_file", "2025/09/MID_XPharma_ico_-12.svg");
INSERT INTO `wp_postmeta` VALUES("457", "119", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:2089;}");
INSERT INTO `wp_postmeta` VALUES("458", "120", "_wp_attached_file", "2025/09/MID_XPharma_ico_-13.svg");
INSERT INTO `wp_postmeta` VALUES("459", "120", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:2922;}");
INSERT INTO `wp_postmeta` VALUES("460", "121", "_wp_attached_file", "2025/09/MID_XPharma_ico_-14.svg");
INSERT INTO `wp_postmeta` VALUES("461", "121", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:1568;}");
INSERT INTO `wp_postmeta` VALUES("462", "122", "_wp_attached_file", "2025/09/MID_XPharma_ico_-15.svg");
INSERT INTO `wp_postmeta` VALUES("463", "122", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:3693;}");
INSERT INTO `wp_postmeta` VALUES("464", "123", "_wp_attached_file", "2025/09/MID_XPharma_ico_-16.svg");
INSERT INTO `wp_postmeta` VALUES("465", "123", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:387;}");
INSERT INTO `wp_postmeta` VALUES("466", "124", "_wp_attached_file", "2025/09/MID_XPharma_logo.png");
INSERT INTO `wp_postmeta` VALUES("467", "124", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:414;s:6:\"height\";i:401;s:4:\"file\";s:28:\"2025/09/MID_XPharma_logo.png\";s:8:\"filesize\";i:13597;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:28:\"MID_XPharma_logo-300x291.png\";s:5:\"width\";i:300;s:6:\"height\";i:291;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15334;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:28:\"MID_XPharma_logo-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7266;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("468", "39", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("469", "47", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("470", "47", "_wp_trash_meta_time", "1757946625");
INSERT INTO `wp_postmeta` VALUES("471", "47", "_wp_desired_post_slug", "minha-conta");
INSERT INTO `wp_postmeta` VALUES("472", "45", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("473", "45", "_wp_trash_meta_time", "1757946625");
INSERT INTO `wp_postmeta` VALUES("474", "45", "_wp_desired_post_slug", "carrinho");
INSERT INTO `wp_postmeta` VALUES("475", "46", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("476", "46", "_wp_trash_meta_time", "1757946625");
INSERT INTO `wp_postmeta` VALUES("477", "46", "_wp_desired_post_slug", "finalizar-compra");
INSERT INTO `wp_postmeta` VALUES("478", "44", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("479", "44", "_wp_trash_meta_time", "1757946625");
INSERT INTO `wp_postmeta` VALUES("480", "44", "_wp_desired_post_slug", "loja");
INSERT INTO `wp_postmeta` VALUES("481", "48", "_wp_trash_meta_status", "draft");
INSERT INTO `wp_postmeta` VALUES("482", "48", "_wp_trash_meta_time", "1757946625");
INSERT INTO `wp_postmeta` VALUES("483", "48", "_wp_desired_post_slug", "refund_returns");
INSERT INTO `wp_postmeta` VALUES("484", "130", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("485", "130", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("486", "130", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("487", "130", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("488", "131", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("489", "130", "_edit_lock", "1760518887:1");
INSERT INTO `wp_postmeta` VALUES("490", "130", "_us_in_content_ids", "9,346");
INSERT INTO `wp_postmeta` VALUES("491", "132", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("492", "130", "us_header_id", "12");
INSERT INTO `wp_postmeta` VALUES("493", "130", "us_header_transparent_override", "1");
INSERT INTO `wp_postmeta` VALUES("494", "130", "us_header_transparent", "default,laptops,tablets,mobiles");
INSERT INTO `wp_postmeta` VALUES("495", "130", "us_titlebar_id", "0");
INSERT INTO `wp_postmeta` VALUES("496", "133", "_wp_attached_file", "2025/09/MID_XPharma_agua-4.png");
INSERT INTO `wp_postmeta` VALUES("497", "133", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:702;s:6:\"height\";i:241;s:4:\"file\";s:30:\"2025/09/MID_XPharma_agua-4.png\";s:8:\"filesize\";i:2297;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-4-300x103.png\";s:5:\"width\";i:300;s:6:\"height\";i:103;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1187;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-4-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:488;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("498", "134", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("499", "134", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("500", "134", "_menu_item_object_id", "134");
INSERT INTO `wp_postmeta` VALUES("501", "134", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("502", "134", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("503", "134", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("504", "134", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("505", "134", "_menu_item_url", "/#sobre-nos");
INSERT INTO `wp_postmeta` VALUES("507", "135", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("508", "135", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("509", "135", "_menu_item_object_id", "135");
INSERT INTO `wp_postmeta` VALUES("510", "135", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("511", "135", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("512", "135", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("513", "135", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("514", "135", "_menu_item_url", "/#servicos");
INSERT INTO `wp_postmeta` VALUES("516", "136", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("517", "136", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("518", "136", "_menu_item_object_id", "136");
INSERT INTO `wp_postmeta` VALUES("519", "136", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("520", "136", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("521", "136", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("522", "136", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("523", "136", "_menu_item_url", "/#areas-atuacao");
INSERT INTO `wp_postmeta` VALUES("525", "137", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("526", "137", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("527", "137", "_menu_item_object_id", "137");
INSERT INTO `wp_postmeta` VALUES("528", "137", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("529", "137", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("530", "137", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("531", "137", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("532", "137", "_menu_item_url", "#contacto");
INSERT INTO `wp_postmeta` VALUES("534", "138", "_wp_attached_file", "2023/02/dekas_hr-1_negative.png");
INSERT INTO `wp_postmeta` VALUES("535", "138", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:171;s:4:\"file\";s:31:\"2023/02/dekas_hr-1_negative.png\";s:8:\"filesize\";i:20955;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"dekas_hr-1_negative-300x51.png\";s:5:\"width\";i:300;s:6:\"height\";i:51;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5597;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"dekas_hr-1_negative-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3139;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("536", "139", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("537", "139", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("538", "139", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("539", "139", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("540", "140", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("541", "139", "_edit_lock", "1760375604:1");
INSERT INTO `wp_postmeta` VALUES("542", "141", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("543", "141", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("544", "141", "_menu_item_object_id", "141");
INSERT INTO `wp_postmeta` VALUES("545", "141", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("546", "141", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("547", "141", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("548", "141", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("549", "141", "_menu_item_url", "#pll_switcher");
INSERT INTO `wp_postmeta` VALUES("551", "141", "_pll_menu_item", "a:6:{s:22:\"hide_if_no_translation\";i:0;s:12:\"hide_current\";i:0;s:10:\"force_home\";i:0;s:10:\"show_flags\";i:1;s:10:\"show_names\";i:0;s:8:\"dropdown\";i:0;}");
INSERT INTO `wp_postmeta` VALUES("552", "142", "_wp_attached_file", "2024/11/MID_XPharma_agua-5.png");
INSERT INTO `wp_postmeta` VALUES("553", "142", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1672;s:6:\"height\";i:241;s:4:\"file\";s:30:\"2024/11/MID_XPharma_agua-5.png\";s:8:\"filesize\";i:3603;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:29:\"MID_XPharma_agua-5-300x43.png\";s:5:\"width\";i:300;s:6:\"height\";i:43;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:550;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_agua-5-1024x148.png\";s:5:\"width\";i:1024;s:6:\"height\";i:148;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2249;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-5-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:488;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("554", "130", "_us_jsoncss_data", "a:128:{i:0;s:244:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23f0f0f0%22%2C%22background-image%22%3A%22339%22%2C%22background-position%22%3A%22right%20center%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\";i:1;s:227:\"%7B%22default%22%3A%7B%22margin-top%22%3A%223.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%223.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%223.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:2;s:161:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_top_text%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.5%22%2C%22font-weight%22%3A%22500%22%7D%7D\";i:3;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.8rem%22%7D%7D\";i:4;s:227:\"%7B%22default%22%3A%7B%22margin-top%22%3A%224.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%224.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%224.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%7D\";i:5;s:156:\"%7B%22default%22%3A%7B%22background-image%22%3A%22333%22%2C%22background-position%22%3A%22left%20bottom%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:6;s:59:\"%7B%22default%22%3A%7B%22padding-right%22%3A%228vw%22%7D%7D\";i:7;s:224:\"%7B%22default%22%3A%7B%22background-image%22%3A%22484%22%2C%22background-position%22%3A%22left%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22425px%22%7D%7D\";i:8;s:59:\"%7B%22default%22%3A%7B%22padding-left%22%3A%222rem%22%7D%7D\";i:9;s:219:\"%7B%22default%22%3A%7B%22margin-top%22%3A%223rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%223rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%223rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:10;s:135:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%221.5rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\";i:11;s:157:\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\";i:12;s:79:\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%7D\";i:13;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:14;s:219:\"%7B%22default%22%3A%7B%22margin-top%22%3A%226rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%226rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%226rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%223rem%22%7D%7D\";i:15;s:220:\"%7B%22default%22%3A%7B%22background-image%22%3A%22469%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22541px%22%7D%7D\";i:16;s:198:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22padding-left%22%3A%220px%22%2C%22padding-top%22%3A%220px%22%2C%22padding-bottom%22%3A%220px%22%2C%22padding-right%22%3A%220px%22%7D%7D\";i:17;s:138:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_principal%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\";i:18;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:19;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:20;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:21;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:22;s:133:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\";i:23;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:24;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:25;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:26;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:27;s:220:\"%7B%22default%22%3A%7B%22background-image%22%3A%22482%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22289px%22%7D%7D\";i:28;s:137:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23757575%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\";i:29;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:30;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:31;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:32;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:33;s:220:\"%7B%22default%22%3A%7B%22background-image%22%3A%22461%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22330px%22%7D%7D\";i:34;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%224rem%22%7D%7D\";i:35;s:134:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%22.8rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\";i:36;s:157:\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\";i:37;s:79:\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%7D\";i:38;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:39;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:40;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:41;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:42;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:43;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:44;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:45;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:46;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:47;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:48;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:49;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:50;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:51;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:52;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:53;s:92:\"%7B%22default%22%3A%7B%22margin-top%22%3A%224rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\";i:54;s:135:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%221.5rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\";i:55;s:157:\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\";i:56;s:307:\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22laptops%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22tablets%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22mobiles%22%3A%7B%22width%22%3A%2235px%22%2C%22height%22%3A%221px%22%7D%7D\";i:57;s:195:\"%7B%22default%22%3A%7B%22background-image%22%3A%2294%22%2C%22background-position%22%3A%22center%20bottom%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:58;s:348:\"%7B%22default%22%3A%7B%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22560px%22%7D%2C%22laptops%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22tablets%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22mobiles%22%3A%7B%22min-height%22%3A%22120px%22%7D%7D\";i:59;s:644:\"%7B%22default%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22laptops%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22tablets%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22mobiles%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%22.3rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:60;s:222:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%2230px%22%7D%7D\";i:61;s:52:\"%7B%22default%22%3A%7B%22width%22%3A%2284px%22%7D%7D\";i:62;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:63;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:64;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:65;s:222:\"%7B%22default%22%3A%7B%22color%22%3A%22_fundo2%22%2C%22font-size%22%3A%2213px%22%2C%22line-height%22%3A%221.2%22%2C%22letter-spacing%22%3A%220.04em%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%221.5rem%22%7D%7D\";i:66;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:67;s:460:\"%7B%22default%22%3A%7B%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22560px%22%2C%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%221px%22%2C%22border-color%22%3A%22%23767b96%22%7D%2C%22laptops%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22tablets%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22mobiles%22%3A%7B%22min-height%22%3A%22120px%22%7D%7D\";i:68;s:644:\"%7B%22default%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22laptops%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22tablets%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22mobiles%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%22.3rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:69;s:222:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%2230px%22%7D%7D\";i:70;s:52:\"%7B%22default%22%3A%7B%22width%22%3A%2284px%22%7D%7D\";i:71;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:72;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:73;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:74;s:222:\"%7B%22default%22%3A%7B%22color%22%3A%22_fundo2%22%2C%22font-size%22%3A%2213px%22%2C%22line-height%22%3A%221.2%22%2C%22letter-spacing%22%3A%220.04em%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%221.5rem%22%7D%7D\";i:75;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:76;s:460:\"%7B%22default%22%3A%7B%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22560px%22%2C%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%221px%22%2C%22border-color%22%3A%22%23767b96%22%7D%2C%22laptops%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22tablets%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22mobiles%22%3A%7B%22min-height%22%3A%22120px%22%7D%7D\";i:77;s:163:\"%7B%22default%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:78;s:222:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%2230px%22%7D%7D\";i:79;s:52:\"%7B%22default%22%3A%7B%22width%22%3A%2284px%22%7D%7D\";i:80;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:81;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:82;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:83;s:222:\"%7B%22default%22%3A%7B%22color%22%3A%22_fundo2%22%2C%22font-size%22%3A%2213px%22%2C%22line-height%22%3A%221.2%22%2C%22letter-spacing%22%3A%220.04em%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%221.5rem%22%7D%7D\";i:84;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:85;s:238:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_fundo1%22%2C%22background-image%22%3A%2292%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\";i:86;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%224rem%22%7D%7D\";i:87;s:135:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%221.5rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\";i:88;s:157:\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\";i:89;s:307:\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22laptops%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22tablets%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22mobiles%22%3A%7B%22width%22%3A%2220px%22%2C%22height%22%3A%221px%22%7D%7D\";i:90;s:226:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:91;s:206:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%222.4rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:92;s:219:\"%7B%22default%22%3A%7B%22color%22%3A%22_link%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:93;s:205:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:94;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:95;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:96;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:97;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:98;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:99;s:207:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:100;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:101;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:102;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:103;s:267:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%222.4rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%2C%22position%22%3A%22relative%22%2C%22z-index%22%3A%2222%22%7D%7D\";i:104;s:219:\"%7B%22default%22%3A%7B%22color%22%3A%22_link%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:105;s:266:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%2C%22position%22%3A%22relative%22%2C%22z-index%22%3A%2222%22%7D%7D\";i:106;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:107;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:108;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:109;s:757:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%2C%22position%22%3A%22relative%22%2C%22z-index%22%3A%2222%22%7D%2C%22laptops%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22tablets%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22mobiles%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:110;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:111;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:112;s:93:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22z-index%22%3A%2222%22%7D%7D\";i:113;s:291:\"%7B%22default%22%3A%7B%22background-image%22%3A%2293%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%2C%22margin-top%22%3A%22-140px%22%2C%22z-index%22%3A%2210%22%7D%7D\";i:114;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22150px%22%7D%7D\";i:115;s:216:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_secundaria%22%2C%22padding-left%22%3A%222.5rem%22%2C%22padding-top%22%3A%222.5rem%22%2C%22padding-bottom%22%3A%222.5rem%22%2C%22padding-right%22%3A%222.5rem%22%7D%7D\";i:116;s:220:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:117;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:118;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:119;s:215:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_principal%22%2C%22padding-left%22%3A%222.5rem%22%2C%22padding-top%22%3A%222.5rem%22%2C%22padding-bottom%22%3A%222.5rem%22%2C%22padding-right%22%3A%222.5rem%22%7D%7D\";i:120;s:220:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:121;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:122;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:123;s:214:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23757575%22%2C%22padding-left%22%3A%222.5rem%22%2C%22padding-top%22%3A%222.5rem%22%2C%22padding-bottom%22%3A%222.5rem%22%2C%22padding-right%22%3A%222.5rem%22%7D%7D\";i:124;s:220:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:125;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:126;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:127;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%228rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("555", "144", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("556", "145", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("557", "146", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("558", "147", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("559", "148", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("560", "149", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("561", "150", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("562", "151", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("563", "152", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("564", "153", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("565", "154", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("566", "130", "us_og_image", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/09/MID_XPharma_ico_-16.svg");
INSERT INTO `wp_postmeta` VALUES("567", "155", "_wp_attached_file", "2025/09/MID_XPharma_agua-6.jpg");
INSERT INTO `wp_postmeta` VALUES("568", "155", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:478;s:6:\"height\";i:328;s:4:\"file\";s:30:\"2025/09/MID_XPharma_agua-6.jpg\";s:8:\"filesize\";i:5345;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-6-300x206.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:206;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1972;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-6-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1244;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("569", "156", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("570", "157", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("571", "158", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("572", "159", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("573", "160", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("574", "161", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("575", "162", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("576", "163", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("577", "164", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("578", "165", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("579", "166", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("580", "167", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("581", "168", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("582", "169", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("583", "170", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("584", "171", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("585", "172", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("586", "173", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("587", "174", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("588", "175", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("589", "176", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("590", "177", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("591", "178", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("592", "179", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("593", "180", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("594", "181", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("595", "182", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("596", "183", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("597", "184", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("598", "185", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("599", "186", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("600", "187", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("601", "188", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("602", "189", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("603", "190", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("604", "191", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("605", "192", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("606", "193", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("607", "194", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("608", "195", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("609", "196", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("610", "197", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("611", "198", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("612", "199", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("613", "200", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("614", "201", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("615", "202", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("616", "203", "_wp_attached_file", "2025/09/MID_XPharma_null-rosa-1.jpg");
INSERT INTO `wp_postmeta` VALUES("617", "203", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:953;s:6:\"height\";i:1321;s:4:\"file\";s:35:\"2025/09/MID_XPharma_null-rosa-1.jpg\";s:8:\"filesize\";i:15465;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:35:\"MID_XPharma_null-rosa-1-216x300.jpg\";s:5:\"width\";i:216;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1754;}s:5:\"large\";a:5:{s:4:\"file\";s:36:\"MID_XPharma_null-rosa-1-739x1024.jpg\";s:5:\"width\";i:739;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12722;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:35:\"MID_XPharma_null-rosa-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1090;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("618", "204", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("619", "205", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("620", "206", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("621", "207", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("622", "208", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("623", "209", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("624", "210", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("625", "211", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("626", "212", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("627", "213", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("628", "214", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("629", "215", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("630", "216", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("631", "217", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("632", "218", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("633", "219", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("634", "220", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("635", "221", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("636", "222", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("637", "223", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("638", "224", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("639", "225", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("640", "226", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("641", "227", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("642", "228", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("643", "229", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("644", "230", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("645", "231", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("646", "232", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("647", "233", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("648", "234", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("649", "235", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("650", "236", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("651", "237", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("652", "238", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("653", "239", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("654", "240", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("655", "241", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("656", "242", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("657", "243", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("658", "244", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("659", "245", "_wp_attached_file", "2023/02/MID_XPharma_ico_-17.svg");
INSERT INTO `wp_postmeta` VALUES("660", "245", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:10430;}");
INSERT INTO `wp_postmeta` VALUES("661", "15", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("662", "246", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("663", "247", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("664", "248", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("665", "249", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("666", "5", "_wpb_vc_editor_type", "classic");
INSERT INTO `wp_postmeta` VALUES("667", "5", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("668", "5", "_wpb_shortcodes_custom_css_updated", "1");
INSERT INTO `wp_postmeta` VALUES("669", "250", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("670", "251", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("671", "252", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("672", "253", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("673", "254", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("674", "255", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("675", "256", "_wp_attached_file", "2025/09/1_DEKAsPlus-liquid-e1586427950918.png");
INSERT INTO `wp_postmeta` VALUES("676", "256", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:45:\"2025/09/1_DEKAsPlus-liquid-e1586427950918.png\";s:8:\"filesize\";i:105367;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:45:\"1_DEKAsPlus-liquid-e1586427950918-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:33896;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:45:\"1_DEKAsPlus-liquid-e1586427950918-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10474;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("677", "257", "_wp_attached_file", "2025/09/2_DEKAsPlus-tablets-1-e1586427981294.png");
INSERT INTO `wp_postmeta` VALUES("678", "257", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:48:\"2025/09/2_DEKAsPlus-tablets-1-e1586427981294.png\";s:8:\"filesize\";i:129350;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:48:\"2_DEKAsPlus-tablets-1-e1586427981294-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:39033;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:48:\"2_DEKAsPlus-tablets-1-e1586427981294-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11546;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("679", "258", "_wp_attached_file", "2025/09/3_DEKAsPlus-softgels-e1586427935703.png");
INSERT INTO `wp_postmeta` VALUES("680", "258", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:47:\"2025/09/3_DEKAsPlus-softgels-e1586427935703.png\";s:8:\"filesize\";i:130709;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:47:\"3_DEKAsPlus-softgels-e1586427935703-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:39770;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:47:\"3_DEKAsPlus-softgels-e1586427935703-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:11859;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("681", "259", "_wp_attached_file", "2025/09/4_DEKAs-Aqua-E-liquid-e15735471477641.png");
INSERT INTO `wp_postmeta` VALUES("682", "259", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:768;s:6:\"height\";i:768;s:4:\"file\";s:49:\"2025/09/4_DEKAs-Aqua-E-liquid-e15735471477641.png\";s:8:\"filesize\";i:155790;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:49:\"4_DEKAs-Aqua-E-liquid-e15735471477641-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:39647;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:49:\"4_DEKAs-Aqua-E-liquid-e15735471477641-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:12608;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("683", "260", "_wp_attached_file", "2025/09/5_DEKAsEssential-liquid-768x768-1.png");
INSERT INTO `wp_postmeta` VALUES("684", "260", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:768;s:6:\"height\";i:768;s:4:\"file\";s:45:\"2025/09/5_DEKAsEssential-liquid-768x768-1.png\";s:8:\"filesize\";i:179316;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:45:\"5_DEKAsEssential-liquid-768x768-1-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:35321;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:45:\"5_DEKAsEssential-liquid-768x768-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:10879;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("685", "261", "_wp_attached_file", "2025/09/MID_XPharma_dekas_cunha-1.png");
INSERT INTO `wp_postmeta` VALUES("686", "261", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:251;s:6:\"height\";i:350;s:4:\"file\";s:37:\"2025/09/MID_XPharma_dekas_cunha-1.png\";s:8:\"filesize\";i:2430;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:37:\"MID_XPharma_dekas_cunha-1-215x300.png\";s:5:\"width\";i:215;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3890;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:37:\"MID_XPharma_dekas_cunha-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1877;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("687", "262", "_wp_attached_file", "2025/09/MID_XPharma_dekas_img-1.jpg");
INSERT INTO `wp_postmeta` VALUES("688", "262", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1700;s:6:\"height\";i:911;s:4:\"file\";s:35:\"2025/09/MID_XPharma_dekas_img-1.jpg\";s:8:\"filesize\";i:328877;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:35:\"MID_XPharma_dekas_img-1-300x161.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:161;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5701;}s:5:\"large\";a:5:{s:4:\"file\";s:36:\"MID_XPharma_dekas_img-1-1024x549.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:549;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:37418;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:35:\"MID_XPharma_dekas_img-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3262;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("689", "139", "us_header_id", "12");
INSERT INTO `wp_postmeta` VALUES("690", "139", "us_header_transparent_override", "1");
INSERT INTO `wp_postmeta` VALUES("691", "139", "us_header_transparent", "default,laptops,tablets,mobiles");
INSERT INTO `wp_postmeta` VALUES("692", "139", "us_titlebar_id", "0");
INSERT INTO `wp_postmeta` VALUES("693", "139", "_us_jsoncss_data", "a:37:{i:0;s:56:\"%7B%22default%22%3A%7B%22margin-top%22%3A%227vh%22%7D%7D\";i:1;s:295:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%222.1rem%22%2C%22line-height%22%3A%221%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%22.8rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22animation-name%22%3A%22aft%22%2C%22animation-delay%22%3A%22250ms%22%7D%7D\";i:2;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:3;s:137:\"%7B%22default%22%3A%7B%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%227px%22%2C%22border-color%22%3A%22%234472C4%22%7D%7D\";i:4;s:137:\"%7B%22default%22%3A%7B%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%227px%22%2C%22border-color%22%3A%22%23ED7D31%22%7D%7D\";i:5;s:56:\"%7B%22default%22%3A%7B%22margin-top%22%3A%227vh%22%7D%7D\";i:6;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22140px%22%7D%7D\";i:7;s:295:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%222.1rem%22%2C%22line-height%22%3A%221%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%22.8rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22animation-name%22%3A%22aft%22%2C%22animation-delay%22%3A%22250ms%22%7D%7D\";i:8;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:9;s:137:\"%7B%22default%22%3A%7B%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%227px%22%2C%22border-color%22%3A%22%234472C4%22%7D%7D\";i:10;s:137:\"%7B%22default%22%3A%7B%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%227px%22%2C%22border-color%22%3A%22%23ED7D31%22%7D%7D\";i:11;s:56:\"%7B%22default%22%3A%7B%22margin-top%22%3A%227vh%22%7D%7D\";i:12;s:776:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%234472C4%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22laptops%22%3A%7B%22background-color%22%3A%22%234472C4%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22tablets%22%3A%7B%22background-color%22%3A%22%234472C4%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22mobiles%22%3A%7B%22background-color%22%3A%22%234472C4%22%2C%22background-image%22%3A%22%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:13;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:14;s:152:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.5%22%2C%22font-weight%22%3A%22300%22%7D%7D\";i:15;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%7D\";i:16;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%223rem%22%7D%7D\";i:17;s:92:\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:18;s:225:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:19;s:92:\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:20;s:225:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:21;s:92:\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:22;s:225:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:23;s:92:\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:24;s:225:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:25;s:124:\"%7B%22default%22%3A%7B%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%224rem%22%7D%7D\";i:26;s:776:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23ED7D31%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22laptops%22%3A%7B%22background-color%22%3A%22%23ED7D31%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22tablets%22%3A%7B%22background-color%22%3A%22%23ED7D31%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22mobiles%22%3A%7B%22background-color%22%3A%22%23ED7D31%22%2C%22background-image%22%3A%22%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:27;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:28;s:152:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.5%22%2C%22font-weight%22%3A%22300%22%7D%7D\";i:29;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%7D\";i:30;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%223rem%22%7D%7D\";i:31;s:92:\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:32;s:225:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:33;s:92:\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:34;s:225:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:35;s:124:\"%7B%22default%22%3A%7B%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%224rem%22%7D%7D\";i:36;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%223rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("694", "263", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("695", "264", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("696", "266", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("697", "267", "_wp_attached_file", "2025/09/MID_XPharma_dekas_img-2.jpg");
INSERT INTO `wp_postmeta` VALUES("698", "267", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1946;s:6:\"height\";i:911;s:4:\"file\";s:35:\"2025/09/MID_XPharma_dekas_img-2.jpg\";s:8:\"filesize\";i:347111;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:35:\"MID_XPharma_dekas_img-2-300x140.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:140;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4976;}s:5:\"large\";a:5:{s:4:\"file\";s:36:\"MID_XPharma_dekas_img-2-1024x479.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:479;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31003;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:35:\"MID_XPharma_dekas_img-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2625;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("699", "268", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("700", "269", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("701", "270", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("702", "271", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("703", "272", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("704", "273", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("705", "274", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("706", "275", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("707", "276", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("708", "277", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("709", "278", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("710", "279", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("711", "280", "_wp_attached_file", "2025/09/MID_XPharma_dekas_cunha-2.png");
INSERT INTO `wp_postmeta` VALUES("712", "280", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:227;s:6:\"height\";i:350;s:4:\"file\";s:37:\"2025/09/MID_XPharma_dekas_cunha-2.png\";s:8:\"filesize\";i:2484;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:37:\"MID_XPharma_dekas_cunha-2-195x300.png\";s:5:\"width\";i:195;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3840;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:37:\"MID_XPharma_dekas_cunha-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1877;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("713", "281", "_wp_attached_file", "2025/09/MID_XPharma_dekas_img-3.jpg");
INSERT INTO `wp_postmeta` VALUES("714", "281", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1946;s:6:\"height\";i:1053;s:4:\"file\";s:35:\"2025/09/MID_XPharma_dekas_img-3.jpg\";s:8:\"filesize\";i:374047;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:35:\"MID_XPharma_dekas_img-3-300x162.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:162;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5274;}s:5:\"large\";a:5:{s:4:\"file\";s:36:\"MID_XPharma_dekas_img-3-1024x554.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:33558;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:35:\"MID_XPharma_dekas_img-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2787;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("715", "282", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("716", "139", "us_og_image", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/09/1_DEKAsPlus-liquid-e1586427950918.png");
INSERT INTO `wp_postmeta` VALUES("717", "283", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("718", "284", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("719", "285", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("720", "286", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("721", "287", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("722", "288", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("723", "289", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("724", "289", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("725", "289", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("726", "289", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("727", "290", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("728", "289", "_edit_lock", "1760375407:1");
INSERT INTO `wp_postmeta` VALUES("729", "10", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("730", "10", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("731", "291", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("732", "292", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("733", "293", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("734", "294", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("735", "295", "_wp_attached_file", "2025/09/Certificado_XPHARMA_LDA.pdf");
INSERT INTO `wp_postmeta` VALUES("736", "295", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:459263;}");
INSERT INTO `wp_postmeta` VALUES("737", "296", "_wp_attached_file", "2025/09/Autorizacao_XPHARMA_LDA.pdf");
INSERT INTO `wp_postmeta` VALUES("738", "296", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:855877;}");
INSERT INTO `wp_postmeta` VALUES("739", "289", "us_og_image", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/09/MID_XPharma_cert-25-2.jpg");
INSERT INTO `wp_postmeta` VALUES("742", "299", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("747", "302", "_wp_attached_file", "2025/09/Autorizacao_XPHARMA_LDA-1.jpg");
INSERT INTO `wp_postmeta` VALUES("748", "302", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:900;s:6:\"height\";i:1273;s:4:\"file\";s:37:\"2025/09/Autorizacao_XPHARMA_LDA-1.jpg\";s:8:\"filesize\";i:203257;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:37:\"Autorizacao_XPHARMA_LDA-1-212x300.jpg\";s:5:\"width\";i:212;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11157;}s:5:\"large\";a:5:{s:4:\"file\";s:38:\"Autorizacao_XPHARMA_LDA-1-724x1024.jpg\";s:5:\"width\";i:724;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:83862;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:37:\"Autorizacao_XPHARMA_LDA-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5079;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("749", "303", "_wp_attached_file", "2025/09/Certificado_XPHARMA_LDA-1.jpg");
INSERT INTO `wp_postmeta` VALUES("750", "303", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:595;s:6:\"height\";i:841;s:4:\"file\";s:37:\"2025/09/Certificado_XPHARMA_LDA-1.jpg\";s:8:\"filesize\";i:150680;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:37:\"Certificado_XPHARMA_LDA-1-212x300.jpg\";s:5:\"width\";i:212;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13479;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:37:\"Certificado_XPHARMA_LDA-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6349;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("751", "304", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("752", "289", "_us_jsoncss_data", "a:4:{i:0;s:270:\"%7B%22default%22%3A%7B%22color%22%3A%22_principal%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.3%22%2C%22padding-bottom%22%3A%22.2rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_vivo%22%7D%7D\";i:1;s:92:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%224rem%22%7D%7D\";i:2;s:302:\"%7B%22default%22%3A%7B%22color%22%3A%22_principal%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.3%22%2C%22margin-top%22%3A%221rem%22%2C%22padding-bottom%22%3A%22.2rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_vivo%22%7D%7D\";i:3;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("753", "305", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("754", "306", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("755", "307", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("756", "308", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("757", "309", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("758", "310", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("759", "311", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("760", "312", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("761", "313", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("762", "3", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("763", "3", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("764", "314", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("765", "3", "_us_jsoncss_data", "a:1:{i:0;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("766", "315", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("767", "316", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("768", "317", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("769", "318", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("770", "319", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("771", "320", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("772", "321", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("773", "323", "_wp_attached_file", "2025/09/dekas_hr-1.png");
INSERT INTO `wp_postmeta` VALUES("774", "323", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1000;s:6:\"height\";i:171;s:4:\"file\";s:22:\"2025/09/dekas_hr-1.png\";s:8:\"filesize\";i:33644;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:21:\"dekas_hr-1-300x51.png\";s:5:\"width\";i:300;s:6:\"height\";i:51;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7105;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:22:\"dekas_hr-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4586;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("775", "324", "_wp_attached_file", "2023/02/MID_XPharma_logo-positivo.png");
INSERT INTO `wp_postmeta` VALUES("776", "324", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:414;s:6:\"height\";i:401;s:4:\"file\";s:37:\"2023/02/MID_XPharma_logo-positivo.png\";s:8:\"filesize\";i:13635;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:37:\"MID_XPharma_logo-positivo-300x291.png\";s:5:\"width\";i:300;s:6:\"height\";i:291;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:15569;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:37:\"MID_XPharma_logo-positivo-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7399;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("777", "325", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("778", "325", "_edit_lock", "1759160282:1");
INSERT INTO `wp_postmeta` VALUES("779", "325", "us_header_id", "12");
INSERT INTO `wp_postmeta` VALUES("780", "325", "us_header_transparent_override", "1");
INSERT INTO `wp_postmeta` VALUES("781", "325", "us_header_transparent", "default,laptops,tablets");
INSERT INTO `wp_postmeta` VALUES("782", "325", "us_titlebar_id", "0");
INSERT INTO `wp_postmeta` VALUES("783", "325", "_us_jsoncss_data", "a:115:{i:0;s:246:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_secundaria%22%2C%22background-image%22%3A%22102%22%2C%22background-position%22%3A%22right%20center%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\";i:1;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%223.5rem%22%7D%7D\";i:2;s:152:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.5%22%2C%22font-weight%22%3A%22300%22%7D%7D\";i:3;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:4;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%224.5rem%22%7D%7D\";i:5;s:156:\"%7B%22default%22%3A%7B%22background-image%22%3A%22155%22%2C%22background-position%22%3A%22left%20bottom%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:6;s:59:\"%7B%22default%22%3A%7B%22padding-right%22%3A%228vw%22%7D%7D\";i:7;s:224:\"%7B%22default%22%3A%7B%22background-image%22%3A%22103%22%2C%22background-position%22%3A%22left%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22425px%22%7D%7D\";i:8;s:59:\"%7B%22default%22%3A%7B%22padding-left%22%3A%222rem%22%7D%7D\";i:9;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%223rem%22%7D%7D\";i:10;s:135:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%221.5rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\";i:11;s:157:\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22200%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\";i:12;s:79:\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%7D\";i:13;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:14;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%226rem%22%7D%7D\";i:15;s:64:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%7D%7D\";i:16;s:220:\"%7B%22default%22%3A%7B%22background-image%22%3A%22101%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22320px%22%7D%7D\";i:17;s:103:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_principal%22%2C%22padding-left%22%3A%223rem%22%7D%7D\";i:18;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.4rem%22%7D%7D\";i:19;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:20;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:21;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:22;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.4rem%22%7D%7D\";i:23;s:133:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22padding-left%22%3A%224rem%22%2C%22padding-right%22%3A%224rem%22%7D%7D\";i:24;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:25;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:26;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:27;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:28;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:29;s:258:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22background-image%22%3A%2299%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22284px%22%7D%7D\";i:30;s:98:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_link%22%2C%22padding-left%22%3A%223rem%22%7D%7D\";i:31;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.4rem%22%7D%7D\";i:32;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:33;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:34;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:35;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.4rem%22%7D%7D\";i:36;s:220:\"%7B%22default%22%3A%7B%22background-image%22%3A%22100%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22320px%22%7D%7D\";i:37;s:103:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_principal%22%2C%22padding-left%22%3A%223rem%22%7D%7D\";i:38;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.8rem%22%7D%7D\";i:39;s:231:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:40;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.8rem%22%7D%7D\";i:41;s:190:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.8rem%22%2C%22line-height%22%3A%221%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:42;s:190:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.8rem%22%2C%22line-height%22%3A%221%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:43;s:92:\"%7B%22default%22%3A%7B%22margin-top%22%3A%224rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\";i:44;s:135:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%221.5rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\";i:45;s:157:\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22200%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\";i:46;s:79:\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%7D\";i:47;s:195:\"%7B%22default%22%3A%7B%22background-image%22%3A%2294%22%2C%22background-position%22%3A%22center%20bottom%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:48;s:183:\"%7B%22default%22%3A%7B%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22560px%22%7D%7D\";i:49;s:163:\"%7B%22default%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:50;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22120px%22%7D%7D\";i:51;s:52:\"%7B%22default%22%3A%7B%22width%22%3A%2284px%22%7D%7D\";i:52;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:53;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:54;s:222:\"%7B%22default%22%3A%7B%22color%22%3A%22_fundo2%22%2C%22font-size%22%3A%2213px%22%2C%22line-height%22%3A%221.2%22%2C%22letter-spacing%22%3A%220.04em%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%221.5rem%22%7D%7D\";i:55;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:56;s:295:\"%7B%22default%22%3A%7B%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22560px%22%2C%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%221px%22%2C%22border-color%22%3A%22%23767b96%22%7D%7D\";i:57;s:163:\"%7B%22default%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:58;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22120px%22%7D%7D\";i:59;s:52:\"%7B%22default%22%3A%7B%22width%22%3A%2284px%22%7D%7D\";i:60;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:61;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:62;s:222:\"%7B%22default%22%3A%7B%22color%22%3A%22_fundo2%22%2C%22font-size%22%3A%2213px%22%2C%22line-height%22%3A%221.2%22%2C%22letter-spacing%22%3A%220.04em%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%221.5rem%22%7D%7D\";i:63;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:64;s:295:\"%7B%22default%22%3A%7B%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22560px%22%2C%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%221px%22%2C%22border-color%22%3A%22%23767b96%22%7D%7D\";i:65;s:163:\"%7B%22default%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:66;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22120px%22%7D%7D\";i:67;s:52:\"%7B%22default%22%3A%7B%22width%22%3A%2284px%22%7D%7D\";i:68;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:69;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:70;s:222:\"%7B%22default%22%3A%7B%22color%22%3A%22_fundo2%22%2C%22font-size%22%3A%2213px%22%2C%22line-height%22%3A%221.2%22%2C%22letter-spacing%22%3A%220.04em%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%221.5rem%22%7D%7D\";i:71;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:72;s:238:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_fundo1%22%2C%22background-image%22%3A%2292%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\";i:73;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%224rem%22%7D%7D\";i:74;s:135:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%221.5rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\";i:75;s:157:\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22200%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\";i:76;s:79:\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%7D\";i:77;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:78;s:206:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%222.4rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:79;s:219:\"%7B%22default%22%3A%7B%22color%22%3A%22_link%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:80;s:205:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:81;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:82;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:83;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:84;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:85;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:86;s:207:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:87;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:88;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:89;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:90;s:267:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%222.4rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%2C%22position%22%3A%22relative%22%2C%22z-index%22%3A%2222%22%7D%7D\";i:91;s:219:\"%7B%22default%22%3A%7B%22color%22%3A%22_link%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:92;s:266:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%2C%22position%22%3A%22relative%22%2C%22z-index%22%3A%2222%22%7D%7D\";i:93;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:94;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:95;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:96;s:268:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%2C%22position%22%3A%22relative%22%2C%22z-index%22%3A%2222%22%7D%7D\";i:97;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:98;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:99;s:93:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22z-index%22%3A%2222%22%7D%7D\";i:100;s:291:\"%7B%22default%22%3A%7B%22background-image%22%3A%2293%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%2C%22margin-top%22%3A%22-140px%22%2C%22z-index%22%3A%2210%22%7D%7D\";i:101;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22150px%22%7D%7D\";i:102;s:216:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_secundaria%22%2C%22padding-left%22%3A%222.5rem%22%2C%22padding-top%22%3A%222.5rem%22%2C%22padding-bottom%22%3A%222.5rem%22%2C%22padding-right%22%3A%222.5rem%22%7D%7D\";i:103;s:220:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:104;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:105;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:106;s:215:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_principal%22%2C%22padding-left%22%3A%222.5rem%22%2C%22padding-top%22%3A%222.5rem%22%2C%22padding-bottom%22%3A%222.5rem%22%2C%22padding-right%22%3A%222.5rem%22%7D%7D\";i:107;s:220:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:108;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:109;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:110;s:210:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_link%22%2C%22padding-left%22%3A%222.5rem%22%2C%22padding-top%22%3A%222.5rem%22%2C%22padding-bottom%22%3A%222.5rem%22%2C%22padding-right%22%3A%222.5rem%22%7D%7D\";i:111;s:220:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:112;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:113;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:114;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%228rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("784", "325", "_us_in_content_ids", "9");
INSERT INTO `wp_postmeta` VALUES("785", "325", "us_og_image", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/09/MID_XPharma_ico_-16.svg");
INSERT INTO `wp_postmeta` VALUES("786", "325", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("787", "325", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("788", "325", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("789", "326", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("790", "327", "_wp_attached_file", "2025/09/MID_XPharma_agua-7.png");
INSERT INTO `wp_postmeta` VALUES("791", "327", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:771;s:6:\"height\";i:857;s:4:\"file\";s:30:\"2025/09/MID_XPharma_agua-7.png\";s:8:\"filesize\";i:25481;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-7-270x300.png\";s:5:\"width\";i:270;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7633;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-7-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3659;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("792", "328", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("793", "329", "_wp_attached_file", "2025/09/MID_XPharma_img-11.jpg");
INSERT INTO `wp_postmeta` VALUES("794", "329", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1053;s:6:\"height\";i:726;s:4:\"file\";s:30:\"2025/09/MID_XPharma_img-11.jpg\";s:8:\"filesize\";i:108247;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-11-300x207.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:207;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12462;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-11-1024x706.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:706;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:67257;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-11-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5964;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("795", "330", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("796", "331", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("797", "332", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("798", "333", "_wp_attached_file", "2025/09/MID_XPharma_agua-9.png");
INSERT INTO `wp_postmeta` VALUES("799", "333", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:478;s:6:\"height\";i:328;s:4:\"file\";s:30:\"2025/09/MID_XPharma_agua-9.png\";s:8:\"filesize\";i:2633;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-9-300x206.png\";s:5:\"width\";i:300;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2623;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-9-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1347;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("800", "334", "_wp_attached_file", "2025/09/MID_XPharma_img-12.jpg");
INSERT INTO `wp_postmeta` VALUES("801", "334", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1053;s:6:\"height\";i:726;s:4:\"file\";s:30:\"2025/09/MID_XPharma_img-12.jpg\";s:8:\"filesize\";i:107727;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-12-300x207.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:207;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12396;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-12-1024x706.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:706;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:67066;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-12-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5926;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("802", "335", "_wp_attached_file", "2025/09/MID_XPharma_agua-8.png");
INSERT INTO `wp_postmeta` VALUES("803", "335", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:771;s:6:\"height\";i:857;s:4:\"file\";s:30:\"2025/09/MID_XPharma_agua-8.png\";s:8:\"filesize\";i:22059;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-8-270x300.png\";s:5:\"width\";i:270;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7008;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_agua-8-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3356;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("804", "336", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("805", "337", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("806", "338", "_wp_attached_file", "2025/09/MID_XPharma_img-13.jpg");
INSERT INTO `wp_postmeta` VALUES("807", "338", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1053;s:6:\"height\";i:726;s:4:\"file\";s:30:\"2025/09/MID_XPharma_img-13.jpg\";s:8:\"filesize\";i:107897;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-13-300x207.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:207;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12418;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-13-1024x706.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:706;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:67162;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-13-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5937;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("808", "339", "_wp_attached_file", "2025/09/MID_XPharma_agua-11.png");
INSERT INTO `wp_postmeta` VALUES("809", "339", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:771;s:6:\"height\";i:857;s:4:\"file\";s:31:\"2025/09/MID_XPharma_agua-11.png\";s:8:\"filesize\";i:26868;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_agua-11-270x300.png\";s:5:\"width\";i:270;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8308;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_agua-11-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:3857;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("810", "340", "_wp_attached_file", "2025/09/MID_XPharma_agua-10.png");
INSERT INTO `wp_postmeta` VALUES("811", "340", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:478;s:6:\"height\";i:328;s:4:\"file\";s:31:\"2025/09/MID_XPharma_agua-10.png\";s:8:\"filesize\";i:2583;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_agua-10-300x206.png\";s:5:\"width\";i:300;s:6:\"height\";i:206;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:2587;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_agua-10-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1343;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("812", "341", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("813", "342", "_wp_attached_file", "2024/11/MID_XPharma_img-14.jpg");
INSERT INTO `wp_postmeta` VALUES("814", "342", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1700;s:6:\"height\";i:931;s:4:\"file\";s:30:\"2024/11/MID_XPharma_img-14.jpg\";s:8:\"filesize\";i:167271;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-14-300x164.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9073;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-14-1024x561.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:561;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:50208;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-14-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4709;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("815", "343", "_wp_attached_file", "2024/11/MID_XPharma_img-15.jpg");
INSERT INTO `wp_postmeta` VALUES("816", "343", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1700;s:6:\"height\";i:931;s:4:\"file\";s:30:\"2024/11/MID_XPharma_img-15.jpg\";s:8:\"filesize\";i:174049;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-15-300x164.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9374;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-15-1024x561.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:561;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52136;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-15-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4763;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("817", "344", "_wp_attached_file", "2024/11/MID_XPharma_img-16.jpg");
INSERT INTO `wp_postmeta` VALUES("818", "344", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1700;s:6:\"height\";i:931;s:4:\"file\";s:30:\"2024/11/MID_XPharma_img-16.jpg\";s:8:\"filesize\";i:174126;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-16-300x164.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9285;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-16-1024x561.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:561;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:52228;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-16-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4768;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("819", "345", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("820", "346", "_edit_lock", "1760373488:1");
INSERT INTO `wp_postmeta` VALUES("821", "349", "_wp_attached_file", "2025/09/MID_XPharma_img-17.jpg");
INSERT INTO `wp_postmeta` VALUES("822", "349", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:910;s:6:\"height\";i:1274;s:4:\"file\";s:30:\"2025/09/MID_XPharma_img-17.jpg\";s:8:\"filesize\";i:173493;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-17-214x300.jpg\";s:5:\"width\";i:214;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12159;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-17-731x1024.jpg\";s:5:\"width\";i:731;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:73135;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-17-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5990;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("823", "346", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("824", "346", "us_og_image", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/09/MID_XPharma_img-22b.jpg");
INSERT INTO `wp_postmeta` VALUES("825", "346", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("826", "346", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("827", "346", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("828", "350", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("829", "351", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("830", "352", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("831", "353", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("832", "354", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("833", "355", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("834", "356", "_wp_attached_file", "2025/09/MID_XPharma_img-17b.jpg");
INSERT INTO `wp_postmeta` VALUES("835", "356", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:910;s:6:\"height\";i:1414;s:4:\"file\";s:31:\"2025/09/MID_XPharma_img-17b.jpg\";s:8:\"filesize\";i:189389;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-17b-193x300.jpg\";s:5:\"width\";i:193;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11235;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"MID_XPharma_img-17b-659x1024.jpg\";s:5:\"width\";i:659;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:66754;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-17b-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6030;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("836", "357", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("837", "358", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("838", "359", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("839", "360", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("840", "361", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("841", "362", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("842", "363", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("843", "364", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("844", "365", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("845", "366", "_wp_attached_file", "2025/09/MID_XPharma_img-18.jpg");
INSERT INTO `wp_postmeta` VALUES("846", "366", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:575;s:6:\"height\";i:767;s:4:\"file\";s:30:\"2025/09/MID_XPharma_img-18.jpg\";s:8:\"filesize\";i:86627;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-18-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11878;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-18-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5782;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("847", "367", "_wp_attached_file", "2025/09/MID_XPharma_img-19.jpg");
INSERT INTO `wp_postmeta` VALUES("848", "367", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:575;s:6:\"height\";i:767;s:4:\"file\";s:30:\"2025/09/MID_XPharma_img-19.jpg\";s:8:\"filesize\";i:106297;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-19-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:13048;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-19-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5698;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("849", "368", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("850", "369", "_wp_attached_file", "2025/09/MID_XPharma_img-20.jpg");
INSERT INTO `wp_postmeta` VALUES("851", "369", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:575;s:6:\"height\";i:767;s:4:\"file\";s:30:\"2025/09/MID_XPharma_img-20.jpg\";s:8:\"filesize\";i:11119;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-20-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3280;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-20-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:1955;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("852", "370", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("853", "371", "_wp_attached_file", "2025/09/MID_XPharma_img-21.jpg");
INSERT INTO `wp_postmeta` VALUES("854", "371", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1536;s:6:\"height\";i:1004;s:4:\"file\";s:30:\"2025/09/MID_XPharma_img-21.jpg\";s:8:\"filesize\";i:310545;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-21-300x196.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:196;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15670;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-21-1024x669.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:669;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:99697;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-21-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7351;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("855", "372", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("856", "373", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("857", "374", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("858", "375", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("859", "376", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("860", "377", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("861", "378", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("862", "379", "_edit_lock", "1759162868:1");
INSERT INTO `wp_postmeta` VALUES("863", "379", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("864", "379", "_us_jsoncss_data", "a:22:{i:0;s:299:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22background-image%22%3A%2291%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%222rem%22%7D%7D\";i:1;s:53:\"%7B%22default%22%3A%7B%22width%22%3A%22156px%22%7D%7D\";i:2;s:130:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%2C%22margin-top%22%3A%222rem%22%7D%7D\";i:3;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%7D\";i:4;s:198:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\";i:5;s:231:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.55rem%22%2C%22line-height%22%3A%221%22%2C%22letter-spacing%22%3A%221px%22%2C%22margin-top%22%3A%22.6rem%22%7D%7D\";i:6;s:196:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.2%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:7;s:63:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\";i:8;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\";i:9;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\";i:10;s:63:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\";i:11;s:195:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\";i:12;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\";i:13;s:63:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\";i:14;s:195:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\";i:15;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\";i:16;s:63:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\";i:17;s:195:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\";i:18;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%22.8rem%22%2C%22line-height%22%3A%221.2%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:19;s:53:\"%7B%22default%22%3A%7B%22width%22%3A%22166px%22%7D%7D\";i:20;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.2%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%22.2rem%22%7D%7D\";i:21;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%22.75rem%22%2C%22line-height%22%3A%221.2%22%2C%22font-weight%22%3A%22400%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("865", "379", "us_og_image", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/09/MID_XPharma_logo.png");
INSERT INTO `wp_postmeta` VALUES("866", "379", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("867", "379", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("868", "379", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("869", "381", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("870", "382", "_wp_attached_file", "2025/09/XPharma_DM_16_04_2024.pdf");
INSERT INTO `wp_postmeta` VALUES("871", "382", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:41457;}");
INSERT INTO `wp_postmeta` VALUES("872", "383", "_wp_attached_file", "2025/09/XPharma_GDP_16_07_2025_MUH.pdf");
INSERT INTO `wp_postmeta` VALUES("873", "383", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:238063;}");
INSERT INTO `wp_postmeta` VALUES("874", "384", "_wp_attached_file", "2025/09/XPharma_WDA_03_07_2025_MUH.pdf");
INSERT INTO `wp_postmeta` VALUES("875", "384", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:261788;}");
INSERT INTO `wp_postmeta` VALUES("876", "385", "_wp_attached_file", "2025/09/XPharma_WDA_14_03_2024_MUV.pdf");
INSERT INTO `wp_postmeta` VALUES("877", "385", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:116844;}");
INSERT INTO `wp_postmeta` VALUES("878", "386", "_wp_attached_file", "2025/09/MID_XPharma_cert-25-4.jpg");
INSERT INTO `wp_postmeta` VALUES("879", "386", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:789;s:6:\"height\";i:1116;s:4:\"file\";s:33:\"2025/09/MID_XPharma_cert-25-4.jpg\";s:8:\"filesize\";i:93685;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:33:\"MID_XPharma_cert-25-4-212x300.jpg\";s:5:\"width\";i:212;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9768;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"MID_XPharma_cert-25-4-724x1024.jpg\";s:5:\"width\";i:724;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:68723;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:33:\"MID_XPharma_cert-25-4-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4801;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("880", "387", "_wp_attached_file", "2025/09/MID_XPharma_cert-25-3.jpg");
INSERT INTO `wp_postmeta` VALUES("881", "387", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:789;s:6:\"height\";i:1116;s:4:\"file\";s:33:\"2025/09/MID_XPharma_cert-25-3.jpg\";s:8:\"filesize\";i:175424;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:33:\"MID_XPharma_cert-25-3-212x300.jpg\";s:5:\"width\";i:212;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12394;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"MID_XPharma_cert-25-3-724x1024.jpg\";s:5:\"width\";i:724;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:106969;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:33:\"MID_XPharma_cert-25-3-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6149;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("882", "388", "_wp_attached_file", "2025/09/MID_XPharma_cert-25-2.jpg");
INSERT INTO `wp_postmeta` VALUES("883", "388", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:789;s:6:\"height\";i:1116;s:4:\"file\";s:33:\"2025/09/MID_XPharma_cert-25-2.jpg\";s:8:\"filesize\";i:120530;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:33:\"MID_XPharma_cert-25-2-212x300.jpg\";s:5:\"width\";i:212;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:9728;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"MID_XPharma_cert-25-2-724x1024.jpg\";s:5:\"width\";i:724;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:73843;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:33:\"MID_XPharma_cert-25-2-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4095;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("884", "389", "_wp_attached_file", "2025/09/MID_XPharma_cert-25-1.jpg");
INSERT INTO `wp_postmeta` VALUES("885", "389", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:789;s:6:\"height\";i:1116;s:4:\"file\";s:33:\"2025/09/MID_XPharma_cert-25-1.jpg\";s:8:\"filesize\";i:106790;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:33:\"MID_XPharma_cert-25-1-212x300.jpg\";s:5:\"width\";i:212;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8683;}s:5:\"large\";a:5:{s:4:\"file\";s:34:\"MID_XPharma_cert-25-1-724x1024.jpg\";s:5:\"width\";i:724;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:62029;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:33:\"MID_XPharma_cert-25-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3757;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("886", "390", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("887", "391", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("888", "392", "_wp_attached_file", "2023/02/logo_dgav_2.svg");
INSERT INTO `wp_postmeta` VALUES("889", "392", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:26483;}");
INSERT INTO `wp_postmeta` VALUES("890", "393", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("891", "394", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("892", "395", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("893", "396", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("894", "397", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("895", "398", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("896", "399", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("897", "400", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("898", "401", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("899", "402", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("900", "403", "_wp_attached_file", "2025/10/MID_XPharma_img-21b.jpg");
INSERT INTO `wp_postmeta` VALUES("901", "403", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1536;s:6:\"height\";i:1004;s:4:\"file\";s:31:\"2025/10/MID_XPharma_img-21b.jpg\";s:8:\"filesize\";i:313402;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-21b-300x196.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:196;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15818;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"MID_XPharma_img-21b-1024x669.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:669;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:101048;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-21b-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7439;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("902", "404", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("903", "405", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("904", "406", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("905", "407", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("906", "408", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("907", "409", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("908", "410", "_wp_attached_file", "2025/10/1_XPharma_WDA_14_03_2024_MUV.pdf");
INSERT INTO `wp_postmeta` VALUES("909", "410", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:116844;}");
INSERT INTO `wp_postmeta` VALUES("910", "411", "_wp_attached_file", "2025/10/2_XPharma_GDP_14_03_2024_MUV.pdf");
INSERT INTO `wp_postmeta` VALUES("911", "411", "_wp_attachment_metadata", "a:1:{s:8:\"filesize\";i:171241;}");
INSERT INTO `wp_postmeta` VALUES("912", "412", "_wp_attached_file", "2025/10/1-final_XPharma_WDA_14_03_2024_MUV-1.jpg");
INSERT INTO `wp_postmeta` VALUES("913", "412", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:789;s:6:\"height\";i:1116;s:4:\"file\";s:48:\"2025/10/1-final_XPharma_WDA_14_03_2024_MUV-1.jpg\";s:8:\"filesize\";i:104793;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:48:\"1-final_XPharma_WDA_14_03_2024_MUV-1-212x300.jpg\";s:5:\"width\";i:212;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11100;}s:5:\"large\";a:5:{s:4:\"file\";s:49:\"1-final_XPharma_WDA_14_03_2024_MUV-1-724x1024.jpg\";s:5:\"width\";i:724;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:77059;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:48:\"1-final_XPharma_WDA_14_03_2024_MUV-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5470;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("914", "413", "_wp_attached_file", "2025/10/2-final_XPharma_GDP_14_03_2024_MUV-1.jpg");
INSERT INTO `wp_postmeta` VALUES("915", "413", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:789;s:6:\"height\";i:1116;s:4:\"file\";s:48:\"2025/10/2-final_XPharma_GDP_14_03_2024_MUV-1.jpg\";s:8:\"filesize\";i:123337;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:48:\"2-final_XPharma_GDP_14_03_2024_MUV-1-212x300.jpg\";s:5:\"width\";i:212;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11599;}s:5:\"large\";a:5:{s:4:\"file\";s:49:\"2-final_XPharma_GDP_14_03_2024_MUV-1-724x1024.jpg\";s:5:\"width\";i:724;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:90000;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:48:\"2-final_XPharma_GDP_14_03_2024_MUV-1-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5819;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("916", "414", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("917", "415", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("918", "416", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("919", "417", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("920", "418", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("921", "419", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("922", "137", "_wp_old_date", "2025-09-15");
INSERT INTO `wp_postmeta` VALUES("923", "420", "_wp_attached_file", "2025/10/MID_XPharma_img-21c.jpg");
INSERT INTO `wp_postmeta` VALUES("924", "420", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1536;s:6:\"height\";i:1004;s:4:\"file\";s:31:\"2025/10/MID_XPharma_img-21c.jpg\";s:8:\"filesize\";i:313864;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-21c-300x196.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:196;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:15860;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"MID_XPharma_img-21c-1024x669.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:669;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:101295;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-21c-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7453;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("925", "421", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("926", "422", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("927", "346", "_us_jsoncss_data", "a:1:{i:0;s:224:\"%7B%22default%22%3A%7B%22text-align%22%3A%22left%22%2C%22font-size%22%3A%222.1rem%22%2C%22line-height%22%3A%221.2%22%2C%22font-family%22%3A%22Corinthia%22%2C%22font-weight%22%3A%22400%22%2C%22margin-top%22%3A%222rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("928", "423", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("929", "424", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("930", "425", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("931", "426", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("932", "427", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("933", "428", "_wp_attached_file", "2025/09/MID_XPharma_img-22.jpg");
INSERT INTO `wp_postmeta` VALUES("934", "428", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:910;s:6:\"height\";i:1502;s:4:\"file\";s:30:\"2025/09/MID_XPharma_img-22.jpg\";s:8:\"filesize\";i:202787;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-22-182x300.jpg\";s:5:\"width\";i:182;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10851;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-22-620x1024.jpg\";s:5:\"width\";i:620;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:64118;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-22-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6132;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("935", "429", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("936", "430", "_wp_attached_file", "2025/09/MID_XPharma_img-22b.jpg");
INSERT INTO `wp_postmeta` VALUES("937", "430", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:910;s:6:\"height\";i:1574;s:4:\"file\";s:31:\"2025/09/MID_XPharma_img-22b.jpg\";s:8:\"filesize\";i:216439;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-22b-173x300.jpg\";s:5:\"width\";i:173;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10747;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"MID_XPharma_img-22b-592x1024.jpg\";s:5:\"width\";i:592;s:6:\"height\";i:1024;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:64116;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-22b-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6193;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("938", "431", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("939", "432", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("940", "2", "_us_jsoncss_data", "a:38:{i:0;s:64:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%7D%7D\";i:1;s:220:\"%7B%22default%22%3A%7B%22background-image%22%3A%22452%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22610px%22%7D%7D\";i:2;s:138:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_principal%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\";i:3;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:4;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:5;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:6;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:7;s:133:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\";i:8;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:9;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:10;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:11;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:12;s:259:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22background-image%22%3A%22450%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22280px%22%7D%7D\";i:13;s:137:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23757575%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\";i:14;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:15;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:16;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:17;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:18;s:220:\"%7B%22default%22%3A%7B%22background-image%22%3A%22451%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22330px%22%7D%7D\";i:19;s:64:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%7D%7D\";i:20;s:220:\"%7B%22default%22%3A%7B%22background-image%22%3A%22101%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22320px%22%7D%7D\";i:21;s:103:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_principal%22%2C%22padding-left%22%3A%223rem%22%7D%7D\";i:22;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.4rem%22%7D%7D\";i:23;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:24;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:25;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.4rem%22%7D%7D\";i:26;s:133:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22padding-left%22%3A%224rem%22%2C%22padding-right%22%3A%224rem%22%7D%7D\";i:27;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:28;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:29;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:30;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:31;s:258:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22background-image%22%3A%2299%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22284px%22%7D%7D\";i:32;s:137:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23757575%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\";i:33;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.4rem%22%7D%7D\";i:34;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:35;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:36;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.4rem%22%7D%7D\";i:37;s:220:\"%7B%22default%22%3A%7B%22background-image%22%3A%22100%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22320px%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("941", "2", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("942", "2", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("943", "433", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("944", "435", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("945", "436", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("946", "437", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("947", "438", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("948", "439", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("949", "440", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("950", "442", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("951", "443", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("952", "444", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("953", "445", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("954", "446", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("955", "447", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("956", "448", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("957", "449", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("958", "450", "_wp_attached_file", "2025/10/MID_XPharma_img-25.jpg");
INSERT INTO `wp_postmeta` VALUES("959", "450", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1476;s:6:\"height\";i:571;s:4:\"file\";s:30:\"2025/10/MID_XPharma_img-25.jpg\";s:8:\"filesize\";i:107384;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-25-300x116.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:116;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:7807;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-25-1024x396.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:396;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:41023;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-25-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5570;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("960", "451", "_wp_attached_file", "2025/10/MID_XPharma_img-24.jpg");
INSERT INTO `wp_postmeta` VALUES("961", "451", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:726;s:6:\"height\";i:558;s:4:\"file\";s:30:\"2025/10/MID_XPharma_img-24.jpg\";s:8:\"filesize\";i:77316;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-24-300x231.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:231;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:14604;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-24-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6617;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("962", "452", "_wp_attached_file", "2025/10/MID_XPharma_img-23.jpg");
INSERT INTO `wp_postmeta` VALUES("963", "452", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:477;s:6:\"height\";i:796;s:4:\"file\";s:30:\"2025/10/MID_XPharma_img-23.jpg\";s:8:\"filesize\";i:66206;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-23-180x300.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10381;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-23-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6112;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("964", "453", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("965", "454", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("966", "455", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("967", "456", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("968", "457", "_wp_attached_file", "2025/10/DEKAsEssentialCapsules_Bottle-236x300-1.png");
INSERT INTO `wp_postmeta` VALUES("969", "457", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:236;s:6:\"height\";i:300;s:4:\"file\";s:51:\"2025/10/DEKAsEssentialCapsules_Bottle-236x300-1.png\";s:8:\"filesize\";i:55711;s:5:\"sizes\";a:1:{s:9:\"thumbnail\";a:5:{s:4:\"file\";s:51:\"DEKAsEssentialCapsules_Bottle-236x300-1-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:22188;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("970", "458", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("971", "459", "_wp_attached_file", "2025/10/3_DEKAsPlus-essencial-2.png");
INSERT INTO `wp_postmeta` VALUES("972", "459", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:600;s:6:\"height\";i:600;s:4:\"file\";s:35:\"2025/10/3_DEKAsPlus-essencial-2.png\";s:8:\"filesize\";i:126822;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:35:\"3_DEKAsPlus-essencial-2-300x300.png\";s:5:\"width\";i:300;s:6:\"height\";i:300;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:47689;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:35:\"3_DEKAsPlus-essencial-2-150x150.png\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:14524;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("973", "460", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("974", "461", "_wp_attached_file", "2025/10/MID_XPharma_img-26.jpg");
INSERT INTO `wp_postmeta` VALUES("975", "461", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:726;s:6:\"height\";i:558;s:4:\"file\";s:30:\"2025/10/MID_XPharma_img-26.jpg\";s:8:\"filesize\";i:96660;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-26-300x231.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:231;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12158;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-26-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5263;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("976", "462", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("977", "463", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("978", "463", "_edit_lock", "1759510916:1");
INSERT INTO `wp_postmeta` VALUES("979", "463", "_us_jsoncss_data", "a:8:{i:0;s:193:\"%7B%22default%22%3A%7B%22background-image%22%3A%22344%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:1;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%2242vh%22%7D%7D\";i:2;s:204:\"%7B%22default%22%3A%7B%22background-image%22%3A%22142%22%2C%22background-position%22%3A%22right%20bottom%22%2C%22background-blend-mode%22%3A%22multiply%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:3;s:323:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%223.4rem%22%2C%22line-height%22%3A%221%22%2C%22font-weight%22%3A%22200%22%2C%22margin-left%22%3A%229vw%22%2C%22margin-top%22%3A%22.8rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22animation-name%22%3A%22aft%22%2C%22animation-delay%22%3A%22250ms%22%7D%7D\";i:4;s:193:\"%7B%22default%22%3A%7B%22background-image%22%3A%22104%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:5;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%2235vh%22%7D%7D\";i:6;s:152:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%223.2rem%22%2C%22line-height%22%3A%221.1%22%2C%22font-weight%22%3A%22200%22%7D%7D\";i:7;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("980", "463", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("981", "463", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("982", "463", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("983", "464", "_wp_attached_file", "2024/11/MID_XPharma_img-27.jpg");
INSERT INTO `wp_postmeta` VALUES("984", "464", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1700;s:6:\"height\";i:931;s:4:\"file\";s:30:\"2024/11/MID_XPharma_img-27.jpg\";s:8:\"filesize\";i:79792;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-27-300x164.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4360;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-27-1024x561.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:561;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:27338;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-27-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2763;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("985", "465", "_wp_attached_file", "2024/11/MID_XPharma_img-27b.jpg");
INSERT INTO `wp_postmeta` VALUES("986", "465", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1700;s:6:\"height\";i:931;s:4:\"file\";s:31:\"2024/11/MID_XPharma_img-27b.jpg\";s:8:\"filesize\";i:89136;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-27b-300x164.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4972;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"MID_XPharma_img-27b-1024x561.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:561;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30908;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-27b-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3082;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("987", "466", "_wp_attached_file", "2024/11/MID_XPharma_img-27c.jpg");
INSERT INTO `wp_postmeta` VALUES("988", "466", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1700;s:6:\"height\";i:931;s:4:\"file\";s:31:\"2024/11/MID_XPharma_img-27c.jpg\";s:8:\"filesize\";i:89416;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-27c-300x164.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5163;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"MID_XPharma_img-27c-1024x561.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:561;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:31496;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-27c-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3177;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("989", "467", "_wp_attached_file", "2024/11/MID_XPharma_img-27d.jpg");
INSERT INTO `wp_postmeta` VALUES("990", "467", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1700;s:6:\"height\";i:931;s:4:\"file\";s:31:\"2024/11/MID_XPharma_img-27d.jpg\";s:8:\"filesize\";i:90017;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-27d-300x164.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5044;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"MID_XPharma_img-27d-1024x561.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:561;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:32554;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-27d-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3190;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("991", "468", "_us_grid_filter_atts", "");
INSERT INTO `wp_postmeta` VALUES("992", "468", "_edit_lock", "1759407559:1");
INSERT INTO `wp_postmeta` VALUES("993", "468", "cptemplate_custom_rules", "s:6:\"a:0:{}\";");
INSERT INTO `wp_postmeta` VALUES("994", "468", "cptemplate_custom_rules_optimized", "s:6:\"a:0:{}\";");
INSERT INTO `wp_postmeta` VALUES("995", "469", "_wp_attached_file", "2025/10/MID_XPharma_img-28.jpg");
INSERT INTO `wp_postmeta` VALUES("996", "469", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:477;s:6:\"height\";i:796;s:4:\"file\";s:30:\"2025/10/MID_XPharma_img-28.jpg\";s:8:\"filesize\";i:60901;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-28-180x300.jpg\";s:5:\"width\";i:180;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10651;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-28-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5818;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("997", "470", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("998", "471", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("999", "472", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1000", "473", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1001", "474", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1002", "475", "_wp_attached_file", "2025/10/MID_XPharma_img-29.jpg");
INSERT INTO `wp_postmeta` VALUES("1003", "475", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1536;s:6:\"height\";i:1004;s:4:\"file\";s:30:\"2025/10/MID_XPharma_img-29.jpg\";s:8:\"filesize\";i:230092;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-29-300x196.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:196;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12907;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-29-1024x669.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:669;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:80558;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-29-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6112;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1004", "476", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1005", "477", "_wp_attached_file", "2025/10/MID_XPharma_img-29c.jpg");
INSERT INTO `wp_postmeta` VALUES("1006", "477", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1536;s:6:\"height\";i:1004;s:4:\"file\";s:31:\"2025/10/MID_XPharma_img-29c.jpg\";s:8:\"filesize\";i:228514;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-29c-300x196.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:196;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12766;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"MID_XPharma_img-29c-1024x669.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:669;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:80404;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-29c-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6005;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1007", "478", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1008", "480", "_wp_attached_file", "2023/02/DEKAs-Vitamins_2.png");
INSERT INTO `wp_postmeta` VALUES("1009", "480", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:768;s:6:\"height\";i:109;s:4:\"file\";s:28:\"2023/02/DEKAs-Vitamins_2.png\";s:8:\"filesize\";i:29476;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:27:\"DEKAs-Vitamins_2-300x43.png\";s:5:\"width\";i:300;s:6:\"height\";i:43;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8670;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:28:\"DEKAs-Vitamins_2-150x109.png\";s:5:\"width\";i:150;s:6:\"height\";i:109;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5607;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1010", "481", "_wp_attached_file", "2025/10/MID_XPharma_img-31.jpg");
INSERT INTO `wp_postmeta` VALUES("1011", "481", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1053;s:6:\"height\";i:726;s:4:\"file\";s:30:\"2025/10/MID_XPharma_img-31.jpg\";s:8:\"filesize\";i:122199;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-31-300x207.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:207;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11048;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-31-1024x706.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:706;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:71219;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-31-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5444;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1012", "482", "_wp_attached_file", "2025/10/MID_XPharma_img-30.jpg");
INSERT INTO `wp_postmeta` VALUES("1013", "482", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1476;s:6:\"height\";i:780;s:4:\"file\";s:30:\"2025/10/MID_XPharma_img-30.jpg\";s:8:\"filesize\";i:97988;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-30-300x159.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:159;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:6609;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-30-1024x541.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:541;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:36542;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-30-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3929;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1014", "483", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1015", "484", "_wp_attached_file", "2025/10/MID_XPharma_img-31b.jpg");
INSERT INTO `wp_postmeta` VALUES("1016", "484", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1053;s:6:\"height\";i:726;s:4:\"file\";s:31:\"2025/10/MID_XPharma_img-31b.jpg\";s:8:\"filesize\";i:123153;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-31b-300x207.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:207;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11606;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"MID_XPharma_img-31b-1024x706.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:706;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:71930;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-31b-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5534;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1017", "485", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1018", "486", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1019", "487", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1020", "488", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1021", "489", "_wp_attached_file", "2025/10/MID_XPharma_team_01.jpg");
INSERT INTO `wp_postmeta` VALUES("1022", "489", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:575;s:6:\"height\";i:767;s:4:\"file\";s:31:\"2025/10/MID_XPharma_team_01.jpg\";s:8:\"filesize\";i:73225;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_team_01-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:11891;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_team_01-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5877;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1023", "490", "_wp_attached_file", "2025/10/MID_XPharma_team_02.jpg");
INSERT INTO `wp_postmeta` VALUES("1024", "490", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:575;s:6:\"height\";i:767;s:4:\"file\";s:31:\"2025/10/MID_XPharma_team_02.jpg\";s:8:\"filesize\";i:70269;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_team_02-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:10974;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_team_02-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5029;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1025", "491", "_wp_attached_file", "2025/10/MID_XPharma_team_03.jpg");
INSERT INTO `wp_postmeta` VALUES("1026", "491", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:575;s:6:\"height\";i:767;s:4:\"file\";s:31:\"2025/10/MID_XPharma_team_03.jpg\";s:8:\"filesize\";i:51601;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_team_03-225x300.jpg\";s:5:\"width\";i:225;s:6:\"height\";i:300;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:8921;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_team_03-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4214;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1027", "492", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1028", "493", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1029", "494", "_wp_attached_file", "2025/10/MID_XPharma_img-32.jpg");
INSERT INTO `wp_postmeta` VALUES("1030", "494", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1946;s:6:\"height\";i:1053;s:4:\"file\";s:30:\"2025/10/MID_XPharma_img-32.jpg\";s:8:\"filesize\";i:124251;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-32-300x162.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:162;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:4736;}s:5:\"large\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-32-1024x554.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:554;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:30763;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:30:\"MID_XPharma_img-32-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:2511;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1031", "495", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1032", "496", "_wp_attached_file", "2024/11/MID_XPharma_img-27e.jpg");
INSERT INTO `wp_postmeta` VALUES("1033", "496", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1700;s:6:\"height\";i:931;s:4:\"file\";s:31:\"2024/11/MID_XPharma_img-27e.jpg\";s:8:\"filesize\";i:98126;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-27e-300x164.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:164;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5523;}s:5:\"large\";a:5:{s:4:\"file\";s:32:\"MID_XPharma_img-27e-1024x561.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:561;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:34616;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_img-27e-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:3417;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1034", "497", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1035", "498", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1036", "499", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1037", "500", "_edit_lock", "1760372620:1");
INSERT INTO `wp_postmeta` VALUES("1038", "500", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1039", "500", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("1040", "500", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("1041", "500", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1042", "502", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1043", "500", "_us_jsoncss_data", "a:3:{i:0;s:92:\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.1rem%22%7D%7D\";i:1;s:154:\"%7B%22default%22%3A%7B%22width%22%3A%22190px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:2;s:126:\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.1rem%22%2C%22margin-top%22%3A%221.5rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("1044", "500", "us_og_image", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/10/DEKAs-Vitamins_2-negative2.png");
INSERT INTO `wp_postmeta` VALUES("1045", "504", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1046", "505", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1047", "505", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1048", "505", "_menu_item_object_id", "500");
INSERT INTO `wp_postmeta` VALUES("1049", "505", "_menu_item_object", "us_page_block");
INSERT INTO `wp_postmeta` VALUES("1050", "505", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1051", "505", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1052", "505", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1053", "505", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1055", "505", "_menu_item_remove_rows", "1");
INSERT INTO `wp_postmeta` VALUES("1056", "506", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1057", "507", "_wp_attached_file", "2023/02/MID_XPharma_logo-hor.png");
INSERT INTO `wp_postmeta` VALUES("1058", "507", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:683;s:6:\"height\";i:84;s:4:\"file\";s:32:\"2023/02/MID_XPharma_logo-hor.png\";s:8:\"filesize\";i:7235;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_logo-hor-300x37.png\";s:5:\"width\";i:300;s:6:\"height\";i:37;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5030;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:31:\"MID_XPharma_logo-hor-150x84.png\";s:5:\"width\";i:150;s:6:\"height\";i:84;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:1464;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1059", "508", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1060", "509", "_wp_attached_file", "2025/10/DEKAs-Vitamins_2_negative.png");
INSERT INTO `wp_postmeta` VALUES("1061", "509", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:768;s:6:\"height\";i:109;s:4:\"file\";s:37:\"2025/10/DEKAs-Vitamins_2_negative.png\";s:8:\"filesize\";i:25321;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:36:\"DEKAs-Vitamins_2_negative-300x43.png\";s:5:\"width\";i:300;s:6:\"height\";i:43;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:7917;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:37:\"DEKAs-Vitamins_2_negative-150x109.png\";s:5:\"width\";i:150;s:6:\"height\";i:109;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:4587;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1062", "510", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1063", "511", "_wp_attached_file", "2025/10/DEKAs-Vitamins_2-negative2.png");
INSERT INTO `wp_postmeta` VALUES("1064", "511", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:768;s:6:\"height\";i:109;s:4:\"file\";s:38:\"2025/10/DEKAs-Vitamins_2-negative2.png\";s:8:\"filesize\";i:26082;s:5:\"sizes\";a:2:{s:6:\"medium\";a:5:{s:4:\"file\";s:37:\"DEKAs-Vitamins_2-negative2-300x43.png\";s:5:\"width\";i:300;s:6:\"height\";i:43;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:8032;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:38:\"DEKAs-Vitamins_2-negative2-150x109.png\";s:5:\"width\";i:150;s:6:\"height\";i:109;s:9:\"mime-type\";s:9:\"image/png\";s:8:\"filesize\";i:5154;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1065", "512", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1066", "513", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1067", "514", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1068", "515", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1069", "516", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1070", "518", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1071", "519", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1072", "520", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1073", "521", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1074", "522", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1075", "523", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1076", "524", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1077", "525", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1078", "526", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1079", "527", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1080", "528", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1081", "529", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1082", "530", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1083", "531", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1084", "532", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1085", "533", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1086", "534", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1087", "535", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1088", "536", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1089", "537", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1090", "538", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1091", "539", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1092", "540", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1094", "541", "us_header_transparent_override", "1");
INSERT INTO `wp_postmeta` VALUES("1095", "541", "us_header_transparent", "default,laptops,tablets,mobiles");
INSERT INTO `wp_postmeta` VALUES("1096", "541", "us_titlebar_id", "0");
INSERT INTO `wp_postmeta` VALUES("1097", "541", "us_og_image", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/09/MID_XPharma_ico_-16.svg");
INSERT INTO `wp_postmeta` VALUES("1098", "541", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1099", "541", "_edit_lock", "1760519166:1");
INSERT INTO `wp_postmeta` VALUES("1100", "541", "_us_jsoncss_data", "a:129:{i:0;s:244:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23f0f0f0%22%2C%22background-image%22%3A%22339%22%2C%22background-position%22%3A%22right%20center%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\";i:1;s:227:\"%7B%22default%22%3A%7B%22margin-top%22%3A%223.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%223.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%223.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:2;s:161:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_top_text%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.5%22%2C%22font-weight%22%3A%22500%22%7D%7D\";i:3;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.8rem%22%7D%7D\";i:4;s:227:\"%7B%22default%22%3A%7B%22margin-top%22%3A%224.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%224.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%224.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%7D\";i:5;s:156:\"%7B%22default%22%3A%7B%22background-image%22%3A%22333%22%2C%22background-position%22%3A%22left%20bottom%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:6;s:59:\"%7B%22default%22%3A%7B%22padding-right%22%3A%228vw%22%7D%7D\";i:7;s:224:\"%7B%22default%22%3A%7B%22background-image%22%3A%22484%22%2C%22background-position%22%3A%22left%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22425px%22%7D%7D\";i:8;s:59:\"%7B%22default%22%3A%7B%22padding-left%22%3A%222rem%22%7D%7D\";i:9;s:219:\"%7B%22default%22%3A%7B%22margin-top%22%3A%223rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%223rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%223rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:10;s:135:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%221.5rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\";i:11;s:157:\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\";i:12;s:79:\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%7D\";i:13;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:14;s:219:\"%7B%22default%22%3A%7B%22margin-top%22%3A%226rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%226rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%226rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%223rem%22%7D%7D\";i:15;s:220:\"%7B%22default%22%3A%7B%22background-image%22%3A%22469%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22541px%22%7D%7D\";i:16;s:198:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22padding-left%22%3A%220px%22%2C%22padding-top%22%3A%220px%22%2C%22padding-bottom%22%3A%220px%22%2C%22padding-right%22%3A%220px%22%7D%7D\";i:17;s:138:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_principal%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\";i:18;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:19;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:20;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:21;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:22;s:133:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\";i:23;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:24;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:25;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:26;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:27;s:220:\"%7B%22default%22%3A%7B%22background-image%22%3A%22482%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22267px%22%7D%7D\";i:28;s:137:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23757575%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\";i:29;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:30;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:31;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:32;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:33;s:220:\"%7B%22default%22%3A%7B%22background-image%22%3A%22461%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22330px%22%7D%7D\";i:34;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%224rem%22%7D%7D\";i:35;s:134:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%22.8rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\";i:36;s:157:\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\";i:37;s:79:\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%7D\";i:38;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:39;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:40;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:41;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:42;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:43;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:44;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:45;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:46;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:47;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:48;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:49;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:50;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:51;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:52;s:191:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\";i:53;s:92:\"%7B%22default%22%3A%7B%22margin-top%22%3A%224rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\";i:54;s:135:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%221.5rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\";i:55;s:157:\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\";i:56;s:307:\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22laptops%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22tablets%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22mobiles%22%3A%7B%22width%22%3A%2235px%22%2C%22height%22%3A%221px%22%7D%7D\";i:57;s:195:\"%7B%22default%22%3A%7B%22background-image%22%3A%2294%22%2C%22background-position%22%3A%22center%20bottom%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:58;s:348:\"%7B%22default%22%3A%7B%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22560px%22%7D%2C%22laptops%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22tablets%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22mobiles%22%3A%7B%22min-height%22%3A%22120px%22%7D%7D\";i:59;s:644:\"%7B%22default%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22laptops%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22tablets%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22mobiles%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%22.3rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:60;s:222:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%2230px%22%7D%7D\";i:61;s:52:\"%7B%22default%22%3A%7B%22width%22%3A%2284px%22%7D%7D\";i:62;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:63;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:64;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:65;s:222:\"%7B%22default%22%3A%7B%22color%22%3A%22_fundo2%22%2C%22font-size%22%3A%2213px%22%2C%22line-height%22%3A%221.2%22%2C%22letter-spacing%22%3A%220.04em%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%221.5rem%22%7D%7D\";i:66;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:67;s:460:\"%7B%22default%22%3A%7B%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22560px%22%2C%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%221px%22%2C%22border-color%22%3A%22%23767b96%22%7D%2C%22laptops%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22tablets%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22mobiles%22%3A%7B%22min-height%22%3A%22120px%22%7D%7D\";i:68;s:644:\"%7B%22default%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22laptops%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22tablets%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22mobiles%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%22.3rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:69;s:222:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%2230px%22%7D%7D\";i:70;s:52:\"%7B%22default%22%3A%7B%22width%22%3A%2284px%22%7D%7D\";i:71;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:72;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:73;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:74;s:222:\"%7B%22default%22%3A%7B%22color%22%3A%22_fundo2%22%2C%22font-size%22%3A%2213px%22%2C%22line-height%22%3A%221.2%22%2C%22letter-spacing%22%3A%220.04em%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%221.5rem%22%7D%7D\";i:75;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:76;s:460:\"%7B%22default%22%3A%7B%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22560px%22%2C%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%221px%22%2C%22border-color%22%3A%22%23767b96%22%7D%2C%22laptops%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22tablets%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22mobiles%22%3A%7B%22min-height%22%3A%22120px%22%7D%7D\";i:77;s:163:\"%7B%22default%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:78;s:222:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%2230px%22%7D%7D\";i:79;s:52:\"%7B%22default%22%3A%7B%22width%22%3A%2284px%22%7D%7D\";i:80;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:81;s:221:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:82;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:83;s:222:\"%7B%22default%22%3A%7B%22color%22%3A%22_fundo2%22%2C%22font-size%22%3A%2213px%22%2C%22line-height%22%3A%221.2%22%2C%22letter-spacing%22%3A%220.04em%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%221.5rem%22%7D%7D\";i:84;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:85;s:238:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_fundo1%22%2C%22background-image%22%3A%2292%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\";i:86;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%224rem%22%7D%7D\";i:87;s:135:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%221.5rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\";i:88;s:157:\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\";i:89;s:307:\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22laptops%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22tablets%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22mobiles%22%3A%7B%22width%22%3A%2220px%22%2C%22height%22%3A%221px%22%7D%7D\";i:90;s:226:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:91;s:206:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%222.4rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:92;s:219:\"%7B%22default%22%3A%7B%22color%22%3A%22_link%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:93;s:205:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:94;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:95;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:96;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:97;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:98;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:99;s:207:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:100;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:101;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:102;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\";i:103;s:267:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%222.4rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%2C%22position%22%3A%22relative%22%2C%22z-index%22%3A%2222%22%7D%7D\";i:104;s:219:\"%7B%22default%22%3A%7B%22color%22%3A%22_link%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:105;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%221rem%22%7D%7D\";i:106;s:266:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%2C%22position%22%3A%22relative%22%2C%22z-index%22%3A%2222%22%7D%7D\";i:107;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:108;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:109;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:110;s:757:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%2C%22position%22%3A%22relative%22%2C%22z-index%22%3A%2222%22%7D%2C%22laptops%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22tablets%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22mobiles%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\";i:111;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:112;s:88:\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\";i:113;s:93:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22z-index%22%3A%2222%22%7D%7D\";i:114;s:291:\"%7B%22default%22%3A%7B%22background-image%22%3A%2293%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%2C%22margin-top%22%3A%22-140px%22%2C%22z-index%22%3A%2210%22%7D%7D\";i:115;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22150px%22%7D%7D\";i:116;s:216:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_secundaria%22%2C%22padding-left%22%3A%222.5rem%22%2C%22padding-top%22%3A%222.5rem%22%2C%22padding-bottom%22%3A%222.5rem%22%2C%22padding-right%22%3A%222.5rem%22%7D%7D\";i:117;s:220:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:118;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:119;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:120;s:215:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_principal%22%2C%22padding-left%22%3A%222.5rem%22%2C%22padding-top%22%3A%222.5rem%22%2C%22padding-bottom%22%3A%222.5rem%22%2C%22padding-right%22%3A%222.5rem%22%7D%7D\";i:121;s:220:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:122;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:123;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:124;s:214:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23757575%22%2C%22padding-left%22%3A%222.5rem%22%2C%22padding-top%22%3A%222.5rem%22%2C%22padding-bottom%22%3A%222.5rem%22%2C%22padding-right%22%3A%222.5rem%22%7D%7D\";i:125;s:220:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:126;s:119:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\";i:127;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:128;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%228rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("1101", "541", "_us_in_content_ids", "9,558");
INSERT INTO `wp_postmeta` VALUES("1102", "541", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("1103", "541", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("1104", "541", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1105", "542", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1106", "543", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1107", "543", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1108", "544", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("1109", "544", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1110", "544", "_menu_item_object_id", "544");
INSERT INTO `wp_postmeta` VALUES("1111", "544", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("1112", "544", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1113", "544", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1114", "544", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1115", "544", "_menu_item_url", "#contact");
INSERT INTO `wp_postmeta` VALUES("1117", "545", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("1118", "545", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1119", "545", "_menu_item_object_id", "545");
INSERT INTO `wp_postmeta` VALUES("1120", "545", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("1121", "545", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1122", "545", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1123", "545", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1124", "545", "_menu_item_url", "/en/#about-us");
INSERT INTO `wp_postmeta` VALUES("1126", "546", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("1127", "546", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1128", "546", "_menu_item_object_id", "546");
INSERT INTO `wp_postmeta` VALUES("1129", "546", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("1130", "546", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1131", "546", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1132", "546", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1133", "546", "_menu_item_url", "/en/#services");
INSERT INTO `wp_postmeta` VALUES("1135", "547", "_menu_item_type", "custom");
INSERT INTO `wp_postmeta` VALUES("1136", "547", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1137", "547", "_menu_item_object_id", "547");
INSERT INTO `wp_postmeta` VALUES("1138", "547", "_menu_item_object", "custom");
INSERT INTO `wp_postmeta` VALUES("1139", "547", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1140", "547", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1141", "547", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1142", "547", "_menu_item_url", "/en/#expertise");
INSERT INTO `wp_postmeta` VALUES("1144", "548", "us_og_image", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/10/DEKAs-Vitamins_2-negative2.png");
INSERT INTO `wp_postmeta` VALUES("1145", "548", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1146", "548", "_us_jsoncss_data", "a:3:{i:0;s:92:\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.1rem%22%7D%7D\";i:1;s:154:\"%7B%22default%22%3A%7B%22width%22%3A%22190px%22%2C%22margin-left%22%3A%22auto%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:2;s:126:\"%7B%22default%22%3A%7B%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.1rem%22%2C%22margin-top%22%3A%221.5rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("1147", "548", "_edit_lock", "1760372748:1");
INSERT INTO `wp_postmeta` VALUES("1148", "548", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("1149", "548", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("1150", "548", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1151", "549", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1152", "550", "_menu_item_type", "post_type");
INSERT INTO `wp_postmeta` VALUES("1153", "550", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_postmeta` VALUES("1154", "550", "_menu_item_object_id", "548");
INSERT INTO `wp_postmeta` VALUES("1155", "550", "_menu_item_object", "us_page_block");
INSERT INTO `wp_postmeta` VALUES("1156", "550", "_menu_item_target", "");
INSERT INTO `wp_postmeta` VALUES("1157", "550", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_postmeta` VALUES("1158", "550", "_menu_item_xfn", "");
INSERT INTO `wp_postmeta` VALUES("1159", "550", "_menu_item_url", "");
INSERT INTO `wp_postmeta` VALUES("1161", "550", "_menu_item_remove_rows", "1");
INSERT INTO `wp_postmeta` VALUES("1162", "551", "us_header_id", "555");
INSERT INTO `wp_postmeta` VALUES("1163", "551", "us_header_transparent_override", "1");
INSERT INTO `wp_postmeta` VALUES("1164", "551", "us_header_transparent", "default,laptops,tablets,mobiles");
INSERT INTO `wp_postmeta` VALUES("1165", "551", "us_titlebar_id", "0");
INSERT INTO `wp_postmeta` VALUES("1166", "551", "us_og_image", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/09/1_DEKAsPlus-liquid-e1586427950918.png");
INSERT INTO `wp_postmeta` VALUES("1167", "551", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1168", "551", "_edit_lock", "1760376135:1");
INSERT INTO `wp_postmeta` VALUES("1169", "551", "_us_jsoncss_data", "a:37:{i:0;s:56:\"%7B%22default%22%3A%7B%22margin-top%22%3A%227vh%22%7D%7D\";i:1;s:295:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%222.1rem%22%2C%22line-height%22%3A%221%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%22.8rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22animation-name%22%3A%22aft%22%2C%22animation-delay%22%3A%22250ms%22%7D%7D\";i:2;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:3;s:137:\"%7B%22default%22%3A%7B%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%227px%22%2C%22border-color%22%3A%22%234472C4%22%7D%7D\";i:4;s:137:\"%7B%22default%22%3A%7B%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%227px%22%2C%22border-color%22%3A%22%23ED7D31%22%7D%7D\";i:5;s:56:\"%7B%22default%22%3A%7B%22margin-top%22%3A%227vh%22%7D%7D\";i:6;s:58:\"%7B%22default%22%3A%7B%22margin-top%22%3A%22140px%22%7D%7D\";i:7;s:295:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%222.1rem%22%2C%22line-height%22%3A%221%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%22.8rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22animation-name%22%3A%22aft%22%2C%22animation-delay%22%3A%22250ms%22%7D%7D\";i:8;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:9;s:137:\"%7B%22default%22%3A%7B%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%227px%22%2C%22border-color%22%3A%22%234472C4%22%7D%7D\";i:10;s:137:\"%7B%22default%22%3A%7B%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%227px%22%2C%22border-color%22%3A%22%23ED7D31%22%7D%7D\";i:11;s:56:\"%7B%22default%22%3A%7B%22margin-top%22%3A%227vh%22%7D%7D\";i:12;s:776:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%234472C4%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22laptops%22%3A%7B%22background-color%22%3A%22%234472C4%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22tablets%22%3A%7B%22background-color%22%3A%22%234472C4%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22mobiles%22%3A%7B%22background-color%22%3A%22%234472C4%22%2C%22background-image%22%3A%22%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:13;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:14;s:152:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.5%22%2C%22font-weight%22%3A%22300%22%7D%7D\";i:15;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%7D\";i:16;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%223rem%22%7D%7D\";i:17;s:92:\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:18;s:225:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:19;s:92:\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:20;s:225:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:21;s:92:\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:22;s:225:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:23;s:92:\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:24;s:225:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:25;s:124:\"%7B%22default%22%3A%7B%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%224rem%22%7D%7D\";i:26;s:776:\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23ED7D31%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22laptops%22%3A%7B%22background-color%22%3A%22%23ED7D31%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22tablets%22%3A%7B%22background-color%22%3A%22%23ED7D31%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22mobiles%22%3A%7B%22background-color%22%3A%22%23ED7D31%22%2C%22background-image%22%3A%22%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\";i:27;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\";i:28;s:152:\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.5%22%2C%22font-weight%22%3A%22300%22%7D%7D\";i:29;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%7D\";i:30;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%223rem%22%7D%7D\";i:31;s:92:\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:32;s:225:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:33;s:92:\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\";i:34;s:225:\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:35;s:124:\"%7B%22default%22%3A%7B%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%224rem%22%7D%7D\";i:36;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%223rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("1170", "551", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("1171", "551", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("1172", "551", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1173", "553", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1174", "554", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1175", "555", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1176", "555", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1177", "543", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_postmeta` VALUES("1178", "543", "_wp_trash_meta_time", "1760373064");
INSERT INTO `wp_postmeta` VALUES("1179", "543", "_wp_desired_post_slug", "header-pt-2");
INSERT INTO `wp_postmeta` VALUES("1180", "555", "_edit_lock", "1760375556:1");
INSERT INTO `wp_postmeta` VALUES("1181", "541", "us_header_id", "555");
INSERT INTO `wp_postmeta` VALUES("1182", "556", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1183", "558", "us_og_image", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/09/MID_XPharma_img-22b.jpg");
INSERT INTO `wp_postmeta` VALUES("1184", "558", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1185", "558", "_edit_lock", "1760518888:1");
INSERT INTO `wp_postmeta` VALUES("1186", "558", "_us_jsoncss_data", "a:1:{i:0;s:224:\"%7B%22default%22%3A%7B%22text-align%22%3A%22left%22%2C%22font-size%22%3A%222.1rem%22%2C%22line-height%22%3A%221.2%22%2C%22font-family%22%3A%22Corinthia%22%2C%22font-weight%22%3A%22400%22%2C%22margin-top%22%3A%222rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("1187", "558", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("1188", "558", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("1189", "558", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1190", "559", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1191", "560", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1192", "561", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1193", "562", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1194", "563", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1195", "564", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1196", "565", "_wp_attached_file", "2025/10/MID_XPharma_team-totalen.jpg");
INSERT INTO `wp_postmeta` VALUES("1197", "565", "_wp_attachment_metadata", "a:6:{s:5:\"width\";i:1536;s:6:\"height\";i:1004;s:4:\"file\";s:36:\"2025/10/MID_XPharma_team-totalen.jpg\";s:8:\"filesize\";i:227761;s:5:\"sizes\";a:3:{s:6:\"medium\";a:5:{s:4:\"file\";s:36:\"MID_XPharma_team-totalen-300x196.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:196;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:12740;}s:5:\"large\";a:5:{s:4:\"file\";s:37:\"MID_XPharma_team-totalen-1024x669.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:669;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:80083;}s:9:\"thumbnail\";a:5:{s:4:\"file\";s:36:\"MID_XPharma_team-totalen-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";s:8:\"filesize\";i:5991;}}s:10:\"image_meta\";a:12:{s:8:\"aperture\";s:1:\"0\";s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";s:1:\"0\";s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";s:1:\"0\";s:3:\"iso\";s:1:\"0\";s:13:\"shutter_speed\";s:1:\"0\";s:5:\"title\";s:0:\"\";s:11:\"orientation\";s:1:\"0\";s:8:\"keywords\";a:0:{}}}");
INSERT INTO `wp_postmeta` VALUES("1198", "566", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1199", "567", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1200", "568", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1201", "569", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1202", "570", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1203", "571", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1204", "572", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1205", "573", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1206", "574", "us_og_image", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/09/MID_XPharma_logo.png");
INSERT INTO `wp_postmeta` VALUES("1207", "574", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1208", "574", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1209", "574", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1210", "574", "_edit_lock", "1760376135:1");
INSERT INTO `wp_postmeta` VALUES("1211", "574", "_us_jsoncss_data", "a:19:{i:0;s:572:\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22background-image%22%3A%2291%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%222rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%222rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%222rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%221rem%22%7D%7D\";i:1;s:203:\"%7B%22default%22%3A%7B%22width%22%3A%22156px%22%7D%2C%22laptops%22%3A%7B%22width%22%3A%22156px%22%7D%2C%22tablets%22%3A%7B%22width%22%3A%22156px%22%7D%2C%22mobiles%22%3A%7B%22width%22%3A%22106px%22%7D%7D\";i:2;s:130:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%2C%22margin-top%22%3A%222rem%22%7D%7D\";i:3;s:196:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.2%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\";i:4;s:63:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\";i:5;s:197:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\";i:6;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\";i:7;s:63:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\";i:8;s:195:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\";i:9;s:59:\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\";i:10;s:63:\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\";i:11;s:195:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\";i:12;s:468:\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%22.8rem%22%2C%22line-height%22%3A%221.2%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%22.3rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\";i:13;s:53:\"%7B%22default%22%3A%7B%22width%22%3A%22166px%22%7D%7D\";i:14;s:52:\"%7B%22default%22%3A%7B%22width%22%3A%2265px%22%7D%7D\";i:15;s:225:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";i:16;s:198:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\";i:17;s:231:\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.55rem%22%2C%22line-height%22%3A%221%22%2C%22letter-spacing%22%3A%221px%22%2C%22margin-top%22%3A%22.6rem%22%7D%7D\";i:18;s:57:\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("1212", "574", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("1213", "574", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("1214", "574", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1215", "575", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1216", "576", "cptemplate_custom_rules", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1217", "576", "cptemplate_custom_rules_optimized", "a:0:{}");
INSERT INTO `wp_postmeta` VALUES("1218", "576", "_wp_page_template", "default");
INSERT INTO `wp_postmeta` VALUES("1219", "576", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1220", "576", "_edit_lock", "1760375363:1");
INSERT INTO `wp_postmeta` VALUES("1221", "576", "_us_jsoncss_data", "a:1:{i:0;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("1222", "576", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("1223", "576", "_wpb_vc_editor_type", "classic");
INSERT INTO `wp_postmeta` VALUES("1224", "576", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1225", "577", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1226", "578", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1227", "579", "us_og_image", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/09/MID_XPharma_cert-25-2.jpg");
INSERT INTO `wp_postmeta` VALUES("1228", "579", "_edit_last", "1");
INSERT INTO `wp_postmeta` VALUES("1229", "579", "_edit_lock", "1760375686:1");
INSERT INTO `wp_postmeta` VALUES("1230", "579", "_us_jsoncss_data", "a:4:{i:0;s:270:\"%7B%22default%22%3A%7B%22color%22%3A%22_principal%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.3%22%2C%22padding-bottom%22%3A%22.2rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_vivo%22%7D%7D\";i:1;s:92:\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%224rem%22%7D%7D\";i:2;s:302:\"%7B%22default%22%3A%7B%22color%22%3A%22_principal%22%2C%22font-size%22%3A%221.5rem%22%2C%22line-height%22%3A%221.3%22%2C%22margin-top%22%3A%221rem%22%2C%22padding-bottom%22%3A%22.2rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_vivo%22%7D%7D\";i:3;s:60:\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\";}");
INSERT INTO `wp_postmeta` VALUES("1231", "579", "_wpb_vc_js_status", "true");
INSERT INTO `wp_postmeta` VALUES("1232", "579", "_wpb_vc_editor_type", "backend");
INSERT INTO `wp_postmeta` VALUES("1233", "579", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1234", "580", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1235", "581", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1236", "582", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1237", "584", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1238", "586", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1239", "587", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1240", "589", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1241", "590", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1242", "591", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1243", "592", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1244", "593", "_wpb_post_custom_layout", "default");
INSERT INTO `wp_postmeta` VALUES("1245", "594", "_wpb_post_custom_layout", "default");

/* INSERT TABLE DATA: wp_posts */
INSERT INTO `wp_posts` VALUES("1", "1", "2023-02-13 23:22:36", "2023-02-13 23:22:36", "<!-- wp:paragraph -->\n<p>Boas-vindas ao WordPress. Este é o seu primeiro artigo. Edite-o ou elimine-o, e depois comece a escrever!</p>\n<!-- /wp:paragraph -->", "Olá, mundo!", "", "publish", "open", "open", "", "ola-mundo", "", "", "2023-02-13 23:22:36", "2023-02-13 23:22:36", "", "0", "https://midtemplate.makeitdigital2.tk/?p=1", "0", "post", "", "1");
INSERT INTO `wp_posts` VALUES("2", "1", "2023-02-13 23:22:36", "2023-02-13 23:22:36", "[vc_row][vc_column width=\"1/1\"][us_separator size=\"huge\"][/vc_column][/vc_row][vc_row width=\"full\" columns_gap=\"0rem\" content_placement=\"bottom\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%7D%7D\"][vc_column link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22452%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22610px%22%7D%7D\" width=\"1/4\"][/vc_column][vc_column link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][vc_row_inner columns_gap=\"0rem\" content_placement=\"middle\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_principal%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\" width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][us_text text=\"A nossa Missão\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]O nosso propósito é estabelecer o acesso a medicamentos não disponíveis por qualquer razão (ruturas, descontinuados ou não comercializados) com precisão, agilidade e, acima de tudo, com um profundo compromisso com o paciente.[/vc_column_text][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\" width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][us_text text=\"Os nossos Valores\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]Os nossos pilares valorizam a Confiança juntamente com o acesso à saúde para todos e as pessoas em primeiro lugar.[/vc_column_text][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width=\"1/2\"][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22background-image%22%3A%22450%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22280px%22%7D%7D\" width=\"1/1\"][/vc_column_inner][/vc_row_inner][vc_row_inner columns_gap=\"0rem\" content_placement=\"middle\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23757575%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\" width=\"5/12\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][us_text text=\"A nossa Visão\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]Queremos ser reconhecidos como especialistas no procurement de medicamentos de importação e exportação, com sólidas relações que impulsionem o crescimento de todos.[/vc_column_text][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22451%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22330px%22%7D%7D\" width=\"7/12\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column width=\"1/1\"][us_separator size=\"huge\"][/vc_column][/vc_row][vc_row width=\"full\" columns_gap=\"0rem\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%7D%7D\"][vc_column width=\"1/2\"][vc_row_inner columns_gap=\"0rem\" content_placement=\"middle\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22101%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22320px%22%7D%7D\" width=\"1/2\"][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_principal%22%2C%22padding-left%22%3A%223rem%22%7D%7D\" width=\"1/2\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.4rem%22%7D%7D\"][us_text text=\"A nossa Missão\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]O nosso propósito é estabelecer o acesso a medicamentos não disponíveis por qualquer razão (ruturas, descontinuados ou não comercializados) com precisão, agilidade e, acima de tudo, com um profundo compromisso com o paciente.[/vc_column_text][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.4rem%22%7D%7D\"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22padding-left%22%3A%224rem%22%2C%22padding-right%22%3A%224rem%22%7D%7D\" width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][us_text text=\"Os nossos Valores\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]Os nossos pilares valorizam a Confiança juntamente com o acesso à saúde para todos e as pessoas em primeiro lugar.[/vc_column_text][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/2\"][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22background-image%22%3A%2299%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22284px%22%7D%7D\" width=\"1/1\"][/vc_column_inner][/vc_row_inner][vc_row_inner columns_gap=\"0rem\" content_placement=\"middle\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23757575%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\" width=\"1/2\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.4rem%22%7D%7D\"][us_text text=\"A nossa Visão\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]Queremos ser reconhecidos como especialistas no procurement de medicamentos de importação e exportação, com sólidas relações que impulsionem o crescimento de todos.[/vc_column_text][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.4rem%22%7D%7D\"][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22100%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22320px%22%7D%7D\" width=\"1/2\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row][vc_column width=\"1/1\"][us_separator size=\"huge\"][/vc_column][/vc_row]", "Exemplo de página", "", "draft", "closed", "open", "", "pagina-exemplo", "", "", "2025-10-02 12:55:24", "2025-10-02 12:55:24", "", "0", "https://midtemplate.makeitdigital2.tk/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("3", "1", "2023-02-13 23:22:36", "2023-02-13 23:22:36", "[vc_row css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%225rem%22%7D%7D\"][vc_column][vc_column_text]<span>Ao utilizar o nosso website, o utilizador assume implicitamente que leu, compreendeu e concordou com a política de privacidade e termos de utilização presentes nesta página. A presente política de privacidade refere a finalidade e a forma de como processamos e garantimos a privacidade dos seus dados pessoais.</span>\r\n\r\n<span>A mesma é efetuada de acordo com o <a href=\"https://eur-lex.europa.eu/legal-content/PT/TXT/?uri=celex%3A32016R0679\" target=\"_blank\" rel=\"noopener\"><b>Regulamento (EU) 2016/679</b></a> do Parlamento e Conselho Europeu, de 27 de abril de 2016 (Regulamento Geral de Proteção de Dados, ou RGPD), e restantes normas aplicáveis a nível nacional e internacional.</span>\r\n\r\n&nbsp;\r\n<h3>1. Responsável pelo tratamento de dados</h3>\r\n<span>Os seus dados pessoais são tratados pela <a href=\"https://xpharma.pt/\" target=\"_blank\" rel=\"noopener\">XPHARMA</a>, com sede na Av. Das Robinias, 10 -2635-545 Rio de Mouro, Portugal</span><span>.</span><span>\r\n</span><span>Email: </span><a href=\"mailto:xpharma@xpharma.pt\"><span>xpharma@xpharma.pt</span></a><span> – </span><span>Telefone: <a href=\"tel:+351211370048\">+351 211 370 048</a></span>\r\n<h3>2. Formas de recolha de dados</h3>\r\n<span>Poderão ser recolhidos dados seus de forma direta (preenchimento de campos de formulário de pedido de contacto) ou indireta (recolha de dados agregados para acompanhamento estatístico do número de visitantes do site e páginas visitadas no site, através de <em>cookies</em> ou outros). Os dados recolhidos de forma direta poderão incluir informação pessoal, enquanto que os dados recolhidos de forma indireta não incluem qualquer informação pessoal e não permitem a sua identificação.</span>\r\n<h3>3. Finalidade da recolha de dados pessoais</h3>\r\n<span>Todos e quaisquer dados pessoais recolhidos, destinam-se exclusivamente ao atendimento a pedidos de contacto e/ou de prestação de serviços, recebidos através de formulário de contacto específico, não sendo utilizados para nenhum outro fim que não os expressamente previstos.</span><span> </span>\r\n<h3>4. Armazenamento de dados pessoais</h3>\r\n<span>A informação pessoal recolhida será armazenada apenas pelo tempo estritamente necessário para o cumprimento da finalidade específica a que se destina e/ou para o cumprimento de quaisquer obrigações legais e/ou regulamentares relativas à conservação de dados, mantendo-se salvaguardada a privacidade dos dados durante todo o período de armazenamento.</span>\r\n<h3>5. Partilha de dados pessoais com terceiros</h3>\r\n<span>Os seus dados pessoais apenas serão partilhados com entidades terceiras na medida estritamente necessária para o cumprimento da finalidade para a qual nos disponibilizou os mesmos (ex.: encomendas, solucionar questões ou dúvidas relacionadas com a venda de produtos). Também podemos usar e fornecer informações agregadas e estatísticas a terceiros para monitorizar o uso do nosso website, com a finalidade de nos ajudar a desenvolvê-lo.</span>\r\n\r\n<span>A cedência voluntária dos dados será tida como consentimento para a comunicação dos mesmos a terceiros que sejam indissociáveis do serviço ou ação solicitada. Nenhuma partilha ou divulgação dos seus dados pessoais ocorrerá sem o seu consentimento explícito ou implícito, exceto para o cumprimento de obrigações legais e/ou regulamentares (p.ex., auditorias), no âmbito das quais se manterá o princípio da segurança e privacidade de todos os dados na extensão máxima que for possível.</span>\r\n<h3>6. Direitos legais sobre os seus dados</h3>\r\n<span>Ao abrigo dos artigos 15.º a 21.º do Regulamento Geral de Proteção de Dados, dispõe de vários direitos enquanto titular dos seus dados, sendo que esses são integralmente reconhecidos por esta política de privacidade: Direito de acesso, Direito de retificação, Direito ao apagamento, Direito à limitação do tratamento, Direito de portabilidade dos dados, Direito de oposição.</span>\r\n\r\n<span>Poderá consultar a legislação de referência (RGPD) para um esclarecimento mais aprofundado relativamente aos seus direitos, podendo também recorrer aos meios de contacto indicados nesta política de privacidade para exercê-los ou para fazer questões relativamente ao tratamento e utilização dos seus dados.</span>\r\n<h3>7. Hiperligações a páginas de terceiros</h3>\r\n<span>A política de privacidade não é aplicável a websites ou meios de suporte de terceiros que o utilizador possa vir a ter acesso através deste website. Neste caso, sempre que visitar outro website a partir deste, deverá sempre ler a política de privacidade aplicável e verificar se concorda com os seus termos antes de facultar os seus dados pessoais.</span>\r\n\r\n<span>O proprietário deste website não se responsabiliza pela política de privacidade ou tratamento de dados pessoais que seja aplicável em websites de entidades terceiras, nem pelos conteúdos disponibilizados nos mesmos websites</span>[/vc_column_text][/vc_column][/vc_row]", "Política de privacidade", "", "publish", "closed", "open", "", "politica-privacidade", "", "", "2025-09-17 08:56:14", "2025-09-17 08:56:14", "", "0", "https://midtemplate.makeitdigital2.tk/?page_id=3", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("5", "1", "2023-02-13 23:30:18", "2023-02-13 23:30:18", "[vc_row height=\"auto\"][vc_column width=\"1/1\"][dhvc_form_text required=\"1\" control_name=\"nome\" placeholder=\"Nome\"][/vc_column][/vc_row][vc_row height=\"auto\" columns_gap=\"0.8rem\"][vc_column width=\"1/2\"][dhvc_form_email required=\"1\" control_name=\"email\" placeholder=\"Email\"][/vc_column][vc_column width=\"1/2\"][dhvc_form_text required=\"1\" control_name=\"telefone\" placeholder=\"Telefone\"][/vc_column][/vc_row][vc_row height=\"auto\"][vc_column width=\"1/1\"][dhvc_form_textarea required=\"1\" control_name=\"mensagem\" input_css=\".vc_custom_1758028114321{margin-bottom: 20px !important;}\" placeholder=\"Mensagem\"][dhvc_form_checkbox required=\"1\" control_name=\"optin\" options=\"W3siaXNfZGVmYXVsdCI6MCwibGFiZWwiOiI8c3BhbiBzdHlsZT1cImZvbnQtc2l6ZTowLjdyZW0gIWltcG9ydGFudDtjb2xvcjojZmZmICFpbXBvcnRhbnQ7XCI+RXN0b3UgZGUgYWNvcmRvIGNvbSBhIDxhIGhyZWY9XCIvcG9saXRpY2EtcHJpdmFjaWRhZGUvXCIgdGFyZ2V0PVwiX2JsYW5rXCIgcmVsPVwibm9vcGVuZXJcIj5Qb2zDrXRpY2EgZGUgUHJpdmFjaWRhZGU8L2E+IHF1ZSBsaSBlIGNvbXByZWVuZGkuPC9zcGFuPiIsInZhbHVlIjoib3B0aW4ifV0=\" input_css=\".vc_custom_1758028132742{margin-bottom: 20px !important;}\"][dhvc_form_submit_button label=\"Enviar\"][/vc_column][/vc_row]", "Contacto PT", "", "publish", "closed", "closed", "", "contacto-pt", "", "", "2025-09-16 13:11:42", "2025-09-16 13:11:42", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=dhvcform&#038;p=5", "0", "dhvcform", "", "0");
INSERT INTO `wp_posts` VALUES("6", "1", "2023-02-13 23:30:45", "2023-02-13 23:30:45", "<p>[vc_row][vc_column width=\"1/1\"][dhvc_form id=\"5\"][/vc_column][/vc_row]</p>\r\n", "Exemplo de página", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2023-02-13 23:30:45", "2023-02-13 23:30:45", "", "2", "https://midtemplate.makeitdigital2.tk/?p=6", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("7", "1", "2023-02-13 23:39:16", "2023-02-13 23:39:16", "<p>[vc_row height=\"auto\"][vc_column width=\"1/1\"][dhvc_form_text required=\"1\" control_label=\"Name\" control_name=\"name\" input_css=\".vc_custom_1676331511714{margin-bottom: 10px !important;}\"][/vc_column][/vc_row][vc_row height=\"auto\" columns_gap=\"0.8rem\"][vc_column width=\"1/2\"][dhvc_form_email required=\"1\" control_label=\"Email\" control_name=\"email\" input_css=\".vc_custom_1676159579023{margin-bottom: 10px !important;}\"][/vc_column][vc_column width=\"1/2\"][dhvc_form_text required=\"1\" control_label=\"Phone\" control_name=\"phone\" input_css=\".vc_custom_1676331520066{margin-bottom: 10px !important;}\"][/vc_column][/vc_row][vc_row height=\"auto\"][vc_column width=\"1/1\"][dhvc_form_textarea required=\"1\" control_label=\"Message\" control_name=\"message\" input_css=\".vc_custom_1676331529269{margin-bottom: 20px !important;}\"][dhvc_form_checkbox required=\"1\" control_name=\"optin\" options=\"W3siaXNfZGVmYXVsdCI6MCwibGFiZWwiOiI8c3BhbiBzdHlsZT1cImZvbnQtc2l6ZTowLjdyZW0gIWltcG9ydGFudDtcIj5Fc3RvdSBkZSBhY29yZG8gY29tIGEgPGEgaHJlZj1cIi9wb2xpdGljYS1wcml2YWNpZGFkZS9cIiB0YXJnZXQ9XCJfYmxhbmtcIiByZWw9XCJub29wZW5lclwiPlBvbMOtdGljYSBkZSBQcml2YWNpZGFkZTwvYT4gcXVlIGxpIGUgY29tcHJlZW5kaS48L3NwYW4+IiwidmFsdWUiOiJvcHRpbiJ9XQ==\" input_css=\".vc_custom_1676330982083{margin-bottom: 20px !important;}\"][dhvc_form_submit_button][/vc_column][/vc_row]</p>\r\n", "Contacto EN", "", "publish", "closed", "closed", "", "contacto-en", "", "", "2023-02-13 23:39:16", "2023-02-13 23:39:16", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=dhvcform&#038;p=7", "0", "dhvcform", "", "0");
INSERT INTO `wp_posts` VALUES("8", "1", "2023-02-13 23:41:45", "2023-02-13 23:41:45", "", "Slide_homep", "", "publish", "closed", "closed", "", "slide_homep", "", "", "2023-02-13 23:41:45", "2023-02-13 23:41:45", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=cpt_cpt&#038;p=8", "0", "cpt_cpt", "", "0");
INSERT INTO `wp_posts` VALUES("9", "1", "2023-02-13 23:42:56", "2023-02-13 23:42:56", "{\"data\":{\"post_content:1\":{\"type\":\"full_content\",\"remove_rows\":\"\",\"force_fullwidth_rows\":0,\"excerpt_length\":\"0\",\"length\":\"30\",\"show_more_toggle\":0,\"show_more_toggle_height\":\"200px\",\"show_more_toggle_text_more\":\"Show More\",\"show_more_toggle_text_less\":\"Show Less\",\"show_more_toggle_alignment\":\"none\",\"css\":\"\",\"el_class\":\"\",\"el_id\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\"}},\"default\":{\"options\":{\"fixed\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"overflow\":0,\"color_bg\":\"\",\"color_text\":\"\",\"bg_img_source\":\"none\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_file_size\":\"large\",\"bg_img_size\":\"cover\",\"bg_img_position\":\"center center\",\"bg_img_repeat\":\"no-repeat\",\"bg_img_wrapper_end\":\"\",\"border_radius\":0,\"box_shadow\":0,\"box_shadow_hover\":0,\"el_class\":\"\"},\"layout\":{\"hidden\":[],\"middle_center\":[\"post_content:1\"]}}}", "Slide full content", "", "publish", "closed", "closed", "", "slide-full-content", "", "", "2023-02-13 23:43:15", "2023-02-13 23:43:15", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=us_grid_layout&#038;p=9", "0", "us_grid_layout", "", "0");
INSERT INTO `wp_posts` VALUES("10", "1", "2023-02-14 10:35:02", "2023-02-14 10:35:02", "<p>[vc_row us_bg_image_source=\"media\" us_bg_image=\"280\" us_bg_size=\"contain\" us_bg_pos=\"top right\" us_bg_repeat=\"no-repeat\" content_placement=\"middle\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_chrome_toolbar%22%2C%22background-image%22%3A%22161%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22margin-bottom%22%3A%223rem%22%7D%7D\"][vc_column width=\"1/1\"][us_separator][us_post_title css=\"%7B%22default%22%3A%7B%22color%22%3A%22_principal%22%2C%22font-size%22%3A%221.9rem%22%2C%22font-weight%22%3A%22400%22%7D%7D\"][us_separator size=\"small\"][/vc_column][/vc_row]</p>\r\n", "Page title PT", "", "publish", "closed", "closed", "", "page-title-pt", "", "", "2025-09-16 16:06:16", "2025-09-16 16:06:16", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=us_page_block&#038;p=10", "0", "us_page_block", "", "0");
INSERT INTO `wp_posts` VALUES("11", "1", "2023-02-14 10:38:19", "2023-02-14 10:38:19", "<p>[vc_row content_placement=\"middle\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_bg_alt%22%2C%22background-image%22%3A%22161%22%2C%22background-position%22%3A%22center%20center%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\"][vc_column width=\"1/1\"][us_separator][us_post_title css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_text%22%2C%22font-size%22%3A%221.9rem%22%2C%22font-weight%22%3A%22700%22%7D%7D\"][us_separator][/vc_column][/vc_row]</p>\n", "Page title PT", "", "inherit", "closed", "closed", "", "10-autosave-v1", "", "", "2023-02-14 10:38:19", "2023-02-14 10:38:19", "", "10", "https://midtemplate.makeitdigital2.tk/?p=11", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("12", "1", "2023-02-14 10:37:03", "2023-02-14 10:37:03", "{\"default\":{\"options\":{\"custom_breakpoint\":0,\"breakpoint\":\"900px\",\"orientation\":\"hor\",\"sticky\":1,\"sticky_auto_hide\":0,\"scroll_breakpoint\":\"1px\",\"transparent\":0,\"width\":\"300px\",\"elm_align\":\"center\",\"shadow\":\"none\",\"top_show\":true,\"top_height\":\"40px\",\"top_sticky_height\":\"0px\",\"top_fullwidth\":0,\"top_centering\":1,\"top_bg_color\":\"_secundaria\",\"top_text_color\":\"_header_middle_bg\",\"top_text_hover_color\":\"_content_bg_alt\",\"top_transparent_bg_color\":\"_secundaria\",\"top_transparent_text_color\":\"_header_middle_bg\",\"top_transparent_text_hover_color\":\"_content_bg_alt\",\"middle_height\":\"180px\",\"middle_sticky_height\":\"100px\",\"middle_fullwidth\":0,\"middle_centering\":1,\"elm_valign\":\"top\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_img_size\":\"cover\",\"bg_img_repeat\":\"repeat\",\"bg_img_position\":\"top left\",\"bg_img_attachment\":1,\"bg_img_wrapper_end\":\"\",\"middle_bg_color\":\"_header_middle_bg\",\"middle_text_color\":\"_dark\",\"middle_text_hover_color\":\"_link\",\"middle_transparent_bg_color\":\"_header_transparent_bg\",\"middle_transparent_text_color\":\"_dark\",\"middle_transparent_text_hover_color\":\"_link\",\"bottom_show\":0,\"bottom_height\":\"50px\",\"bottom_sticky_height\":\"50px\",\"bottom_fullwidth\":0,\"bottom_centering\":0,\"bottom_bg_color\":\"_header_middle_bg\",\"bottom_text_color\":\"_header_middle_text\",\"bottom_text_hover_color\":\"_header_middle_text_hover\",\"bottom_transparent_bg_color\":\"_header_transparent_bg\",\"bottom_transparent_text_color\":\"_header_transparent_text\",\"bottom_transparent_text_hover_color\":\"_header_transparent_text_hover\"},\"layout\":{\"top_left\":[],\"top_center\":[\"text:1\"],\"top_right\":[\"socials:1\",\"additional_menu:1\"],\"middle_left\":[\"menu:1\"],\"middle_center\":[\"image:1\"],\"middle_right\":[\"image:2\",\"menu:2\"],\"bottom_left\":[],\"bottom_center\":[],\"bottom_right\":[],\"hidden\":[\"btn:1\",\"menu:3\",\"image:3\"]}},\"laptops\":{\"options\":{\"custom_breakpoint\":0,\"breakpoint\":\"900px\",\"orientation\":\"hor\",\"sticky\":1,\"sticky_auto_hide\":0,\"scroll_breakpoint\":\"1px\",\"transparent\":0,\"width\":\"300px\",\"elm_align\":\"center\",\"shadow\":\"thin\",\"top_show\":true,\"top_height\":\"40px\",\"top_sticky_height\":\"0px\",\"top_fullwidth\":0,\"top_centering\":0,\"top_bg_color\":\"_header_top_bg\",\"top_text_color\":\"_header_top_text\",\"top_text_hover_color\":\"_header_top_text_hover\",\"top_transparent_bg_color\":\"_header_top_transparent_bg\",\"top_transparent_text_color\":\"_header_top_transparent_text\",\"top_transparent_text_hover_color\":\"_header_top_transparent_text_hover\",\"middle_height\":\"100px\",\"middle_sticky_height\":\"60px\",\"middle_fullwidth\":0,\"middle_centering\":0,\"elm_valign\":\"top\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_img_size\":\"cover\",\"bg_img_repeat\":\"repeat\",\"bg_img_position\":\"top left\",\"bg_img_attachment\":1,\"bg_img_wrapper_end\":\"\",\"middle_bg_color\":\"_header_middle_bg\",\"middle_text_color\":\"_header_middle_text\",\"middle_text_hover_color\":\"_header_middle_text_hover\",\"middle_transparent_bg_color\":\"_header_transparent_bg\",\"middle_transparent_text_color\":\"_header_transparent_text\",\"middle_transparent_text_hover_color\":\"_header_transparent_text_hover\",\"bottom_show\":0,\"bottom_height\":\"50px\",\"bottom_sticky_height\":\"50px\",\"bottom_fullwidth\":0,\"bottom_centering\":0,\"bottom_bg_color\":\"_header_middle_bg\",\"bottom_text_color\":\"_header_middle_text\",\"bottom_text_hover_color\":\"_header_middle_text_hover\",\"bottom_transparent_bg_color\":\"_header_transparent_bg\",\"bottom_transparent_text_color\":\"_header_transparent_text\",\"bottom_transparent_text_hover_color\":\"_header_transparent_text_hover\"},\"layout\":{\"top_left\":[\"text:1\"],\"top_center\":[],\"top_right\":[\"socials:1\",\"additional_menu:1\"],\"middle_left\":[\"menu:1\"],\"middle_center\":[\"image:1\"],\"middle_right\":[\"image:2\",\"menu:2\"],\"bottom_left\":[],\"bottom_center\":[],\"bottom_right\":[],\"hidden\":[\"btn:1\",\"menu:3\",\"image:3\"]}},\"tablets\":{\"options\":{\"custom_breakpoint\":0,\"breakpoint\":\"900px\",\"orientation\":\"hor\",\"sticky\":1,\"sticky_auto_hide\":0,\"scroll_breakpoint\":\"1px\",\"transparent\":0,\"width\":\"300px\",\"elm_align\":\"center\",\"shadow\":\"thin\",\"top_show\":true,\"top_height\":\"40px\",\"top_sticky_height\":\"0px\",\"top_fullwidth\":0,\"top_centering\":0,\"top_bg_color\":\"_header_top_bg\",\"top_text_color\":\"_header_top_text\",\"top_text_hover_color\":\"_header_top_text_hover\",\"top_transparent_bg_color\":\"_header_top_transparent_bg\",\"top_transparent_text_color\":\"_header_top_transparent_text\",\"top_transparent_text_hover_color\":\"_header_top_transparent_text_hover\",\"middle_height\":\"80px\",\"middle_sticky_height\":\"60px\",\"middle_fullwidth\":0,\"middle_centering\":0,\"elm_valign\":\"top\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_img_size\":\"cover\",\"bg_img_repeat\":\"repeat\",\"bg_img_position\":\"top left\",\"bg_img_attachment\":1,\"bg_img_wrapper_end\":\"\",\"middle_bg_color\":\"_header_middle_bg\",\"middle_text_color\":\"_header_middle_text\",\"middle_text_hover_color\":\"_header_middle_text_hover\",\"middle_transparent_bg_color\":\"_header_transparent_bg\",\"middle_transparent_text_color\":\"_header_transparent_text\",\"middle_transparent_text_hover_color\":\"_header_transparent_text_hover\",\"bottom_show\":0,\"bottom_height\":\"50px\",\"bottom_sticky_height\":\"50px\",\"bottom_fullwidth\":0,\"bottom_centering\":0,\"bottom_bg_color\":\"_header_middle_bg\",\"bottom_text_color\":\"_header_middle_text\",\"bottom_text_hover_color\":\"_header_middle_text_hover\",\"bottom_transparent_bg_color\":\"_header_transparent_bg\",\"bottom_transparent_text_color\":\"_header_transparent_text\",\"bottom_transparent_text_hover_color\":\"_header_transparent_text_hover\"},\"layout\":{\"top_left\":[\"text:1\"],\"top_center\":[],\"top_right\":[\"socials:1\",\"additional_menu:1\"],\"middle_left\":[\"menu:1\"],\"middle_center\":[\"image:1\"],\"middle_right\":[\"image:2\",\"menu:2\"],\"bottom_left\":[],\"bottom_center\":[],\"bottom_right\":[],\"hidden\":[\"btn:1\",\"image:3\",\"menu:3\"]}},\"mobiles\":{\"options\":{\"custom_breakpoint\":0,\"breakpoint\":\"900px\",\"orientation\":\"hor\",\"sticky\":1,\"sticky_auto_hide\":0,\"scroll_breakpoint\":\"1px\",\"transparent\":0,\"width\":\"300px\",\"elm_align\":\"center\",\"shadow\":\"thin\",\"top_show\":1,\"top_height\":\"40px\",\"top_sticky_height\":\"0px\",\"top_fullwidth\":0,\"top_centering\":1,\"top_bg_color\":\"_header_top_bg\",\"top_text_color\":\"_header_top_text\",\"top_text_hover_color\":\"_header_top_text_hover\",\"top_transparent_bg_color\":\"_header_top_transparent_bg\",\"top_transparent_text_color\":\"_header_top_transparent_text\",\"top_transparent_text_hover_color\":\"_header_top_transparent_text_hover\",\"middle_height\":\"80px\",\"middle_sticky_height\":\"60px\",\"middle_fullwidth\":0,\"middle_centering\":1,\"elm_valign\":\"top\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_img_size\":\"cover\",\"bg_img_repeat\":\"repeat\",\"bg_img_position\":\"top left\",\"bg_img_attachment\":1,\"bg_img_wrapper_end\":\"\",\"middle_bg_color\":\"_header_middle_bg\",\"middle_text_color\":\"_header_middle_text\",\"middle_text_hover_color\":\"_header_middle_text_hover\",\"middle_transparent_bg_color\":\"_header_transparent_bg\",\"middle_transparent_text_color\":\"_header_transparent_text\",\"middle_transparent_text_hover_color\":\"_header_transparent_text_hover\",\"bottom_show\":0,\"bottom_height\":\"50px\",\"bottom_sticky_height\":\"50px\",\"bottom_fullwidth\":0,\"bottom_centering\":0,\"bottom_bg_color\":\"_header_middle_bg\",\"bottom_text_color\":\"_header_middle_text\",\"bottom_text_hover_color\":\"_header_middle_text_hover\",\"bottom_transparent_bg_color\":\"_header_transparent_bg\",\"bottom_transparent_text_color\":\"_header_transparent_text\",\"bottom_transparent_text_hover_color\":\"_header_transparent_text_hover\"},\"layout\":{\"top_left\":[],\"top_center\":[\"text:1\"],\"top_right\":[\"additional_menu:1\"],\"middle_left\":[],\"middle_center\":[\"image:3\"],\"middle_right\":[\"menu:3\"],\"bottom_left\":[],\"bottom_center\":[],\"bottom_right\":[],\"hidden\":[\"socials:1\",\"image:1\",\"btn:1\",\"image:2\",\"menu:2\",\"menu:1\"]}},\"data\":{\"image:1\":{\"img\":\"324\",\"image\":\"\",\"has_ratio\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"disable_lazy_loading\":0,\"meta\":0,\"meta_style\":\"simple\",\"align\":\"none\",\"style\":\"\",\"size\":\"full\",\"img_transparent\":\"\",\"link\":\"%7B%22url%22%3A%22%2F%22%7D\",\"heading_1\":\"\",\"height_default\":\"130px\",\"height_laptops\":\"130px\",\"height_tablets\":\"130px\",\"height_mobiles\":\"60px\",\"heading_2\":\"\",\"height_sticky\":\"75px\",\"height_sticky_laptops\":\"90px\",\"height_sticky_tablets\":\"90px\",\"height_sticky_mobiles\":\"40px\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":\"\",\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":[],\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"scale_hover\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"animate\":\"\",\"animate_delay\":\"\",\"link_new_tab\":\"\",\"onclick\":\"\",\"onclick_code\":\"\"},\"socials:1\":{\"items\":[{\"type\":\"linkedin\",\"url\":\"%7B%22url%22%3A%22https%3A%2F%2Fwww.linkedin.com%2Fcompany%2Fxpharma-portugal%2F%22%2C%22target%22%3A%22_blank%22%2C%22rel%22%3A%22nofollow%22%7D\",\"icon\":\"fab|apple\",\"title\":\"Título\",\"color\":\"_content_faded\"},{\"type\":\"facebook\",\"url\":\"%7B%22url%22%3A%22https%3A%2F%2Fwww.facebook.com%2Fxpharma.movedbyconnections%22%2C%22target%22%3A%22_blank%22%7D\",\"icon\":\"fab|apple\",\"title\":\"Título\",\"color\":\"_content_faded\"},{\"type\":\"instagram\",\"url\":\"%7B%22url%22%3A%22https%3A%2F%2Fwww.instagram.com%2Fxpharma_movedbyconnections%2F%3Fhl%3Den%22%2C%22target%22%3A%22_blank%22%7D\",\"icon\":\"fab|apple\",\"title\":\"Título\",\"color\":\"_content_faded\"}],\"shape\":\"none\",\"style\":\"default\",\"icons_color\":\"text\",\"hover\":\"fade\",\"stretch\":0,\"gap\":\"0.5em\",\"hide_tooltip\":0,\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"font-size\":\"1.1rem\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":[],\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"color\":\"\",\"align\":\"\",\"nofollow\":\"\"},\"menu:1\":{\"source\":\"menu-header-esq\",\"indents\":\"14px\",\"spread\":0,\"align_edges\":0,\"vstretch\":1,\"hover_effect\":\"simple\",\"dropdown_arrow\":0,\"dropdown_effect\":\"height\",\"dropdown_font_size\":\"1rem\",\"dropdown_width\":0,\"mobile_width\":\"900px\",\"mobile_icon_heading\":\"\",\"mobile_icon_style\":\"hamburger_1\",\"mobile_icon_thickness\":\"3px\",\"mobile_custom_icon_open\":\"fas|bars\",\"mobile_custom_icon_close\":\"fas|times\",\"mobile_custom_image_open\":\"\",\"mobile_custom_image_close\":\"\",\"mobile_icon_size\":\"36px\",\"mobile_icon_size_laptops\":\"32px\",\"mobile_icon_size_tablets\":\"28px\",\"mobile_icon_size_mobiles\":\"24px\",\"mobile_icon_text\":\"none\",\"mobile_icon_text_label\":\"Menu\",\"mobile_body_heading\":\"\",\"mobile_layout\":\"dropdown\",\"mobile_effect_p\":\"afl\",\"mobile_effect_f\":\"aft\",\"mobile_font_size\":\"1.1rem\",\"mobile_dropdown_font_size\":\"0.9rem\",\"mobile_align\":\"none\",\"mobile_behavior\":\"1\",\"color_hover_bg\":\"transparent\",\"color_hover_text\":\"_principal\",\"color_active_bg\":\"transparent\",\"color_active_text\":\"_principal\",\"color_transparent_hover_bg\":\"\",\"color_transparent_hover_text\":\"_content_bg_alt\",\"color_transparent_active_bg\":\"transparent\",\"color_transparent_active_text\":\"_content_bg_alt\",\"color_drop_bg\":\"_header_middle_bg\",\"color_drop_text\":\"_header_middle_text\",\"color_drop_hover_bg\":\"transparent\",\"color_drop_hover_text\":\"_header_middle_text_hover\",\"color_drop_active_bg\":\"transparent\",\"color_drop_active_text\":\"_header_middle_text_hover\",\"mobile_colors\":0,\"color_mobile_bg\":\"_content_bg\",\"color_mobile_text\":\"_content_heading\",\"color_mobile_hover_bg\":\"transparent\",\"color_mobile_hover_text\":\"_content_link_hover\",\"color_mobile_active_bg\":\"transparent\",\"color_mobile_active_text\":\"_content_link\",\"color_mobile_sub_bg\":\"transparent\",\"color_mobile_sub_text\":\"_content_text\",\"color_mobile_sub_hover_bg\":\"transparent\",\"color_mobile_sub_hover_text\":\"_content_link_hover\",\"color_mobile_sub_active_bg\":\"transparent\",\"color_mobile_sub_active_text\":\"_content_link\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"font-size\":\"0.87rem\",\"letter-spacing\":\"0.06em\",\"font-weight\":\"500\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":[],\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\"},\"text:1\":{\"text\":\"XPharma - Moved by Connections\",\"wrap\":0,\"link\":\"%7B%22url%22%3A%22%22%7D\",\"hide_with_empty_link\":0,\"tag\":\"div\",\"background_inside_text\":0,\"icon\":\"\",\"iconpos\":\"left\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"color\":\"_branco\",\"text-align\":\"center\",\"font-size\":\"0.7rem\",\"letter-spacing\":\"2px\",\"font-weight\":\"600\",\"text-transform\":\"uppercase\",\"margin-left\":\"2px\",\"margin-top\":\"2px\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":[],\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"scale_hover\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"align\":\"\",\"link_type\":\"\",\"link_new_tab\":\"\",\"onclick_code\":\"\"},\"btn:1\":{\"label\":\"Contacte-nos\",\"link\":\"%7B%22url%22%3A%22%2Fcontactos%2F%22%7D\",\"hide_with_empty_link\":0,\"style\":\"5\",\"align\":\"none\",\"icon\":\"\",\"iconpos\":\"left\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":\"\",\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"scale_hover\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"link_new_tab\":\"\",\"link_type\":\"\",\"onclick_code\":\"\",\"width_type\":\"\"},\"menu:2\":{\"source\":\"menu-header-drt\",\"indents\":\"14px\",\"spread\":0,\"align_edges\":0,\"vstretch\":1,\"hover_effect\":\"simple\",\"dropdown_arrow\":0,\"dropdown_effect\":\"height\",\"dropdown_font_size\":\"1rem\",\"dropdown_width\":0,\"mobile_width\":\"300px\",\"mobile_icon_heading\":\"\",\"mobile_icon_style\":\"hamburger_1\",\"mobile_icon_thickness\":\"1.5px\",\"mobile_custom_icon_open\":\"fas|bars\",\"mobile_custom_icon_close\":\"fas|times\",\"mobile_custom_image_open\":\"\",\"mobile_custom_image_close\":\"\",\"mobile_icon_size\":\"20px\",\"mobile_icon_size_laptops\":\"20px\",\"mobile_icon_size_tablets\":\"20px\",\"mobile_icon_size_mobiles\":\"20px\",\"mobile_icon_text\":\"none\",\"mobile_icon_text_label\":\"Menu\",\"mobile_body_heading\":\"\",\"mobile_layout\":\"dropdown\",\"mobile_effect_p\":\"afl\",\"mobile_effect_f\":\"aft\",\"mobile_font_size\":\".8rem\",\"mobile_dropdown_font_size\":\"0.9rem\",\"mobile_align\":\"none\",\"mobile_behavior\":\"1\",\"color_hover_bg\":\"transparent\",\"color_hover_text\":\"#f79ec6\",\"color_active_bg\":\"transparent\",\"color_active_text\":\"#f79ec6\",\"color_transparent_hover_bg\":\"\",\"color_transparent_hover_text\":\"_content_bg_alt\",\"color_transparent_active_bg\":\"transparent\",\"color_transparent_active_text\":\"_content_bg_alt\",\"color_drop_bg\":\"_header_middle_bg\",\"color_drop_text\":\"_header_middle_text\",\"color_drop_hover_bg\":\"transparent\",\"color_drop_hover_text\":\"_principal\",\"color_drop_active_bg\":\"transparent\",\"color_drop_active_text\":\"_principal\",\"mobile_colors\":0,\"color_mobile_bg\":\"_content_bg\",\"color_mobile_text\":\"_content_heading\",\"color_mobile_hover_bg\":\"transparent\",\"color_mobile_hover_text\":\"_content_link_hover\",\"color_mobile_active_bg\":\"transparent\",\"color_mobile_active_text\":\"_content_link\",\"color_mobile_sub_bg\":\"transparent\",\"color_mobile_sub_text\":\"_content_text\",\"color_mobile_sub_hover_bg\":\"transparent\",\"color_mobile_sub_hover_text\":\"_content_link_hover\",\"color_mobile_sub_active_bg\":\"transparent\",\"color_mobile_sub_active_text\":\"_content_link\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"font-size\":\"0.87rem\",\"letter-spacing\":\"0.06em\",\"font-weight\":\"500\"},\"laptops\":{\"font-size\":\"0.87rem\",\"letter-spacing\":\"0.06em\",\"font-weight\":\"500\"},\"tablets\":{\"font-size\":\"0.87rem\",\"letter-spacing\":\"0.06em\",\"font-weight\":\"500\"},\"mobiles\":{\"font-size\":\"0.77rem\",\"letter-spacing\":\"0.06em\",\"font-weight\":\"500\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":[],\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\"},\"image:2\":{\"img\":\"480\",\"image\":\"\",\"has_ratio\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"disable_lazy_loading\":0,\"meta\":0,\"meta_style\":\"simple\",\"align\":\"none\",\"style\":\"\",\"size\":\"full\",\"img_transparent\":\"\",\"link\":\"%7B%22url%22%3A%22%2Fdekas%2F%22%7D\",\"heading_1\":\"\",\"height_default\":\"22px\",\"height_laptops\":\"22px\",\"height_tablets\":\"22px\",\"height_mobiles\":\"20px\",\"heading_2\":\"\",\"height_sticky\":\"22px\",\"height_sticky_laptops\":\"22px\",\"height_sticky_tablets\":\"22px\",\"height_sticky_mobiles\":\"20px\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"max-height\":\"32px\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":[],\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"scale_hover\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"animate\":\"\",\"animate_delay\":\"\",\"link_new_tab\":\"\",\"onclick\":\"\",\"onclick_code\":\"\"},\"additional_menu:1\":{\"source\":\"idioma\",\"layout\":\"ver\",\"spread\":0,\"responsive_width\":\"600px\",\"main_gap\":\"0.4rem\",\"main_style\":\"links\",\"main_ver_indent\":\"0.8em\",\"main_hor_indent\":\"0.8em\",\"main_color_bg\":\"rgba(0,0,0,0.1)\",\"main_color_text\":\"inherit\",\"main_color_bg_hover\":\"\",\"main_color_text_hover\":\"\",\"main_color_bg_active\":\"\",\"main_color_text_active\":\"\",\"sub_items\":0,\"sub_gap\":\"0px\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"margin-left\":\"28px\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":[],\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"align\":\"\"},\"menu:3\":{\"source\":\"menu-mobile-pt\",\"indents\":\"20px\",\"spread\":0,\"align_edges\":0,\"vstretch\":1,\"hover_effect\":\"simple\",\"dropdown_arrow\":0,\"dropdown_effect\":\"height\",\"dropdown_font_size\":\"1rem\",\"dropdown_width\":0,\"mobile_width\":\"900px\",\"mobile_icon_heading\":\"\",\"mobile_icon_style\":\"hamburger_1\",\"mobile_icon_thickness\":\"1.5px\",\"mobile_custom_icon_open\":\"fas|bars\",\"mobile_custom_icon_close\":\"fas|times\",\"mobile_custom_image_open\":\"\",\"mobile_custom_image_close\":\"\",\"mobile_icon_size\":\"36px\",\"mobile_icon_size_laptops\":\"32px\",\"mobile_icon_size_tablets\":\"28px\",\"mobile_icon_size_mobiles\":\"24px\",\"mobile_icon_text\":\"none\",\"mobile_icon_text_label\":\"Menu\",\"mobile_body_heading\":\"\",\"mobile_layout\":\"fullscreen\",\"mobile_effect_p\":\"afl\",\"mobile_effect_f\":\"aft\",\"mobile_font_size\":\"1.1rem\",\"mobile_dropdown_font_size\":\"0.9rem\",\"mobile_align\":\"none\",\"mobile_behavior\":\"1\",\"color_hover_bg\":\"transparent\",\"color_hover_text\":\"_header_middle_text_hover\",\"color_active_bg\":\"transparent\",\"color_active_text\":\"_header_middle_text_hover\",\"color_transparent_hover_bg\":\"\",\"color_transparent_hover_text\":\"\",\"color_transparent_active_bg\":\"transparent\",\"color_transparent_active_text\":\"_header_transparent_text_hover\",\"color_drop_bg\":\"_header_middle_bg\",\"color_drop_text\":\"_header_middle_text\",\"color_drop_hover_bg\":\"transparent\",\"color_drop_hover_text\":\"_header_middle_text_hover\",\"color_drop_active_bg\":\"transparent\",\"color_drop_active_text\":\"_header_middle_text_hover\",\"mobile_colors\":0,\"color_mobile_bg\":\"_content_bg\",\"color_mobile_text\":\"_content_heading\",\"color_mobile_hover_bg\":\"transparent\",\"color_mobile_hover_text\":\"_content_link_hover\",\"color_mobile_active_bg\":\"transparent\",\"color_mobile_active_text\":\"_content_link\",\"color_mobile_sub_bg\":\"transparent\",\"color_mobile_sub_text\":\"_content_text\",\"color_mobile_sub_hover_bg\":\"transparent\",\"color_mobile_sub_hover_text\":\"_content_link_hover\",\"color_mobile_sub_active_bg\":\"transparent\",\"color_mobile_sub_active_text\":\"_content_link\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":\"\",\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":[],\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\"},\"image:3\":{\"img\":\"507\",\"image\":\"\",\"has_ratio\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"disable_lazy_loading\":0,\"meta\":0,\"meta_style\":\"simple\",\"align\":\"none\",\"style\":\"\",\"size\":\"full\",\"img_transparent\":\"\",\"link\":\"%7B%22url%22%3A%22%2F%22%7D\",\"heading_1\":\"\",\"height_default\":\"35px\",\"height_laptops\":\"30px\",\"height_tablets\":\"25px\",\"height_mobiles\":\"25px\",\"heading_2\":\"\",\"height_sticky\":\"35px\",\"height_sticky_laptops\":\"30px\",\"height_sticky_tablets\":\"25px\",\"height_sticky_mobiles\":\"20px\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":\"\",\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":[],\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":1,\"opacity_hover\":1,\"scale\":1,\"scale_hover\":1,\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"animate\":\"\",\"animate_delay\":\"\",\"link_new_tab\":\"\",\"onclick\":\"\",\"onclick_code\":\"\"}}}", "Header PT", "", "publish", "closed", "closed", "", "header-pt", "", "", "2025-10-13 17:14:43", "2025-10-13 17:14:43", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=us_header&#038;p=12", "0", "us_header", "", "0");
INSERT INTO `wp_posts` VALUES("13", "1", "2023-02-14 10:40:33", "2023-02-14 10:40:33", "{\"title\":\"Image first (category, date, excerpt)\",\"cols\":\"2\",\"data\":{\"post_image:1\":{\"custom_link\":{\"url\":\"\",\"target\":\"\"},\"media_preview\":1,\"has_ratio\":1,\"ratio\":\"16x9\",\"thumbnail_size\":\"full\",\"css\":{\"default\":{\"margin-bottom\":\"1rem\"}}},\"post_title:1\":{\"custom_link\":{\"url\":\"\",\"target\":\"\"},\"css\":{\"default\":{\"font-size\":\"1rem\",\"font-weight\":\"700\",\"margin-bottom\":\"0.5rem\"}}},\"hwrapper:1\":{\"alignment\":\"none\",\"valign\":\"top\",\"inner_items_gap\":\"0rem\",\"wrap\":1,\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"color\":\"_content_faded\",\"font-size\":\"0.9rem\"}},\"el_class\":\"\",\"el_id\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\"},\"post_date:1\":{\"format\":\"default\",\"css\":{\"default\":{\"font-size\":\"0.7rem\"}}},\"btn:1\":{\"label\":\"Ler notícia\",\"link\":{\"url\":\"%23\",\"target\":\"\"},\"style\":\"2\",\"icon\":\"fal|arrow-right\",\"iconpos\":\"right\"}},\"default\":{\"layout\":{\"middle_center\":[\"post_image:1\",\"post_title:1\",\"hwrapper:1\",\"btn:1\"],\"hwrapper:1\":[\"post_date:1\"],\"hidden\":[]},\"options\":{\"fixed\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"overflow\":0,\"color_bg\":\"\",\"color_text\":\"\",\"bg_img_source\":\"none\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_file_size\":\"large\",\"bg_img_size\":\"cover\",\"bg_img_position\":\"center center\",\"bg_img_repeat\":\"no-repeat\",\"bg_img_wrapper_end\":\"\",\"border_radius\":0,\"box_shadow\":0,\"box_shadow_hover\":0}}}", "Grid Blog", "", "publish", "closed", "closed", "", "grid-blog", "", "", "2023-02-14 10:43:09", "2023-02-14 10:43:09", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=us_grid_layout&#038;p=13", "0", "us_grid_layout", "", "0");
INSERT INTO `wp_posts` VALUES("14", "1", "2023-02-14 10:41:42", "2023-02-14 10:41:42", "<p>[vc_row][vc_column width=\"1/1\"][us_grid items_layout=\"13\" columns=\"3\"][/vc_column][/vc_row]</p>\r\n", "Exemplo de página", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2023-02-14 10:41:42", "2023-02-14 10:41:42", "", "2", "https://midtemplate.makeitdigital2.tk/?p=14", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("15", "1", "2023-02-14 10:44:17", "2023-02-14 10:44:17", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22background-image%22%3A%2291%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%222rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%222rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%222rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%221rem%22%7D%7D\" el_id=\"contacto\"][vc_column width=\"1/1\"][vc_row_inner content_placement=\"bottom\"][vc_column_inner width=\"3/12\"][us_image image=\"124\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22156px%22%7D%2C%22laptops%22%3A%7B%22width%22%3A%22156px%22%7D%2C%22tablets%22%3A%7B%22width%22%3A%22156px%22%7D%2C%22mobiles%22%3A%7B%22width%22%3A%22106px%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fxpharma-portugal%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fxpharma.movedbyconnections%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fxpharma_movedbyconnections%252F%253Fhl%253Den%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%2C%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"4/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.2%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"]Contactos:[/vc_column_text][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|map-marker-alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]Av. das Robínias, 10\r\n2635-545 Rio de Mouro[/vc_column_text][/us_hwrapper][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|phone\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"tel:00351211350069\">+351 211 350 069</a>\r\n<span style=\"font-size: 0.65rem !important; display: inline-block; color: #fceaf4!important;\">(Chamada para a rede fixa nacional)</span>[/vc_column_text][/us_hwrapper][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|envelope\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"mailto:xpharma@xpharma.pt\" target=\"_blank\" rel=\"noopener\">xpharma@xpharma.pt</a>[/vc_column_text][/us_hwrapper][/vc_column_inner][vc_column_inner width=\"5/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%22.8rem%22%2C%22line-height%22%3A%221.2%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%22.3rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\"]Certificações:[/vc_column_text][us_hwrapper valign=\"middle\" inner_items_gap=\"1.3rem\" link=\"%7B%22url%22%3A%22%22%7D\"][us_image image=\"245\" size=\"full\" link=\"%7B%22url%22%3A%22%2Fcertificados%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22166px%22%7D%7D\"][us_image image=\"392\" size=\"full\" link=\"%7B%22url%22%3A%22%2Fcertificados%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%2265px%22%7D%7D\"][/us_hwrapper][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.55rem%22%2C%22line-height%22%3A%221%22%2C%22letter-spacing%22%3A%221px%22%2C%22margin-top%22%3A%22.6rem%22%7D%7D\"]Copyright [year] © XPharma[/vc_column_text][/vc_column_inner][/vc_row_inner][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][/vc_column][/vc_row]", "Footer PT", "", "publish", "closed", "closed", "", "footer-pt", "", "", "2025-10-13 15:45:21", "2025-10-13 15:45:21", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=us_page_block&#038;p=15", "0", "us_page_block", "", "0");
INSERT INTO `wp_posts` VALUES("16", "1", "2025-10-13 15:43:53", "2025-10-13 15:43:53", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22background-image%22%3A%2291%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%222rem%22%7D%7D\" el_id=\"contacto\"][vc_column width=\"1/1\"][vc_row_inner content_placement=\"bottom\"][vc_column_inner width=\"3/12\"][us_image image=\"124\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22156px%22%7D%2C%22laptops%22%3A%7B%22width%22%3A%22156px%22%7D%2C%22tablets%22%3A%7B%22width%22%3A%22156px%22%7D%2C%22mobiles%22%3A%7B%22width%22%3A%22106px%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.linkedin.com%252Fcompany%252Fxpharma-portugal%252F%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.facebook.com%252Fxpharma.movedbyconnections%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22instagram%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522https%253A%252F%252Fwww.instagram.com%252Fxpharma_movedbyconnections%252F%253Fhl%253Den%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%2C%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"4/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.2%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"]Contactos:[/vc_column_text][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|map-marker-alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]Av. das Robínias, 10<br />\n2635-545 Rio de Mouro[/vc_column_text][/us_hwrapper][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|phone\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"tel:00351211350069\">+351 211 350 069</a><br />\n<span style=\"font-size: 0.65rem !important; display: inline-block; color: #fceaf4!important;\">(Chamada para a rede fixa nacional)</span>[/vc_column_text][/us_hwrapper][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|envelope\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"mailto:xpharma@xpharma.pt\" target=\"_blank\" rel=\"noopener\">xpharma@xpharma.pt</a>[/vc_column_text][/us_hwrapper][/vc_column_inner][vc_column_inner width=\"5/12\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%22.8rem%22%2C%22line-height%22%3A%221.2%22%2C%22margin-top%22%3A%223rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\"]Certificações:[/vc_column_text][us_hwrapper valign=\"middle\" inner_items_gap=\"1.3rem\" link=\"%7B%22url%22%3A%22%22%7D\"][us_image image=\"245\" size=\"full\" link=\"%7B%22url%22%3A%22%2Fcertificados%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22166px%22%7D%7D\"][us_image image=\"392\" size=\"full\" link=\"%7B%22url%22%3A%22%2Fcertificados%2F%22%2C%22target%22%3A%22_blank%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%2265px%22%7D%7D\"][/us_hwrapper][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.55rem%22%2C%22line-height%22%3A%221%22%2C%22letter-spacing%22%3A%221px%22%2C%22margin-top%22%3A%22.6rem%22%7D%7D\"]Copyright [year] © XPharma[/vc_column_text][/vc_column_inner][/vc_row_inner][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][/vc_column][/vc_row]</p>\n", "Footer PT", "", "inherit", "closed", "closed", "", "15-autosave-v1", "", "", "2025-10-13 15:43:53", "2025-10-13 15:43:53", "", "15", "https://midtemplate.makeitdigital2.tk/?p=16", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("17", "1", "2023-02-14 10:46:33", "2023-02-14 10:46:33", "<p>Este Site recolhe alguns Dados Pessoais dos Utilizadores.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Propriet</strong><strong>ário e Controlador de Dados</strong><br />Nome da empresa legal</p>\r\n<p>Morada da empresa</p>\r\n<p>&nbsp;</p>\r\n<p><strong>E-mail de contato do Proprietá</strong><strong>rio:</strong> email de contacto da pessoas de contacto</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Tipos de Dados recolhidos</strong><br />Entre os tipos de Dados Pessoais que este Site recolhe, por si mesmo ou através de terceiros, existem: Nome; Apelido; Número de telefone; Nome da empresa; E-mail; Cookies.</p>\r\n<p>Os detalhes completos dos Dados Pessoais recolhidos são fornecidos nas seções dedicadas desta política de privacidade ou por textos explicativos específicos exibidos antes da recolha dos mesmos.<br />Os Dados Pessoais poderão ser fornecidos voluntariamente pelo Utilizador, ou, no caso dos Dados de Utilização, recolhidos automaticamente ao se utilizar este Site.</p>\r\n<p>A menos que seja especificado que todos os Dados solicitados por este Site são obrigatórios e a falta de fornecimento destes Dados poderá impossibilitar este Site de fornecer os seus Serviços. Nos casos em que este Site afirma especificamente que alguns Dados não são obrigatórios, os Utilizadores não terão de preencher esses Dados e não existirão consequências para a disponibilidade ou o funcionamento do Serviço.</p>\r\n<p>Os Utilizadores que tiverem dúvidas a respeito de quais os Dados Pessoais que são obrigatórios estão convidados a entrar em contato com o Proprietário.<br />Quaisquer usos de cookies – ou de outras ferramentas de rastreamento – por este Site ou pelos proprietários de serviços terceiros utilizados por este Site serão para a finalidade de fornecer os Serviços solicitados pelo Utilizador, além das demais finalidades descritas no presente documento e na Política de Cookies, se estiver disponível.</p>\r\n<p>Os Utilizadores ficam responsáveis por quaisquer Dados Pessoais de terceiros que forem obtidos, publicados ou compartilhados através deste Serviço (este Site) e confirmam que possuem a autorização dos terceiros para fornecerem os Dados para o Proprietário.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Modo e local de processamento dos Dados</strong></p>\r\n<p><br /><strong>M</strong><strong>é</strong><strong>todo de processamento</strong></p>\r\n<p>O Proprietário tomará as medidas de segurança adequadas para impedir o acesso não autorizado, divulgação, alteração ou destruição não autorizada dos Dados.<br />O processamento dos Dados é realizado através de computadores e /ou ferramentas de TI habilitadas, seguindo procedimentos organizacionais e meios estritamente relacionados com os fins indicados. Além do Proprietário, em alguns casos, os Dados podem ser acessados por certos tipos de pessoas encarregadas, envolvidas com a operação deste Serviço (este Site) (administração, vendas, marketing, administração legal do sistema) ou pessoas externas (como fornecedores terceirizados de serviços técnicos, correio, etc) nomeadas, quando necessário, como Processadores de Dados por parte do Proprietário. A lista atualizada destas partes pode ser solicitada ao Proprietário a qualquer momento.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Base jurídica para o processamento</strong><br />O Proprietário poderá processar os Dados Pessoais relacionados ao Utilizador se uma das hipóteses a seguir se aplicar:</p>\r\n<p>Utilizadores que tenham dado a sua aprovação para uma ou mais finalidades específicas; Observação: De acordo com algumas legislações o Proprietário poderá ter a permissão para processar os Dados Pessoais ATÉ QUE O Utilizador faça objeção a isto (“opt-out”), sem ter que se basear em permissão ou em quaisquer outras bases jurídicas a seguir. Isto, contudo, não se aplica sempre que o processamento de Dados Pessoais estiver sujeito à legislação europeia de proteção de dados;<br />– o fornecimento dos Dados for necessário para o cumprimento de um contrato com o Utilizador e/ou quaisquer obrigações pré-contratuais do mesmo;<br />– o processamento for necessário para o cumprimento de uma obrigação jurídica à qual o Proprietário estiver sujeito;<br />– o processamento estiver relacionado a uma tarefa que for executada no interesse público ou no exercício de uma autorização oficial na qual o Proprietário estiver investido;<br />– o processamento for necessário para a finalidade de interesses legítimos perseguidos pelo Proprietário ou por um terceiro;</p>\r\n<p>Em qualquer caso, o Proprietário colaborará de bom grado para esclarecer qual a base jurídica que se aplica ao processamento, e em especial se o fornecimento de Dados for um requisito obrigatório por força de lei ou contratual, ou uma exigência necessária para celebrar um contrato.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Per</strong><strong>íodo de Conservação</strong><br />Os Dados Pessoais serão processados e armazenados por 365 dias.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>As Finalidades do Processamento</strong><br />Os Dados relativos ao Utilizador são recolhidos para permitir que o Proprietário forneça os seus Serviços, bem como para os seguintes propósitos: Contatar o Utilizador; Proteção anti-spam; Acesso a contas de serviços de terceiros; Estatísticas; Salvar e gerir o backup; Comentário de conteúdo; Visualizar conteúdo de plataformas externas; Processamento de pagamentos; Interação com redes sociais e plataformas externas; Gestão de banco de dados de Utilizadores; Interação com plataformas de recolha de dados e outros terceiros; Gestão de endereços de e-mail e envio de mensagens; Registro e autenticação; Gestão de tags e Otimização e distribuição de tráfego.</p>\r\n<p>Os Utilizadores poderão obter informações adicionais detalhadas sobre tais finalidades do processamento e sobre os Dados Pessoais específicos utilizados para cada finalidade nas seções respetivas deste documento.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Permiss</strong><strong>ões do Facebook solicitadas por este Site</strong><br />Este Site pode pedir algumas permissões no Facebook que permitem realizar ações com a conta do Utilizador no Facebook e para recuperar as informações, incluindo dados pessoais. Este serviço permite que este Site se conecte com a conta do Utilizador na rede social Facebook, fornecido pelo Facebook Inc.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Para mais informações sobre as seguintes permissõ</strong><strong>es, consulte a documenta</strong><strong>çã</strong><strong>o de permiss</strong><strong>õ</strong><strong>es Facebook</strong> (https://developers.facebook.com/docs/facebook-login/permissions) e a política de privacidade do Facebook (https://www.facebook.com/about/privacy/).</p>\r\n<p>&nbsp;</p>\r\n<p><strong>As permissões solicitadas são as seguintes:</strong> Aniversário, Contato de e-mail, E-mail e Informações básicas.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Informa</strong><strong>ções detalhadas sobre o processamento de Dados Pessoais</strong><br />Os Dados Pessoais são recolhidos para os seguintes fins e utilizando os seguintes serviços:</p>\r\n<p>&nbsp;</p>\r\n<p>Acesso a contas de serviços de terceiros<br />Este tipo de serviço permite a este serviço (este Site) acessar os Dados da sua conta com um serviço terceiro e realizar ações com os mesmos.<br />Estes serviços não são ativados automaticamente, precisam de autorização explícita do Usuário.</p>\r\n<p>&nbsp;</p>\r\n<p>Acesso à conta Facebook (este Site)<br />Este serviço permite que este Site se conecte com a conta do Usuário na rede social Facebook, fornecido pelo Facebook, Inc.</p>\r\n<p>Pedido de Permissão: Aniversário; Contato de e-mail; E-mail.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.facebook.com/policy.php).<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>Comentário de conteúdo<br />O serviço de comentários de conteúdo permite aos Utilizadores criar e publicar comentários sobre o conteúdo deste serviço (este Site).<br />Dependendo das configurações escolhidas pelo Proprietário, os Utilizadores podem também deixar comentários anónimos. Se houver um endereço de e-mail entre os Dados Pessoais fornecidos pelo Utilizador, poderá ser usado para enviar notificações de comentários sobre o mesmo conteúdo. Os Utilizadores são responsáveis pelo conteúdo dos seus comentários.<br />Se um serviço de comentários de conteúdo prestado por terceiros estiver instalado, este ainda poderá recolher dados de tráfego da web para as páginas onde o serviço de comentário estiver instalado, mesmo quando os Utilizadores não utilizam o serviço de conteúdo de comentários.</p>\r\n<p>&nbsp;</p>\r\n<p>Sistema de Comentários gerido diretamente (este Site)<br />Este Site tem o seu próprio sistema de comentários de conteúdo interno.</p>\r\n<p>Dados Pessoais recolhidos: Cookie; E-mail; Nome; Nome de Utilizador; Apelido; Website.</p>\r\n<p>&nbsp;</p>\r\n<p>Contactar o Utilizador<br />Formulário de contacto (este Site)<br />Ao preencherem o formulário de contacto com os seus Dados, os Utilizadores autorizam este Site a utilizar esses detalhes para responder a pedidos de informações, cotação ou qualquer outro tipo de pedido como indicado pelo título do formulário.</p>\r\n<p>Dados Pessoais recolhidos: Nome, E-mail; Nome da empresa; Número de telefone.</p>\r\n<p>&nbsp;</p>\r\n<p>Lista de endereçamento ou boletim informativo (este Site)<br />Ao registar-se na lista de endereçamento ou no boletim informativo, o endereço de e-mail do Utilizador será adicionado à lista de contactos daqueles que podem receber mensagens de e-mail que contenham informações de natureza comercial ou promocional sobre este Site. O seu endereço de e-mail também poderá ser adicionado a esta lista, como resultado da sua inscrição neste serviço (este Site) ou após a realização de uma compra.</p>\r\n<p>Dados Pessoais recolhidos: E-mail; Nome; Apelido.</p>\r\n<p>&nbsp;</p>\r\n<p>Telefone de contato (este Site)<br />Os Utilizadores que forneceram o número de telefone poderão ser contactados para fins comerciais ou promocionais relacionadas com este Site, bem como para o cumprimento de pedidos de suporte.</p>\r\n<p>Dados Pessoais recolhidos: Número de telefone.</p>\r\n<p>&nbsp;</p>\r\n<p>Estatísticas<br />Os serviços presentes nesta seção habilitam o Proprietário a monitorar e analisar o tráfego da web e podem ser utilizados para rastrear o comportamento do Utilizador.</p>\r\n<p>&nbsp;</p>\r\n<p>Google Analytics (Google Inc.)<br />O Google Analytics é um serviço de análise da Internet fornecido pela Google, dependendo do local a partir do qual este Site for acedido, (“Google”). O Google utiliza os dados recolhidos para acompanhar e analisar o uso deste serviço (este Site) para preparar relatórios sobre atividades e compartilhá-los com outros serviços do Google.<br />O Google pode utilizar os dados recolhidos para contextualizar e personalizar os anúncios da sua própria rede de publicidade.</p>\r\n<p>Dados Pessoais recolhidos: Cookie; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.facebook.com/policy.php ) – Opt (https://policies.google.com/privacy?hl=pt) Out.<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>WordPress Stat (Automattic Inc.)<br />WordPress é um serviço de análise fornecido pela Automattic Inc.</p>\r\n<p>Dados Pessoais recolhidos: Cookie; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://automattic.com/privacy/).</p>\r\n<p>&nbsp;</p>\r\n<p>Gestão do banco de dados dos Utilizadores<br />Esses tipos de serviços permitem que o Proprietário crie perfis de Utilizador a partir de um endereço de e-mail, um nome pessoal, ou outras informações que o Utilizador forneceu a este Site, como também o rastreamento de atividades do Utilizador por meio de recursos analíticos. Estes Dados Pessoais podem também ser combinados com informações publicamente disponíveis sobre o Utilizador (como perfis de redes sociais) e utilizado para construir perfis privados que o Proprietário pode exibir e usar para melhorar o serviço (este Site).<br />Alguns desses serviços podem também ser habilitados para enviar mensagens programadas ao Utilizador tais como emails baseados em ações realizadas neste serviço (este Site).</p>\r\n<p>&nbsp;</p>\r\n<p>Gestão de endereços de e-mail e envio de mensagens<br />Esses tipos de serviços permitem a gestão da base de dados de contatos de e-mail, telefones ou outra informação de contacto para efeitos de comunicação com o Utilizador.<br />Estes serviços também podem ser utilizados para recolher dados referentes à data e o horário em que o Utilizador visualizou o e-mail; e também quando o Utilizador interagiu com o e-mail recebido, como por exemplo, quando o Utilizador selecionou os links incluídos no e-mail.</p>\r\n<p>&nbsp;</p>\r\n<p>Mailchimp (The Rocket Science Group, LLC.)<br />Mailchimp é a gestão de endereços de e-mail e envio de mensagem de serviço prestado por The Rocket Science Group LLC.</p>\r\n<p>Dados Pessoais recolhidos: e-mail.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://mailchimp.com/legal/privacy/).<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>Gestão de tags<br />Este tipo de serviço ajuda o Proprietário a gerir as tags ou scripts necessitados por este Site de forma centralizada. Em consequência disto os Dados do Utilizador fluem através destes serviços e há possibilidade de retenção destes Dados.</p>\r\n<p>&nbsp;</p>\r\n<p>Google Tag Manager (Google)<br />O Google Tag Manager é um serviço de gestão fornecido pela Google, dependendo do local a partir do qual este Site for acedido.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://policies.google.com/privacy?hl=pt).<br />Participante do Privacy Shield.</p>\r\n<p>Interação com plataformas de recolha de dados e outros terceiros<br />Esses tipos de serviços permitem que os Utilizadores interajam com plataformas de recolha de dados ou outros serviços diretamente a partir das páginas deste serviço (este Site) com o objetivo de salvar e reutilizar dados.</p>\r\n<p><br />Se um desses serviços estiver instalado, este poderá recolher Dados de Uso e de navegação nas páginas onde foram instalados, mesmo que os Utilizadores não utilizem o serviço ativamente.</p>\r\n<p>&nbsp;</p>\r\n<p>Interação com redes sociais e plataformas externas<br />Estes tipos de serviços permitem a interação com as redes sociais ou outras plataformas externas diretamente a partir das páginas deste serviço (este Site).<br />A interação e as informações obtidas por este Site estão sempre sujeitas às configurações de privacidade do Utilizador em cada rede social.<br />Este tipo de serviço pode ainda recolher dados de tráfego para as páginas onde o serviço estiver instalado, mesmo quando os Utilizadores não o utilizarem.<br />Recomenda-se sair dos respetivos serviços de forma a garantir que os dados processados neste serviço (este Site) não estejam a ser conectados de volta ao perfil do Utilizador.</p>\r\n<p>&nbsp;</p>\r\n<p>O botão de Gostar e os Widgets sociais do Facebook (Facebook, Inc.)<br />O botão de Gostar do Facebook e os Widgets sociais são serviços que permitem a interação com a rede social Facebook fornecido pela Facebook, Inc.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.facebook.com/privacy/explanation).<br />Participante do Privacy Shield.</p>\r\n<p>O botão +1 e Widgets sociais do Google+ (Google Inc.)<br />O botão +1 e Widgets sociais do Google+ são serviços que permitem a interação com a rede social Google+ fornecido pelo Google, dependendo do local a partir do qual este Site for acedido.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://policies.google.com/privacy?hl=pt-PT).<br />Participante do Privacy Shield.</p>\r\n<p>O botão e os widgets sociais do LinkedIn (LinkedIn Corporation)<br />O botão e os widgets sociais do LinkedIn são serviços que permitem a interação com a rede social LinkedIn fornecido pelo LinkedIn Corporation.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.linkedin.com/legal/privacy-policy).<br />Participante do Privacy Shield.</p>\r\n<p>O botão e os widgets sociais do YouTube (Google Inc.)<br />O botão e os widgets sociais do YouTube são serviços que permitem a interação com a rede social YouTube fornecido pela Google, dependendo do local a partir do qual este Site for acedido.</p>\r\n<p>Dados Pessoais recolhidos: Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://policies.google.com/privacy?hl=pt).<br />Participante do Privacy Shield.</p>\r\n<p>Otimização e distribuição de tráfego<br />Esses tipos de serviços permitem a este Site distribuir o conteúdo deles utilizando servidores localizados em países diferentes, de forma a otimizar o seu desempenho.<br />Alguns Dados Pessoais são processados e dependem das características e da forma como esses serviços são implementados. A sua função é a de filtrar as comunicações entre este Site e o navegador do Utilizador.<br />Considerando a distribuição generalizada deste sistema, é difícil determinar os locais, para os quais os conteúdos, que possam conter informações pessoais do Utilizador, foram transferidos.</p>\r\n<p>&nbsp;</p>\r\n<p>Google reCAPTCHA (Google Inc.)<br />Google reCAPTCHA é um serviço de proteção de SPAM fornecido pelo Google ou pela Google, dependendo do local a partir do qual este Site for acedido.<br />O uso do reCAPTCHA está sujeito à política de privacidade (https://policies.google.com/privacy?hl=pt-BR) e aos termos de utilização (https://policies.google.com/terms?hl=pt-BR) da Google.</p>\r\n<p>Dados Pessoais recolhidos: Cookies; Dados de utilização.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://policies.google.com/privacy?hl=pt-PT).<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>Registro e autenticação<br />Ao registrar ou autenticar, os Utilizadores permitem a este serviço (este Site) identificá-los e dar-lhes o acesso a serviços dedicados. Dependendo do que estiver descrito abaixo, os serviços de registro e autenticação podem ser fornecidos por terceiros. Neste caso, este Site poderá aceder a alguns Dados armazenados por estes serviços de terceiros para fins de registro ou identificação.</p>\r\n<p>&nbsp;</p>\r\n<p>Facebook Authentication (Facebook, Inc.)<br />O Facebook Authentication é um serviço de registro e autenticação fornecido pelo Facebook, Inc. e está conectado à rede social Facebook.</p>\r\n<p>Dados Pessoais recolhidos: vários tipos de Dados como especificados na política de privacidade do serviço.</p>\r\n<p>Lugar de processamento: EUA – Política de Privacidade (https://www.facebook.com/help/405977429438260).<br />Participante do Privacy Shield.</p>\r\n<p>&nbsp;</p>\r\n<p>Salvar e gerir o backup<br />Esses tipos de serviços permitem que o Proprietário salve e gira os backups deste serviço (este Site) em servidores externos geridos pelo próprio prestador do serviço. Os backups podem incluir o código fonte e conteúdo, bem como os dados que o Utilizador fornece a este Site.</p>\r\n<p>Visualizar o conteúdo de plataformas externas<br />Esses tipos de serviços permitem que o Utilizador visualize e interage com o conteúdo presente em plataformas externas diretamente das páginas deste serviço (este Site). Se esse tipo de serviço estiver instalado poderá recolher os dados de tráfego da web para as páginas onde o mesmo estiver instalado, até quando os Utilizadores não os estão a utilizar.</p>\r\n<p>Os direitos dos Utilizadores<br />Os Utilizadores poderão exercer determinados direitos a respeito dos seus Dados processados pelo Proprietário.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Em especial, os Utilizadores têm direitos, tais como:</strong></p>\r\n<p>Retirar a sua aprovação a qualquer momento. Os Utilizadores têm o direito de retirar a sua aprovação nos casos em que tenham dado a sua aprovação anteriormente para o processamento dos seus Dados Pessoais.<br />Recusar o processamento dos seus Dados. Os Utilizadores têm o direito de recusar o processamento dos seus Dados se o processamento for executado sobre outra base jurídica que não a aprovação. São fornecidos detalhes adicionais na seção específica abaixo.<br />Aceder aos seus Dados. Os Utilizadores têm o direito de saber se os seus Dados estão a ser processados pelo Proprietário, obter revelações sobre determinados aspetos do processamento e conseguir uma cópia dos Dados que estão em processo.<br />Verificar e pedir correção. Os Utilizadores têm o direito de verificar a exatidão dos seus Dados e pedir eventuais atualizações ou correções.<br />Restringir o processamento dos seus Dados. Os Utilizadores têm o direito de, sob determinadas circunstâncias, restringir o processamento dos seus Dados para qualquer outra finalidade que não seja o armazenamento dos mesmos.<br />Apagar os Dados Pessoais ou retirá-los de outra maneira. Os Utilizadores têm o direito de, sob determinadas circunstâncias, obter a eliminação dos seus Dados do Proprietário.<br />Receber os seus Dados e ter os mesmos que foram transferidos para outro controlador. Os Utilizadores têm o direito de receber os seus Dados num formato estruturado, utilizado comumente e apto a ser lido por máquinas e, se for viável tecnicamente, fazer com que os mesmos sejam transmitidos para outro controlador sem nenhum problema. Esta determinação condiciona que os Dados sejam processados por meios automatizados e que o processamento esteja baseado na aprovação do Utilizador, num contrato do qual o Utilizador seja uma das partes ou por obrigações pré-contratuais do mesmo.<br />Registrar uma reclamação. Os Utilizadores têm o direito de apresentar uma reclamação perante a sua autoridade de proteção de dados competente.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Detalhes sobre o direito de recusar o processamento</strong><br />Nos casos em que os Dados Pessoais forem processados por um interesse público, no exercício de uma autorização oficial na qual o Proprietário estiver investido ou para finalidades dos interesses legítimos perseguidos pelo Proprietário, os Utilizadores poderão recusar o processamento através do fornecimento de um motivo relacionado com a sua situação em especial para justificar a recusa.</p>\r\n<p>Os Utilizadores devem saber que caso os seus Dados Pessoais sejam processados para finalidades de marketing, poderão recusar o processamento a qualquer momento sem fornecer nenhuma justificação. Os Utilizadores podem consultar as seções respetivas deste documento.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Como exercer estes direitos</strong><br />Quaisquer pedidos para exercer os direitos dos Utilizadores podem ser direcionados ao Proprietário através dos dados para contacto fornecidos neste documento. Estes pedidos podem ser exercidos sem nenhum custo e serão atendidos pelo Proprietário com a maior brevidade possível e em todos os casos em prazo inferior a um mês.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Informa</strong><strong>ções adicionais sobre a coleta e processamento de Dados</strong><br /><strong>Ação jurí</strong><strong>dica</strong><br />Os Dados Pessoais dos Utilizadores podem ser utilizados para fins jurídicos pelo Proprietário em questão ou nas etapas conducentes à possível ação jurídica decorrente de uma utilização indevida deste Serviço (este Site) ou dos Serviços relacionados. O Utilizador declara estar ciente de que o Proprietário poderá ser obrigado a revelar os Dados Pessoais mediante solicitação das autoridades governamentais.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Informa</strong><strong>ções adicionais sobre os Dados Pessoais do Utilizador</strong><br />Além das informações contidas nesta política de privacidade, este Site poderá fornecer ao Utilizador informações adicionais e contextuais sobre os serviços específicos ou a recolha do processamento de Dados Pessoais mediante solicitação.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Logs do sistema e manutenção</strong><br />Para fins de sistema e manutenção, este Site e quaisquer serviços de terceiros poderão recolher arquivos que guardam a interação com este Site (logs do sistema) ou utilizar outros Dados Pessoais (tais como endereço IP) para esta finalidade.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Mudanças nesta política de privacidade</strong><br />O Proprietário reserva o direito de fazer alterações nesta política de privacidade a qualquer momento, mediante comunicação aos seus Utilizadores nesta página e possivelmente dentro deste Serviço, este Site e/ou – na medida em que for viável tecnicamente e juridicamente – enviando um aviso aos Utilizadores através de quaisquer informações de contacto disponíveis para o Proprietário. É altamente recomendável que esta página seja consultada várias vezes em relação à última modificação descrita na parte inferior.</p>\r\n<p>Caso as mudanças afetem as atividades de processamento realizadas com base na aprovação do Utilizador, o Proprietário recolherá a nova aprovação do Utilizador, onde for exigida.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Defini</strong><strong>ções e referências jurídicas</strong><br /><strong>Dados Pessoais (ou Dados)</strong><br />Quaisquer informações que diretamente, indiretamente ou em relação com outras informações – incluindo um número de identificação pessoal – permitam a identificação ou identificabilidade de uma pessoa física.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Dados de Utilização</strong><br />As informações recolhidas automaticamente através deste este Site (ou serviços de terceiros contratados neste Serviço), que podem incluir: os endereços IP ou nomes de domínio dos computadores utilizados pelos Utilizadores que utilizam este Site, os endereços URI (Identificador Uniforme de Recurso), a data e hora do pedido, o método utilizado para submeter o pedido ao servidor, o tamanho do arquivo recebido em resposta, o código numérico que indica o status do servidor de resposta (resultado positivo, erro , etc.), o país de origem, as características do navegador e do sistema operacional utilizado pelo Utilizador, os vários detalhes de tempo por visita (por exemplo, o tempo gasto em cada página dentro do aplicativo) e os detalhes sobre o caminho seguido dentro da aplicação, com especial referência à sequência de páginas visitadas e outros parâmetros sobre o sistema operacional do dispositivo e/ou ambiente de TI do Utilizador.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Utilizador</strong><br />A pessoa que utiliza este Site que, a menos que especificado diferentemente, coincida com o Titular dos Dados.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Titular dos Dados</strong><br />A pessoa física a quem os Dados Pessoais se referem.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Processador de Dados (ou supervisor de Dados)</strong><br />A pessoa física ou jurídica, administração pública, agência ou outro órgão que processe os Dados Pessoais em nome do Controlador conforme descrito nesta política de privacidade.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Controlador de Dados (ou proprietá</strong><strong>rio)</strong><br />A pessoa física ou jurídica, administração pública, agência ou outro órgão que, isoladamente ou em conjunto com outros determinar as finalidades e os meios de processamento dos Dados Pessoais, incluindo medidas de segurança relativas ao funcionamento e à utilização deste Serviço (este Site). O Controlador de Dados, a menos que seja especificado de outra forma, é o Proprietário deste Serviço (este Site).</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Este Site (ou este Aplicativo)</strong><br />O meio pelo qual os Dados Pessoais do Utilizador são recolhidos e processados.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Serviço</strong><br />O serviço fornecido por este Site conforme descrito nos termos relativos (se disponíveis) e neste site/aplicativo.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>União Europeia (ou UE)</strong><br />A menos que especificado diferentemente, todas as referências feitas neste documento à União Europeia incluem todos os atuais estados membros da União Europeia e do Espaço Econômico Europeu.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Cookies</strong><br />Pequenas unidades de dados armazenados no dispositivo do Utilizador.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Informa</strong><strong>ção jurí</strong><strong>dica</strong><br />Esta declaração de privacidade foi preparada com base em determinações de múltiplas legislações, inclusive os Arts. 13/14 do Regulamento (EU) 2016/679 (GDPR – Regulamento Geral de Proteção de Dados).</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Última atualizaçã</strong><strong>o: </strong><strong>26</strong><strong> de </strong><strong>maio de 2022</strong></p>", "Política de privacidade", "", "inherit", "closed", "closed", "", "3-revision-v1", "", "", "2023-02-14 10:46:33", "2023-02-14 10:46:33", "", "3", "https://midtemplate.makeitdigital2.tk/?p=17", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("18", "1", "2023-02-14 14:49:01", "0000-00-00 00:00:00", "Thank you for reading this post, don\'t forget to subscribe!", "Display a message after the 1st paragraph of posts", "", "draft", "closed", "closed", "", "", "", "", "2023-02-14 14:49:01", "0000-00-00 00:00:00", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=wpcode&p=18", "0", "wpcode", "", "0");
INSERT INTO `wp_posts` VALUES("19", "1", "2023-02-14 14:49:01", "0000-00-00 00:00:00", "add_action(\'admin_init\', function () {\r\n    // Redirect any user trying to access comments page\r\n    global $pagenow;\r\n    \r\n    if ($pagenow === \'edit-comments.php\') {\r\n        wp_safe_redirect(admin_url());\r\n        exit;\r\n    }\r\n\r\n    // Remove comments metabox from dashboard\r\n    remove_meta_box(\'dashboard_recent_comments\', \'dashboard\', \'normal\');\r\n\r\n    // Disable support for comments and trackbacks in post types\r\n    foreach (get_post_types() as $post_type) {\r\n        if (post_type_supports($post_type, \'comments\')) {\r\n            remove_post_type_support($post_type, \'comments\');\r\n            remove_post_type_support($post_type, \'trackbacks\');\r\n        }\r\n    }\r\n});\r\n\r\n// Close comments on the front-end\r\nadd_filter(\'comments_open\', \'__return_false\', 20, 2);\r\nadd_filter(\'pings_open\', \'__return_false\', 20, 2);\r\n\r\n// Hide existing comments\r\nadd_filter(\'comments_array\', \'__return_empty_array\', 10, 2);\r\n\r\n// Remove comments page in menu\r\nadd_action(\'admin_menu\', function () {\r\n    remove_menu_page(\'edit-comments.php\');\r\n});\r\n\r\n// Remove comments links from admin bar\r\nadd_action(\'init\', function () {\r\n    if (is_admin_bar_showing()) {\r\n        remove_action(\'admin_bar_menu\', \'wp_admin_bar_comments_menu\', 60);\r\n    }\r\n});", "Completely Disable Comments", "", "draft", "closed", "closed", "", "", "", "", "2023-02-14 14:49:01", "0000-00-00 00:00:00", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=wpcode&p=19", "0", "wpcode", "", "0");
INSERT INTO `wp_posts` VALUES("20", "1", "2023-02-14 15:24:41", "2023-02-14 15:24:41", "<p>[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Voltar às Notícias\" link=\"%7B%22url%22%3A%22%2Fnoticias-e-casos-de-sucesso-doorwin%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outras notícias\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]</p>\r\n", "Blog single", "", "publish", "closed", "closed", "", "blog-single", "", "", "2024-11-26 17:52:11", "2024-11-26 17:52:11", "", "0", "https://midtemplate.makeitdigital2.tk/?post_type=us_content_template&#038;p=20", "0", "us_content_template", "", "0");
INSERT INTO `wp_posts` VALUES("21", "1", "2023-02-14 15:25:04", "2023-02-14 15:25:04", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/1\"][us_grid items_quantity=\"12\" items_layout=\"13\" columns=\"3\" items_gap=\"1rem\"][/vc_column][/vc_row]</p>\r\n", "Notícias", "", "publish", "closed", "closed", "", "noticias", "", "", "2023-02-14 15:40:48", "2023-02-14 15:40:48", "", "0", "https://midtemplate.makeitdigital2.tk/?page_id=21", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("22", "1", "2023-02-14 15:25:04", "2023-02-14 15:25:04", "", "Notícias", "", "inherit", "closed", "closed", "", "21-revision-v1", "", "", "2023-02-14 15:25:04", "2023-02-14 15:25:04", "", "21", "https://midtemplate.makeitdigital2.tk/?p=22", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("23", "1", "2023-02-14 15:40:48", "2023-02-14 15:40:48", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/1\"][us_grid items_quantity=\"12\" items_layout=\"13\" columns=\"3\" items_gap=\"1rem\"][/vc_column][/vc_row]</p>\r\n", "Notícias", "", "inherit", "closed", "closed", "", "21-revision-v1", "", "", "2023-02-14 15:40:48", "2023-02-14 15:40:48", "", "21", "https://midtemplate.makeitdigital2.tk/?p=23", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("29", "1", "2024-02-27 17:03:00", "2024-02-27 17:03:00", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/1\"][us_grid items_quantity=\"12\" items_layout=\"13\" columns=\"3\" items_gap=\"1rem\"][us_image][/vc_column][/vc_row]</p>\n", "Notícias", "", "inherit", "closed", "closed", "", "21-autosave-v1", "", "", "2024-02-27 17:03:00", "2024-02-27 17:03:00", "", "21", "https://xpharma.digitalpath.pt/xpharma/?p=29", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("31", "1", "2024-11-21 19:09:54", "2024-11-21 19:09:54", "", "logo", "", "inherit", "", "closed", "", "logo", "", "", "2024-11-21 19:09:54", "2024-11-21 19:09:54", "", "12", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2023/02/logo.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("32", "1", "2024-11-21 19:10:45", "2024-11-21 19:10:45", "", "Contactos", "", "publish", "closed", "closed", "", "contactos", "", "", "2024-11-21 19:10:45", "2024-11-21 19:10:45", "", "0", "https://xpharma.digitalpath.pt/xpharma/?page_id=32", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("33", "1", "2024-11-21 19:10:45", "2024-11-21 19:10:45", "", "Contactos", "", "inherit", "closed", "closed", "", "32-revision-v1", "", "", "2024-11-21 19:10:45", "2024-11-21 19:10:45", "", "32", "https://xpharma.digitalpath.pt/xpharma/?p=33", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("34", "1", "2024-11-21 19:12:04", "2024-11-21 19:12:04", "", "logo-02", "", "inherit", "", "closed", "", "logo-02", "", "", "2024-11-21 19:12:04", "2024-11-21 19:12:04", "", "15", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2023/02/logo-02.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("35", "1", "2024-11-21 19:13:16", "2024-11-21 19:13:16", "[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23263b61%22%2C%22padding-top%22%3A%224rem%22%2C%22padding-bottom%22%3A%224rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"3/12\"][us_image image=\"34\" align=\"left\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%22220px%22%7D%7D\"][us_text text=\"Siga-nos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_socials items=\"%5B%7B%22type%22%3A%22facebook%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522%2523%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%2C%7B%22type%22%3A%22linkedin%22%2C%22url%22%3A%22%257B%2522url%2522%253A%2522%2523%2522%252C%2522target%2522%253A%2522_blank%2522%257D%22%2C%22icon%22%3A%22fab%7Capple%22%2C%22title%22%3A%22T%C3%ADtulo%22%2C%22color%22%3A%22_content_faded%22%7D%5D\" shape=\"none\" icons_color=\"text\" gap=\"0.4em\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.2rem%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"4/12\"][us_text text=\"Contactos\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|map-marker-alt\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221.2rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]fdsffgfdgd\r\nfgdfgdfgdffdgd[/vc_column_text][/us_hwrapper][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|phone\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"tel:00351000000000\">(+351) 000 000 000</a>\r\n<span style=\"font-size: 0.65rem !important; display: inline-block; color: #edf5fd !important;\">(Chamada para a rede fixa nacional)</span>[/vc_column_text][/us_hwrapper][us_hwrapper inner_items_gap=\"0.5rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%220.7rem%22%7D%7D\"][us_text text=\"\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fas|envelope\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_bg_alt%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%221rem%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%224px%22%7D%7D\"]<a style=\"color: #fff !important;\" href=\"mailto:geral@mail.pt\" target=\"_blank\" rel=\"noopener\">geral@mail.pt</a>[/vc_column_text][/us_hwrapper][/vc_column_inner][vc_column_inner width=\"5/12\"][us_text text=\"Receba a nossa newsletter\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_bg_alt%22%2C%22text-align%22%3A%22left%22%2C%22font-size%22%3A%220.75rem%22%2C%22line-height%22%3A%220.9rem%22%2C%22letter-spacing%22%3A%222px%22%2C%22font-weight%22%3A%22600%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-bottom%22%3A%220.7rem%22%7D%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%230a1c3b%22%2C%22padding-top%22%3A%220.7rem%22%2C%22padding-bottom%22%3A%220.7rem%22%7D%7D\"][vc_column width=\"1/1\"][us_hwrapper alignment=\"left\" inner_items_gap=\"1.20rem\" hide_on_states=\"mobiles\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]|[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_hwrapper][us_vwrapper alignment=\"center\" inner_items_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%220.6rem%22%2C%22padding-bottom%22%3A%220.6rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]Copyright [year] ©[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_border%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%221px%22%7D%7D\"]<a style=\"color: #ddd !important;\" href=\"/politica-privacidade/\">Política de Privacidade</a>[/vc_column_text][/us_vwrapper][/vc_column][/vc_row]", "Footer PT", "", "inherit", "closed", "closed", "", "15-revision-v1", "", "", "2024-11-21 19:13:16", "2024-11-21 19:13:16", "", "15", "https://xpharma.digitalpath.pt/xpharma/?p=35", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("36", "1", "2024-11-21 19:28:37", "2024-11-21 19:28:37", "<p>[vc_row width=\"full\"][vc_column width=\"1/1\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" autoplay=\"1\" autoplay_timeout=\"5s\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"12px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\"][vc_column width=\"1/1\"][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokeverde\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokegrey\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokeverdecenter\"][us_separator][/vc_column][/vc_row]</p>\r\n", "Homepage", "", "publish", "closed", "closed", "", "homepage", "", "", "2024-11-21 19:31:40", "2024-11-21 19:31:40", "", "0", "https://xpharma.digitalpath.pt/xpharma/?page_id=36", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("37", "1", "2024-11-21 19:28:37", "2024-11-21 19:28:37", "", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-11-21 19:28:37", "2024-11-21 19:28:37", "", "36", "https://xpharma.digitalpath.pt/xpharma/?p=37", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("38", "1", "2024-11-21 19:29:05", "2024-11-21 19:29:05", "a:35:{s:9:\"post_type\";s:13:\"slide-carross\";s:22:\"advanced_configuration\";b:1;s:13:\"import_source\";s:0:\"\";s:11:\"import_date\";s:0:\"\";s:6:\"labels\";a:33:{s:4:\"name\";s:6:\"Slides\";s:13:\"singular_name\";s:5:\"Slide\";s:9:\"menu_name\";s:6:\"Slides\";s:9:\"all_items\";s:15:\"Todos os Slides\";s:9:\"edit_item\";s:12:\"Editar Slide\";s:9:\"view_item\";s:9:\"Ver Slide\";s:10:\"view_items\";s:10:\"Ver Slides\";s:12:\"add_new_item\";s:20:\"Adicionar novo Slide\";s:7:\"add_new\";s:20:\"Adicionar novo Slide\";s:8:\"new_item\";s:10:\"Novo Slide\";s:17:\"parent_item_colon\";s:15:\"Slide superior:\";s:12:\"search_items\";s:15:\"Pesquisa Slides\";s:9:\"not_found\";s:24:\"Nenhum slides encontrado\";s:18:\"not_found_in_trash\";s:32:\"Nenhum slides encontrado no lixo\";s:8:\"archives\";s:16:\"Arquivo de Slide\";s:10:\"attributes\";s:18:\"Atributos de Slide\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:16:\"insert_into_item\";s:16:\"Inserir em slide\";s:21:\"uploaded_to_this_item\";s:26:\"Carregados para este slide\";s:17:\"filter_items_list\";s:23:\"Filtrar lista de slides\";s:14:\"filter_by_date\";s:23:\"Filtrar slides por data\";s:21:\"items_list_navigation\";s:30:\"Navegação da lista de Slides\";s:10:\"items_list\";s:15:\"Lista de Slides\";s:14:\"item_published\";s:16:\"Slide publicado.\";s:24:\"item_published_privately\";s:27:\"Slide publicado em privado.\";s:22:\"item_reverted_to_draft\";s:30:\"Slide revertido para rascunho.\";s:14:\"item_scheduled\";s:15:\"Slide agendado.\";s:12:\"item_updated\";s:18:\"Slide actualizado.\";s:9:\"item_link\";s:18:\"Ligação de Slide\";s:21:\"item_link_description\";s:28:\"Uma ligação para um slide.\";}s:11:\"description\";s:0:\"\";s:6:\"public\";b:1;s:12:\"hierarchical\";b:1;s:19:\"exclude_from_search\";b:0;s:18:\"publicly_queryable\";b:1;s:7:\"show_ui\";b:1;s:12:\"show_in_menu\";b:1;s:17:\"admin_menu_parent\";s:0:\"\";s:17:\"show_in_admin_bar\";b:1;s:17:\"show_in_nav_menus\";b:1;s:12:\"show_in_rest\";b:1;s:9:\"rest_base\";s:0:\"\";s:14:\"rest_namespace\";s:5:\"wp/v2\";s:21:\"rest_controller_class\";s:24:\"WP_REST_Posts_Controller\";s:13:\"menu_position\";i:2;s:9:\"menu_icon\";a:2:{s:4:\"type\";s:9:\"dashicons\";s:5:\"value\";s:31:\"dashicons-image-flip-horizontal\";}s:19:\"rename_capabilities\";b:0;s:24:\"singular_capability_name\";s:4:\"post\";s:22:\"plural_capability_name\";s:5:\"posts\";s:8:\"supports\";a:4:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";i:3;s:13:\"custom-fields\";}s:10:\"taxonomies\";s:0:\"\";s:11:\"has_archive\";b:0;s:16:\"has_archive_slug\";s:0:\"\";s:7:\"rewrite\";a:4:{s:17:\"permalink_rewrite\";s:13:\"post_type_key\";s:10:\"with_front\";s:1:\"1\";s:5:\"feeds\";s:1:\"0\";s:5:\"pages\";s:1:\"1\";}s:9:\"query_var\";s:13:\"post_type_key\";s:14:\"query_var_name\";s:0:\"\";s:10:\"can_export\";b:1;s:16:\"delete_with_user\";b:0;s:20:\"register_meta_box_cb\";s:0:\"\";s:16:\"enter_title_here\";s:0:\"\";}", "Slides", "slides", "publish", "closed", "closed", "", "post_type_673f89ed47a7d", "", "", "2024-11-21 19:29:05", "2024-11-21 19:29:05", "", "0", "https://xpharma.digitalpath.pt/xpharma/?post_type=acf-post-type&#038;p=38", "0", "acf-post-type", "", "0");
INSERT INTO `wp_posts` VALUES("39", "1", "2024-11-21 19:29:27", "2024-11-21 19:29:27", "[vc_row width=\"full\" columns_gap=\"0rem\" content_placement=\"bottom\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22496%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\" pb_type=\"matrix\" pb_min_speedx=\".5\" pb_max_speedx=\".5\" pb_min_speedy=\".5\" pb_max_speedy=\"1.5\" pb_directionx=\"center\" pb_directiony=\"center\" pb_particle_density=\"15000\" pb_dot_color=\"#FFFFFF30\" pb_line_color=\"#FFFFFF30\" pb_particle_radius=\"7\" pb_line_width=\".5\"][vc_column link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22min-height%22%3A%2280vh%22%7D%2C%22laptops%22%3A%7B%22min-height%22%3A%2280vh%22%7D%2C%22tablets%22%3A%7B%22min-height%22%3A%2280vh%22%7D%2C%22mobiles%22%3A%7B%22min-height%22%3A%2270vh%22%7D%7D\" width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%2242vh%22%7D%7D\"][vc_row_inner columns_gap=\"0rem\" content_placement=\"bottom\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/1\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%223.4rem%22%2C%22line-height%22%3A%221%22%2C%22font-weight%22%3A%22200%22%2C%22animation-name%22%3A%22aft%22%2C%22animation-delay%22%3A%22250ms%22%7D%7D\"]Moved by connections[/vc_column_text][/vc_column_inner][/vc_row_inner][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%226vh%22%7D%7D\"][/vc_column][/vc_row][vc_row us_bg_image_source=\"media\" us_bg_image=\"106\" us_bg_size=\"initial\" us_bg_pos=\"bottom left\" us_bg_repeat=\"no-repeat\" columns_gap=\"0rem\" content_placement=\"bottom\" disable_element=\"yes\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22104%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%2235vh%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%223.2rem%22%2C%22line-height%22%3A%221.1%22%2C%22font-weight%22%3A%22200%22%7D%7D\"]Moved by\r\nconnections[/vc_column_text][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row]", "Slide 1", "", "publish", "closed", "closed", "", "slide-1", "", "", "2025-10-13 15:14:55", "2025-10-13 15:14:55", "", "0", "https://xpharma.digitalpath.pt/xpharma/?post_type=slide-carross&#038;p=39", "0", "slide-carross", "", "0");
INSERT INTO `wp_posts` VALUES("40", "1", "2024-11-21 19:29:37", "2024-11-21 19:29:37", "", "DoorWin_img-1b", "", "inherit", "", "closed", "", "doorwin_img-1b", "", "", "2024-11-21 19:29:37", "2024-11-21 19:29:37", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2024/11/DoorWin_img-1b.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("41", "1", "2024-11-21 19:30:44", "2024-11-21 19:30:44", "[vc_row width=\"full\"][vc_column width=\"1/1\"][us_carousel post_type=\"slide-carrossel\" items_quantity=\"4\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" autoplay=\"1\" autoplay_timeout=\"5s\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"12px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\"][vc_column width=\"1/1\"][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokeverde\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokegrey\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokeverdecenter\"][us_separator][/vc_column][/vc_row]", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-11-21 19:30:44", "2024-11-21 19:30:44", "", "36", "https://xpharma.digitalpath.pt/xpharma/?p=41", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("42", "1", "2024-11-21 19:31:29", "2024-11-21 19:31:29", "<p>[vc_row width=\"full\"][vc_column width=\"1/1\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" autoplay=\"1\" autoplay_timeout=\"5s\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"12px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row height=\"huge\"][vc_column width=\"1/1\"][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokeverde\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokegrey\"][us_separator][us_text link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokeverdecenter\"][us_separator][/vc_column][/vc_row]</p>\r\n", "Homepage", "", "inherit", "closed", "closed", "", "36-revision-v1", "", "", "2024-11-21 19:31:29", "2024-11-21 19:31:29", "", "36", "https://xpharma.digitalpath.pt/xpharma/?p=42", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("43", "1", "2024-11-22 17:42:14", "2024-11-22 17:42:14", "", "woocommerce-placeholder", "", "inherit", "", "closed", "", "woocommerce-placeholder", "", "", "2024-11-22 17:42:14", "2024-11-22 17:42:14", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2024/11/woocommerce-placeholder.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("44", "1", "2024-11-22 17:42:15", "2024-11-22 17:42:15", "", "Loja", "", "trash", "closed", "closed", "", "loja__trashed", "", "", "2025-09-15 14:30:25", "2025-09-15 14:30:25", "", "0", "https://xpharma.digitalpath.pt/xpharma/loja/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("45", "1", "2024-11-22 17:42:15", "2024-11-22 17:42:15", "<!-- wp:woocommerce/cart -->\n<div class=\"wp-block-woocommerce-cart alignwide is-loading\"><!-- wp:woocommerce/filled-cart-block -->\n<div class=\"wp-block-woocommerce-filled-cart-block\"><!-- wp:woocommerce/cart-items-block -->\n<div class=\"wp-block-woocommerce-cart-items-block\"><!-- wp:woocommerce/cart-line-items-block -->\n<div class=\"wp-block-woocommerce-cart-line-items-block\"></div>\n<!-- /wp:woocommerce/cart-line-items-block -->\n\n<!-- wp:woocommerce/cart-cross-sells-block -->\n<div class=\"wp-block-woocommerce-cart-cross-sells-block\"><!-- wp:heading {\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">Pode estar interessado em…</h2>\n<!-- /wp:heading -->\n\n<!-- wp:woocommerce/cart-cross-sells-products-block -->\n<div class=\"wp-block-woocommerce-cart-cross-sells-products-block\"></div>\n<!-- /wp:woocommerce/cart-cross-sells-products-block --></div>\n<!-- /wp:woocommerce/cart-cross-sells-block --></div>\n<!-- /wp:woocommerce/cart-items-block -->\n\n<!-- wp:woocommerce/cart-totals-block -->\n<div class=\"wp-block-woocommerce-cart-totals-block\"><!-- wp:woocommerce/cart-order-summary-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-block\"><!-- wp:woocommerce/cart-order-summary-heading-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-heading-block\"></div>\n<!-- /wp:woocommerce/cart-order-summary-heading-block -->\n\n<!-- wp:woocommerce/cart-order-summary-coupon-form-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-coupon-form-block\"></div>\n<!-- /wp:woocommerce/cart-order-summary-coupon-form-block -->\n\n<!-- wp:woocommerce/cart-order-summary-subtotal-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-subtotal-block\"></div>\n<!-- /wp:woocommerce/cart-order-summary-subtotal-block -->\n\n<!-- wp:woocommerce/cart-order-summary-fee-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-fee-block\"></div>\n<!-- /wp:woocommerce/cart-order-summary-fee-block -->\n\n<!-- wp:woocommerce/cart-order-summary-discount-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-discount-block\"></div>\n<!-- /wp:woocommerce/cart-order-summary-discount-block -->\n\n<!-- wp:woocommerce/cart-order-summary-shipping-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-shipping-block\"></div>\n<!-- /wp:woocommerce/cart-order-summary-shipping-block -->\n\n<!-- wp:woocommerce/cart-order-summary-taxes-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-taxes-block\"></div>\n<!-- /wp:woocommerce/cart-order-summary-taxes-block --></div>\n<!-- /wp:woocommerce/cart-order-summary-block -->\n\n<!-- wp:woocommerce/cart-express-payment-block -->\n<div class=\"wp-block-woocommerce-cart-express-payment-block\"></div>\n<!-- /wp:woocommerce/cart-express-payment-block -->\n\n<!-- wp:woocommerce/proceed-to-checkout-block -->\n<div class=\"wp-block-woocommerce-proceed-to-checkout-block\"></div>\n<!-- /wp:woocommerce/proceed-to-checkout-block -->\n\n<!-- wp:woocommerce/cart-accepted-payment-methods-block -->\n<div class=\"wp-block-woocommerce-cart-accepted-payment-methods-block\"></div>\n<!-- /wp:woocommerce/cart-accepted-payment-methods-block --></div>\n<!-- /wp:woocommerce/cart-totals-block --></div>\n<!-- /wp:woocommerce/filled-cart-block -->\n\n<!-- wp:woocommerce/empty-cart-block -->\n<div class=\"wp-block-woocommerce-empty-cart-block\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"with-empty-cart-icon wc-block-cart__empty-cart__title\"} -->\n<h2 class=\"wp-block-heading has-text-align-center with-empty-cart-icon wc-block-cart__empty-cart__title\">O seu carrinho está vazio!</h2>\n<!-- /wp:heading -->\n\n<!-- wp:separator {\"className\":\"is-style-dots\"} -->\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-dots\"/>\n<!-- /wp:separator -->\n\n<!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"wp-block-heading has-text-align-center\">Novo na loja</h2>\n<!-- /wp:heading -->\n\n<!-- wp:woocommerce/product-new {\"columns\":4,\"rows\":1} /--></div>\n<!-- /wp:woocommerce/empty-cart-block --></div>\n<!-- /wp:woocommerce/cart -->", "Carrinho", "", "trash", "closed", "closed", "", "carrinho__trashed", "", "", "2025-09-15 14:30:25", "2025-09-15 14:30:25", "", "0", "https://xpharma.digitalpath.pt/xpharma/carrinho/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("46", "1", "2024-11-22 17:42:15", "2024-11-22 17:42:15", "<!-- wp:woocommerce/checkout -->\n<div class=\"wp-block-woocommerce-checkout alignwide wc-block-checkout is-loading\"><!-- wp:woocommerce/checkout-fields-block -->\n<div class=\"wp-block-woocommerce-checkout-fields-block\"><!-- wp:woocommerce/checkout-express-payment-block -->\n<div class=\"wp-block-woocommerce-checkout-express-payment-block\"></div>\n<!-- /wp:woocommerce/checkout-express-payment-block -->\n\n<!-- wp:woocommerce/checkout-contact-information-block -->\n<div class=\"wp-block-woocommerce-checkout-contact-information-block\"></div>\n<!-- /wp:woocommerce/checkout-contact-information-block -->\n\n<!-- wp:woocommerce/checkout-shipping-method-block -->\n<div class=\"wp-block-woocommerce-checkout-shipping-method-block\"></div>\n<!-- /wp:woocommerce/checkout-shipping-method-block -->\n\n<!-- wp:woocommerce/checkout-pickup-options-block -->\n<div class=\"wp-block-woocommerce-checkout-pickup-options-block\"></div>\n<!-- /wp:woocommerce/checkout-pickup-options-block -->\n\n<!-- wp:woocommerce/checkout-shipping-address-block -->\n<div class=\"wp-block-woocommerce-checkout-shipping-address-block\"></div>\n<!-- /wp:woocommerce/checkout-shipping-address-block -->\n\n<!-- wp:woocommerce/checkout-billing-address-block -->\n<div class=\"wp-block-woocommerce-checkout-billing-address-block\"></div>\n<!-- /wp:woocommerce/checkout-billing-address-block -->\n\n<!-- wp:woocommerce/checkout-shipping-methods-block -->\n<div class=\"wp-block-woocommerce-checkout-shipping-methods-block\"></div>\n<!-- /wp:woocommerce/checkout-shipping-methods-block -->\n\n<!-- wp:woocommerce/checkout-payment-block -->\n<div class=\"wp-block-woocommerce-checkout-payment-block\"></div>\n<!-- /wp:woocommerce/checkout-payment-block -->\n\n<!-- wp:woocommerce/checkout-additional-information-block -->\n<div class=\"wp-block-woocommerce-checkout-additional-information-block\"></div>\n<!-- /wp:woocommerce/checkout-additional-information-block -->\n\n<!-- wp:woocommerce/checkout-order-note-block -->\n<div class=\"wp-block-woocommerce-checkout-order-note-block\"></div>\n<!-- /wp:woocommerce/checkout-order-note-block -->\n\n<!-- wp:woocommerce/checkout-terms-block -->\n<div class=\"wp-block-woocommerce-checkout-terms-block\"></div>\n<!-- /wp:woocommerce/checkout-terms-block -->\n\n<!-- wp:woocommerce/checkout-actions-block -->\n<div class=\"wp-block-woocommerce-checkout-actions-block\"></div>\n<!-- /wp:woocommerce/checkout-actions-block --></div>\n<!-- /wp:woocommerce/checkout-fields-block -->\n\n<!-- wp:woocommerce/checkout-totals-block -->\n<div class=\"wp-block-woocommerce-checkout-totals-block\"><!-- wp:woocommerce/checkout-order-summary-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-block\"><!-- wp:woocommerce/checkout-order-summary-cart-items-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-cart-items-block\"></div>\n<!-- /wp:woocommerce/checkout-order-summary-cart-items-block -->\n\n<!-- wp:woocommerce/checkout-order-summary-coupon-form-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-coupon-form-block\"></div>\n<!-- /wp:woocommerce/checkout-order-summary-coupon-form-block -->\n\n<!-- wp:woocommerce/checkout-order-summary-subtotal-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-subtotal-block\"></div>\n<!-- /wp:woocommerce/checkout-order-summary-subtotal-block -->\n\n<!-- wp:woocommerce/checkout-order-summary-fee-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-fee-block\"></div>\n<!-- /wp:woocommerce/checkout-order-summary-fee-block -->\n\n<!-- wp:woocommerce/checkout-order-summary-discount-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-discount-block\"></div>\n<!-- /wp:woocommerce/checkout-order-summary-discount-block -->\n\n<!-- wp:woocommerce/checkout-order-summary-shipping-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-shipping-block\"></div>\n<!-- /wp:woocommerce/checkout-order-summary-shipping-block -->\n\n<!-- wp:woocommerce/checkout-order-summary-taxes-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-taxes-block\"></div>\n<!-- /wp:woocommerce/checkout-order-summary-taxes-block --></div>\n<!-- /wp:woocommerce/checkout-order-summary-block --></div>\n<!-- /wp:woocommerce/checkout-totals-block --></div>\n<!-- /wp:woocommerce/checkout -->", "Finalizar compras", "", "trash", "closed", "closed", "", "finalizar-compra__trashed", "", "", "2025-09-15 14:30:25", "2025-09-15 14:30:25", "", "0", "https://xpharma.digitalpath.pt/xpharma/finalizar-compra/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("47", "1", "2024-11-22 17:42:15", "2024-11-22 17:42:15", "<!-- wp:shortcode -->[woocommerce_my_account]<!-- /wp:shortcode -->", "A minha conta", "", "trash", "closed", "closed", "", "minha-conta__trashed", "", "", "2025-09-15 14:30:25", "2025-09-15 14:30:25", "", "0", "https://xpharma.digitalpath.pt/xpharma/minha-conta/", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("48", "1", "2025-09-15 14:30:25", "2025-09-15 14:30:25", "<!-- wp:paragraph -->\n<p><b>This is a sample page.</b></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Overview</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Our refund and returns policy lasts 30 days. If 30 days have passed since your purchase, we can’t offer you a full refund or exchange.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>To be eligible for a return, your item must be unused and in the same condition that you received it. It must also be in the original packaging.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Several types of goods are exempt from being returned. Perishable goods such as food, flowers, newspapers or magazines cannot be returned. We also do not accept products that are intimate or sanitary goods, hazardous materials, or flammable liquids or gases.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Additional non-returnable items:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul>\n<li>Gift cards</li>\n<li>Downloadable software products</li>\n<li>Some health and personal care items</li>\n</ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>To complete your return, we require a receipt or proof of purchase.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Please do not send your purchase back to the manufacturer.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>There are certain situations where only partial refunds are granted:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul>\n<li>Book with obvious signs of use</li>\n<li>CD, DVD, VHS tape, software, video game, cassette tape, or vinyl record that has been opened.</li>\n<li>Any item not in its original condition, is damaged or missing parts for reasons not due to our error.</li>\n<li>Any item that is returned more than 30 days after delivery</li>\n</ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<h2>Refunds</h2>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Once your return is received and inspected, we will send you an email to notify you that we have received your returned item. We will also notify you of the approval or rejection of your refund.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If you are approved, then your refund will be processed, and a credit will automatically be applied to your credit card or original method of payment, within a certain amount of days.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h3 class=\"wp-block-heading\">Late or missing refunds</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>If you haven’t received a refund yet, first check your bank account again.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Then contact your credit card company, it may take some time before your refund is officially posted.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Next contact your bank. There is often some processing time before a refund is posted.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If you’ve done all of this and you still have not received your refund yet, please contact us at {email address}.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h3 class=\"wp-block-heading\">Sale items</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Only regular priced items may be refunded. Sale items cannot be refunded.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<h2>Exchanges</h2>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We only replace items if they are defective or damaged. If you need to exchange it for the same item, send us an email at {email address} and send your item to: {physical address}.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<h2>Gifts</h2>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If the item was marked as a gift when purchased and shipped directly to you, you’ll receive a gift credit for the value of your return. Once the returned item is received, a gift certificate will be mailed to you.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If the item wasn’t marked as a gift when purchased, or the gift giver had the order shipped to themselves to give to you later, we will send a refund to the gift giver and they will find out about your return.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<h2>Shipping returns</h2>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>To return your product, you should mail your product to: {physical address}.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>You will be responsible for paying for your own shipping costs for returning your item. Shipping costs are non-refundable. If you receive a refund, the cost of return shipping will be deducted from your refund.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Depending on where you live, the time it may take for your exchanged product to reach you may vary.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If you are returning more expensive items, you may consider using a trackable shipping service or purchasing shipping insurance. We don’t guarantee that we will receive your returned item.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<h2>Need help?</h2>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Contact us at {email} for questions related to refunds and returns.</p>\n<!-- /wp:paragraph -->", "Política de devolução e reembolso", "", "trash", "closed", "closed", "", "refund_returns__trashed", "", "", "2025-09-15 14:30:25", "2025-09-15 14:30:25", "", "0", "https://xpharma.digitalpath.pt/xpharma/?page_id=48", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("49", "1", "2024-11-22 17:42:57", "2024-11-22 17:42:57", "<!-- wp:woocommerce/cart -->\n<div class=\"wp-block-woocommerce-cart alignwide is-loading\"><!-- wp:woocommerce/filled-cart-block -->\n<div class=\"wp-block-woocommerce-filled-cart-block\"><!-- wp:woocommerce/cart-items-block -->\n<div class=\"wp-block-woocommerce-cart-items-block\"><!-- wp:woocommerce/cart-line-items-block -->\n<div class=\"wp-block-woocommerce-cart-line-items-block\"></div>\n<!-- /wp:woocommerce/cart-line-items-block -->\n\n<!-- wp:woocommerce/cart-cross-sells-block -->\n<div class=\"wp-block-woocommerce-cart-cross-sells-block\"><!-- wp:heading {\"fontSize\":\"large\"} -->\n<h2 class=\"wp-block-heading has-large-font-size\">Pode estar interessado em…</h2>\n<!-- /wp:heading -->\n\n<!-- wp:woocommerce/cart-cross-sells-products-block -->\n<div class=\"wp-block-woocommerce-cart-cross-sells-products-block\"></div>\n<!-- /wp:woocommerce/cart-cross-sells-products-block --></div>\n<!-- /wp:woocommerce/cart-cross-sells-block --></div>\n<!-- /wp:woocommerce/cart-items-block -->\n\n<!-- wp:woocommerce/cart-totals-block -->\n<div class=\"wp-block-woocommerce-cart-totals-block\"><!-- wp:woocommerce/cart-order-summary-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-block\"><!-- wp:woocommerce/cart-order-summary-heading-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-heading-block\"></div>\n<!-- /wp:woocommerce/cart-order-summary-heading-block -->\n\n<!-- wp:woocommerce/cart-order-summary-coupon-form-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-coupon-form-block\"></div>\n<!-- /wp:woocommerce/cart-order-summary-coupon-form-block -->\n\n<!-- wp:woocommerce/cart-order-summary-subtotal-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-subtotal-block\"></div>\n<!-- /wp:woocommerce/cart-order-summary-subtotal-block -->\n\n<!-- wp:woocommerce/cart-order-summary-fee-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-fee-block\"></div>\n<!-- /wp:woocommerce/cart-order-summary-fee-block -->\n\n<!-- wp:woocommerce/cart-order-summary-discount-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-discount-block\"></div>\n<!-- /wp:woocommerce/cart-order-summary-discount-block -->\n\n<!-- wp:woocommerce/cart-order-summary-shipping-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-shipping-block\"></div>\n<!-- /wp:woocommerce/cart-order-summary-shipping-block -->\n\n<!-- wp:woocommerce/cart-order-summary-taxes-block -->\n<div class=\"wp-block-woocommerce-cart-order-summary-taxes-block\"></div>\n<!-- /wp:woocommerce/cart-order-summary-taxes-block --></div>\n<!-- /wp:woocommerce/cart-order-summary-block -->\n\n<!-- wp:woocommerce/cart-express-payment-block -->\n<div class=\"wp-block-woocommerce-cart-express-payment-block\"></div>\n<!-- /wp:woocommerce/cart-express-payment-block -->\n\n<!-- wp:woocommerce/proceed-to-checkout-block -->\n<div class=\"wp-block-woocommerce-proceed-to-checkout-block\"></div>\n<!-- /wp:woocommerce/proceed-to-checkout-block -->\n\n<!-- wp:woocommerce/cart-accepted-payment-methods-block -->\n<div class=\"wp-block-woocommerce-cart-accepted-payment-methods-block\"></div>\n<!-- /wp:woocommerce/cart-accepted-payment-methods-block --></div>\n<!-- /wp:woocommerce/cart-totals-block --></div>\n<!-- /wp:woocommerce/filled-cart-block -->\n\n<!-- wp:woocommerce/empty-cart-block -->\n<div class=\"wp-block-woocommerce-empty-cart-block\"><!-- wp:heading {\"textAlign\":\"center\",\"className\":\"with-empty-cart-icon wc-block-cart__empty-cart__title\"} -->\n<h2 class=\"wp-block-heading has-text-align-center with-empty-cart-icon wc-block-cart__empty-cart__title\">O seu carrinho está vazio!</h2>\n<!-- /wp:heading -->\n\n<!-- wp:separator {\"className\":\"is-style-dots\"} -->\n<hr class=\"wp-block-separator has-alpha-channel-opacity is-style-dots\"/>\n<!-- /wp:separator -->\n\n<!-- wp:heading {\"textAlign\":\"center\"} -->\n<h2 class=\"wp-block-heading has-text-align-center\">Novo na loja</h2>\n<!-- /wp:heading -->\n\n<!-- wp:woocommerce/product-new {\"columns\":4,\"rows\":1} /--></div>\n<!-- /wp:woocommerce/empty-cart-block --></div>\n<!-- /wp:woocommerce/cart -->", "Carrinho", "", "inherit", "closed", "closed", "", "45-revision-v1", "", "", "2024-11-22 17:42:57", "2024-11-22 17:42:57", "", "45", "https://xpharma.digitalpath.pt/xpharma/?p=49", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("50", "1", "2024-11-22 17:43:49", "2024-11-22 17:43:49", "a:29:{s:8:\"taxonomy\";s:13:\"marca-produto\";s:11:\"object_type\";a:1:{i:0;s:7:\"product\";}s:22:\"advanced_configuration\";i:1;s:13:\"import_source\";s:0:\"\";s:11:\"import_date\";s:0:\"\";s:6:\"labels\";a:25:{s:4:\"name\";s:17:\"Marcas de Produto\";s:13:\"singular_name\";s:16:\"Marca de Produto\";s:9:\"menu_name\";s:17:\"Marcas de Produto\";s:9:\"all_items\";s:26:\"Todos os Marcas de Produto\";s:9:\"edit_item\";s:23:\"Editar Marca de Produto\";s:9:\"view_item\";s:20:\"Ver Marca de Produto\";s:11:\"update_item\";s:27:\"Actualizar Marca de Produto\";s:12:\"add_new_item\";s:31:\"Adicionar novo Marca de Produto\";s:13:\"new_item_name\";s:29:\"Nome do novo Marca de Produto\";s:12:\"search_items\";s:26:\"Pesquisa Marcas de Produto\";s:13:\"popular_items\";s:32:\"Marcas de Produto mais populares\";s:26:\"separate_items_with_commas\";s:39:\"Separar marcas de produto por vírgulas\";s:19:\"add_or_remove_items\";s:38:\"Adicionar ou remover marcas de produto\";s:21:\"choose_from_most_used\";s:52:\"Escolher entre marcas de produto mais utilizados(as)\";s:9:\"most_used\";s:0:\"\";s:9:\"not_found\";s:35:\"Nenhum marcas de produto encontrado\";s:8:\"no_terms\";s:24:\"Nenhum marcas de produto\";s:22:\"name_field_description\";s:0:\"\";s:22:\"slug_field_description\";s:0:\"\";s:22:\"desc_field_description\";s:0:\"\";s:21:\"items_list_navigation\";s:41:\"Navegação da lista de Marcas de Produto\";s:10:\"items_list\";s:26:\"Lista de Marcas de Produto\";s:13:\"back_to_items\";s:29:\"← Ir para marcas de produto\";s:9:\"item_link\";s:29:\"Ligação de Marca de Produto\";s:21:\"item_link_description\";s:38:\"Uma ligação para um marca de produto\";}s:11:\"description\";s:0:\"\";s:12:\"capabilities\";a:4:{s:12:\"manage_terms\";s:17:\"manage_categories\";s:10:\"edit_terms\";s:17:\"manage_categories\";s:12:\"delete_terms\";s:17:\"manage_categories\";s:12:\"assign_terms\";s:10:\"edit_posts\";}s:6:\"public\";i:1;s:18:\"publicly_queryable\";i:1;s:12:\"hierarchical\";i:0;s:7:\"show_ui\";i:1;s:12:\"show_in_menu\";i:1;s:17:\"show_in_nav_menus\";i:1;s:12:\"show_in_rest\";i:1;s:9:\"rest_base\";s:0:\"\";s:14:\"rest_namespace\";s:5:\"wp/v2\";s:21:\"rest_controller_class\";s:24:\"WP_REST_Terms_Controller\";s:13:\"show_tagcloud\";i:1;s:18:\"show_in_quick_edit\";i:1;s:17:\"show_admin_column\";i:0;s:7:\"rewrite\";a:3:{s:17:\"permalink_rewrite\";s:12:\"taxonomy_key\";s:10:\"with_front\";s:1:\"1\";s:20:\"rewrite_hierarchical\";s:1:\"0\";}s:9:\"query_var\";s:13:\"post_type_key\";s:14:\"query_var_name\";s:0:\"\";s:12:\"default_term\";a:1:{s:20:\"default_term_enabled\";s:1:\"0\";}s:4:\"sort\";i:0;s:8:\"meta_box\";s:7:\"default\";s:11:\"meta_box_cb\";s:0:\"\";s:20:\"meta_box_sanitize_cb\";s:0:\"\";}", "Marcas de Produto", "marcas-de-produto", "publish", "closed", "closed", "", "taxonomy_6740c2bd61b09", "", "", "2024-11-22 17:43:49", "2024-11-22 17:43:49", "", "0", "https://xpharma.digitalpath.pt/xpharma/?post_type=acf-taxonomy&#038;p=50", "0", "acf-taxonomy", "", "0");
INSERT INTO `wp_posts` VALUES("51", "1", "2024-11-22 17:44:57", "2024-11-22 17:44:57", "a:8:{s:8:\"location\";a:1:{i:0;a:1:{i:0;a:3:{s:5:\"param\";s:8:\"taxonomy\";s:8:\"operator\";s:2:\"==\";s:5:\"value\";s:13:\"marca-produto\";}}}s:8:\"position\";s:6:\"normal\";s:5:\"style\";s:7:\"default\";s:15:\"label_placement\";s:3:\"top\";s:21:\"instruction_placement\";s:5:\"label\";s:14:\"hide_on_screen\";s:0:\"\";s:11:\"description\";s:0:\"\";s:12:\"show_in_rest\";i:0;}", "Detalhes de Marca", "detalhes-de-marca", "publish", "closed", "closed", "", "group_6740c2e180d93", "", "", "2024-11-22 17:44:57", "2024-11-22 17:44:57", "", "0", "https://xpharma.digitalpath.pt/xpharma/?post_type=acf-field-group&#038;p=51", "0", "acf-field-group", "", "0");
INSERT INTO `wp_posts` VALUES("52", "1", "2024-11-22 17:44:57", "2024-11-22 17:44:57", "a:17:{s:10:\"aria-label\";s:0:\"\";s:4:\"type\";s:5:\"image\";s:12:\"instructions\";s:0:\"\";s:8:\"required\";i:0;s:17:\"conditional_logic\";i:0;s:7:\"wrapper\";a:3:{s:5:\"width\";s:0:\"\";s:5:\"class\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:13:\"return_format\";s:5:\"array\";s:7:\"library\";s:3:\"all\";s:9:\"min_width\";s:0:\"\";s:10:\"min_height\";s:0:\"\";s:8:\"min_size\";s:0:\"\";s:9:\"max_width\";s:0:\"\";s:10:\"max_height\";s:0:\"\";s:8:\"max_size\";s:0:\"\";s:10:\"mime_types\";s:0:\"\";s:17:\"allow_in_bindings\";i:0;s:12:\"preview_size\";s:6:\"medium\";}", "Logo da Marca", "logo_marca", "publish", "closed", "closed", "", "field_6740c2e10e785", "", "", "2024-11-22 17:44:57", "2024-11-22 17:44:57", "", "51", "https://xpharma.digitalpath.pt/xpharma/?post_type=acf-field&p=52", "0", "acf-field", "", "0");
INSERT INTO `wp_posts` VALUES("53", "1", "2024-11-22 17:45:12", "2024-11-22 17:45:12", "{\"data\":{\"image:1\":{\"img\":\"{{logo_marca}}\",\"image\":\"\",\"has_ratio\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"disable_lazy_loading\":0,\"meta\":0,\"meta_style\":\"simple\",\"align\":\"none\",\"style\":\"\",\"size\":\"medium\",\"img_transparent\":\"\",\"link\":\"%7B%22type%22%3A%22post%22%7D\",\"heading_1\":\"\",\"height_default\":\"35px\",\"height_laptops\":\"30px\",\"height_tablets\":\"25px\",\"height_mobiles\":\"20px\",\"heading_2\":\"\",\"height_sticky\":\"35px\",\"height_sticky_laptops\":\"30px\",\"height_sticky_tablets\":\"25px\",\"height_sticky_mobiles\":\"20px\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":\"\",\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\",\"animate\":\"\",\"animate_delay\":\"\",\"link_new_tab\":\"\",\"onclick\":\"\",\"onclick_code\":\"\"}},\"default\":{\"options\":{\"fixed\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"overflow\":0,\"color_bg\":\"\",\"color_text\":\"\",\"ignore_us_tile_colors\":0,\"bg_img_source\":\"none\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_file_size\":\"large\",\"bg_img_size\":\"cover\",\"bg_img_position\":\"center center\",\"bg_img_repeat\":\"no-repeat\",\"bg_img_wrapper_end\":\"\",\"border_radius\":0,\"box_shadow\":0,\"box_shadow_hover\":0,\"el_class\":\"\"},\"layout\":{\"hidden\":[],\"middle_center\":[\"image:1\"]}}}", "Marcas - Carrossel", "", "publish", "closed", "closed", "", "marcas-carrossel", "", "", "2024-11-22 17:45:54", "2024-11-22 17:45:54", "", "0", "https://xpharma.digitalpath.pt/xpharma/?post_type=us_grid_layout&#038;p=53", "0", "us_grid_layout", "", "0");
INSERT INTO `wp_posts` VALUES("54", "1", "2024-11-22 17:46:07", "2024-11-22 17:46:07", "{\"data\":{\"post_image:1\":{\"conditions\":[]},\"post_taxonomy:1\":{\"taxonomy_name\":\"marca-produto\",\"conditions\":[]},\"html:1\":{\"content\":\"JTVCbG9nb19tYXJjYSU1RA==\",\"conditions\":[]}},\"default\":{\"options\":{\"fixed\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"overflow\":0,\"color_bg\":\"\",\"color_text\":\"\",\"ignore_us_tile_colors\":0,\"bg_img_source\":\"none\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_file_size\":\"large\",\"bg_img_size\":\"cover\",\"bg_img_position\":\"center center\",\"bg_img_repeat\":\"no-repeat\",\"bg_img_wrapper_end\":\"\",\"border_radius\":0,\"box_shadow\":0,\"box_shadow_hover\":0,\"el_class\":\"\"},\"layout\":{\"hidden\":[],\"middle_center\":[\"post_image:1\",\"post_taxonomy:1\",\"html:1\"]}}}", "Teste 1", "", "publish", "closed", "closed", "", "teste-1", "", "", "2024-11-22 17:47:19", "2024-11-22 17:47:19", "", "0", "https://xpharma.digitalpath.pt/xpharma/?post_type=us_grid_layout&#038;p=54", "0", "us_grid_layout", "", "0");
INSERT INTO `wp_posts` VALUES("55", "1", "2024-11-22 18:17:06", "2024-11-22 18:17:06", "[vc_row css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][vc_column width=\"1/1\"][us_breadcrumbs css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_link%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.75rem%22%7D%7D\"][/vc_column][/vc_row][vc_row][vc_column sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"5/12\"][us_product_gallery][/vc_column][vc_column width=\"7/12\"][us_post_taxonomy taxonomy_name=\"product_cat\" link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_link%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.75rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_primary%22%2C%22font-size%22%3A%222.3rem%22%2C%22line-height%22%3A%222.5rem%22%2C%22font-weight%22%3A%22500%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][us_post_taxonomy taxonomy_name=\"marca-produto\" link=\"%7B%22type%22%3A%22archive%22%7D\" text_before=\"Marca:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.8rem%22%7D%7D\" el_class=\"atrantes\"][us_post_custom_field key=\"custom\" custom_key=\"_sku\" link=\"%7B%22url%22%3A%22%22%7D\" text_before=\"REF:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.8rem%22%2C%22margin-top%22%3A%226px%22%7D%7D\" el_class=\"atrantes\"][us_text text=\"Descrição\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%220.3em%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222.5rem%22%2C%22margin-bottom%22%3A%221.5rem%22%7D%7D\" el_class=\"titlestrokeverde\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%220.9rem%22%2C%22line-height%22%3A%221.3rem%22%7D%7D\"][us_hwrapper valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%2C%22padding-top%22%3A%221.2rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%221px%22%2C%22border-color%22%3A%22%23d4d4d4%22%7D%7D\"][us_text text=\"Partilhar:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.85rem%22%2C%22letter-spacing%22%3A%220.16em%22%2C%22font-weight%22%3A%22400%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\"][us_sharing providers=\"email,facebook,twitter,whatsapp\" color=\"primary\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23757575%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.85rem%22%2C%22letter-spacing%22%3A%220.2em%22%7D%7D\"][/us_hwrapper][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%226rem%22%7D%7D\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22100px%22%7D%7D\"][us_text text=\"Outros produtos que lhe podem interessar\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.1rem%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokeverdecenter\"][us_carousel post_type=\"related\" related_taxonomy=\"product_cat\" related_post_type=\"product\" orderby=\"rand\" items_quantity=\"16\" items_layout=\"189\" items_gap=\"1.2rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"4\" arrows=\"1\" arrows_size=\"1rem\" arrows_offset=\"15px\" dots=\"1\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%223rem%22%7D%7D\"][/vc_column][/vc_row]", "Product Single", "", "publish", "closed", "closed", "", "product-single", "", "", "2024-11-22 18:17:26", "2024-11-22 18:17:26", "", "0", "https://xpharma.digitalpath.pt/xpharma/?post_type=us_content_template&#038;p=55", "0", "us_content_template", "", "0");
INSERT INTO `wp_posts` VALUES("56", "1", "2024-11-22 18:17:06", "2024-11-22 18:17:06", "", "Page Template 2", "", "inherit", "closed", "closed", "", "55-revision-v1", "", "", "2024-11-22 18:17:06", "2024-11-22 18:17:06", "", "55", "https://xpharma.digitalpath.pt/xpharma/?p=56", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("57", "1", "2024-11-22 18:17:26", "2024-11-22 18:17:26", "[vc_row css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][vc_column width=\"1/1\"][us_breadcrumbs css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_link%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.75rem%22%7D%7D\"][/vc_column][/vc_row][vc_row][vc_column sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"5/12\"][us_product_gallery][/vc_column][vc_column width=\"7/12\"][us_post_taxonomy taxonomy_name=\"product_cat\" link=\"%7B%22type%22%3A%22archive%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_link%22%2C%22font-size%22%3A%220.65rem%22%2C%22line-height%22%3A%220.75rem%22%2C%22letter-spacing%22%3A%221px%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_primary%22%2C%22font-size%22%3A%222.3rem%22%2C%22line-height%22%3A%222.5rem%22%2C%22font-weight%22%3A%22500%22%2C%22margin-top%22%3A%221.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][us_post_taxonomy taxonomy_name=\"marca-produto\" link=\"%7B%22type%22%3A%22archive%22%7D\" text_before=\"Marca:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.8rem%22%7D%7D\" el_class=\"atrantes\"][us_post_custom_field key=\"custom\" custom_key=\"_sku\" link=\"%7B%22url%22%3A%22%22%7D\" text_before=\"REF:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.8rem%22%2C%22margin-top%22%3A%226px%22%7D%7D\" el_class=\"atrantes\"][us_text text=\"Descrição\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%220.85rem%22%2C%22line-height%22%3A%221rem%22%2C%22letter-spacing%22%3A%220.3em%22%2C%22font-weight%22%3A%22800%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%222.5rem%22%2C%22margin-bottom%22%3A%221.5rem%22%7D%7D\" el_class=\"titlestrokeverde\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%220.9rem%22%2C%22line-height%22%3A%221.3rem%22%7D%7D\"][us_hwrapper valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%2C%22padding-top%22%3A%221.2rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%221px%22%2C%22border-color%22%3A%22%23d4d4d4%22%7D%7D\"][us_text text=\"Partilhar:\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.85rem%22%2C%22letter-spacing%22%3A%220.16em%22%2C%22font-weight%22%3A%22400%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\"][us_sharing providers=\"email,facebook,twitter,whatsapp\" color=\"primary\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22%23757575%22%2C%22font-size%22%3A%220.7rem%22%2C%22line-height%22%3A%220.85rem%22%2C%22letter-spacing%22%3A%220.2em%22%7D%7D\"][/us_hwrapper][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%226rem%22%7D%7D\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22100px%22%7D%7D\"][us_text text=\"Outros produtos que lhe podem interessar\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%221.1rem%22%2C%22letter-spacing%22%3A%220.06em%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%7D%7D\" el_class=\"titlestrokeverdecenter\"][us_carousel post_type=\"related\" related_taxonomy=\"product_cat\" related_post_type=\"product\" orderby=\"rand\" items_quantity=\"16\" items_layout=\"189\" items_gap=\"1.2rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"4\" arrows=\"1\" arrows_size=\"1rem\" arrows_offset=\"15px\" dots=\"1\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%223rem%22%7D%7D\"][/vc_column][/vc_row]", "Product Single", "", "inherit", "closed", "closed", "", "55-revision-v1", "", "", "2024-11-22 18:17:26", "2024-11-22 18:17:26", "", "55", "https://xpharma.digitalpath.pt/xpharma/?p=57", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("58", "1", "2024-11-22 18:20:29", "2024-11-22 18:20:29", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"1/5\"][us_grid_filter filter_items=\"%5B%7B%22source%22%3A%22tax%7Cproduct_cat%22%2C%22ui_type%22%3A%22checkbox%22%2C%22min_value%22%3A%220%22%2C%22step_size%22%3A%221%22%2C%22show_all_value%22%3A%221%22%2C%22show_amount%22%3A%220%22%2C%22label%22%3A%22CATEGORIAS%3A%22%2C%22show_color_swatch%22%3A%220%22%2C%22hide_color_swatch_label%22%3A%220%22%7D%5D\" layout=\"ver\" values_max_height=\"80vh\" mobile_button_label=\"Filtros\" mobile_button_icon=\"fal|plus\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%220.8rem%22%2C%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%220.5rem%22%2C%22padding-bottom%22%3A%220.5rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%221px%22%2C%22border-bottom-width%22%3A%221px%22%7D%7D\" el_class=\"xfilter\"][/vc_column_inner][vc_column_inner width=\"4/5\"][us_grid post_type=\"current_query\" pagination=\"regular\" pagination_style=\"1\" items_layout=\"61\" columns=\"4\" items_gap=\"0.8rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" breakpoint_1_cols=\"4\" breakpoint_2_cols=\"4\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]</p>\r\n", "Loja Archive", "", "publish", "closed", "closed", "", "loja-archive", "", "", "2024-11-26 17:26:38", "2024-11-26 17:26:38", "", "0", "https://xpharma.digitalpath.pt/xpharma/?post_type=us_content_template&#038;p=58", "0", "us_content_template", "", "0");
INSERT INTO `wp_posts` VALUES("59", "1", "2024-11-22 18:20:29", "2024-11-22 18:20:29", "", "Page Template 3", "", "inherit", "closed", "closed", "", "58-revision-v1", "", "", "2024-11-22 18:20:29", "2024-11-22 18:20:29", "", "58", "https://xpharma.digitalpath.pt/xpharma/?p=59", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("60", "1", "2024-11-22 18:21:35", "2024-11-22 18:21:35", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_bg_alt%22%2C%22padding-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"1/4\"][us_grid_filter filter_items=\"%5B%7B%22source%22%3A%22tax%7Cproduct_cat%22%2C%22ui_type%22%3A%22checkbox%22%2C%22min_value%22%3A%220%22%2C%22step_size%22%3A%221%22%2C%22show_all_value%22%3A%221%22%2C%22show_amount%22%3A%220%22%2C%22label%22%3A%22CATEGORIAS%3A%22%2C%22show_color_swatch%22%3A%220%22%2C%22hide_color_swatch_label%22%3A%220%22%7D%5D\" layout=\"ver\" values_max_height=\"80vh\" mobile_button_label=\"Filtros\" mobile_button_icon=\"fal|plus\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%220.5rem%22%2C%22padding-bottom%22%3A%220.5rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%221px%22%2C%22border-bottom-width%22%3A%221px%22%7D%7D\" el_class=\"xfilter\"][/vc_column_inner][vc_column_inner width=\"3/4\"][us_grid post_type=\"current_query\" pagination=\"regular\" items_layout=\"152\" columns=\"3\" items_gap=\"0.8rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" breakpoint_1_cols=\"4\" breakpoint_2_cols=\"4\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]</p>\n", "Loja Archive", "", "inherit", "closed", "closed", "", "58-autosave-v1", "", "", "2024-11-22 18:21:35", "2024-11-22 18:21:35", "", "58", "https://xpharma.digitalpath.pt/xpharma/?p=60", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("61", "1", "2024-11-22 18:21:59", "2024-11-22 18:21:59", "{\"title\":\"Shop Modern\",\"cols\":\"4\",\"items_gap\":\"5px\",\"data\":{\"post_image:1\":{\"placeholder\":1,\"stretch\":0,\"thumbnail_size\":\"medium\",\"link\":\"%7B%22type%22%3A%22post%22%7D\",\"conditions\":[],\"el_class\":\"image_archive\"},\"product_field:1\":{\"type\":\"sale_badge\",\"conditions\":[],\"css\":{\"default\":{\"color\":\"#fff\",\"font-size\":\"12px\",\"font-weight\":\"700\",\"text-transform\":\"uppercase\",\"background-color\":\"_content_secondary\",\"padding-left\":\"0.8rem\",\"padding-right\":\"0.8rem\",\"border-radius\":\"2rem\",\"position\":\"absolute\",\"left\":\"10px\",\"top\":\"10px\"}},\"hide_below\":\"2000px\"},\"vwrapper:1\":{\"alignment\":\"left\",\"inner_items_gap\":\"0.2rem\",\"conditions\":[],\"css\":{\"default\":{\"background-color\":\"inherit\",\"padding-left\":\"1.2rem\",\"padding-top\":\"1rem\",\"padding-bottom\":\"1rem\",\"padding-right\":\"1.2rem\"}},\"translateY_hover\":\"-2.4rem\",\"transition_duration\":\"0.2s\"},\"post_title:1\":{\"link\":\"%7B%22type%22%3A%22post%22%7D\",\"conditions\":[],\"css\":{\"default\":{\"color\":\"_header_middle_text_hover\",\"font-size\":\"1.25rem\",\"line-height\":\"1.4rem\",\"font-family\":\"h1\",\"font-weight\":\"400\",\"margin-bottom\":\"0.3rem\"}}},\"product_field:3\":{\"conditions\":[],\"css\":{\"default\":{\"color\":\"_header_middle_text_hover\",\"font-size\":\"1.3rem\",\"font-family\":\"h1\",\"font-weight\":\"500\"}}},\"add_to_cart:1\":{\"conditions\":[],\"el_class\":\"addbtn1\",\"opacity\":\"0\"},\"post_taxonomy:1\":{\"taxonomy_name\":\"product_cat\",\"link\":\"%7B%22type%22%3A%22archive%22%7D\",\"conditions\":[],\"css\":{\"default\":{\"color\":\"_content_link\",\"font-size\":\"0.7rem\",\"line-height\":\"0.8rem\",\"letter-spacing\":\"1px\",\"font-family\":\"h1\",\"text-transform\":\"uppercase\"}}},\"vwrapper:2\":{\"conditions\":[],\"css\":{\"default\":{\"padding-left\":\"1.2rem\",\"padding-right\":\"1.2rem\",\"position\":\"absolute\",\"left\":\"0px\",\"bottom\":\"0px\",\"right\":\"0px\"}}},\"hwrapper:1\":{\"alignment\":\"justify\",\"valign\":\"middle\",\"conditions\":[],\"css\":{\"default\":{\"padding-bottom\":\"12px\",\"border-style\":\"solid\",\"border-bottom-width\":\"1px\",\"border-color\":\"#e8e5dc\"}}},\"html:1\":{\"content\":\"JTVCYXdsX2dldF9wcm9kdWN0X2xhYmVscyUyMGlkJTNEJTIyNjIlMjIlNUQ=\",\"scroll_effect\":0,\"wrapper_start_translate_y\":\"\",\"scroll_translate_y\":0,\"scroll_translate_y_direction\":\"up\",\"scroll_translate_y_speed\":\"0.5x\",\"wrapper_end_translate_y\":\"\",\"wrapper_start_translate_x\":\"\",\"scroll_translate_x\":0,\"scroll_translate_x_direction\":\"left\",\"scroll_translate_x_speed\":\"0.5x\",\"wrapper_end_translate_x\":\"\",\"wrapper_start_opacity\":\"\",\"scroll_opacity\":0,\"scroll_opacity_direction\":\"out-in\",\"wrapper_end_opacity\":\"\",\"wrapper_start_scale\":\"\",\"scroll_scale\":0,\"scroll_scale_direction\":\"up\",\"scroll_scale_speed\":\"0.5x\",\"wrapper_end_scale\":\"\",\"scroll_delay\":\"0.1s\",\"scroll_from_initial_position\":\"0\",\"scroll_start_position\":\"0%\",\"scroll_end_position\":\"100%\",\"conditions_operator\":\"always\",\"conditions\":[],\"css\":{\"default\":{\"position\":\"absolute\",\"left\":\"12px\",\"top\":\"12px\"}},\"el_class\":\"\",\"el_id\":\"\",\"enable_custom_html_atts\":0,\"custom_html_atts\":\"\",\"hide_on_states\":\"\",\"hide_for_sticky\":0,\"hide_for_not_sticky\":0,\"hide_below\":\"0px\",\"hide_above\":\"0px\",\"hover\":0,\"opacity\":\"1\",\"opacity_hover\":\"1\",\"scale\":\"1\",\"scale_hover\":\"1\",\"translateX\":\"0%\",\"translateX_hover\":\"0%\",\"translateY\":\"0%\",\"translateY_hover\":\"0%\",\"color_bg_hover\":\"\",\"color_border_hover\":\"\",\"color_text_hover\":\"\",\"transition_duration\":\"0.3s\",\"transform_origin_X\":\"50%\",\"transform_origin_Y\":\"50%\"},\"vwrapper:3\":{\"inner_items_gap\":\"0rem\",\"conditions\":[],\"css\":{\"default\":{\"min-height\":\"470px\",\"padding-left\":\"0px\",\"padding-right\":\"0px\"}}},\"product_field:2\":{\"type\":\"sku\",\"conditions\":[],\"css\":{\"default\":{\"color\":\"_content_faded\",\"font-size\":\"0.8rem\",\"line-height\":\"0.9rem\",\"font-family\":\"h1\"}}}},\"default\":{\"layout\":{\"middle_center\":[\"vwrapper:3\"],\"vwrapper:1\":[\"post_taxonomy:1\",\"post_title:1\",\"product_field:2\"],\"hidden\":[],\"vwrapper:2\":[\"hwrapper:1\"],\"hwrapper:1\":[\"product_field:3\",\"add_to_cart:1\"],\"vwrapper:3\":[\"post_image:1\",\"html:1\",\"product_field:1\",\"vwrapper:1\",\"vwrapper:2\"]},\"options\":{\"fixed\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"overflow\":1,\"color_bg\":\"_content_bg\",\"color_text\":\"_content_text\",\"ignore_us_tile_colors\":1,\"bg_img_source\":\"none\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_file_size\":\"large\",\"bg_img_size\":\"cover\",\"bg_img_position\":\"center center\",\"bg_img_repeat\":\"no-repeat\",\"bg_img_wrapper_end\":\"\",\"border_radius\":\"\",\"box_shadow\":\"0.3rem\",\"box_shadow_hover\":\"1rem\",\"el_class\":\"gridprod1css\"}}}", "Produto 1", "", "publish", "closed", "closed", "", "produto-1", "", "", "2024-11-22 18:26:45", "2024-11-22 18:26:45", "", "0", "https://xpharma.digitalpath.pt/xpharma/?post_type=us_grid_layout&#038;p=61", "0", "us_grid_layout", "", "0");
INSERT INTO `wp_posts` VALUES("62", "1", "2024-11-22 18:24:53", "2024-11-22 18:24:53", "", "Percentagem", "", "publish", "closed", "closed", "", "percentagem", "", "", "2024-11-22 18:24:53", "2024-11-22 18:24:53", "", "0", "https://xpharma.digitalpath.pt/xpharma/?post_type=awl-labels&#038;p=62", "0", "awl-labels", "", "0");
INSERT INTO `wp_posts` VALUES("63", "1", "2024-11-22 18:27:19", "2024-11-22 18:27:19", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_bg_alt%22%2C%22padding-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"1/4\"][us_grid_filter filter_items=\"%5B%7B%22source%22%3A%22tax%7Cproduct_cat%22%2C%22ui_type%22%3A%22checkbox%22%2C%22min_value%22%3A%220%22%2C%22step_size%22%3A%221%22%2C%22show_all_value%22%3A%221%22%2C%22show_amount%22%3A%220%22%2C%22label%22%3A%22CATEGORIAS%3A%22%2C%22show_color_swatch%22%3A%220%22%2C%22hide_color_swatch_label%22%3A%220%22%7D%5D\" layout=\"ver\" values_max_height=\"80vh\" mobile_button_label=\"Filtros\" mobile_button_icon=\"fal|plus\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%220.5rem%22%2C%22padding-bottom%22%3A%220.5rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%221px%22%2C%22border-bottom-width%22%3A%221px%22%7D%7D\" el_class=\"xfilter\"][/vc_column_inner][vc_column_inner width=\"3/4\"][us_grid post_type=\"current_query\" pagination=\"regular\" items_layout=\"152\" columns=\"3\" items_gap=\"0.8rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" breakpoint_1_cols=\"4\" breakpoint_2_cols=\"4\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]</p>\r\n", "Loja Archive", "", "inherit", "closed", "closed", "", "58-revision-v1", "", "", "2024-11-22 18:27:19", "2024-11-22 18:27:19", "", "58", "https://xpharma.digitalpath.pt/xpharma/?p=63", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("64", "1", "2024-11-26 17:10:41", "2024-11-26 17:10:41", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"1/5\"][us_grid_filter filter_items=\"%5B%7B%22source%22%3A%22tax%7Cproduct_cat%22%2C%22ui_type%22%3A%22checkbox%22%2C%22min_value%22%3A%220%22%2C%22step_size%22%3A%221%22%2C%22show_all_value%22%3A%221%22%2C%22show_amount%22%3A%220%22%2C%22label%22%3A%22CATEGORIAS%3A%22%2C%22show_color_swatch%22%3A%220%22%2C%22hide_color_swatch_label%22%3A%220%22%7D%5D\" layout=\"ver\" values_max_height=\"80vh\" mobile_button_label=\"Filtros\" mobile_button_icon=\"fal|plus\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%220.8rem%22%2C%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%220.5rem%22%2C%22padding-bottom%22%3A%220.5rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%221px%22%2C%22border-bottom-width%22%3A%221px%22%7D%7D\" el_class=\"xfilter\"][/vc_column_inner][vc_column_inner width=\"4/5\"][us_grid post_type=\"product\" items_quantity=\"24\" pagination=\"regular\" pagination_style=\"1\" items_layout=\"61\" columns=\"4\" items_gap=\"0.8rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" breakpoint_1_cols=\"4\" breakpoint_2_cols=\"4\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]</p>\r\n", "Loja", "", "publish", "closed", "closed", "", "loja", "", "", "2024-11-26 17:21:39", "2024-11-26 17:21:39", "", "0", "https://xpharma.digitalpath.pt/xpharma/?post_type=us_content_template&#038;p=64", "0", "us_content_template", "", "0");
INSERT INTO `wp_posts` VALUES("65", "1", "2024-11-26 17:10:41", "2024-11-26 17:10:41", "", "Page Template 4", "", "inherit", "closed", "closed", "", "64-revision-v1", "", "", "2024-11-26 17:10:41", "2024-11-26 17:10:41", "", "64", "https://xpharma.digitalpath.pt/xpharma/?p=65", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("66", "1", "2024-11-26 17:11:05", "2024-11-26 17:11:05", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_content_bg_alt%22%2C%22padding-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"1/4\"][us_grid_filter filter_items=\"%5B%7B%22source%22%3A%22tax%7Cproduct_cat%22%2C%22ui_type%22%3A%22checkbox%22%2C%22min_value%22%3A%220%22%2C%22step_size%22%3A%221%22%2C%22show_all_value%22%3A%221%22%2C%22show_amount%22%3A%220%22%2C%22label%22%3A%22CATEGORIAS%3A%22%2C%22show_color_swatch%22%3A%220%22%2C%22hide_color_swatch_label%22%3A%220%22%7D%5D\" layout=\"ver\" values_max_height=\"80vh\" mobile_button_label=\"Filtros\" mobile_button_icon=\"fal|plus\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%220.5rem%22%2C%22padding-bottom%22%3A%220.5rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%221px%22%2C%22border-bottom-width%22%3A%221px%22%7D%7D\" el_class=\"xfilter\"][/vc_column_inner][vc_column_inner width=\"3/4\"][us_grid post_type=\"product\" items_quantity=\"24\" pagination=\"regular\" pagination_style=\"1\" items_layout=\"152\" columns=\"3\" items_gap=\"0.8rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" breakpoint_1_cols=\"4\" breakpoint_2_cols=\"4\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]</p>\r\n", "Loja", "", "inherit", "closed", "closed", "", "64-revision-v1", "", "", "2024-11-26 17:11:05", "2024-11-26 17:11:05", "", "64", "https://xpharma.digitalpath.pt/xpharma/?p=66", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("67", "1", "2024-11-26 17:21:39", "2024-11-26 17:21:39", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"1/5\"][us_grid_filter filter_items=\"%5B%7B%22source%22%3A%22tax%7Cproduct_cat%22%2C%22ui_type%22%3A%22checkbox%22%2C%22min_value%22%3A%220%22%2C%22step_size%22%3A%221%22%2C%22show_all_value%22%3A%221%22%2C%22show_amount%22%3A%220%22%2C%22label%22%3A%22CATEGORIAS%3A%22%2C%22show_color_swatch%22%3A%220%22%2C%22hide_color_swatch_label%22%3A%220%22%7D%5D\" layout=\"ver\" values_max_height=\"80vh\" mobile_button_label=\"Filtros\" mobile_button_icon=\"fal|plus\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%220.8rem%22%2C%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%220.5rem%22%2C%22padding-bottom%22%3A%220.5rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%221px%22%2C%22border-bottom-width%22%3A%221px%22%7D%7D\" el_class=\"xfilter\"][/vc_column_inner][vc_column_inner width=\"4/5\"][us_grid post_type=\"product\" items_quantity=\"24\" pagination=\"regular\" pagination_style=\"1\" items_layout=\"61\" columns=\"4\" items_gap=\"0.8rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" breakpoint_1_cols=\"4\" breakpoint_2_cols=\"4\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]</p>\r\n", "Loja", "", "inherit", "closed", "closed", "", "64-revision-v1", "", "", "2024-11-26 17:21:39", "2024-11-26 17:21:39", "", "64", "https://xpharma.digitalpath.pt/xpharma/?p=67", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("68", "1", "2024-11-26 17:22:28", "2024-11-26 17:22:28", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"1/5\"][us_grid_filter filter_items=\"%5B%7B%22source%22%3A%22tax%7Cproduct_cat%22%2C%22ui_type%22%3A%22checkbox%22%2C%22min_value%22%3A%220%22%2C%22step_size%22%3A%221%22%2C%22show_all_value%22%3A%221%22%2C%22show_amount%22%3A%220%22%2C%22label%22%3A%22CATEGORIAS%3A%22%2C%22show_color_swatch%22%3A%220%22%2C%22hide_color_swatch_label%22%3A%220%22%7D%5D\" layout=\"ver\" values_max_height=\"80vh\" mobile_button_label=\"Filtros\" mobile_button_icon=\"fal|plus\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%220.8rem%22%2C%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%220.5rem%22%2C%22padding-bottom%22%3A%220.5rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%221px%22%2C%22border-bottom-width%22%3A%221px%22%7D%7D\" el_class=\"xfilter\"][/vc_column_inner][vc_column_inner width=\"4/5\"][us_grid post_type=\"current_query\" pagination=\"regular\" pagination_style=\"1\" items_layout=\"61\" columns=\"4\" items_gap=\"0.8rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" breakpoint_1_cols=\"4\" breakpoint_2_cols=\"4\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]</p>\r\n", "Loja Archive", "", "inherit", "closed", "closed", "", "58-revision-v1", "", "", "2024-11-26 17:22:28", "2024-11-26 17:22:28", "", "58", "https://xpharma.digitalpath.pt/xpharma/?p=68", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("69", "1", "2024-11-26 17:26:38", "2024-11-26 17:26:38", "<p>[vc_row css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%225rem%22%7D%7D\"][vc_column width=\"1/1\"][vc_row_inner][vc_column_inner width=\"1/5\"][us_grid_filter filter_items=\"%5B%7B%22source%22%3A%22tax%7Cproduct_cat%22%2C%22ui_type%22%3A%22checkbox%22%2C%22min_value%22%3A%220%22%2C%22step_size%22%3A%221%22%2C%22show_all_value%22%3A%221%22%2C%22show_amount%22%3A%220%22%2C%22label%22%3A%22CATEGORIAS%3A%22%2C%22show_color_swatch%22%3A%220%22%2C%22hide_color_swatch_label%22%3A%220%22%7D%5D\" layout=\"ver\" values_max_height=\"80vh\" mobile_button_label=\"Filtros\" mobile_button_icon=\"fal|plus\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%220.8rem%22%2C%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%22%22%2C%22padding-bottom%22%3A%22%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%22%22%2C%22border-bottom-width%22%3A%22%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%220.5rem%22%2C%22padding-bottom%22%3A%220.5rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-top-width%22%3A%221px%22%2C%22border-bottom-width%22%3A%221px%22%7D%7D\" el_class=\"xfilter\"][/vc_column_inner][vc_column_inner width=\"4/5\"][us_grid post_type=\"current_query\" pagination=\"regular\" pagination_style=\"1\" items_layout=\"61\" columns=\"4\" items_gap=\"0.8rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" breakpoint_1_cols=\"4\" breakpoint_2_cols=\"4\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]</p>\r\n", "Loja Archive", "", "inherit", "closed", "closed", "", "58-revision-v1", "", "", "2024-11-26 17:26:38", "2024-11-26 17:26:38", "", "58", "https://xpharma.digitalpath.pt/xpharma/?p=69", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("70", "1", "2024-11-26 17:51:23", "2024-11-26 17:51:23", "<p>[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Voltar às Notícias\" link=\"%7B%22url%22%3A%22%2Fnoticias-e-casos-de-sucesso-doorwin%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outras notícias\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"338\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]</p>\r\n", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-11-26 17:51:23", "2024-11-26 17:51:23", "", "20", "https://xpharma.digitalpath.pt/xpharma/?p=70", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("71", "1", "2024-11-26 17:51:45", "2024-11-26 17:51:45", "{\"title\":\"Image first (category, date, excerpt)\",\"cols\":\"2\",\"data\":{\"post_title:1\":{\"conditions\":[],\"css\":{\"default\":{\"font-size\":\"1rem\",\"font-weight\":\"600\",\"margin-bottom\":\"0.2rem\"}}},\"hwrapper:1\":{\"inner_items_gap\":\"0rem\",\"wrap\":1,\"conditions\":[],\"css\":{\"default\":{\"color\":\"_content_faded\",\"font-size\":\"0.9rem\"}},\"link\":\"{\\\"url\\\":\\\"\\\"}\"},\"post_date:1\":{\"format\":\"default\",\"css\":{\"default\":{\"font-size\":\"0.7rem\"}},\"conditions\":[]}},\"default\":{\"layout\":{\"middle_center\":[\"post_title:1\",\"hwrapper:1\"],\"hwrapper:1\":[\"post_date:1\"],\"hidden\":[]},\"options\":{\"fixed\":0,\"ratio\":\"1x1\",\"ratio_width\":\"21\",\"ratio_height\":\"9\",\"overflow\":0,\"color_bg\":\"\",\"color_text\":\"\",\"ignore_us_tile_colors\":0,\"bg_img_source\":\"none\",\"bg_img\":\"\",\"bg_img_wrapper_start\":\"\",\"bg_file_size\":\"large\",\"bg_img_size\":\"cover\",\"bg_img_position\":\"center center\",\"bg_img_repeat\":\"no-repeat\",\"bg_img_wrapper_end\":\"\",\"border_radius\":0,\"box_shadow\":0,\"box_shadow_hover\":0,\"el_class\":\"\"}}}", "grid Blog Listagem", "", "publish", "closed", "closed", "", "grid-blog-listagem", "", "", "2024-11-26 17:51:56", "2024-11-26 17:51:56", "", "0", "https://xpharma.digitalpath.pt/xpharma/?post_type=us_grid_layout&#038;p=71", "0", "us_grid_layout", "", "0");
INSERT INTO `wp_posts` VALUES("72", "1", "2024-11-26 17:52:11", "2024-11-26 17:52:11", "<p>[vc_row height=\"auto\" css=\"%7B%22default%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22laptops%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22tablets%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%2C%22mobiles%22%3A%7B%22padding-top%22%3A%222rem%22%2C%22padding-bottom%22%3A%227rem%22%7D%7D\"][vc_column width=\"1/1\"][us_text text=\"Voltar às Notícias\" link=\"%7B%22url%22%3A%22%2Fnoticias-e-casos-de-sucesso-doorwin%2F%22%7D\" icon=\"fal|angle-left\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_faded%22%2C%22font-size%22%3A%220.7rem%22%2C%22letter-spacing%22%3A%223px%22%2C%22font-weight%22%3A%22300%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"mobiles\"][vc_column_inner width=\"3/4\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"][vc_column_inner width=\"1/1\"][us_post_image has_ratio=\"1\" ratio=\"16x9\" thumbnail_size=\"full\"][/vc_column_inner][/vc_row_inner][vc_row_inner css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][vc_column_inner width=\"3/4\"][us_post_title tag=\"h1\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_heading%22%2C%22font-size%22%3A%222.2rem%22%2C%22font-family%22%3A%22h1%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%222rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_post_content type=\"full_content\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%222rem%22%7D%7D\"][us_hwrapper alignment=\"left\" valign=\"middle\" inner_items_gap=\"0.7rem\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][us_text text=\"Partilhar:\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_alt_content_faded%22%2C%22text-align%22%3A%22right%22%2C%22font-size%22%3A%220.8rem%22%2C%22font-weight%22%3A%22300%22%7D%7D\"][us_sharing align=\"right\" color=\"primary\"][/us_hwrapper][/vc_column_inner][vc_column_inner sticky=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/4\"][us_text text=\"Outras notícias\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_content_secondary%22%2C%22font-size%22%3A%220.6rem%22%2C%22letter-spacing%22%3A%224px%22%2C%22font-weight%22%3A%22700%22%2C%22text-transform%22%3A%22uppercase%22%2C%22margin-top%22%3A%223.5rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22padding-bottom%22%3A%220.3rem%22%2C%22border-style%22%3A%22solid%22%2C%22border-bottom-width%22%3A%221px%22%2C%22border-color%22%3A%22_header_transparent_text_hover%22%7D%7D\"][us_grid items_quantity=\"4\" items_layout=\"71\" columns=\"1\" overriding_link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row]</p>\r\n", "Blog single", "", "inherit", "closed", "closed", "", "20-revision-v1", "", "", "2024-11-26 17:52:11", "2024-11-26 17:52:11", "", "20", "https://xpharma.digitalpath.pt/xpharma/?p=72", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("77", "0", "2025-02-19 11:13:26", "2025-02-19 11:13:26", "<!-- wp:page-list /-->", "Navegação", "", "publish", "closed", "closed", "", "navigation", "", "", "2025-02-19 11:13:26", "2025-02-19 11:13:26", "", "0", "https://xpharma.digitalpath.pt/xpharma/navigation/", "0", "wp_navigation", "", "0");
INSERT INTO `wp_posts` VALUES("90", "1", "2025-09-15 14:13:02", "2025-09-15 14:13:02", "", "MID_XPharma_favicon", "", "inherit", "", "closed", "", "mid_xpharma_favicon", "", "", "2025-09-15 14:13:02", "2025-09-15 14:13:02", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_favicon.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("91", "1", "2025-09-15 14:13:04", "2025-09-15 14:13:04", "", "MID_XPharma_img-10", "", "inherit", "", "closed", "", "mid_xpharma_img-10", "", "", "2025-09-15 14:13:04", "2025-09-15 14:13:04", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_img-10.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("92", "1", "2025-09-15 14:13:05", "2025-09-15 14:13:05", "", "MID_XPharma_img-9", "", "inherit", "", "closed", "", "mid_xpharma_img-9", "", "", "2025-09-15 14:13:05", "2025-09-15 14:13:05", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_img-9.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("93", "1", "2025-09-15 14:13:06", "2025-09-15 14:13:06", "", "MID_XPharma_img-8", "", "inherit", "", "closed", "", "mid_xpharma_img-8", "", "", "2025-09-15 14:13:06", "2025-09-15 14:13:06", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_img-8.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("94", "1", "2025-09-15 14:13:07", "2025-09-15 14:13:07", "", "MID_XPharma_img-7", "", "inherit", "", "closed", "", "mid_xpharma_img-7", "", "", "2025-09-15 14:13:07", "2025-09-15 14:13:07", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_img-7.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("95", "1", "2025-09-15 14:13:09", "2025-09-15 14:13:09", "", "MID_XPharma_team-4", "", "inherit", "", "closed", "", "mid_xpharma_team-4", "", "", "2025-09-15 14:13:09", "2025-09-15 14:13:09", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_team-4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("96", "1", "2025-09-15 14:13:09", "2025-09-15 14:13:09", "", "MID_XPharma_team-3", "", "inherit", "", "closed", "", "mid_xpharma_team-3", "", "", "2025-09-15 14:13:09", "2025-09-15 14:13:09", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_team-3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("97", "1", "2025-09-15 14:13:11", "2025-09-15 14:13:11", "", "MID_XPharma_team-2", "", "inherit", "", "closed", "", "mid_xpharma_team-2", "", "", "2025-09-15 14:13:11", "2025-09-15 14:13:11", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_team-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("98", "1", "2025-09-15 14:13:12", "2025-09-15 14:13:12", "", "MID_XPharma_team-1", "", "inherit", "", "closed", "", "mid_xpharma_team-1", "", "", "2025-09-15 14:13:12", "2025-09-15 14:13:12", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_team-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("99", "1", "2025-09-15 14:13:13", "2025-09-15 14:13:13", "", "MID_XPharma_img-6", "", "inherit", "", "closed", "", "mid_xpharma_img-6", "", "", "2025-09-15 14:13:13", "2025-09-15 14:13:13", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_img-6.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("100", "1", "2025-09-15 14:13:14", "2025-09-15 14:13:14", "", "MID_XPharma_img-5", "", "inherit", "", "closed", "", "mid_xpharma_img-5", "", "", "2025-09-15 14:13:14", "2025-09-15 14:13:14", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_img-5.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("101", "1", "2025-09-15 14:13:15", "2025-09-15 14:13:15", "", "MID_XPharma_img-4", "", "inherit", "", "closed", "", "mid_xpharma_img-4", "", "", "2025-09-15 14:13:15", "2025-09-15 14:13:15", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_img-4.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("102", "1", "2025-09-15 14:13:16", "2025-09-15 14:13:16", "", "MID_XPharma_img-3", "", "inherit", "", "closed", "", "mid_xpharma_img-3", "", "", "2025-09-15 14:13:16", "2025-09-15 14:13:16", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_img-3.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("103", "1", "2025-09-15 14:13:17", "2025-09-15 14:13:17", "", "MID_XPharma_img-2", "", "inherit", "", "closed", "", "mid_xpharma_img-2", "", "", "2025-09-15 14:13:17", "2025-09-15 14:13:17", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_img-2.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("104", "1", "2025-09-15 14:13:19", "2025-09-15 14:13:19", "", "MID_XPharma_img-1", "", "inherit", "", "closed", "", "mid_xpharma_img-1", "", "", "2025-09-15 14:13:19", "2025-09-15 14:13:19", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_img-1.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_posts` VALUES("105", "1", "2025-09-15 14:13:20", "2025-09-15 14:13:20", "", "MID_XPharma_agua-3", "", "inherit", "", "closed", "", "mid_xpharma_agua-3", "", "", "2025-09-15 14:13:20", "2025-09-15 14:13:20", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_agua-3.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("106", "1", "2025-09-15 14:13:21", "2025-09-15 14:13:21", "", "MID_XPharma_agua-2", "", "inherit", "", "closed", "", "mid_xpharma_agua-2", "", "", "2025-09-15 14:13:21", "2025-09-15 14:13:21", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_agua-2.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("107", "1", "2025-09-15 14:13:22", "2025-09-15 14:13:22", "", "MID_XPharma_agua-1", "", "inherit", "", "closed", "", "mid_xpharma_agua-1", "", "", "2025-09-15 14:13:22", "2025-09-15 14:13:22", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_agua-1.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("108", "1", "2025-09-15 14:13:35", "2025-09-15 14:13:35", "", "MID_XPharma_ico_-01", "", "inherit", "", "closed", "", "mid_xpharma_ico_-01", "", "", "2025-09-15 14:13:35", "2025-09-15 14:13:35", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-01.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("109", "1", "2025-09-15 14:13:36", "2025-09-15 14:13:36", "", "MID_XPharma_ico_-02", "", "inherit", "", "closed", "", "mid_xpharma_ico_-02", "", "", "2025-09-15 14:13:36", "2025-09-15 14:13:36", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-02.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("110", "1", "2025-09-15 14:13:37", "2025-09-15 14:13:37", "", "MID_XPharma_ico_-03", "", "inherit", "", "closed", "", "mid_xpharma_ico_-03", "", "", "2025-09-15 14:13:37", "2025-09-15 14:13:37", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-03.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("111", "1", "2025-09-15 14:13:38", "2025-09-15 14:13:38", "", "MID_XPharma_ico_-04", "", "inherit", "", "closed", "", "mid_xpharma_ico_-04", "", "", "2025-09-15 14:13:38", "2025-09-15 14:13:38", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-04.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("112", "1", "2025-09-15 14:13:39", "2025-09-15 14:13:39", "", "MID_XPharma_ico_-05", "", "inherit", "", "closed", "", "mid_xpharma_ico_-05", "", "", "2025-09-15 14:13:39", "2025-09-15 14:13:39", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-05.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("113", "1", "2025-09-15 14:13:40", "2025-09-15 14:13:40", "", "MID_XPharma_ico_-06", "", "inherit", "", "closed", "", "mid_xpharma_ico_-06", "", "", "2025-09-15 14:13:40", "2025-09-15 14:13:40", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-06.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("114", "1", "2025-09-15 14:13:41", "2025-09-15 14:13:41", "", "MID_XPharma_ico_-07", "", "inherit", "", "closed", "", "mid_xpharma_ico_-07", "", "", "2025-09-15 14:13:41", "2025-09-15 14:13:41", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-07.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("115", "1", "2025-09-15 14:13:42", "2025-09-15 14:13:42", "", "MID_XPharma_ico_-08", "", "inherit", "", "closed", "", "mid_xpharma_ico_-08", "", "", "2025-09-15 14:13:42", "2025-09-15 14:13:42", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-08.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("116", "1", "2025-09-15 14:13:43", "2025-09-15 14:13:43", "", "MID_XPharma_ico_-09", "", "inherit", "", "closed", "", "mid_xpharma_ico_-09", "", "", "2025-09-15 14:13:43", "2025-09-15 14:13:43", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-09.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("117", "1", "2025-09-15 14:13:44", "2025-09-15 14:13:44", "", "MID_XPharma_ico_-10", "", "inherit", "", "closed", "", "mid_xpharma_ico_-10", "", "", "2025-09-15 14:13:44", "2025-09-15 14:13:44", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-10.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("118", "1", "2025-09-15 14:13:45", "2025-09-15 14:13:45", "", "MID_XPharma_ico_-11", "", "inherit", "", "closed", "", "mid_xpharma_ico_-11", "", "", "2025-09-15 14:13:45", "2025-09-15 14:13:45", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-11.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("119", "1", "2025-09-15 14:13:46", "2025-09-15 14:13:46", "", "MID_XPharma_ico_-12", "", "inherit", "", "closed", "", "mid_xpharma_ico_-12", "", "", "2025-09-15 14:13:46", "2025-09-15 14:13:46", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-12.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("120", "1", "2025-09-15 14:13:47", "2025-09-15 14:13:47", "", "MID_XPharma_ico_-13", "", "inherit", "", "closed", "", "mid_xpharma_ico_-13", "", "", "2025-09-15 14:13:47", "2025-09-15 14:13:47", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-13.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("121", "1", "2025-09-15 14:13:48", "2025-09-15 14:13:48", "", "MID_XPharma_ico_-14", "", "inherit", "", "closed", "", "mid_xpharma_ico_-14", "", "", "2025-09-15 14:13:48", "2025-09-15 14:13:48", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-14.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("122", "1", "2025-09-15 14:13:49", "2025-09-15 14:13:49", "", "MID_XPharma_ico_-15", "", "inherit", "", "closed", "", "mid_xpharma_ico_-15", "", "", "2025-09-15 14:13:49", "2025-09-15 14:13:49", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-15.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("123", "1", "2025-09-15 14:13:50", "2025-09-15 14:13:50", "", "MID_XPharma_ico_-16", "", "inherit", "", "closed", "", "mid_xpharma_ico_-16", "", "", "2025-09-15 14:13:50", "2025-09-15 14:13:50", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_ico_-16.svg", "0", "attachment", "image/svg+xml", "0");
INSERT INTO `wp_posts` VALUES("124", "1", "2025-09-15 14:13:56", "2025-09-15 14:13:56", "", "MID_XPharma_logo", "", "inherit", "", "closed", "", "mid_xpharma_logo", "", "", "2025-09-15 14:13:56", "2025-09-15 14:13:56", "", "0", "https://xpharma.digitalpath.pt/xpharma/wp-content/uploads/2025/09/MID_XPharma_logo.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("125", "1", "2025-10-03 17:07:08", "2025-10-03 17:07:08", "<p>[vc_row width=\"full\" columns_gap=\"0rem\" content_placement=\"bottom\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22464%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\" pb_type=\"matrix\" pb_min_speedx=\".5\" pb_max_speedx=\".5\" pb_min_speedy=\".5\" pb_max_speedy=\"1.5\" pb_directionx=\"center\" pb_directiony=\"center\" pb_particle_density=\"15000\" pb_dot_color=\"#FFFFFF30\" pb_line_color=\"#FFFFFF30\" pb_particle_radius=\"7\" pb_line_width=\".5\"][vc_column link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22min-height%22%3A%2280vh%22%7D%7D\" width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%2242vh%22%7D%7D\"][vc_row_inner columns_gap=\"0rem\" content_placement=\"bottom\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/1\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22text-align%22%3A%22center%22%2C%22font-size%22%3A%223.4rem%22%2C%22line-height%22%3A%221%22%2C%22font-weight%22%3A%22200%22%2C%22margin-left%22%3A%229vw%22%2C%22margin-top%22%3A%22.8rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22animation-name%22%3A%22aft%22%2C%22animation-delay%22%3A%22250ms%22%7D%7D\"]Moved by connections[/vc_column_text][/vc_column_inner][/vc_row_inner][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%226vh%22%7D%7D\"][/vc_column][/vc_row][vc_row us_bg_image_source=\"media\" us_bg_image=\"106\" us_bg_size=\"initial\" us_bg_pos=\"bottom left\" us_bg_repeat=\"no-repeat\" columns_gap=\"0rem\" content_placement=\"bottom\" disable_element=\"yes\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22104%22%2C%22background-position%22%3A%22center%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%2235vh%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%223.2rem%22%2C%22line-height%22%3A%221.1%22%2C%22font-weight%22%3A%22200%22%7D%7D\"]Moved by<br />\nconnections[/vc_column_text][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222rem%22%7D%7D\"][/vc_column][/vc_row]</p>\n", "Slide 1", "", "inherit", "closed", "closed", "", "39-autosave-v1", "", "", "2025-10-03 17:07:08", "2025-10-03 17:07:08", "", "39", "https://xpharma.digitalpath.pt/?p=125", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("126", "1", "2025-09-15 14:30:25", "2025-09-15 14:30:25", "<!-- wp:shortcode -->[woocommerce_my_account]<!-- /wp:shortcode -->", "A minha conta", "", "inherit", "closed", "closed", "", "47-revision-v1", "", "", "2025-09-15 14:30:25", "2025-09-15 14:30:25", "", "47", "https://xpharma.digitalpath.pt/?p=126", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("127", "1", "2025-09-15 14:30:25", "2025-09-15 14:30:25", "<!-- wp:woocommerce/checkout -->\n<div class=\"wp-block-woocommerce-checkout alignwide wc-block-checkout is-loading\"><!-- wp:woocommerce/checkout-fields-block -->\n<div class=\"wp-block-woocommerce-checkout-fields-block\"><!-- wp:woocommerce/checkout-express-payment-block -->\n<div class=\"wp-block-woocommerce-checkout-express-payment-block\"></div>\n<!-- /wp:woocommerce/checkout-express-payment-block -->\n\n<!-- wp:woocommerce/checkout-contact-information-block -->\n<div class=\"wp-block-woocommerce-checkout-contact-information-block\"></div>\n<!-- /wp:woocommerce/checkout-contact-information-block -->\n\n<!-- wp:woocommerce/checkout-shipping-method-block -->\n<div class=\"wp-block-woocommerce-checkout-shipping-method-block\"></div>\n<!-- /wp:woocommerce/checkout-shipping-method-block -->\n\n<!-- wp:woocommerce/checkout-pickup-options-block -->\n<div class=\"wp-block-woocommerce-checkout-pickup-options-block\"></div>\n<!-- /wp:woocommerce/checkout-pickup-options-block -->\n\n<!-- wp:woocommerce/checkout-shipping-address-block -->\n<div class=\"wp-block-woocommerce-checkout-shipping-address-block\"></div>\n<!-- /wp:woocommerce/checkout-shipping-address-block -->\n\n<!-- wp:woocommerce/checkout-billing-address-block -->\n<div class=\"wp-block-woocommerce-checkout-billing-address-block\"></div>\n<!-- /wp:woocommerce/checkout-billing-address-block -->\n\n<!-- wp:woocommerce/checkout-shipping-methods-block -->\n<div class=\"wp-block-woocommerce-checkout-shipping-methods-block\"></div>\n<!-- /wp:woocommerce/checkout-shipping-methods-block -->\n\n<!-- wp:woocommerce/checkout-payment-block -->\n<div class=\"wp-block-woocommerce-checkout-payment-block\"></div>\n<!-- /wp:woocommerce/checkout-payment-block -->\n\n<!-- wp:woocommerce/checkout-additional-information-block -->\n<div class=\"wp-block-woocommerce-checkout-additional-information-block\"></div>\n<!-- /wp:woocommerce/checkout-additional-information-block -->\n\n<!-- wp:woocommerce/checkout-order-note-block -->\n<div class=\"wp-block-woocommerce-checkout-order-note-block\"></div>\n<!-- /wp:woocommerce/checkout-order-note-block -->\n\n<!-- wp:woocommerce/checkout-terms-block -->\n<div class=\"wp-block-woocommerce-checkout-terms-block\"></div>\n<!-- /wp:woocommerce/checkout-terms-block -->\n\n<!-- wp:woocommerce/checkout-actions-block -->\n<div class=\"wp-block-woocommerce-checkout-actions-block\"></div>\n<!-- /wp:woocommerce/checkout-actions-block --></div>\n<!-- /wp:woocommerce/checkout-fields-block -->\n\n<!-- wp:woocommerce/checkout-totals-block -->\n<div class=\"wp-block-woocommerce-checkout-totals-block\"><!-- wp:woocommerce/checkout-order-summary-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-block\"><!-- wp:woocommerce/checkout-order-summary-cart-items-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-cart-items-block\"></div>\n<!-- /wp:woocommerce/checkout-order-summary-cart-items-block -->\n\n<!-- wp:woocommerce/checkout-order-summary-coupon-form-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-coupon-form-block\"></div>\n<!-- /wp:woocommerce/checkout-order-summary-coupon-form-block -->\n\n<!-- wp:woocommerce/checkout-order-summary-subtotal-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-subtotal-block\"></div>\n<!-- /wp:woocommerce/checkout-order-summary-subtotal-block -->\n\n<!-- wp:woocommerce/checkout-order-summary-fee-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-fee-block\"></div>\n<!-- /wp:woocommerce/checkout-order-summary-fee-block -->\n\n<!-- wp:woocommerce/checkout-order-summary-discount-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-discount-block\"></div>\n<!-- /wp:woocommerce/checkout-order-summary-discount-block -->\n\n<!-- wp:woocommerce/checkout-order-summary-shipping-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-shipping-block\"></div>\n<!-- /wp:woocommerce/checkout-order-summary-shipping-block -->\n\n<!-- wp:woocommerce/checkout-order-summary-taxes-block -->\n<div class=\"wp-block-woocommerce-checkout-order-summary-taxes-block\"></div>\n<!-- /wp:woocommerce/checkout-order-summary-taxes-block --></div>\n<!-- /wp:woocommerce/checkout-order-summary-block --></div>\n<!-- /wp:woocommerce/checkout-totals-block --></div>\n<!-- /wp:woocommerce/checkout -->", "Finalizar compras", "", "inherit", "closed", "closed", "", "46-revision-v1", "", "", "2025-09-15 14:30:25", "2025-09-15 14:30:25", "", "46", "https://xpharma.digitalpath.pt/?p=127", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("128", "1", "2025-09-15 14:30:25", "2025-09-15 14:30:25", "", "Loja", "", "inherit", "closed", "closed", "", "44-revision-v1", "", "", "2025-09-15 14:30:25", "2025-09-15 14:30:25", "", "44", "https://xpharma.digitalpath.pt/?p=128", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("129", "1", "2025-09-15 14:30:25", "2025-09-15 14:30:25", "<!-- wp:paragraph -->\n<p><b>This is a sample page.</b></p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h2 class=\"wp-block-heading\">Overview</h2>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Our refund and returns policy lasts 30 days. If 30 days have passed since your purchase, we can’t offer you a full refund or exchange.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>To be eligible for a return, your item must be unused and in the same condition that you received it. It must also be in the original packaging.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Several types of goods are exempt from being returned. Perishable goods such as food, flowers, newspapers or magazines cannot be returned. We also do not accept products that are intimate or sanitary goods, hazardous materials, or flammable liquids or gases.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Additional non-returnable items:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul>\n<li>Gift cards</li>\n<li>Downloadable software products</li>\n<li>Some health and personal care items</li>\n</ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<p>To complete your return, we require a receipt or proof of purchase.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Please do not send your purchase back to the manufacturer.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>There are certain situations where only partial refunds are granted:</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:list -->\n<ul>\n<li>Book with obvious signs of use</li>\n<li>CD, DVD, VHS tape, software, video game, cassette tape, or vinyl record that has been opened.</li>\n<li>Any item not in its original condition, is damaged or missing parts for reasons not due to our error.</li>\n<li>Any item that is returned more than 30 days after delivery</li>\n</ul>\n<!-- /wp:list -->\n\n<!-- wp:paragraph -->\n<h2>Refunds</h2>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Once your return is received and inspected, we will send you an email to notify you that we have received your returned item. We will also notify you of the approval or rejection of your refund.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If you are approved, then your refund will be processed, and a credit will automatically be applied to your credit card or original method of payment, within a certain amount of days.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h3 class=\"wp-block-heading\">Late or missing refunds</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>If you haven’t received a refund yet, first check your bank account again.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Then contact your credit card company, it may take some time before your refund is officially posted.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Next contact your bank. There is often some processing time before a refund is posted.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If you’ve done all of this and you still have not received your refund yet, please contact us at {email address}.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:heading -->\n<h3 class=\"wp-block-heading\">Sale items</h3>\n<!-- /wp:heading -->\n\n<!-- wp:paragraph -->\n<p>Only regular priced items may be refunded. Sale items cannot be refunded.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<h2>Exchanges</h2>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>We only replace items if they are defective or damaged. If you need to exchange it for the same item, send us an email at {email address} and send your item to: {physical address}.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<h2>Gifts</h2>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If the item was marked as a gift when purchased and shipped directly to you, you’ll receive a gift credit for the value of your return. Once the returned item is received, a gift certificate will be mailed to you.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If the item wasn’t marked as a gift when purchased, or the gift giver had the order shipped to themselves to give to you later, we will send a refund to the gift giver and they will find out about your return.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<h2>Shipping returns</h2>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>To return your product, you should mail your product to: {physical address}.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>You will be responsible for paying for your own shipping costs for returning your item. Shipping costs are non-refundable. If you receive a refund, the cost of return shipping will be deducted from your refund.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Depending on where you live, the time it may take for your exchanged product to reach you may vary.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>If you are returning more expensive items, you may consider using a trackable shipping service or purchasing shipping insurance. We don’t guarantee that we will receive your returned item.</p>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<h2>Need help?</h2>\n<!-- /wp:paragraph -->\n\n<!-- wp:paragraph -->\n<p>Contact us at {email} for questions related to refunds and returns.</p>\n<!-- /wp:paragraph -->", "Política de devolução e reembolso", "", "inherit", "closed", "closed", "", "48-revision-v1", "", "", "2025-09-15 14:30:25", "2025-09-15 14:30:25", "", "48", "https://xpharma.digitalpath.pt/?p=129", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("130", "1", "2025-09-15 14:30:46", "2025-09-15 14:30:46", "[vc_row width=\"full\"][vc_column width=\"1/1\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" autoplay=\"1\" autoplay_timeout=\"5s\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"12px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23f0f0f0%22%2C%22background-image%22%3A%22339%22%2C%22background-position%22%3A%22right%20center%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%223.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%223.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%223.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\"][vc_row_inner columns=\"2\" columns_gap=\"0rem\"][vc_column_inner width=\"3/4\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_top_text%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.5%22%2C%22font-weight%22%3A%22500%22%7D%7D\"]Na <strong>XPharma</strong>, somos o seu aliado de confiança na aquisição de medicamentos importados para uso humano e veterinário.\r\n\r\nMais do que um fornecedor, somos o seu parceiro estratégico.\r\n\r\n<strong>Valorizamos as relações que construímos.</strong> Acreditamos que o verdadeiro impacto surge da confiança e da colaboração com todos os nossos parceiros.\r\n\r\nO nosso compromisso vai além da entrega de medicamentos: <strong>procuramos soluções eficazes e seguras,</strong> adaptadas às necessidades terapêuticas e às exigências do mercado.\r\n\r\nPorque na XPharma, <strong>as ligações estão no centro de tudo o que fazemos!</strong>[/vc_column_text][us_hwrapper valign=\"middle\" inner_items_gap=\"1.8rem\" stack_on_mobiles=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.8rem%22%7D%7D\"][us_btn label=\"Os nossos Serviços\" link=\"%7B%22url%22%3A%22%23servicos%22%7D\" style=\"2\" icon=\"fal|long-arrow-right\" iconpos=\"right\"][us_btn label=\"Áreas de Atuação\" link=\"%7B%22url%22%3A%22%23areas-atuacao%22%7D\" style=\"2\" icon=\"fal|long-arrow-right\" iconpos=\"right\"][/us_hwrapper][/vc_column_inner][vc_column_inner width=\"1/4\"][/vc_column_inner][/vc_row_inner][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%224.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%224.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%224.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%7D\"][/vc_column][/vc_row][vc_row width=\"full\" content_placement=\"middle\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22333%22%2C%22background-position%22%3A%22left%20bottom%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\" el_id=\"sobre-nos\"][vc_column link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/1\"][vc_row_inner columns=\"5-7\" content_placement=\"middle\" css=\"%7B%22default%22%3A%7B%22padding-right%22%3A%228vw%22%7D%7D\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22484%22%2C%22background-position%22%3A%22left%20top%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22425px%22%7D%7D\" width=\"5/12\"][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22padding-left%22%3A%222rem%22%7D%7D\" width=\"7/12\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%223rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%223rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%223rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][us_hwrapper valign=\"middle\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%221.5rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\"][us_text text=\"Quem somos\" link=\"%7B%22url%22%3A%22%22%7D\" tag=\"h2\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\"][us_image image=\"123\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%7D\"][/us_hwrapper][vc_column_text]A XPharma nasceu de uma visão compartilhada por duas profissionais com vasta experiência no mercado farmacêutico. O nosso objetivo era criar uma empresa que fosse além da distribuição tradicional, com um serviço de Procurement altamente diferenciado. Mas, acima de tudo, a nossa base foi construída e assente em princípios de parcerias genuínas com clientes e fornecedores, alicerçada num ambiente de trabalho que valoriza a nossa equipa e o equilíbrio entre a vida profissional e pessoal.[/vc_column_text][us_popup use_page_block=\"346\" popup_width=\"80vw\" popup_padding=\"\" content_bgcolor=\"\" content_textcolor=\"_branco\" overlay_bgcolor=\"rgba(47,29,48,0.97)\" closer_color=\"_fundo2\" btn_label=\"Conheça-nos melhor\" btn_style=\"2\" align=\"left\" btn_icon=\"fal|long-arrow-right\" btn_iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" el_class=\"pop1\"]\r\n<h3>A Nossa História</h3>\r\nA XPharma nasceu de uma visão partilhada por duas profissionais com vasta experiência no mercado farmacêutico. O nosso objetivo era criar uma empresa que fosse além da distribuição tradicional, com um serviço de Procurement altamente diferenciado. Mas, acima de tudo, a nossa base foi construída e assente em princípios de parcerias genuínas com clientes e fornecedores, alicerçada num ambiente de trabalho que valoriza a nossa equipa e o equilíbrio entre a vida profissional e pessoal.\r\n\r\nAcreditamos que a nossa identidade está na nossa história. Cada detalhe, desde o logo às cores que nos representam, foi cuidadosamente pensado para refletir a nossa filosofia. Para nós, a ética, a inovação e o bem-estar da nossa equipa caminham lado a lado, e são esses pilares que guiam cada decisão e projeto que abraçamos.\r\n\r\nFundada em 2020, a XPharma tem superado desafios e conquistado o sucesso em projetos complexos, e isso é um reflexo direto do nosso compromisso com as pessoas. A nossa equipa, motivada por um ambiente de trabalho saudável e pela paixão pelo que faz, é composta por especialistas que usam o seu conhecimento profundo para garantir soluções que superem as expectativas. Estamos aqui para ser o seu parceiro estratégico no mercado de medicamentos, com agilidade, confiabilidade e um compromisso inabalável com a excelência, sustentado por um negócio que se preocupa com as suas pessoas.[/us_popup][/vc_column_inner][/vc_row_inner][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%226rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%226rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%226rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%223rem%22%7D%7D\"][/vc_column][/vc_row][vc_row width=\"full\" columns=\"custom\" columns_layout=\"1.5fr 1.5fr 3fr\" columns_gap=\"0rem\"][vc_column link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22469%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22541px%22%7D%7D\" width=\"1/4\"][/vc_column][vc_column link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22padding-left%22%3A%220px%22%2C%22padding-top%22%3A%220px%22%2C%22padding-bottom%22%3A%220px%22%2C%22padding-right%22%3A%220px%22%7D%7D\" width=\"1/4\"][vc_row_inner columns_gap=\"0rem\" content_placement=\"middle\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_principal%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\" width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][us_text text=\"A nossa Missão\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]O nosso propósito é estabelecer o acesso a medicamentos não disponíveis por qualquer razão (ruturas, descontinuados ou não comercializados) com precisão, agilidade e, acima de tudo, com um profundo compromisso com o paciente.[/vc_column_text][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][/vc_column_inner][/vc_row_inner][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_dark%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\" width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][us_text text=\"Os nossos Valores\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]Os nossos pilares valorizam a Confiança juntamente com o acesso à saúde para todos e as pessoas em primeiro lugar.[/vc_column_text][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][/vc_column_inner][/vc_row_inner][/vc_column][vc_column width=\"1/2\"][vc_row_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22482%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22289px%22%7D%7D\" width=\"1/1\"][/vc_column_inner][/vc_row_inner][vc_row_inner columns=\"5-7\" columns_gap=\"0rem\" content_placement=\"middle\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23757575%22%2C%22padding-left%22%3A%222rem%22%2C%22padding-right%22%3A%222rem%22%7D%7D\" width=\"5/12\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][us_text text=\"A nossa Visão\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_header_middle_bg%22%2C%22font-size%22%3A%221.3rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22500%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]Queremos ser reconhecidos como especialistas no procurement de medicamentos de importação e exportação, com sólidas relações que impulsionem o crescimento de todos.[/vc_column_text][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%22461%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22330px%22%7D%7D\" width=\"7/12\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row columns_gap=\"0rem\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%224rem%22%7D%7D\"][us_hwrapper valign=\"middle\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%22.8rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\"][us_text text=\"A nossa equipa\" link=\"%7B%22url%22%3A%22%22%7D\" tag=\"h2\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\"][us_image image=\"123\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%7D\"][/us_hwrapper][vc_column_text]Conheça a equipa que todos os dias garante a solução das suas necessidades.[/vc_column_text][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][/vc_column][/vc_row][vc_row columns=\"2\" columns_gap=\"0.5rem\" hide_on_states=\"mobiles\"][vc_column width=\"1/2\"][us_image image=\"477\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\"][/vc_column][vc_column width=\"1/2\"][vc_row_inner columns=\"3\" columns_gap=\"0.5rem\"][vc_column_inner width=\"1/3\"][us_ibanner image=\"489\" size=\"full\" title=\"Paula Valente\" title_size=\"1rem\" desc=\"Assistente Comercial\" link=\"%7B%22url%22%3A%22%22%7D\" ratio=\"3x4\" animation=\"phorcys\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"1/3\"][us_ibanner image=\"491\" size=\"full\" title=\"Carlos Silva\" title_size=\"1rem\" desc=\"Assistente Comercial\" link=\"%7B%22url%22%3A%22%22%7D\" ratio=\"3x4\" animation=\"phorcys\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"1/3\"][us_ibanner image=\"490\" size=\"full\" title=\"Cátia Poças\" title_size=\"1rem\" desc=\"Diretora Técnica\" link=\"%7B%22url%22%3A%22%22%7D\" ratio=\"3x4\" animation=\"phorcys\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\"][/vc_column_inner][/vc_row_inner][vc_row_inner columns=\"3\" columns_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][vc_column_inner width=\"1/3\"][us_ibanner image=\"367\" size=\"full\" title=\"Debora Fontes\" title_size=\"1rem\" desc=\"Sales Manager &amp; Business Development\" link=\"%7B%22url%22%3A%22%22%7D\" ratio=\"3x4\" animation=\"phorcys\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"1/3\"][us_ibanner image=\"366\" size=\"full\" title=\"Anne Monteiro\" title_size=\"1rem\" desc=\"Procurement &amp; Purchasing Manager\" link=\"%7B%22url%22%3A%22%22%7D\" ratio=\"3x4\" animation=\"phorcys\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row columns_gap=\"0.5rem\" hide_on_states=\"default,laptops,tablets\"][vc_column width=\"1/1\"][us_image image=\"477\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\"][vc_row_inner columns=\"2\" mobiles_columns=\"2\" columns_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][vc_column_inner width=\"1/2\"][us_ibanner image=\"489\" size=\"full\" title=\"Paula Valente\" title_size=\"1rem\" desc=\"Assistente Comercial\" link=\"%7B%22url%22%3A%22%22%7D\" ratio=\"3x4\" animation=\"phorcys\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"1/2\"][us_ibanner image=\"491\" size=\"full\" title=\"Carlos Silva\" title_size=\"1rem\" desc=\"Assistente Comercial\" link=\"%7B%22url%22%3A%22%22%7D\" ratio=\"3x4\" animation=\"phorcys\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\"][/vc_column_inner][/vc_row_inner][vc_row_inner columns=\"2\" mobiles_columns=\"2\" columns_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][vc_column_inner width=\"1/2\"][us_ibanner image=\"490\" size=\"full\" title=\"Cátia Poças\" title_size=\"1rem\" desc=\"Diretora Técnica\" link=\"%7B%22url%22%3A%22%22%7D\" ratio=\"3x4\" animation=\"phorcys\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"1/2\"][us_ibanner image=\"367\" size=\"full\" title=\"Debora Fontes\" title_size=\"1rem\" desc=\"Sales Manager &amp; Business Development\" link=\"%7B%22url%22%3A%22%22%7D\" ratio=\"3x4\" animation=\"phorcys\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\"][/vc_column_inner][/vc_row_inner][vc_row_inner columns=\"2\" mobiles_columns=\"2\" columns_gap=\"0.5rem\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][vc_column_inner width=\"1/2\"][us_ibanner image=\"366\" size=\"full\" title=\"Anne Monteiro\" title_size=\"1rem\" desc=\"Procurement &amp; Purchasing Manager\" link=\"%7B%22url%22%3A%22%22%7D\" ratio=\"3x4\" animation=\"phorcys\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.7rem%22%2C%22line-height%22%3A%22.9%22%2C%22font-style%22%3A%22italic%22%2C%22background-color%22%3A%22_dark%22%7D%7D\"][/vc_column_inner][vc_column_inner width=\"1/2\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%224rem%22%2C%22margin-bottom%22%3A%222rem%22%7D%7D\" el_id=\"servicos\"][vc_column width=\"1/1\"][us_hwrapper valign=\"middle\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%221.5rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\"][us_text text=\"Os nossos Serviços\" link=\"%7B%22url%22%3A%22%22%7D\" tag=\"h2\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\"][us_image image=\"123\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22laptops%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22tablets%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22mobiles%22%3A%7B%22width%22%3A%2235px%22%2C%22height%22%3A%221px%22%7D%7D\"][/us_hwrapper][/vc_column][/vc_row][vc_row width=\"full\" columns=\"3\" columns_gap=\"0rem\" content_placement=\"bottom\" css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2294%22%2C%22background-position%22%3A%22center%20bottom%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\"][vc_column link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22560px%22%7D%2C%22laptops%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22tablets%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22mobiles%22%3A%7B%22min-height%22%3A%22120px%22%7D%7D\" el_class=\"hoverpurple1\" width=\"1/3\"][vc_row_inner el_class=\"shift01 mousepoint\" el_id=\"popfornecimento\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22laptops%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22tablets%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22mobiles%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%22.3rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\" width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%2230px%22%7D%7D\"][us_image image=\"108\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%2284px%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\" hide_on_states=\"mobiles\"]Fornecimento\r\nde Medicamentos\r\nde Difícil Acesso:[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"]Fornecimento de Medicamentos de Difícil Acesso:[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]Encontrar medicamentos de difícil acesso é um desafio complexo. Oferecemos um serviço de procurement especializado com a missão de encontrar e entregar soluções para o mercado de saúde humana e animal.[/vc_column_text][us_text text=\"Saiba mais\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fal|long-arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_fundo2%22%2C%22font-size%22%3A%2213px%22%2C%22line-height%22%3A%221.2%22%2C%22letter-spacing%22%3A%220.04em%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%221.5rem%22%7D%7D\"][us_popup popup_width=\"60vw\" popup_padding=\"\" title_bgcolor=\"\" title_textcolor=\"\" content_bgcolor=\"\" content_textcolor=\"_branco\" overlay_bgcolor=\"rgba(47,29,48,0.97)\" closer_color=\"_fundo2\" show_on=\"selector\" trigger_selector=\"#popfornecimento\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" el_class=\"pop1\"]\r\n<h3>Fornecimento de Medicamentos de Difícil Acesso</h3>\r\nEncontrar medicamentos de difícil acesso é um desafio complexo. Oferecemos um serviço de procurement especializado com a missão de encontrar e entregar soluções para o mercado de saúde humana e animal que não estão facilmente disponíveis, seja por rupturas de stock ou por não serem acessíveis no mercado nacional. O nosso expertise é o nosso maior diferencial. Com uma equipa de profissionais que construíram carreiras sólidas nas áreas comercial e técnica e com uma robusta rede de parceiros, conseguimos navegar pelo mercado global com precisão. Estamos sempre à frente, antecipando as necessidades do mercado e garantindo que os pacientes e as instituições não ficam sem o acesso a tratamentos cruciais.[/us_popup][/vc_column_inner][/vc_row_inner][/vc_column][vc_column link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22560px%22%2C%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%221px%22%2C%22border-color%22%3A%22%23767b96%22%7D%2C%22laptops%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22tablets%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22mobiles%22%3A%7B%22min-height%22%3A%22120px%22%7D%7D\" el_class=\"hoverpurple1\" width=\"1/3\"][vc_row_inner el_class=\"shift01 mousepoint\" el_id=\"popimportacao\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22laptops%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22tablets%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22mobiles%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%22.3rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\" width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%2230px%22%7D%7D\" hide_on_states=\"mobiles\"][us_image image=\"109\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%2284px%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\" hide_on_states=\"mobiles\"]Importação\r\ne Exportação:\r\nA Nossa Ponte Global[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"]Importação e Exportação:\r\nA Nossa Ponte Global[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]O fornecimento de medicamentos de difícil acesso é, por natureza, uma operação global. A nossa competência em importação e exportação é a chave para o sucesso dos nossos projetos.[/vc_column_text][us_text text=\"Saiba mais\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fal|long-arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_fundo2%22%2C%22font-size%22%3A%2213px%22%2C%22line-height%22%3A%221.2%22%2C%22letter-spacing%22%3A%220.04em%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%221.5rem%22%7D%7D\"][us_popup popup_width=\"60vw\" popup_padding=\"\" title_bgcolor=\"\" title_textcolor=\"\" content_bgcolor=\"\" content_textcolor=\"_branco\" overlay_bgcolor=\"rgba(47,29,48,0.97)\" closer_color=\"_fundo2\" show_on=\"selector\" trigger_selector=\"#popimportacao\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" el_class=\"pop1\"]\r\n<h3>Importação e Exportação: A Nossa Ponte Global</h3>\r\nO fornecimento de medicamentos de difícil acesso é, por natureza, uma operação global. A nossa competência em importação e exportação é a chave para o sucesso dos nossos projetos.\r\n\r\nA equipa da XPharma é especialista em todo o processo, desde a negociação e aquisição de produtos no mercado internacional até à entrega final. Gerimos todas as etapas, incluindo a análise de requisitos regulatórios, o controlo rigoroso da documentação e a logística especializada que garante a integridade dos produtos durante o transporte. Com a XPharma, a sua operação de comércio internacional de medicamentos está em mãos experientes, assegurando a confiança e a tranquilidade em cada etapa.[/us_popup][/vc_column_inner][/vc_row_inner][/vc_column][vc_column link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22min-height%22%3A%22560px%22%2C%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%221px%22%2C%22border-color%22%3A%22%23767b96%22%7D%2C%22laptops%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22tablets%22%3A%7B%22min-height%22%3A%22560px%22%7D%2C%22mobiles%22%3A%7B%22min-height%22%3A%22120px%22%7D%7D\" el_class=\"hoverpurple1\" width=\"1/3\"][vc_row_inner el_class=\"shift01 mousepoint\" el_id=\"poplogistica\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%223rem%22%2C%22padding-bottom%22%3A%223rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\" width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%22120px%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%2230px%22%7D%7D\" hide_on_states=\"mobiles\"][us_image image=\"110\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%2284px%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\" hide_on_states=\"mobiles\"]Logística\r\ne Qualidade:[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\" hide_on_states=\"default,laptops,tablets\"]Logística e Qualidade:[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]A confiança é construída sobre a excelência dos processos e por isso a nossa gestão de logística é fundamentada em rigorosos padrões de qualidade e nas Boas Práticas de Distribuição (BPD).[/vc_column_text][us_text text=\"Saiba mais\" link=\"%7B%22url%22%3A%22%22%7D\" icon=\"fal|long-arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22color%22%3A%22_fundo2%22%2C%22font-size%22%3A%2213px%22%2C%22line-height%22%3A%221.2%22%2C%22letter-spacing%22%3A%220.04em%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%221.5rem%22%7D%7D\"][us_popup popup_width=\"60vw\" popup_padding=\"\" title_bgcolor=\"\" title_textcolor=\"\" content_bgcolor=\"\" content_textcolor=\"_branco\" overlay_bgcolor=\"rgba(47,29,48,0.97)\" closer_color=\"_fundo2\" show_on=\"selector\" trigger_selector=\"#poplogistica\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\" el_class=\"pop1\"]\r\n<h3>Logística e Qualidade</h3>\r\nA confiança é construída sobre a excelência dos processos e por isso a nossa gestão de logística é fundamentada em rigorosos padrões de qualidade e nas Boas Práticas de Distribuição (BPD). O nosso compromisso com estas normas é a garantia de que cada medicamento é tratado com o máximo cuidado.\r\n\r\nA rastreabilidade total e o transporte em condições controladas — incluindo a rigorosa gestão da cadeia de frio — são parte integrante do nosso serviço. A XPharma não entrega apenas medicamentos, mas também a tranquilidade de saber que a sua cadeia de distribuição é segura, fiável e opera com os mais altos padrões do setor.[/us_popup][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_fundo1%22%2C%22background-image%22%3A%2292%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%7D%7D\" el_id=\"areas-atuacao\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%224rem%22%7D%7D\"][us_hwrapper valign=\"middle\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-bottom%22%3A%221.5rem%22%2C%22animation-name%22%3A%22afl%22%2C%22animation-delay%22%3A%22100ms%22%7D%7D\"][us_text text=\"Áreas de Atuação\" link=\"%7B%22url%22%3A%22%22%7D\" tag=\"h2\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221.8rem%22%2C%22line-height%22%3A%221.4%22%2C%22font-weight%22%3A%22600%22%2C%22margin-bottom%22%3A%220rem%22%7D%7D\"][us_image image=\"123\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22laptops%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22tablets%22%3A%7B%22width%22%3A%2275px%22%2C%22height%22%3A%221px%22%7D%2C%22mobiles%22%3A%7B%22width%22%3A%2220px%22%2C%22height%22%3A%221px%22%7D%7D\"][/us_hwrapper][vc_row_inner columns=\"2-1\" disable_element=\"yes\"][vc_column_inner width=\"2/3\"][vc_column_text]A XPharma é um parceiro estratégico para o setor da saúde, especializado no fornecimento de soluções que atendem a uma ampla gama de necessidades terapêuticas e de mercado.[/vc_column_text][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][/vc_row_inner][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%2C%22laptops%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%2C%22tablets%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%2C%22mobiles%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%222.4rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/1\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_link%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\"]Especialidades Terapêuticas[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner columns=\"5\" columns_gap=\"1.2rem\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/5\"][us_iconbox img=\"111\" link=\"%7B%22url%22%3A%22%22%7D\" size=\"54px\" iconpos=\"left\" alignment=\"left\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\"]Oncologia[/us_iconbox][/vc_column_inner][vc_column_inner width=\"1/5\"][us_iconbox icon=\"\" img=\"112\" link=\"%7B%22url%22%3A%22%22%7D\" size=\"54px\" iconpos=\"left\" alignment=\"left\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\"]Doenças Raras[/us_iconbox][/vc_column_inner][vc_column_inner width=\"1/5\"][us_iconbox icon=\"\" img=\"113\" link=\"%7B%22url%22%3A%22%22%7D\" size=\"54px\" iconpos=\"left\" alignment=\"left\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\"]Imunologia[/us_iconbox][/vc_column_inner][vc_column_inner width=\"1/5\"][us_iconbox img=\"114\" link=\"%7B%22url%22%3A%22%22%7D\" size=\"54px\" iconpos=\"left\" alignment=\"left\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\"]Antibióticos[/us_iconbox][/vc_column_inner][vc_column_inner width=\"1/5\"][us_iconbox img=\"115\" link=\"%7B%22url%22%3A%22%22%7D\" size=\"54px\" iconpos=\"left\" alignment=\"left\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\"]Suplementos\r\nAlimentares[/us_iconbox][/vc_column_inner][/vc_row_inner][vc_row_inner columns=\"1-3-1\" columns_gap=\"0.4rem\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/5\"][us_iconbox img=\"116\" link=\"%7B%22url%22%3A%22%22%7D\" size=\"54px\" iconpos=\"left\" alignment=\"left\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\"]Medicamentos\r\nVeterinários[/us_iconbox][/vc_column_inner][vc_column_inner width=\"3/5\"][us_iconbox img=\"117\" link=\"%7B%22url%22%3A%22%22%7D\" size=\"54px\" iconpos=\"left\" alignment=\"left\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\"]E outras áreas especializadas[/us_iconbox][/vc_column_inner][vc_column_inner width=\"1/5\"][/vc_column_inner][/vc_row_inner][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22.5rem%22%7D%7D\"][vc_row_inner css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%222.4rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%2C%22position%22%3A%22relative%22%2C%22z-index%22%3A%2222%22%7D%7D\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/1\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_link%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\"]Tipos de Clientes[/vc_column_text][/vc_column_inner][/vc_row_inner][vc_row_inner columns=\"3\" columns_gap=\"1.2rem\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%221rem%22%2C%22padding-right%22%3A%223rem%22%2C%22position%22%3A%22relative%22%2C%22z-index%22%3A%2222%22%7D%7D\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/3\"][us_iconbox img=\"118\" link=\"%7B%22url%22%3A%22%22%7D\" size=\"54px\" iconpos=\"left\" alignment=\"left\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\"]Hospitais (Públicos e Privados) e Clínicas[/us_iconbox][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/3\"][us_iconbox img=\"120\" link=\"%7B%22url%22%3A%22%22%7D\" size=\"54px\" iconpos=\"left\" alignment=\"left\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\"]Instituições Governamentais de Saúde[/us_iconbox][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/3\"][us_iconbox img=\"119\" link=\"%7B%22url%22%3A%22%22%7D\" size=\"54px\" iconpos=\"left\" alignment=\"left\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\"]Hospitais e Clínicas Veterinárias[/us_iconbox][/vc_column_inner][/vc_row_inner][vc_row_inner columns=\"3\" columns_gap=\"1.2rem\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%2C%22position%22%3A%22relative%22%2C%22z-index%22%3A%2222%22%7D%2C%22laptops%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22tablets%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%7D%2C%22mobiles%22%3A%7B%22padding-left%22%3A%223rem%22%2C%22padding-top%22%3A%22.1rem%22%2C%22padding-bottom%22%3A%222.2rem%22%2C%22padding-right%22%3A%223rem%22%7D%7D\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/3\"][us_iconbox img=\"121\" link=\"%7B%22url%22%3A%22%22%7D\" size=\"54px\" iconpos=\"left\" alignment=\"left\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\"]Distribuidores de Medicamentos[/us_iconbox][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/3\"][us_iconbox img=\"122\" link=\"%7B%22url%22%3A%22%22%7D\" size=\"54px\" iconpos=\"left\" alignment=\"left\" css=\"%7B%22default%22%3A%7B%22font-size%22%3A%221rem%22%2C%22line-height%22%3A%221.2%22%7D%7D\"]Farmácias[/us_iconbox][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_branco%22%2C%22z-index%22%3A%2222%22%7D%7D\" hide_on_states=\"mobiles\" width=\"1/3\"][/vc_column_inner][/vc_row_inner][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-image%22%3A%2293%22%2C%22background-position%22%3A%22center%22%2C%22background-size%22%3A%22cover%22%2C%22background-repeat%22%3A%22no-repeat%22%2C%22background-attachment%22%3A%22fixed%22%2C%22margin-top%22%3A%22-140px%22%2C%22z-index%22%3A%2210%22%7D%7D\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22150px%22%7D%7D\"][vc_row_inner columns=\"3\" columns_gap=\"1.5rem\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_secundaria%22%2C%22padding-left%22%3A%222.5rem%22%2C%22padding-top%22%3A%222.5rem%22%2C%22padding-bottom%22%3A%222.5rem%22%2C%22padding-right%22%3A%222.5rem%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"]Representação Local[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]Atuamos como o seu representante local, oferecendo uma porta de entrada estratégica para o mercado português. A nossa equipa e a nossa infraestrutura estão prontas para atuar como uma extensão da sua empresa.[/vc_column_text][us_popup popup_width=\"60vw\" popup_padding=\"\" title_bgcolor=\"\" title_textcolor=\"\" content_bgcolor=\"\" content_textcolor=\"_branco\" overlay_bgcolor=\"rgba(47,29,48,0.97)\" closer_color=\"_fundo2\" btn_label=\"Saiba mais\" btn_style=\"6\" align=\"left\" btn_icon=\"fal|long-arrow-right\" btn_iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\" el_class=\"pop1\"]\r\n<h3>Representação Local</h3>\r\nAtuamos como o seu representante local, oferecendo uma porta de entrada estratégica para o mercado português. A nossa equipa e a nossa infraestrutura estão prontas para atuar como uma extensão da sua empresa. Com um profundo conhecimento das regulamentações e dinâmicas do mercado nacional, garantimos que os seus produtos sejam representados e distribuídos com a máxima eficiência, permitindo que a sua marca cresça com sucesso.[/us_popup][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22_principal%22%2C%22padding-left%22%3A%222.5rem%22%2C%22padding-top%22%3A%222.5rem%22%2C%22padding-bottom%22%3A%222.5rem%22%2C%22padding-right%22%3A%222.5rem%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"]Serviço\r\nde Armazenamento\r\ne Distribuição[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]Disponibilizamos um serviço de gestão de cadeia de abastecimento que integra armazenamento e distribuição de forma transparente e eficiente.[/vc_column_text][us_popup popup_width=\"60vw\" popup_padding=\"\" title_bgcolor=\"\" title_textcolor=\"\" content_bgcolor=\"\" content_textcolor=\"_branco\" overlay_bgcolor=\"rgba(47,29,48,0.97)\" closer_color=\"_fundo2\" btn_label=\"Saiba mais\" btn_style=\"6\" align=\"left\" btn_icon=\"fal|long-arrow-right\" btn_iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\" el_class=\"pop1\"]\r\n<h3>Serviço de Armazenamento e Distribuição</h3>\r\nDisponibilizamos um serviço de gestão de cadeia de abastecimento que integra armazenamento e distribuição de forma transparente e eficiente. Para garantir o mais alto nível de qualidade, a XPharma conta com um parceiro logístico que é um dos maiores grupos farmacêuticos em Portugal, com um rigoroso controlo de temperatura, inclusive ao longo de toda a cadeia de frio, operando em total conformidade com as Boas Práticas de Distribuição (BPD). Esta colaboração assegura que os medicamentos cheguem aos clientes no prazo e em perfeitas condições, cumprindo todos os padrões de qualidade.[/us_popup][/vc_column_inner][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%23757575%22%2C%22padding-left%22%3A%222.5rem%22%2C%22padding-top%22%3A%222.5rem%22%2C%22padding-bottom%22%3A%222.5rem%22%2C%22padding-right%22%3A%222.5rem%22%7D%7D\" width=\"1/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.1rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%221rem%22%7D%7D\"]Fornecimento\r\nde Medicamentos\r\npara Estudos Clínicos[/vc_column_text][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%22.9rem%22%2C%22line-height%22%3A%221.5%22%7D%7D\"]Somos especialistas na gestão de uma cadeia de abastecimento altamente controlada e sensível, assegurando a disponibilidade pontual de medicamentos de investigação para os centros de estudo.[/vc_column_text][us_popup popup_width=\"60vw\" popup_padding=\"\" title_bgcolor=\"\" title_textcolor=\"\" content_bgcolor=\"\" content_textcolor=\"_branco\" overlay_bgcolor=\"rgba(47,29,48,0.97)\" closer_color=\"_fundo2\" btn_label=\"Saiba mais\" btn_style=\"6\" align=\"left\" btn_icon=\"fal|long-arrow-right\" btn_iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\" el_class=\"pop1\"]\r\n<h3>Fornecimento de Medicamentos para Estudos Clínicos</h3>\r\nSomos especialistas na gestão de uma cadeia de abastecimento altamente controlada e sensível, assegurando a disponibilidade pontual de medicamentos de investigação para os centros de estudo.\r\nO nosso serviço garante que o seu projeto de investigação não seja comprometido, com total aderência aos protocolos e requisitos regulatórios.[/us_popup][/vc_column_inner][/vc_row_inner][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%228rem%22%7D%7D\"][/vc_column][/vc_row]", "Homepage Xpharma", "", "publish", "closed", "closed", "", "homepage-xpharma", "", "", "2025-10-15 09:01:47", "2025-10-15 09:01:47", "", "0", "https://xpharma.digitalpath.pt/?page_id=130", "0", "page", "", "0");
INSERT INTO `wp_posts` VALUES("131", "1", "2025-09-15 14:30:46", "2025-09-15 14:30:46", "", "Homepage Xpharma", "", "inherit", "closed", "closed", "", "130-revision-v1", "", "", "2025-09-15 14:30:46", "2025-09-15 14:30:46", "", "130", "https://xpharma.digitalpath.pt/?p=131", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("132", "1", "2025-09-15 14:31:00", "2025-09-15 14:31:00", "<p>[vc_row width=\"full\"][vc_column width=\"1/1\"][us_carousel post_type=\"slide-carross\" items_quantity=\"-1\" items_layout=\"9\" items_gap=\"0rem\" overriding_link=\"%7B%22url%22%3A%22%22%7D\" items=\"1\" autoplay=\"1\" autoplay_timeout=\"5s\" arrows=\"1\" arrows_size=\"1.2rem\" arrows_pos=\"inside\" arrows_offset=\"12px\" responsive=\"%5B%7B%22breakpoint%22%3A%22mobiles%22%2C%22breakpoint_width%22%3A%221024px%22%2C%22items%22%3A%221%22%2C%22items_offset%22%3A%220px%22%2C%22center_item%22%3A%220%22%2C%22autoheight%22%3A%220%22%2C%22loop%22%3A%220%22%2C%22autoplay%22%3A%220%22%2C%22arrows%22%3A%220%22%2C%22dots%22%3A%220%22%7D%5D\"][/vc_column][/vc_row]</p>\r\n", "Homepage Xpharma", "", "inherit", "closed", "closed", "", "130-revision-v1", "", "", "2025-09-15 14:31:00", "2025-09-15 14:31:00", "", "130", "https://xpharma.digitalpath.pt/?p=132", "0", "revision", "", "0");
INSERT INTO `wp_posts` VALUES("133", "1", "2025-09-15 14:44:19", "2025-09-15 14:44:19", "", "MID_XPharma_agua-4", "", "inherit", "", "closed", "", "mid_xpharma_agua-4", "", "", "2025-09-15 14:44:19", "2025-09-15 14:44:19", "", "0", "https://xpharma.digitalpath.pt/wp-content/uploads/2025/09/MID_XPharma_agua-4.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("134", "1", "2025-09-15 15:54:15", "2025-09-15 15:54:15", "", "Sobre nós", "", "publish", "closed", "closed", "", "sobre-nos", "", "", "2025-09-15 15:54:15", "2025-09-15 15:54:15", "", "0", "https://xpharma.digitalpath.pt/?p=134", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("135", "1", "2025-09-15 15:54:15", "2025-09-15 15:54:15", "", "Serviços", "", "publish", "closed", "closed", "", "servicos", "", "", "2025-09-15 15:54:15", "2025-09-15 15:54:15", "", "0", "https://xpharma.digitalpath.pt/?p=135", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("136", "1", "2025-09-15 15:54:15", "2025-09-15 15:54:15", "", "Áreas de atuação", "", "publish", "closed", "closed", "", "areas-de-atuacao", "", "", "2025-09-15 15:54:15", "2025-09-15 15:54:15", "", "0", "https://xpharma.digitalpath.pt/?p=136", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("137", "1", "2025-10-02 11:09:54", "2025-09-15 15:54:48", "", "Contactos", "", "publish", "closed", "closed", "", "contacto", "", "", "2025-10-02 11:09:54", "2025-10-02 11:09:54", "", "0", "https://xpharma.digitalpath.pt/?p=137", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_posts` VALUES("138", "1", "2025-09-15 15:58:31", "2025-09-15 15:58:31", "", "dekas_hr-1_negative", "", "inherit", "", "closed", "", "dekas_hr-1_negative", "", "", "2025-09-15 15:58:31", "2025-09-15 15:58:31", "", "12", "https://xpharma.digitalpath.pt/wp-content/uploads/2023/02/dekas_hr-1_negative.png", "0", "attachment", "image/png", "0");
INSERT INTO `wp_posts` VALUES("139", "1", "2025-09-15 15:59:16", "2025-09-15 15:59:16", "[vc_row us_bg_image_source=\"media\" us_bg_image=\"494\" us_bg_pos=\"top right\" us_bg_repeat=\"no-repeat\" columns_gap=\"0rem\" content_placement=\"bottom\" el_class=\"image-wrap\" el_id=\"desk\" hide_on_states=\"mobiles\"][vc_column link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%227vh%22%7D%7D\"][vc_row_inner columns_gap=\"0rem\" content_placement=\"bottom\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" width=\"2/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%222.1rem%22%2C%22line-height%22%3A%221%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%22.8rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22animation-name%22%3A%22aft%22%2C%22animation-delay%22%3A%22250ms%22%7D%7D\"]DEKAs é uma associação\r\nde vitaminas numa só formulação.\r\nAjudando os pacientes\r\na melhorar a absorção de vitaminas.[/vc_column_text][us_hwrapper valign=\"middle\" inner_items_gap=\"1.8rem\" stack_on_mobiles=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][us_btn label=\"Fibrose Quística\" link=\"%7B%22url%22%3A%22%23fibrosequistica%22%7D\" style=\"4\" icon=\"fal|long-arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%227px%22%2C%22border-color%22%3A%22%234472C4%22%7D%7D\"][us_btn label=\"Doença Hepática Colestática\" link=\"%7B%22url%22%3A%22%23doencahepatica%22%7D\" icon=\"fal|long-arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%227px%22%2C%22border-color%22%3A%22%23ED7D31%22%7D%7D\"][/us_hwrapper][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][/vc_row_inner][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%227vh%22%7D%7D\"][/vc_column][/vc_row][vc_row us_bg_image_source=\"media\" us_bg_image=\"494\" us_bg_pos=\"top left\" us_bg_repeat=\"no-repeat\" columns_gap=\"0rem\" content_placement=\"bottom\" el_class=\"image-wrap\" el_id=\"mobile\" hide_on_states=\"default,laptops,tablets\"][vc_column link=\"%7B%22url%22%3A%22%22%7D\" width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%22140px%22%7D%7D\"][vc_row_inner columns_gap=\"0rem\" content_placement=\"bottom\"][vc_column_inner link=\"%7B%22url%22%3A%22%22%7D\" width=\"2/3\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%222.1rem%22%2C%22line-height%22%3A%221%22%2C%22font-weight%22%3A%22300%22%2C%22margin-top%22%3A%22.8rem%22%2C%22margin-bottom%22%3A%222rem%22%2C%22animation-name%22%3A%22aft%22%2C%22animation-delay%22%3A%22250ms%22%7D%7D\"]DEKAs é uma associação\r\nde vitaminas numa só formulação.\r\nAjudando os pacientes\r\na melhorar a absorção de vitaminas.[/vc_column_text][us_hwrapper valign=\"middle\" inner_items_gap=\"1.8rem\" stack_on_mobiles=\"1\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221rem%22%7D%7D\"][us_btn label=\"Fibrose Quística\" link=\"%7B%22url%22%3A%22%23fibrosequistica%22%7D\" style=\"4\" icon=\"fal|long-arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%227px%22%2C%22border-color%22%3A%22%234472C4%22%7D%7D\"][us_btn label=\"Doença Hepática Colestática\" link=\"%7B%22url%22%3A%22%23doencahepatica%22%7D\" icon=\"fal|long-arrow-right\" iconpos=\"right\" css=\"%7B%22default%22%3A%7B%22border-style%22%3A%22solid%22%2C%22border-left-width%22%3A%227px%22%2C%22border-color%22%3A%22%23ED7D31%22%7D%7D\"][/us_hwrapper][/vc_column_inner][vc_column_inner width=\"1/3\"][/vc_column_inner][/vc_row_inner][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%227vh%22%7D%7D\"][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22background-color%22%3A%22%234472C4%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22laptops%22%3A%7B%22background-color%22%3A%22%234472C4%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22tablets%22%3A%7B%22background-color%22%3A%22%234472C4%22%2C%22background-image%22%3A%22280%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%2C%22mobiles%22%3A%7B%22background-color%22%3A%22%234472C4%22%2C%22background-image%22%3A%22%22%2C%22background-position%22%3A%22right%20top%22%2C%22background-repeat%22%3A%22no-repeat%22%7D%7D\" el_id=\"fibrosequistica\"][vc_column width=\"1/1\"][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%221.5rem%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_branco%22%2C%22font-size%22%3A%221.4rem%22%2C%22line-height%22%3A%221.5%22%2C%22font-weight%22%3A%22300%22%7D%7D\"]DEKAs para pacientes com <strong>Fibrose Quística</strong>.\r\nAlimento para fins medicinais específicos numa única formulação para pacientes de diferentes idades.[/vc_column_text][us_separator size=\"custom\" css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%222.5rem%22%7D%7D\"][/vc_column][/vc_row][vc_row css=\"%7B%22default%22%3A%7B%22margin-top%22%3A%223rem%22%7D%7D\"][vc_column width=\"1/4\"][us_image image=\"256\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\"]DEKAs Plus Líquido[/vc_column_text][vc_column_text]Solução oral com sabor agradável a pêssego e manga para administração a pacientes com dificuldades em ingerir comprimidos ou cápsulas. Contém minerais, antioxidantes e vitaminas B e C.[/vc_column_text][/vc_column][vc_column width=\"1/4\"][us_image image=\"257\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\"]DEKAs Plus Comprimidos Mastigáveis[/vc_column_text][vc_column_text]Comprimidos mastigáveis com sabor a pêssego, para pacientes a partir dos 4 anos de idade. Contém minerais, antioxidantes e vitaminas B e C.[/vc_column_text][/vc_column][vc_column width=\"1/4\"][us_image image=\"258\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\"]DEKAs Plus Cápsulas Moles[/vc_column_text][vc_column_text]Cápsulas moles cor de chocolate adequadas para pacientes a partir dos 10 anos de idade. Rico em vitamina D3 contendo igualmente minerais, antioxidantes e vitaminas B e C.[/vc_column_text][/vc_column][vc_column width=\"1/4\"][us_image image=\"459\" align=\"center\" size=\"full\" link=\"%7B%22url%22%3A%22%22%7D\" css=\"%7B%22default%22%3A%7B%22margin-left%22%3A%22auto%22%2C%22margin-right%22%3A%22auto%22%7D%7D\"][vc_column_text css=\"%7B%22default%22%3A%7B%22color%22%3A%22_secundaria%22%2C%22font-size%22%3A%221.2rem%22%2C%22line-height%22%3A%221.3%22%2C%22font-weight%22%3A%22600%22%2C%22margin-top%22%3A%22.5rem%22%2C%22margin-bottom%22%3A%22.5rem%22%7D%7D\"]DEKAs Essential Cápsulas[/vc_column_text][vc_column_text]Cápsulas contendo apenas as vitaminas lipossolúveis A, D, E e K. Não contêm minerais, antioxidantes ou vitaminas B e C.[/vc_column_text][/vc_column][/vc_row][vc_row][vc_column width=\"1/1\"][vc_column_text css=\"%7B%22defa