<?php
/* Custom functions code goes here. */


// The filter callback function.
 function turnoff_dhvc_bounce( $string ) {
	 // (maybe) modify $string.
	 return false;
 }
 add_filter( 'dhvc_form_submit_use_nonce', 'turnoff_dhvc_bounce', 10, 1 );
 
 
 //Allow shortcodes in widgets
 add_filter ('widget_text', 'do_shortcode');
 
 function year_shortcode () {
 $year = date_i18n ('Y');
 return $year;
 }
 add_shortcode ('year', 'year_shortcode');
 
 //Shortcodes to display logo marca
 function display_logo_marca_for_taxonomy($atts) {
      // Attributes for the shortcode (optional)
      $atts = shortcode_atts(
          array(
              'taxonomy' => 'marca-produto', // Default taxonomy
          ),
          $atts,
          'logo_marca'
      );
  
      // Get the current post ID
      $post_id = get_the_ID();
  
      // Get the terms of the specified taxonomy for this post
      $terms = get_the_terms($post_id, $atts['taxonomy']);
  
      // Ensure terms exist
      if (!$terms || is_wp_error($terms)) {
          return '<!-- No terms found for this taxonomy -->';
      }
  
      // Get the first term (adjust this logic if needed for multiple terms)
      $term = $terms[0];
  
      // Get the ACF field value for the term
      $logo_marca = get_field('logo_marca', $term);
  
      // Check if the field has a value
      if (empty($logo_marca)) {
          return '<!-- No logo_marca found for this term -->';
      }
  
      // Get the taxonomy archive URL
      $term_link = get_term_link($term);
  
      // Handle errors in getting the term link
      if (is_wp_error($term_link)) {
          return '<!-- Invalid term link -->';
      }
  
      // Output the image (assuming it's an image URL or an ACF image array)
      if (is_array($logo_marca) && isset($logo_marca['url'])) {
          $image_url = $logo_marca['url'];
      } elseif (is_string($logo_marca)) {
          $image_url = $logo_marca;
      } else {
          return '<!-- Invalid logo_marca data -->';
      }
  
      // Return the linked image HTML
      return '<a href="' . esc_url($term_link) . '" title="' . esc_attr($term->name) . '">
                  <img src="' . esc_url($image_url) . '" alt="' . esc_attr($term->name) . '" />
              </a>';
  }
  
  // Register the shortcode
  add_shortcode('logo_marca', 'display_logo_marca_for_taxonomy');
