<?php
/*
Plugin Name: Parcticle Backround for visual composer
Plugin URI: https://rcreators.com/vc/addons
Description: Extend Visual Composer row background option with particle background js
Version: 4.6
Author: Rcreators Websolutions
Author URI: https://rcreators.com
License: GPLv2 or later
*/

// don't load directly
if (!defined('ABSPATH')) die('-1');

class VCExtendAddonClass {
    function __construct() {
        // We safely integrate with VC with this hook
        add_action( 'init', array( $this, 'integrateWithVC' ) );
		
		add_filter('vc_shortcode_output',array($this, 'execute_rc_pb_shortcode'),10,3);
        // Register CSS and JS
        //add_action( 'wp_enqueue_scripts', array( $this, 'loadCssAndJs' ) );
		
		add_filter( 'vc_shortcodes_css_class', array($this, 'pb_css_classes'), 10, 2 );
    }
	
	function execute_rc_pb_shortcode($output, $obj, $attr) {
		if($obj->settings('base')=='vc_row') {
			$output .= $this->pb_shortcode($attr, '');
		}
		return $output;
	}
	
	public static function pb_shortcode($atts, $content){
		$pb_type = $pb_dot_color = $pb_line_color = $pb_particle_radius = $pb_line_width = $pb_min_speedx = $pb_max_speedx = $pb_min_speedy = $pb_max_speedy = $pb_directionx = $pb_directiony = $pb_particle_density = $pb_smoke_preset = $pb_sm_line_width =  $pb_bg_inner = $pb_bg_outer = $pb_gradient_end = $pb_gradient_start = $pb_num_circles = $pb_radius_size = $pb_smoke_opacity = $pb_speed = $pb_rain_bg = $pb_rain_preset = $pb_rain_img_blur = $pjs_shape = $pjs_img = $pjs_color = $pjs_stroke = $pjs_scolor = $pjs_sides = $pjs_count = $pjs_size = $pjs_srandom = $pjs_sanimate = $pjs_sanispeed = $pjs_smin = $pjs_opacity = $pjs_orandom = $pjs_oanimate = $pjs_oanispeed = $pjs_omin = $pjs_link = $pjs_ldistance = $pjs_lcolor = $pjs_lopacity = $pjs_lwidth = $pjs_move = $pjs_direction = $pjs_mrandom = $pjs_mstraight = $pjs_mspeed = $pjs_omode = $pjs_hover = $pjs_onhover = $pjs_click = $pjs_onclick = $fss_depth = $fss_segments = $fss_slices = $fss_xrange = $fss_yrange = $fss_zrange = $fss_mambient = $fss_mdiffuse = $fss_count = $fss_xyscalar = $fss_zofsset = $fss_lambient = $fss_ldiffuse = $bird_type = $bird_count = $swarm_count = $swarm_rcolor = $swarm_pcolor = $alian_count = $aliancolor1 = $aliancolor2 = $bgaliancolor1 = $bgaliancolor2 = $wavescolor = $spcolor = $mpcolor = $lpcolor = $lcolor1 = $lcolor2 = $lcolor3 = $spacepcolor = $spacepspeed = "";
		
		extract( shortcode_atts( array( "pb_type" => "", "pb_dot_color" => "", "pb_line_color" => "", "pb_particle_radius" => "", "pb_line_width" => "", "pb_min_speedx" => "", "pb_max_speedx" => "", "pb_min_speedy" => "", "pb_max_speedy" => "", "pb_directionx" => "", "pb_directiony" => "", "pb_particle_density" => "", "pb_smoke_preset" => "", "pb_bg_inner" => "", "pb_bg_outer" => "", "pb_gradient_end" => "", "pb_gradient_start" => "", "pb_num_circles" => "", "pb_radius_size" => "", "pb_smoke_opacity" => "", "pb_sm_line_width" => "", "pb_speed" => "", "pb_rain_bg" => "", "pb_rain_preset" => "", "pb_rain_img_blur" => "", "pjs_shape" => "", "pjs_img" => "", "pjs_color" => "", "pjs_stroke" => "", "pjs_scolor" => "", "pjs_sides" => "", "pjs_count" => "", "pjs_size" => "", "pjs_srandom" => "", "pjs_sanimate" => "", "pjs_sanispeed" => "", "pjs_smin" => "", "pjs_opacity" => "", "pjs_orandom" => "", "pjs_oanimate" => "", "pjs_oanispeed" => "", "pjs_omin" => "", "pjs_link" => "", "pjs_ldistance" => "", "pjs_lcolor" => "", "pjs_lopacity" => "", "pjs_lwidth" => "", "pjs_move" => "", "pjs_direction" => "", "pjs_mrandom" => "", "pjs_mstraight" => "", "pjs_mspeed" => "", "pjs_omode" => "", "pjs_hover" => "", "pjs_onhover" => "", "pjs_click" => "", "pjs_onclick" => "",  "fss_depth" => "",  "fss_segments" => "",  "fss_slices" => "",  "fss_xrange" => "",  "fss_yrange" => "",  "fss_zrange" => "",  "fss_mambient" => "",  "fss_mdiffuse" => "",  "fss_count" => "",  "fss_xyscalar" => "",  "fss_zoffset" => "",  "fss_lambient" => "",  "fss_ldiffuse" => "", "bird_type" => "", "bird_count" => "", "swarm_count" => "", "swarm_rcolor" => "", "swarm_pcolor" => "", "alian_count" => "", "aliancolor1" => "", "aliancolor2" => "", "bgaliancolor1" => "", "bgaliancolor2" => "", "wavescolor" => "", "spcolor" => "", "mpcolor" => "", "lpcolor" => "", "lcolor1" => "", "lcolor2" => "", "lcolor3" => "", "spacepcolor" => "", "spacepspeed" => "" ), $atts ) );
		
		$js_path = '/assets/js/';
		$css_path = '/assets/css/';

		$html = "";
		
		if($pb_type != '') {
			
			wp_register_style( 'pb_style', plugins_url($css_path,__FILE__).'pb_style.css' );
			wp_enqueue_style( 'pb_style' );
			
			if($pb_type == 'matrix'){
				
				wp_enqueue_script('pb-row-matrix',plugins_url($js_path,__FILE__).'jquery.particleground.min.js', array( 'jquery' ));
				
				$html .= '<div class="particle_matrix_ref" data-dotColor="'.$pb_dot_color.'" data-lineColor="'.$pb_line_color.'"  data-particleRadius="'.$pb_particle_radius.'" data-lineWidth="'.$pb_line_width.'" data-minSpeedX="'.$pb_min_speedx.'" data-maxSpeedX="'.$pb_max_speedx.'" data-minSpeedY="'.$pb_min_speedy.'" data-maxSpeedY="'.$pb_max_speedy.'" data-directionX="'.$pb_directionx.'" data-directionY="'.$pb_directiony.'" data-density="'.$pb_particle_density.'"></div>';
			
			} else if($pb_type == 'smoke') {
				
				wp_enqueue_script('pb-row-smoke',plugins_url($js_path,__FILE__).'waterpipe.js', array( 'jquery' ));
				
				if($pb_smoke_preset == 1){
					$pb_bg_inner = "#2b2b2b";
					$pb_bg_outer = "#000000";
					$pb_gradient_end = "#f5883b";
					$pb_gradient_start = "#ff5500";
					$pb_sm_line_width = 1;
					$pb_num_circles = 1;
					$pb_radius_size = 100;
					$pb_smoke_opacity = 0.05;
				} else if($pb_smoke_preset == 2){
					$pb_bg_inner = "#ffffff";
					$pb_bg_outer = "#cccccc";
					$pb_gradient_end = "#7a7a7a";
					$pb_gradient_start = "#000000";
					$pb_sm_line_width = 2;
					$pb_num_circles = 1;
					$pb_radius_size = 100;
					$pb_smoke_opacity = 0.10;
				} else if($pb_smoke_preset == 3){
					$pb_bg_inner = "#2b2b2b";
					$pb_bg_outer = "#000000";
					$pb_gradient_end = "#6b71e3";
					$pb_gradient_start = "#fa05fa";
					$pb_sm_line_width = 1.5;
					$pb_num_circles = 1;
					$pb_radius_size = 100;
					$pb_smoke_opacity = 0.05;
				}else if($pb_smoke_preset == 4){
					$pb_bg_inner = "#2b2b2b";
					$pb_bg_outer = "#000000";
					$pb_gradient_end = "#7d7d7d";
					$pb_gradient_start = "#e0e0e0";
					$pb_sm_line_width = 1.2;
					$pb_num_circles = 1;
					$pb_radius_size = 100;
					$pb_smoke_opacity = 0.05;
				}else if($pb_smoke_preset == 5){
					$pb_bg_inner = "#ffffff";
					$pb_bg_outer = "#ffffff";
					$pb_gradient_end = "#404040";
					$pb_gradient_start = "#000000";
					$pb_sm_line_width = 3;
					$pb_num_circles = 1;
					$pb_radius_size = 100;
					$pb_smoke_opacity = 0.05;
				}else if($pb_smoke_preset == 6){
					$pb_bg_inner = "#292929";
					$pb_bg_outer = "#000000";
					$pb_gradient_end = "#001eff";
					$pb_gradient_start = "#51ff00";
					$pb_sm_line_width = 1.5;
					$pb_num_circles = 1;
					$pb_radius_size = 100;
					$pb_smoke_opacity = 0.05;
				} else if($pb_smoke_preset == 7){
					$pb_bg_inner = "#400000";
					$pb_bg_outer = "#000000";
					$pb_gradient_end = "#400000";
					$pb_gradient_start = "#ff0000";
					$pb_sm_line_width = 1.5;
					$pb_num_circles = 1;
					$pb_radius_size = 100;
					$pb_smoke_opacity = 0.10;
				} else if($pb_smoke_preset == 8){
					$pb_bg_inner = "#ffffff";
					$pb_bg_outer = "#000000";
					$pb_gradient_end = "#000000";
					$pb_gradient_start = "#000000";
					$pb_sm_line_width = 2.2;
					$pb_num_circles = 1;
					$pb_radius_size = 100;
					$pb_smoke_opacity = 0.10;
				} else if($pb_smoke_preset == 9){
					$pb_bg_inner = "#ffffff";
					$pb_bg_outer = "#ffffff";
					$pb_gradient_end = "#696969";
					$pb_gradient_start = "#636363";
					$pb_sm_line_width = 1;
					$pb_num_circles = 1;
					$pb_radius_size = 100;
					$pb_smoke_opacity = 0.05;
				} else if($pb_smoke_preset == 10){
					$pb_bg_inner = "#3b003b";
					$pb_bg_outer = "#630063";
					$pb_gradient_end = "#cccc00";
					$pb_gradient_start = "#ffff00";
					$pb_sm_line_width = 1;
					$pb_num_circles = 1;
					$pb_radius_size = 100;
					$pb_smoke_opacity = 0.05;
				} else if($pb_smoke_preset == 11){
					$pb_bg_inner = "#ffffff";
					$pb_bg_outer = "#ebebeb";
					$pb_gradient_end = "#012e82";
					$pb_gradient_start = "#2600ff";
					$pb_sm_line_width = 1.5;
					$pb_num_circles = 1;
					$pb_radius_size = 100;
					$pb_smoke_opacity = 0.05;
				}
				
				$html .= '<div class="particle_smoke_ref" data-gradientEnd="'.$pb_gradient_end.'" data-gradientStart="'.$pb_gradient_start.'" data-lineWidth="'.$pb_sm_line_width.'" data-numCircles="'.$pb_num_circles.'" data-radiusSize="'.$pb_radius_size.'" data-smokeOpacity="'.$pb_smoke_opacity.'" data-bgColorInner="'.$pb_bg_inner.'" data-bgColorOuter="'.$pb_bg_outer.'" data-speed="'.$pb_speed.'"></div>';				
				
			} else if($pb_type == 'rain') {
				
				wp_enqueue_script('pb-row-rain',plugins_url($js_path,__FILE__).'rainyday.min.js', array( 'jquery' ));
				
				$img_src = wp_get_attachment_image_src($pb_rain_bg, 'full');
				
				$html .= '<div class="particle_rain_ref" data-imgblurness="'.$pb_rain_img_blur.'" data-rainbg="'.$img_src[0].'" data-preset="'.$pb_rain_preset.'"></div>';
				
			} else if($pb_type == 'pjs') {
				
				wp_enqueue_script('pb-row-pjs',plugins_url($js_path,__FILE__).'particles.min.js', array( 'jquery' ));
				
				$pid = substr(str_shuffle(str_repeat('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',5)),0,5);
				
				$p_img = wp_get_attachment_image_src($pjs_img, 'full');
				
				$html .= '<div class="particle_pjs_ref" data-id="'.$pid.'" data-shape="'.$pjs_shape.'" data-img="'.$p_img[0].'" data-pcolor="'.$pjs_color.'" data-stroke="'.$pjs_stroke.'" data-scolor="'.$pjs_scolor.'" data-sides="'.$pjs_sides.'" data-count="'.$pjs_count.'" data-size="'.$pjs_size.'" data-srandom="'.$pjs_srandom.'" data-sanimate="'.$pjs_sanimate.'" data-sanispeed="'.$pjs_sanispeed.'" data-smin="'.$pjs_smin.'" data-opacity="'.$pjs_opacity.'" data-orandom="'.$pjs_orandom.'" data-oanimate="'.$pjs_oanimate.'" data-oanispeed="'.$pjs_oanispeed.'" data-omin="'.$pjs_omin.'" data-link="'.$pjs_link.'" data-ldistance="'.$pjs_ldistance.'" data-lcolor="'.$pjs_lcolor.'" data-lopacity="'.$pjs_lopacity.'" data-lwidth="'.$pjs_lwidth.'" data-move="'.$pjs_move.'" data-direction="'.$pjs_direction.'" data-mrandom="'.$pjs_mrandom.'" data-mstraight="'.$pjs_mstraight.'" data-mspeed="'.$pjs_mspeed.'" data-omode="'.$pjs_omode.'" data-hover="'.$pjs_hover.'" data-onhover="'.$pjs_onhover.'" data-click="'.$pjs_click.'" data-onclick="'.$pjs_onclick.'"></div>';
				
			} else if($pb_type == 'fss') {
				
				wp_enqueue_script('pb-row-fss',plugins_url($js_path,__FILE__).'fss.min.js', array( 'jquery' ));

				$pid = substr(str_shuffle(str_repeat('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',5)),0,5);
				
				$html .= '<div class="flat_surf_ref" data-id="'.$pid.'" data-depth="'.$fss_depth.'" data-segments="'.$fss_segments.'" data-slices="'.$fss_slices.'" data-xrange="'.$fss_xrange.'" data-yrange="'.$fss_yrange.'" data-zrange="'.$fss_zrange.'" data-mambient="'.$fss_mambient.'" data-mdiffuse="'.$fss_mdiffuse.'" data-count="'.$fss_count.'" data-xyscalar="'.$fss_xyscalar.'" data-zoffset="'.$fss_zoffset.'" data-lambient="'.$fss_lambient.'" data-ldiffuse="'.$fss_ldiffuse.'" ></div>';
				
			} else if($pb_type == 'birds') {

				wp_enqueue_script('three-min',plugins_url($js_path,__FILE__).'three.min.js', array( 'jquery' ));
				wp_enqueue_script('three-projector',plugins_url($js_path,__FILE__).'projector.min.js', array( 'jquery' ));
				wp_enqueue_script('three-canvasrenderer',plugins_url($js_path,__FILE__).'canvasrenderer.min.js', array( 'jquery' ));
				wp_enqueue_script('three-bird',plugins_url($js_path,__FILE__).'bird.min.js', array( 'jquery' ));
				wp_enqueue_script('three-boid',plugins_url($js_path,__FILE__).'boid.min.js', array( 'jquery' ));

				$pid = substr(str_shuffle(str_repeat('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',5)),0,5);
				
				$html .= '<div class="three_bird_ref" data-birdcount="'.$bird_count.'" data-id="'.$pid.'" data-birdtype="'.$bird_type.'"></div>';
				
			} else if($pb_type == 'swarm') {

				wp_enqueue_script('smallprng',plugins_url($js_path,__FILE__).'smallprng.js', array( 'jquery' ));
				wp_enqueue_script('codepen',plugins_url($js_path,__FILE__).'codepen-utilities.min.js', array( 'jquery' ));
				wp_enqueue_script('swarm',plugins_url($js_path,__FILE__).'swarm.js', array( 'jquery' ));

				$pid = substr(str_shuffle(str_repeat('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',5)),0,5);
				
				$html .= '<div class="swarm_ref" data-swarmcount="'.$swarm_count.'" data-id="'.$pid.'" data-swarmrcolor="'.$swarm_rcolor.'" data-swarmpcolor="'.$swarm_pcolor.'"></div>';

			} else if($pb_type == 'alian') {

				$pid = substr(str_shuffle(str_repeat('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',5)),0,5);
				
				$html .= '<div class="alian_ref" data-id="'.$pid.'" data-aliancount="'.$alian_count.'" data-aliancolor1="'.$aliancolor1.'" data-aliancolor2="'.$aliancolor2.'" data-bgaliancolor1="'.$bgaliancolor1.'" data-bgaliancolor2="'.$bgaliancolor2.'"></div>';

			} else if($pb_type == 'waves') {

				wp_enqueue_script('three-min',plugins_url($js_path,__FILE__).'three.min.js', array( 'jquery' ));
				wp_enqueue_script('three-projector',plugins_url($js_path,__FILE__).'projector.min.js', array( 'jquery' ));
				wp_enqueue_script('three-canvasrenderer',plugins_url($js_path,__FILE__).'canvasrenderer.min.js', array( 'jquery' ));

				$pid = substr(str_shuffle(str_repeat('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',5)),0,5);

				if(!$wavescolor) { $wavescolor = "#ffffff"; }
				
				$html .= '<div class="three_waves_ref" data-color="'.$wavescolor.'" data-id="'.$pid.'"></div>';

			} else if($pb_type == 'ambient') {

				wp_enqueue_script('create-js',plugins_url($js_path,__FILE__).'createjs.min.js', array( 'jquery' ));
				wp_enqueue_script('tweenMax-js',plugins_url($js_path,__FILE__).'TweenMax.min.js', array( 'jquery' ));
				wp_enqueue_script('particle-engine',plugins_url($js_path,__FILE__).'particle_engine.js', array( 'jquery' ));

				$pid = substr(str_shuffle(str_repeat('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',5)),0,5);

				if(!$spcolor) $spcolor = '#0cdbf3';
				if(!$mpcolor) $mpcolor = '#6fd2f3';
				if(!$lpcolor) $lpcolor = '#93e9f3';
				if(!$lcolor1) $lcolor1 = '#6ac6e8';
				if(!$lcolor2) $lcolor2 = '#54d5e8';
				if(!$lcolor3) $lcolor3 = '#2ae8d8';
				
				$html .= '<div class="ambient_ref" data-spcolor="'.$spcolor.'" data-mpcolor="'.$mpcolor.'" data-lpcolor="'.$lpcolor.'" data-lcolor1="'.$lcolor1.'" data-lcolor2="'.$lcolor2.'" data-lcolor3="'.$lcolor3.'" data-id="'.$pid.'"></div>';

			} else if($pb_type == 'space') {

				wp_enqueue_script('three-min',plugins_url($js_path,__FILE__).'three.min.js', array( 'jquery' ));
				wp_enqueue_script('three-projector',plugins_url($js_path,__FILE__).'projector.min.js', array( 'jquery' ));
				wp_enqueue_script('three-canvasrenderer',plugins_url($js_path,__FILE__).'canvasrenderer.min.js', array( 'jquery' ));

				$pid = substr(str_shuffle(str_repeat('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz',5)),0,5);

				$html .= '<div class="space_ref" data-spacepcolor="'.$spacepcolor.'" data-spacepspeed="'.$spacepspeed.'" data-id="'.$pid.'"></div>';

			}
			
			//wp_enqueue_script('pb-row-common',plugins_url($js_path,__FILE__).'particle_common.js');

			wp_enqueue_script('pb-row-common',plugins_url($js_path,__FILE__).'particle_common.min.js');
		}
		
		$output = $html;
		
		return $output;
	}
	
	function pb_css_classes( $class_string, $tag = null ) {
		if ( $tag == 'vc_row' ) {
			$class_string .= " pb_bg";
		}
		
		return $class_string;
	}
 
    public function integrateWithVC() {
        // Check if Visual Composer is installed
        if ( ! defined( 'WPB_VC_VERSION' ) ) {
            // Display notice that Visual Compser is required
            add_action('admin_notices', array( $this, 'showVcVersionNotice' ));
            return;
        }

		$group_name = "Particle Background";
		
        if(function_exists('vc_add_param')){
				vc_add_param('vc_row',array(
						"type" => "dropdown",
						"class" => "",
						"admin_label" => true,
						"heading" => __("Background Style", "rc_pb"),
						"param_name" => "pb_type",
						"value" => array(
							__("Default","rc_pb") => "",
							__("ParticleGround Matrix Effect","rc_pb") => "matrix",
							__("WaterPipes Smoke Effect","rc_pb") => "smoke",
							__("Rainy Day Effect","rc_pb") => "rain",
							__("Particle Js","rc_pb") => "pjs",
							__("Flat Surface Shader","rc_pb") => "fss",
							__("Three Js Birds","rc_pb") => "birds",
							__("Particle Swarm Effect","rc_pb") => "swarm",
							__("ALIEN - Deviation of microcosm","rc_pb") => "alian",
							__("Three Js Particles Wave","rc_pb") => "waves",
							__("Ambient Background","rc_pb") => "ambient",
							__("Space Background","rc_pb") => "space",
							),
						"description" => __("Select the kind of background would you like to set for this row.","rc_pb"),
						"group" => $group_name,
					)
				);
				/* Matrix Effect */
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Min Speedx", "rc_pb"),
						"param_name" => "pb_min_speedx",
						"value" => 1,
						"std" => 1,
						"dependency" => array("element" => "pb_type", "value" => array("matrix")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Max Speedx", "rc_pb"),
						"param_name" => "pb_max_speedx",
						"value" => 1,
						"std" => 1,
						"dependency" => array("element" => "pb_type", "value" => array("matrix")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Min Speedy", "rc_pb"),
						"param_name" => "pb_min_speedy",
						"value" => 1,
						"std" => 1,
						"dependency" => array("element" => "pb_type", "value" => array("matrix")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Max Speedy", "rc_pb"),
						"param_name" => "pb_max_speedy",
						"value" => 1,
						"std" => 1,
						"dependency" => array("element" => "pb_type", "value" => array("matrix")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "dropdown",
						"class" => "",
						"heading" => __("Direction X", "rc_pb"),
						"param_name" => "pb_directionx",
						"value" => array(
							__("Default / Center","rc_pb") => "center",
							__("Left","rc_pb") => "left",
							__("Right","rc_pb") => "right",
							),
						"std" => 'center',
						'save_always' => true,
						"dependency" => array("element" => "pb_type", "value" => array("matrix")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "dropdown",
						"class" => "",
						"heading" => __("Direction Y", "rc_pb"),
						"param_name" => "pb_directiony",
						"value" => array(
							__("Default / Center","rc_pb") => "center",
							__("Up","rc_pb") => "up",
							__("down","rc_pb") => "down",
							),
						"std" => 'center',
						'save_always' => true,
						"dependency" => array("element" => "pb_type", "value" => array("matrix")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Density", "rc_pb"),
						"param_name" => "pb_particle_density",
						"value" => 10000,
						"std" => 10000,
						"dependency" => array("element" => "pb_type", "value" => array("matrix")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Dot Color", "rc_pb"),
						"param_name" => "pb_dot_color",
						"value" => "#000000",
						'save_always' => true,
						"dependency" => array("element" => "pb_type","value" => array("matrix")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Line Color", "rc_pb"),
						"param_name" => "pb_line_color",
						"value" => "#000000",
						'save_always' => true,
						"dependency" => array("element" => "pb_type","value" => array("matrix")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Particle Radius", "rc_pb"),
						"param_name" => "pb_particle_radius",
						"value" => 7,
						"std" => 7,
						"dependency" => array("element" => "pb_type", "value" => array("matrix")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Line Width", "rc_pb"),
						"param_name" => "pb_line_width",
						"value" => 1,
						"std" => 1,
						"dependency" => array("element" => "pb_type", "value" => array("matrix")),
						"group" => $group_name,
					)
				);
				/* Smoke Effects */
				vc_add_param('vc_row',array(
						"type" => "dropdown",
						"class" => "",
						"heading" => __("Presets", "rc_pb"),
						"param_name" => "pb_smoke_preset",
						"value" => array(
							__("Default","rc_pb") => "0",
							__("Preset1","rc_pb") => "1",
							__("Preset2","rc_pb") => "2",
							__("Preset3","rc_pb") => "3",
							__("Preset4","rc_pb") => "4",
							__("Preset5","rc_pb") => "5",
							__("Preset6","rc_pb") => "6",
							__("Preset7","rc_pb") => "7",
							__("Preset8","rc_pb") => "8",
							__("Preset9","rc_pb") => "9",
							__("Preset10","rc_pb") => "10",
							__("Preset11","rc_pb") => "11",
							__("Custom","rc_pb") => "12",
							),
						"std" => '0',
						'save_always' => true,
						"dependency" => array("element" => "pb_type", "value" => array("smoke")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Background Color Inner", "rc_pb"),
						"param_name" => "pb_bg_inner",
						"dependency" => array("element" => "pb_smoke_preset","value" => array("12")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Background Color Outer", "rc_pb"),
						"param_name" => "pb_bg_outer",
						"dependency" => array("element" => "pb_smoke_preset","value" => array("12")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Gradient Start", "rc_pb"),
						"param_name" => "pb_gradient_start",
						"dependency" => array("element" => "pb_smoke_preset","value" => array("12")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Gradient End", "rc_pb"),
						"param_name" => "pb_gradient_end",
						"dependency" => array("element" => "pb_smoke_preset","value" => array("12")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Line Width", "rc_pb"),
						"param_name" => "pb_sm_line_width",
						"value" => 1,
						"std" => 1,
						"dependency" => array("element" => "pb_smoke_preset", "value" => array("12")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Speed", "rc_pb"),
						"param_name" => "pb_speed",
						"value" => 1,
						"std" => 1,
						"dependency" => array("element" => "pb_smoke_preset", "value" => array("12")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("No of Circles", "rc_pb"),
						"param_name" => "pb_num_circles",
						"value" => 1,
						"std" => 1,
						"dependency" => array("element" => "pb_smoke_preset", "value" => array("12")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Radius Size", "rc_pb"),
						"param_name" => "pb_radius_size",
						"value" => 100,
						"std" => 100,
						"dependency" => array("element" => "pb_smoke_preset", "value" => array("12")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Smoke Opacity", "rc_pb"),
						"param_name" => "pb_smoke_opacity",
						"value" => 0.1,
						"std" => 0.1,
						"dependency" => array("element" => "pb_smoke_preset", "value" => array("12")),
						"group" => $group_name,
					)
				);
				/* Rain Effect */
				vc_add_param('vc_row',array(
						"type" => "attach_image",
						"class" => "",
						"heading" => __("Background Image", "rc_pb"),
						"param_name" => "pb_rain_bg",
						"dependency" => array("element" => "pb_type", "value" => array("rain")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "dropdown",
						"class" => "",
						"heading" => __("Presets", "rc_pb"),
						"param_name" => "pb_rain_preset",
						"value" => array(
							__("Preset1","rc_pb") => "1",
							__("Preset2","rc_pb") => "2",
							__("Preset3","rc_pb") => "3",
							__("Preset4","rc_pb") => "4",
							__("Preset5","rc_pb") => "5",
							),
						"std" => '1',
						'save_always' => true,
						"dependency" => array("element" => "pb_type", "value" => array("rain")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Image Blurness", "rc_pb"),
						"param_name" => "pb_rain_img_blur",
						"dependency" => array("element" => "pb_type","value" => array("rain")),
						"value" => 10,
						"std" => 10,
						"group" => $group_name,
					)
				);
				/* Particle Js Effect */
				vc_add_param('vc_row',array(
						"type" => "dropdown",
						"class" => "",
						"heading" => __("Particle Shape", "rc_pb"),
						"param_name" => "pjs_shape",
						"value" => array(
							__("Circle","rc_pb") => "circle",
							__("Edge","rc_pb") => "edge",
							__("Triangle","rc_pb") => "triangle",
							__("Polygon","rc_pb") => "polygon",
							__("Star","rc_pb") => "star",
							__("Image","rc_pb") => "image",
							),
						"std" => 'circle',
						'save_always' => true,
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "attach_image",
						"class" => "",
						"heading" => __("Particle Image", "rc_pb"),
						"param_name" => "pjs_img",
						"dependency" => array("element" => "pjs_shape", "value" => array("image")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Particle color", "rc_pb"),
						"param_name" => "pjs_color",
						"dependency" => array("element" => "pjs_shape","value" => array("circle", "edge", "triangle", "polygon", "star")),
						"value" => "#ffffff",
						'save_always' => true,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Particle Stroke", "rc_pb"),
						"param_name" => "pjs_stroke",
						"dependency" => array("element" => "pjs_shape","value" => array("circle", "edge", "triangle", "polygon", "star")),
						"value" => 0,
						"std" => 0,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("stroke color", "rc_pb"),
						"param_name" => "pjs_scolor",
						"dependency" => array("element" => "pjs_shape","value" => array("circle", "edge", "triangle", "polygon", "star")),
						"value" => "#ffffff",
						'save_always' => true,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Particle Polygon Sides", "rc_pb"),
						"param_name" => "pjs_sides",
						"dependency" => array("element" => "pjs_shape", "value" => array("circle", "edge", "triangle", "polygon", "star")),
						"value" => 3,
						"std" => 3,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("No of Particles", "rc_pb"),
						"param_name" => "pjs_count",
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"value" => 80,
						"std" => 80,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Particle Size", "rc_pb"),
						"param_name" => "pjs_size",
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"value" => 5,
						"std" => 5,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "checkbox",
						"class" => "",
						"heading" => __("Random Particle Size", "rc_pb"),
						"param_name" => "pjs_srandom",
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"value" => array(
							__("Yes","rc_pb") => "yes",
						),
						"std" => 'yes',
						'save_always' => true,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "checkbox",
						"class" => "",
						"heading" => __("Animate Particle Size", "rc_pb"),
						"param_name" => "pjs_sanimate",
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"value" => array(
							__("Yes","rc_pb") => "yes",
						),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Size Animation Speed", "rc_pb"),
						"param_name" => "pjs_sanispeed",
						"dependency" => array("element" => "pjs_sanimate", "value" => array("yes")),
						"value" => 40,
						"std" => 40,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Min. Size", "rc_pb"),
						"param_name" => "pjs_smin",
						"dependency" => array("element" => "pjs_sanimate", "value" => array("yes")),
						"value" => 0.1,
						"std" => 0.1,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Opacity", "rc_pb"),
						"param_name" => "pjs_opacity",
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"value" => "0.5",
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "checkbox",
						"class" => "",
						"heading" => __("Random Opacity", "rc_pb"),
						"param_name" => "pjs_orandom",
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"value" => array(
							__("Yes","rc_pb") => "yes",
						),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "checkbox",
						"class" => "",
						"heading" => __("Animate Particle Opacity", "rc_pb"),
						"param_name" => "pjs_oanimate",
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"value" => array(
							__("Yes","rc_pb") => "yes",
						),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Opacity Animation Speed", "rc_pb"),
						"param_name" => "pjs_oanispeed",
						"dependency" => array("element" => "pjs_oanimate", "value" => array("yes")),
						"value" => 1,
						"std" => 1,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Min. Opacity", "rc_pb"),
						"param_name" => "pjs_omin",
						"dependency" => array("element" => "pjs_oanimate", "value" => array("yes")),
						"value" => 0.1,
						"std" => 0.1,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "checkbox",
						"class" => "",
						"heading" => __("Want Particle Linked ?", "rc_pb"),
						"param_name" => "pjs_link",
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"value" => array(
							__("Yes","rc_pb") => "yes",
						),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Distance for link", "rc_pb"),
						"param_name" => "pjs_ldistance",
						"dependency" => array("element" => "pjs_link", "value" => array("yes")),
						"value" => 150,
						"std" => 150,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Line Color", "rc_pb"),
						"param_name" => "pjs_lcolor",
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"value" => "#ffffff",
						'save_always' => true,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Line Opacity", "rc_pb"),
						"param_name" => "pjs_lopacity",
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"value" => 0.4,
						"std" => 0.4,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Line Width", "rc_pb"),
						"param_name" => "pjs_lwidth",
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"value" => 1,
						"std" => 1,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "checkbox",
						"class" => "",
						"heading" => __("Want Particle Move?", "rc_pb"),
						"param_name" => "pjs_move",
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"value" => array(
							__("Yes","rc_pb") => "yes",
						),
						"std" => 'yes',
						'save_always' => true,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "dropdown",
						"class" => "",
						"heading" => __("Particle Movement Direction", "rc_pb"),
						"param_name" => "pjs_direction",
						"value" => array(
							__("None","rc_pb") => "none",
							__("Top","rc_pb") => "top",
							__("Top Right","rc_pb") => "top-right",
							__("Right","rc_pb") => "right",
							__("Bottom Right","rc_pb") => "bottom-right",
							__("Bottom","rc_pb") => "bottom",
							__("Bottom Left","rc_pb") => "bottom-left",
							__("Left","rc_pb") => "left",
							__("Top Left","rc_pb") => "top-left",
							),
						"std" => 'none',
						'save_always' => true,
						"dependency" => array("element" => "pjs_move", "value" => array("yes")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "checkbox",
						"class" => "",
						"heading" => __("Random Movement?", "rc_pb"),
						"param_name" => "pjs_mrandom",
						"dependency" => array("element" => "pjs_move", "value" => array("yes")),
						"value" => array(
							__("Yes","rc_pb") => "yes",
						),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "checkbox",
						"class" => "",
						"heading" => __("Move Straight?", "rc_pb"),
						"param_name" => "pjs_mstraight",
						"dependency" => array("element" => "pjs_move", "value" => array("yes")),
						"value" => array(
							__("Yes","rc_pb") => "yes",
						),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Particle Movement Speed", "rc_pb"),
						"param_name" => "pjs_mspeed",
						"dependency" => array("element" => "pjs_move", "value" => array("yes")),
						"value" => 6,
						"std" => 6,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "dropdown",
						"class" => "",
						"heading" => __("Particle Out Mode", "rc_pb"),
						"param_name" => "pjs_omode",
						"value" => array(
							__("Out","rc_pb") => "out",
							__("Bounce","rc_pb") => "bounce",
							),
						"std" => 'out',
						'save_always' => true,
						"dependency" => array("element" => "pjs_move", "value" => array("yes")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "checkbox",
						"class" => "",
						"heading" => __("Active Hover Effect on Particles?", "rc_pb"),
						"param_name" => "pjs_hover",
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"value" => array(
							__("Yes","rc_pb") => "yes",
						),
						"std" => 'yes',
						'save_always' => true,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "dropdown",
						"class" => "",
						"heading" => __("Hover Effect", "rc_pb"),
						"param_name" => "pjs_onhover",
						"value" => array(
							__("Grab","rc_pb") => "grab",
							__("Bubble","rc_pb") => "bubble",
							__("Repulse","rc_pb") => "repulse",
							),
						"std" => 'grab',
						'save_always' => true,
						"dependency" => array("element" => "pjs_hover", "value" => array("yes")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "checkbox",
						"class" => "",
						"heading" => __("Active Click Effect on Particles?", "rc_pb"),
						"param_name" => "pjs_click",
						"dependency" => array("element" => "pb_type", "value" => array("pjs")),
						"value" => array(
							__("Yes","rc_pb") => "yes",
						),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "dropdown",
						"class" => "",
						"heading" => __("Click Effect", "rc_pb"),
						"param_name" => "pjs_onclick",
						"value" => array(
							__("Push","rc_pb") => "push",
							__("Remove","rc_pb") => "remove",
							__("Bubble","rc_pb") => "bubble",
							__("Repulse","rc_pb") => "repulse",
							),
						"std" => 'push',
						'save_always' => true,
						"dependency" => array("element" => "pjs_click", "value" => array("yes")),
						"group" => $group_name,
					)
				);
				/* Flat Surfase Shader Effect */
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Depth", "rc_pb"),
						"param_name" => "fss_depth",
						"value" => 10,
						"std" => 10,
						"dependency" => array("element" => "pb_type", "value" => array("fss")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Segments", "rc_pb"),
						"param_name" => "fss_segments",
						"value" => 12,
						"std" => 12,
						"dependency" => array("element" => "pb_type", "value" => array("fss")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Slices", "rc_pb"),
						"param_name" => "fss_slices",
						"value" => 4,
						"std" => 4,
						"dependency" => array("element" => "pb_type", "value" => array("fss")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("X-Range", "rc_pb"),
						"param_name" => "fss_xrange",
						"value" => 0.6,
						"std" => 0.6,
						"dependency" => array("element" => "pb_type", "value" => array("fss")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Y-Range", "rc_pb"),
						"param_name" => "fss_yrange",
						"value" => 0.1,
						"std" => 0.1,
						"dependency" => array("element" => "pb_type", "value" => array("fss")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Z-Range", "rc_pb"),
						"param_name" => "fss_zrange",
						"value" => 1,
						"std" => 1,
						"dependency" => array("element" => "pb_type", "value" => array("fss")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Plane Ambient Color", "rc_pb"),
						"param_name" => "fss_mambient",
						"dependency" => array("element" => "pb_type", "value" => array("fss")),
						"value" => "#555555",
						'save_always' => true,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Plane Diffuse Color", "rc_pb"),
						"param_name" => "fss_mdiffuse",
						"dependency" => array("element" => "pb_type", "value" => array("fss")),
						"value" => "#ffffff",
						'save_always' => true,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Light Count", "rc_pb"),
						"param_name" => "fss_count",
						"value" => 2,
						"std" => 2,
						"dependency" => array("element" => "pb_type", "value" => array("fss")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("XY Scalar", "rc_pb"),
						"param_name" => "fss_xyscalar",
						"value" => 1,
						"std" => 1,
						"dependency" => array("element" => "pb_type", "value" => array("fss")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Z offset", "rc_pb"),
						"param_name" => "fss_zoffset",
						"value" => 100,
						"std" => 100,
						"dependency" => array("element" => "pb_type", "value" => array("fss")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Light Ambient Color", "rc_pb"),
						"param_name" => "fss_lambient",
						"dependency" => array("element" => "pb_type", "value" => array("fss")),
						"value" => "#880066",
						'save_always' => true,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Light Diffuse Color", "rc_pb"),
						"param_name" => "fss_ldiffuse",
						"dependency" => array("element" => "pb_type", "value" => array("fss")),
						"value" => "#FF8800",
						'save_always' => true,
						"group" => $group_name,
					)
				);
				/* Three Js Birds Effect */
				vc_add_param('vc_row',array(
						"type" => "dropdown",
						"class" => "",
						"heading" => __("Bird Type", "rc_pb"),
						"param_name" => "bird_type",
						"value" => array(
							__("Black / White","rc_pb") => "bw",
							__("colourful","rc_pb") => "color",
							),
						"std" => 'bw',
						'save_always' => true,
						"dependency" => array("element" => "pb_type", "value" => array("birds")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Bird Count", "rc_pb"),
						"param_name" => "bird_count",
						"value" => 200,
						"std" => 200,
						"dependency" => array("element" => "pb_type", "value" => array("birds")),
						"group" => $group_name,
					)
				);
				/* Particle Swarm Effect */
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Particle Count", "rc_pb"),
						"param_name" => "swarm_count",
						"value" => 5000,
						"std" => 5000,
						"dependency" => array("element" => "pb_type", "value" => array("swarm")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "checkbox",
						"class" => "",
						"heading" => __("Rotate Color?", "rc_pb"),
						"param_name" => "swarm_rcolor",
						"dependency" => array("element" => "pb_type", "value" => array("swarm")),
						"value" => array(
							__("Yes","rc_pb") => "yes",
						),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Particle Color", "rc_pb"),
						"param_name" => "swarm_pcolor",
						"dependency" => array("element" => "pb_type", "value" => array("swarm")),
						"value" => "#FF8800",
						'save_always' => true,
						"group" => $group_name,
					)
				);
				/* Alian Effect */
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Particle Count", "rc_pb"),
						"param_name" => "alian_count",
						"value" => 1000,
						"std" => 1000,
						"dependency" => array("element" => "pb_type", "value" => array("alian")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Color 1", "rc_pb"),
						"param_name" => "aliancolor1",
						"dependency" => array("element" => "pb_type", "value" => array("alian")),
						"value" => "#FF8800",
						'save_always' => true,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Color 2", "rc_pb"),
						"param_name" => "aliancolor2",
						"dependency" => array("element" => "pb_type", "value" => array("alian")),
						"value" => "#b5ff00",
						'save_always' => true,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Background Color 1", "rc_pb"),
						"param_name" => "bgaliancolor1",
						"dependency" => array("element" => "pb_type", "value" => array("alian")),
						"value" => "#000155",
						'save_always' => true,
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Background Color 2", "rc_pb"),
						"param_name" => "bgaliancolor2",
						"dependency" => array("element" => "pb_type", "value" => array("alian")),
						"value" => "#000021",
						'save_always' => true,
						"group" => $group_name,
					)
				);
				//Wave Effect
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Particle Color", "rc_pb"),
						"param_name" => "wavescolor",
						"value" => "#ffffff",
						'save_always' => true,
						"dependency" => array("element" => "pb_type","value" => array("waves")),
						"group" => $group_name,
					)
				);
				//Ambient Effect
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Small Particle Color", "rc_pb"),
						"param_name" => "spcolor",
						"value" => "#0cdbf3",
						'save_always' => true,
						"dependency" => array("element" => "pb_type","value" => array("ambient")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Medium Particle Color", "rc_pb"),
						"param_name" => "mpcolor",
						"value" => "#6fd2f3",
						'save_always' => true,
						"dependency" => array("element" => "pb_type","value" => array("ambient")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Large Particle Color", "rc_pb"),
						"param_name" => "lpcolor",
						"value" => "#93e9f3",
						'save_always' => true,
						"dependency" => array("element" => "pb_type","value" => array("ambient")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Light Color1", "rc_pb"),
						"param_name" => "lcolor1",
						"value" => "#6ac6e8",
						'save_always' => true,
						"dependency" => array("element" => "pb_type","value" => array("ambient")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Light Color2", "rc_pb"),
						"param_name" => "lcolor2",
						"value" => "#54d5e8",
						'save_always' => true,
						"dependency" => array("element" => "pb_type","value" => array("ambient")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Light Color3", "rc_pb"),
						"param_name" => "lcolor3",
						"value" => "#2ae8d8",
						'save_always' => true,
						"dependency" => array("element" => "pb_type","value" => array("ambient")),
						"group" => $group_name,
					)
				);
				//Space Effect
				vc_add_param('vc_row',array(
						"type" => "colorpicker",
						"class" => "",
						"heading" => __("Space Particle Color", "rc_pb"),
						"param_name" => "spacepcolor",
						"value" => "#F7E4BE",
						'save_always' => true,
						"dependency" => array("element" => "pb_type","value" => array("space")),
						"group" => $group_name,
					)
				);
				vc_add_param('vc_row',array(
						"type" => "textfield",
						"class" => "",
						"heading" => __("Space Particle Speed", "rc_pb"),
						"param_name" => "spacepspeed",
						"value" => 5,
						"std" => 5,
						"dependency" => array("element" => "pb_type", "value" => array("space")),
						"group" => $group_name,
					)
				);

		}
    }

    /*
    Show notice if your plugin is activated but Visual Composer is not
    */
    public function showVcVersionNotice() {
        $plugin_data = get_plugin_data(__FILE__);
        echo '
        <div class="updated">
          <p>'.sprintf(__('<strong>%s</strong> requires <strong><a href="http://bit.ly/vcomposer" target="_blank">Visual Composer</a></strong> plugin to be installed and activated on your site.', 'vc_extend'), $plugin_data['Name']).'</p>
        </div>';
    }
}
// Finally initialize code
new VCExtendAddonClass();